/*
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PROFILER.C

AUTHOR: Craig Muller P. Eng. 1991,1992,1993
        cmuller@ccu.umanitoba.ca
        Computer Vision Laboratory
        Mech. Engn.,Univ. of Manitoba
        Winnipeg, Manitoba. R3T 2N2

DESCRIPTION:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/
#include <windows.h>

#pragma hdrstop

#include <stdio.h>
#include <string.h>

#include "iwf.h"

// Defines.
#define  MODULENAME "PROFILER"

// Exported Procedures.
BOOL FAR PASCAL _export DP_Profiler(HWND hWnd,WORD wMsg,WORD wParam,LONG lParam);
BOOL FAR PASCAL _export DP_ProfilerAbout(HWND hDlg,WORD wMsg,WORD wParam,LONG lParam);

// Public procedures.
static void Profile(HWND hWnd,POINT *pt0,POINT *pt1);
static void Message(char *sz,int font);

// Private variables.
HWND  hDlgProfiler=NULL;
static HWND  hWndStatBar;

// Flags for display options
static BOOL fCapture  = FALSE;
static BOOL fRefresh  = TRUE;
static BOOL fBright   = TRUE;
static BOOL fGradient = TRUE ;

static BYTE	 dn[1024];
static int	 gs[1024];

// Drawing colors
static COLORREF crBright = RGB(0xff,0xff,0x00);
static COLORREF crGrad   = RGB(0x00,0xff,0x00);
static COLORREF crScan   = RGB(0xff,0x00,0x00);

// Drawing cccdinates
static POINT pt0;
static POINT pt1;

// Application instance handle.
static HINSTANCE hInstance;

/*
--------------------------------------------------------------------------
Profiler()
~~~~~~~~

PROFILER STARTUP PROCESSING PROCEDURE.
This is called when the user selects this option from the main menu.
This procedure check to see if the popup window exists. If so it simply
passes focus to the window and returns since there is nothing more to do.
If it does not exist then it proceeds to create the popup window and menu
and displays it on the screen. The popup window acts like a sub-program
within the main program and receives messages from the main program.
--------------------------------------------------------------------------
*/
void Profiler(HWND hWndParent)
   {
	FARPROC lpProc;
   RECT rc0,rc1;
   int w,h;

   if (IsWindow(hDlgProfiler))
      {
      SetFocus(hDlgProfiler);
      }
   else
      {
		hInstance = GetWindowWord(hWndParent,GWW_HINSTANCE);
      lpProc = MakeProcInstance(DP_Profiler,hInstance);
      hDlgProfiler = CreateDialog(hInstance,"PROFILER",hWndParent,lpProc);
      GetWindowRect(hWndParent,&rc0);
      GetWindowRect(hDlgProfiler,&rc1);
      w = rc1.right - rc1.left;
      h = rc1.bottom - rc1.top;
      MoveWindow(hDlgProfiler,rc0.right-10-w,rc0.top+45,w,h,TRUE);
      ShowWindow(hDlgProfiler,SW_SHOW);
      }
   }



 /*
===============================================================================
BOOL FAR PASCAL _export DP_Profiler(HWND hWnd,WORD wMsg,WORD wParam,LONG lParam)

Decription:
This window procedure handles all the messaging for the Profiler Image Viewing
module. Special code is called which produces a red and blue composite
image from both left and right grey scale image. The user the puts on red
and blue 3D glasses to view the image in 3D.
===============================================================================
*/
BOOL FAR PASCAL _export DP_Profiler(HWND hWnd,WORD wMsg,WORD wParam,LONG lParam)
   {

	switch (wMsg)
		{
		case WM_INITDIALOG:                        // WINDOW CREATION.
		// Initialize check boxes.
      CheckDlgButton(hWnd,51,fRefresh);
		CheckDlgButton(hWnd,52,fBright );
		CheckDlgButton(hWnd,53,fGradient);
		hWndStatBar = CreateStatBar(hWnd);         // Add a status line
      PostMessage(hWnd,WM_USER,0,0);             // Ready to show the window
		break;

      case WM_USER:
      ShowWindow(hWnd,SW_SHOW);                  // Show the window
		hWndMod = hWnd;                            // Make this module active.
      break;

		case WM_CTLCOLOR:
		switch(HIWORD(lParam))
         {
         case CTLCOLOR_STATIC:
         SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
         return (LRESULT) GetStockObject(LTGRAY_BRUSH);
         }
      return (LRESULT) NULL;

      case WM_PAINT:                             // IMAGE NEEDS PAINTING.
      {
      RECT rc;
      PAINTSTRUCT ps;

      BeginPaint(hWnd,&ps);

      if (IsIconic(hWnd))
			{
			DrawIcon(ps.hdc,0,0,LoadIcon(hInstance,"PROFILER"));
         }
      else
         {
         GetClientRect(hWnd,&rc);
         FillRect(ps.hdc,&rc,GetStockObject(LTGRAY_BRUSH));
         }

		EndPaint(hWnd,&ps);                        // Painting complete.
		}
		break;

		case WM_LBUTTONUP:                         // LEFT BUTTON UP.
		if (IsWindow((HWND)wParam))
			{
			if (!fCapture)
				{
				char sz[40];

				SetCapture((HWND)wParam);
				fCapture = TRUE;
				pt0 = MAKEPOINT(lParam);
				pt1 = MAKEPOINT(lParam);
				sprintf(sz,"Coordinates: x:%d  y:%d",pt0.x,pt0.y);
				Message(sz,0);
				if (fRefresh)
					{
					RefreshImage((HWND)wParam);
					UpdateWindow((HWND)wParam);
					}
				}
			else
				{
				int cx,cy;
				char sz[40];
				HDC hDC;
				IMAGE *image;
				RECT rc;

				hDC = GetDC((HWND)wParam);
				image = GetImage(hWndSrc);           // Get attached data set.

				// Map image coords into window area
				GetClientRect((HWND)wParam,&rc);
				SetMapMode(hDC,MM_ISOTROPIC);
				SetWindowExt(hDC,image->hres,image->vres);
				SetViewportExt(hDC,rc.right,rc.bottom);

				SetROP2(hDC,R2_NOT);
				pt1 = MAKEPOINT(lParam);
				cx = pt1.x - pt0.x;
				cy = pt1.y - pt0.y;
				if (cx>=cy) pt1.y = pt0.y;
				if (cx< cy) pt1.x = pt0.x;
				MoveTo(hDC,pt0.x,pt0.y);
				LineTo(hDC,pt1.x,pt1.y);
				ReleaseDC((HWND)wParam,hDC);

				sprintf(sz,"Coordinates: x:%d  y:%d",pt1.x,pt1.y);
				Message(sz,0);
				ReleaseCapture();
				fCapture = FALSE;
				Profile((HWND)wParam,&pt0,&pt1);
				}
			}
		else
			{
			hWndMod = hWnd;                        // Make this module active.
			}
		break;

		case WM_MOUSEMOVE:
		if (IsWindow((HWND)wParam))
			{
			if (fCapture)
				{
				int cx,cy;
				HDC hDC;
				IMAGE *image;
				RECT rc;

				hDC = GetDC((HWND)wParam);
				image = GetImage(hWndSrc);           // Get attached data set.

				// Map image coords into window area
				GetClientRect((HWND)wParam,&rc);
				SetMapMode(hDC,MM_ISOTROPIC);
				SetWindowExt(hDC,image->hres,image->vres);
				SetViewportExt(hDC,rc.right,rc.bottom);

				// Erase the previous indicator line and draw a new one
				SetROP2(hDC,R2_NOT);
				MoveTo(hDC,pt0.x,pt0.y);
				LineTo(hDC,pt1.x,pt1.y);
				pt1 = MAKEPOINT(lParam);
				cx = pt1.x - pt0.x;
				cy = pt1.y - pt0.y;
				if (cx>=cy) pt1.y = pt0.y;
				if (cx< cy) pt1.x = pt0.x;
				MoveTo(hDC,pt0.x,pt0.y);
				LineTo(hDC,pt1.x,pt1.y);

				ReleaseDC((HWND)wParam,hDC);
				}
			}
		break;

		case WM_CHAR:
		case WM_COMMAND:                           // MENU COMMAND SELECTED.
		switch (wParam)
			{
			case 51:
			fRefresh = (IsDlgButtonChecked(hWnd,wParam)) ? 1 : 0;
			break;

			case 52:
			fBright  = (IsDlgButtonChecked(hWnd,wParam)) ? 1 : 0;
			break;

			case 53:
			fGradient = (IsDlgButtonChecked(hWnd,wParam)) ? 1 : 0;
			break;

			case 111:
			PickColor(hWnd,&crBright);
			break;

			case 112:
			PickColor(hWnd,&crGrad);
			break;

			case 113:
			PickColor(hWnd,&crScan);
			break;

         case 999:
         CallDialogBox(hWnd,DP_ProfilerAbout,"PROFILER_ABOUT");
         break;
			}
      break;

      case WM_SETFOCUS:                          // FOCUS HAS BEEN SET.
      hWndMod = hWnd;                            // Make this module active.
      break;

      case WM_KILLFOCUS:                         // FOCUS HAS BEEN KILLED.
      break;

      case WM_CLOSE:
      DestroyWindow(hWnd);
      break;

      case WM_DESTROY:
		hDlgProfiler = NULL;
      break;
      }

   lParam=lParam;

	return(NULL);
	}


/*
==========================================================================
DP_ProfilerAbout()
~~~~~~~~~~~~~~~~~~

Description:
This box appears to inform the user about the origins of the software.
Wait for user to click on "Ok" button, then close the dialog box.
==========================================================================
*/
BOOL FAR PASCAL _export DP_ProfilerAbout(HWND hDlg,WORD wMsg,WORD wParam,LONG lParam)
	{
   switch (wMsg)
		{
      case WM_INITDIALOG: return (TRUE);
		case WM_COMMAND:    EndDialog(hDlg,TRUE); return (TRUE);
		}

   // Supress compiler messages
	lParam=lParam;
	wParam=wParam;
	return (FALSE);
	}




/*
---------------------------------------------------------------------
Profile()
~~~~~~~~~
Description:
This procedure draws an image brightness profile on the screen.
---------------------------------------------------------------------
*/
static void Profile(HWND hWnd,POINT *pt0,POINT *pt1)
	{
	int    i,cx,cy;
	RECT   rc;
	HDC    hDC;
	HPEN   hPenBright,hPenScan,hPenGrad;
	IMAGE  *image;

	image = (IMAGE *)GetWindowWord(hWnd,GWW_IMAGE);// Get attached data set.
	hDC = GetDC(hWnd);                             // Get the image window DC

	// Map image to window area
	GetClientRect(hWnd,&rc);                       // Get Client image rect
	SetMapMode(hDC,MM_ISOTROPIC);                  // Set map mode to scale
	SetWindowExt(hDC,image->hres,image->vres);     // Set logical extents
	SetViewportExt(hDC,rc.right,rc.bottom);        // Set physical extents

	hPenBright = CreatePen(PS_SOLID,1,crBright);
	hPenGrad   = CreatePen(PS_SOLID,1,crGrad);
	hPenScan   = CreatePen(PS_SOLID,1,crScan);

	cx = pt1->x - pt0->x;
	cy = pt1->y - pt0->y;

	if (cx>0)
		{
		GetImageRow(image,pt0->x,pt0->y,dn,cx);

		for (i=0; i<cx; i++)
			gs[i] = (int)(image->LUT[dn[i]].peRed+
						  image->LUT[dn[i]].peGreen+
						  image->LUT[dn[i]].peBlue)/3;

		SelectObject(hDC,hPenScan);
		MoveTo(hDC,pt0->x,pt0->y);
		LineTo(hDC,pt1->x,pt1->y);

		if (fBright)
			{
			SelectObject(hDC,hPenBright);                      /* select yellow pen */
         if (pt0->y > image->vres/2)
            {
   			MoveTo(hDC,pt0->x,pt0->y-gs[0]/2);
            for (i=0; i<cx-1; i++)
				   LineTo(hDC,pt0->x+i,pt0->y-gs[i]/2);
            }
         else
            {
   			MoveTo(hDC,pt0->x,pt0->y+128-gs[0]/2);
            for (i=0; i<cx-1; i++)
				   LineTo(hDC,pt0->x+i,pt0->y+128-gs[i]/2);
            }
			}

		if (fGradient)
			{
			SelectObject(hDC,hPenGrad);
			MoveTo(hDC,pt0->x,pt0->y-(gs[1]-gs[0]));
			for (i=0; i<cx-1; i++)
				LineTo(hDC,pt0->x+i,pt0->y-(gs[i+1]-gs[i]));
			}
		}

	if (cy>0)
		{
		GetImageCol(image,pt0->x,pt0->y,dn,cy);

		for (i=0; i<cy; i++)
			gs[i] = (int)(image->LUT[dn[i]].peRed+
						  image->LUT[dn[i]].peGreen+
						  image->LUT[dn[i]].peBlue)/3;

		SelectObject(hDC,hPenScan);
		MoveTo(hDC,pt0->x,pt0->y);
		LineTo(hDC,pt1->x,pt1->y);

		if (fBright)
			{
			SelectObject(hDC,hPenBright);
         if (pt0->x < image->hres/2)
            {
		   	MoveTo(hDC,pt0->x+gs[0]/2,pt0->y);
			   for (i=0; i<cy-1; i++)
				   LineTo(hDC,pt0->x+gs[i]/2,pt0->y+i);
            }
         else
            {
		   	MoveTo(hDC,pt0->x-128+gs[0]/2,pt0->y);
			   for (i=0; i<cy-1; i++)
				   LineTo(hDC,pt0->x-128+gs[i]/2,pt0->y+i);
            }
			}

		if (fGradient)
			{
			SelectObject(hDC,hPenGrad);
			MoveTo(hDC,pt0->x+(gs[1]-gs[0]),pt0->y);
			for (i=0; i<cy-1; i++)
				LineTo(hDC,pt0->x+(gs[i+1]-gs[i]),pt0->y+i);
			}
		}

	SelectObject(hDC,GetStockObject(BLACK_PEN));

	DeleteObject(hPenBright);
	DeleteObject(hPenGrad);
	DeleteObject(hPenScan);

	ReleaseDC(hWnd,hDC);
	}


/*
--------------------------------------------------------------------------

--------------------------------------------------------------------------
*/
static void Message(char *sz,int font)
	{
	SendMessage(hWndStatBar,WM_USER,(WPARAM)sz,font);
	}

