/*
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
MODULE: SAMP_WIN.C (SAMP_WIN Image viewer)

AUTHOR: Craig Muller P. Eng. 1991,1992,1993
        cmuller@ccu.umanitoba.ca
        Computer Vision Laboratory
        Mech. Engn.,Univ. of Manitoba
        Winnipeg, Manitoba. CANADA. R3T 2N2


DESCRIPTION:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/
#include <windows.h>

#pragma hdrstop

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "iwf.h"

// Defines.
#define  MODULENAME "SAMPWIN"
#define  CLASSNAME  MODULENAME"User"

// Exported Procedures.
long far PASCAL _export WP_SampWin(HWND hWnd,WORD wMsg,WORD wParam,LONG lParam);

// Public variables
HWND hWndSampWin;

// Private variables
static HINSTANCE hInst;              // Application instance handle.

/*
--------------------------------------------------------------------------
SampWin()
~~~~~~~~

SAMP_WIN STARTUP PROCESSING PROCEDURE.
This is called when the user selects this option from the main menu.
This procedure check to see if the popup window exists. If so it simply
passes focus to the window and returns since there is nothing more to do.
If it does not exist then it proceeds to create the popup window and menu
and displays it on the screen. The popup window acts like a sub-program
within the main program and receives messages from the main program.
--------------------------------------------------------------------------
*/
void SampWin(HWND hWndParent)
   {
   char   msg[80];
   WNDCLASS  wc;
   HANDLE  hInst;

   // If an instance exists then set focus to that instance and return.
   if (IsWindow(hWndSampWin))
      {
      SetFocus(hWndSampWin);
      return;
      }

   hInst = GetWindowWord(hWndParent,GWW_HINSTANCE);

   // Register a new window class for the popup window.
   if (!GetClassInfo(hInst,CLASSNAME,&wc))
      {
      memset(&wc,0,sizeof(WNDCLASS));            // Zero init structure.

      wc.lpszClassName = CLASSNAME;              // Name for CreateWindow.
      wc.style         = CS_SAVEBITS;            // Extra style parameters.
      wc.lpfnWndProc   = (WNDPROC)WP_SampWin;     // Func to get msgs
      wc.hInstance     = hInst;                  // App that owns the class
      wc.hCursor       = LoadCursor(hInst,"CROSSHAIR");
      wc.lpszMenuName  = MODULENAME;
      wc.hbrBackground = GetStockObject(LTGRAY_BRUSH);

      if (!RegisterClass(&wc))                   // Initialize new window class.
         {
         char sz[80];

         sprintf(sz,"RegisterClass() failure! -> %s",CLASSNAME);
         MessageBeep(MB_ICONEXCLAMATION);
         MessageBox(NULL,sz,NULL,MB_OK | MB_ICONEXCLAMATION);
         return;                                 // Exit on failure
         }
      }

   // Window class is registered, now create an window from the class.
   hWndSampWin = CreateWindow(CLASSNAME,MODULENAME,
                             WS_POPUPWINDOW | WS_CAPTION | WS_MINIMIZEBOX | WS_VISIBLE,
                            500,100,400,200,hWndParent,NULL,hInst,NULL);
   if (!hWndSampWin)
      {
      sprintf(msg,"CreateWindow() failure! -> %s",CLASSNAME);
      MessageBeep(MB_ICONEXCLAMATION);
		MessageBox(NULL,msg,NULL,MB_OK | MB_ICONEXCLAMATION);
      return;
      }

   SetFocus(hWndSampWin);
   }



/*
===============================================================================
long far PASCAL _export WP_SampWin(HWND hWnd,WORD wMsg,WORD wParam,LONG lParam)

Decription:
This window procedure handles all the messaging for the SampWin Image Viewing
module. Special code is called which produces a red and blue composite
image from both left and right grey scale image. The user the puts on red
and blue 3D glasses to view the image in 3D.
===============================================================================
*/
long far PASCAL _export WP_SampWin(HWND hWnd,WORD wMsg,WORD wParam,LONG lParam)
   {
   switch (wMsg)
      {
      case WM_CREATE:                            // WINDOW CREATION.
      break;

      case WM_PAINT:                             // IMAGE NEEDS PAINTING.
      {
      RECT rc;
      PAINTSTRUCT ps;
      HICON hIcon;

      BeginPaint(hWnd,&ps);
      if (IsIconic(hWnd))
         {
         hIcon = LoadIcon(hInst,MODULENAME);
         DrawIcon(ps.hdc,2,3,hIcon);
         DestroyIcon(hIcon);
         }
      else
         {
			GetClientRect(hWnd,&rc);
			FillRect(ps.hdc,&rc,GetStockObject(LTGRAY_BRUSH));
			}
      EndPaint(hWnd,&ps);                        // Painting complete.
      }
      break;
      
      case WM_LBUTTONUP:                         // LEFT BUTTON UP.
      case WM_RBUTTONUP:                         // RIGHT BUTTON UP.
		{
		HDC hDC;
		char sz[80];
		int scale;
		RECT rc;
		IMAGE *image;

		hDC = GetDC(hWnd);
		GetClientRect(hWnd,&rc);
		rc.bottom = 100;
		FillRect(hDC,&rc,GetStockObject(LTGRAY_BRUSH));
		SetBkColor(hDC,GetSysColor(COLOR_BTNFACE));
		if (IsWindow((HWND)wParam))
			{
			image = GetImage((HWND)wParam);
			scale = GetScale((HWND)wParam);
			sprintf(sz,"Message from image window");
			TextOut(hDC,10,10,sz,strlen(sz));
			sprintf(sz,"File: %s",image->fspec);
			TextOut(hDC,10,25,sz,strlen(sz));
			sprintf(sz,"Scale: %d  Width: %d  Height: %d",scale,image->hres,image->vres);
			TextOut(hDC,10,40,sz,strlen(sz));
			}
		else
			{
			sprintf(sz,"Message from user window");
			TextOut(hDC,10,10,sz,strlen(sz));
			hWndMod = hWnd;                        // Make this module active.
			}
		ReleaseDC(hWnd,hDC);
		}
		break;

		case WM_CHAR:
		case WM_COMMAND:                           // MENU COMMAND SELECTED.
		break;

		case WM_SETFOCUS:                          // FOCUS HAS BEEN SET.
      if (FlashWindow(hWnd,TRUE))
         FlashWindow(hWnd,TRUE);                 // Make this module active.
      hWndMod = hWnd;                            // Make this module active.
      BringWindowToTop(hWnd);                    // Bring this module to top.
      InvalidateRect(hWnd,NULL,FALSE);           // Invalidate this image.
      UpdateWindow(hWnd);                        // Update this image.
      break;

      case WM_DESTROY:                           // DESTROY WINDOW.
      break;

      default:                                   // Pass on if unprocessed.
      return(DefWindowProc(hWnd, wMsg, wParam, lParam));
      }

   lParam=lParam;

   return(NULL);
   }

