;----- Boolean.Asm - Returns True for anything other than CHR$(0) or NUL string

;Copyright (c) 1992 Gary Meeker


;Syntax - Boolean%(Char$)
;
;  where Char$ is the String to test

.Model Medium
.Code
Include Mixed.Inc

HProc Boolean, CharStr:Ptr
    Xor  AX,AX            ;Assume it's a NUL string or CHR$(0), load FALSE
    Mov  SI,CharStr       ;get the descriptor address for Char$
    Mov  CX,[SI]          ;get LEN(Char$)
    Mov  SI,[SI+02]       ;now SI points to the start of the string
    Jcxz Exit             ;It's a NUL String
    Cmp  AL,[SI]          ;Test for CHR$(0)
    Jz   Exit             ;Yes, it is
    Dec  AX               ;No,  its TRUE, make it -1
Exit:
    HRet

HEndp
End
