'+--------------------------[ PCBFiles Ver 2.00 ]----------------------------+
'|  Written By Gary Meeker 09/01/90                        Updated 07/12/93  |
'|  SYSOP: SHARP Technical Support Line BBS               Lawrenceville, GA  |
'|         (404) 962-1788                          300-14400 Baud. 24 Hours  |
'+---------------------------------------------------------------------------+
'1.00 : 09/01/90 Initial Coding
'2.00 : 07/12/93 Updated for PCBoard 15.x

DEFINT A-Z

' PDQ Declarations
DECLARE FUNCTION PDQExist% (FileSpec$) ' Replace with whatever you can find
DECLARE FUNCTION PDQValI% (Number$)    ' Replace with VAL() for pure QB
DECLARE FUNCTION PDQValL& (Number$)    ' Replace with VAL() for pure QB

' QuickPack Declarations
DECLARE FUNCTION QPStrI$ (IntValue%)   ' Replace with STR$() for pure QB
DECLARE FUNCTION Soundex$ (Work$)
DECLARE FUNCTION TrapInt% (Value%, LoLimit%, HiLimit%)

' Myown Declarations
DECLARE FUNCTION Boolean%(Char$)
DECLARE FUNCTION EndString(Temp$, EndCh$)
DECLARE FUNCTION FindLastCh(St$, BYVAL Ch)
DECLARE FUNCTION UnSignedI% (BYVAL X&)
DECLARE FUNCTION UnSignedL& (BYVAL X%)
DECLARE SUB DEC ALIAS "_dec" (IntVar%)
DECLARE SUB DEC2 ALIAS "_decL" (LongVar&)
DECLARE SUB DecStep(IntVar%, StepVar%)
DECLARE SUB DecStepL(LongVar&, StepVar%)
DECLARE SUB INC ALIAS "_inc" (IntVar%)
DECLARE SUB INC2 ALIAS "_incL" (LongVar&)
DECLARE SUB IncStep(IntVar%, StepVar%)
DECLARE SUB IncStepL(LongVar&, StepVar%)

' Local Declarations
DECLARE FUNCTION EndChar$(St$, EndCh$)
DECLARE FUNCTION MakeExt$(St$, Ext$)
DECLARE FUNCTION FindIndex%(IndexFiles$, UserName$, SoundAlike)
DECLARE FUNCTION JulianInt2Str$(Julian)
DECLARE FUNCTION Str2JulianInt%(St$)
DECLARE FUNCTION ZeroStr$(Num)

CONST FALSE = 0 , TRUE = -1

' $INCLUDE: 'PCBTYPES.INC'

Zero = 0
DIM SHARED Days(0 TO 1, 1 TO 12)
DIM SHARED Command(1 TO 99), Macro$(1 TO 10)
DIM SHARED PCBSys AS PCBSysRecord
DIM SHARED UsersSysHdr AS UsersSysHdrRecord, UsersSys AS UsersSysRecord
DIM SHARED AliasName AS STRING * 26, Address AS UAddressRecord
DIM SHARED Notes AS UNotesRecord, Password AS UPasswordRecord
DIM SHARED Verify AS STRING * 26, Stats AS StatsRecord
DIM SHARED LMR&(Zero)
DIM SHARED ConfName(Zero) AS STRING * 14
DIM SHARED CNamesAt AS CNamesAtRecord, CNamesAdd AS CNamesAddRecord
DIM SHARED Users AS UsersRecord, UsersInf AS UsersInfRecord
DIM SHARED InfHeader AS UsersInfHdrRecord, UsersApp AS UsersAppRecord

' Function to Find User Name in PCBNDX.* files
' IndexFiles$ = Full Drive:\Path\PCBNDX.
' SoundAlike search requires QuickPack Professional SOUNDEX routine.
'            remove that portion of code for pure QB code.

FUNCTION FindIndex%(IndexFiles$, UserName$, SoundAlike)
   DIM PCBNDX AS PCBNDXRECORD
   IndexLen = LEN(PCBNDX)
   IndexFile$ = IndexFiles$ + CHR$(TrapInt(ASC(LEFT$(UserName$, 1)), 65, 90))
   IndexFileNo = FREEFILE
   FindIndex = -1
   IF PDQExist(IndexFile$) THEN
      OPEN IndexFile$ FOR RANDOM AS #IndexFileNo LEN = Indexlen
         Indexes = LOF(IndexFileNo) \ IndexLen
         Test = 0
         IF Indexes < 1 THEN
         ELSEIF SoundAlike = 0 THEN         ' just ELSE for QB Code
            Jump = Indexes \ 2 + (Indexes MOD 2): Match = Jump
            DO
               Test = Test - (Jump = 1)
               Jump = Jump \ 2 + (Jump MOD 2)
               Match = TrapInt(Match, 1, Indexes)
               GET #IndexFileNo, Match, PCBNDX
               IF UserName$ = PCBNDX.UserName$ THEN
                  FindIndex = PCBNDX.Index
                  EXIT DO
               ELSEIF UserName$ < PCBNDX.UserName$ THEN
                  DecStep Match, Jump
               ELSE
                  IncStep Match, Jump
               END IF
               IF Test > 1 THEN
                  EXIT DO
               END IF
            LOOP
         ELSE
            X = INSTR(UserName$, " ")
            IF X THEN
               UserNameSnd& = PDQValL&(Soundex$(LEFT$(UserName$, X-1)))
               LastNameSnd& = PDQValL&(Soundex$(MID$(UserName$, X+1)))
            ELSE
               UserNameSnd& = PDQValL&(Soundex$(UserName$))
               LastNameSnd& = 0
            END IF

            FOR Match = SoundAlike To Indexes
               GET #IndexFileNo, Match, PCBNDX
               X = INSTR(PCBNDX.UserName$, " ")
               IF X THEN
                  MatchSnd& = PDQValL&(Soundex$(LEFT$(PCBNDX.UserName$, X-1)))
                  MatchLastSnd& = PDQValL&(Soundex$(MID$(PCBNDX.UserName$, X+1)))
               ELSE
                  MatchSnd& = PDQValL&(Soundex$(PCBNDX.UserName$))
                  MatchLastSnd& = 0
               END IF
               IF UserNameSnd& = MatchSnd& AND LastNameSnd& = MatchLastSnd& THEN
                  UserNameMatch$ = PCBNDX.UserName$
                  FindIndex = PCBNDX.Index
                  SoundAlike = Match+1
                  EXIT FOR
               END IF
            NEXT Match
         END IF
      CLOSE #IndexFileNo
   END IF
END FUNCTION

' Function to make sure a string ends with a particular Character (or string)
'  (useful for checking Paths for '\')

FUNCTION EndChar$(St$, EndCh$) STATIC
   Temp$ = RTRIM$(ST$)
   IF (LEN(Temp$) = 0) OR EndString(Temp$, EndCh$) THEN
      EndChar$ = Temp$
   ELSE
      EndChar$ = Temp$ + EndCh$
   END IF
END FUNCTION

' Function for creating a string with an identical Drive:Path\FileName but
'  with a different extension
'  (useful for obtaining a Configuration filename from the program name)

FUNCTION MakeExt$(St$, Ext$) STATIC
   ExtPos = FindLastCh(St$, 46)
   IF ExtPos THEN
      MakeExt$ = LEFT$(St$, ExtPos) + Ext$
   ELSE
      MakeExt$ = RTRIM$(St$) + "." + Ext$
   END IF
END FUNCTION

' Function to Convert an INTEGER containing the date in Julian to a
'  "MM-DD-YY" STRING

Days(0, 1) =   0   :   Days(1, 1) =   0
Days(0, 2) =  31   :   Days(1, 2) =  31
Days(0, 3) =  59   :   Days(1, 3) =  60
Days(0, 4) =  90   :   Days(1, 4) =  91
Days(0, 5) = 120   :   Days(1, 5) = 121
Days(0, 6) = 151   :   Days(1, 6) = 152
Days(0, 7) = 181   :   Days(1, 7) = 182
Days(0, 8) = 212   :   Days(1, 8) = 213
Days(0, 9) = 243   :   Days(1, 9) = 244
Days(0,10) = 273   :   Days(1,10) = 274
Days(0,11) = 304   :   Days(1,11) = 305
Days(0,12) = 334   :   Days(1,12) = 335

FUNCTION JulianInt2Str$(Julian) STATIC
   IF Julian <> 0 THEN
      Julian& = UnSignedL&(Julian)
      Year   = (100 * Julian&) \ 36525&
      Temp&  = Year * 36525&
      DayofYear = Julian& - (Temp& \ 100)

      IF (Temp& MOD 100) = 0 THEN
         INC DayOfyear
         Leap = 1
      ELSE
         Leap = 0
      END IF
      Month = 1
      FOR Counter = 2 TO 12
         IF Days(Leap, Counter) < DayOfYear THEN
            Month = Counter
         END IF
      NEXT Counter
      Day = DayOfYear - Days(Leap, Month)
   ELSE
      Year = 0
      Month = 0
      Day = 0
   END IF
   JulianInt2Str$ = ZeroStr$(Month) + "-" + ZeroStr$(Day) + "-" + ZeroStr$(Year)
END FUNCTION

' Function to Convert a "MM-DD-YY" STRING to an INTEGER containing the
'  date in Julian.

FUNCTION Str2JulianInt%(St$)
   Year  = PDQValI(RIGHT$(St$, 2)) + 1900
   Month = PDQValI(LEFT$(St$, 2))
   Day   = PDQValI(MID$(St$, 4, 2))
   JDT& = 36525& * Year
   IF (JDT& MOD 100) = 0 AND Month < 3 THEN DEC2 JDT&
   JDT& = (JDT& - (1900 * 36525&)) \ 100
   Str2JulianInt% = JDT& + Days(0, Month) + Day
END FUNCTION

' Function used in JulianInt2Str$ to return a 2 digit '0' padded number

FUNCTION ZeroStr$(Num) STATIC
   ZeroStr$ = RIGHT$("00" + LTRIM$(STR$(Num)), 2)
END FUNCTION


'   Routine to read PCBOARD.DAT file for PCBOARD 15.x

PCB$ = "PCBOARD.DAT"

OPEN PCB$ FOR INPUT AS #1
   LINE INPUT #1, Title$           ' PCBOARD.DAT version identification                                 1
   LINE INPUT #1, SysopFName$      ' SYSOPS Display Name (if answered NO to "Use Real Name")            2
   LINE INPUT #1, SysopPassword1$  ' Sysop Password (from call waiting screen)                          3
   INPUT #1, UseRealName           ' Use Real Name                                                      4
   INPUT #1, UseGraphics           ' Use Graphics (when logging in as the sysop)                        5
   INPUT #1, Command(20)           ' Level Needed to Real All Comments                                  6
   INPUT #1, Command(21)           ' Level Needed to Read All Mail Except Comments                      7
   INPUT #1, Command(22)           ' Sysop Level (for Sysop Menu and F1-Temp-Sysop Upgrade)             8
   INPUT #1, Command(23)           ' Level Needed to Copy or Move Messages Between Areas                9
   FOR X = 1 TO 14                 '                                                                   10
      INPUT #1, Command(X)         ' Security Req'd for Sysop Function  1-14                           ~
   NEXT X                          '                                                                   23
   LINE INPUT #1, HelpPath$        ' Location of Help Files                                            24
   LINE INPUT #1, SecPath$         ' Location of Security Message Files                                25
   LINE INPUT #1, NodeChatPath$    ' Location of NODE CHAT Files                                       26
   LINE INPUT #1, PCBTextPath$     ' Location of PCBTEXT Files                                         27
   LINE INPUT #1, USERSIndexPath$  ' Location of USERS File Index Files                                28
   LINE INPUT #1, UsersFile$       ' Loc/Name of Users File                                            29
   LINE INPUT #1, CallerFile$      ' Loc/Name of Caller Log File                                       30
   LINE INPUT #1, CNamesFile$      ' Loc/Name of Conference Name File                                  31
   LINE INPUT #1, PwrdFile$        ' Loc/Name of Password File                                         32
   LINE INPUT #1, FSecFile$        ' Loc/Name of File Security File                                    33
   LINE INPUT #1, UpSecFile$       ' Loc/Name of UPSEC File                                            34
   LINE INPUT #1, TCanFile$        ' Loc/Name of Trashcan File                                         35
   LINE INPUT #1, WelcomeFile$     ' Loc/Name of Welcome Screen File                                   36
   LINE INPUT #1, NewUserFile$     ' Loc/Name of New User Message File                                 37
   LINE INPUT #1, ClosedFile$      ' Loc/Name of CLOSED File                                           38
   LINE INPUT #1, WarningFile$     ' Loc/Name of WARNING File                                          39
   LINE INPUT #1, ExpiredFile$     ' Loc/Name of EXPIRED File                                          40
   LINE INPUT #1, UserNetFile$     ' Loc/Name of USERNET File                                          41
   LINE INPUT #1, CnfnFile$        ' Loc/Name of Conference Join Menu                                  42
   LINE INPUT #1, NewAskFile$      ' Loc/Name of New Reg. Quest.                                       43
   LINE INPUT #1, NewRegFile$      ' Loc/Name of Answers to New Reg.                                   44
   LINE INPUT #1, PCBProtFile$     ' Loc/Name of Protocol Data File                                    45
   LINE INPUT #1, DownloadFile$    ' Loc/Name of Download Summary File                                 46
   LINE INPUT #1, Script0File$     ' Loc/Name of Script Quest.                                         47
   LINE INPUT #1, Answer0File$     ' Loc/Name of Script Answers                                        48
   LINE INPUT #1, PCBMLFile$       ' Loc/Name of Multi-Lang Data File                                  49
   LINE INPUT #1, GroupFile$       ' Loc/Name of Group Chat Topic File                                 50
   INPUT #1, CarrierWait           ' Seconds to wait for Carrier                                       51
   LINE INPUT #1, CommPort$        ' Comm Port to use (COMx or None)                                   52
   LINE INPUT #1, BaudRate$        ' Initial Port Speed                                                53
   INPUT #1, LockSpeed             ' Lock Opening Speed (Fixed DTE)                                    54
   LINE INPUT #1, ModemInit$       ' Modem Initialization Command String                               55
   LINE INPUT #1, ModemOffHook$    ' Modem Off-Hook Command String                                     56
   INPUT #1, CTSCheck              ' Disable CTS/RTS Checking                                          57
   INPUT #1, HayesV                ' Using a Hayes 9600 V-Series Modem                                 58
   INPUT #1, EVIFastComm           ' Using a EVI/Fastcomm Modem                                        59
   INPUT #1, SoftReset             ' Perform 'Soft' Modem Reset - (ATZ) Command  During Recycle        60
   INPUT #1, OffHook               ' Place Modem 'Off-Hook' During Recycle                             61
   INPUT #1, Packet                ' Running Under PAD (Packet Switched) Environment                   62
   INPUT #1, TrueRing              ' Answer on True Ring Detect                                        63
   INPUT #1, Caller7e1             ' Allow 7,E,1 Callers                                               64
   INPUT #1, AllowLowBaud          ' Allow Low Baud Rates                                              65
   LINE INPUT #1, Start300$        ' Start Time of 300 Baud  (00:00 to 23:59)                          66
   LINE INPUT #1, End300$          ' End Time of 300 Baud    (00:00 to 24:00)                          67
   INPUT #1, MesgScan              ' Disable Message Scan Prompt                                       68
   INPUT #1, ScreenClr             ' Disable 3 Minute Screen Clear                                     69
   INPUT #1, RegEdit               ' Disable Registration Edits                                        70
   INPUT #1, HighFilt              ' Disable High-Ascii Filter                                         71
   INPUT #1, QuickLog              ' Disable Quick Logon Feature                                       72
   INPUT #1, PasswordCheck         ' Disable Password Check (DOS Return)                               73
   INPUT #1, MultLing              ' Multilingual Operation                                            74
   INPUT #1, DenyUpdate            ' Disable Full Record Updating                                      75
   INPUT #1, ClosedBoard           ' Run as a Closed Board                                             76
   INPUT #1, NonGraphics           ' Run Board in Non-Graphics Mode                                    77
   INPUT #1, ExitDos               ' Exit to DOS After Each Call                                       78
   INPUT #1, CityChat              ' Include City in Node CHAT DIsplay                                 79
   INPUT #1, ScrnSnow              ' Eliminate Screen Snow                                             80
   INPUT #1, Subscription          ' Enable Subscription Operation                                     81
   INPUT #1, AllowEsc              ' Allow (Esc) Codes in Messages                                     82
   INPUT #1, CarbonCopy            ' Allow Carbon-Copy Messages                                        83
   INPUT #1, Validate              ' Validate 'To:' Name During (E)nter a Message                      84
   INPUT #1, UpdatePointer         ' (no longer used, was:  Update Msg Ptr after Read)                 85
   INPUT #1, DailyLimit            ' Enforce Daily Time Limit                                          86
   INPUT #1, ShowNews              ' Display NEWS File Only if Changed (-1=YES, 0=NO, 1=ALWAYS)        87
   INPUT #1, CTSDrop               ' Disable CTS/RTS Drop During Disk Write                            88
   INPUT #1, KBTimeout             ' Keyboard Timeout Period (0=disable)                               89
   INPUT #1, Network               ' Running Under a Network / Multitasker System                      90
   INPUT #1, Netnode               ' Network Node Number                                               91
   INPUT #1, NetTimeout            ' Network Timeout Value (20-99 secs)                                92
   INPUT #1, NodeDelay             ' Node CHAT Delay While 'Idle' (once every 5-99 secs)               93
   LINE INPUT #1, BBSName$         ' BBS Name String                                                   94
   LINE INPUT #1, ViewBatFile$     ' Loc/Name of Batch File for viewing files                          95
   LINE INPUT #1, ARCExt$          ' Filename Extension for compressed files                           96
   FOR X = 0 TO 9                  '                                                                   97
      LINE INPUT #1, Macro$(X)     ' Function Key SHIFT-Fn Macro$ 1 to 10                              ~
   NEXT X                          '                                                                  106
   LINE INPUT #1, PubConf$         ' New User OPEN Conference String (not used)                       107
   INPUT #1, ConfCount             ' Number of Highest Conference Desired                             108
   INPUT #1, LineLimit             ' Maximum Lines in the Message Editor                              109
   INPUT #1, TextColor             ' Text ANSI Color (31 - 37)                                        110
   INPUT #1, Attrib                ' Test ANSI Attribute (00 or 01)                                   111
   INPUT #1, EventFlag             ' Is a Timed Event Active                                          112
   LINE INPUT #1, EventTime$       ' Time to Begin Event (military time)                              113
   INPUT #1, EventSuspend          ' Minutes to suspend activity before event                         114
   INPUT #1, AllowUploads          ' Dis-allow Uploads during suspend time                            115
   INPUT #1, SlideEvent            ' Slide Event Time if a User is Online                             116
   INPUT #1, UploadBuffer          ' Upload buffer Size (4-64)                                        117
   INPUT #1, DriveCheck            ' Disable Drive Size Check                                         118
   INPUT #1, ParallelPort          ' Parallel Port Num (1-3, 0=None)                                  119
   INPUT #1, UploadLimit           ' Stop Uploads at Free Space less than xKB                         120
   FOR X = 65 TO 90                '                                                                  121
      INPUT #1, Command(X)         ' Security Level for A to Z                                         ~
   NEXT X                          '                                                                  146
   INPUT #1, Command(91)           ' Security Level for OPEN a DOOR                                   147
   INPUT #1, Command(92)           ' Security Level for CHAT between NODEs                            148
   INPUT #1, SecLevelNew           ' Level Given to Users Who Agree  to Register Security             149
   INPUT #1, SecLevelRefuse        ' Level Given to Users Who Refuse to Register Security             150
   INPUT #1, Command(93)           ' Security Level needed for USERS command                          151
   INPUT #1, Command(94)           ' Security Level needed for WHO command                            152
   INPUT #1, Command(95)           ' Security Level needed for BATCH file transfers                   153
   LINE INPUT #1, ColorDefFile$    ' Name of color definition file (usually PCBFILER.DEF)             154
   INPUT #1, LowBaud               ' Lowest allowed baud rate for callers (was /BAUD:xxxx)            155
   INPUT #1, ModemDelay            ' Modem delay during recycle (was /DELAY:xx)                       156
   INPUT #1, NumRings              ' Number of Rings before answering the phone                       157
   INPUT #1, IRQNum                ' IRQ number of comm port if not COM1 or COM2                      158
   INPUT #1, BaseAddress           ' BASE address of comm port if not COM1 or COM2                    159
   INPUT #1, DropDTR               ' Leave DTR up at drop to DOS (some modems hangup if DTR is down   160
   INPUT #1, ScrollBackBuff        ' Maximum lines in scrollback buffer (was /MAX:xxx)                161
   INPUT #1, PreLoadPCBTEXT        ' Pre-load PCBTEXT file for faster access (uses more memory)       162
   INPUT #1, PreLoadCNAMES         ' Pre-load CNAMES file for faster access (uses more memory)        163
   INPUT #1, Command(96)           ' Security Level required for a caller to use @-variables          164
   INPUT #1, FileUlBy              ' Include "Uploaded By" line in uploaded file descriptions         165
   INPUT #1, ShowStats             ' Show user settings during login (was /INFO)                      166
   INPUT #1, LocalShells           ' Allow local F5 shells to DOS                                     167
   INPUT #1, SlaveCards            ' Use Slave Card updating (v14.2 did, v14.5 is faster without)     168
   INPUT #1, SubLength             ' Default subscription length for new users                        169
   INPUT #1, MaxMsgsCap            ' Maximum messages in a capture file                               170
   INPUT #1, MaxmsgsConf           ' Maximum messages per conference in a capture file                171
   INPUT #1, Mins2StopUl           ' Minutes prior to an event to stop uploads                        172
   INPUT #1, Command(97)           ' Security Level needed to EDIT any message                        173
   INPUT #1, Command(98)           ' Security Level needed to EDIT your own message                   174
   INPUT #1, ShareIRQs             ' Share IRQ's on microchannel buses (for comm ports)               175
   INPUT #1, ScanAllConfs          ' Default to scan ALL conferences at login                         176
   INPUT #1, Command(24)           ' Level Needed to Use the 'Read Only' Command                      177
   INPUT #1, AskNewAsk             ' Use NEWASK questionnaire plus standard new user questions        178
   LINE INPUT #1, TempDir$         ' Location for temporary files                                     179
   LINE INPUT #1, UsersInfFile$    ' Name and location of USERS.INF file                              180
   INPUT #1, QuickScan             ' Default to 'Quick Scan' method on personal message scan          181
   INPUT #1, WarningPeriod         ' Number of DAYS for warning prior to subscription expiration      182
   INPUT #1, OneNameUsers          ' Allow ONE-name users to log onto the system                      183
   INPUT #1, NewExplevel           ' Default 'Expired' Security Level                                 184
   INPUT #1, Command(99)           ' Security Level to use the TEST command                           185
   LINE INPUT #1, CaptureFile$     ' Name of the message CAPTURE file (or blank=caller number)        186
   INPUT #1, VerifyUls             ' Perform file verification on uploads                             187
   INPUT #1, MsgCapStopClk         ' Stop the clock during Message Capture download                   188
   LINE INPUT #1, SysopIn$         ' Start time for sysop pages                                       189
   LINE INPUT #1, SysopOut$        ' Stop time for sysop pages                                        190
   INPUT #1, LogCallNum            ' Write Caller Number to callers log                               191
   INPUT #1, LogConnect            ' Write Connect String to callers log                              192
   INPUT #1, LogSeclevel           ' Write Caller's Security Level to callers log                     193
   INPUT #1, ReadPWRD              ' Read PWRD file upon joining a conference                         194
   INPUT #1, ConfirmCaller         ' Confirm caller name at logon time                                195
   INPUT #1, CommentPWFail         ' Allow password failure comment                                   196
   INPUT #1, LogOffWarning         ' Warning before logoff                                            197
   INPUT #1, Uploadlines           ' Maximum number of lines in upload description                    198
   LINE INPUT #1, ChatFile$        ' Name/Location of CHAT.DAT file                                   199
   LINE INPUT #1, StatsFile$       ' Name/Location of PCBSTATS.DAT file                               200
   LINE INPUT #1, ChatMenu$        ' Name/Location of CHAT menu                                       201
   LINE INPUT #1, NoANSIFile$      ' Name/Location of NOANSI file                                     202
   LINE INPUT #1, SlowDrives$      ' List of slow drive letters                                       203
   LINE INPUT #1, SwapFile$        ' Name/Location of SWAP FILE (when swapping to disk)               204
   INPUT #1, SwapOut               ' Swap out                                                         205
   INPUT #1, NoBatchUl             ' Disable Batch Uploads                                            206
   INPUT #1, CommentsMain          ' Force comments-to-sysop into the Main Board                       207
   INPUT #1, ForeignSys            ' Foreign System - use 0Dh instead of E3h for Line Sep in msgs     208
   INPUT #1, MonitorMissed         ' Monitor modem - record missed connections in callers log         209
   INPUT #1, No16550               ' Force NO 16550 usage                                             210
   INPUT #1, Force16550            ' Force 16550 usage                                                211
   INPUT #1, ResetModemIdle        ' Reset modem while idling at the call waiting screen              212
   INPUT #1, FloadNode             ' Float Node Number via USERNET information                        213
   INPUT #1, UD2UBDB               ' Promote U/D commands to UB/DB when batch protocol is default     214
   INPUT #1, RegPubConf            ' Automatically register new users into public conferences         215
   INPUT #1, Scan4Blts             ' Scan for new bulletins during login sequence                     216
   INPUT #1, CreateMsgs            ' Create MSGS file if it does not exist when joining a conference  217
   INPUT #1, VerifyCDLoss          ' Verify CD Loss before recycling                                  218
   INPUT #1, EncryptUsers          ' Encrypt USERS file                                               219
   INPUT #1, TimeCredit            ' Upload Time Credits (default is 1.0)                             220
   INPUT #1, ByteCredit            ' Upload Byte Credits (default is 0.0)                             221
   INPUT #1, DefaultColor          ' Default Color, range 0-255 (overrides lines 110 and 111)         222
   INPUT #1, MsgHdrLine1Color      ' Message Header Line 1 Color, range 0-255                         223
   INPUT #1, MsgHdrLine2Color      ' Message Header Line 2 Color, range 0-255                         224
   INPUT #1, MsgHdrLine3Color      ' Message Header Line 3 Color, range 0-255                         225
   INPUT #1, MsgHdrLine4Color      ' Message Header Line 4 Color, range 0-255                         226
   INPUT #1, MsgHdrLine5Color      ' Message Header Line 5 Color, range 0-255                         227
   INPUT #1, MsgHdrLine6Color      ' Message Header Line 6 Color, range 0-255                         228
   LINE INPUT #1, Origin$          ' ORIGIN information for netmail routing                           229
   LINE INPUT #1, EventDatFile$    ' Name/Location of EVENT.DAT file                                  230
   LINE INPUT #1, Events$          ' Location of EVENT files                                          231
   LINE INPUT #1, CmdLstFile$      ' Name/Location of CMD.LST file                                    232
   LINE INPUT #1, DOSPassword$     ' Require password to exit to DOS from Call Waiting screen         233
   INPUT #1, Command(15)           ' Security Level to use Sysop Function 15                          234
   INPUT #1, Command(25)           ' Security Level to use BROADCAST command                          235
   INPUT #1, Command(26)           ' Security Level to view the Private Upload directory              236
   INPUT #1, Command(27)           ' Security Level to enter generic messages (@user@, @##@, @##-##@) 237
   INPUT #1, Command(28)           ' Security Level to edit message headers                           238
   INPUT #1, Command(29)           ' Security Level to protect messages                               239
   INPUT #1, Command(30)           ' Security Level to overwrite files on an upload                   240
   INPUT #1, Command(31)           ' Security Level to copy/move a message to a new location          241
   INPUT #1, EnvSize               ' Environment Size when shelling/swapping to DOS                   242
   INPUT #1, Command(32)           ' Security Level to override the Low Baud Rate limit               243
   LINE INPUT #1, AllLstFile$      ' Name/Location of ALLFILES.LST (used in place of DLPATH.LST on upl244
   LINE INPUT #1, Res1$            ' Reserved                                                         245
   LINE INPUT #1, Res2$            ' Reserved                                                         246
   LINE INPUT #1, Res3$            ' Reserved                                                         247
   INPUT #1, ReadNewMail           ' Prompt callers to read new mail                                  248
   LINE INPUT #1, LogonAskFile$    ' Name/Location of LOGON Script Questionnaire                      249
   LINE INPUT #1, LogonAnswerFile$ ' Name/Location of LOGON Script Questionnaire ANSWER File          250
   LINE INPUT #1, QwkPacket$       ' Name of QWK Packet (root name of .QWK and .REP files)            251
   LINE INPUT #1, UlTrashCan$      ' Name/Location of Upload File TRASHCAN (stop uploads of specific) 252
   INPUT #1, Command(33)           ' Security Level to set an pack-out date on a message              253
   INPUT #1, Command(34)           ' Security Level to be able to see Return Receipts not addressed to254
   INPUT #1, SwapOnOffBatch        ' Swap during $$LOGON/$$LOGOFF batch execution                     255
   INPUT #1, CreateUsersSys        ' Create USERS.SYS file for $$LOGON.BAT execution                  256
   INPUT #1, DefaultMode           ' Graphics Mode default                                            257
   LINE INPUT #1, SlowBatch$       ' Name of SLOW DRIVE batch file to execute after copying from slow 258
   INPUT #1, ChangeAliases         ' Allow Aliases to be changed after first selecting them           259
   INPUT #1, ExcludeLocal          ' Exclude local logins/downloads/etc from statistics               260
   INPUT #1, ForcePwDays           ' Number of days to FORCE password change (requires Password PSA)  261
   INPUT #1, WarnPwDays            ' Number of days to WARN before password change (requires Password 262
   INPUT #1, RecordChat            ' Record Group Chat Sessions                                       263
   INPUT #1, ShowAlias             ' Show ALIAS names in USERNET                                      264
   INPUT #1, MinPwLen              ' Minimum length for passwords when the Password PSA is installed  265
CLOSE


'   Routine to read PCBOARD.SYS file for PCBOARD 15.x

PSysFile$ = "PCBOARD.SYS"
OPEN SysFile$ FOR BINARY AS #1
   GET #1,, PCBSys
   IF ConfCount > 39 THEN               'ConfCount from PCBOARD.DAT Line 108
      ExtConfLen = ((ConfCount + 1) \ 8) - (((ConfCount + 1) MOD 8) <> 0) - 5
      ExtConfJoined$ = STRING$(ExtConfLen, 0)
      ExtConfScaned$ = STRING$(ExtConfLen, 0)
      GET #1, , ExtConfJoined$
      GET #1, , ExtConfScaned$
   END IF
   NodeNum = ASC(PCBSys.NodeNum)
   IF NodeNum = 255 THEN
      GET #1, LOF(1) - 2, NodeNum
   END IF
CLOSE #1


'   Routine to read USERS.SYS file for PCBOARD 15.x

USysFile$ = "USERS.SYS"

OPEN USysFile$ FOR BINARY ACCESS READ WRITE SHARED AS #1
   GET #1, , UsersSysHdr
   GET #1, , UsersSys
   AliasSupport = Boolean(INPUT$(1, #1))
   IF AliasSupport THEN GET #1, , AliasName
   AddressSupport = Boolean(INPUT$(1, #1))
   IF AddressSupport THEN GET #1, , Address
   PasswordSupport = Boolean(INPUT$(1, #1))
   IF PasswordSupport THEN GET #1, , Password
   VerifySupport = Boolean(INPUT$(1, #1))
   IF VerifySupport THEN GET #1, , Verify
   StatsSupport = Boolean(INPUT$(1, #1))
   IF StatsSupport THEN GET #1, , Stats
   NotesSupport = Boolean(INPUT$(1, #1))
   IF NotesSupport THEN GET #1, , Notes

'  We should be pointing to LMR's but make sure in case things change
   SEEK #1, UsersSysHdr.SizeOfRec + 41

   NumOfAreas& = UnSignedL&(UsersSysHdr.NumOfAreas)
   REDIM LMR&(0 TO NumOfAreas& - 1)
'  To get the Last Message Read Pointers using QB
   FOR X& = 0 TO NumOfAreas& - 1
      GET #1, , LMR&(X&)
   NEXT X&

'  To get the Last Message Read Pointers using QPPRO
'  Handle = FILEATTR(1,2)
'  FGetAH2 Handle, LMR(0), 4, UsersSysHdr.NumOfAreas

'  If you don't want to read the LMR's you skip them
'  SEEK #1, UsersSysHdr.SizeOfRec + 41 + 4 * NumOfAreas&

   AreaReg$     = STRING$(UsersSysHdr.SizeOfBitFields, 0)
   ExpAreaReg$  = STRING$(UsersSysHdr.SizeOfBitFields, 0)
   UserScan$    = STRING$(UsersSysHdr.SizeOfBitFields, 0)
   MailWaiting$ = STRING$(UsersSysHdr.SizeOfBitFields, 0)
   ConfSysop$   = STRING$(UsersSysHdr.SizeOfBitFields, 0)
   ConfJoined$  = STRING$(UsersSysHdr.SizeOfBitFields, 0)
   ConfScanned$ = STRING$(UsersSysHdr.SizeOfBitFields, 0)
   GET #1, ,AreaReg$
   GET #1, ,ExpAreaReg$
   GET #1, ,UserScan$
   GET #1, ,MailWaiting$
   GET #1, ,ConfSysop$
   GET #1, ,ConfJoined$
   GET #1, ,ConfScanned$

'  Again make sure we know where we are!
   SEEK #1, UsersSysHdr.SizeOfRec + 41 + 4 * NumOfAreas& + _
            UsersSysHdr.NumOfBitFields * UsersSysHdr.SizeOfBitFields

'  TPA Static & Dynamic would be here

CLOSE #1


'   Routine to read Conference names from CNAMES.@@@ for PCBOARD 15.x

' CNamesFile$ from PCBOARD.DAT Line 31

OPEN CNamesFile$ FOR BINARY ACCESS READ SHARED AS #1
   GET #1, 1, CNamesRecLen
   RecLen& = CNamesRecLen
   MsgBases = (LOF(1) - 2) \ CNamesRecLen
   REDIM ConfName(0 TO MsgBases - 1) AS STRING * 14
   FOR X = 0 TO MsgBases - 1
      GET #1, X * RecLen& + 3, ConfName$(X)
   NEXT X
CLOSE #1


'   Routine to read CNAMES.@@@ & CNAMES.ADD files for PCBOARD 15.x

' ConfNum would contain the desired Conference to read/Write

OPEN CNamesAtFile$ FOR BINARY ACCESS READ WRITE SHARED AS #1
   GET #1, 1, CNamesRecLen
   GET #1, UnSignedL&(ConfNum) * CNamesRecLen + 3, CNamesAt
'  PUT #1, UnSignedL&(ConfNum) * CNamesRecLen + 3, CNamesAt
CLOSE #1

PRINT "ConferenceName: "; CNamesAt.ConfName$

OPEN CNamesAddFile$ FOR RANDOM ACCESS READ WRITE SHARED AS #1 LEN = 256
   GET #1, ConfNum + 1, CNamesAdd
'  PUT #1, ConfNum + 1, CNamesAdd
CLOSE #1

PRINT "Conference Intro File: "; CNamesAdd.Intro$


'   Routine to read USERS & USERS.INF files for PCBOARD 15.x

' UserNum would contain the desired User record to read/Write

' UsersFile$ from PCBOARD.DAT Line 29
' UsersInfFile$ from PCBOARD.DAT Line 180


UsersLen    = LEN(Users)
OPEN UsersFile$ FOR RANDOM ACCESS READ WRITE SHARED AS #1 LEN = UsersLen
   Recs = CINT(LOF(1) \ UsersLen)
   GET #1, UserNum, Users
'  PUT #1, UserNum, Users
CLOSE #1

OPEN UsersInfFile$ FOR BINARY ACCESS READ WRITE SHARED AS #1
   GET #1, 1, InfHeader
   NumofApps& = UnSignedL&(InfHeader.NumofApps)
   HeaderSize& = NumofApps& * LEN(UsersApp) + LEN(InfHeader) + 1&
   Pointer& = HeaderSize& + (Users.UsersInfPointer& - 1&) * InfHeader.TotalRecSize&
   GET #1, Pointer&, UsersInf
'  PUT #1, Pointer&, UsersInf
CLOSE #1
