TITLE "PCBoard 15.0 internal QWK/REP mail run"
;----------------------------------------------------------------------
; PCB15QWK.RS -- MAIL run for PCBoard 15 Internal QWK
;......................................................................
;
; Author:  Dan Parsons
; Version: 1.1
; Revised: 9/20/93
;
;----------------------------------------------------------------------
PARAMETER 1 "PCBoard QWK Packet ID    (8 chars max)"
PARAMETER 2 "Incoming QWK dir  (include ending '\')"
PARAMETER 3 "Outgoing REP dir  (include ending '\')"
PARAMETER 4 "Hang up after sending REP        (Y/N)"
PARAMETER 5 "Mail run log file           (optional)"
ENDPARAMS

    ; Verify that the 3 necessary parameters were entered.
    IF EMPTY "%P1%" GOTO PARAM_ERROR
    IF EMPTY "%P2%" GOTO PARAM_ERROR
    IF EMPTY "%P3%" GOTO PARAM_ERROR

    ; Set up capture file
    ; Change "overwrite" below to "append" if desired.
    IF NOT EMPTY "%P5%" CAPTURE "%P5%" OVERWRITE

    ; Default to ten minutes to scan for mail.
    ; Edit this if desired.
    TIMEOUT 600

    ; Get to mail door
    VENUE MAIN
    JOIN "0"

    ; Request the packet
    SEND "QWK D|"

    WHEN "%BBS32%" SEND "|"
    WHEN "%BBS34%" SEND "|"
    WHEN "NOTHING TO DOWN" GOTO NOQWK
    WAITFOR "%BBS39%" FAILURE GOTO SLOW_BBS

    ; Keep 3 old QWK packets by default.
    ; Edit this if desired.
    IF EXIST "%P2%%P1%.QWK" RENUMBER "%P2%%P1%.QWK" 3

    ; Download the QWK packet.
    MESSAGE "Downloading %P2%%P1%.QWK"
    DOWNLOAD "%P2%%P1%.QWK" USING "%BBS22%"

    GOSUB GET_TO_COMMAND

GOTO SENDREP

:NOQWK
    MESSAGE "No mail to download."
    GOTO SENDREP

:SENDREP
    IF NOT EXIST "%P3%%P1%.REP" GOTO NOREP
    SEND "QWK U|"
    WAITFOR "%BBS39%" FAILURE GOTO I_AM_LOST
    MESSAGE "Uploading %P3%%P1%.REP"
    UPLOAD "%P3%%P1%.REP" USING "%BBS21%"
    ; Will keep up to 3 old rep packets.  Edit if desired.
    RENUMBER "%P3%%P1%.REP" 3
GOTO ENDRUN

:NOREP
    MESSAGE "No %P3%%P1%.REP to send"
GOTO ENDRUN

:ENDRUN
    IF YES "%P5%" GOTO DROP_CARRIER
    GOSUB GET_TO_COMMAND
    CLOSE
EXIT 0

:DROP_CARRIER
    MESSAGE "Dropping carrier per request"
    HANGUP
    CLOSE
EXIT 0

:GET_TO_COMMAND
    SEND "|"
    CLEAR
    WHEN "CONFERENCE COMMAND" SEND "A|"
    WHEN "%BBS32%" SEND "|"
    WHEN "%BBS34%" SEND "|"
    WAITFOR "%BBS35%" FAILURE GOTO I_AM_LOST
RETURN
 
:SLOW_BBS
    MESSAGE "^UERROR:^U Timeout during mail run."
    HANGUP
    CLOSE
EXIT 1

:I_AM_LOST
    MESSAGE "^UERROR:^U Sorry - I am lost."
    HANGUP
    CLOSE
EXIT 1

:PARAM_ERROR
    MESSAGE "^UERROR:^U Parameters 1, 2 and 3 are required!"
    CLOSE
EXIT 1

;eof
