
(*
 * ulpfmt - reformat the captured output of ulptest
 *
 * s.h.smith, 2-20-94
 *
 *)

var
   infd,outfd:    text;
   line:          string;

procedure exclude(key: string);
begin
   if pos(key,line) > 0 then
      line := '';
end;

begin
   if paramcount <> 2 then
   begin
      writeln('Usage: ulpfmt infile outfile');
      halt;
   end;

   assign(infd,paramstr(1));
   reset(infd);
   assign(outfd,paramstr(2));
   rewrite(outfd);

   writeln(outfd,'@PON@');

   while not eof(infd) do
   begin
      readln(infd,line);
      while line[length(line)] = ' ' do
         dec(line[0]);

      exclude('ULPTEST - Online UpLoadProcessor ');
      exclude('Copyright (c) 1992-1994 by Stacy Smith');
      exclude('(Comm I/O: ');
      exclude('Identifying Archive Format');
      exclude('Screening Archive for Corruption');
      exclude('Swapping in...');
      exclude('Swapping out...');
      exclude('Executing Un-archiving Program');
      exclude('Executing File-checking Programs');
      exclude('PKUNZIP (R)');
      exclude('PKWARE Inc. All Rights Reserved.');
      exclude('PKUNZIP Reg.');
      exclude('Scanning Volume:');
      exclude('Drive C:');
      exclude('This McAFEE(TM) software');
      exclude('agency or institution ');
      exclude('To negotiate a license fee ');
      exclude('All use of  this software  ');
      exclude('license terms set forth in ');
      exclude('Copyright (c) McAfee Associates ');
      exclude('Checking file number:');
      exclude('Changing all file attributes to read/write access...');
      exclude('Searching for internal description files in archive...');
      exclude('Executing Commenting Program');

      if line <> '' then
         writeln(outfd,line);
   end;

   writeln(outfd,'@WAIT@');
   close(infd);
   close(outfd);
end.


