' $linesize:132
' $title: 'Proposed new SUB for Maple Street Version of RBBS-PC'
' $INCLUDE: 'RBBS-VAR.MOD'
'
' $SUBTITLE: 'DoorSys - Makes a DOOR.SYS drop file'
' $PAGE
'
'  SUBPROGRAM NAME    -- DoorSys
'
'  INPUT PARAMETERS   --     PARAMETER                    MEANING
'                         To be added later after finalization of merge
'
'  OUTPUT PARAMETERS  --  ???
'
'  SUBPROGRAM PURPOSE --  Create a DOOR.SYS drop file
'
'DOOR.SYS Modification begins here per Kenny Gardner - author of GAP and the
'creator/cheerleader of DOOR.SYS.  Kenny told me that if RBBS-PC does not
'support the fields to put just a CR/LF which is what should happen here.  He
'said the doors are supposed to be smart enough to use their own default value
'if RBBS-PC cannot give it one.  If you take a look at QKDOOR you will find it
'also does things this way - I went to the source to confirm this! 8-)
'This merge creates both a DORINFO?.DEF and a DOOR.SYS....unless of course you
'comment out the above DORINFO?.DEF routines code...."Just Do It!" <BIG GRIN>
'                                                                  
70000 SUB DoorSys STATIC                                             ' DD091701
      CALL TimeRemain (MinsRemaining)                                'ER 06/05/92
      Close 2                                                        ' DD091701
      OPEN "O", 2, ZNodeWorkDrvPath$ + "DOOR.SYS"                    'ER 05/31/92
      IF ZLocalUser THEN _                                           ' DD092302/DOORSYS
         PRINT #2, "COM0:" _                                         ' DD092302/DOORSYS
      ELSE PRINT #2, ZComPort$ + ":"                            '(1) ' DD092302/DOORSYS
      PRINT #2, ZCBaud$                                         '(2) 'ER 05/30/92
      ZPosition% = INSTR(ZBaudParity$, "N,")                         'ER 06/17/92
      PRINT #2, MID$(ZBaudParity$, ZPosition% + 2, 1)           '(3) 'ER 06/17/92
      PRINT #2, ZNodeFileID$                                    '(4) 'ER 05/30/92
      PRINT #2, ZTalkToModemAt$                                 '(5) ' DD092302/DOORSYS
      IF ZSnoop = -1 THEN _                                     '(6) ' DD092302/DOORSYS
         PRINT #2, "Y" _                                             ' DD092302/DOORSYS
      ELSE PRINT #2, "N"                                             ' DD092302/DOORSYS
      IF ZPrinter = -1 THEN _                                   '(7) 'ER 05/30/92
         PRINT #2, "Y" _                                             'ER 05/30/92
      ELSE PRINT #2, "N"                                             'ER 05/30/92
      IF ZSysopAvail = -1 OR ZSysopAnnoy = -1 THEN _            '(8) 'ER 06/05/92
         PRINT #2, "Y" _                                             'ER 06/05/92
      ELSE PRINT #2, "N"                                             'ER 06/05/92
      IF ZSysopAvail = -1 OR ZSysopAnnoy = -1 THEN _            '(9) 'ER 06/05/92
         PRINT #2, "Y" _                                             'ER 06/05/92
      ELSE PRINT #2, "N"                                             'ER 06/05/92
      IF ZGlobalSysop THEN _                                   '(10) 'ER 05/30/92
         PRINT #2, ZSysopFirstName$ + " " + ZSysopLastName$ _        'ER 06/05/92
      ELSE PRINT #2, OrigFirstName$ + " " + ZLastName$              'Pe 021393
      PRINT #2, ZCityState$                                    '(11) ' DD092302/DOORSYS
      PRINT #2, ""    'Home Phone                              '(12) ' DD092302/DOORSYS
      PRINT #2, ""    'Data Phone                              '(13) ' DD092302/DOORSYS
      PRINT #2, ZPswdSave$                                     '(14) 'ER 05/30/92
      ZZ$ = STR$(ZUserSecLevel)                                      'RT070192
      CALL Trim(ZZ$)                                                 'RT070192
      PRINT #2, ZZ$                                            '(15) 'RT070192
      ZZ$ = STR$(ZTimesLoggedOn)                                     'RT070192
      CALL Trim(ZZ$)                                                 'RT070192
      PRINT #2, ZZ$                                            '(16) 'RT070192
      PRINT #2, MID$(ZLastDateTimeOn$, 1, 2) + "/" + _               'ER 06/05/92
                MID$(ZLastDateTimeOn$, 4 ,2) + "/" + _               'ER 06/05/92
                MID$(ZLastDateTimeOn$, 7 ,2)                         'ER 06/05/92
      ZZ$ = STR$(VAL(ZDoorTime$) * 60)                               ' DD092302/DOORSYS
      CALL Trim(ZZ$)                                                 'RT070192
      PRINT #2, ZZ$                                            '(18) 'RT070192
      PRINT #2, ZDoorTime$                                     '(19) ' DD092302/DOORSYS
      IF ZWasGR = 2 THEN _                                     '(20) 'ER 05/30/92
         PRINT #2, "GR" _                                            'ER 05/30/92
      ELSE PRINT #2, "NG"                                            'ER 05/30/92
      ZZ$ = STR$(ZPageLength)                                        'RT070192
      CALL Trim(ZZ$)                                                 'RT070192
      PRINT #2, ZZ$                                            '(21) 'RT070192
      IF ZExpertUser THEN _                                    '(22) ' DD092302/DOORSYS
         PRINT #2, "Y" _                                             ' DD092302/DOORSYS
      ELSE PRINT #2, "N"                                             ' DD092302/DOORSYS
      PRINT #2, ""       'Conferences registered in            '(23) ' DD092302/DOORSYS
      ZZ$ = ZConfName$                                               ' DD092302/DOORSYS
      CALL Trim (ZZ$)                                                ' DD092302/DOORSYS
      PRINT #2, ZZ$                                            '(24) ' DD092302/DOORSYS
      PRINT #2, ZExpirationDate$                               '(25) ' DD092302/DOORSYS
      ZZ$ = STR$(ZUserFileIndex)                                     'RT070192
      CALL Trim(ZZ$)                                                 'RT070192
      PRINT #2, ZZ$                                            '(26) 'RT070192
      PRINT #2, ZUserXferDefault$                              '(27) ' DD092302/DOORSYS
      ZZ$ = STR$(ZUplds)                                             'RT070192
      CALL Trim(ZZ$)                                                 'RT070192
      PRINT #2, ZZ$                                            '(28) 'RT070192
      ZZ$ = STR$(ZDnlds)                                             'RT070192
      CALL Trim(ZZ$)                                                 'RT070192
      PRINT #2, ZZ$                                            '(29) 'RT070192
      ZZ$ = STR$(ZBytesToday!)                                       'RT070192
      CALL Trim(ZZ$)                                                 'RT070192
      PRINT #2, ZZ$                                            '(30) 'RT070192
      IF ZByteMethod = 3 THEN _                                      ' DD092302/DOORSYS
         Today# = ZRatioRestrict# - ZBytesToday! - ZNumDnldBytes! : _' DD092302/DOORSYS
         ZZ$ = STR$(Today#) : _                                      ' DD092302/DOORSYS
         CALL Trim(ZZ$) : _                                          ' DD092302/DOORSYS
         PRINT #2, ZZ$ _                                             ' DD092302/DOORSYS
      ELSE PRINT #2, ""                                              ' DD092302/DOORSYS
      PRINT #2, ""         'Callers birthday mm/dd/yy          '(32) ' DD092302/DOORSYS
      CALL BreakFileName (ZMainUserFile$,Drive$,filename$,extension$,ZFalse) ' DD092302/DOORSYS
      PRINT #2, Drive$                                         '(33) ' DD092302/DOORSYS
      PRINT #2, ""   'Path to GEN Directory                    '(34) ' DD092302/DOORSYS
      PRINT #2, ZSysopFirstName$                               '(35) ' DD092302/DOORSYS
      PRINT #2, OrigFirstName$ + " " + ZLastName$              '(36) ' Pe021393
      PRINT #2, ""   'Event Time        (hh:mm)                '(37) ' DD092302/DOORSYS
      IF ZReliableMode = -1 THEN _                             '(38) 'ER 06/17/92
         PRINT #2, "Y" _                                             'ER 06/05/92
      ELSE PRINT #2, "N"                                             'ER 06/05/92
      PRINT #2, ""       'ANSI Supported but caller is NG (Y,N)'(39) 'ER 06/09/92
      IF ZShareIt THEN _                                       '(40) ' DD092302/DOORSYS
         PRINT #2, "Y" _                                             ' DD092302/DOORSYS
      ELSE PRINT #2, "N"                                             ' DD092302/DOORSYS
      PRINT #2, ""       'BBS Default color     (1-15)         '(41) 'ER 06/09/92
      ZZ$ = STR$(ASC(ZBankTime$))                                    'RT070192
      CALL Trim(ZZ$)                                                 'RT070192
      PRINT #2, ZZ$                                            '(42) 'RT070192
      ZZ$ = RIGHT$(STR$(ASC(MID$(ZListNewDate$,2))),2) + _ '(43)     ' DD092302/DOORSYS
                "/" + _                                              ' DD092302/DOORSYS
                RIGHT$(STR$(ASC(MID$(ZListNewDate$,3))),2) + _       ' DD092302/DOORSYS
                "/" + _                                              ' DD092302/DOORSYS
                RIGHT$(STR$(ASC(ZListNewDate$)),2)                   ' DD092302/DOORSYS
      CALL Trim (ZZ$)                                                ' DD092302/DOORSYS
      PRINT #2, ZZ$                                                  ' DD092302/DOORSYS
      PRINT #2, LEFT$(ZTimeLoggedOn$, 5)                       '(44) 'ER 06/05/92
      PRINT #2, RIGHT$(ZLastDateTimeOnSave$, 5)                '(45) 'ER 06/05/92
      PRINT #2, ""       'Max daily files limit                '(46) ' DD092302/DOORSYS
      ZZ$ = STR$(ZDLToday!)                                          'RT070192
      CALL Trim(ZZ$)                                                 'RT070192
      PRINT #2, ZZ$                                            '(47) 'RT070192
      ZZ$ = STR$(ZULBytes!/1000)                                     'RT070192
      CALL Trim(ZZ$)                                                 'RT070192
      PRINT #2, ZZ$                                            '(48) 'RT070192
      ZZ$ = STR$(ZDLBytes!/1000)                                     'RT070192
      CALL Trim(ZZ$)                                                 'RT070192
      PRINT #2, ZZ$                                            '(49) 'RT070192
      PRINT #2, "RBBS-PC is the Best!"                         '(50) 'ER 06/05/92
      PRINT #2, ""      'Total Doors opened                    '(51) ' DD092302/DOORSYS
      PRINT #2, ""      'Total Messages left                   '(52) ' DD092302/DOORSYS
      CLOSE 2                                                        ' DD091701/DOORSYS
      END SUB                                                        'ER 06/17/92
' $SUBTITLE: 'ReadDoorSys - Reads a DOOR.SYS drop file'              ' DD091101
' $PAGE                                                              ' DD091101
'                                                                    ' DD091101
'  SUBPROGRAM NAME    -- ReadDoorSys  - by Dan Drinnon 1993          ' DD091101
'                                                                    ' DD091101
'  INPUT PARAMETERS   --     PARAMETER                    MEANING    ' DD091101
'                                                                    ' DD091101
'                                                                    ' DD091101
'  OUTPUT PARAMETERS  --     ZUserSecLevel                           ' DD091101
'                            ZUplds                                  ' DD091101
'                            ZDnlds                                  ' DD091101
'                            ZBytesToday!                            ' DD091101
'                            ZBankTime$                              ' DD091101
'                            ZDLToday!                               ' DD091101
'                            ZULBytes!                               ' DD091101
'                            ZDLBytes!                               ' DD091101
'                                                                    ' DD091101
'  SUBPROGRAM PURPOSE --  Update Users Record From DOOR.SYS          ' DD091101
'                                                                    ' DD091101
' SecurityLevel (15), Total Uploads (28), Total Downloads (29),      ' DD091101
' Daily Download "K" Total (30) Time Credits (42), Files DL today (47),' DD091101
' Total "K" Uploaded (48), and Total "K" DL (49) can be modified by a ' DD091101
' Door, so let RBBS read back in the values!                         ' DD091101
'                                                                    ' DD091101
70005 SUB ReadDoorSys STATIC                                         ' DD091101
'                                                                    ' DD091101
      CALL OpenWork (2,ZNodeWorkDrvPath$+"DOOR.SYS")                 ' DD091101
      IF ZErrCode = 52 THEN _                                        ' DD091101
         EXIT SUB                                                    ' DD091101
      FOR I = 1 TO 15                                                ' DD012702
         CALL ReadDir (2,1)                                          ' DD091101
      NEXT I                                                         ' DD091101
      OldVal = ZUserSecLevel                                         ' DD012702
      ZUserSecLevel = VAL (ZOutTxt$)                                 ' DD091101
      IF OldVal <> ZUserSecLevel THEN _                              ' DD012702
         CALL UpdtCalr ("Door set Security Level From" + _           ' DD012702
              STR$(OldVal) +" to" + STR$(ZUserSecLevel),2) : _       ' DD012702
         CALL MenuPlus (10) : _                                      ' MENU1748
         ZAdjustedSecurity = ZTrue : _                               ' DD012702
         ZUserSecSave = ZUserSecLevel : _                            ' DD012702
         IF (NOT ZConfMode) AND (NOT ZSubBoard) THEN _               ' DD012702
             ZOrigSec = ZUserSecLevel                                ' DD012702
      MID$(ZUserRecord$,47,2) = MKI$(VAL(ZOutTxt$)) ' sec. level (15)' DD012702
      FOR I = 16 TO 28                                               ' DD091101
         CALL ReadDir (2,1)                                          ' DD012702
      NEXT I                                                         ' DD091101
      ZZ$ = ZOutTxt$                                                 ' DD012702
      CALL Trim (ZZ$)                                                ' DD012702
      MID$(ZUserRecord$,125,2) = MKI$(VAL(ZZ$)) 'total uploads   (28)' DD012702
      CALL ReadDir (2,1)                                             ' DD091101
      ZZ$ = ZOutTxt$                                                 ' DD012702
      CALL Trim (ZZ$)                                                ' DD012702
      MID$(ZUserRecord$,123,2) = MKI$(VAL(ZZ$)) 'total downloads (29)' DD012702
      CALL ReadDir (2,1)                                             ' DD012702
      ZZ$ = ZOutTxt$                                                 ' DD012702
      CALL Trim (ZZ$)                                                ' DD012702
      MID$(ZUserRecord$,94,4) = MKS$(VAL(ZZ$))  'bytes dnld today(30)' DD012702
      FOR I = 31 TO 42                                               ' DD012702
         CALL ReadDir (2,1)                                          ' DD091101
      NEXT I                                                         ' DD091101
      ZZ$ = ZOutTxt$                                                 ' DD012702
      CALL Trim (ZZ$)                                                ' DD012702
      MID$(ZUserRecord$,89,1) = CHR$(VAL(ZZ$))  ' banked time    (42)' DD012702
      FOR I = 43 TO 47                                               ' DD012702
         CALL ReadDir (2,1)                                          ' DD091101
      NEXT I                                                         ' DD091101
      ZZ$ = ZOutTxt$                                                 ' DD012702
      CALL Trim (ZZ$)                                                ' DD012702
      MID$(ZUserRecord$,90,4) = MKS$(VAL(ZZ$))  ' files dl today (47)' DD012702
      CALL ReadDir (2,1)                                             ' DD012702
      ZZ$ = ZOutTxt$                                                 ' DD012702
      CALL Trim (ZZ$)                                                ' DD012702
      MID$(ZUserRecord$,102,4) = MKS$(VAL(ZZ$)*1000)' total kbytes uploaded (48)' DD012702
      CALL ReadDir (2,1)                                             ' DD012702
      ZZ$ = ZOutTxt$                                                 ' DD012702
      CALL Trim (ZZ$)                                                ' DD012702
      MID$(ZUserRecord$,98,4) = MKS$(VAL(ZZ$)*1000) ' total kbytes downloaded (49)' DD012702
      CLOSE 2                                                        ' DD091101
      END SUB                                                        ' DD091101
'                                                                    ' DD121702
70010 SUB PCBoardSys STATIC                                          ' DD121702
'                                                                    ' DD121702
      CALL TimeRemain (MinsRemaining)                                ' DD121702
      CLOSE 2                                                        ' DD121702
      OPEN ZNodeWorkDrvPath$ + "PCBOARD.SYS" FOR RANDOM AS #2 LEN = 128' DD121702
      FIELD #2, 128 AS CONTENTS$                                     ' DD121702
      Template$ = STRING$(128,32)                                    ' DD121702
      IF ZSnoop THEN _                                               ' DD121702
         MID$(Template$,1,2) = "-1" _                                ' DD121702
      ELSE MID$(Template$,1,2) = " 0"                                ' DD121702
      IF ZPrinter THEN _                                             ' DD121702
         MID$(Template$,3,2) = "-1" _                                ' DD121702
      ELSE MID$(Template$,3,2) = " 0"                                ' DD121702
      IF ZSysopAvail THEN _                                          ' DD121702
         MID$(Template$,5,2) = "-1" _                                ' DD121702
      ELSE MID$(Template$,5,2) = " 0"                                ' DD121702
      MID$(Template$,7,2) = " 0"                                     ' DD121702
      IF ZSysop THEN _                                               ' DD121702
         MID$(Template$,9,1) = "X" _                                 ' DD121702
      ELSE MID$(Template$,9,1) = "N"                                 ' DD121702
      IF ZReliableMode THEN _                                        ' DD121702
         MID$(Template$,10,2) = "-1" _                               ' DD121702
      ELSE MID$(Template$,10,2) = " 0"                               ' DD121702
      ZZ$ = "N"                                                      ' DD121702
      IF ZWasGR > 1 THEN _                                           ' DD121702
         ZZ$ = "Y"                                                   ' DD121702
      IF INSTR(ZBaudParity$, ",7") THEN _                            ' DD121702
         ZZ$ = "7"                                                   ' DD121702
      MID$(Template$,12,1) = ZZ$                                     ' DD121702
      IF ZAvailableForChat THEN _                                    ' DD121702
         MID$(Template$,13,1) = "A" _                                ' DD121702
      ELSE MID$(Template$,13,1) = "U"                                ' DD121702
      MID$(Template$,14,5) = RIGHT$(ZTalkToModemAt$,5)               ' DD121702
      IF ZLocalUser THEN _                                           ' DD121702
         MID$(Template$,19,5) = "local" _                            ' DD121702
      ELSE MID$(Template$,19,5) = RIGHT$(ZCBaud$,5)                  ' DD121702
      LSET temp$ = MKI$(VAL(ZUserRecord$))                           ' DD121702
      MID$(Template$,24,2) = temp$                                   ' DD121702
      MID$(Template$,26,15) = LEFT$(OrigFirstName$,15)               'Pe021393
      MID$(Template$,41,12) = LEFT$(ZPswdSave$,12)                   ' DD121702
      MID$(Template$,53,2) = MKI$(ZStartTime)                        ' DD121702
      MID$(Template$,55,2) = MKI$(ZElapsedTime)                      ' DD121702
      MID$(Template$,57,5) = LEFT$(ZTimeLoggedOn$,5)                 ' DD121702
      MID$(Template$,62,2) = MKI$(ZTempTimeAllowed)                  ' DD121702
      IF ZGlobalSysop THEN _                                         ' DD121702
         UserName$ =  ZSysopFirstName$ + " " + ZSysopLastName$ _     ' DD121702
      ELSE UserName$ =  OrigFirstName$ + " " + ZLastName$            'Pe021393
      MID$(Template$,85,25) = LEFT$(UserName$,25)                    ' DD121702
      pcboardtime = VAL(ZDoorTime$)                                  ' DD121702
      IF pcboardtime > 99 THEN _                                     ' DD121702
         pcboardtime = 99                                            ' DD121702
      min$ = "  "                                                    ' DD121702
      LSET min$ = MKI$(pcboardtime)                                  ' DD121702
      MID$(Template$,110,2) = min$                                   ' DD121702
      ZZ$ = ZNodeID$                                                 ' DD121702
      CALL Trim (ZNodeID$)                                           ' DD121702
      MID$(Template$,112,1) = LEFT$(ZNodeID$,1)                      ' DD121702
      MID$(Template$,126,1) = MID$(ZComPort$,4,1)                    ' DD121702
      LSET CONTENTS$ = Template$                                     ' DD121702
      PUT 2,1                                                        ' DD121702
      CLOSE #2                                                       ' DD121702
      END SUB                                                        ' DD121702
'                                                                    ' DD121702
70020 SUB CallInfoBBS STATIC                                         ' DD121702
'                                                                    ' DD121702
      CALL TimeRemain(MinRemaining)                                  ' DD121702
      OPEN ZNodeWorkDrvPath$ + "CALLINFO.BBS" FOR OUTPUT AS #2       ' DD121702
      PRINT #2, OrigFirstName$ + " " + ZLastName$                    'Pe021393
      baudcode = 3                                                   ' DD121702
      baudrate = VAL(ZCBaud$)                                        ' DD121702
      IF baudrate = 2400 THEN _                                      ' DD121702
         baudcode = 0                                                ' DD121702
      IF baudrate = 300 THEN _                                       ' DD121702
         baudcode = 1                                                ' DD121702
      IF baudrate = 1200 THEN _                                      ' DD121702
         baudcode = 2                                                ' DD121702
      IF baudrate = 19200 THEN _                                     ' DD121702
         baudcode = 4                                                ' DD121702
      ZZ$ = STR$(baudcode)                                           ' DD010302
      CALL Trim (ZZ$)                                                ' DD010302
      PRINT #2, ZZ$                                                  ' DD010302
      PRINT #2, ZWasCI$                                              ' DD121702
      ZZ$ = STR$(ZUserSecLevel)                                      ' DD121702
      CALL Trim(ZZ$)                                                 ' DD121702
      PRINT #2, ZZ$                                                  ' DD121702
      PRINT #2, ZDoorTime$                                           ' DD121702
      IF ZWasGR > 1 THEN                                             ' DD121702
         PRINT #2, "COLOR"                                           ' DD121702
      ELSE                                                           ' DD121702
         PRINT #2, "MONO"                                            ' DD121702
      END IF                                                         ' DD121702
      PRINT #2, ZPswdSave$                                           ' DD121702
      ZZ$ = STR$(ZUserFileIndex)                                     ' DD121702
      CALL Trim(ZZ$)                                                 ' DD121702
      PRINT #2, ZZ$                                                  ' DD121702
      CALL GetTime                                                   ' DD121702
      ZZ$ = STR$(ZSessionMin)                                        ' DD010302
      CALL Trim (ZZ$)                                                ' DD010302
      PRINT #2, ZZ$                                                  ' DD010302
      PRINT #2, LEFT$(TIME$,5)                                       ' DD121702
      PRINT #2, LEFT$(ZTimeLoggedOn$, 5)                             ' DD121702
      PRINT #2, ""                         'conferences joined       ' DD121702
      PRINT #2, ""                         ' daily dl file total     ' DD121702
      PRINT #2, ""                         'max daily dl file limit  ' DD121702
      ZZ$ = STR$(ZBytesToday!)                                       ' DD121702
      CALL Trim(ZZ$)                                                 ' DD121702
      PRINT #2, ZZ$                        ' daily dl kb limit       ' DD121702
      IF ZByteMethod = 3 THEN _                                      ' DD121702
         Today# = ZRatioRestrict# - ZBytesToday! - ZNumDnldBytes! : _' DD121702
         ZZ$ = STR$(Today#) : _                                      ' DD121702
         CALL Trim(ZZ$) : _                                          ' DD121702
         PRINT #2, ZZ$ _                                             ' DD121702
      ELSE PRINT #2, ""                    ' max daily dl kb limit   ' DD121702
      PRINT #2, ""                         'user's phone number      ' DD121702
      PRINT #2, MID$(ZLastDateTimeOn$, 1, 2) + "/" + _               ' DD121702
                MID$(ZLastDateTimeOn$, 4 ,2) + "/" + _               ' DD121702
                MID$(ZLastDateTimeOn$, 7 ,2) 'don't know separator   ' DD121702
      IF ZExpertUser THEN _                                          ' DD121702
         PRINT #2, "EXPERT" _                                        ' DD121702
      ELSE PRINT #2, ""                    ' don't know novice       ' DD121702
      PRINT #2, ZUserXferDefault$                                    ' DD121702
      ZZ$ = RIGHT$(STR$(ASC(MID$(ZListNewDate$,2))),2) + _ '(43)     ' DD121702
                "/" + _                                              ' DD121702
                RIGHT$(STR$(ASC(MID$(ZListNewDate$,3))),2) + _       ' DD121702
                "/" + _                                              ' DD121702
                RIGHT$(STR$(ASC(ZListNewDate$)),2)                   ' DD121702
      CALL Trim (ZZ$)                                                ' DD121702
      PRINT #2, ZZ$                        ' don't know separator    ' DD121702                          ' DD121702
      ZZ$ = STR$(ZTimesLoggedOn)                                     ' DD121702
      CALL Trim(ZZ$)                                                 ' DD121702
      PRINT #2, ZZ$                                                  ' DD121702
      ZZ$ = STR$(ZPageLength)                                        ' DD121702
      CALL Trim(ZZ$)                                                 ' DD121702
      PRINT #2, ZZ$                                                  ' DD121702
      PRINT #2, ""                         'last msg read (not global)' DD121702
      ZZ$ = STR$(ZUplds)                                             ' DD121702
      CALL Trim(ZZ$)                                                 ' DD121702
      PRINT #2, ZZ$                                                  ' DD121702
      ZZ$ = STR$(ZDnlds)                                             ' DD121702
      CALL Trim(ZZ$)                                                 ' DD121702
      PRINT #2, ZZ$                                                  ' DD121702
      ZPosition% = INSTR(ZBaudParity$, "N,")                         ' DD121702
      PRINT #2, MID$(ZBaudParity$, ZPosition% + 2, 1)                ' DD121702
      IF ZLocalUser THEN _                                           ' DD121702
         PRINT #2, "LOCAL" _                                         ' DD121702
      ELSE PRINT #2, "REMOTE"                                        ' DD121702
      IF ZLocalUser THEN _                                           ' DD121702
         PRINT #2, "COM0" _                                          ' DD121702
      ELSE PRINT #2, ZComPort$                                       ' DD121702
      print #2, ""                         'birthday                 ' DD121702
      IF ZLocalUser THEN _                                           ' DD121702
         PRINT #2, "9600" _                                          ' DD121702
      ELSE PRINT #2, ZCBaud$                                         ' DD121702
      CLOSE #2                                                       ' DD121702
      END SUB                                                        ' DD121702
