' $linesize:132
' $title: 'FileSys.BAS 17.4, Copyright 1986 - 92 by D. Thomas Mack'
'  Copyright 1991 by D. Thomas Mack, all rights reserved.
'  Name ...............: FileSys.BAS
'  First Released .....: June 21, 1992
'  Subsequent Releases.: March 27, 1992 by Pete Eibl (moved to seperate sub)
'  Copyright ..........: 1986 - 1992
'  Purpose.............: The Remote Bulletin Board System for the IBM PC,
'     RBBS-PC.BAS utilizes a lot of common subroutines.  Those that do not
'     require error trapping are incorporated within RBBSSUB 2-5 as
'     separately callable subroutines in order to free up as much
'     code as possible within the 64K code segment used by RBBS-PC.BAS.
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
' Subroutine  Line               Function of Subroutine
'   Name     Number
'  CheckRatio     20096  Test upload/download ratio
'  CmndSysopXfer  64640  Sysop function to change Xfer count
'  ColorDir       59920  Adds colorization to FMS directory entry
'  FileSystem     20117  File System for RBBS-PC
'  FMS            58200  Search the upload management system for entries
'  GetArc         30140  Handle request for verbose listing
'  GetAll         59780  Get list of all directories to display
'  GetDirs        58895  Prompts for directories for file list/new/search cmds
'  Protocol       62600  Determine if external protocols are available
'  Transfer       62620  RBBS-PC support for external protocols for file transfer
'  TStats         69600  Display transfer stats from XFER-? file     ' MplXfer
'  BatchUpload
'  Batchit
'  AutoLogoff
'
'  $INCLUDE: 'RBBS-VAR.BAS'
'
20096 ' $SUBTITLE: 'CheckRatio - subroutine to print ul/dl ratio'
' $PAGE
'
'  NAME    -- CheckRatio
'
'  INPUTS  --   PARAMETER                    MEANING
'               TellUser           TELL USER THEIR RATIO
'               ZDnlds             FILES DOWNLOADED
'               ZDLBytes!          BYTES DOWNLOADED
'               ZUplds             FILES UPLOADED
'               ZULBytes!          BYTES UPLOADED
'
'  OUTPUTS --   ZOK                 -1 if okay to download, 0 otherwise
'
'  PURPOSE -- To determine whether the users violated
'             their upload to download restriction
'
      SUB CheckRatio (TellUser) STATIC
      ZOK = ZTrue
 IF ZFreeDnld or ZPersonalDnld THEN _     'Pe062301
       GOTO 20110
'
' Detemine method of ratio checking.  Look ahead to amount downloaded
'
      IF ZByteMethod = 1 OR ZByteMethod = 3 THEN _
         Method$ = "Bytes" : _
         ULWork# = ZULBytes! : _
         DLWork# = ZDLBytes! + ZNumDnldBytes!
      IF ZByteMethod = 0 OR ZByteMethod = 2 THEN _
         Method$ = "Files" : _
         ULWork# = ZUplds : _
         DLWork# = ZDnlds + ZDownFiles
      IF ULWork# < ZInitialCredit# THEN _
         ULWork# = ZInitialCredit#
      IF ZByteMethod = 2 THEN _
         Today# = ZRatioRestrict# - ZDLToday! - ZDownFiles
      IF ZByteMethod = 3 THEN _
         Today# = ZRatioRestrict# - ZBytesToday! - ZNumDnldBytes!
'
      Ratio# = 0
      RatioSuffix$ = ":0"
      IF ULWork# > 0 THEN _
         Ratio# = (DLWork# / ULWork#) : _
         RatioSuffix$ = ":1"
      IF ZByteMethod > 1 THEN _
 ZOutTxt$ =  "Today's Downloaded Files: " + STR$(ZDLToday! + ZDownFiles)+ZCrLf$ + _
             "Number of Bytes Today  : " + STR$(ZBytesToday! + ZNumDnldBytes!) : _
         ZSubParm = 5 : _
         CALL TPut : _
         CALL SkipLine (1) : _
         GOTO 20100
      WasX$ = STR$(Ratio#)
      X = INSTR(WasX$,".")
      IF X > 0 THEN _
         WasX$ = LEFT$(WasX$,X+1)
ZOutTxt$ = ZFG1$ + Method$ + " Downloaded: " + ZFG2$ +STR$(DLWork#)+ZCrLf$+ _
           ZFG3$ + Method$ + " Uploaded  : " + ZFG2$ +STR$(ULWork#) + ZCrLf$
ZOutTxt$ = ZoutTxt$ +  ZFG4$ + "Todays Downloaded Files: " + ZFG1$ + _
          STR$(ZDLToday! + ZDownFiles) + ZCrLf$ +"Ratio  : " +ZFG3$ + _
                             WasX$ + RatioSuffix$ +ZEmphasizeOff$
         ZSubParm = 5
         CALL TPut        'Pe 02/16/90
'
'  CHECK TO SEE IF THE USER HAS VIOLATED THEIR UL/DL RESTRICTION
'
20100   IF NOT ZEnforceRatios OR ZRatioRestrict# <= 0 THEN _
         GOTO 20110                                               'Pe 02/16/90
 IF NOT (ZRatioRestrict# > 0 AND TellUser) THEN _
         EXIT SUB
      IF ZByteMethod <= 1 THEN _
         GOTO 20105
      IF Today# < 0 THEN _
         ZOutTxt$ = "Sorry, Daily download limit of" + _
              STR$(ZRatioRestrict#) + " " + _
              Method$ + " Reached" : _
         ZOK = ZFalse : _
      CALL DelayTime (3) _  'Pe 02/03/90
      ELSE ZOutTxt$ = "Download balance:" + _
                STR$(Today#) + _
                " " + _
                Method$ : _
           ZOK = ZTrue
      ZSubParm = 5
      CALL TPut
      CALL SkipLine(1)
      EXIT SUB
'
20105 IF Ratio# > ZRatioRestrict# OR ULWork# = 0 THEN _
         ZOK = ZFalse : _
           ZOutTxt$ = "Sorry, DL/UL ratio of" + _
              STR$(ZRatioRestrict#) + _
              ":1 " + _
              Method$ + " exceeded" + CHR$(7) : _
         ZSubParm = 5 : _
         CALL TPut : _
         Call DelayTime (4) : _      'Pe 06/13/91
         ZOutTxt$ = "Minimum upload of" + _
              STR$(INT(((DLWork# - (ULWork# * ZRatioRestrict#)) _
              / ZRatioRestrict#) + 1)) + _
              + " " + Method$ + " required to download" _
      ELSE ZOutTxt$ = "Balance remaining before upload required:" + _
                STR$(INT((ULWork# * ZRatioRestrict#)-DLWork#)) + _
                " " + Method$
      ZSubParm = 5
      CALL TPut
     CALL SkipLine (1)
20110 END SUB

20117 ' $SUBTITLE: 'FileSystem -- subroutine for RBBS-PC's file system'
' $PAGE
'
' NAME    -- FileSystem
'
' INPUTS  --       PARAMETER                 MEANING
'             ZFileSysParm = 1  LIST THE SYSOP'S COMMENTS FILE
'                                 2  L)IST DIRECTORY COMMAND
'                                 3  D)OWNLOAD COMMAND
'                                 4  RETURN FROM EXTERNAL PROTOCOLS
'                                 5  U)PLOAD COMMAND
'                                 6  S)CAN DIRECTORY COMMAND
'                                 7  P)ERSONAL FILES COMMAND
'                                 8  N)EW FILES COMMAND
'                                 9  RETURN FROM EXTENDED DESCRIPTION
'                                 10  Batch Upload files
'
' OUTPUTS -- ZFileSysParm = 1  COMMAND PROCESSED SUCCESSFULLY
'                                2  RECYCLE TO TOP OF RBBS-PC (202)
'                                3  PROCESS NEXT COMMAND (1200)
'                                4  DENY USER ACCESS (1380)
'                                5  HANDLE EXTENDED DESCRIP. (2008)
'                                6  USER'S TIME EXCEEDED (10553)
'                                7  Carrier DROPPED (10595)
'
' PURPOSE -- To handle the RBBS-PC file system commands
'
      SUB FileSystem STATIC
      ZFF = ZFileSysParm
      ZFileSysParm = 1
      ZActiveFMSDir$ = ""
      CALL SaveUserActivity("F", ZNodeRecIndex, ZFalse)              ' CHAT0813
      ON ZFF GOSUB 20119, _  ' HANDLER TO LIST COMMENTS TO SYSOP
                  20150, _  ' L)IST DIRECTORY COMMAND HANDLER
                  20180, _  ' D)OWNLOAD COMMAND HANDLER
                  20263, _  ' RETURN FROM EXTERNAL Protocol'S
                  20400, _  ' U)PLOAD COMMAND HANDLER
                  21800, _  ' S)CAN DIRECTORY COMMAND HANDLER
                  21850, _  ' P)ERSONAL FILES COMMAND HANDLER
                  21860, _  ' N)EW FILES COMMAND HANDLER
                  20705, _  ' RETURN FROM EXTENDED DESCRIPTIONS
                  20410     ' 4)Batch Upload files
      CALL SaveUserActivity("F", ZNodeRecIndex, ZFalse) 'lk 032293
      GOTO 21920
20119 ZErrCode = 0
      GOTO 20122
'
' *****  SCAN DIRECTORIES (PRINT TEXT)  ****
'
'  (formerly lines 7000 to 7260 in RBBS-PC.BAS CPC16-1A
20120  X = 159             'Pe 01/19/93
       Gosub 21915         'Pe 01/19/93
       ZOutTxt$ = OutTxt$ + " " + _
           ZFileNameHold$
      IF WasRS$ <> "" THEN _
         ZOutTxt$ = ZOutTxt$ + " for " + WasRS$
      GOSUB 21650
      IF ZFileSysParm > 1 THEN _
         RETURN
      CALL AskMore ("",ZTrue,ZTrue,ZAnsIndex,ZFalse)
      IF ZNo THEN _
         ZErrCode = 0 : _
         RETURN
      WasPG = ZTrue
20122 CALL OpenWork (2,ZFileName$)
      IF ZErrCode = 53 THEN _
       X = 160 : _             'Pe 01/19/93
       Gosub 21915 : _         'Pe 01/19/93
         ZOutTxt$ = OutTxt$ + " " + ZFileName$ : _
         CALL UpdtCalr (ZOutTxt$,2) : _
         X = 161 : _             'Pe 01/19/93
         Gosub 21915 : _         'Pe 01/19/93
         ZOutTxt$ = ZOutTxt$ + OutTxt$ : _
         GOSUB 21650 : _
         RETURN
      ZJumpSupported = ZTrue
      ZJumpLast$ = ""
      LastOK = ZFalse
      ZJumpSearching = ZFalse
      MaxPrint = ZPageLength - 1
      CALL CmdStackPushPop (1)
      ZLastIndex = 0
20124 CALL Carrier
      IF EOF(2) OR _
         (ZSubParm = -1 AND NOT ZLocalUser) THEN _
         GOTO 20142
20126 CALL ReadDir (2,1)
      IF ZErrCode <> 0 THEN _
         ZWasEL = 20126 : _
         GOTO 21900
      IF LEFT$(ZOutTxt$,1) = " " THEN _
         IF LastOK AND NOT ZExtendedOff THEN _
            GOTO 20140 _
         ELSE GOTO 20124
      IF WasCK = 0 THEN _
         GOTO 20140
      LastOK = ZFalse
20128 IF ZJumpSearching THEN _
         GOTO 20129
      IF WasCK < 2 THEN _
         GOTO 20130
      IF WildSearch THEN _
         ZWasA = INSTR(ZOutTxt$," ") : _
         IF ZWasA = 0 THEN _
            GOTO 20124 _
         ELSE ZWasZ$ = LEFT$(ZOutTxt$,ZWasA - 1) : _
              CALL WildFile (WasRS$,ZWasZ$,WasXXX) : _
              WasXXX = NOT WasXXX : _
              GOTO 20136
20129 ZWasZ$ = ZOutTxt$
      CALL AllCaps (ZWasZ$)
      WasXXX = (INSTR(ZWasZ$,WasRS$) = 0)
      GOTO 20136
20130 ZWasA = INSTR(9,MID$(ZOutTxt$,1,32),"/")
      IF ZWasA = 0 THEN _
         ZWasA = INSTR(9,MID$(ZOutTxt$,1,32),"-")
20132 IF ZWasA < 3 THEN _
         GOTO 20124
      IF INSTR("0123456789",MID$(ZOutTxt$,ZWasA - 1,1)) = 0 THEN _
         GOTO 20124
      ZWasA = ZWasA - 2
      WasWK$ = RIGHT$(MID$(ZOutTxt$,ZWasA,8),2) + _
            LEFT$(MID$(ZOutTxt$,ZWasA,8),2) + _
            MID$(MID$(ZOutTxt$,ZWasA,8),4,2)
      IF MID$(WasWK$,3,1) = " " THEN _
         MID$(WasWK$,3,1) = "0"
      IF MID$(WasWK$,5,1) = " " THEN _
         MID$(WasWK$,5,1) = "0"
20134 WasXXX = (WasWK$ < WasRS$)
20136 IF WasXXX THEN _
         GOTO 20124
      IF ZJumpSearching THEN _
         WasRS$ = PrevSearch$ : _
         WasCK = PrevCK : _
         ZJumpSearching = ZFalse : _
         GOTO 20140
      IF WasPG THEN _
         WasPG = ZFalse : _
         CALL OpenWork (2,ZFileName$) : _
         ZWasQ = 0 : _
         GOTO 20124
20138 IF WasPG THEN _
         GOTO 20124
20140 LastOK = ZTrue
      GOSUB 21650
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZLinesPrinted > MaxPrint THEN _
         ZTurboKey = -ZTurboKeyUser : _
         CALL AskMore (",M)ark",ZTrue,ZTrue,ZAnsIndex,ZFalse) : _
         IF ZNo THEN _
            ZErrCode = 0 : _
            RETURN _
         ELSE Temp$ = ZUserIn$(1) : _
              CALL AskItems ("M",Temp$,ZTrue,"file",ZMarkedFiles$) : _
              ZUserIn$(1) = ""
      IF ZJumpSearching THEN _
         IF LEFT$(ZOutTxt$,1) <> " " THEN _
            PrevSearch$ = WasRS$ : _
            PrevCK = WasCK : _
            WasCK = 2 : _
            WasRS$ = ZJumpTo$
      IF NOT ZRet THEN _
         GOTO 20124
20142 ZWasQ = 0
      CALL CmdStackPushPop (2)
      ZJumpSupported = ZFalse
      CLOSE 2
      CALL Carrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7
      RETURN
'
' *  L - COMMAND FROM FILES MENU (LIST DIRECTORY)
'
20150 ZListDir = ZTrue
      ListNew = ZFalse
      SearchDate$ = ""
      SearchString$ = ""
      WasRS$ = ""
      ShowDirOfDir = (ZLastIndex <= ZAnsIndex) AND NOT ZExpertUser
      WasCK = 0
      ZSearchingAll = ZFalse
      ZExtendedOff = ZFalse 'ZTrue   'Pe 10/27/91
20155 IF ZDnldCompleted AND ZAutoEnd = 1 THEN _   'Pe 02/05/90
        ZFileSysParm = 7 : _
        RETURN
 IF ListNew OR ZAnsIndex > 255 THEN _   'Pe 12/12/91
         RETURN                         'Pe 12/12/91
      CALL GetDirs (ZFalse)    'Pe 02/04/90
      IF ZWasQ = 0 THEN _
         RETURN
      ShowDirOfDir = ZFalse
      CALL ConvertDir (ZAnsIndex)
      WasQX = ZLastIndex
20157 CALL Carrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
      GOTO 20161
20159 IF ZAnsIndex < ZLastIndex THEN _
         GOTO 20155
      ZSearchingAll = ZFalse
      CALL CmdStackPushPop (1)
      ZLastIndex = 0
      IF ZNo OR InFMS OR (ZFileNameHold$ = ZDirPrefix$) THEN _
         GOTO 20155
      GOSUB 20177                                                    ' DD030301/WILD
      CALL QuickTPut (ZEmphasizeOff$,0)
      ZTurboKey = - ZTurboKeyUser
       X = 162              'Pe 01/19/93
       Gosub 21915         'Pe 01/19/93
       ZOutTxt$ = OutTxt$
      GOSUB 21667
      CALL AraAllCaps (ZUserIn$(),1)
'******************************* Pe 02/15/90 **********************
     IF ZUserIn$(1) = "T"  AND _
         ZUserSecLevel >= ZOptSec(19 - 20 * (ZMenuIndex = 6)) THEN _
         ZAnsIndex = 1 : _   
        CALL TypeFile : _
       RETURN
     IF ZUserIn$(1) = "V"  AND _
         ZUserSecLevel >= ZOptSec(19 - 20 * (ZMenuIndex = 6)) THEN _
         ZAnsIndex = 1 : _   
        CALL GetArc : _
       RETURN
'******************************************************************
      IF ZUserIn$(1) = "L" THEN _
         ZUserIn$(ZAnsIndex) = WasA1$ : _
        GOTO 20161
      Temp$ = ZUserIn$(1)
      Temp = (ZUserIn$(1) = "D")
      CALL AskItems ("MD",Temp$,ZTrue,"file",ZMarkedFiles$)
      IF ZWasQ = 0 OR ZUserSecLevel < ZOptSec(19 - 20 * (ZMenuIndex = 6)) THEN _
         GOTO 20160
      IF Temp THEN _
         GOSUB 20202 _
      ELSE IF LEN(ZUserIn$(1)) > 1 THEN _
         ZAnsIndex = 1 : _
         GOSUB 20202
20160 CALL CmdStackPushPop (2)
      RETURN
20161 IF INSTR(ZUserIn$(ZAnsIndex),".") THEN _
         GOTO 20172
      ZViolation$ = "List Dir. "
      ZWasZ$ = ZUserIn$(ZAnsIndex)
      ZWasA = INSTR("E+E-E",ZWasZ$)
      IF ZWasA > 0 THEN _
         IF ZWasA = 5 THEN _
            ZExtendedOff = NOT ZExtendedOff : _
            GOTO 20155 _
         ELSE ZExtendedOff = (ZWasA > 2) : _
              GOTO 20155
      CALL AllCaps(ZWasZ$)
      ZFileNameHold$ = ZWasZ$
      WasA1$ = ZWasZ$
      IF ZWasZ$ = ZDirPrefix$ THEN _
         GOTO 20164
      InFMS = ZFalse
20162 CALL CmdStackPushPop (1)         ' save dir list list processing
      CALL FMS (ZWasZ$,SearchString$,SearchDate$,InFMS, _
                ZCategoryName$(),ZCategoryCode$(),ZCategoryDesc$(),_
                DnldFlag,CatFound,ZAnsIndex)
      WHILE DnldFlag > 0 AND ZSubParm > -1
         GOSUB 20202
         IF ZFileSysParm > 1 THEN _
            RETURN
        IF ZDnldCompleted and ZAutoEnd = 1 THEN _  'Pe 02/05/90
           RETURN       ' AUTOLOGOFF MOD
         WasX$ = ZCategoryCode$(CatFound)
         CALL DispUpDir (WasX$,SearchString$,SearchDate$,DnldFlag,ZAnsIndex)
         CALL CheckTimeRemain (MinsRemaining)
         IF ZSubParm = -1 THEN _
            ZFileSysParm = 6 : _
            RETURN
         CALL Carrier
      WEND
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
      IF ZAnsIndex > 255 OR ZRet THEN _
         ZLastIndex = 0 : _
         RETURN
      CALL CmdStackPushPop (2)        ' restore dir list list processing
      ZActiveFMSDir$ = ""
      IF InFMS THEN _
         GOTO 20159
      IF ZUserSecLevel < ZMinSecToView THEN _
         IF ZFileNameHold$ = ZUpldDirCheck$ THEN _
       X = 163 : _             'Pe 01/19/93
       Gosub 21915 : _        'Pe 01/19/93
       ZOutTxt$ = OutTxt$ : _
        GOSUB 21640 : _                                           'DGS-TXT
        ZNo = ZTrue : _                                           'DGS-TXT
        GOTO 20155                                                'DGS-TXT
      ZFileNameHold$ = ZUserIn$(ZAnsIndex)
      IF ZLimitSearchToFMS THEN _
         GOTO 20166
      IF NOT ZSearchingAll THEN _
         IF ZFileNameHold$ = "ALL" OR ZFileNameHold$ = "A" THEN _
            ZSearchingAll = ZTrue : _
            GOSUB 21890 : _
            GOTO 20157
      CALL BadFile (ZFileNameHold$,BadFileNameIndex)
      ON BadFileNameIndex GOTO 20163,20172,20176
20163 ZFileName$ = ZFileNameHold$
      CALL BadName (BadFileNameIndex,ZTrue)
      ON BadFileNameIndex GOTO 20164,20176
20164 IF ZFileName$ = ZUpldDirCheck$ AND _
         ZUserSecLevel >= ZMinSecToView THEN _
            ZFileName$ = ZUpldPath$ _
      ELSE ZFileName$ = ZCurDirPath$
      ZFileName$ = ZFileName$ + _
                   ZFileNameHold$ + _
                   "." + _
                   ZDirExtension$
      CALL Graphic (ZFileName$)
20165 IF ZOK THEN _
         CALL ReadDir (2,1) : _
         IF ZErrCode = 0 THEN _
            IF LEFT$(ZOutTxt$,4) = "\FMS" THEN _
               InFMS = ZTrue : _
               ZActiveFMSDir$ = ZFileName$ : _
               GOTO 20162 _
            ELSE GOTO 20167
20166 ZFileName$ = ZCurDirPath$ + _
                   ZFileNameHold$ + ".MNU"
      CALL FindIt (ZFileName$)
      IF ZOK THEN _
         CALL BufFile (ZFileName$,ZAnsIndex) : _
         GOTO 20155
      IF ZAltdirExtension$ = "" THEN _
         GOTO 20172
      ZFileName$ = ZCurDirPath$ + _
                   ZFileNameHold$ + _
                   "." + _
                   ZAltdirExtension$
      CALL Graphic (ZFileName$)
      IF NOT ZOK THEN _
         GOTO 20172
20167 ZUserIn$(0) = ZUserIn$(ZAnsIndex)
      GOSUB 20120
      IF ZFileSysParm > 1 THEN _
         RETURN
      GOTO 20170
20168 CALL BufFile(ZFileName$,ZAnsIndex)
      CALL Carrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
20170 IF ZAnsIndex > 255 THEN _
         ZLastIndex = 0 : _
         RETURN
      ZUserIn$(ZAnsIndex) = ZUserIn$(0)
      GOTO 20159
20172 IF NOT ZSearchingAll THEN _
       X = 70 : _             'Pe 01/19/93
       Gosub 21915 : _         'Pe 01/19/93
         ZOutTxt$ = "Directory " + _
              ZFileNameHold$ + _
              OutTxt$ : _
         GOSUB 21640 : _
         ZNo = ZTrue : _
         IF ZFileSysParm > 1 THEN _
            RETURN
      GOTO 20155
20176 CALL SecViolation
      IF ZDenyAccess THEN _
         ZFileSysParm = 4 : _
         RETURN
      GOTO 20172
20177 ZListOnly = ZFalse                                             ' DD030301/WILD
      ZExtraDnldTime = 0
      ZFreeDnld = ZFalse
      ZPersonalDnld = ZFalse
      RETURN
'                                                                    ' DD030301/WILD
' * WildCard Download Support                                        ' DD030301/WILD
'                                                                    ' DD030301/WILD
20178   X = 319             'Pe 05/19/93
       Gosub 21915         'Pe 05/19/93
      ZOutTxt$ = OutTxt$
      ZTurboKey = - ZTurboKeyUser                                    ' DD030301/WILD
      GOSUB 21668                                                    ' DD030301/WILD
      IF ZNO THEN _                                                  ' DD030301/WILD
      CALL KillWork (ZNodeWorkDrvPath$+"WILDDOWN.DEF") : _           ' PE031302/WILD
         GOTO 20180                                                  ' DD030301/WILD
      CALL OpenWork (2,ZNodeWorkDrvPath$+"WILDDOWN.DEF")             ' DD030301/WILD
      DO WHILE NOT EOF(2)                                            ' DD030301/WILD
         CALL ReadDir (2,1)                                          ' DD030301/WILD
         CALL Trim (ZOutTxt$)                                        ' DD030301/WILD
         ZFileName$ = ZOutTxt$                                       ' DD030301/WILD
         IF ZFileName$ = "" THEN EXIT DO                             ' DD030301/WILD
         ZOutTxt$ = "Mark " + ZFileName$ + _                         ' DD030301/WILD
                    SPACE$(13-LEN(ZFileName$)) + _                   ' DD030301/WILD
                    " (Y)es,[N]o,A)bort)"                            ' DD030301/WILD
         ZTurboKey = - ZTurboKeyUser                                 ' DD030301/WILD
         GOSUB 21668                                                 ' DD030301/WILD
         CALL AllCaps(ZUserIn$)                                      ' DD030301/WILD
         IF LEFT$(ZUserIn$,1) = "A" THEN _                           ' DD030301/WILD
            GOTO 20179                                               ' DD030301/WILD
         IF ZYes THEN                                                ' DD032301
            IF ZMarkedFiles$ = "" THEN                               ' DD032301
               ZMarkedFiles$ = ZFileName$ + CHR$(13)                 ' DD032301
            ELSE                                                     ' DD032301
               IF INSTR(ZMarkedFiles$,ZFileName$) = 0 THEN           ' DD032301
                  ZMarkedFiles$ = ZMarkedFiles$ + ZFileName$ + CHR$(13) ' DD030301/WILD
               END IF                                                ' DD032301
            END IF                                                   ' DD032301
         END IF                                                      ' DD032301
      LOOP                                                           ' DD030301/WILD
      CLOSE 2                                                        ' DD030301/WILD
20179  If Found THEN                                           'Pe031793
       X = 320             'Pe 05/19/93
       Gosub 21915         'Pe 05/19/93
      ZOutTxt$ = ZCRLF$ + OutTxt$
      ZTurboKey = - ZTurboKeyUser                              ' lk 030993
      GOSUB 21668                                              ' lk 030993
      IF ZYES THEN _                                           ' lk 030993
         GOTO 20178                                            ' lk 030993
      End If                                                   'Pe031893
      CALL KillWork (ZNodeWorkDrvPath$+"WILDDOWN.DEF")               ' DD030301/WILD
      ZOutTxt$ = ""                                                  ' DD030301/WILD
      ZOK = ZFalse                                                   ' DD030301/WILD
      ZAutoLogoffReq = ZFalse                                        ' DD030301/WILD
'
' *  D - COMMAND FROM FILES MENU (SEARCH FOR FILE TO DOWNLOAD)
'
20180 Temp$ = "D"
      CALL AskItems ("D",Temp$,ZFalse,"file",ZMarkedFiles$)
      GOSUB 20177                                                    ' DD030301/WILD
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZWasQ = 0 THEN _
         RETURN
20202 IF (ZTimeLock AND 2) AND (NOT TimeLockExempt) AND NOT ZHasPrivDoor THEN _
         CALL TimeLock : _
         IF NOT ZOK THEN _
            RETURN
      LastDnld = ZLastIndex
      FirstDnld = ZAnsIndex
      ZCmdTransfer$ = ""
      ZAnsIndex = ZLastIndex
      GOSUB 20470
      LastDnld = LastDnld + (WasX > 0)
      BatchBytes# = 0
      BatchBlocks# = 0
      ZDownFiles = 0
      CALL KillWork (ZNodeWorkFile$)
      ZErrCode = 0
      ZAnsIndex = FirstDnld
      CALL SaveUserActivity("D", ZNodeRecIndex, ZFalse)  'lk 032293
20203 IF ZAnsIndex > LastDnld THEN _
            GOTO 20204
         GOSUB 20470
         GOSUB 20205
         IF ReStart THEN _
            ReStart = ZFalse : _
            GOTO 20202
         ZCmdTransfer$ = ZWasFT$
         CALL Line25
         IF ZFileSysParm > 1 OR ZInternalProt$ = "N" THEN _
            GOTO 20204
      ZAnsIndex = ZAnsIndex + 1
      GOTO 20203
20204 ZLastIndex = 0
      IF ZFileSysParm > 1 THEN _
         RETURN
      ZBatchTransfer = ZFalse
      ZCmdTransfer$ = ""
      RETURN
20205 MarkingTime = (ZAnsIndex = FirstDnld OR NOT ZConcatFIles)
      ZFileName$ = ZUserIn$(ZAnsIndex)
      CALL AllCaps(ZFileName$)                                       'ANSIEd
      CALL Remove (ZFileName$,", ")
      ZViolation$ = "Download "
      IF ZListOnly THEN _
         CALL BreakFileName (ZFileName$,DR$,ZWasY$,WasX$,ZTrue) : _
         ZFileNameHold$ = ZWasY$ + _
                           WasX$ : _
         GOTO 20235
      ZFileNameHold$ = ZFileName$
'                                                                    ' DD030301/WILD
' * WildCard Download Support                                        ' DD030301/WILD
'                                                                    ' DD030301/WILD
20208 IF INSTR(ZFileName$,"*") <> 0 THEN                             ' DD030301/WILD
         IF ZWildDownOK AND NOT ZPersonalDnld THEN                   ' DD031803/WILD
            ZLastIndex = 1
            LastDnld = 1
     CALL WildDown(ZFileName$, ZMarkedFiles$, ZFastFileList$, Found) ' DD030301/WILD
            IF Found THEN
               GOTO 20178
            ELSE GOTO 20179
            END IF
         END IF                                                      ' DD030301/WILD
      END IF                                                         ' DD030301/WILD
      TmpFileNameHold$ = ZFileNameHold$                            'Pe 04/25/92
      CALL BadFile (ZFileName$,BadFileNameIndex)
      ON BadFileNameIndex GOTO 20220,20231,20233

20210 CALL RotorsDir (ZFileName$,ZSubDir$(),ZSubDirCount + _      'Pe 06/01/92
                      ((ZUserSecLevel < ZMinSecToView) OR _       'Pe 06/01/92
                       NOT ZCanDnldFromUp),MarkingTime,"D")       'Pe 06/01/92
       RETURN                                                     'Pe 06/01/92 
20220 IF INSTR(ZFileName$,ZDefaultExtension$)= 0 Then             'Pe 06/04/92
      GOSUB 20210                                                 'Pe 06/02/92
      IF ZOK THEN _                                               'Pe 06/02/92
        GOTO 20235                                                'Pe 06/02/92
      IF ZDotFlag THEN _                                          'Pe 06/02/92
         RETURN                                                   'Pe 06/02/92
     End if                                                       'Pe 06/04/92
         WasI = 1                                                 'Pe 06/01/92
20225 CALL BreakFileName (ZFileName$,DR$,WasX$,Extension$,ZFalse) 'Pe 06/01/92
        WasJ = INSTR(Mid$(ZCompressedExt$+". ",WasI),".")        'Pe 04/18/92
       IF WasJ = 0 THEN _                                        'Pe 04/18/92
          GOTO 20231                                             'Pe 06/04/92
              Check$ = MID$(ZCompressedExt$,WasI,WasJ-1)         'Pe 04/28/92
          WasI = WasI + WasJ                                     'Pe 04/18/92
       ZFileName$ = WasX$ + "." + Check$                         'Pe 04/18/92
      ZFileNameHold$ = ZFileName$                                'Pe 04/18/92
     GOSUB 20210                                                 'Pe 06/01/92
 IF ZOK THEN _                                                   'Pe 06/01/92
       GOTO 20235                                                'Pe 06/01/92
     IF ZDotFlag THEN _                                          'Pe 06/01/92
        RETURN                                                   'Pe 06/01/92
      GOTO 20225                                                 'Pe 06/01/92
20231  X = 70              'Pe 01/19/93
       Gosub 21915         'Pe 01/19/93
       ZOutTxt$ = TmpFileNameHold$ + _                             'Pe 04/18/92
           OutTxt$
      CALL UpdtCalr (ZOutTxt$,2)
      ZOutTxt$ = ZOutTxt$ + _
           " Correct name"+ZPressEnterExpert$
      ZSuspendAutoLogoff = ZTrue
      GOSUB 21660
      ZSuspendAutoLogoff = ZFalse
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZWasQ=0 THEN _
         IF ZBatchTransfer AND ZAnsIndex >= LastDnld THEN _
            GOTO 20262 _
         ELSE ZAutoLogOffReq = ZFalse : _
              RETURN
      ZUserIn$(ZAnsIndex) = ZUserIn$(1)
      GOTO 20205
20233 CALL SecViolation
      IF ZDenyAccess THEN _
         ZFileSysParm = 4 : _
         RETURN
      GOTO 20231
20235 CALL BadName (BadFileNameIndex,ZTrue)
      ON BadFileNameIndex GOTO  20236,20245
20236 ZLine25$ = "(D) " + _
                 ZWasZ$
'
' *  TEST FOR DOWNLOAD SECURITY
'
      CALL OpenWork (2,ZFileSecFile$)
      IF ZErrCode = 53 THEN _
       X = 160 : _              'Pe 01/19/93
       Gosub 21915  : _        'Pe 01/19/93
         CALL UpdtCalr (OutTxt$ + " " + ZFileSecFile$,2) : _
         GOTO 20247
20242 IF EOF(2) THEN _
         GOTO 20247
      CALL ReadParms (ZWorkAra$(),3,1)
      IF ZErrCode <> 0 THEN _
         ZWasEL = 20242 : _
         GOTO 21900
20243 CALL WildFile (ZWorkAra$(1),ZWasZ$,ZOK)
      IF NOT ZOK THEN _
         GOTO 20242
20244 IF ZUserSecLevel < VAL(ZWorkAra$(2)) THEN _
         GOTO 20245
      FilePswd$ = ZWorkAra$(3)
      IF FilePswd$ = "" THEN _
         GOTO 20247
      CALL AraAllCaps (ZUserIn$(),1)
      IF ZUserIn$(1) = FilePswd$ THEN _
         GOTO 20247
       X = 164               'Pe 01/19/93
       Gosub 21915         'Pe 01/19/93
      ZOutTxt$ = OutTxt$ + " " + ZFileName$
      GOSUB 21660
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZWasQ = 0 THEN _
         RETURN
      CALL AllCaps (ZUserIn$(1))
      IF ZUserIn$(1) = FilePswd$ THEN _
         GOTO 20247
20245 ZViolation$ = "DownLoad " + _
                   ZFileName$
20246 CALL SecViolation
      IF ZDenyAccess THEN _
         ZFileSysParm = 4
      RETURN
20247 ZWasDF = 0
      CALL BreakFileName (ZFileName$,DR$,WasX$,Extension$,ZFalse)
 IF INSTR("...WRK.FW .GIF.JPG.MAC.ARC.EXE.COM.OBJ.WKS.LBR.ZIP.PAK.ZOO.ARJ.LZH.","."+Extension$+".") > 2 OR _
         MID$(Extension$,2,1) = "Q" OR _                         'ST022093
         (ZRequireNonASCII AND Extension$ = "BAS") THEN _
            ZWasDF = ZTrue
20248 ZOutTxt$ = ""
      IF ZBatchTransfer THEN _
         IF ZAnsIndex < LastDnld THEN _
            GOTO 20260
      CALL XferType (2,ZTrue)
      IF ZFF THEN _
         GOTO 20260
      CALL XferType (1,ZTrue)
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
20260 ZTransferFunction = 1
      ZWasBatchTransfer = ZFalse             'Pe 03/02/92
      ZUpBatchTransfer = ZFalse              'Pe 03/02/92
      GOSUB 21790
      IF ZFileSysParm > 1 THEN _
         RETURN
         ZBatchTransfer = ZBatchProto                     'Pe Batch Mod
      IF ZBatchTransfer AND ZCmdTransfer$ = "" THEN _
         ZCmdTransfer$ = ZWasFT$
      ON INSTR("AXCYN",ZInternalProt$) GOTO _
         20340, _              ' ASCII DOWNLOAD
         20290, _              ' Xmodem
         20290, _              ' Xmodem CRC
         20270, _              ' YMODEM
         21700                 ' NONE - CANCEL
'
' *  EXTERNAL Protocol Downloads/Uploads
'
20261 IF ZReq8Bit THEN _
         IF NOT ZEightBit THEN _
            GOSUB 20318 : _
            IF ZFileSysParm > 1 THEN _
               RETURN _
            ELSE GOSUB 20992 : _
                 IF ZFileSysParm > 1 THEN _
                    RETURN
      IF ZTransferFunction = 1 THEN _
         GOSUB 20750 : _
         CLOSE 2 : _
         IF ZFileSysParm > 1 OR NOT ZOK THEN _
            RETURN
20262 IF ZBatchTransfer THEN _
         IF ZAnsIndex < LastDnld THEN _
            RETURN _
         ELSE ZBlocksInFile# = BatchBlocks# : _
              ZBytesInFile# = BatchBytes# : _
              ZNumDnldBytes! = BatchBytes# : _
              IF ZBytesInFile# < 1 THEN _
                 RETURN _
              ELSE GOSUB 20780 : _
                   IF ZFileSysParm > 1 OR NOT ZOK THEN _
                      RETURN
         IF ZAbort THEN _
            ZAbort = ZFalse : _              'Pe 01/26/92
            ZDnldCompleted = ZFalse : _
            GOSUB 21760 : _
            RETURN
      GOSUB 20337
      CALL Transfer
20263 IF ZPrivateDoor THEN _
         ZCmdTransfer$ = ZWasFT$ : _
         CALL XferType (2,ZTrue) : _
         ZCmdTransfer$ = ""
      CALL OpenWork (2,"XFER-" + ZNodeID$ + ".DEF")
      IF ZErrCode <> 0 THEN _
         GOTO 20267
      CALL ReadParms (ZWorkAra$(), ZFailureParm, 1)
      IF ZErrCode <> 0 THEN _
         GOTO 20267
      CLOSE 2
      IF NOT ZFakeXRpt THEN _                  'Pe 03/26/92
        Call TStats                            'Pe 03/26/92
      CALL KillWork ("XFER-" + ZNodeID$ + ".DEF")
20264 IF ZPrivateDoor THEN _
         ZFileName$ = ZWorkAra$(1) : _
         CALL BreakFileName (ZFileName$,WasX$,ZFileNameHold$,ZWasY$,ZTrue) : _
         ZFileNameHold$ = ZFileNameHold$ + _
                           ZWasY$
      IF LEFT$(ZWorkAra$(ZFailureParm),1) = "L" THEN _
         MID$(ZWorkAra$(ZFailureParm),1,1) = ZFailureString$
20265 IF ZTransferFunction = 2 THEN _
         IF INSTR(ZWorkAra$(ZFailureParm),ZFailureString$) <> 1 THEN _
            GOTO 20700 _
         ELSE GOTO 20730
      IF ZTransferFunction = 1 THEN _
        ZDnldCompleted = (INSTR(ZWorkAra$(ZFailureParm),ZFailureString$) <> 1)  'Pe 05/30/91
      GOSUB 21760
      CALL Carrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7
      RETURN
'
' *  XFER FILE NOT Found
'
20267 ZWasEL = 20263
      GOTO 21900

'
' *  YMODEM DOWNLOAD DRIVER
'
20270 GOTO 20292
'
' *  Xmodem DOWNLOAD DRIVER
'
20290 '
20292 X = 165               'Pe 01/19/93
      Gosub 21915        'Pe 01/19/93
      Call QuickTput1 (OutTxt$) : _
      Call Delaytime (3) : _
      Return
20318 X = 166               'Pe 01/19/93
       Gosub 21915        'Pe 01/19/93
      ZOutTxt$ = OutTxt$
      GOSUB 21630
      IF ZFileSysParm > 1 THEN _
         RETURN
      CALL DelayTime (3)
      RETURN
20320 IF NOT ZEightBit THEN _
         GOSUB 20318 : _
         IF ZFileSysParm > 1 THEN _
            RETURN
20330 GOSUB 20337
      ZOutTxt$ = ZProtoPrompt$ + _
            " " + WasA1$ + _
            " of " + _
            ZFileNameHold$ + _
            " ready.  <Ctrl X> aborts"
      GOSUB 21650
      RETURN
20337 IF ZProtoMacro$ <> "" THEN _
         ZGSRAra$(1) = MID$("DU ",ZTransferFunction,1) : _
         CALL MacroExe (ZProtoMacro$)
      RETURN
'
' *  ASCII DOWNLOAD DRIVER
'
20340 IF ZWasDF THEN _
       X = 167 : _              'Pe 01/19/93
       Gosub 21915  : _        'Pe 01/19/93
         ZOutTxt$ = OutTxt$ : _
         GOSUB 21650 : _
         GOTO 21700
      GOSUB 20750
      IF ZFileSysParm > 1 OR NOT ZOK THEN _
         RETURN
      CALL OpenWork (2,ZFileName$)
      IF (ZAnsIndex = FirstDnld OR NOT ZConcatFIles) THEN _
         GOSUB 20337 : _
       X = 168 : _              'Pe 01/19/93
       Gosub 21915  : _        'Pe 01/19/93
         ZOutTxt$ = OutTxt$ : _
         GOSUB 21640 : _
         IF ZFileSysParm > 1 THEN _
            RETURN _
         ELSE X = 169 : _              'Pe 01/19/93
             Gosub 21915  : _        'Pe 01/19/93
 ZOutTxt$ = ZProtoPrompt$ + " SEND of " + _
              ZFileNameHold$ + _
              OutTxt$ : _
         ZTurboKey = 2 : _
         ZForceKeyboard = ZTrue : _
         ZSuspendAutologoff = ZTrue : _
         GOSUB 21660 : _
         ZSuspendAutologoff = ZFalse : _
         IF ZFileSysParm > 1 THEN _
            RETURN
20380 ZStopInterrupts = ZFalse
      WasTU = 0
      SWAP WasTU,ZPageLength
      CALL BufFile (ZFileName$,WasX)
      SWAP WasTU,ZPageLength
      ZNonStop = (ZPageLength < 1)
      IF StopFile THEN _
         ZDnldCompleted = ZFalse : _   'Pe 05/29/91
         GOTO 20390
20381 IF (ZAnsIndex = LastDnld OR NOT ZConcatFIles) THEN _
         CALL QuickTPut (CHR$(26),0) : _
         IF NOT ZLocalUser AND ZSubParm = 0 THEN _
            FOR WasX = 1 TO 5 : _
               CALL PutCom (CHR$(7)) : _
               CALL DelayTime (3) : _
            NEXT
20385 ZDnldCompleted = ZTrue   'Pe 05/30/91
20390 GOTO 21760
'
' *  U - COMMAND FROM FILES MENU (UPLOAD)
'
20395 GOSUB 21640
      IF ZFileSysParm > 1 THEN _
         RETURN
       X = 170              'Pe 01/19/93
       Gosub 21915        'Pe 01/19/93
      ZOutTxt$ = OutTxt$ +ZPressEnterExpert$
      GOSUB 21660
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZWasQ = 0 THEN _
         RETURN
      ZUserIn$(ZAnsIndex) = ZUserIn$(1)
      GOTO 20435
20400 CALL TimeBack (1)
      ZUpBatchTransfer = ZFalse     'Pe 12/08/91
      ZWasBatchTransfer = ZFalse
      DupeCount = 0                                                  ' ds112801
      GOSUB 20420
      ZAutoLogOffReq = 0
      FirstUpld = ZAnsIndex
      GOTO 20430
20410 CALL TimeBack (1)
      CALL KillWork (ZBatchWorkFile$)                 'Pe Batchup mod 
      ZErrCode = 0
      ZUpBatchTransfer = ZTrue
      Call Killwork ("BatchUp" +ZNodeID$ +".LST")
      ZErrCode = 0
      ZAutoLogOffReq = 0
'
' changes for 12/28/91
'
If LEN(ZUserIn$) < 3 Then _
      CALL Batchit : _
      FirstUpld = 2 : _
      LastUpld = ZLastIndex : _
      GOTO 20430
     FirstUpld = ZAnsIndex
    Goto 20430

20420  X = 171              'Pe 01/19/93
      Gosub 21915        'Pe 01/19/93
      ZOutTxt$ = OutTxt$
      GOSUB 21667
      RETURN
'
' *  SEARCH FOR DUPLICATE FILENAME
'
20430 ZAnsIndex = ZLastIndex
      GOSUB 20471
      ZLastIndex = ZLastIndex + (WasX > 0)
      LastUpld = ZLastIndex

20432 FOR ZAnsIndex = FirstUpld TO LastUpld
         IndexSave = ZAnsIndex

IF ZRbatch = ZTrue THEN 
         IF (ZBatchProto = 0 AND ZuserXferDefault$ <> "N") _
            AND IndexSave > 1 THEN _                                 ' ds112801
            IndexSave = LastUpld + 1 : _                             ' ds112801
            EXIT FOR                                                 ' ds112801
    End IF

         GOSUB 20471
         GOSUB 20435
         FirstUpld = FirstUpld + 1
         IF ZFileSysParm > 1 THEN _
            IndexSave = LastUpld + 1
         ZAnsIndex = IndexSave
     NEXT

IF ZRbatch = ZTrue Then
      IF (DupeCount > 0 AND IndexSave <> 1) _                        ' ds112801
          AND (ZBatchProto <> 0 OR ZUserXferDefault$ = "N") THEN _   ' ds112801
       X = 321 : _             'Pe 05/19/93
       Gosub 21915 : _         'Pe 05/19/93
        CALL QuickTPut1 (ZCrLf$ + OutTxt$) : _
       X = 322 : _            'Pe 05/19/93
       Gosub 21915 : _        'Pe 05/19/93
        CALL QuickTPut (OutTxt$,1) : _           ' ds112801
        FOR DCount = 1 to DupeCount : _                              ' ds112801
            CALL QuickTPut1 ("     " + ZUserIn$(DCount)) : _         ' ds112801
        NEXT : _                                                     ' ds112801
       X = 323 : _             'Pe 05/19/93
       Gosub 21915 : _         'Pe 05/19/93
        CALL QuickTPut1 (ZCrLf$ + OutTxt$ )
   End IF

    ZCmdTransfer$ = ""
      RETURN
20435 ZFileNameHold$ = ZUserIn$(ZAnsIndex)
      ExtSrch = ZFalse
      IF INSTR(ZFileNameHold$,".") = 0 THEN _
         ZFileNameHold$ = ZFileNameHold$ + "." + ZDefaultExtension$
      CALL AllCaps(ZFileNameHold$)
      ZFileName$ = ZFileNameHold$

     If ZRbatch = ZTrue Then
      ZUserIn$(ZAnsIndex) = ZFileName$                               ' ds112801
       End IF

      ZViolation$ = "Upload "
      CALL NoPath (ZFileName$,BadFileNameIndex)
      IF BadFileNameIndex THEN _
         GOTO 20451
      CALL BadFile (ZFileName$,BadFileNameIndex)
      ON BadFileNameIndex GOTO 20440,20451,20515
'
' Following mod was orig from DGS-UNW mod....updated for Maple code 12/15/91
'
20440 TmpName$ = ZDirPath$+"NOTHANX.DEF"                         'Pe 06/01/92
      CALL FindIt (TmpName$)                                        'DGS-UNW
      IF ZOK THEN
       X = 172              'Pe 01/19/93
       Gosub 21915        'Pe 01/19/93
       CALL QuickTPut1 (OutTxt$ + " "+ZFileNameHold$)
        CALL OpenWork (2,TmpName$)
         HaveFile$ = ""
          FileInList = ZFalse
            WHILE NOT EOF(2) AND NOT FileInList
	     INPUT #2, HaveFile$
	    CALL AllCaps (HaveFile$)
          FileInList = (INSTR(ZFileNameHold$,HaveFile$) > 0)
	 WEND
       CLOSE 2
      END IF
     IF FileInList THEN _
    GOTO 20443
'
' If you want to eliminate either one of these routines just comment
' out the one you don't want....NOTHANX.DEF must reside in RBBS's Subdir
' the OFFLINE.DIR were your Master FMS dir is kept....you can change names
' as you see fit.
'                  !!DO NOT COMMENT OUT THE LINE NUMBER !!
'
 TmpName$ = ZDirPath$+"OFFLINE.DIR"                            'PE mode2 to
       CALL FindIt (TmpName$)                                        'DGS-UNW
        IF ZOK THEN
       X = 173               'Pe 01/19/93
       Gosub 21915        'Pe 01/19/93
          CALL QuickTPut1 (OutTxt$ + " "+ZFileNameHold$ )
           CALL OpenWork (2,TmpName$)
            HaveFile$ = ""
             FileInList = ZFalse
               WHILE NOT EOF(2) AND NOT FileInList
                LINE INPUT #2, HaveFile$                     'Pe 12/15/91
                 CALL AllCaps (HaveFile$)
                  StopReading = INSTR(HaveFile$,".")
                   HaveFile$ = Left$(HaveFile$,StopReading)    'Pe 12/16/91
                  Search = INSTR(ZFileNameHold$,".")
                  Search$ = Left$(ZFileNameHold$,Search)
                 If Search$ = HaveFile$ THEN_
                FileInList = ZTrue
             WEND
	  CLOSE 2
        END IF
'
'    next 2 lines
'    Allow Sysop to update FMS listing with a local upload
'    even if the filename exists in the NOTHANX.DEF OR OFFLINE.DIR
'
20443   If ZSysop Then _
            FileinList = ZFalse            'Pe 12/15/91
        IF FileInList THEN _
           CALL BufFile (ZHelpPath$+"NOTHANX.MSG",WasX) : _  'Pe 06/01/92
           CALL DelayTime (3) : _
           GOTO 20453
        CALL Carrier
        IF ZSubParm = -1 THEN _
           ZFileSysParm = 7 : _
           RETURN
      PersFile$ = ZFileName$                                     'Pe 08/09/91
      ZFileName$ = ZPersonalDrvPath$ + PersFile$                 'Pe 08/08/91
      Call FindFile (ZFileName$,ZOK)                             'Pe 08/09/91
      IF ZOK THEN Goto 20452                                     'Pe 08/09/91
      ZFileName$ = PersFile$                                     'Pe 08/09/91
      CALL RotorsDir (ZFileName$,ZSubDir$(),ZSubDirCount,ZTrue,"U")
20445 IF ZOK THEN _
         GOTO 20452
      IF INSTR(ZFileName$,".") = 0 THEN _
         GOTO 20475
      CALL BreakFileName (ZFileName$,DR$,WasX$,Extension$,ZFalse)
      WasI = 1
20447 WasJ = INSTR(MID$(ZCompressedExt$+". ",WasI),".")
      IF WasJ = 0 THEN _
         GOTO 20475
      Check$ = MID$(ZCompressedExt$,WasI,WasJ-1)
      WasI = WasI + WasJ
20450 IF Extension$ <> Check$ THEN _
      CALL RotorsDir (WasX$ + "." + Check$,ZSubDir$(),ZSubDirCount,ZTrue,"U") : _
         IF ZOK THEN _
            ExtSrch = ZTrue : _
            GOTO 20452
      GOTO 20447
20451 X = 174              'Pe 01/19/93
      Gosub 21915        'Pe 01/19/93
      ZOutTxt$ = OutTxt$+ ZFileName$ + ">"
      GOTO 20395
20452 IF ZUserSecLevel < ZOverWriteSecLevel THEN _
         GOTO 20453
      IF ExtSrch AND (WasX$ + "." + Check$) <> ZFileName$ THEN _
       X = 175 : _              'Pe 01/19/93
       Gosub 21915  : _        'Pe 01/19/93
         ZOutTxt$ = WasX$ + "." + Check$ + OutTxt$ _
      ELSE X = 176              'Pe 01/19/93
       Gosub 21915        'Pe 01/19/93
       ZOutTxt$ = OutTxt$
      GOSUB 21660
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF NOT ZYes THEN _
         GOTO 20453
      ZWasZ$ = ZFileName$
      CALL KillWork (ZFileName$)
      IF ZErrCode <> 0 AND ZErrCode <> 53 THEN _
       X = 177 : _              'Pe 01/19/93
       Gosub 21915  : _        'Pe 01/19/93
         ZOutTxt$ = OutTxt$ : _
         GOSUB 21660 : _
         RETURN
      GOTO 20475
20453 CLOSE 2
      FileInList = ZFalse ' Pe 12/31/92
      IF ZUserSecLevel >= ZAddDirSecurity THEN _
         GOTO 20455
20454 X = 178               'Pe 01/19/93
      Gosub 21915         'Pe 01/19/93
      CALL QuickTPut1 (OutTxt$ + " " + ZFileNameHold$)
      CALL DelayTime (3)  'Pe 08/04/91
      PersFile$ = ""      'Pe 08/08/91
IF ZRbatch = ZTrue Then
      IF ZBatchProto <> 0 OR ZUserXferDefault$ = "N" THEN _          ' ds112801
         DupeCount = DupeCount + 1 : _                               ' ds112801
         ZUserIn$(DupeCount) = ZUserIn$(ZAnsIndex)                   ' ds112801
END IF
      CALL UpdtCalr ("Upload duplicate " + ZFileNameHold$,1)
      RETURN
20455 X = 179              'Pe 01/19/93
       Gosub 21915        'Pe 01/19/93
       ZOutTxt$ = OutTxt$
      ZTurboKey = - ZTurboKeyUser
      GOSUB 21660
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF NOT ZYes THEN _
         RETURN
      GOSUB 20460
      IF WhoTo$ = "" THEN _
         RETURN
      AddingDescOnly = ZTrue
      ZWasBatchTransfer = ZFalse    'Pe 01/03/92
      ZWasFT$ = "l"
CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),ZLinesInMsg,1) 'UPL-MOD pe082690
'Call AutoLogoff    'Pe 10/20/91 Test mod... remove when working
      GOSUB 20702
      RETURN
20460 CALL KillWork (ZNodeWorkFile$)      'Pe BatchUp
      WhoTo$ = ""
     IF ZUpBatchTransfer THEN _          'Pe 04/29/92
      WhoTo$ = "ALL"                     'Pe 04/29/92
      WasY$ = ZFileName$
      IF ZUserSecLevel >= ZMinSecPersUpld THEN _
         CALL SetWhoTo (ZTrue,WhoTo$,"",RcvrRecNum,Found,ZTrue) _    ' KG012502
      ELSE WhoTo$ = "ALL"
      ZFileName$ = WasY$
      RETURN
20470 ' *** CHECK FOR Protocol/Marked files IN FILE LIST ***
      WasX = 0
      ZWasZ$ = ZUserIn$(ZAnsIndex)
      CALL UnMarkItems (ZMarkedFiles$,ZAnsIndex,LastDnld,FoundMarked,ZTrue)
      IF FoundMarked THEN _
         RETURN
20471 ZWasZ$ = ZUserIn$(ZAnsIndex)
      CALL AllCaps(ZWasZ$)
      WasX = 0
      IF LEN (ZWasZ$) = 1 THEN _
         WasX = INSTR(ZDefaultXfer$,ZWasZ$) : _
         IF WasX > 0 THEN _
            ZAnsIndex = ZAnsIndex + 1 : _
            IndexSave = IndexSave + 1 : _
            ZCmdTransfer$ = ZWasZ$ : _
            IF MID$(ZInternalEquiv$,WasX,1) = "N" THEN _
               ZCmdTransfer$ = ""
      RETURN
20475 ZWasZ$ = ZUpldDriveFile$
      CALL FindFree
      IF VAL(ZFreeSpace$) < 4096 THEN _
         GOSUB 21895 : _
         IndexSave = ZLastIndex + 1 : _
         RETURN

If ZRbatch = ZTrue THEN
 IF ZBatchProto <> 0 OR ZUserXferDefault$ = "N" THEN _               ' ds112801
         IF (IndexSave < LastUpld) OR DupeCount > 0 THEN _           ' ds112801
            RETURN                                                   ' ds112801
      IF (ZUserIn$(1) = "U" OR ZUserIn$(1) = "u") THEN _             ' ds121401
         ZUserIn$(1) = ZUserIn$(2)                                   ' ds121401
      ZFileNameHold$ = ZUserIn$(1)                                   ' ds123001
      CALL AllCaps(ZFileNameHold$)                                   ' ds123001
 IF ZBatchProto = 0 AND ZuserXferDefault$ <> "N"THEN _               ' ds123001
         ZLastIndex = 1                                              ' ds112801
END IF

       X = 180               'Pe 01/19/93
       Gosub 21915        'Pe 01/19/93
      ZOutTxt$ = OutTxt$ + ZFreeSpace$
      GOSUB 21640
      IF ZFileSysParm > 1 THEN _
         RETURN
    GOSUB 20460                                                  'Pe 08/08/91
      If ZMplPersUpload = ZTrue Then _                           'Pe 08/09/91
      ZFileName$ = ZPersonalDrvPath$ + PersFile$                 'Pe 08/08/91
'*****************
CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),ZLinesInMsg,1)  '<++++++
'*****************
20476 IF ZAbort THEN _     'Pe 09/07/91 added line number
      ZAbort = ZFalse : _   'PE 12/14/88
        RETURN
      CALL SaveUserActivity("W", ZNodeRecIndex, ZFalse) 'lk 032293
      ZLine25$ = "(U) " + _
                 ZFileNameHold$
      ZSubParm = 2
      CALL Line25
      ZOutTxt$ = ""
      ZOK = ZTrue
20477 CALL XferType (2,ZTrue)
      IF ZFF THEN _
         GOTO 20500
      CALL XferType (1,ZTrue)
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
20500  ZTransferFunction = 2
      GOSUB 21790
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZInternalProt$ = "N" THEN _                       'Pe 08/08/91
         GOTO 21700                                        'Pe 08/08/91
IF NOT ZUpBatchTransfer THEN _
CALL AutoLogOff            'Pe 02/04/90
      IF ZAutoEnd = 2 THEN _
         RETURN
      ON INSTR("AXCYN",ZInternalProt$) GOTO _
         20560, _         ' ASCII UPLOAD
         20542, _         ' Xmodem
         20542, _         ' Xmodem CRC
         20542, _         ' YMODEM
         20735            ' NONE - CANCEL
      GOTO 20261
20510 WasD$ = "<Esc> by SysOp aborts"
      GOSUB 21710
      RETURN
20515 CALL SecViolation
      IF ZDenyAccess THEN _
         ZFileSysParm = 4 : _
         RETURN
      GOTO 20420
'
' *  Xmodem/YMODEM UPLOAD DRIVER
'
20542 X = 165              'Pe 01/19/93
      Gosub 21915         'Pe 01/19/93
      Call QuickTput1 (OutTxt$) : _
      Call Delaytime (3) : _
      Return
'
' *  ASCII UPLOAD
'
20560 LineACK = (ZDefaultLineACK$ <> "")
      IF LineACK THEN _
       X = 181 : _              'Pe 01/19/93
       Gosub 21915  : _        'Pe 01/19/93
         ZOutTxt$ = OutTxt$ : _
         ZTurboKey = - ZTurboKeyUser : _
         LineACK = NOT ZNo : _
         GOSUB 21660 : _
         IF ZFileSysParm > 1 THEN _
            RETURN
      GOSUB 20337
       X = 182              'Pe 01/19/93
       Gosub 21915       'Pe 01/19/93
      CALL QuickTPut1 (OutTxt$)
      CALL QuickTPut1 (ZProtoPrompt$+" RECEIVE of " + ZFileNameHold$ + " ready")
      ZOK = ZFalse
      XOff = ZFalse
      CALL OpenOutW(ZFileName$)
      IF ZErrCode <> 0 AND ZErrCode <> 53 THEN _
         ZWasEL = 20560 : _
         GOTO 21900
      GOSUB 20510
      IF ZFileSysParm > 1 THEN _
         RETURN
20600 CALL EofComm (Char)
      WHILE Char <> -1
         CALL Carrier
         IF ZSubParm = -1 THEN _
            ZFileSysParm = 7 : _
            RETURN
         IF NOT ZFossil THEN _
            IF LOF(3) < 512 THEN _
               CALL PutCom(ZXOff$) : _
               XOff = ZTrue
20610    CALL FlushCom (WasX$)
         IF ZSubParm = -1 THEN _
            ZFileSysParm = 7 : _
            RETURN
         IF INSTR(WasX$,CHR$(11)) THEN _
            GOTO 20650
         ZOK = ZTrue
20620    CALL PrintWork (WasX$)
         IF LineACK THEN _
            IF INSTR(WasX$,CHR$(10)) > 0 THEN _
               CALL PutCom (ZDefaultLineACK$)
         IF ZErrCode <> 0 THEN _
            ZWasEL = 20620 : _
            GOTO 21900
         WasD$ = WasX$
         NumReturns = 0
         GOSUB 21720
         IF ZFileSysParm > 1 THEN _
            RETURN
20621    CALL FindFKey
         IF ZSubParm < 0 THEN _
            ZFileSysParm = 2 : _
            RETURN
         IF ZKeyPressed$ = ZEscape$ THEN _
            GOTO 20745
         IF NOT ZOK THEN _
            GOTO 20670
      CALL EofComm (Char)
20630 WEND
      CALL Carrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
      IF XOff THEN _
         XOff = ZFalse : _
         CALL PutCom (ZXOn$) : _
         IF ZErrCode <> 0 THEN _
            ZWasEL = 20630 : _
            GOTO 21900
      GOTO 20600
20650 WasX = INSTR(WasX$,CHR$(11))
      IF WasX = 1 THEN _
         IF NOT ZOK THEN _
            GOTO 20730 _
         ELSE GOTO 20700
      CALL PrintWorkA (LEFT$(WasX$,WasX-1))
      IF ZErrCode <> 0 THEN _
         ZWasEL = 20650 : _
         GOTO 21900
      GOTO 20700
20670 X = 183               'Pe 01/19/93
       Gosub 21915        'Pe 01/19/93
       ZOutTxt$ = ZXOff$ + OutTxt$
20675 GOSUB 21650
      IF ZFileSysParm > 1 THEN _
         RETURN
      CALL DelayTime (3)
      CALL PutCom(ZXOn$)
20680 CALL EofComm (Char)
      WHILE Char <> -1
         CALL FlushCom(WasX$)
         IF INSTR(WasX$,CHR$(11)) THEN _
            GOTO 20730
20685    CALL Carrier
         IF ZSubParm = -1 THEN _
            ZFileSysParm = 7 : _
            RETURN
      CALL EofComm (Char)
      WEND
      GOTO 20680
'
' *  UPDATE UPLOAD DIRECTORY
'
20700 GOSUB 21780
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZWasBatchTransfer Then _
        CALL BatchUpload (ZDesc$,ZUCat$,2) : _
        GOTO 20703
20702 CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(), ZLinesInMsg,2) 'Pe 02/03/90
'
20703 IF ZAutoEnd = 1 THEN _                'AUTO-UP MOD
         ZFileSysParm = 7: _             'Pe BatchUp 09/12/91
         ZDnldCompleted = ZTrue : _      'Pe BatchUp 09/12/91
         RETURN                             'AUTO-UP MOD
      IF NOT ZGetExtDesc THEN _
         ZPrivateDoor = ZFalse : _
         GOTO 20710
       X = 184             'Pe 01/19/93
       Gosub 21915        'Pe 01/19/93
      ZMsgHeader$ = OutTxt$ + " " + ZFileNameHold$
      ZSysopComment = ZTrue
      ZMaxMsgLines = ZMaxExtendedLines
      WasLL = ZRightMargin
      ZRightMargin = 30 + ZMaxDescLen
      IF ZRightMargin > 74 THEN _
         ZRightMargin = 74
      ZFileSysParm = 5
      RETURN
20705 ZMaxMsgLines = ZMaxMsgLinesDef
      ZRightMargin = WasLL
      CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),ZLinesInMsg,3)  'Pe 02/04/90
20710 AddingDescOnly = ZFalse
      IF ZBytesInFile# > 0.0 THEN _
         GOTO 21770
20730 GOSUB 21780
       X = 160              'Pe 01/19/93
       Gosub 21915        'Pe 01/19/93
      CALL QuickTPut1 (OutTxt$)
      ZAutoLogoffReq = ZFalse                'Pe 10/20/91
      ZWasBatchTransfer = ZFalse             'Pe 03/02/92
      ZUpBatchTransfer = ZFalse              'Pe 03/02/92
      LastUpld = 0
      ZPrivateDoor = ZFalse
20735 CALL KillWork (ZFileName$)
      IF ZErrCode <> 0 THEN _
         ZWasEL = 20736 : _
         GOTO 21900
      ZAnsIndex = ZLastIndex + 1
      IndexSave = ZAnsIndex
      ZLastIndex = 0
      RETURN
'
' *  Sysop ABORTED UPLOAD
'
20745 X = 186              'Pe 01/19/93
       Gosub 21915        'Pe 01/19/93
       ZOutTxt$ = ZXOff$ + OutTxt$
      GOTO 20675
'
' *  CALCULATE DOWNLOAD TIME ESTIMATE
'
20750 ZStartOfHeader$ = CHR$(1 - (ZInternalProt$ = "Y"))
      CALL OpenRSeq (2,ZFileName$,MaxBlock,ZWasDF,ZFLen)             'Pe031901
20760 IF ZErrCode <> 0 THEN _
       X = 187 : _              'Pe 01/19/93
       Gosub 21915  : _        'Pe 01/19/93
         CALL QuickTPut1 (OutTxt$ + " " +ZFileNameHold$) : _
         CALL UpdtCalr (OutTxt$ + " "+ZFileName$,2) : _
         ZOK = ZFalse : _
         ZErrCode = 0 : _
         ZBytesInFile# = 0 : _
         RETURN
      ZBytesInFile# = LOF(2)
      ZNumDnldBytes! = LOF(2)
      ZOK = ZTrue
      IF SizeOnly THEN _
         SizeOnly = ZFalse : _
         RETURN
      ZBlocksInFile# = MaxBlock
      IF ZBatchTransfer THEN _
         BatchBlocks# =  BatchBlocks# + ZBlocksInFile# : _
         BatchBytes# = BatchBytes# + ZBytesInFile# : _
         CALL OpenWorkA (ZNodeWorkFile$) : _
         CALL PrintWorkA (ZFileName$) : _
         ZDownFiles = ZDownFiles + 1 : _
         CLOSE 2 : _
         RETURN
      ZDownFiles = 1
20780 ZOutTxt$ = "File Size    :"
      ZOK = ZTrue
      IF ZBlockSize > 0 THEN _
         ZOutTxt$ = ZOutTxt$ + _
              STR$(FIX(ZBlocksInFile#)) + _
              " blocks "
20785 ZBlocksInFile# = ZBlocksInFile# / _
         VAL(MID$("000003000450120024004800720096012001440168019203840", -4 * ZCBPS, 4))
      ZBlocksInFile# = ZBlocksInFile# * ZFLen / ZSpeedFactor!
      IF (ZAnsIndex > 1 AND ZConcatFIles) THEN _
         RETURN
      ZOutTxt$ = ZOutTxt$ + _
           STR$(ZBytesInFile#) + _
           " bytes"
      GOSUB 21650
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZBytesInFile# < 1 THEN _
         RETURN
20790 ZSubParm = 2
      CALL Line25
      ZOutTxt$ = "Transfer Time:" + _
         STR$(INT(ZBlocksInFile# / 60)) + _
         " min," + _
         STR$(INT(ZBlocksInFile# - (INT(ZBlocksInFile# / 60) * 60))) + _
         " sec (approx)"
      GOSUB 21650
      IF ZFileSysParm > 1 THEN _
         RETURN
20791 CALL CheckTimeRemain (MinsRemaining)
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 6 : _
         RETURN
      ZOK = ZTrue
      Temp = ZExtraDnldTime
      CALL ChkAddedTime (Temp)
      Temp = MinsRemaining + Temp
      ZWasA = INT(ZBlocksInFile# / 60) + 1
      IF ZWasA <= Temp THEN _
         GOTO 20793
      IF ZDownFiles < 2 THEN _
         CALL AllCaps (ZFileNameHold$) : _
       X = 188 : _              'Pe 01/19/93
       Gosub 21915  : _        'Pe 01/19/93
         ZOutTxt$ = ZFileNameHold$ +OutTxt$ _
                 + STR$(ZWasA) + "  have" + STR$(Temp) : _
         CALL UpdtCalr (ZOutTxt$,2) : _
         CALL QuickTPut1 (ZOutTxt$) _
      ELSE CALL OpenWork (2,ZNodeWorkFile$) : _
           WHILE NOT EOF(2) : _
              CALL ReadDir (2,1) : _
              CALL BreakFileName (ZOutTxt$,DR$,ZWasY$,WasX$,ZTrue): _
              ZFileName$ = ZWasY$ + WasX$ : _
              X = 188 : _              'Pe 01/19/93
              Gosub 21915  : _        'Pe 01/19/93
              ZOutTxt$ = ZFileName$ + OutTxt$ _
                         + STR$(ZWasA) + "  have" + STR$(Temp) : _
              CALL UpdtCalr (ZOutTxt$,2) : _
           WEND : _
           CLOSE 2 : _
            X = 188 : _              'Pe 01/19/93
             Gosub 21915  : _        'Pe 01/19/93
           ZOutTxt$ = OutTxt$  _
                       + STR$(ZWasA) + "  have" + STR$(Temp) : _
           CALL QuickTPut1 (ZOutTxt$)
      CALL DelayTime (3)
      IF ZDownFiles < 2 THEN _
         GOTO 20792
      ZLastIndex = 0
       X = 189              'Pe 01/19/93
       Gosub 21915        'Pe 01/19/93
      ZOutTxt$ = OutTxt$
      ZTurboKey = - ZTurboKeyUser
      GOSUB 21668
      IF ZNo THEN _
         LastDnld = 0 : _
         GOTO 20792
      Temp = 0
      CALL OpenWork (2,ZNodeWorkFile$)
      WHILE NOT EOF(2)
         CALL ReadDir (2,1)
         CALL BreakFileName (ZOutTxt$,DR$,ZWasY$,WasX$,ZTrue)
         ZFileName$ = ZWasY$ + WasX$
         ZOutTxt$ = "Download " + ZFileName$ + " (Y,[N])"
         ZTurboKey = - ZTurboKeyUser
         GOSUB 21668
         IF ZYes THEN _
            Temp = Temp + 1 : _
            ZOutTxt$(Temp) = ZFileName$
      WEND
      CLOSE 2
      ZAnsIndex = 1
      ReStart = (Temp > 0)
      LastDnld = Temp
      ZLastIndex = Temp
      FOR WasX = 1 TO Temp
         ZUserIn$(WasX) = ZOutTxt$(WasX)
      NEXT
20792 ZOutTxt$ = ""
      ZOK = ZFalse
      ZAutoLogoffReq = ZFalse
      RETURN
20793 IF ZRatioRestrict# > 0 THEN _
         GOSUB 21775 : _                        ' DD040901
         IF ZFreeDnld = ZFalse THEN _           ' DD060101
       X = 190 : _              'Pe 01/19/93
       Gosub 21915  : _        'Pe 01/19/93
         CALL QuickTPut1 (OutTxt$) : _
         CALL CheckRatio (ZTrue)
      CALL AutoLogoff
      IF ZAutoEnd = 2 THEN _
      ZOK = ZFalse
      RETURN
20810 ZDelay! = TIMER + 6
20840 CALL EofComm (Char)
      IF Char = -1 THEN _
         GOTO 20850
      CALL FlushCom(ZWasY$)
      RETURN
20850 CALL CheckTime (ZDelay!, TempElapsed!, 1)
      IF TempElapsed! > 0 THEN GOTO 20840
20851 ZWasY$ = ""
      CALL CheckCarrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
      RETURN
'
' *  CHANGE TO 8 BIT FOR Xmodem
'
20992 GOSUB 20510
      IF ZFileSysParm > 1 THEN _
         ZFileSysParm = 2 : _
         RETURN
      IF NOT ZEightBit THEN _
         PrevLineCntl = INP (ZLineCntlReg) : _
         CALL DelayTime (3) : _
         SwitchToEight = ZTrue : _
         OUT ZLineCntlReg,3
20996 WasSO = 0
      RETURN
'
' STANDARD ENTRY FOR RBBS-PC'S COMMON TERMINAL OUTPUT ROUTINE
'
' Modeled on lines 12975 to 12983 in RBBS-PC.BAS
21630 ZSubParm = 1
      GOTO 21655
21640 ZSubParm = 3
      GOTO 21655
21650 ZSubParm = 5
21655 CALL TPut
      IF ZSubParm < 0 THEN _
         ZFileSysParm = 2 : _
         RETURN
      IF ZSubParm = 8 THEN _
         GOSUB 21660
      RETURN
'
' STANDARD ENTRY FOR RBBS-PC'S COMMON TERMINAL INPUT ROUTINE
'
' Modeled on lines 12995 to 12997 in RBBS-PC.BAS
21660 ZSubParm = 1
      CALL TGet
21665 IF ZSubParm < 0 THEN _
         ZFileSysParm = 2
      RETURN
21667 ZStackC = ZTrue
21668 CALL PopCmdStack
      GOTO 21665
21700 ZErrCode = 0
      ZLastIndex = 0
      RETURN
'
' **** COMMON LOCAL DISPLAY PRINT ***
'
'  (formerly lines 1315 to 1320 in RBBS-PC.BAS
21710 NumReturns = 1
21720 CALL LPrnt (WasD$,NumReturns)
      RETURN
'
' * UPDATE DOWNLOAD STATISTICS
'
'  (formerly lines 50600 to 50614 in RBBS-PC.BAS
21760 GOSUB 21780
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZBatchTransfer THEN _
         CALL LinesInFile (ZNodeWorkFile$,ZDownFiles) _
      ELSE ZDownFiles = 1
      IF NOT ZDnldCompleted THEN _     'Pe 05/31/91
         ZAutoLogoffReq = ZFalse : _
         ZWasDF$ = " Aborted" : _
         GOTO 21770
      CALL LogPDown (ZPersonalDnld,1+ZAnsIndex-FirstDnld)
      WasX = ((ZRatioRestrict# > 0) AND ZEnforceRatios AND ZFreeDnld)
      IF NOT WasX THEN _
         ZDnlds = ZDnlds + ZDownFiles : _
         ZGlobalDLToday! = ZGlobalDLToday! + ZDownFiles : _
         ZGlobalDnlds = ZGlobalDnlds + ZDownFiles : _
         ZDLBytes! = ZDLBytes! + ZNumDnldBytes! : _
         ZGlobalDLBytes! = ZGlobalDLBytes! + ZNumDnldBytes! : _
         ZDLToday! = ZDLToday! + ZDownFiles : _
         ZBytesToday! = ZBytesToday! + ZNumDnldBytes! : _
         ZGlobalBytesToday! = ZGlobalBytesToday! + ZNumDnldBytes!
      ZNumDnldBytes! = 0
      ZWasDF$ = " Downloaded"
      IF (ZAnsIndex = LastDnld OR NOT ZConcatFIles) THEN _
         CALL SkipLine (1) : _
       X = 191 : _              'Pe 01/19/93
       Gosub 21915  : _        'Pe 01/19/93
         CALL QuickTPut1 (OutTxt$)
         IF WasX THEN _
       X = 192 : _              'Pe 01/19/93
       Gosub 21915  : _        'Pe 01/19/93
            CALL QuickTPut1 (OutTxt$)
21770 CALL AMorPM
      IF NOT ZBatchTransfer THEN _
         ZWasQ = 1 : _
         ZUserIn$(1) = ZFileName$ : _
         GOTO 21772
      CALL OpenWork (2,ZNodeWorkFile$)
      IF ZErrCode > 0 THEN _
         RETURN
      ZWasQ = 0
      WHILE NOT EOF(2)
         CALL ReadAny
         ZWasQ = ZWasQ + 1
         ZUserIn$(ZWasQ) = ZOutTxt$
      WEND
21772 IF ZWasQ < 1 THEN _
         ZBatchTransfer = ZFalse : _
         RETURN
      CALL OpenWork (2,ZUserIn$(ZWasQ))
      IF ZErrCode > 0 THEN _
         ZErrCode = 0 : _
         ZWasQ = ZWasQ - 1 : _
         GOTO 21772
      ZBytesInFile# = LOF(2)
      ZFileName$ = ZUserIn$(ZWasQ)
21773 IF ZTransferFunction = 1 THEN
     CALL BreakFileName (ZFileName$,DR$,WasX$,Extension$,ZTrue)
      ZWasZ$ = WasX$ + _
           Extension$ + _
           ZWasDF$ + _
           " at " + _
           ZTime$ + _
           " using " + _
           ZWasFT$ + _
           STR$(ZBytesInFile#)
      CALL UpdtCalr (ZWasZ$,2)
         IF  ZWasDF$ = " Downloaded" Then          'Pe021593
        Call MenuPlus (9)                          'Pe021593
      END IF                                       'Pe021593
   END IF
      IF ZBatchTransfer THEN _
         ZWasQ = ZWasQ - 1 : _
         GOTO 21772
      'CALL CheckRatio (ZFalse)
21774  RETURN
21775 TmpName$ = ZDirPath$ + "FREE.DEF"         ' DD040901
      TempZOK = ZOK                                                  ' DD043001
      CALL FindIt (TmpName$)                    ' DD040901
      IF ZOK THEN                               ' DD040901
         CALL OpenWork (2, TmpName$)            ' DD040901
         HaveFile$ = ""                         ' DD040901
         FileIsFree = ZFalse                    ' DD040901
         WHILE NOT EOF(2) AND NOT FileIsFree    ' DD040901
            INPUT #2, FreeFile$                 ' DD040901
            CALL AllCaps (FreeFile$)            ' DD040901
            FileIsFree = (INSTR(LEFT$(ZFileNameHold$,LEN(FreeFile$)),FreeFile$) > 0) ' DD040901
         WEND                                   ' DD040901
         CLOSE 2                                ' DD040901
         IF FileIsFree THEN                     ' DD040901
            ZFreeDnld = ZTrue                   ' DD040901
         END IF                                 ' DD040901
      END IF                                    ' DD040901
      ZOK = TempZOK                                                  ' DD043001
      RETURN                                    ' DD040901

'
'
' *****   TURN ON INTERMEDIATE ECHO   ****
'
'  (formerly line 50620 in RBBS-PC.BAS
21780 IF ZEchoer$ = "I" THEN _
         CALL SetEcho ("I")
'
' *  RESTORE COMMUNICATIONS AFTER Switch TO 8 BIT
'
'  (formerly between lines 50620 and 50630 in RBBS-PC.BAS
      IF SwitchToEight THEN _
         IF ZSwitchBack THEN _
            OUT ZLineCntlReg, PrevLineCntl : _
            CALL DelayTime (3) : _
            ZEightBit = ZFalse : _
            SwitchToEight = ZFalse
      RETURN
'
' *****  TURN OFF INTERMEDIATE ECHO  ****
'
'  (formerly line 50630 in RBBS-PC.BAS
21790  Call CheckCarrier                  'Pe 12/31/91
      IF ZSubParm = -1 THEN _             'Pe 12/31/91
         ZFileSysParm = 7 : _             'Pe 12/31/91
       Return                             'Pe 12/31/91
       IF ZEchoer$ = "I" THEN _
         CALL SetEcho ("R")
      RETURN
'
' *****   DIRECTORY SEARCH   ****
'
'  (formerly lines 52900 to 52920 in RBBS-PC.BAS
21800 WasCK = 2
21810 X = 193              'Pe 01/19/93
       Gosub 21915        'Pe 01/19/93
       ZOutTxt$ = OutTxt$
      ZMacroMin = 99
      GOSUB 21668
      IF ZWasQ = 0 THEN _
         RETURN
21820 WasRS$ = ZUserIn$(ZAnsIndex)
      WildSearch = (INSTR(WasRS$,"*") > 0 OR INSTR(WasRS$,"?") > 0)
      CALL AllCaps (WasRS$)
      IF RIGHT$(WasRS$,1) = "*" THEN _
         IF RIGHT$(WasRS$,2) <> ".*" THEN _
            WasRS$ = WasRS$ + ".*"
      SearchString$ = WasRS$
      SearchDate$ = ""
      ZJumpSearching = ZFalse
      WasA1$ = WasRS$
      ZExtendedOff = ZFalse 'ZTrue       'Pe 10/27/91
      GOTO 21867
'
' *****  P - personal download  ****
'
'  (formerly lines 52950 to 52952 in RBBS-PC.BAS
21850 IF ZPersonalBegin < 1 OR ZPersonalLen < 1 THEN _
         RETURN
      DnldFlag = 0
      ZPersonalDnld = ZTrue
21852 ZActiveFMSDir$ = ZPersonalDir$
      CALL DispUpDir (WasX$,SearchString$,SearchDate$,DnldFlag,ZAnsIndex)
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7: _
         RETURN
      IF ZAnsIndex > ZLastIndex THEN _
         GOTO 21854
      ZConcatFIles = ZPersonalConcat
      ZStopInterrupts = ZTrue
      TimeLockExempt = ZTrue
      GOSUB 20202
      IF ZFileSysParm > 1 THEN _
         GOTO 21854
      TimeLockExempt = ZFalse
      ZConcatFIles = ZFalse
      GOTO 21852
21854 RETURN
'
' *  WasN - COMMAND FROM FILES MENU (DISPLAY NEW FILES SINCE Last DIR DISPLAY)
'
'  (formerly lines 53000 to 53070 in RBBS-PC.BAS
21860 WasCK = 1
21862 WasA1$ = RIGHT$(ZWasLM$,4) +_
            LEFT$(ZWasLM$,2)
       X = 194              'Pe 01/19/93
       Gosub 21915        'Pe 01/19/93
      ZOutTxt$ = OutTxt$ + WasA1$
      GOSUB 21668
      CALL AraAllCaps (ZUserIn$(),ZAnsIndex)
      IF ZWasQ = 0 OR ZUserIn$(ZAnsIndex) = "S" THEN _
         WasRS$ = ZWasLM$ : _
         GOTO 21866
21865 IF LEN(ZUserIn$(ZAnsIndex)) <> 6 THEN _
         GOTO 21862
      WasA1$ = ZUserIn$(ZAnsIndex)
      WasRS$ = RIGHT$(WasA1$,2) + _
            LEFT$(WasA1$,4)
      ListNew = ZTrue
21866 SearchDate$ = WasRS$
      SearchString$ = ""
      ZJumpSearching = ZFalse
      ZExtendedOff = ZFalse 'ZTrue             'Pe 10/27/91
      ZUserIn$(ZAnsIndex) = "A"
       ZEndList = ZTrue          'Pe 12/01/91
       GOTO 21871                'Pe NewFile mod
21867 CALL GetDirs (ZFalse)
      IF ZWasQ = 0 THEN _
         RETURN
21871 CALL ConvertDir (ZAnsIndex)
      ZListDir = ZTrue
      ListNew = ZTrue
      ZSearchingAll = ZFalse
21875 ZWasZ$ = ZUserIn$(ZAnsIndex)
      IF NOT ZSearchingAll THEN _
         IF ZWasZ$ = "ALL" THEN _
            IF NOT ZLimitSearchToFMS THEN _
               GOSUB 21890
21880 WasQX = ZAnsIndex
      GOSUB 20157
      IF ZFileSysParm > 1 THEN _
         RETURN
      ZAnsIndex = ZAnsIndex + 1
      IF ZAnsIndex <= ZLastIndex THEN _
         GOTO 21875
      ListNew = ZFalse
      ZEndList = ZFalse       'Pe 12/01/91
      SearchString$ = ""
      SearchDate$ = ""
      RETURN
21890 WasG = ZAnsIndex
      CALL GetAll (ZUserIn$(),WasG)
      ZSearchingAll = ZTrue
      ZLastIndex = WasG
      ZAnsIndex = ZAnsIndex + 1
      RETURN
21895  X = 195              'Pe 01/19/93
       Gosub 21915        'Pe 01/19/93
       CALL QuickTPut1 (OutTxt$)
       RETURN
'
' *  MAIN FILE SYSTEM ERROR TRAP - ALL ERRORS PASS THROUGH THIS ROUTINE
'
'  (formerly lines 13000 to 13500 in RBBS-PC.BAS
21900 IF ZDebug THEN _
         ZOutTxt$ = "RBBSSUB5 DEBUG Error Trap Entry ERL=" + _
             STR$(ZWasEL) + _
              " ERR=" + _
              STR$(ZErrCode) : _
         IF ZPrinter THEN _
            CALL Printit(ZOutTxt$) _
         ELSE CALL LPrnt(ZOutTxt$,1)
      IF ZWasEL = 20126 AND ZErrCode = 53 THEN _
         GOTO 20142
      IF ZWasEL = 20242 AND ZErrCode = 62 THEN _
         CALL UpdtCalr (ZFileSecFile$ + " bad format!",2) : _
         GOTO 20247
      IF ZWasEL = 20263 THEN _
         ZOutTxt$ = "<Download aborted>" : _
         ZDnldCompleted = ZFalse : _          'Pe
         ZAutoLogoffReq = ZFalse : _
         ZAutoEnd = 3 : _
         GOTO 20390
      IF ZWasEL = 20560 AND ZErrCode = 67 THEN _
         GOTO 20451
      IF ZWasEL = 20560 AND ZErrCode = 70 THEN _
         IF VAL(ZFreeSpace$) > 1999 THEN _
            GOTO 20610 _
         ELSE GOSUB 21895 : _
              GOTO 21700
      IF ZWasEL = 20620 THEN _
         GOTO 20670
      IF ZWasEL = 20650 THEN _
         GOTO 20670
      IF ZWasEL = 20736 AND ZErrCode = 53 THEN _
         GOTO 21700
21910 CALL LogError
      CALL QuickTPut1 (ZCallersRecord$)
      ZFileSysParm = 3
      RETURN
21915 Call GetRBBSString(X,RBBSString$)      'Pe 01/16/93
      OutTxt$ = RBBSString$                 'Pe 01/16/93
      Return
21920 ' EXIT RBBS-PC FILE SUBSYSTEM
      END SUB
'
' $SUBTITLE: 'TStat --- Display Transfer Stats from Xfer-? file'
' $PAGE
'
      SUB TStats STATIC                                              ' MplXfer
      CALL OpenWork (2,"XFER-" + ZNodeID$ + ".DEF")                  ' MplXfer
      IF ZErrCode <> 0 THEN _
       Exit Sub                                                    'Pe 06/01/92
      CALL SkipLine (2)                                              ' MplXfer
      Call GetRBBSString(206,RBBSString$)      'Pe 01/16/93
      OutTxt$ = RBBSString$                 'Pe 01/16/93
      CALL QuickTPut (ZFG2$ + OutTxt$,2)
        Call GetRBBSString(207,RBBSString$)      'Pe 01/16/93
            OutTxt$ = RBBSString$               'Pe 01/16/93
      CALL QuickTPut1 (ZFG4$ + OutTxt$)
        Call GetRBBSString(208,RBBSString$)      'Pe 01/16/93
             OutTxt$ = RBBSString$               'Pe 01/16/93
     Call QuickTput1 (ZFG3$ +OutTxt$ + ZEmphasizeOff$) ' MplXfer
      WHILE NOT EOF(2)                                               ' MplXfer
        LINE INPUT #2,Stat$                                          ' MplXfer
        WasS = INSTR(Stat$,"rs ")                                    ' MplXfer
        IF WasS > 0 THEN _                                           ' MplXfer
           WasX$ = MID$(Stat$, 2, WasS)                              ' MplXfer
        Match = INSTR(Stat$, ".")                                    ' MplXfer
        IF Match > 0 THEN _                                          ' MplXfer
           WasZyX$ = MID$(Stat$, Match - 8, 12)                      ' MplXfer
        Match = 0                                                    ' MplXfer
        Start = 1                                                    ' MplXfer
        DO                                                           ' MplXfer
          Match = INSTR(Start, WasZyX$, "\")                         ' MplXfer
          IF Match > 0 THEN _                                        ' MplXfer
             WasZyX$ = RIGHT$(WasZyX$, LEN(WasZyX$) - Match)         ' MplXfer
        LOOP WHILE Match                                             ' MplXfer
        Match = 0                                                    ' MplXfer
        Start = 1                                                    ' MplXfer
        DO                                                           ' MplXfer
          Match = INSTR(Start, WasZyX$, " ")                         ' MplXfer
          IF Match > 0 THEN _                                        ' MplXfer
             WasZyX$ = RIGHT$(WasZyX$, LEN(WasZyX$) - Match)         ' MplXfer
        LOOP WHILE Match                                             ' MplXfer
        WasXy = LEN(WasZyX$)                                         ' MplXfer

      IF ZErrCode <> 0 THEN _
       Exit Sub                                                    'Pe 06/01/92
 
     CALL QuickTPut1 (ZFG1$ + WasZyX$ + SPACE$(15-WasXy) + WasX$ + ZEmphasizeOff$) ' MplXfer
      WEND                                                           ' MplXfer
      CALL SkipLine (1)                                              ' MplXfer
      CLOSE 2                                                        ' MplXfer
      CALL DelayTime (3)                                             ' MplXfer
      END SUB                                                        ' MplXfer

30140 ' $SUBTITLE: 'GetArc - sub to get what files to verbose list'
' $PAGE
'
'  NAME    -- GetArc
'
'  INPUTS  --     PARAMETER                    MEANING
'                 ZWasQ                       NUMBER OF ENTRIES TYPED
'                 ZUserIn$()                  ENTRIES TYPED
'
'  OUTPUTS --
'
'  PURPOSE --  Process the V)erbose list command.
'              Takes what user types and tries to list it.
'
      SUB GetArc STATIC
30141 IF ZAnsIndex >= ZLastIndex THEN _
         IF LEN(ZDefaultExtension$) > 0 THEN _
    Call GetRBBSString(87,RBBSString$) : _     'Pe 01/16/93
     OutTxt$ = RBBSString$ : _               'Pe 01/16/93 
            CALL QuickTPut1 (OutTxt$ + "  "+ZDefaultExtension$)
      WasZ$ = "V"
      CALL AskItems ("V",WasZ$,ZFalse,"file",ZMarkedFiles$)
      IF ZSubParm = -1 OR ZWasQ = 0 THEN _
         EXIT SUB
      ZViolation$ = "View ARC"
      WasX = ZAnsIndex
      ZAnsIndex = WasX
30142 IF ZAnsIndex > ZLastIndex THEN _
         IF ZLastIndex > 1 OR Drive$ <> "" THEN _                    ' KG091001
            EXIT SUB _
         ELSE GOTO 30141
      GOSUB 30143
      IF ZSubParm < 0 THEN _
         EXIT SUB
      ZAnsIndex = ZAnsIndex + 1
      GOTO 30142
30143 ZWasZ$ = ZUserIn$(ZAnsIndex)
      CALL UnMarkItems (ZMarkedFiles$,ZAnsIndex, ZLastIndex,Temp,ZFalse)
      ZWasZ$ = ZUserIn$(ZAnsIndex)
      WasZ$ = ZWasZ$
      CALL AllCaps (ZWasZ$)
      CALL BreakFileName (ZWasZ$,Drive$,Prefix$,Ext$,ZFalse)
      IF Ext$ = "" THEN _
         Ext$ = ZDefaultExtension$ : _
         ZWasZ$ = ZWasZ$ + "." + ZDefaultExtension$
      ZLastExt$ = Ext$                                   'Pe 08/12/91
      ZFileNameHold$ = ZWasZ$
      ZFileName$ = ZWasZ$
      WasI = 1                                        'Pe 04/21/92
      CALL BadFile (Prefix$,BadFileNameIndex)
      ON BadFileNameIndex GOTO 30144,30146,30147
30144 CALL BadFile (ZFileName$,BadFileNameIndex)
      ON BadFileNameIndex GOTO 30145,30146,30147
30145  IF Drive$ <> "" THEN _                                         ' KG091001
         ZFileNameHold$ = Prefix$ + "." + Ext$ : _                   ' KG091001
         CALL FindFile (ZFileName$,ZOK) _                            ' KG091001
   Else CALL RotorsDir (ZFileName$,ZSubDir$(),ZSubDirCount + (NOT ZSysop),ZTrue,"V")
      IF ZOK THEN _
         GOTO 30148
If ZPersonalDnld  or ZMarkedPersFile Then _                    'Pe032001
ZFileName$ = ZPersonalDrvPath$ + ZWasZ$ : _                    'Pe 08/12/91
CALL FindFile (ZFileName$,ZOK)                                 'Pe 08/12/91
 IF ZOK THEN _                                                 'Pe 08/12/91
    GOTO 30148                                                 'Pe 08/12/91
   ZWasZ$ = ZFileName$                                         'Pe 04/21/92
    CALL BreakFileName (ZFileName$,DR$,Prefix$,Ext$,ZFalse)    'Pe 04/21/92
    WasJ = INSTR(MID$(ZCompressedExt$+". ",WasI),".")          'Pe 04/21/92
     IF WasJ = 0 THEN _                                        'Pe 04/21/92
        GOTO 30146                                             'Pe 04/21/92
         Check$ = MID$(ZCompressedExt$,WasI,WasJ-1)            'Pe 04/21/92
       WasI = WasI + WasJ                                      'Pe 04/21/92
      ZFileName$ = Prefix$ + "." + Check$                      'Pe 04/21/92
      ZLastExt$ = Check$                                       'Pe 04/21/92
     ZFileNameHold$ = ZFileName$                               'Pe 04/21/92
   GOTO 30145                                                  'Pe 04/21/92
30146 ZWasZ$ = WasZ$ + _
           " not found!"
      CALL UpdtCalr (ZWasZ$,2)
      ZOutTxt$ = ZWasZ$ + _
           " Type correct filename" + ZPressEnterExpert$
      ZSubParm = 1
      CALL TGet
      IF ZSubParm = -1 OR ZWasQ = 0 THEN _
         RETURN
      ZUserIn$(ZAnsIndex) = ZUserIn$(1)
      GOTO 30143
30147 CALL SecViolation
      IF ZDenyAccess THEN _
         EXIT SUB
      GOTO 30146
30148  WasX$ = ZDiskForDos$ + "VU_FILE.BAT"   'Pe 12/29/92
      ' WasX$ = ZDiskForDos$ + "V" + Ext$ + ".BAT"   'Pe 09/25/91
      CALL FindIt (WasX$)
      IF NOT ZOK THEN _
         GOTO 30170                 'Pe 11/02/91
'
'  adds FileSec to ViewArc commands
'
      CALL OpenWork (2,ZFileSecFile$)
      IF ZErrCode = 53 THEN _
         CALL UpdtCalr ("Missing file " + ZFileSecFile$,2) : _
         ZErrCode = 0 : _
         GOTO 30165
30160 IF EOF(2) THEN _
         GOTO 30165
      CALL ReadParms (ZWorkAra$(),3,1)
      IF ZErrCode <> 0 THEN _
         CALL UpdtCalr (ZFileSecFile$ + " error in file!",2) : _
         GOTO 30165
     CALL WildFile (ZWorkAra$(1),ZWasZ$,ZOK)
      IF NOT ZOK THEN _
         GOTO 30160
        IF ZUserSecLevel < VAL(ZWorkAra$(2)) THEN _
         GOTO 30162
      FilePswd$ = ZWorkAra$(3)
      IF FilePswd$ = "" THEN _
         GOTO 30165
      CALL AraAllCaps (ZUserIn$(),1)
      IF ZUserIn$(1) = FilePswd$ THEN _
         GOTO 30165
    Call GetRBBSString(293,RBBSString$)     'Pe 01/16/93
     ZOutTxt$ = RBBSString$ + ZFileNameHold$              'Pe 01/16/93 
            ZSubParm = 1
         Call TGet
      IF ZSubParm < 0 THEN _
         Exit Sub
      IF ZWasQ = 0 THEN _
         RETURN
      CALL AllCaps (ZUserIn$(1))
      IF ZUserIn$(1) = FilePswd$ THEN _
         GOTO 30165
30162 ZViolation$ = "View " + _
                   ZFileName$
    Call GetRBBSString(88,RBBSString$)     'Pe 01/16/93
     OutTxt$ = RBBSString$               'Pe 01/16/93 
      Call QuickTPut1 (OutTxt$)
30163 CALL SecViolation
      IF ZDenyAccess THEN _
         ZFileSysParm = 4
      RETURN
'
'  End of changes
'
30165 Call GetRBBSString(89,RBBSString$) : _     'Pe 01/16/93
       OutTxt$ = RBBSString$ : _               'Pe 01/16/93 
       CALL QuickTPut1 (ZFileNameHold$ + OutTxt$)       'Pe 09/25/91
      ZGSRAra$(3) = MID$(RIGHT$(ZComPort$,1)+"0",1-ZLocalUser, 1)
      CALL OpenWork (2,WasX$)                                     'Pe 11/02/91
      CALL ReadDir (2,1)
      IF EOF(2) THEN _
         ZWasZ$ = ZOutTxt$ : _
         ZGSRAra$(1) = ZFileName$ : _
         ZGSRAra$(2) = ZArcWork$ _
      ELSE ZWasZ$ = WasX$ + " " + ZFileName$ + _
            " " + ZArcWork$ + " " + ZGSRAra$(3) + " " + Ext$ + " " + ZNodeId$
      CALL ShellExit (ZWasZ$)
      CALL Findit (ZDiskForDOS$ + "NOVIEW."+ ZNodeId$)         'Pe 12/29/92
      IF ZOK Then _          'Pe 12/29/92
      Call KillWork(ZDiskForDOS$ + "NOVIEW."+ ZNodeId$) : _
       GOTO 30170                'Pe 12/29/92
      CALL BufFile (ZArcWork$,WasX)
      CALL ViewTxt        'located in Rbbssub1.bas
      RETURN
30170     Call GetRBBSString(90,RBBSString$)     'Pe 01/16/93
     OutTxt$ = RBBSString$                'Pe 01/16/93 
       CALL QuickTPut1 (OutTxt$ + " "+Ext$+" files")    'Pe 11/02/91
         RETURN
      END SUB

'********

58162 ' $SUBTITLE: 'InitFMS - sub to initialize file management system'
' $PAGE
'
'  NAME    -- InitFMS
'
'  INPUTS  -- PARAMETER             MEANING
'             ZFMSDirectory$
'
'  OUTPUTS -- ZCategoryName$()  ELEMENTS 1,2, POSSIBLY MORE
'             ZCategoryCode$()  ELEMENTS 1,2, POSSIBLY MORE
'             ZCategoryDesc$()  ELEMENTS 1,2, POSSIBLY MORE
'             CategoryIndex     COUNT OF # ELEMENTS IN THE FILE
'                               MANAGMENT SYSTEM
'
'  PURPOSE -- Subroutine to initialize the RBBS-PC File Management System
'
      SUB InitFMS (CategoryIndex) STATIC
      Blank$ = " "
      CategoryIndex = 1
      ZCategoryName$(1) = "P"
      ZCategoryCode$(1) = "P"
      ZCategoryDesc$(1) = "Personals"
      IF ZFMSDirectory$ <> "" THEN _
         CategoryIndex = CategoryIndex + 1 : _
         CatN$ = ZCategoryName$(CategoryIndex) : _
         CALL BreakFileName (ZFMSDirectory$,DrvPath$,CatN$,Extension$,ZFalse) : _
         ZCategoryName$(CategoryIndex) = CatN$ : _
         ZCategoryCode$(CategoryIndex) = "" : _
         ZCategoryDesc$(CategoryIndex) = "All uploads"_
      ELSE ZLimitSearchToFMS = ZFalse : _
           EXIT SUB
      IF ZLimitSearchToFMS OR ZMasterDirName$ = ZMainFMSDir$ THEN _
         CategoryIndex = CategoryIndex + 1 : _
         ZCategoryName$(CategoryIndex) = "ALL" : _
         ZCategoryCode$(CategoryIndex) = "" : _
         ZCategoryDesc$(CategoryIndex) = "All files"
      CALL FindIt (ZDirCatFile$)
      IF NOT ZOK THEN _
         EXIT SUB
      WHILE NOT EOF(2)
         CALL ReadParms (ZWorkAra$(),3,1)
         IF ZErrCode > 0 THEN _
            ZErrCode = 0 : _
            CALL PScrn (ZDirCatFile$+" invalid.  Line" + STR$(CategoryIndex) + " needs 3 parms") : _
            CALL DelayTime (4) _
         ELSE CategoryIndex = CategoryIndex + 1 : _
              ZCategoryName$(CategoryIndex) = ZWorkAra$(1) : _
              CALL AraAllCaps (ZCategoryName$(),CategoryIndex) : _
              ZCategoryCode$(CategoryIndex) = ZWorkAra$(2) : _
              ZCategoryDesc$(CategoryIndex) = ZWorkAra$(3) : _
              CatR$ = ZCategoryCode$(CategoryIndex) : _
              CALL Remove (CatR$,Blank$) : _
              ZCategoryCode$(CategoryIndex) = CatR$
      WEND
      CLOSE 2
      END SUB

58165 ' $SUBTITLE: 'DispUpDir - sub to display FMS directory'
' $PAGE
'
'  NAME    -- DispUpDir
'
'  INPUTS  -- PARAMETER             MEANING
'             PassedCats$         FILE "CATEGORIES" TO BE INCLUDED IN
'                                 THE SEARCH.
'             SearchString$       STRING TO SEARCH ON WITHIN THE
'                                 FILE "CATEGORIES" SELECTED
'             SearchDate$         DATE EQUAL TO OR GREATER THAN TO BE
'                                 SEARCHED FOR WITH THE "CATEGORIES"
'                                 AND THE STRING TO SEARCH.
'             DnldFlag            SET TO RECORD # OF LINE TO BEGIN
'                                 VIEWING - 0 IF AT END
'
'  OUTPUTS -- DnldFlag            WHENEVER DOWNLOAD REQUESTED, SETS
'                                 TO 1.  OTHERWISE LEAVES AT ZERO
'  PURPOSE -- Display the files that meet the criteria selected in
'             RBBS-PC upload management system on the users screen.
'
      SUB DispUpDir (PassedCats$,SearchString$, _
                    SearchDate$,DnldFlag,AbortIndex) STATIC
      IF AtEndList THEN _
         AtEndList = ZFalse : _
         IF DnldFlag > 0 THEN _
            GOSUB 58185 : _
            GOTO 58184
      CALL AllCaps (SearchString$)
      Blank$ = " "
      ZStopInterrupts = ZFalse
      Categories$ = "," + _
                    PassedCats$ + _
                    ","
      CanDnld = (ZUserSecLevel => ZOptSec(19))
      CanView = (ZUserSecLevel => ZOptSec(26))
      ZJumpSupported = ZTrue
      ZJumpSearching = ZFalse
      GOSUB 58185
      OrigDir$ = ZActiveFMSDir$
      InList = (RelistAt > 0 AND ReListAt <= LastRec)
      IF InList AND DnldFlag > 0 THEN _
         UpldIndex = RelistAt : _
         DnldFlag = 0 : _
         GOTO 58179
      ZJumpLast$ = ""
      SearchFor$ = SearchString$
      ExtraPrompt$ = LEFT$(",T)ype",6+4*ZExpertUser)                 'Pe 10/21/89
      ExtraPrompt$ = ExtraPrompt$ + LEFT$(",V)iew",6+4*ZExpertUser)  'Pe 10/21/89
      IF ZPersonalDnld THEN _
         ExtraPrompt$ = ExtraPrompt$ + ",*)new"
      IF CanDnld THEN _
         ExtraPrompt$ = ExtraPrompt$ + ",E)xtra,M)ark,D)nld"    'Pe 11/07/91
      MaxPrint = ZPageLength - 1
      BelowMinSec = (ZUserSecLevel < ZMinSecToView)
      ZNonStop = ZNonStop OR (ZPageLength < 1)
      FMSCheckPoint = 0
      WildSearch = (INSTR(SearchString$,"?") > 0) _
                     OR (INSTR(SearchString$,"*") > 0)
      CALL AraAllCaps (ZUserIn$(),ZAnsIndex)
      IF ZAnsIndex > 0 THEN _
        IF ZLastCommand$ = "FP" AND INSTR("Ll",ZUserIn$(ZLastIndex)) = 0 THEN _
            ZUserIn$(ZAnsIndex) = "D" : _
            IF (UpldIndex > 0 AND UpldIndex <= LastRec) THEN _
               GOTO 58180 _
            ELSE Temp$ = "" : _
                 GOTO 58196
58168 UpldIndex = UpldIndex + ZUpInc
      CALL CheckKBStop
      IF ZRet THEN _
         ZLinesPrinted = 999 : _
         GOTO 58178
      IF UpldIndex = CutoffRec THEN _
         GOTO 58184
      GET #2,UpldIndex
      FMSCheckPoint = FMSCheckPoint + 1
      ON INSTR("\* =",LEFT$(PartToPrint$,1)) GOTO 58168,58171,58170,58169
      GOTO 58172
58169 CALL CheckInt (MID$(PartToPrint$,34))
      IF ZUserSecLevel < ZTestedIntValue THEN _
         LastOK = ZFalse : _
         FailedSearch = ZFalse : _
         GOTO 58168
      MID$(PartToPrint$,1,13) = MID$(PartToPrint$,2,12) + " "
      ZWasA = LEN(STR$(ZTestedIntValue))
      MID$(PartToPrint$,34) = MID$(PartToPrint$,34 + ZWasA) + SPACE$(ZWasA)
      GOTO 58172
58170 IF ZExtendedOff THEN _      ' Extended description
         GOTO 58168 _
      ELSE IF LastOK THEN _
         GOTO 58175 _
      ELSE IF ZJumpSearching THEN _
              GOTO 58187 _
           ELSE IF SearchString$ <> "" AND (NOT WildSearch) AND FailedSearch THEN _
                   GOTO 58187 _
                ELSE GOTO 58168
58171 IF Category$ = "***" THEN _   ' display line
         GOTO 58176 _
      ELSE HoldCat$ = "," + Category$ + "," : _
           IF INSTR(Categories$,HoldCat$) > 0 THEN _
              GOTO 58176 _
           ELSE GOTO 58168
58172 LastOK = ZFalse           ' normal file entry display
      FailedSearch = ZFalse
      LastFName = UpldIndex
      IF Category$ = "***" THEN _
         IF NOT ZSysop THEN _
            GOTO 58178
      IF Category$ = ZDefaultCatCode$ THEN _
         IF BelowMinSec THEN _
            GOTO 58178
58173 IF LEN(Categories$) > 2 THEN _
         GOSUB 58191 : _
         IF NOT CanGet THEN _
            IF CatLen < 4 OR NOT ZGlobalSysOp THEN _
               GOTO 58178
      IF ZJumpSearching OR SearchString$ <> "" THEN _
         ZOutTxt$ = PartToPrint$ : _
         IF WildSearch THEN _
            Temp$ = LEFT$(PartToPrint$,INSTR(PartToPrint$," ")-1) : _
            Temp$ = MID$(Temp$,1-(LEFT$(Temp$,1)="=")) : _
            CALL WildFile (SearchString$,Temp$,ZOK) : _
            IF ZOK THEN _
               FoundString$ = SearchString$ : _
               GOTO 58175 _
            ELSE GOTO 58178 _
         ELSE CALL AllCaps (ZOutTxt$) : _
              HiLitePos = INSTR(ZOutTxt$,SearchFor$) : _
              IF HiLitePos = 0 THEN _
                 FailedSearch = ZTrue : _
                 GOTO 58178 _
              ELSE HiLiteRec = UpldIndex : _
                   FoundString$ = SearchFor$ : _
                   IF ZJumpSearching THEN _
                      ZJumpSearching = ZFalse : _
                      SearchFor$ = PrevSearch$
58174 IF SearchDate$ <> "" THEN _
         HoldCat$ = MID$(PartToPrint$,30,2) + _
                MID$(PartToPrint$,24,2) + _
                MID$(PartToPrint$,27,2) : _
         IF HoldCat$ < SearchDate$ THEN _
            IF ZDateOrderedFMS THEN _
               GOTO 58184 _
            ELSE GOTO 58168
'
'
' * Allow the FMS to be both fast and interruptable if a local
' * user or there is nothing in the input buffer by using QuickTPut.
'
'
58175 LastOK = ZTrue
58176 ZWasA = EndDesc
      IF LEFT$(PartToPrint$,5) = "     " THEN _
         GOTO 58178
      ZOutTxt$ = PartToPrint$
      IF PersonalStatus$ = "*" AND LEFT$(ZOutTxt$,1) <> " " THEN _
         MID$(ZOutTxt$, INSTR(ZOutTxt$," ")) = "*"
      CALL TrimTrail (ZOutTxt$," ")
      CALL ColorDir (ZOutTxt$,"Y")
      IF UpldIndex = HiLiteRec THEN _
         HiLiteRec = -1 : _
         HiLitePos = 0 : _
         CALL CheckColor (ZOutTxt$,FoundString$,"")
58177 IF ZLocalUser THEN _
         CALL QuickTPut1 (ZOutTxt$) : _
         GOTO 58178
      CALL EofComm (Char)
      IF Char = -1 THEN _
         CALL QuickTPut1 (ZOutTxt$) _
      ELSE ZSubParm = 5 : _
           CALL TPut : _
           IF ZRet THEN _
              GOTO 58198
58178 IF ZLinesPrinted <= MaxPrint AND (FMSCheckPoint MOD 1000 <> 0) THEN _
         GOTO 58168
      CALL CheckCarrier
      IF ZSubParm = -1 THEN _
         GOTO 58198
      CALL TimeRemain (MinsRemaining)
      IF MinsRemaining <= 0 THEN _
         ZSubParm = -1 : _
         GOTO 58198
      IF ZNonStop THEN _
         GOTO 58168
      IF ZLinesPrinted <= MaxPrint THEN _
         IF ZDateOrderedFMS THEN _
    Call GetRBBSString(115,RBBSString$) : _      'Pe 01/16/93
      OutTxt$ = RBBSString$ : _                'Pe 01/16/93
            CALL QuickTPut1 (ZEmphasizeOff$ + _
               OutTxt$ + " " + MID$(PartToPrint$,24,8)) _
         ELSE _
            CALL QuickTPut1 (ZEmphasizeOff$ + STR$(FMSCheckPoint) + _
               " files checked")
58179 InList = (UpldIndex > 0 AND UpldIndex <= LastRec)
58180 WasX$ = ZUserIn$(ZAnsIndex)
      CALL AllCaps (WasX$)
      IF InList AND (ZAnsIndex >= ZLastIndex OR WasX$ <> "D") THEN _
         ZTurboKey = -ZTurboKeyUser : _
         ZStackC = ZTrue : _
         CALL AskMore (ExtraPrompt$, ZTrue, ZFalse,AbortIndex,ZFalse) : _
         IF ZSubParm = -1 THEN _
            EXIT SUB _
         ELSE ZLastIndex = ZWasQ :_
         IF NOT ZNo THEN _
            ZAnsIndex = 1
      IF ZSubParm = -1 THEN _
         GOTO 58198
      IF ZNo THEN _
         ZLastIndex = 0 : _
         GOTO 58198
      WasX$ = ZUserIn$(ZAnsIndex)
      CALL AllCaps (WasX$)
'
'Type TXT file mod  Pe 10/21/89
'
      IF WasX$ = "T" THEN _
         CALL TypeFile : _
         ZwasA = UpldIndex : _
         GOSUB 58185 : _
         UpldIndex = ZwasA : _
         GOTO 58180
'
'
      IF WasX$ = "V" THEN IF CanView THEN _
         CALL GetArc : _
         ZJumpSupported = ZTrue : _
         ZWasA = UpldIndex : _
         GOSUB 58185 : _
         UpldIndex = ZWasA : _
         GOTO 58180
'
'   
     IF WasX$ = "E" THEN _                  'Pe 11/07/91
      ZExtendedOff=NOT ZExtendedOff: _       'Pe 11/07/91
    Call GetRBBSString(116,RBBSString$) : _      'Pe 01/16/93
      OutTxt$ = RBBSString$ : _                'Pe 01/16/93
      CALL QuickTPut1 (OutTxt$ + " "+FNOffOn$(NOT ZExtendedOff)) : _
      GOTO 58168
'
'
58181 MarkingFiles = ZFalse
      IF ((WasX$ = "D" OR WasX$ = "M") AND CanDnld) OR (WasX$ = "V" AND CanView) THEN _ ' KG091001
 MarkingFiles = (WasX$ = "M") : _ 
         AtEndList = ZFalse : _                                  'PE 08/04/91
         CALL AskItems ("DMV",WasX$,ZTrue,"file",ZMarkedFiles$) ': _   ' KG091001
         IF ZWasQ = 0 THEN _
            GOTO 58183
      IF WasX$ = "*" THEN IF ZPersonalDnld THEN _
         GOTO 58193
58183 IF ZJumpSearching THEN _
         PrevSearch$ = SearchFor$ : _
         SearchFor$ = ZJumpTo$ _
      ELSE SearchFor$ = SearchString$ : _
           IF NOT ZYes AND CanDnld THEN _
              GOSUB 58188 : _
              IF WasX$ = "V" AND CanView AND ZLastIndex >= ZAnsIndex THEN _ ' KG091001
                 ZAnsIndex = ZAnsIndex - 1 : _                       ' KG091001
                 CALL GetArc : _                                     ' KG091001
                 ZJumpSupported = ZTrue : _                          ' KG091001
                 ZWasA = UpldIndex : _                               ' KG091001
                 GOSUB 58185 : _                                     ' KG091001
                 UpldIndex = ZWasA : _                               ' KG091001
                 GOTO 58180 _                                        ' KG091001
 ELSE IF WasX$ <> "L" AND ZLastIndex >= ZAnsIndex AND NOT MarkingFiles AND NOT AtEndList THEN _ ' Pe 080391
                 CALL SkipLine (1) : _
                 DnldFlag = 1 : _
                 ReListAt = UpldIndex : _
                 EXIT SUB _
              ELSE IF UpldIndex = CutoffRec THEN _
                      GOTO 58184
      IF ZNonStop THEN IF UpldIndex > 999 THEN _
         IF (SearchDate$ = "" OR NOT ZExpertUser) THEN _
         Call GetRBBSString(299,RBBSString$): _      'Pe 01/16/93
            ZOutTxt$ = STR$(UpldIndex) + RBBSString$ : _
            ZNoAdvance = ZTrue : _
            ZTurboKey = -ZTurboKeyUser : _
            ZSubParm = 1 : _
            CALL TGet : _
            CALL WipeLine (79) : _
            ZNonStop = ZYes
      GOTO 58168
58184 IF ZChainedDir$ <> "" THEN _
         ZActiveFMSDir$ = ZChainedDir$ : _
         GOSUB 58185 : _
         LastFName = 0 : _
         GOTO 58168
      IF ZNo THEN _
         GOTO 58198
      Temp$ = "End list. "
      AtEndList = ZTrue
      UpldIndex = CutOffRec - ZUpInc
      ZLastIndex = 0
      GOTO 58196
58185 IF PassedCats$ = "P" THEN _
         ZActiveFMSDir$ = ZPersonalDir$
      CALL OpenFMS (UpldIndex,CatLen)
      LastRec = UpldIndex
      EndDesc = 33 + ZMaxDescLen
      IF CatLen > 3 THEN _
         Categories$ = ZActiveUserName$ : _
         CALL Trim (Categories$) : _
         Categories$ = "," + Categories$ + "," + LEFT$(",SYSOP,",-7*ZSysOp) : _
         CanDnld = ZTrue : _
         StatLen = 1 _
      ELSE StatLen = 0
      FIELD 2, EndDesc AS PartToPrint$, _
               CatLen AS Category$, _
               StatLen AS PersonalStatus$, _
               2 AS Filler$
      PrevFMS$ = ZActiveFMSDir$
58186 IF ZUpInc = -1 THEN _
         CutoffRec = 0 : _
         UpldIndex = LastRec + 1 _
      ELSE CutoffRec = LastRec + 1 : _
           UpldIndex = 0
      RETURN
58187 ZOutTxt$ = PartToPrint$
      CALL AllCaps (ZOutTxt$)
      HiLitePos = INSTR(ZOutTxt$,SearchFor$)
      IF HiLitePos < 1 THEN _
         GOTO 58168
      HiLiteRec = UpldIndex
      IF LastFName > 0 THEN _
         UpldIndex = LastFName
      GET 2,UpldIndex
      FoundString$ = SearchFor$
      IF ZJumpSearching THEN _
         SearchFor$ = PrevSearch$
      GOTO 58175
58188 IF ProcessedNew OR MarkingFiles OR NOT ZListOnly THEN _
         ProcessedNew = ZFalse : _
         RETURN
      ZUserIn$(0) = ""
      WasI = ZAnsIndex              ' check whether in dir
      WHILE WasI <= ZLastIndex
         CALL AraAllCaps (ZUserIn$(),WasI)
         ZWasZ$ = ZUserIn$(WasI)
         CALL UnMarkItems (ZMarkedFiles$,WasI,ZLastIndex,WasX,ZTrue)
         Temp$ = ZUserIn$(WasI)
         CALL AllCaps (Temp$)                                        ' KG062401
         IsProto = (LEN(Temp$) = 1 AND _
                    INSTR(ZDefaultXfer$,Temp$) > 0)
         ZOK = IsProto
         WasJ = LastRec + 1
         WasX = INSTR(Temp$,".")
         AltTemp$ = ""
         IF NOT IsProto THEN _
            IF WasX = 0 THEN _
               AltTemp$ = Temp$ + "." + ZDefaultExtension$ _
            ELSE IF WasX = LEN(Temp$) THEN _
                    AltTemp$ = LEFT$(Temp$,WasX-1)
         WHILE WasJ > 1 AND NOT ZOK
            WasJ = WasJ - 1
            GET #2,WasJ
            GOSUB 58191
            IF CanGet THEN _
               MID$(PartToPrint$,13,1) = " " : _
               ZWasY$ = LEFT$(PartToPrint$,INSTR(PartToPrint$," ") - 1) : _ ' KG091001
               ZOK = (Temp$ = ZWasY$) : _                            ' KG091001
               IF NOT ZOK THEN _
                  IF AltTemp$ <> "" THEN _
                     ZOK = (AltTemp$ = ZWasY$)                       ' KG091001
         WEND
         IF ZOK THEN _
            GOSUB 58189 : _
            IF ZOK OR IsProto THEN _
               ZWasY$ = MID$(STR$(WasJ),2) : _                       ' KG091001
               ZUserIn$(0) = ZUserIn$(0) + _
                       ZWasY$ + _                                    ' KG091001
                       SPACE$(5 - LEN(ZWasY$))                       ' KG091001
         IF NOT ZOK AND NOT IsProto THEN _
    Call GetRBBSString(70,RBBSString$) : _      'Pe 01/16/93
      OutTxt$ = RBBSString$ : _                'Pe 01/16/93
            CALL QuickTPut1 (ZWasZ$ + OutTxt$ + " - omitted") : _
            FOR WasK = WasI + 1 TO ZLastIndex : _
               ZUserIn$(WasK - 1) = ZUserIn$(WasK) : _
            NEXT : _
            ZLastIndex = ZLastIndex - 1 : _
            WasI = WasI - 1
         WasI = WasI + 1
      WEND
      ZWasQ = ZLastIndex
      RETURN
58189 IF IsProto THEN _
         RETURN
      ZUserIn$(WasI) = LEFT$(PartToPrint$,INSTR(PartToPrint$," ") - 1)
      CALL FindFile (ZPersonalDrvPath$ + ZUserIn$(WasI),ZOK)
      IF ZOK THEN _
         ZMarkedPersFile = ZTrue : _                               'Pe032001
         ZUserIn$(WasI) = ZPersonalDrvPath$ + ZUserIn$(WasI) _
     ELSE CALL RotorsDir (ZUserIn$(WasI),ZSubDir$(),ZSubDirCount + _
                      ((ZUserSecLevel < ZMinSecToView) OR _
                       NOT ZCanDnldFromUp),ZTrue,"D") : _
           GOSUB 58185
      RETURN
58191 IF LEN(Categories$) < 3 THEN _
         CanGet = ZTrue : _
         RETURN
      HoldCat$ = Category$
      CALL TrimTrail (HoldCat$," ")
      CALL AllCaps (HoldCat$)
      HoldCat$ = "," + HoldCat$ + ","
      CanGet = (INSTR(Categories$,HoldCat$) > 0)
      IF NOT CanGet THEN _
         IF ZPersonalDnld AND ZGlobalSysOp THEN _
            CanGet = ZTrue
      IF NOT CanGet THEN _
         IF ASC(Category$) = 32 THEN _
            IF LEN(HoldCat$) > 2 THEN _
               CALL CheckInt (Category$) : _
               CanGet = (ZUserSecLevel >= ZTestedIntValue)
      RETURN
58193 GOSUB 58185                ' handle new files
      PersIndex = LastRec
      ProcessedNew = ZTrue
      ZLastIndex = 0
      ZUserIn$(0) = ""
      WHILE PersIndex > 0 AND  ZLastIndex < UBOUND(ZUserIn$)
         GET 2,PersIndex
         GOSUB 58191
         IF NOT CanGet THEN _
            GOTO 58194
         IF PersonalStatus$ <> "*" THEN _
            GOTO 58194
         ZLastIndex = ZLastIndex + 1
         WasI = ZLastIndex
         GOSUB 58189
         IF ZOK THEN _
            WasX$ = MID$(STR$(PersIndex),2) : _
            ZUserIn$(0) = ZUserIn$(0) + _
                    WasX$ + _
                    SPACE$(5 - LEN(WasX$)) _
         ELSE ZLastIndex = ZLastIndex - 1
58194    PersIndex = PersIndex - 1
      WEND
      IF ZLastIndex = 0 THEN _
         ZOutTxt$ = "No new files for you" : _
         CALL QuickTPut1 (ZOutTxt$) : _
         GOTO 58183
      ZAnsIndex = 1
      GOTO 58183
58196 CALL QuickTPut (ZEmphasizeOff$,0)
      ZOutTxt$ = Temp$ + "L)ist,A)bort,T)ype,V)iew," + _             ' Pe 03/30/92
                 LEFT$("*)dnld new,",-11*ZPersonalDnld) + _
                 "M)ark" + LEFT$(",D)nld",-6*CanDnld) + ZPressEnterExpert$
      ZTurboKey = -ZTurboKeyUser
If ZDnldCompleted and ZAutoEnd = 1 THEN _   'Pe 10/22/91
         ZNonStop = ZTrue : _                            ' DD092501
         ZStopInterrupts = ZTrue : _                     ' DD092501
         ZAutoLogOffReq = ZTrue : _                      ' DD092501
         GOTO 58199                                      ' DD092501
      CALL PopCmdStack
      WasX$ = ZUserIn$(ZAnsIndex)
      CALL AllCaps (WasX$)
           IF WasX$ = "A" THEN _                         ' DD012304
         ZLastIndex = 0 : _                              ' DD012304
         ZRet = ZTrue                                    ' DD012304
      IF ZWasQ = 0 OR ZRet OR ZSubParm < 0 THEN _
         GOTO 58198
'
      IF WasX$ = "L" THEN _
         ZActiveFMSDir$ = OrigDir$ : _
         GOSUB 58185 : _
         AtEndList = ZFalse : _
         GOTO 58168   
'
'Type TXT file mod  Pe 10/21/89
'
      IF WasX$ = "T" THEN _
         CALL TypeFile : _
         ZwasA = UpldIndex : _
         GOSUB 58185 : _
         UpldIndex = ZwasA : _
         GOTO 58180
'
'
      IF WasX$ = "V" THEN IF CanView THEN _
         CALL GetArc : _
         ZJumpSupported = ZTrue : _
         ZWasA = UpldIndex : _
         GOSUB 58185 : _
         UpldIndex = ZWasA : _
         GOTO 58180
         ZYes = ZFalse 
         Goto 58181
58198 CLOSE 2
      ZNonStop = (ZPageLength < 1)
      ZStopInterrupts = ZFalse
58199 ZOutTxt$ = ""                                      ' DD092501
      ZActiveFMSDir$ = ""
      ZJumpSupported = ZFalse
      DnldFlag = 0
      EXIT SUB
      END SUB

58200 ' $SUBTITLE: 'FMS - subroutine to search the upload management system'
' $PAGE
'
'  NAME    -- FMS
'
'  INPUTS  -- PARAMETER                      MEANING
'             DirToSearch$          RBBS-PC "DIR" CATEGORY TO LOOK
'                                     FOR
'             SearchString$          STRING TO SEARCH FOR
'             SearchDate$            DATE TO SEARCH FOR
'             ZCategoryName$()
'             ZCategoryCode$()
'             ZCategoryDesc$()
'             CatFound
'             ZNumCategories
'
'  OUTPUTS -- ProcessedInFMS
'             DnldFlag
'
'  PURPOSE -- To search the file management system and display the
'             files being searched for as well as the catetory descriptions
'
      SUB FMS (DirToSearch$,SearchString$,SearchDate$, _
               ProcessedInFMS,ZCategoryName$(1),ZCategoryCode$(1), _
               ZCategoryDesc$(1),DnldFlag,CatFound,AbortIndex) STATIC
      DnldFlag = 0
      CALL SearchArray (DirToSearch$,ZCategoryName$(),ZNumCategories,CatFound)
      ProcessedInFMS = ProcessedInFMS OR (CatFound > 0)
IF ZFG4$ <> "" THEN _
	FG5$ = ZEscape$ + "[1;34;40m" : _
	FG6$ = ZEscape$ + "[1;37;41m" : _
	FG7$ = ZEscape$ + "[1;37;44m"         'Pe 02/05/90
      IF ProcessedInFMS THEN _
         ZSubParm = 5 : _
         GOSUB 58202 : _
	 CALL QuickTPut("",1) : _
	 CALL QuickTPut(FG5$+""+FG6$+" "+DirToSearch$+" "+FG5$+"",0) : _
	 CALL QuickTPut(FG6$ +" "+ ZCategoryDesc$(CatFound) +" " + FG5$ + "" + _
		    ZFG3$+" " +  SrchDir$,1) : _
	 CALL QuickTPut(FG5$+ "",1)  : _
	 CALL QuickTPut(""+FG7$+"File Name"+FG5$+"" + FG7$ + "Size" + _
		    FG5$+"",0) : _
	 CALL QuickTPut(FG7$+"Date"+FG5$+""+FG7$ + "Description"+ _
	      FG5$+""+ZFG3$+" "+ZEmphasizeOff$,1) : _
	 Cat$ = ZCategoryCode$(CatFound) : _
	 CALL DispUpDir (CAT$,SearchString$,SearchDate$,DnldFlag,AbortIndex)
      EXIT SUB
58202 ZOutTxt$ = SearchDate$
      IF LEN(ZOutTxt$) > 0 THEN _
         ZOutTxt$ = MID$(ZOutTxt$,3) + LEFT$(ZOutTxt$,2)
      SrchDir$ = SearchString$ + _
             ZOutTxt$
      IF SrchDir$ <> "" THEN _
          SrchDir$ = ZFG4$ + "Scanning for "  + ZFG2$ + SrchDir$
      RETURN
      END SUB

58895 ' $SUBTITLE: 'GetDirs -- Prompt for directories to search'
' $PAGE
'
'  NAME    -- GetDirs
'
'  INPUTS  --     PARAMETER                    MEANING
'                 ZDirPrompt$             BASE OF DIRECTORY PROMPT
'                 ShowHelp               Whether to display help
'                                            on entry
'  OUTPUTS --     ZUserIn$
'                 ZWasQ
'
'  PURPOSE -- Prompt for directories to search
'
      SUB GetDirs (ShowHelp) STATIC
      IF ShowHelp AND (ZAnsIndex >= ZLastIndex ) THEN _
         GOTO 58902
58900 If ZEndList = ZTrue Then _     'Lk11/29/91
      Exit Sub                       'Lk 11/29/91
      ZOutTxt$ = ZDirPrompt$
      ZMacroMin = 2
      CALL PopCmdStack
      IF ZWasQ = 0 OR ZSubParm = -1 THEN _
         EXIT SUB
      CALL AraAllCaps (ZUserIn$(),ZAnsIndex)
      IF ZUserIn$(ZAnsIndex) = "Q" THEN _
         ZWasQ = 0 : _
         EXIT SUB
      ZWasA = INSTR("E+.E-.E.L.H.?.",ZUserIn$(ZAnsIndex)+".")
      IF ZWasA = 0 THEN _
         EXIT SUB
      IF ZWasA > 8 THEN _
         IF ZAnsIndex < ZLastIndex THEN _
            GOTO 58900 _
         ELSE GOTO 58902
      IF ZWasA = 7 THEN _
         ZExtendedOff = NOT ZExtendedOff _
      ELSE ZExtendedOff = (ZWasA > 3)
      Call GetRBBSString(116,RBBSString$)     'Pe 01/16/93
      OutTxt$ = RBBSString$                 'Pe 01/16/93
      CALL QuickTPut1 (OutTxt$ + "  "+FNOffOn$(NOT ZExtendedOff))
      GOTO 58900
58902 ZFileName$ = ZCurDirPath$ + ZDirPrefix$ + _
                    "." + ZDirExtension$
      CALL Graphic (ZFileName$)
      CALL BufFile (ZFileName$,ZAnsIndex)
      GOTO 58900
      END SUB
'
58950 ' $SUBTITLE: 'ConvertDir -- Converts coded response to right directory'
' $PAGE
'
'  NAME    -- ConvertDir
'
'  INPUTS  --     PARAMETER                    MEANING
'                 Start               ELEMENT TO BEGIN WITH
'                 ZUserIn$            ARRAY TO CONVERT
'                 ZWasQ               Last ELEMENT TO CONVERT
'
'  OUTPUTS --     ZUserIn$            CONVERTED DIRECTORY LIST
'
'  PURPOSE -- Let the user put in a short standard string for a directory
'
'
      SUB ConvertDir (Start) STATIC
      FOR WasI=Start TO ZLastIndex
         CALL AraAllCaps (ZUserIn$(),WasI)
         IF ZUserIn$(WasI)="U" THEN _
            ZUserIn$(WasI) = ZUpldDirCheck$
         IF ZUserIn$(WasI) = "A" THEN _
            ZUserIn$(WasI) = "ALL"
      NEXT
      END SUB


'
' $SUBTITLE: 'TypeFile - subroutine to TYPE an ASCII FILE'
' $PAGE
'
'  NAME    -- TYPEAFILE
'
'  PARAMETERs          
'                      
'                      
'                      
'
'  PURPOSE -- Type a ASCII file to screen
'
      SUB TypeFile STATIC
59141 CALL SkipLine (1)
         Call GetRBBSString(300,RBBSString$)     'Pe 01/16/93
       ZOutTxt$ = RBBSString$+ZPressEnterExpert$
        CALL PopCmdStack
       IF ZSubParm = -1 OR ZWasQ = 0 THEN _
      EXIT SUB
59142 ZViolation$ = "TYPE File"
      WasX = ZAnsIndex
     FOR ZAnsIndex = WasX TO ZLastIndex
      GOSUB 59143
        IF ZSubParm < 0 THEN _
       ZAnsIndex = ZLastIndex + 1
      NEXT ZAnsIndex
      IF ZLastIndex > 1 THEN _
         EXIT SUB _
      ELSE GOTO 59141
59143  WasZ$ = ZUserIn$(ZAnsIndex)
       CALL AllCaps (WasZ$)
    IF INSTR(WasZ$,"*") OR INSTR(WasZ$,"?") THEN _
    Call GetRBBSString(51,RBBSString$) : _      'Pe 01/16/93
      OutTxt$ = RBBSString$ : _                'Pe 01/16/93
   CALL QuickTPut (OutTxt$,1) : _
    RETURN
       ZFileName$ = WasZ$
        ZFileNameHold$ = WasZ$
         CALL BadFile (ZFileNameHold$,BadFileNameIndex)
        ON BadFileNameIndex GOTO 59145,59148,59150
59145 CALL BadName (BadFileNameIndex,ZTrue)          'Pe 06/03/91
      ON BadFileNameIndex GOTO 59146,59150
59146 CALL RotorsDir (ZFileName$,ZSubDir$(),ZSubDirCount + (NOT ZSysop),ZTrue,"V") 'Pe 02/25/90
       IF ZOK THEN _        ' Pe 02/06/90
        GOTO 59158
'
'**********************8 Pe 08/12/91 next 5 lines *********
If ZPersonalDnld or ZMarkedPersFile Then _                   'Pe032001
  ZFileName$ = ZPersonalDrvPath$ + WasZ$ : _
CALL FindFile (ZFileName$,ZOK)
 IF ZOK THEN _
    GOTO 59158
'************************************************************
59148 WasZ$ = ZUserIn$(ZAnsIndex) + _
           " not found!"
      CALL UpdtCalr (WasZ$,2)
      ZOutTxt$ = WasZ$ + _
           " Type correct filename" + ZPressEnterExpert$
      ZSubParm = 1
      CALL TGet
      IF ZSubParm = -1 OR ZWasQ = 0 THEN _
         RETURN
      ZUserIn$(ZAnsIndex) = ZUserIn$(1) 
      GOTO 59143
59150 CALL SecViolation
      IF ZDenyAccess THEN _
         EXIT SUB
      GOTO 59148
59158 CALL BreakFileName (WasZ$,Drive$,Prefix$,Ext$,ZFalse)
      IF Ext$ = "" THEN _
        GOTO 59160
      IF INSTR("DWC,COM,EXE,GIF,PIC,DAT,BIN,ZIP,ARC,LZH,ZOO,PAK,ARJ,",Ext$+",") > 0 THEN _
    Call GetRBBSString(117,RBBSString$) : _      'Pe 01/16/93
      OutTxt$ = RBBSString$ : _                'Pe 01/16/93
 CALL QuickTPut (OutTxt$ + " " +Ext$ ,1) : _
         RETURN
59160  CALL BufFile (ZFileName$,WasX) 
       RETURN
       END SUB
'************************ Pe 01/25/92  to end of file **************
'
' $SUBTITLE: 'WhoDidIt - subroutine to Display Who Uploaded that file'
' $PAGE
'
'  NAME    -- WhoDidIt
'
'  PARAMETERs None
'                      
'                      
'                      
'
'PURPOSE - Maple Version of RBBS creates a file Called Uploadlg.def
'          this file keeps track of who Uploaded what file
'          File location is Drive/Path were *.DIR files are stored 'Pe 03/13/92
'          Allows reading UPLOADLG.DEF file in reverse order
'
      SUB WhoDidIt STATIC
59500 CALL SkipLine (3)
    Call GetRBBSString(118,RBBSString$)      'Pe 01/16/93
      OutTxt$ = RBBSString$                 'Pe 01/16/93
Call QuickTput1 (OutTxt$)
    Call GetRBBSString (119,RBBSString$)
      OutTxt$ = RBBSString$
    Call Quicktput1 (OutTxt$)
    Call GetRBBSString(118,RBBSString$)      'Pe 01/16/93
      OutTxt$ = RBBSString$                 'Pe 01/16/93
Call QuickTput1(OutTxt$)
    Close 8
   IF ZShareIt THEN _
     OPEN ZDirPath$ +"UPLOADLG.DEF" FOR RANDOM SHARED AS #8 LEN=86 _  'Pe 03/13/92
        ELSE OPEN "R",8,ZDirPAth$ +"UPLOADLG.DEF",86                  'Pe 03/13/92
                   FIELD 8,84 AS ShowUp$, _
                   2 AS fill$
         RecordNum! = FIX(LOF(8) / 86)
        ZJumpSupported = ZTrue
       ZJumpSearching = ZFalse
      ZJumpLast$ = ""
59502 If RecordNum! < 1 OR ZRet THEN  _
       GOTO 59560
        Get #8, RecordNum!
         ZOutTxt$ = ShowUp$
          RecordNum! = RecordNum! - 1

' Do Not display Sysop only and Personall Uploads

 IF INSTR(ZOutTxt$,"*") > 0 and NOT ZSysop THEN _
          GOTO 59502

         GOSUB 59550
        GOTO 59502      

59550   IF ZJumpSearching THEN _
          ZWasDF$ = ZOutTxt$ : _
           CALL AllCaps (ZWasDF$) : _
            IF INSTR(ZWasDF$,ZJumpTo$) = 0 THEN _
               Return _
             ELSE CALL CheckColor (ZOutTxt$,ZJumpTo$,"") : _
              ZJumpSearching = ZFalse
             ZSubParm = 5
            CALL SmartText (ZOutTxt$,ZTrue,ZFalse,ZFalse)
           CALL Tput
          WasX=1
        CALL AskMore ("",ZTrue,ZTrue,WasX,ZFalse)
         IF ZNo OR ZSubParm = -1 THEN _
            ZJumpSupported = ZFalse : _
              ZJumpSearching = ZFalse : _
               ZJumpLast$ = "" : _
              Close 8 : _
           Exit Sub 
      Return
59560 IF ZJumpSearching Then _
    Call GetRBBSString(120,RBBSString$) : _      'Pe 01/16/93
      OutTxt$ = RBBSString$ : _                'Pe 01/16/93
      Call QuickTput1 (OutTxt$)
      ZJumpSupported = ZFalse
      ZJumpSearching = ZFalse
      ZJumpLast$ = ""
      Close 8
     End Sub

59780 ' $SUBTITLE: 'GetAll -- subroutine to create directory list'
' $PAGE
'
'  NAME    -- GetAll
'
'  INPUTS  --   PARAMETER     MEANING
'               LookIn$       NAME OF FILE TO SEARCH
'               DIR.EXT$      MAIN DIRECTORY EXTENSION TO USE
'               StartPos      Last POSITION USED IN ARRAY
'
'  OUTPUTS      StartPos     Last ELEMENT USED IN ARRAY
'               LoadInto$    ARRAY TO LOAD ELEMENTS Found
'
'  PURPOSE -- Creates a list (LoadInto$) of all directories
'             to be listed when A)ll is selected for a directory.
'             All uses config parm, which can be either a single
'             directory or list of directories (begin with "@").
'
      SUB GetAll (LoadInto$(1), StartPos) STATIC
      IF ZMasterDirName$ <> "" AND LEFT$(ZMasterDirName$,1) <> "@" THEN _
         StartPos = StartPos + 1 : _
         LoadInto$(StartPos) = ZMasterDirName$ : _
         EXIT SUB
      ZOK = ZFalse
      IF LEN (ZMasterDirName$) > 1 AND LEFT$(ZMasterDirName$,1) = "@" THEN _
         CALL FindIt(MID$(ZMasterDirName$,2))
      IF NOT ZOK THEN _
      Call GetRBBSString(137,RBBSString$) : _     'Pe 01/16/93
       OutTxt$ = RBBSString$ : _                'Pe 01/16/93
         CALL QuickTPut1 (OutTxt$) : _
         EXIT SUB
      MaxLoad = UBOUND(LoadInto$, 1)
      StartSort = StartPos + 1
      WHILE NOT EOF(2) AND StartPos < MaxLoad
         LINE INPUT #2, ZOutTxt$
         StartPos = StartPos + 1
         LoadInto$(StartPos) = ZOutTxt$
      WEND
      CLOSE 2
      END SUB

59920 ' $SUBTITLE: 'ColorDir - builds a color FMS directory string'
' $PAGE
'
'  NAME    --  ColorDir
'
'  INPUTS  --  PARAMETER                   MEANING
'               Strng$              String to alter
'               FMSDir$            "Y" FOR FMS DIR
'                                  "N" FOR PERSONAL Download
'
      SUB ColorDir (Strng$,FMSDir$) STATIC
      IF ZWasGR < 2 THEN _
         EXIT SUB
      IF FMSDir$ = "N" THEN _
         GOTO 59921
'
' INSERT COLOR FOR FILENAME
'
      ON INSTR("\ *",LEFT$(Strng$,1)) GOTO 59924,59922,59923
59921 Strng$ = ZDR1$ + LEFT$(Strng$,13) + ZDR2$ + MID$(Strng$,14,10) + _
               ZDR3$ + MID$(Strng$,24,10) + ZDR4$ + MID$(Strng$,34,ZMaxDescLen) + _
               ZEmphasizeoff$         'Pe 03/15/92
      EXIT SUB
59922 Strng$ = ZDR4$ + Strng$
      EXIT SUB
59923 Strng$ = ZEmphasizeOff$ + Strng$
59924 END SUB

62600 ' $SUBTITLE: 'Protocol - Determine protocols available'
' $PAGE
'
'  NAME    -- Protocol
'
'  INPUTS  --     PARAMETER                    MEANING
'                 ZProtoDef$                File of installed protocols
'
'  OUTPUTS -- ZTransferOption$         Prompt for protocol choice
'             ZDefaultXfer$            Letters of protocols
'             ZInternalEquiv$          Internal protocol to use
'
'  PURPOSE -- TO determine what protocols are available to user
'
      SUB Protocol STATIC
      CALL FindIt (ZProtoDef$)
      IF NOT ZOK THEN _
         ZTransferOption$ = "A)scii,X)modem,C)rcXmodem,Y)modem" : _
         ZInternalEquiv$ = "AXCY" : _
         ZDefaultXfer$ = "AXCY" : _
         GOTO 62604
      ZDefaultXfer$ = ""
      ZInternalEquiv$ = ""
      ZTransferOption$ = ""
      WasL = 0
62602 IF EOF(2) THEN _
         GOTO 62604
      CALL ReadParms (ZWorkAra$(),13,1)
      IF ZErrCode > 0 THEN _
         EXIT SUB
      ZDefaultXfer$ = ZDefaultXfer$ + " "
      ZInternalEquiv$ = ZInternalEquiv$ + " "
      IF ZUserSecLevel < VAL(ZWorkAra$(2)) THEN _
         GOTO 62602
      IF LEFT$(ZWorkAra$(5),1) = "R" THEN _
         IF NOT ZReliableMode THEN _
            GOTO 62602
      IF LEFT$(ZWorkAra$(3),1) = "I" THEN _
         GOTO 62603
      WasX = INSTR(ZWorkAra$(12)+" "," ")
      WasX$ = LEFT$(ZWorkAra$(12),WasX-1)
      CALL FindFile (WasX$,Found)
      IF Found THEN _
         WasX = INSTR(ZWorkAra$(13)+" "," ") : _
         WasX$ = LEFT$(ZWorkAra$(13),WasX-1) : _
         CALL FindFile (WasX$,Found)
      IF NOT Found THEN _
         GOTO 62602
62603 MID$(ZDefaultXfer$,LEN(ZDefaultXfer$),1) = LEFT$(ZWorkAra$(1),1)
      CALL FindLast (ZWorkAra$(1),ZCrLf$,WasX,WasI)
      IF WasX > 0 AND WasX >= LEN(ZWorkAra$(1)) - 2 THEN _
         ZWorkAra$(1) = LEFT$(ZWorkAra$(1),WasX-1)
      IF (WasL + LEN(ZWorkAra$(1)) < 62) AND WasX = 0 THEN _
         ZTransferOption$ = ZTransferOption$ + "," + ZWorkAra$(1) : _
         WasL = WasL + LEN(ZWorkAra$(1)) + 1 _
      ELSE WasL = LEN(ZWorkAra$(1)) : _
           ZTransferOption$ = ZTransferOption$ + _
                              ZCrLf$ + _
                              ZWorkAra$(1)
      IF LEFT$(ZWorkAra$(3),1) = "I" AND RIGHT$(ZWorkAra$(3),1) <> "I" THEN _
         MID$(ZInternalEquiv$,LEN(ZInternalEquiv$),1) = RIGHT$(ZWorkAra$(3),1)
      GOTO 62602
62604 IF INSTR(ZInternalEquiv$,"N") > 0 THEN _
         GOTO 62605
      IF WasX = 0 THEN _
         ZTransferOption$ = ZTransferOption$ + ",N)one" _
      ELSE ZTransferOption$ = ZTransferOption$ + ZCrLf$ + "N)one"
      ZDefaultXfer$ = ZDefaultXfer$ + "N"
      ZInternalEquiv$ = ZInternalEquiv$ + "N"
62605 IF LEFT$(ZTransferOption$,1) = "," THEN _
         ZTransferOption$ = MID$(ZTransferOption$,2)
      IF INSTR(ZDefaultXfer$,ZUserXferDefault$) = 0 THEN _
       Call GetRBBSString(143,RBBSString$) : _      'Pe 01/16/93
       OutTxt$ = RBBSString$ : _                 'Pe 01/16/93
         CALL QuickTPut1 ("Protocol "+ZUserXferDefault$+OutTxt$) : _
         ZUserXferDefault$ = MID$(ZDefaultXfer$,INSTR(ZInternalEquiv$,"N"),1)
      END SUB
62620 ' $SUBTITLE: 'Transfer - Subroutine for external protocols'
' $PAGE
'
'  NAME    -- Transfer
'
'  INPUTS  --     PARAMETER                    MEANING
'              ZTransferFunction         = 1 DOWNLOAD FILE TO USER
'                                        = 2 UPLOAD FILE TO RBBS-PC
'              ZFileName$                NAME OF FILE FOR Transfer
'              ZComPort$                 NAME OF COMMUNICATIONS PORT
'                                        TO BE USED BY KERMIT (COM1
'                                        OR COM2)
'              ZBPS                      = -1 FOR   300 BAUD
'                                        = -2 FOR   450 BAUD
'                                        = -3 FOR  1200 BAUD
'                                        = -4 FOR  2400 BAUD
'                                        = -5 FOR  4800 BAUD
'                                        = -6 FOR  9600 BAUD
'                                        = -7 FOR 14400 BAUD
'                                        = -8 FOR 19200 BAUD
'
'  OUTPUTS  -- NONE
'
'  PURPOSE -- To transfer files using external protocols
'
      SUB Transfer STATIC
IF ZUpBatchTransfer Then _
   Exit Sub
      IF ZPrivateDoor THEN _
         CALL PrivDoorRtn : _
         EXIT SUB
      IF ZTransferFunction = 1 THEN _
         ZUserIn$ = ZDownTemplate$ : _
         ZWasZ$ = "send " _
      ELSE IF ZTransferFunction = 2 THEN _
              ZUserIn$ = ZUpTemplate$ : _
              ZWasZ$ = "receive "
      CALL MetaGSR (ZUserIn$,ZFalse)
      CALL QuickTPut1 ("Protocol     : "+ZProtoPrompt$)
      CALL QuickTPut ("Ready to " + ZWasZ$ + " ",0)
'
      IF ZBatchTransfer or ZWasBatchTransfer THEN _        'Pe BatchUp mod
         CALL QuickTPut1 ("(BATCH)")  _
      ELSE CALL QuickTPut1 (ZFileNameHold$)
'
   IF ZWasBatchTransfer THEN _                             'Pe BatchUp mod
        Temp$ = ZBatchWorkFile$ _
          ELSE IF ZBatchTransfer Then _
        Temp$ = ZNodeWorkFile$  
   IF ZBatchTransfer or ZWasBatchTransfer THEN _        'Pe BatchUp mod
       CALL OpenWork (2,Temp$) : _
          WHILE NOT EOF(2) : _
            CALL ReadAny : _
           CALL BreakFileName (ZOutTxt$,ZWasZ$,ZWasY$,WasX$,ZTrue) : _
         CALL QuickTPut1 ("   "+ZWasY$+WasX$) : _
     WEND
'
      IF ZAutoEnd = 1 THEN _                  'Pe 03/30/92
       Call GetRBBSString(69,RBBSString$) : _      'Pe 01/16/93
       OutTxt$ = RBBSString$ : _                 'Pe 01/16/93
         CALL QuickTPut1 (OutTxt$)
      CALL PrivDoorRtn
      END SUB

64640 ' * SysOp function 5 - change xfer stats
      SUB CmndSysOpXfer STATIC
       Call GetRBBSString(150,RBBSString$)      'Pe 01/16/93
       OutTxt$ = RBBSString$
      CALL QuickTPut1 (OutTxt$)
      ZOutTxt$ = "Upload file total"
      GOSUB 64642
      IF LEN(ZUserIn$(1)) > 0 THEN _
         LSET ZUserUplds$ = MKI$(VAL(ZUserIn$(1)))
      ZOutTxt$ = "Upload byte total"
      GOSUB 64642
      IF LEN(ZUserIn$(1)) > 0 THEN _
         LSET ZULBytes$ = MKS$(VAL(ZUserIn$(1)))
      ZOutTxt$ = "Download file total"
      GOSUB 64642
      IF LEN(ZUserIn$(1)) > 0 THEN _
         LSET ZUserDnlds$ = MKI$(VAL(ZUserIn$(1)))
      ZOutTxt$ = "Download byte total"
      GOSUB 64642
      IF LEN(ZUserIn$(1)) > 0 THEN _
         LSET ZDlBytes$ = MKS$(VAL(ZUserIn$(1)))
      ZOutTxt$ = "Files downloaded TODAY"
      GOSUB 64642
      IF LEN(ZUserIn$(1)) > 0 THEN _
         LSET ZTodayDl$ = MKS$(VAL(ZUserIn$(1)))
      ZOutTxt$ = "Bytes downloaded TODAY"
      GOSUB 64642
      IF LEN(ZUserIn$(1)) > 0 THEN _
         LSET ZTodayBytes$ = MKS$(VAL(ZUserIn$(1)))
      EXIT SUB
64642 ZSubParm = 1
      CALL TGet
      IF ZSubParm >= 0 THEN _
         RETURN
      END SUB
'
' $SUBTITLE: 'AutoLogOff - Subroutine to  to log off after transfer'
' $PAGE
'
  SUB AutoLogOff STATIC
       ZAutoEnd = 0
       ZAbort = ZFalse    'Pe 01/19/92
       IF ZGetExtDesc = ZTrue or ZOK = ZFalse or ZAutoLogOffReq = ZTrue THEN _
       EXIT SUB
       ZSubParm = 1
       ZStackC = ZTrue    'Pe 12/21/91
64989  ZStopInterrupts = ZTrue   'Pe 04/17/92
       CALL BufFile(ZHelpPath$+"AUTOOFF.MNU",X)     ' MO 04/13/92
'      ZOutTxt$ = " C)ontinue with transfer " + ZCrLf$ + _
'                 " A)bort transfer - Cancel"+ ZCrLf$ + _
'                 " G)o ahead LOG-OFF after Transfer " + ZCrLf$ + _
'                 ZCrLf$ + "Press [Enter] to continue or select (C,A,G)->"
       ZStopInterrupts = ZFalse    'Pe 04/17/92
       ZOutTxt$ = "Select ([C],A,G) "
       ZTurboKey = -ZTurboKeyUser
      ZSubParm = 1
      Call TGet
      CALL AllCaps (ZUserIn$)
      WasMplx = INSTR("CAG",ZUserIn$)
      CALL Carrier                      'Pe 03/06/92
      IF ZSubParm = -1 THEN _           'Pe 03/06/92
      ZFileSysParm = 7 : _              'Pe 03/06/92
      EXIT SUB                          'Pe 03/06/92
IF ZUserIn$ = "" or ZUserIn$ = " " Then _
      GOTO 64995
   ON WasMplx GOTO 64995,64990,64998
      GOTO 64989
64990 ZAutoEnd = 2
      Call Skipline (2)
      EXIT SUB
64995 ZAutoEnd = 3
      Call Skipline (2)
      EXIT SUB
64998 ZAutoEnd = 1
      ZAutoLogoffReq = ZTrue     'Pe 12/20/92
      Call SkipLine (2)
      END SUB
'
' $SUBTITLE: 'BatchUpload --- Handles Batch uploads'
' $PAGE
'
SUB BatchUpload (ZDesc$,ZUCat$,WasFF) STATIC
On WasFF GOTO 69000, 69500
69000    CALL OpenWorkA ("BatchUp" +ZNodeID$ +".LST")
         Call PrintWorkA (ZFileName$)
         CALL PrintWorkA (ZFileNameHold$)
         CALL PrintWorkA (ZDesc$)
         CALL PrintWorkA (ZUcat$)
        Close 2
     CALL OpenWorkA (ZBatchWorkFile$) 
       CALL PrintWorkA (ZFileName$)
     Close 2
IF ZAnsindex = ZLastIndex THEN 
      ZUpBatchTransfer = ZFalse
      ZWasBatchTransfer = ZTrue
  End IF
Exit Sub
'
'
69500 CALL KillWork (ZBatchWorkFile$)
      ZErrCode = 0
    Temp$ = "BatchUp" + ZNodeid$ + ".LST"
      CALL OpenWork (8,Temp$)
         While Not EOF(8)
       Line Input #8,ZFileName$
       Line Input #8,ZFileNameHold$
       Line Input #8,ZDesc$
       Line Input #8,ZUCat$
        Call Findit (ZFileName$)
    IF ZOK THEN _
      CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(), ZLinesInMsg,2) _
        Else CALL UpdtCalr (ZFileNameHold$ + " ABORTED during BatchUL",2) 
          ZWasBatchTransfer = ZFalse                  'Pe 09/12/91
         ZAlreadyGiven = ZTrue
       Wend
     Close 8
End Sub

69600 ' $SUBTITLE: 'BATCHIT - subroutine to list files for batch downloading'
' $PAGE
'
 SUB BATCHIT STATIC
      CALL PutCom (CHR$(7))
        Call GetRBBSString(205,RBBSString$) : _      'Pe 01/16/93
        OutTxt$ = RBBSString$ : _                'Pe 01/16/93
      CALL QuickTPUT (OutTxt$,1)
       ZWasB=1
       FOR BatchF = 2 TO 25
        ZOutTxt$ = "Name of file #" + STR$(Batchf-1)
        Call TGet
         IF ZUserIn$ = "" THEN GOTO 70415
          ZUserIn$(BatchF) = ZUserIn$
          ZAnsIndex = BatchF+1
        NEXT BatchF
70415 BatchF =  BatchF-1
      ZLastIndex = BatchF
        End Sub
