; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will shift an integer right a specified number of bit positions.
;
; Usage:  Result% = BitsShr(Input%,ShiftRight%)
; Declare: DECLARE FUNCTION BitsShr% (BYVAL Input%, BYVAL ShiftRight%)
;
; Where Result% contains our new number, Input% contains the number to
; alter, and ShiftRight% contains the number of bits to shift.
;
; The right bit is shifted over and a zero moved in.  ShiftRight% of 0
; does nothing, of 16 returns a zero.
;

.Model Medium, Basic
.Code

            PUBLIC  BitsShr           ;Make this routine available to LINK.

BitsShr     proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            mov     cx,[bp + 06]      ;Get size, all we really want is CL.
            mov     ax,[bp + 08]      ;Get what we should shift.
            shr     ax,cl             ;Do shift for size sent.
            pop     bp
            ret     4                 ;Pop-return past our input parameters.

BitsShr     endp                      ;End of routine.

End


