; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will send a string out the comm port using the fossil.
;
; Usage:  CALL BlockOut(CommPort%,Send$)
; Declare: DECLARE SUB BlockOut (BYVAL CommPort%, Send$)
;
; Where CommPort% is the port number to send to (1...n) and Send$ is the
; string to output.
;
; The equivalent Basic code:
;  SUB BlockOut (K0,K$)
;  IF K0 = 0 THEN EXIT SUB
;  InRegX.AX = &H1900
;  InRegX.DX = K0 - 1
;  InRegX.CX = LEN(K$)
;  InRegX.ES = VARSEG(K$)
;  InRegX.DI = SADD(K$)
;  CALL InterruptX(&H14,InRegX,OutRegX)
;  END SUB
;

.Model Medium, Basic
.Code
 
            PUBLIC  BlockOut          ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

BlockOut    proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     ax,[bp + 08]      ;Get our Port%.
            dec     ax
            js      Done              ;They sent us a zero so exit.
            push    ax

            mov     ax,[bp + 06]      ;Get descriptor of the string.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     cx,di
            pop     si
            jcxz    Done              ;If a null string, then exit.
            mov     es,dx
            mov     di,ax

            mov     dx,si

            mov     ah,19H            ;Fossil subfunction 19H.
            int     14H               ;Call the fossil.  Send ES:DI for len CX.

     Done:  pop     bp
            ret     4                 ;Pop-return past our input parameters.
 
BlockOut    endp                      ;End of routine.

End





