; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will delay for a certain amount of time.
;
; Usage:  CALL DelayTiny(Amount%)
; Declare:  DECLARE SUB DelayTiny(BYVAL Amount%)
;
; Where Amount% is the number of 55ms to delay.  Thus 19 delays for 1 second
; (1000 ms).
;
; Well, actually 19 delays for 1042 ms, a little longer than a second.  Also,
; this routine guarantees a delay for at least the amount of time requested,
; it may delay for up to an additional 55ms longer though.
;
; It works by checking the clock at each 18.2 clock cycle.  It should
; therefore be compatible with multi-taskers.  If running under a
; multi-tasker, however, then it's possible for the additional delay time to
; exceed 55ms--depending on how you've time-sliced your applications.
;
; Because it adds at least 1 55ms delay, sending a zero will still get a
; delay--thus this routine isn't appropriate when you don't want delays.
; (Example: CALL DelayTiny(19 * K), K = 0 => don't delay.  Won't work.)
;

.Model Medium, Basic
.Code

            PUBLIC  DelayTiny         ;Make this routine available to LINK.

DelayTiny   proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            push    ds
            mov     cx,[bp + 06]      ;Get number of clock ticks to delay.
            inc     cx                ;Add one more to make sure we do at
                                      ;least the amount specified at minimum.
            xor     bx,bx             ;Pretend our last clock was 0.
            mov     ds,bx             ;Segment zero for the clock.
      R1:   mov     ax,ds:[046CH]     ;Get the clock value.
            cmp     bx,ax             ;Compare the last clock value with the
                                      ;current value.
            je      R1                ;Keep comparing until it changes.
            mov     bx,ax             ;Update our last clock value.
            loop    R1                ;Loop until CX = 0.
            pop     ds
            pop     bp
            ret     2                 ;Pop-return past our input parameter.

DelayTiny   endp                      ;End of routine.

End

