; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine returns with the amount of free space, in bytes, on a drive.
;
; Usage:  Result& = DriveSpc&(Drive$)
; Declare:  DECLARE FUNCTION DriveSpc& (Drive$)
;
; Where Result& is the resulting free drive space in bytes, and Drive$ is the
; drive to look at (A, B, C, etc.).
;
; No checking is done to see that the string contains a valid drive.  A null
; string returns a zero.  An error returns a -1.
;

.Model Medium, Basic
.Code

            PUBLIC  DriveSpc          ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

DriveSpc    proc    uses DS, Descriptor

            mov     ax,Descriptor     ;Get descriptor of Drive$.
            push    ax
            call    StringAddress     ;Returns address in DX:AX
            push    ds
            mov     ds,dx
            mov     bx,ax
            mov     dl,[bx]           ;Get drive letter.
            pop     ds

            cmp     dl,97             ;If a lower case letter,
            jl      R1
            sub     dl,32             ;then uppercase it.
       R1:  sub     dl,64             ;Adjust to A = 1, etc.

            mov     ah,36H            ;Subfunction 36H.
            int     21H               ;Call DOS services.
            mov     dx,0FFFFH         ;Exit with -1 if error.
            cmp     ax,dx             ;Check for an error.
            jz      Done              ;If -1, then exit.
                                      ;AX contains sectors per cluster.
            mul     cx                ;Multiply AX times bytes per sector.
            mul     bx                ;Multiply AX times available clusters.

      Done: ret

DriveSpc    endp                      ;End of routine.

End

