; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will return the length of a file, divided by a divisor.
;
; Usage:  Result& = FileLof&(Handle%, Divisor%)
; Declare: DECLARE FUNCTION FileLof& (BYVAL Handle%, BYVAL Divisor%)
;
; Where Handle% is the file handle to use, Divisor% is the divisor to divide
; the length by, and Result& is the result of the length divided by Divisor%.
;
; Returns LOF \ Divisor% which will be an integer if Divisor% <> 1.
; Returns LOF which will be a long if Divisor% = 1.
;
; This routine does change the location of the pointer in the file.
;
; It returns the true 1..n length (not zero based, ie. if file is one char
; big then the value it returns is 1).
;

.Model Medium, Basic
.Code

            PUBLIC  FileLof           ;Make this routine available to LINK.

FileLof     proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     bx,[bp + 08]      ;Get the file handle into BX.
            xor     cx,cx             ;DOS wants offset (location) in CX:DX.
            mov     dx,cx
            mov     ax,4202H          ;Subfunction to seek to EOF in file.
            int     21H               ;Call DOS Services to do it.

            mov     cx,[bp + 06]      ;Put record Divisor% into CX.
            cmp     cx,1              ;If Divisor% was one, don't divide,
            je      Done              ;and exit with long size.

            div     cx                ;AX <- DX:AX \ CX
            xor     dx,dx             ;Exit with an integer value.

      Done: pop     bp
            ret     4                 ;Pop-return past our input parameters.

FileLof     endp                      ;End of routine.

End




