; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine searches for file names that match a given pattern.  If a null
; is used, it finds the next file name matching that pattern.
; 
; Usage:  Result% = FindF (FileName$,FFile)
; Declare:  DECLARE FUNCTION FindF% (FileName$, FFile AS FileInfo)
;
; Where FileName$ is the drive\path\filename pattern to match, FFile is a
; record of type FileInfo into which we return our found information, and
; Result% contains either a non-zero pseudo time-date stamp, or zero to
; represent no file found.
;
; It's assumed the path and file specs don't exceed 64 characters.
;
; Directory Entries are ignored.
;
; Works if FileName$ has trailing spaces.
;
; The (more or less) equivalent Basic source code:
;
; FUNCTION FindF% (K$,KT AS FileInfo)
; STATIC DTASeg AS INTEGER
; STATIC DTAOff AS INTEGER
; DO
;   SELECT CASE K$
;     CASE Null$, " " : InRegX.AX = &H4F00
;     CASE ELSE
;          InRegX.AX = &H2F00
;          CALL InterruptX(&H21,InRegX,OutRegX)
;          DTASeg = OutRegX.ES
;          DTAOff = OutRegX.BX
;          K0$ = LTRIM$(K$) + C0$
;          InRegX.AX = &H4E00
;          InRegX.CX = 0
;          InRegX.DS = VARSEG(K0$)
;          InRegX.DX = SADD(K0$)
;   END SELECT
;   CALL InterruptX(&H21,InRegX,OutRegX)
;   FindF = OutRegX.AX
;   IF OutRegX.AX <> 0 THEN EXIT FUNCTION
;   DEF SEG = DTASeg
; LOOP UNTIL PEEK(DTAOff + 21) <> 16
; KT.FSize = PEEK(DTAOff + 26) + (PEEK(DTAOff + 27) * 256&) + _
;            ((PEEK(DTAOff + 28) + (PEEK(DTAOff + 29) * 256)) * 65536)
; KT.FName = Null$
; FOR K = 30 TO 41
;   IF PEEK(DTAOff + K) = 0 THEN EXIT FOR
;   MID$(KT.FName,K - 29,1) = AscChr$(PEEK(DTAOff + K))
; NEXT
; IF AscVal(K$) = 32 THEN K& = PEEK(DTAOff + 24) + PEEK(DTAOff + 25) * 256& : _
;                         K = K& : _
;                         KT.FDate = IntToDate3$(K)
; END FUNCTION
;

.Model Medium, Basic


.Data

DTABufx      DD      0
FilexNameBuf DB      65 dup (0)
DatexBuf     DB      "  -   -  xxxJanFebMarAprMayJunJulAugSepOctNovDec"


;
; Actual program code begins.
;
.Code

            PUBLIC  FindF             ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

FindF       proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            cld                       ;Move forward in string.

            mov     ax,[bp + 08H]     ;Get string descriptor for Input$.
            push    ax
            call    StringLength
            xchg    cx,ax             ;Put it's size in CX.
            jcxz    R2                ;If a null string, then Find-Next.

            push    ds
            push    cx                ;Save the length for later.

            push    ds                ;STOSB wants ES:DI,
            pop     es                ; so give it ES,
            lea     di,FilexNameBuf    ; and DI for FileNameBuf.

            push    di                ;Save it for the MOVSB.
            xor     ax,ax             ;Clear out the filename area.
            mov     cx,20H            ;32 x 2 bytes.  This allows us to not
            rep     stosw             ;need an ASCIIZ file name.
            push    es

            mov     ax,[bp + 08H]     ;Get string descriptor for Input$.
            push    ax
            call    StringAddress
            mov     ds,dx
            xchg    si,ax             ;Get the address for Input$ in SI.

            pop     es
            pop     di                ;Location of FileNameBuf.
            pop     cx                ;Get our length back.
            mov     dx,di             ;Save location for the 4EH call.
            rep     movsb             ;Copy (ES:DI) <- (DS:SI).
            pop     ds

        R1: mov     ah,2FH            ;DOS Services, Subfunction 2F.
            int     21H               ;Call DOS: Get current DTA address.
            add     bx,26             ;Start at our first useful data.
            lea     si,DTABufx         ;Save the DTA address, ES:BX,
            mov     [si],bx           ; the offset BX,
            mov     [si + 2],es       ; the segment ES.

            xor     cx,cx             ;Find only normal files.
            mov     ah,4EH            ;DOS Services, Subfunction 4E.
            int     21H               ;Call DOS: Find First matching file name.
            jc      Done              ;None found, so exit.
            jmp     D1                ;Go process what we got
            
        R2: mov     ah,4FH            ;DOS Services, Subfunction 4F.
            int     21H               ;Call DOS: Find Next matching file name.
            jc      Done              ;None found, so exit.

        D1: mov     di,[bp + 06H]     ;Location of our file information type.
            push    ds                ;Save DS for later.
            push    di                ;Save the start.
            push    ds                ;STOSB and MOVSW want ES:DI,
            pop     es                ; so set ES to DS.
            mov     al,20H            ;Clear out the filename area.
            mov     cx,12             ;We return with a 12 character buffer;
            rep     stosb             ;a "." filename and trailing spaces.

            lds     si,DTABufx         ;Load the DTA address into DS:SI.
            movsw                     ;Get the Long size from DS:SI,
            movsw                     ; into ES:DI.

            mov     bx,[si - 6]       ;Get the file's integer date into BX.
            mov     cx,[si - 8]       ;Get the file's integer time into CX.
            add     cx,bx             ;Add them--a sort-of time-date stamp.

            pop     di                ;Get the start/filename pos again.
            push    di                ;Save it again.
        R3: lodsb                     ;Get the found filename,
            cmp     al,00             ; until we hit a CHR$(0).
            je      D2
            stosb                     ;Store the found filename.
            jmp     R3

        D2: pop     di
            pop     ds                ;Restore our near data segment.
            add     di,16             ;Start of where our date goes.
            push    cx                ;Save CX for after the call,
            push    di                ;  DI also.
            xchg    ax,bx             ;Move the integer date to AX.

            lea     di,DatexBuf        ;Location of output buffer to DI.
            mov     bx,030AH          ;Multiplication and division numbers.
            push    ax                ;Save date for later.

            and     ax,1FH            ;Screen out all but the right 5 bits.
            div     bl                ;Divide by 10.
            add     ax,3030H          ;Make the results ASCII characters.
            cmp     al,48             ;A "0"?
            jne     Dz1               ;Nope.
            mov     al,32             ;Yep, make it a space.
       Dz1: stosw                     ;Store those characters.

            pop     ax                ;Get the original date again.
            mov     cl,05             ;Want to shift right 5 bits.
            shr     ax,cl             ;Do the shift.
            push    ax                ;Save it for later.
            and     ax,0FH            ;Mask to get our Month.
            inc     di                ;Skip past the first "-".
            mul     bh                ;Month * 3 + 1 = month name.
            add     ax,di             ;Prepare to move (ES:DI) <- (DS:SI)
            add     ax,06             ;Minor adjustment.
            mov     si,ax             ;Actual location of month name.
            movsw                     ;Copy the first two letters.
            movsb                     ;Copy the last letter.
            
            mov     cl,04             ;Move past our month's bits.
            pop     ax                ;Get the date.
            shr     ax,cl             ;Do the shift.
            add     ax,80             ;Adjustment for DOS date method.
            div     bl                ;Divide by 10.
            add     ax,3030H          ;Make the results ASCII characters.
            inc     di                ;Skip past the second "-".
            stosw                     ;Store those characters.

            pop     di                ;Restore DI.
            lea     si,DatexBuf        ;Location of output buffer to DI.
            mov     cx,9              ;Length of date is always 9.
            rep     movsb             ;Actually move it.
            pop     cx                ;Get our time-date stamp back.
            inc     cx                ;Do something with it.
            jnz     Done              ;If not zero, then move on.
            inc     cx                ;Zero, so make it non-zero.

      Done: xchg    ax,cx
            pop     bp
            ret     4                 ;Pop-return past our input parameters.

FindF       endp                      ;End of routine.

End

