; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine searches for file names that match a given pattern.  If a null
; is used, it finds the next file name matching that pattern.
; 
; Usage:  Result% = FindF2 (FileName$,FFile)
; Declare:  DECLARE FUNCTION FindF2% (FileName$, FFile AS FileInfo)
;
; Where FileName$ is the drive\path\filename pattern to match, FFile is a
; record of type FileInfo into which we return our found information, and
; Result% contains either -1 or zero to represent no file found.
;
; It's assumed the path and file specs don't exceed 64 characters.
;
; Directory Entries are ignored.
;
; Works if FileName$ has trailing spaces.
;
; This differs from FindF in that only the found file name is returned,
; not the date, size, etc.
;

.Model Medium, Basic


.Data

DTABuf2      DD      0
File2NameBuf DB      65 dup (0)


;
; Actual program code begins.
;
.Code

            PUBLIC  FindF2            ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

FindF2      proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            cld                       ;Move forward in string.

            mov     ax,[bp + 08H]     ;Get string descriptor for Input$.
            push    ax
            call    StringLength
            xchg    cx,ax             ;Put it's size in CX.
            jcxz    R2                ;If a null string, then Find-Next.

            push    ds
            push    cx                ;Save the length for later.

            push    ds                ;STOSB wants ES:DI,
            pop     es                ; so give it ES,
            lea     di,File2NameBuf    ; and DI for FileNameBuf.

            push    di                ;Save it for the MOVSB.
            xor     ax,ax             ;Clear out the filename area.
            mov     cx,20H            ;32 x 2 bytes.  This allows us to not
            rep     stosw             ;need an ASCIIZ file name.
            push    es

            mov     ax,[bp + 08H]     ;Get string descriptor for Input$.
            push    ax
            call    StringAddress
            mov     ds,dx
            xchg    si,ax             ;Get the address for Input$ in SI.

            pop     es
            pop     di                ;Location of FileNameBuf.
            pop     cx                ;Get our length back.
            mov     dx,di             ;Save location for the 4EH call.
            rep     movsb             ;Copy (ES:DI) <- (DS:SI).
            pop     ds

        R1: mov     ah,2FH            ;DOS Services, Subfunction 2F.
            int     21H               ;Call DOS: Get current DTA address.
            add     bx,26             ;Start at our first useful data.
            lea     si,DTABuf2         ;Save the DTA address, ES:BX,
            mov     [si],bx           ; the offset BX,
            mov     [si + 2],es       ; the segment ES.

            xor     cx,cx             ;Find only normal files.
            mov     ah,4EH            ;DOS Services, Subfunction 4E.
            int     21H               ;Call DOS: Find First matching file name.
            jc      Done              ;None found, so exit.
            jmp     D1                ;Go process what we got
            
        R2: mov     ah,4FH            ;DOS Services, Subfunction 4F.
            int     21H               ;Call DOS: Find Next matching file name.
            jc      Done              ;None found, so exit.

        D1: mov     di,[bp + 06H]     ;Location of our file information type.
            push    ds                ;Save DS for later.
            push    di                ;Save the start.
            push    ds                ;STOSB and MOVSW want ES:DI,
            pop     es                ; so set ES to DS.
            mov     al,20H            ;Clear out the filename area.
            mov     cx,12             ;We return with a 12 character buffer;
            rep     stosb             ;a "." filename and trailing spaces.

            lds     si,DTABuf2         ;Load the DTA address into DS:SI.
            add     si,4

            pop     di                ;Get the start/filename pos again.
        R3: lodsb                     ;Get the found filename,
            cmp     al,00             ; until we hit a CHR$(0).
            je      D2
            stosb                     ;Store the found filename.
            jmp     R3

        D2: pop     ds                ;Restore our near data segment.
            mov     cx,-1

      Done: xchg    ax,cx
            pop     bp
            ret     4                 ;Pop-return past our input parameters.

FindF2      endp                      ;End of routine.

End


