; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine calls the fossil with a "get next character, wait until you
; do, or until you time-out".
;
; Replaces the awkward:
;   K$ = TIME$
;   DO
;     K = FosIntAX(CommPort,&H2000)
;   LOOP UNTIL K >= 0 OR NoCarrier OR ElapsedTime$(K$,0) = Settings.LogoTimeOut
;
; It checks for a port of 0, but not for anything else.  Thus you could send
; it port -1000, but the fossil driver probably filters this error.
;

.Model Medium, Basic
.Code
 
            PUBLIC  FosGetByte        ;Make this routine available to LINK.

FosGetByte  proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            xor     ax,ax             ;Exit with at least a zero.
            mov     dx,[bp + 06]      ;Get our Port%.
            or      dx,dx             ;They sent us a zero,
            jz      Done              ;so exit.
            dec     dx                ;The fossil wants 0 to n ports.
            mov     ah,02h            ;Get received character with wait.
            int     14H               ;Call the fossil.
            xor     ah,ah             ;We only want AL.
     Done:  pop     bp
            ret     2
 
FosGetByte  endp                      ;End of routine.

End




