; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine returns with a random integer between 1 and Max%.
;
; Usage:  Result% = GetRndNum(Max%)
; Declare:  DECLARE FUNCTION GetRndNum% (BYVAL Max%) 
;
; Where Result% is the resulting integer and Max% is the size range to use.
;
; I've only tested it from 1 to 10 and it's random enough (all 1's at 1).
;
; It works in "blocks"--1's for a while, then 2's, etc.  So it's not good
; for constant random numbers.  The "blocks" seem due to the time being
; updated only like 18.2 times per second or somesuch.
;
; DOS time: returns DH = 0 to 59 and DL = 0 to 99, so it's probably not good
; for high numbers (also, DL isn't guarenteed, so 1 to 60).
;

.Model Medium, Basic
.Code

            PUBLIC  GetRndNum         ;Make this routine available to LINK.

GetRndNum   proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     ah,2CH            ;Subfunction to get the current time.
            int     21H               ;Call DOS Services to do it.
            mov     ax,dx             ;Move seconds and hundreths to AX.
            inc     ax                ;Start at at least 1.
            xor     dx,dx             ;Clear off top of DX:AX.
            mov     bx,[bp + 06]      ;Get Max% into BX.
            div     bx                ;DX <- DX:AX \ BX
            mov     ax,dx             ;Put the remainder (the MOD) into AX.
            inc     ax                ;Readjust to 1 to n.

            pop     bp
            ret     2                 ;Pop return past our input parameter.

GetRndNum   endp                      ;End of routine.

End


