; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine uncompresses a 5-bit based string into an ASCII 8-bit string.
; 
; Usage:  Result$ = Make8Bit$ (5BitString$, RecNum%, Size%)
; Declare:  DECLARE FUNCTION Make8Bit$ (5BitString$, BYVAL RecNum%, BYVAL Size%)
;
; Where 5BitString$ is the string to uncompress from 5 bits to 8 bits, RecNum%
; is the record number the word was given when stored, Size% is the size of the
; desired output string, and Result$ is the 8 bit output string of size Size%.
;
; The record number is necessary because we need to calculate the "bit start"
; position within the string we're given.
;

.Model Medium, Basic
.Code


            PUBLIC  Make8Bit          ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

Make8Bit    proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            push    ds

            mov     ax,[bp + 0CH]     ;Get descriptor of the string.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     cx,di
            jcxz    Done              ;If a null string, then exit.
            mov     ds,dx
            xchg    si,ax             ;String location -> SI.

            push    si
            mov     ax,[bp + 06]      ;Get descriptor of the string.
            push    ax
            call    StringAddress
            mov     es,dx
            xchg    di,ax             ;String location -> SI.
            pop     si

            mov     cx,[bp + 08]      ;Get size of desired output string.
            mov     ax,cx             ;Put size of word in ax.
            mov     bx,5              ;Size of word * 5 bits = size in bits.
            mul     bx                ;(AX * 5 -> DX:AX)
            mov     bx,[bp + 0AH]     ;Get record number of this word.
            dec     bx                ;0 based.
            mul     bx                ;Get bit pos in terms of 5 bits.

            and     ax,0007H          ;Mask off all but first 3 bits.
            mov     dx,ax             ;The remainder, put in DX.

            lodsb                     ;Get the first two bytes.
            mov     ah,al             ;Putting first letter in AH,
            lodsb                     ;and second in AL.
            mov     bx,ax             ;Save for next time.

        R1: mov     ax,bx             ;Original AX back.
            cmp     dx,12             ;Are we out of 5 bit words?
            jl      R2                ;Nope, get next.
            mov     ah,al             ;Yep, shift AL to AH,
            lodsb                     ;and get another letter into AL.
            mov     bx,ax             ;Save our new AX.
            sub     dx,8              ;Back up some bits.

        R2: push    cx                ;Save our size.
            mov     cl,dl             ;Move starting bit position into CL.
            shl     ax,cl             ;Shift CL over those bits,
            mov     cl,3              ;Shift it back 3,
            shr     ax,cl             ;now AH has our uncompressed letter.
            pop     cx                ;Get the size back.
            add     ah,64             ;Adjust to real-world ASCII.
            cmp     ah,64             ;A 64 means we had a 0--which is a space.
            jne     R3                ;No space, so jump.
            mov     ah,32             ;Otherwise replace it with a space.

        R3: mov     al,ah             ;Store it into our output string.
            stosb                     ;Store to ES:DI.
            add     dx,5              ;Shift over the 5 bit word in DX.
            loop    R1

      Done: pop     ds
            pop     bp
            ret     8                 ;Pop-return past our input parameters.

Make8Bit    endp                      ;End of routine.

End


