; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will write a string to the end of a file opened with FileOpen.
;
; Usage:  CALL FilePutSEnd (Handle%, String$)
; Declare:  DECLARE SUB FilePutSEnd (Byval Handle%, String$)
;
; Where String$ is the string to output and Handle% is the file handle
; returned by FileOpen.
;

.Model Medium, Basic
.Code

            PUBLIC  FilePutSEnd       ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

FilePutSEnd proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     bx,[bp + 08]      ;Get the file handle into BX.
            mov     ax,4202H          ;Subfunction to seek to end of file.
            xor     cx,cx             ;0 offset from the end.
            mov     dx,cx             ;0 here too, must be a long number.
            int     21H               ;Call DOS Services to do it.

            mov     ax,[bp + 06]      ;Descriptor of Output$.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     cx,di
            jcxz    Done              ;Quick exit if a null string.

            mov     bx,[bp + 08]      ;Get the file handle into BX.
            push    ds
            mov     ds,dx
            mov     dx,ax             ;Data buffer to write out.
            mov     ah,40H            ;Subfunction to write to a file.
            int     21H               ;CALL DOS Services to do it.
            pop     ds

      Done: pop     bp
            ret     4                 ;Pop-return past our input parameters.

FilePutSEnd endp                      ;End of routine.

End


