; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine searches for a string inside another string.
; 
; Usage:  Result% = StrSrch(Start%, Source$, Search$)
; Declare:  DECLARE FUNCTION StrSrch% (BYVAL Start%, Source$, Search$)
;
; Where Source$ is our string to search, Search$ is the text to look for,
; Start% is our starting position in Source$, and Result% is where the
; search string is located in the source string.
;
; This routine is a direct replacement for INSTR.  There are two differences
; though:  A starting position must be given.  INSTR default'ed to 1 and
; didn't require the parameter in the calling line, StrSrch requires it.
; Also, INSTR(anything,"") returned 1.  This will return zero.  That is,
; whenever the the Search$ or Source$ is null, a zero is returned.  INSTR
; returned a zero when Source$ was null, but a one when Search$ was null.
; Thus, IF INSTR(a$,b$) > 0 always needed a AND b$ <> "" with it, this
; doesn't: IF StrSrch(1,a$,b$) > 0 THEN ...
;

.Model Medium, Basic
.Code

            PUBLIC  StrSrch           ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

StrSrch     proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            push    ds
            cld                       ;A forward search.

            mov     ax,[bp + 06]      ;Get Search$'s descriptor.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     cx,di
            jcxz    Done

            push    cx
            push    dx
            push    ax

            mov     ax,[bp + 08]      ;Get Source$'s descriptor.
            push    ax
            call    StringLength
            push    ax                ;A 'jcxz' is handled later.

            mov     ax,[bp + 08]      ;Get Source$'s descriptor.
            push    ax
            call    StringAddress
            mov     es,dx
            mov     di,ax

            pop     cx   ;Length of Source$ in CX.
            pop     si   ;Address of Search$ in SI.
            pop     ds
            pop     dx   ;Length of Search$ in DX.

            mov     ax,[bp + 0AH]     ;Start% -> AX
            dec     ax                ;Reduce AX by 1.
            js      D1                ;Start% is zero or negative, so exit.

            sub     cx,ax             ;Reduce the number to search.
            jbe     D1                ;Zero or less now, so exit.

            mov     bx,di             ;Save the start of Source$ for later.
            add     di,ax             ;Skip the first AX characters.
            lodsb                     ;Get Search$'s first character - AL.
        R1: repne   scasb             ;Compare AL until find (or not) a match.
            jnz     D1                ;No match found, exit.
            push    si                ;Save where we left off.
            push    di
            push    cx
            mov     cx,dx             ;Get length of Search$.
            dec     di                ;Clean up from ScasB, necessary for
            dec     si                ;a single character Search$.
            repe    cmpsb             ;See if all of Search$ matches.
            pop     cx                ;Get our information back.
            pop     di
            pop     si
            jne     R1                ;No complete match was found.
            mov     ax,di             ;Location of found string -> AX.
            sub     ax,bx             ;Subtract off the address.
            jmp     Done
        D1: xor     ax,ax             ;Exit with at least a zero.

      Done: pop     ds
            pop     bp
            ret     6                 ;Pop-return past our input parameter.

StrSrch     endp                      ;End of routine.

End

