; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine searches for an ASCII character in a string.  It starts its
; search at the end and works forward.
;
; Usage:  FoundLocation% = StrSrchR(Input$, Find%)
; Declare:  DECLARE FUNCTION StrSrchR% (Input$, BYVAL Find%)
;
; Where Input$ contains the string to search, Find% contains the ASCII code
; to search for, and FoundLocation% contains the last location of the code in
; the source.
;
; Returns zero for a null string or not found.
;

.Model Medium, Basic
.Code

            PUBLIC  StrSrchR          ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

StrSrchR    proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            push    ds

            mov     ax,[bp + 08]      ;Get descriptor of the string.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     cx,di
            jcxz    Done              ;If a null string, then exit.
            mov     ds,dx
            mov     bx,ax

            add     bx,cx             ;Point to end of string + 1.
            mov     al,[bp + 06]      ;Get ASCII value to search for.
        R1: dec     bx                ;Go to previous position.
            cmp     al,[bx]           ;If the contents match what we want,
            jz      Done              ;then exit,
            loop    R1                ;otherwise, reduce CX and repeat.
      Done: xchg    ax,cx             ;We exit with the value of CX.
            pop     ds
            pop     bp
            ret     4                 ;Pop-return past our input parameters.

StrSrchR    endp                      ;End of routine.

End

