; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine uses gets the integer value of two ASCII numbers of the i'th
; position of a string.
;
; Usage:  Result% = Val3%(Input$,Offset%)
;
; Where Input$ is the text to to analyze, and Result% contains the value
; itself.  
;
; Will get a random value if you feed it a null string, or an Offset of
; zero or greater than the length of the string.  Offset% goes from 1 to n.
;
; Sending it a single character will also return random results.
;
; However, it can be used with null and single-character strings (such as
; gotten when reading a file)--it just won't return the right number (since
; there isn't one to return)--but OK for those times (like when loading
; blocks) when you're searching for a non-match number.
;
; It's a faster replacement for Val2&() when the data is known.
;

.Model Medium, Basic
.Code

            PUBLIC  Val3              ;Make this routine available to LINK.

            extrn   StringAddress: proc

Val3        proc    far

            push    bp
            mov     bp,sp

            mov     ax,[bp + 08]
            push    ax
            call    StringAddress
            xchg    ax,si
            mov     bx,[bp + 06]
            mov     es,dx

            mov     ch,10
            mov     al,es:[si + bx - 1]
            sub     al,"0"
            mul     ch
            add     al,es:[si + bx]
            sub     al,"0"

            pop     bp
            ret     4                 ;Pop-return past our input parameters.

Val3        endp                      ;End of routine.

End

