; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will convert the first alphabetic character after a
; non-alphabetic character to uppercase.  Then any other alphabetic characters
; (until the next non-alphabetic character) will be converted to lowercase.
;
; Usage:  CALL WordsCase(Input$)
; Where Input$ is the string we wish to alter.
;
; Known problems: abc's -> Abc'S (we want Abc's)
;                 When we want full capitalization (eg. state abbreviations,
;                 like WI) we can't have it.
;

.Model Medium, Basic
.Code

            PUBLIC  WordsCase         ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

WordsCase   proc    uses DS, Descriptor

            mov     ax,Descriptor     ;Get string descriptor for Input$.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     cx,di
            jcxz    Done
            mov     ds,dx
            xchg    si,ax             ;Get the address for Input$ in SI.

            cld                       ;Move forward in string.
            xor     bx,bx             ;Uppercase next character flag.
        R1: lodsb
                                      ;Spaces are the most common occurance.
                                      ;Normally LC characters would be next,
                                      ;but I use this routine on a lot of UC
                                      ;so UC characters are handled second.
            cmp     al,41H            ;If less than 'A', then jump. 
            jb      R5
            cmp     al,5BH            ;If an uppercase letter, then jump.
            jb      R2
            cmp     al,7AH            ;If greater than 'z', then jump.
            ja      R5
            cmp     al,61H            ;If not 'a' to 'z' then jump.
            jb      R5
                                      ;At this point, the letter is either a-z
                                      ;or A-Z.
        R2: or      bx,bx             ;Check our "next is uppercase" flag.
            jz      R3                ;Yes, go uppercase it.
            or      al,20H            ;Lowercase the letter (if it isn't).
            jmp     R4                ;go store it.
        R3: and     al,0DFH           ;Uppercase the letter (if it isn't).
            dec     bx                ;Set BX flag (reduce to avoid overflow).
                                      ;When non-zero, the characters are LC'd.
        R4: mov     [si - 1],al       ;Store our possibly altered character.
            jmp     R6
        R5: xor     bx,bx             ;Reset flag so next charcter is UC'd.
        R6: loop    R1                ;Do for all the characters.

      Done: ret

WordsCase   endp                      ;End of routine.

End

