; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will return a string containing a word within the input string
; referenced to by an input value.  It returns word number x from a string.
;
; Usage:  CALL WordsGet(Input$, FindNum%, Start%, Size%)
; Declare: DECLARE SUB WordsGet (Input$, BYVAL FindNum%, Start%, Size%)
;
; Where Input$ is the string to search, FindNum% is the word number to get,
; Start% is the position in the string where the word starts, and Size% is
; the size of the word.
;
; A null string, or a FindNum% that is larger than the number of words in the
; line will result in odd output, and should be avoided.
;
;
; The Basic equivalent (more or less) is:
;
;p$ string to search
;p  word number to get
;p0 returns with start of word in string
;FUNCTION WordsGet$ (p$,p,p0)
;  K = 0      '"in word" or not flag.
;  K0 = 0     'current word number.
;  FOR p0 = 1 TO LEN(p$)
;    IF AscMid(p$,p0) = 32 _
;       THEN K = 0 _
;       ELSE IF NOT K THEN K0 = K0 + 1 : _
;                          K = -1 : _
;                          IF K0 = p THEN EXIT FOR
;  NEXT
;  IF K0 <> p THEN WordsGet$ = Null$ : _
;                  p0 = 0 : _
;                  EXIT FUNCTION
;  K$ = LTRIM$(MID$(p$,p0))
;  K3 = StrSrch1(K$,32)
;  IF K3 > 0 THEN WordsGet$ = LEFT$(K$,K3 - 1) _
;            ELSE WordsGet$ = K$
;END FUNCTION
;



.Model Medium, Basic
.Code


;
; Actual program code begins.
;

            PUBLIC  WordsGet2         ;Make this routine available to LINK.

            extrn StringAddress: proc
            extrn StringLength: proc

WordsGet2   proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            push    ds

            mov     ax,[bp + 0CH]     ;Get Input$'s desciptor -> BX.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     cx,di
            jcxz    Done              ;If a null string, then exit.

            push    ds
            pop     es

            mov     ds,dx
            mov     si,ax

            mov     di,[bp + 0AH]     ;Get the number of the word to find.
            xor     ax,ax             ;Our 'in a word?' flag.
            mov     bx,ax             ;Start at position zero.
            dec     ax                ;We start out 'not in a word'.
        R1: cmp byte ptr [bx + si],20H   ;Is the character a space?
            je      R2                ;Yes, get next character.
            or      ax,ax             ;Are we in a word now?
            je      R3                ;If not in a word, then get next.
            dec     di                ;Reduce our words-to-find count.
            or      di,di             ;If we're at the one we want,
            je      R4                ;then go finish up.
            xor     ax,ax             ;Now, we're 'not in a word'.
            jmp     R3

        R2: dec     ax                ;Put us, 'in a word'.

        R3: inc     bx                ;Move to next character.
            loop    R1                ;Keep looping for all of Input$.
            jmp     Done              ;No more found, exit.

        R4: inc     bx                ;Clean up, make it a real-world value.
            mov     di,[bp + 08]      ;Store our starting position,
            mov     es:[di],bx        ;in Start%.

            xor     ax,ax             ;AX will contain our length.
        R5: cmp byte ptr [bx + si],20H   ;Looking for a space.
            je      R6                ;Found, finish up.
            inc     bx                ;Try next character.
            inc     ax                ;Add to our length total.
            loop    R5                ;Keep looping until done.
            dec     ax                ;No last space, clean up.
        R6: inc     ax                ;More cleaning up.
            mov     di,[bp + 06]      ;Store our size.
            mov     es:[di],ax

      Done: pop     ds
            pop     bp
            ret     8                 ;Pop-return past our input parameters.

WordsGet2   endp                      ;End of routine.

End

