' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'
'Various small formatting routines:
'  AddrToInt
'  AnsiLocStr$
'  AttrToInt
'  Commas$
'  CRsToSpaces
'  DateToInt
'  ExpandFileName$
'  Form$
'  Form1$
'  Form2$
'  Form3$
'  IntToAttr$
'  IntToPhone$
'  KwazyColor$
'  MakePathName$
'  NCR$
'  ReplaceCharacters
'  ReplaceStrings
'  RightTime$
'  StripAnsi$
'  StripLeft$
'  StripRight$
'  UnSq$
'  Val2&




        '* * * * * *
        ' This routine takes a node address in 6 byte string form and
        ' returns with it in three integers form.
        '
        ' p$  node address to use
        '
        ' p   zone
        '
        ' p0  net
        '
        ' p1  node
        '
        ' Date last checked for perfection: Dec 31 1992
        '
SUB AddrToInt (p$,p,p0,p1)

  p = IntMid(p$,1)
  p0 = IntMid(p$,3)
  p1 = IntMid(p$,5)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will convert two numbers into an ansi location
        ' placement string.
        '
        '     p1  x-coordinate value
        '     p2  y-coordinate value
        '
        ' Date last checked for perfection: Sep 5 1992
        '
FUNCTION AnsiLocStr$ (p1,p2)

  AnsiLocStr$ = Short$(685) + IntToStr$(p1) + Chars$(59) + _
                IntToStr$(p2) + Chars$(102)

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine will convert a string to an integer according
        ' to the bit formula: 1234567890ABCDEF.
        '
        ' p$  is the input string.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION AttrToInt% (p$)

  k = 0
  k$ = UCASE$(p$)
  FOR k0 = 1 to 16
    IF StrSrch1(k$,AscMid(Short$(812),k0)) > 0 THEN CALL BitSet(k,k0)
  NEXT
  AttrToInt = k

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine will add commas to a number, returning a
        ' string.
        '
        ' p&  number to use.
        '
        ' This routine handles negative numbers properly.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION Commas$ (p&)

  k$ = STR$(p&)
  k = LEN(k$)
  IF k > 4 THEN k$ = LEFT$(k$,k - 3) + Chars$(44) + RIGHT$(k$,3)
  IF k > 7 THEN k$ = LEFT$(k$,k - 6) + Chars$(44) + RIGHT$(k$,7)
  IF k > 10 THEN k$ = LEFT$(k$,k - 9) + Chars$(44) + RIGHT$(k$,11)
  Commas$ = LTRIM$(k$)

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine will 'unwrap' a message so it can be
        ' 're-wrapped'.  That is, it converts all CR's to spaces.
        ' Used for such things as Reviews.
        '
        ' p$  message body
        '
        ' The routine does try to preserve 'hard' CR's--a 'hard' CR is
        ' a 'really hard CR/LF', it's a blank line.  The routine will
        ' remove the blank lines, but it won't tack the new line onto
        ' the end of the previous line--they'll be separated by a CR.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
SUB CRsToSpaces (p$)

  k0 = LEN(p$) - 3
  k = StrSrch1(p$,13)
  WHILE k > 0 AND k < k0
    IF AscMid(p$,k + 1) <> 32 THEN MID$(p$,k,1) = C32$
    k = StrSrch2(k,p$,13)
  WEND

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will convert the date in string form to
        ' integer-date form.
        '
        ' p$  the string to convert.
        '
        ' Will convert 'dd-mm-yy', 'dd-mm-yyyy', ' d-mm-yy', ' d-mm-yyyy'
        '
        ' Date last checked for perfection: Sep 22 1992
        '
FUNCTION DateToInt% (p$)

  DateToInt = DateInt(Val3(p$,4),Val2&(LEFT$(p$,2)),Val2&(p$) - 80)

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine will take 'filename.exe' and make
        ' 'filename ext', or 'file.ext' to make 'file     ext', and
        ' 'file' to make 'file        '.
        '
        ' p$  string to process
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION ExpandFileName$ (p$)

  k = StrSrch1(p$,46)
  IF k = 0 THEN ExpandFileName$ = Form$(1201,p$) _
           ELSE ExpandFileName$ = Form$(901,LEFT$(p$,k - 1)) + _
                                  Form$(301,MID$(p$,k + 1))

END FUNCTION
        '
        '* * * *



        '* * * * * *
        ' This routine handles a variety of minor formatting of text.
        '
        ' p  Breaks up into K0 and K:
        '    k   maximum size of returned string (0 means 'whatever
        '        comes naturally'--except when 8 is used).
        '    k0   attribute (what to do):
        '         1 then LSET the result in spaces to size K.
        '         2 then RSET the result in spaces to size K.
        '         4 do a Wordscase on it. 
        '         8 to center it.
        '        16 to get/use only the first word.
        '        32 to add a leading space.
        '        64 to add a trailing space.
        '        can't use combinations that add up to > 99.
        '
        ' p$ is the input string.
        '
        ' The Centering routine is kinda slow--but it needs to be able
        ' to handle null strings as well as strings longer than k, so
        ' the mathematical alternative was really quite complex.
        '
        ' Any leading spaces are removed (the string is first left
        ' justified before operations begin).
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION Form$ (p,p$)

  k = p \ 100
  k0 = p - k * 100
  IF BitTest(k0,3) THEN k$ = NCR$(p$) _ 
                   ELSE k$ = LTRIM$(RTRIM$(p$))
  IF BitTest(k0,5) THEN k$ = LeftTill$(K$ + C32$,32)
  IF BitTest(k0,1) AND K > 0 THEN k$ = StripLeft$(k$ + SPACE$(k),k)
  IF BitTest(k0,2) AND K > 0 THEN k$ = StripRight$(SPACE$(k) + k$,k)
  IF BitTest(k0,4) AND K > 0 THEN WHILE StripLen(k$) < k : _
                                    k$ = C32$ + k$ + C32$ : _
                                  WEND : _
                                  k$ = StripRight$(k$,k)
  IF BitTest(k0,6) THEN k$ = C32$ + k$
  IF BitTest(k0,7) THEN k$ = k$ + C32$
  Form$ = k$

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This is a couple of useful formatting routines.
        '
        ' p   1 to 5 can be used for specific stuff (maybe I can go
        '     higher if needed):
        '     1 return NCR'd 'last name' (last word).
        '     2 uppercase and trim a string.
        '     3 visibly shrink a message subject.
        '
        ' p$  string to use
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION Form1$ (p,p$)

  SELECT CASE p
    CASE 1
         k$ = NCR$(p$)
         Form1$ = MID$(k$,StrSrchR(k$,32) + 1)
    CASE 2
         Form1$ = UCASE$(LTRIM$(RTRIM$(p$)))
    CASE 3
         K = LEN(p$)
         WHILE LEN(Sq$(LEFT$(p$,K))) > LEN(Message.MsgSubject)
           K = K - 1
           CALL Wipe(1)
         WEND
         K0 = LEN(RTRIM$(UnSq$(Message.MsgSubject))) - K
         IF K0 > 0 THEN TT$ = SPACE$(K0) : _
                        CALL SendTT
         Form1$ = Sq$(LTRIM$(RTRIM$(LEFT$(p$,K))))
    CASE ELSE
         Form1$ = p$ + Short$(213) + IntToStr$(p - StripLen(p$)) + Chars$(67)
  END SELECT

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine RSET's and comma-deliminate's a long integer.
        '
        ' p   size of resulting string
        '
        ' p&  number to use
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION Form2$ (p,p&)

  Form2$ = RIGHT$(SPACE$(p) + Commas$(p&),p)

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine returns a formatted string such that the number
        ' is right justified into a width of three characters.
        '
        ' p  number to use.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION Form3$ (p)

  Form3$ = RIGHT$(C32$ + STR$(p),3)

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine returns a formatted string such that the
        ' number is right justified into a width of two or three
        ' characters with leading zeros.  And other formats.
        '
        ' p   which format to use
        '
        ' p0  number to use, will not modify, but will correctly handle
        '     even if the number is negative.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION Form4$ (p,p0)

  K = p0
  IF K < 0 THEN K = - K
  SELECT CASE p
    CASE 1 : Form4$ = LEFT$(IntToStr$(p0) + Short$(658),5)   ' '#####'  '#    '
    CASE 2 : Form4$ = RIGHT$(STR$(100 + K),2)                ' '##',    '00'
    CASE 3 : Form4$ = RIGHT$(STR$(1000 + K),3)               ' '###',   '000'
    CASE 4 : Form4$ = LEFT$(STR$(K) + C32$,4)                ' ' #  ',  ' ###'
    CASE 5 : Form4$ = LEFT$(STR$(K) + Short$(188),5)         ' ' #   ', ' ####'
    CASE 6 : Form4$ = RIGHT$(Short$(296) + STR$(K),5) + C32$ ' '    # '
    CASE 7 : IF K = 0 THEN Form4$ = Short$(188) _
                      ELSE Form4$ = Form3$(K)
    CASE 9 : Form4$ = RIGHT$(STR$(K),2)
    CASE 10 : Form4$ = RTRIM$(FileNames(35)) + RIGHT$(STR$(1000 + K),3) + _
                       Short$(165)
  END SELECT

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine will convert an integer to a 16 byte string.
        ' The formula is 1234567890ABCDEF and what isn't on will have
        ' a space.
        '
        ' p   is the integer to use.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION IntToAttr$ (p)

  k$ = Short$(812)
  FOR k = 1 to 16
    IF NOT BitTest(p,k) THEN MID$(k$,k,1) = C32$
  NEXT
  IntToAttr$ = k$

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine will convert a long integer phone number into a
        ' string.
        '
        ' p&  is the long integer form of the phone number to use.
        '
        ' Long distance phone numbers have their first and second
        ' digit swapped when it's a long integer.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION IntToPhone$ (p&)

  k$ = LongToStr$(p&)
  IF LEN(k$) = 9 THEN k$ = Chars$(48) + k$
  IF LEN(k$) = 10 _
     THEN k$ = MID$(k$,2,1) + LEFT$(k$,1) + MID$(k$,3,1) + Chars$(45) + _
               MID$(k$,4,3) + Chars$(45) + RIGHT$(k$,4)
  IF LEN(k$) = 7 THEN k$ = LEFT$(k$,3) + Chars$(45) + RIGHT$(k$,4)
  IF k$ = Chars$(48) THEN k$ = Null$
  IntToPhone$ = k$

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine will return the next cycled color string.
        '
        ' p   last color used.
        '
        ' p0  background color being used.
        '
        ' returns with the color string to use.
        '
        ' Date last checked for perfection: Oct 24 1992
        '
FUNCTION KwazyColor$ (p,p0)

  p = p + 1
  IF p > 15 THEN p = 0
  IF p + 40 = p0 THEN p = p + 1
  IF p < 8 THEN k$ = Short$(175) + IntToStr$(30 + p) _
           ELSE k$ = Short$(174) + IntToStr$(30 + p - 8)
  KwazyColor$ = k$ + Chars$(59) + IntToStr$(p0) + Chars$(109)

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine will make a file name out of two numbers.
        '
        ' p&  value for first 8 characters of file name.
        '
        ' p   value for last 3 characters of file name.
        '
        ' Date last checked for perfection: Oct 25 1992
        '
FUNCTION MakePathName$ (p&,p)

  MakePathName$ = Paths$(5) + LongToStr$(p&) + Chars$(46) + _
                  IntToStr$(p) + Chars$(92)

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' Combines both RTrim$ and WordsCase into a single function.
        '
        ' p$  string to use
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION NCR$ (p$)

  k$ = RTRIM$(p$)
  CALL WordsCase(k$)
  NCR$ = k$

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine replaces characters in a string.
        '
        ' p$   string to do replacing on.
        '
        ' p    > -1 to replace a single character (p) with another
        '           single character (p0).
        '        -1 to replace a single character (p0) with a string of
        '           characters (p0$).
        '        -2 to replace a string of characters (p0$) with a
        '           single character (p0).
        '        -3 to replace a single character (p0) with nothing.
        '        -4 to replace a string of characters (p0$) with
        '           nothing.
        '
        ' p0$  to to replace with.
        '
        ' p0   charcter to replace with.
        '
        ' Date last checked for perfection: Sep 22 1992
        '
SUB ReplaceCharacters (p$,p,p0$,p0)

  SELECT CASE p
    CASE -1
         '
         ' Replace a single character with a string of characters.
         '
         k = StrSrch1(p$,p0)
         WHILE k > 0
           p$ = LEFT$(p$,k - 1) + p0$ + MID$(p$,k + 1)
           k = StrSrch1(p$,p0)
         WEND
    CASE -2
         '
         ' Replace a string of characters with a single character.
         '
         k$ = Chars$(p0)
         k = StrSrch(1,p$,p0$)
         WHILE k > 0
           p$ = LEFT$(p$,k - 1) + k$ + MID$(p$,k + LEN(p0$))
           k = StrSrch(k,p$,p0$)
         WEND
    CASE -3
         '
         ' Replace a single character with nothing.
         '
         k = StrSrch1(p$,p0)
         WHILE k > 0
           p$ = LEFT$(p$,k - 1) + MID$(p$,k + 1)
           k = StrSrch1(p$,p0)
         WEND
    CASE -4
         '
         ' Replace a string of characters with nothing.
         '
         k = StrSrch(1,p$,p0$)
         WHILE k > 0
           p$ = LEFT$(p$,k - 1) + MID$(p$,k + LEN(p0$))
           k = StrSrch(k,p$,p0$)
         WEND
    CASE ELSE
         '
         ' Replace a single character with a single character.
         '
         k$ = Chars$(p0)
         k = StrSrch1(p$,p)
         WHILE k > 0
           MID$(p$,k,1) = k$
           k = StrSrch1(p$,p)
         WEND
  END SELECT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine replaces all occurances of a string with
        ' another string within a string.
        '
        ' p$   String to modify.
        '
        ' p0$  String to search for.
        '
        ' p1$  String to replace with.
        '
        ' Date last checked for perfection: Jan 24 1992
        '
SUB ReplaceStrings (p$,p0$,p1$)

  k = LEN(p0$)
  k0 = StrSrch(1,p$,p0$)
  WHILE k0 > 0
    p$ = LEFT$(p$,k0 - 1) + p1$ + MID$(p$,k0 + k)
    k0 = StrSrch(k0 + k,p$,p0$)
  WEND

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will return with the time in 'human' format.
        '
        ' p$  contains the time to use in 'HH:MM:SS' or ' H:MM:SS' format.
        '
        ' Returns with the time in 'HH:MM xm' format.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION RightTime$ (p$)

  IF LEN(p$) = 0 THEN k$ = LEFT$(TIME$,5) _
                 ELSE k$ = LEFT$(p$,5)
  k = Val2&(LEFT$(k$,2))
  k0 = Val3(k$,3)
  SELECT CASE k
    CASE 0        : k$ = Short$(631) + MID$(k$,3) + Short$(632)
    CASE 1 TO 9   : k$ = MID$(k$,2) + Short$(632)
    CASE 10 TO 11 : k$ = k$ + Short$(632)
    CASE 12       : k$ = Short$(631) + MID$(k$,3) + Short$(145)
    CASE 13 TO 23 : k$ = IntToStr$(k - 12)  + MID$(k$,3) + Short$(145)
  END SELECT
  RightTime$ = k$

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine replaces ansi codes with spaces,
        ' returning a new string.
        '
        ' p$  is the string to work on.  Not changed.
        '
        ' returns with p$ without ansi codes.
        '
        ' Date last checked for perfection: Nov 6 1992
        '
FUNCTION ClearAnsi$ (p$)

  K = StrSrch1(p$,27)
  IF K = 0 THEN ClearAnsi$ = p$ : _
                EXIT FUNCTION
  K$ = p$
  K0 = LEN(p$)
  FOR K1 = K TO K0
    K2 = AscMid(K$,K1)
    SELECT CASE K2
      CASE 27
           K3 = K1 + 1
           DO
             K2 = AscMid(K$,K3 - 1)
             K3 = K3 + 1
           LOOP UNTIL K2 <> 27 AND K2 <> 91 AND K2 <> 59 AND (K2 < 48 OR K2 > 57) OR K3 > K0
           MID$(K$,K1,K3 - K1) = SPACE$(K3 - K1)
    END SELECT
  NEXT
  ClearAnsi$ = K$

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine strips out all ANSI codes, returning a new
        ' string.
        '
        ' p$  is the string to work on.  Not changed.
        '
        ' returns with p$ without ansi codes.
        '
        ' Date last checked for perfection: Feb 25 1993
        '
FUNCTION StripAnsi$ (p$)

  K$ = p$
  K = StrSrch1(K$,27)
  WHILE K > 0
    K1 = LEN(K$)
    K2 = K + 2
    DO
      K3 = AscMid(K$,K2)
      K2 = K2 + 1
    LOOP UNTIL K3 <> 59 AND (K3 < 48 OR K3 > 57) OR K2 > K1
    K$ = LEFT$(K$,K - 1) + MID$(K$,K2)
    K = StrSrch2(K - 1,K$,27)
  WEND
  StripAnsi$ = K$

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine returns LEFT$(st$,i%) while ignoring color
        ' codes.
        '
        ' p$  is the string to examine.
        '
        ' p   is the 'true' length we wish to utilize.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION StripLeft$ (p$,p)

  k = 0
  k0 = 0
  DO
    k0 = k0 + 1
    SELECT CASE AscMid(p$,k0)
      CASE 125
           k1 = AscMid(p$,k0 + 1)
           IF (k1 > 48 AND k1 < 58) THEN k0 = k0 + 1 _
                                         ELSE k = k + 1
      CASE 27
           DO : k0 = k0 + 1
           LOOP UNTIL StrSrch1(Short$(814),AscMid(p$,k0)) > 0 OR k0 = LEN(p$)
      CASE ELSE : k = k + 1
    END SELECT
  LOOP UNTIL k = p OR k0 = LEN(p$)
  StripLeft$ = LEFT$(p$,k0)

END FUNCTION
        '
        '* * * *




        '* * * * * *
        'This routine returns RIGHT$(st$,i%) while ignoring color
        ' codes.
        '
        ' p$  is the string to process.
        '
        ' p   is the length (no color codes) we want.  Do not use zero.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION StripRight$ (p$,p)

  k$ = p$
  WHILE StripLen(k$) > p
    SELECT CASE ASC(k$)
      CASE 125 : k = AscMid(k$,2)
                 IF (k > 48 AND k < 58) THEN k$ = MID$(k$,2)
      CASE 27  : DO : k$ = MID$(k$,2)
                 LOOP UNTIL StrSrch1(Short$(814),AscNull(k$)) > 0 OR k$ = Null$
    END SELECT
    k$ = MID$(k$,2)
  WEND
  StripRight$ = k$

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' The routine uncompresses text compressed with Sq.
        '
        ' p$ is the text to uncompress.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION UnSq$ (p$)

  k$ = STRING$(UnSqPlus(p$),4) + p$
  CALL UnSqDo(k$,SqString$)
  UnSq$ = k$

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine will convert a string to a number.
        '
        ' p$  is the number in string form to use.
        '
        ' This routine returns the value as seen from the opposite
        ' end, and stops when it reaches the first backwards
        ' non-number.  Under VAL() '123xyz' = 123, here it = 0.  Under
        ' VAL() 'xyz123' = 0, here it equals 123.
        '
        ' Found no use for negatives.  So, the negative symbol will be
        ' just another 'nonnumeric stop flag'.
        '
        ' Trailing spaces are ignored.
        '
        ' Leading spaces and zero's are ignored.  Although '  xx yy'
        ' will still only return yy, as the space between two numbers
        ' is a stopper.
        '
        ' It only works with integers, thus sending '101.50' will
        ' return 50.
        '
        ' For numbers greater than 1,xxx,xxx,xxx we stop at the '1'
        ' position.
        '
        ' Date last checked for perfection: Oct 15 1993
        '
FUNCTION Val2& (p$)

  k& = 0
  k0& = 1
  K = LEN(RTRIM$(p$))
  K1 = 0
  SELECT CASE K
    CASE IS > 0
         DO
           K0 = AscMid(p$,K) - 48
           K1 = K1 + 1
           IF (K0 < 0) OR (K0 > 9) OR (K1 = 11) OR (K1 = 10 AND K0 > 1) _
              THEN EXIT DO
           k& = k& + k0& * K0
           k0& = 10 * k0&
           K = K - 1
         LOOP UNTIL K = 0
  END SELECT
  Val2& = k&

END FUNCTION
        '
        '* * * *



FUNCTION Val4& (p$)

  k& = 0
  k0& = 1
  K = LEN(RTRIM$(p$))
  SELECT CASE K
    CASE IS > 15
         K3 = 0
         FOR K0 = 0 TO 15
           K1 = AscMid(p$,K - K0) - 48
           IF K1 = 1 THEN CALL BitSet(K3,K0 + 1) _
                     ELSE IF K1 <> 0 THEN EXIT FOR
         NEXT
         IF K0 = 16 THEN K = -1 : _
                         K& = K3
  END SELECT
  K1 = 0
  SELECT CASE K
    CASE IS > 0
         DO
           K0 = AscMid(p$,K) - 48
           K1 = K1 + 1
           IF (K0 < 0) OR (K0 > 9) OR (K1 = 11) OR (K1 = 10 AND K0 > 1) _
              THEN EXIT DO
           k& = k& + k0& * K0
           k0& = 10 * k0&
           K = K - 1
         LOOP UNTIL K = 0
         IF K > 0 THEN IF AscMid(p$,K) = 45 THEN K& = - K&
  END SELECT
  Val4& = k&

END FUNCTION



FUNCTION IntToStr$ (p)

  IntToStr$ = LTRIM$(STR$(p))

END FUNCTION
        '
        '* * * *


FUNCTION LongToStr$ (p&)

  LongToStr$ = LTRIM$(STR$(p&))

END FUNCTION
        '
        '* * * *



FUNCTION FidoForm$ (p$)

  IF LEN(RTRIM$(p$)) = 0 _
     THEN FidoForm$ = Null$ _
     ELSE CALL AddrToInt(p$,k,k0,k1) : _
          FidoForm$ = IntToStr$(k) + Chars$(58) + IntToStr$(k0) + _
                      Chars$(47) + IntToStr$(k1)

END FUNCTION
        '
        '* * * *


FUNCTION StrToNumL& (p$)

  p0$ = Null$
  k$ = ltrim$(p$)
  for k = 1 to len(k$)
    k0$ = mid$(k$,k,1)
    IF ASC(k0$) < 48 OR ASC(k0$) > 57 THEN EXIT FOR
    p0$ = p0$ + k0$
  next
  StrToNumL& = Val2&(p0$)

END FUNCTION





        '* * * * * *
        ' This routine will convert an integer date to string of the
        ' form mm/dd/yy.
        '
        ' Date last checked for perfection: Sep 16 1992
        '
FUNCTION IntToDate2$ (p)

  CALL DateDMY(p,K0,K1,K2)
  IntToDate2$ = Form4$(2,K1) + Chars$(47) + Form4$(2,K0) + Chars$(47) + _
                Form4$(2,K2 + 80)

END FUNCTION
        '
        '* * * *



'to save string space
'a 'p$ = UnSq$(p$)' uses x + y string space, where x is the size before
'and y the size after unsq'ing.  With this call, after the routine exits, only
'y string space is used.  (otherwise the calling routine is hampered with
'the excess x string space used--until another unsq$ is called.
SUB UnSq2 (p$)
 p$ = UnSq$(p$)
END SUB


        '* * * * * *
        ' Parse a pathname for the path.
        '
        ' p$ pathname to work with.
        '
        ' returns with the path (uppercased, with trailing '\').
        '
        ' Date last checked for perfection: May 3 1993
        '
FUNCTION ParseForPath$ (p$)

  K = StrSrchR(p$,92)
  IF K = 0 THEN K = StrSrchR(p$,47)
  ParseForPath$ = UCASE$(LEFT$(p$,K))

END FUNCTION
        '
        '* * * *



        '* * * * * *
        ' Parse a pathname for the filename.
        '
        ' p$ pathname to work with.
        '
        ' returns with the filename (uppercased, rtrimed).
        '
        ' Date last checked for perfection: May 3 1993
        '
FUNCTION ParseForName$ (p$)

  K = StrSrchR(p$,92)
  IF K = 0 THEN K = StrSrchR(p$,47)
  ParseForName$ = UCASE$(MID$(RTRIM$(p$),K + 1))

END FUNCTION
        '
        '* * * *


        '* * * * * *
        ' Create a filename or pathname given a net address.
        '
        ' p$ STRING*6 form of the net address to work with.
        '
        ' p  what to do for the filename:
        '    0  = <netnode>
        '    1  = <netnode>.REQ
        '    2  = TEMPAREA\<netnode>
        '    3  = TEMPAREA\<netnode>.REQ
        '    4  = to do for SumLog.DateOn and TIME$ instead of p$
        '    5  = MSGSTUFF\<zone>\<netnode>
        '    6  = MSGSTUFF\<zone>\<netnode>.REQ
        '    7  = MSGSTUFF\<zone>\<netnode>.FLO
        '    8  = TEMPAREA\<netnode>.FLO
        '    9  = MSGSTUFF\<zone>\<netnode>.
        '    10 = TEMPAREA\<netnode>.PKT
        '    [PATHS$(9) = d:\BBS\NODE???\TEMPAREA\]
        '    [PATHS$(5) = d:\BBS\GLOBAL\MSGSTUFF\]
        '
        ' returns with the filename or pathname.
        '
        ' Date last checked for perfection: May 30 1993
        '
FUNCTION ToNetNodeFile$ (p$,p)

  IF p <> 4 THEN CALL AddrToInt(p$,K,K0,K1) _
            ELSE K0 = SumLog.DateOn : _
                 K1 = TimeToInt(TIME$)
  K$ = IntToHex$(K0) + IntToHex$(K1)
  SELECT CASE p
    CASE 1  : K$ = K$ + Short$(770)
    CASE 2  : K$ = Paths$(9) + K$
    CASE 3  : K$ = Paths$(9) + K$ + Short$(770)
    CASE 5 TO 7
         K$ = Paths$(5) + IntToStr$(K) + Chars$(92) + K$
         IF p <> 5 THEN K$ = K$ + Short$(771 + (p = 6))
    CASE 8  : K$ = Paths$(9) + K$ + Short$(771)
    CASE 9  : K$ = Paths$(5) + IntToStr$(K) + Chars$(92) + K$ + Chars$(46)
    CASE 10 : K$ = Paths$(9) + K$ + Short$(866)
  END SELECT
  ToNetNodeFile$ = K$

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' Expand an integer date into readable form.
        '
        ' p integer date.
        '
        ' returns with the date in the form dd-mmm-yy
        '
        ' Date last checked for perfection: May 31 1993
        '
FUNCTION IntToDate3$ (p)

  IntToDate3$ = Form4$(9,p AND 31) + _
                MID$(Short$(126),(BitsShr(p,5) AND 15) * 4 + 1,5) + _
                IntToStr$(BitsShr(p,9) + 80)

END FUNCTION
        '
        '* * * *


        '* * * * * *
        ' Chop off the last character in a string.
        '
        ' p$ string to work with.
        '
        ' returns with the string less its right-most character.
        '
        ' Date last checked for perfection: May 31 1993
        '
FUNCTION ChopRight1$ (p$)

  K = LEN(p$)
  IF K > 1 THEN ChopRight1$ = LEFT$(p$,K - 1) _
           ELSE ChopRight1$ = Null$             'For the 0 and 1 length cases.

END FUNCTION
        '
        '* * * *


FUNCTION IntToTime$ (p)

  IntToTime$ = Form4$(2,BitsShr(p,11)) + Chars$(58) + _
               Form4$(2,BitsShr(p,5) AND 63) + _
               Chars$(58) + Form4$(2,(p AND 31) * 2)

END FUNCTION

FUNCTION IntToTime2$ (p)

  IntToTime2$ = Form4$(9,BitsShr(p,11)) + Chars$(58) + _
                Form4$(2,BitsShr(p,5) AND 63) + _
                Chars$(58) + Form4$(2,(p AND 31) * 2)

END FUNCTION


FUNCTION LeftTill$ (p$,p)

 K = StrSrch1(p$,p)
 IF K > 0 THEN LeftTill$ = LEFT$(p$,K - 1) _
          ELSE LeftTill$ = p$

END FUNCTION

'p$ string to search
'p  word number to get
'p0 returns with start of word in string
FUNCTION WordsGet$ (p$,p,p0)

  CALL WordsGet2(p$,p,p0,K)
  IF K > 0 THEN WordsGet$ = MID$(p$,p0,K) _
           ELSE WordsGet$ = Null$ : _
                p0 = 0

END FUNCTION



FUNCTION IntToAddr$ (p,p0,p1)

  IntToAddr$ = MKI$(p) + MKI$(p0) + MKI$(p1)

END FUNCTION


        '
        ' TT:     1 - 9999  for LINES.TXT
        '     10001 - 19999 for SHORT.TXT
        '     20001 - 20999 for o$()
        '     21001 - 21999 for o$() + C1310$
        '     rest for the future.
        '
SUB IDTT

  IF TT = 0 THEN EXIT SUB
  SELECT CASE TT
    CASE 1 TO 9999 : TT$ = Lines$(TT)
    CASE 10001 TO 19999 : TT$ = Short$(TT - 10000)
    CASE 20001 TO 20999 : TT$ = o$(TT - 20000)
    CASE 21001 TO 21999 : TT$ = o$(TT - 21000) + C1310$
  END SELECT
  TT = 0

END SUB


              'in reverse to minimize -'ve rollover effects
FUNCTION HexToInt% (p$)

  K$ = UCASE$(p$)
  IF AscRight(K$) = 72 THEN K$ = ChopRight1$(K$)
  K$ = RIGHT$(Short$(418) + K$,4)
  FOR K = 4 TO 1 STEP -1
    K0 = AscMid(K$,K)
    K0 = StrSrch1(Short$(810),K0) - 1
    SELECT CASE K
      CASE 1 : K1 = K1 + K0 * 4096
      CASE 2 : K1 = K1 + K0 * 256
      CASE 3 : K1 = K1 + K0 * 16
      CASE 4 : K1 = K0
    END SELECT
  NEXT
  HexToInt% = K1

END FUNCTION



FUNCTION IntToHex$ (p)

  IntToHex$ = RIGHT$(Short$(418) + UCASE$(HEX$(p)),4)

END FUNCTION



        '* * * * * *
        ' Expand a user entered net address into STRING*6 form.
        '
        ' p$ xxxxx:xxxxx/xxxxx form of net address to work with
        '
        ' returns with the net address in the STRING*6 form
        '
        ' Date last checked for perfection: Jun 2 1993
        '
FUNCTION StrToAddr$ (p$)

  K$ = SPACE$(6)
  IF LEN(p$) = 0 THEN StrToAddr$ = K$ : _
                      EXIT FUNCTION
  K0$ = LeftTill$(p$,64)            'Look for an '@Domain'.
  FOR K = 1 TO LEN(K0$)
    IF AscMid(K0$,K) < 48 OR AscMid(K0$,K) > 57 THEN MID$(K0$,K,1) = C32$
  NEXT
  CALL ReplaceCharacters(K0$,-2,Short$(652),48)
  CALL AddrToInt(GlobalStuff$(25),K,K0,K1)
  SELECT CASE WordsCnt(K0$)
    CASE 0 : StrToAddr$ = SPACE$(6)
             EXIT FUNCTION
    CASE 1 : K1 = Val2&(WordsGet$(K0$,1,0))
    CASE 2 : K1 = Val2&(WordsGet$(K0$,2,0))
             K0 = Val2&(WordsGet$(K0$,1,0))
    CASE ELSE : K1 = Val2&(WordsGet$(K0$,3,0))
                K0 = Val2&(WordsGet$(K0$,2,0))
                K = Val2&(WordsGet$(K0$,1,0))
  END SELECT
  StrToAddr$ = IntToAddr$(K,K0,K1)

END FUNCTION
        '
        '* * * *




'TT$ string to alter
'p$ assign to TT$ if not Null
'p1$ replace %1's with
SUB TTInsertStr1(p$,p1$)

  IF LEN(p$) > 0 THEN TT$ = p$
  CALL ReplaceStrings(TT$,Short$(147),p1$)

END SUB


'TT$ string to alter
'p$ assign to TT$ if not Null
'p1$ replace %1's with
'p2$ replace %2's with
SUB TTInsertStr2(p$,p1$,p2$)

  IF LEN(p$) > 0 THEN TT$ = p$
  CALL ReplaceStrings(TT$,Short$(147),p1$)
  CALL ReplaceStrings(TT$,Short$(148),p2$)

END SUB


'TT$ string to alter
'p$ assign to TT$ if not Null
'p1$ replace %1's with
'p2$ replace %2's with
'p3$ replace %3's with
SUB TTInsertStr3(p$,p1$,p2$,p3$)

  IF LEN(p$) > 0 THEN TT$ = p$
  CALL ReplaceStrings(TT$,Short$(147),p1$)
  CALL ReplaceStrings(TT$,Short$(148),p2$)
  CALL ReplaceStrings(TT$,Short$(150),p3$)

END SUB

