' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'
' This file contains various inputting routines:
'   LineEditTT
'   Censor
'   GrammarCk
'   UnCompressWordRec
'   BoxEdit



        '* * * * * *
        ' This routine will get from the user a line (or two) of text.
        '
        ' The CR/LF is removed.
        '
        ' Date last checked for perfection: Sep 19 1992
        '
FUNCTION LineEditTT$ (p)

  K20 = 0
  km = tt
  km$ = tt$
  CALL SendTT             'Convience, since we always send something out first.
  IF TGot = 13 THEN LineEditTT$ = Null$ :_
                    EXIT FUNCTION
  K0$ = SPACE$(p)
  '
  ' Special processing.  Password, Name and Location all are stored as
  ' uppercase, and NameCase'd out.  Location and Name also have their
  ' input heavily filtered.
  '
  SELECT CASE LESpecial
    CASE IS < 0 : K0 = 2                               'password
    CASE 2      : K0 = 4  : LESpecial = 0              'name
    CASE 3      : K0 = 8  : LESpecial = 0              'location
    CASE 4      : K0 = 16 : LESpecial = 0              'name (msg entry)
    CASE 6      : K0 = 32 : LESpecial = 0              'UserEdit keys.
    CASE 7      : K0 = 64 : LESpecial = 0              '[RING] exit.
    CASE 8      : K0 = 4 + 32 : LESpecial = 0          'name & useredit
    CASE ELSE   : K0 = 0
  END SELECT
  K1 = 0
  K$ = TIME$
  IF K0 = 32 OR K0 = 16 THEN CALL CursorOn
  DO
    z = 32
    IF BitTest(K0,6) THEN z = z + 2048
    K3 = CommIn(z)             '32 = bit 6 = allow net mail checking
    IF K0 = 64 THEN zz3 = FosIntAX(Settings.CommPort,&H300) : _
                    IF BitTest(zz3,7) THEN K0$ = Null$ : _
                                           EXIT DO
    SELECT CASE K0
      CASE 4, 36, 16
           SELECT CASE K3
             CASE 9, 33, 36, 37, 40, 41, 43, 48 TO 62, 64, 91 TO 96, _
                  123 TO 126, 128 TO 255 : K3 = -1
           END SELECT
           IF K3 = 35 AND (UserSL <> LevelsSize OR K1 > 0) THEN K3 = -1
      CASE 8
           '
           ' A filter, hopefully smaller than a 256 byte StrXLate string.
           '
           SELECT CASE K3
             CASE 9, 33, 35 TO 37, 41 TO 43, _
                  60 TO 64, 91 TO 96, 123 TO 126, 128 TO 255 : K3 = -1
           END SELECT
    END SELECT
    '
    ' No excessive inactivity message since that would cause all sorts of
    ' data entry display problems should the user decide to continue the
    ' session.  Also, the cursor could be positioned anywhere.
    '
    K4 = ElapsedTime(K$,K2)
    IF K4 = Settings.TimeOut OR _
       ((BitTest(K0,3) OR K0 = 16) AND K4 = Settings.LogoTimeOut) _
       THEN CALL Quote(0) : _
            K0$ = Null$ : _
            EXIT DO
    IF NoCarrier THEN K0$ = Null$ : _
                      EXIT DO
    SELECT CASE K3
      CASE 8, 127
           SELECT CASE K1
             CASE IS > 0
                  K1 = K1 - 1
                  CALL Wipe(1)
                  SELECT CASE LESpecial
                    CASE IS < 0
                         IF K1 = 1 THEN LESpecial = LESpecial - 5 _
                                   ELSE LESpecial = LESpecial - 1  
                         IF LESpecial < -32 + GetRndNum(5) _
                            THEN CALL Wipe(K1) : _
                                 CALL HangUp : _
                                 IF BitTest(Settings.LoggingAmount,4) _
                                    THEN TT$ = RTRIM$(User.UserName) + _
                                               Short$(710) : _
                                         CALL LogTT
                  END SELECT
           END SELECT
           K20 = K20 + 1
           IF K20 = 240 THEN CALL HangUp
      CASE 13, 32 TO 126
           K4 = -1
           IF (BitTest(K0,3) OR K0 = 16) AND (K3 = 42 OR K3 = 63) _
              THEN IF K0 = 16 THEN LESpecial = 3 : _
                                   CALL UserNameMatcher(K0$,k1,km,km$,k3) : _
                                   LESpecial = 0 : _
                                   K4 = 0 _
                              ELSE CALL UserNameMatcher(K0$,k1,km,km$,k3) : _
                                   K4 = 0
           IF K3 = 13 THEN K0$ = LEFT$(K0$,K1) : _
                           EXIT DO
           K$ = TIME$
           SELECT CASE K4
             CASE -1
                  TT$ = Chars$(K3)
                  K1 = K1 + 1
                  SELECT CASE K0
                    CASE 2, 4, 36, 8, 16
                         MID$(K0$,K1,1) = UCASE$(TT$)
                         TT$ = K0$
                         CALL WordsCase(TT$)
                         TT$ = MID$(TT$,K1,1)
                    CASE ELSE : MID$(K0$,K1,1) = TT$
                  END SELECT
                  CALL CommOut(TT$)
                  CALL AnsiTT
'                  IF K0 = 2 AND LEFT$(K0$,K1) = RTRIM$(User.Password) _
'                     THEN K0$ = LEFT$(K0$,K1) : _
'                          EXIT DO
                  IF K1 > 2 THEN IF AscMid(K0$,K1) = AscMid(K0$,K1 - 2) _
                                    THEN CALL ForeignChar(K0$,K1)
                  IF K1 = p THEN EXIT DO
           END SELECT
      CASE 27   'UserEdit Abort, and general-desired Abort
           IF BitTest(K0,6) THEN TGot = K3 _
                            ELSE K0$ = Null$
           EXIT DO
      CASE 17408, 17152, 18688, 20736, 15104 : TGot = K3
                                               EXIT DO
    END SELECT
  LOOP UNTIL NoCarrier
  IF K0 = 32 OR K0 = 16 THEN CALL CursorOff
  LineEditTT$ = K0$

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine will 'censor' out various stuff.
        '
        ' p   the ending position (1..n) of the current line of text
        '     ('length of p$').  The space or CR/LF having not yet
        '     been added.  The last character of the string we're
        '     going to check.
        '
        ' p0  1 to check only case.  Active grammar check also.
        '     2 to check a description (censor superlatives) and case.
        '     When censoring was done, p will point to the character
        '     before the the current word--this may be 0, it may point
        '     to a space or a CR.
        '
        ' p$  The string to check.
        '
        ' Checks the 'word' in p$ from p back to the previous blank
        ' space (checks the 'word' ending at p).  When censoring, you
        ' want to call this routine whenever a space or CR/LF is hit
        ' (that is, check it after each word) but before said space or
        ' CR/LF is displayed.
        '
        ' There are actually 3 levels: case, non-words, and
        ' superlatives.  If both non-words and superlatives are turned
        ' off, then so is case.  If either non-words or superlatives
        ' is turned on, then so is case.
        '
        ' Date last checked for perfection: Sep 19 1992
        '
SUB Censor (p,p0,p$)

  IF NOT BitTest(Settings.Toggles1,9) AND NOT BitTest(Settings.Toggles1,10) _
     THEN EXIT SUB
  K2$ = LEFT$(p$,p)
  K1$ = WordsGet$(K2$,WordsCnt(K2$),K1)
  K2 = LEN(K1$)
  IF K2 = 0 OR p < 1 THEN EXIT SUB
  '
  ' Fix any blantant case errors.
  '
  IF K1$ = Chars$(105) THEN MID$(p$,K1,1) = Chars$(73)   'i -> I
  K5 = InList(4,K1$,Short$(5))
  IF K5 > 0 THEN MID$(p$,K1,K5) = UCASE$(MID$(p$,K1,K5))
  K5 = InList(3,K1$,Short$(4))
  IF K5 > 0 THEN MID$(p$,K1 + K2 - K5,K5) = UCASE$(MID$(p$,K1 + K2 - K5,K5))
  IF p0 = 1 AND K1$ = Short$(138) THEN CALL BitToggle(User.Toggles,8) : _
                                       CALL Wipe(K2) : _
                                       p = p - K2 : _
                                       p0 = 0
  CALL StrXLate(K1$,GlobalStuff$(14))
  '
  ' Eliminate 'non-words'.
  '
  SELECT CASE BitTest(Settings.Toggles1,10)
    CASE -1
         '
         'L8TR became 'L TR'
         'C00L became 'C  L'
         'K00L became 'K  L'
         '
         FOR K5 = 40 TO 49
           K6 = LEN(Short$(K5))
           IF LEFT$(K1$,K6) = Short$(K5) AND K6 > 0 THEN CALL Wipe(K2) : _
                                                         p = p - K2 : _
                                                         p0 = 0 : _
                                                         EXIT FOR
         NEXT
  END SELECT
  IF p0 = 1 AND BitTest(User.Toggles,8) _
     THEN K1 = 0 : _
          K2$ = LTRIM$(RTRIM$(K1$)) : _
          CALL GrammarCk(K1,K2$,Null$) : _
          IF K1 = -1 THEN IF CommPort = 0 THEN CALL Ansi2(C7$) _
                                          ELSE CALL CommOut(C7$)
  IF p0 < 2 OR NOT BitTest(Settings.Toggles1,9) THEN EXIT SUB
  '
  ' Eliminate superlatives (for descriptions).  If any sub-words are bad, then
  ' we zap the whole string.
  '
  FOR K1 = 1 TO WordsCnt(K1$)
'    IF InList(2,WordsGet$(K1$,K1,0),Short$(2)) THEN p0 = 0 : _
    IF InList(4,WordsGet$(K1$,K1,0),Short$(2)) THEN p0 = 0 : _
                                                    CALL Wipe(K2) : _
                                                    p = p - K2 : _
                                                    EXIT FOR
  NEXT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will spell check a string.
        '
        ' p   0 or less to process a full string (the highlighting
        '     routine).  A -1 is returned if a word wasn't found.
        '     Anything else to process the message text--even though
        '     looping, we work one word at a time since the user can
        '     type anything for the correct word (the editing
        '     routine).
        '
        ' p$  the string to process.
        '
        ' p0$ the message text
        '
        ' Date last checked for perfection: Sep 19 1992
        '
SUB GrammarCk (p,p$,p0$)

  K0 = 0
  K0$ = ClearAnsi$(p$)
  CALL StrXLate(K0$,GlobalStuff$(14))
  FOR K1 = 1 TO WordsCnt(K0$)
    K1$ = Null$
    K2$ = WordsGet$(K0$,K1,K2)
    K3  = LEN(K2$)
    SELECT CASE K3
      CASE 2, 3     : K2$ = LEFT$(K2$ + Short$(658),4)
      CASE 4 TO 12
      CASE 13 TO 18 : K2$ = Form$(1801,K2$)
      CASE ELSE     : K2$ = K1$
    END SELECT
    IF K2$ <> K1$ THEN K1$ = K2$ : _
                       CALL UnCompressWordRec(0,K1$)
    '
    ' Case < 1 handles the highlighting for the initial test (returns with the
    ' string modified to contain highlight codes.
    ' Case ELSE asks for the correction, and will actually alter the text in
    ' the message.
    '
    SELECT CASE K2$
      CASE IS <> K1$
           SELECT CASE p
             CASE IS < 1
                  p = -1
                  p$ = LEFT$(p$,K2 + K0 - 1) + Short$(748) + _
                       MID$(p$,K2 + K0,K3) + Colors$(2) + _
                       MID$(p$,K2 + K3 + K0)
                  K0 = K0 + LEN(Short$(748)) + LEN(Colors$(2))
             CASE ELSE
                  TT$ = Short$(798) + MID$(p$,K2 + K0,K3) + Short$(104)
                  K3$ = LineEditTT$(30)
                  CALL DispCRLF
                  IF ASC(p$) < 91 AND AscNull(K3$) > 96 _
                     THEN MID$(K3$,1,1) = Chars$(ASC(K3$) - 32)
                  IF LEN(K3$) = 0 _
                     THEN CALL SharedWriteEOF(0,0,RTRIM$(FileNames(9)) + Short$(490),p$) _
                     ELSE p0$ = LEFT$(p0$,p + K2 - 2) + K3$ + MID$(p0$,p + K2 + K3 - 1)
           END SELECT
    END SELECT
  NEXT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to GrammarCk, will either get or try
        ' to locate a word in the various WORDS files.
        '
        ' p   0 to find p$, returns the record number if found.
        '
        ' p$  contains the word to find (if K = 0) and returns the
        '     word found at K if K > 0.  Either way, p$ must be the
        '     length of the word to find, that is, the routine
        '     determines which file to search based on the length of
        '     p$.
        '
        ' All the WORDS files should be opened approriately before
        ' calling this.
        '
        ' Date last checked for perfection: Sep 19 1992
        '
SUB UnCompressWordRec (p,p$)

  K0 = LEN(p$)
  SELECT CASE K0
    CASE 1 TO 4
         K0 = 4
         K1 = 1
    CASE 5 TO 12 : K1 = K0 - 3
    CASE 13 TO 18
         K0 = 18
         K1 = 10
    CASE ELSE : EXIT SUB
  END SELECT
  K1$ = SPACE$(K0 + 2)
  SELECT CASE p
    CASE 0
         K2 = 1
         K3 = (FileLof&(Handle(K1 + 9),1) * 8&) \ (K0 * 5)
         K0$ = p$
         K4 = 0
         WHILE K3 >= K2 AND K4 = 0
           p = (K2 + K3) \ 2
           K& = (K0 * 5& * (p - 1)) \ 8
           CALL FileGetSLoc(Handle(K1 + 9),K&,K1$)
           p$ = SPACE$(k0)
           CALL Make8Bit(K1$,p,K0,p$)
           SELECT CASE K0$
             CASE IS < p$ : K3 = p - 1
             CASE p$      : K4 = p
             CASE IS > p$ : K2 = p + 1
           END SELECT
         WEND
         IF K4 <> p THEN p = 0
    CASE ELSE
         K& = (K0 * 5& * p) \ 8
         CALL FileGetSLoc(Handle(K1 + 9),K&,K1$)
         p$ = SPACE$(k0)
         CALL Make8Bit(K1$,p,K0,p$)
  END SELECT

END SUB
        '
        '* * * *





'p  y-coordinate on screen (row)
'p0 x-coordinate on screen (column)
'p1 total allowable lines (not to exceed end of screen)
'p2 line length (don't exceed 79, nor x-coordinate + p2 should exceed 79)
'uses o$(1..p1)
'set LESpecial = 1 to do description (superlative) censoring.
'unlike lineedit$, the coordinates must be
'known before calling this (it also handles tab's and lineedit doesn't)
'(and keypad keys)(does not do foreign chars)(no sysop control keys are
'allowed), doesn't do sendtt, but does draw the box and the text).
'neither ansi codes (except arrows)
'arrows move
'del deletes
'home to start of line
'end to end of line
SUB BoxEdit (p,p0,p1,p2,p1$)

  K20 = 0
  TT$ = p1$
  FOR K = 1 TO p1
    TT$ = TT$ + AnsiLocStr$(p + K - 1,p0) + LEFT$(o$(K) + SPACE$(p2),p2)
  NEXT
  K = 1
  K$ = o$(K)
  K0 = p0
  K0$ = TIME$
  K3 = 0
  CALL CursorOn
  kzz = 0
  DO
    IF kzz >= 0 THEN TT$ = TT$ + AnsiLocStr$(p,p0) : _
                     CALL CursorOff : _
                     CALL SendTT : _
                     CALL CursorOn
    IF K3 <> 27 THEN K3 = CommIn(142) _
                ELSE K3 = K5
    kzz = k3
    '
    ' No excessive inactivity message since that would cause all sorts of
    ' data entry display problems should the user decide to continue the
    ' session.  Also, the cursor could be positioned anywhere.
    '
    K4 = ElapsedTime(K0$,K2)
    IF K4 = Settings.TimeOut OR NoCarrier THEN CALL Quote(0) : _
                                               K$ = Null$ : _
                                               EXIT DO
    K1 = p0 - K0
    SELECT CASE K3
      CASE 9, 13, 32, RightSC, LeftSC, UpSC, DownSC, 21248, 18176, 20224
           IF LESpecial = 1 AND K1 > 1 _
              THEN K2 = 2 : _
                   K4 = K1 : _
                   CALL Censor(K1,K2,K$) : _
                   IF K2 = 0 THEN K3 = 0 : _
                                  p0 = p0 - (K4 - k1) : _
                                  K$ = LEFT$(K$,K1) + MID$(K$,K4 + 1) : _
                                  TT$ = AnsiLocStr$(p,K0) + K$ : _
                                  CALL SendTT
    END SELECT
    TT$ = Null$
    SELECT CASE K3
      CASE 8, 127 : IF K1 > 0 THEN K$ = LEFT$(K$,K1 - 1) + MID$(K$,K1 + 1) : _
                                   p0 = p0 - 1 : _
                                   TT$ = AnsiLocStr$(p,p0) + MID$(K$,K1) + C32$
                    K20 = K20 + 1
                    IF K20 = 200 THEN CALL HangUp
      CASE 9  : IF K1 + 8 <= LEN(K$) THEN p0 = p0 + 8
      CASE 13 : IF K < p1 THEN K3 = 0 : _
                               o$(K) = K$ : _
                               K = K + 1 : _
                               p = p + 1 : _
                               p0 = K0 : _
                               K$ = o$(K)
      CASE 27
           DO : K3 = CommIn(14)
           LOOP UNTIL K3 >= 0 OR NoCarrier    'Get past the '['
           DO : K3 = CommIn(14)
           LOOP UNTIL K3 >= 0 OR NoCarrier    'Get the important character.
           SELECT CASE K3
             CASE 65 : K5 = UpSC
             CASE 66 : K5 = DownSC
             CASE 67 : K5 = RightSC
             CASE 68 : K5 = LeftSC
           END SELECT
           IF K5 > 18000 THEN K3 = 27
      CASE 32 TO 126, 128 TO 255
           K2 = 0
           IF K1 < p2 _
              THEN K$ = LEFT$(LEFT$(K$,K1) + Chars$(K3) + MID$(K$,K1 + 1),p2) : _
                   TT$ = AnsiLocStr$(p,p0) + MID$(K$,K1 + 1) : _
                   p0 = p0 + 1 : _
                   K0$ = TIME$ : _
                   IF K1 > 1 THEN IF AscMid(K$,K1 - 1) = K3 THEN K2 = -1
           IF K1 = p2 THEN K20 = K20 + 1 : _
                           IF K20 = 200 THEN CALL HangUp
           SELECT CASE K2
             CASE -1
                  K2 = -2
                  FOR K4 = 1 TO LEN(Short$(845))
                    K2 = K2 + 3
                    IF MID$(K$,K1 - 1,3) = MID$(Short$(846),K2,3) _
                       THEN TT$ = MID$(Short$(845),K4,1) : _
                            K$ = LEFT$(K$,K1 - 2) + TT$ + MID$(K$,K1 + 2) : _
                            p0 = p0 - 2 : _
                            TT$ = AnsiLocStr$(p,p0 - 1) + MID$(K$,K1 - 1) + C32$ + C32$ : _
                            EXIT FOR
                  NEXT
           END SELECT
      CASE RightSC : IF K1 < LEN(K$) THEN p0 = p0 + 1 _
                                     ELSE IF K1 < p2 THEN K$ = K$ + C32$ : _
                                                          p0 = p0 + 1
      CASE LeftSC : IF K1 > 0 THEN p0 = p0 - 1
      CASE UpSC : IF K > 1 THEN o$(K) = K$ : _
                                K = K - 1 : _
                                p = p - 1 : _
                                K$ = o$(K) : _
                                IF K1 + 1 > LEN(K$) _
                                   THEN K$ = K$ + SPACE$(K1 + 1 - LEN(K$))
      CASE DownSC : IF K < p1 THEN K3 = 0 : _
                                   o$(K) = K$ : _
                                   K = K + 1 : _
                                   p = p + 1 : _
                                   K$ = o$(K) : _
                                   IF K1 + 1 > LEN(K$) _
                                      THEN K$ = K$ + SPACE$(K1 + 1 - LEN(K$))
      CASE 21248 : IF K1 < LEN(K$) _
                      THEN K$ = LEFT$(K$,K1) + MID$(K$,K1 + 2) : _
                           TT$ = AnsiLocStr$(p,p0) + MID$(K$,K1 + 1) + C32$
                                                   '<del>
      CASE 18176 : p0 = K0                         '<home>
      CASE 20224 : p0 = LEN(RTRIM$(K$)) + K0       '<end>
    END SELECT
  LOOP UNTIL (p1 = K AND (K3 = 13 OR K3 = DownSC)) OR NoCarrier
  o$(K) = K$
  CALL CursorOff
  LESpecial = 0

END SUB


