' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.




        '* * * * * *
        ' This routine returns a string with the percentage the
        ' smaller (second) value is in comparison to the larger
        ' (first) value.
        '
        ' p&   total
        '
        ' p0&  smaller number
        '
        ' Normally (PARTIAL / TOTAL) * 100 would be used, but this
        ' doesn't work for '\' integer division.  And the
        ' integer-only method (PARTIAL * 100) \ TOTAL doesn't work
        ' with massively large numbers (like this can).  That 100 cuts
        ' off two digits.
        '
        ' It's accurate to two decimal places.  However, because of
        ' rounding, usually adding up a list of percentages will only
        ' yield 99.99% total.  Rounding is done by adding .005 (where
        ' 100% = 100.00) to the calculated percentage.
        '
        ' Date last checked for perfection: Sep 20 1992
        '
FUNCTION PercentCalc$ (p&,p0&)

  K2& = p&
  K1& = p0&
  IF K1& = 0 THEN K2& = 0
  K$ = Null$
  SELECT CASE K2&
    CASE 0
    CASE K1& : K$ = Short$(540)
    CASE ELSE
         FOR K = 1 TO 5
           IF K2& > 9 AND K1& > 0 THEN SELECT CASE K1& : _
                                         CASE IS > 100000& : K2& = K2& \ 10& : _
                                         CASE ELSE         : K1& = K1& * 10 : _
                                       END SELECT : _
                                       K0 = K1& \ K2& : _
                                       K$ = K$ + IntToStr$(K0) _
                                  ELSE K$ = K$ + Chars$(48)
           IF K2& * K0 <= K1& THEN K1& = K1& - K2& * K0
         NEXT
         K$ = LongToStr$(Val2&(K$) + 5)       'Round it and remove space.
         K$ = ChopRight1$(K$)                 'Knock off last digit.
  END SELECT
  K = LEN(K$)
  SELECT CASE K
    CASE 0      : K$ = Short$(542)
    CASE 1      : K$ = Short$(543) + K$
    CASE 2      : K$ = Chars$(46) + K$
    CASE 3 TO 5 : K$ = LEFT$(K$,K - 2) + Chars$(46) + RIGHT$(K$,2)
  END SELECT
  PercentCalc$ = K$ + Chars$(37)

END FUNCTION
        '
        '* * * *

