' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'
'Various small user I/O routines:
'  GetFilePassWord
'  UpdateSumLog




        '* * * * * *
        ' This routine handles password, and group, protected file
        ' access.
        '
        ' p$  file name to use.
        '
        ' returns 0 for wrong password or -1 if password correct or no
        ' no password.
        '
        ' Date last checked for perfection: Oct 24 1992
        '
FUNCTION GetFilePassWord% (p$)

  IF LEN(RTRIM$(p$)) = 0 THEN GetFilePassWord% = 0 : _
                              EXIT FUNCTION
  KK = FileOpenR(FileNames(59))
  K0 = BiSearch(3,KK,Form$(1201,p$))
  IF K0 < 1 THEN CALL FileCloseR(KK) : _
                 GetFilePassWord% = 0 : _
                 EXIT FUNCTION
  K5 = FileOpenR(FileNames(4))
  CALL FileGetRec(KK,K0,22,FileIDX)
  CALL FileCloseR(KK)
  K0$ = SPACE$(12)
  CALL FileGetSLoc(K5,119& * FileIDX.FRec - 12,K0$)
  CALL FileCloseR(K5)
  K0 = -1
  K2 = IntMid(K0$,1)
  K3 = IntMid(K0$,11)
  IF K3 > 0 THEN CALL InGroup(K3,User.UserName) :  _
                 IF K3 = 0 THEN GetFilePassWord% = 0 : _
                                EXIT FUNCTION
  IF K2 <> 0 THEN TT$ = Short$(333) + RTRIM$(FileIDX.FName) + Lines$(52) : _
                  K1 = (StrCkSum(LineEditTT$(30)) = K2) : _
                  TT = 56 + K1 : _
                  CALL SendTT : _
                  IF K1 = 0 THEN K0 = 0
  GetFilePassWord% = K0

END FUNCTION
        '
        '* * * *




         '
         ' Update statistical summary log.
         '
SUB UpdateSumLog

  k = FileOpenW(FileNames(26))
  k& = FileLof&(k,1)
  k$ = SPACE$(30)
  DO
    k& = k& - 146
    CALL FileGetSLoc(k,k&,k$)
  LOOP UNTIL k& < 0 OR k$ = User.UserName
  IF K& >= 0 THEN CALL FilePutLoc(k,k&,146,SumLog)
  CALL FileCloseW(k)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will get a number or character from the user.
        '
        ' p$  valid alternative keys allowed.
        '
        ' If a '0<ret>' is entered, then this routine will wipe the
        ' '0'.
        '
        ' IF '####<valid key>' is entered, then this routine will wipe
        ' the numbers.
        '
        ' A CR/LF is not outputted in this routine, the calling
        ' routine is left to handle it.
        '
        ' A 0 and CR can be distiquished with TGot$, it'll be null if
        ' the user just hit enter.
        '
        ' Do a Val2&(TGot$) to get the number.  TGot$ contains the
        ' number upon return.
        '
        ' This routine can handle numbers of any length.
        '
        ' Date last checked for perfection: Sep 20 1992
        '
SUB GetNumPlusTT (p$)

  K20 = 0
  CALL SendTT
  IF LEN(p$) > 0 AND TGot > 0 THEN EXIT SUB
  K0$ = Null$
  DO
    CALL TGet(p$ + Short$(114) + C13$ + C8$)
    SELECT CASE TGot
      CASE 8
           IF LEN(K0$) > 0 THEN CALL Wipe(1) : _
                                K0$ = ChopRight1$(K0$)
           K20 = K20 + 1
           IF K20 = 50 THEN CALL HangUp
      CASE 48 TO 57, 46, 44
           K0$ = K0$ + TGot$
           TT$ = TGot$
           CALL SendTT
           TGot = 32767
    END SELECT
  LOOP UNTIL TGot < 1 OR StrSrch1(p$,TGot) > 0
  CALL ReplaceCharacters(K0$,-3,Null$,44)
  CALL ReplaceCharacters(K0$,-3,Null$,46)
  '
  'Now TGot=-1 if they hit a CR or the value of the valid key
  'K0$ = whatever numbers
  '
  K = LEN(K0$)
  IF TGot > 0 OR Val2&(K0$) = 0 THEN CALL Wipe(K)
  IF TGot < 1 THEN TGot$ = K0$

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will get a U.S. phone number.
        '
        ' p  0 to just get a number.
        '    1 to get a home phone number.
        '    2 to get a user's BBS phone number.
        '
        ' TGot$ returns with the alpha-numeric form of the number
        ' entered.
        '
        ' TT& returns with the long integer form of the number
        ' entered.
        '
        ' This routine cannot handle international numbers.
        '
        ' Formats: xxx-yyyy local
        '          (aaa) xxx-yyyy long distance
        '          The formats below aren't supported because they
        '          don't fit too well into long integer's:
        '            1 xxx-yyyy not so local (use LD format)
        '            1 (aaa) xxx-yyyy also a possible entry for long
        '            distance
        '            1 800 xxx-yyyy 800 numbers  --use LD format
        '            011 aaa bbb xxx yyyy  International, lengths
        '            vary, not sure.
        '
        ' When creating the long integer, the second digit of long
        ' distance numbers (always 0 or 1) is moved to the front.  So
        ' check the length of the number when convert back to a
        ' string.  If 7, then local, if 9 then (x0x) long distance, if
        ' 10 then (x1x) long distance.  Examples: (808) 666-5555 is
        ' stored as 886665555, (818) 666-5555 as 1886665555
        '
        ' Date last checked for perfection: Sep 19 1992
        '
SUB GetPhoneNumber (p)

  K20 = 0
  IF p = 1 THEN TT = 59 : _
                CALL SendTT
  IF p = 2 THEN TT = 60 : _
                CALL SendTT
  K$ = Null$
  DO
    CALL TGet(Short$(999) + C13$ + C8$)
    K = TGot
    K0$ = TGot$
    SELECT CASE TGot
      CASE 8
           DO
             IF LEN(K$) > 0 THEN K2 = AscRight(K$) : _
                                 K$ = ChopRight1$(K$) : _
                                 CALL Wipe(1)
           LOOP UNTIL LEN(K$) = 0 OR StrSrch1(Short$(999),K2) > 0
           IF K$ = Chars$(40) THEN K$ = Null$ : _
                                   CALL Wipe(1)
           K20 = K20 + 1
           IF K20 = 50 THEN CALL HangUp
      CASE IS > 8
           SELECT CASE AscNull(K$)
             CASE 40
                  SELECT CASE LEN(K$)
                    CASE 3 : K0$ = K0$ + Short$(491)
                    CASE 8 : K0$ = K0$ + Chars$(45)
                    CASE 14 : K = 0
                  END SELECT 
             CASE ELSE
                  SELECT CASE LEN(K$)
                    CASE 0 : IF TGot = 48 OR TGot = 49 THEN K = 0
                    CASE 1
'                         IF TGot = 48 OR TGot = 49 _
'                            THEN CALL Wipe(1) : _
'                                 K0$ = Chars$(40) + K$ + K0$ : _
'                                 K$ = Null$
                         IF TGot = 49 _
                            THEN CALL Wipe(1) : _
                                 K0$ = Chars$(40) + K$ + K0$ : _
                                 K$ = Null$
                    CASE 2 : K0$ = K0$ + Chars$(45)
                    CASE 8 : K = 0
                  END SELECT
           END SELECT
           IF K > 0 THEN K$ = K$ + K0$ : _
                         TT$ = K0$ : _
                         CALL SendTT
    END SELECT
  LOOP UNTIL K = -1
  TT& = 0
  TGot$ = Null$
  SELECT CASE AscNull(K$)
    CASE 40
         IF LEN(K$) = 14 _
            THEN TT& = Val2&(MID$(K$,3,1) + MID$(K$,2,1) + MID$(K$,4,1) + _
                       MID$(K$,7,3) + RIGHT$(K$,4)) : _
                 TGot$ = K$
    CASE ELSE
         IF LEN(K$) = 8 THEN TT& = Val2&(LEFT$(K$,3) + RIGHT$(K$,4)) : _
                             TGot$ = K$
  END SELECT
  IF p = 1 THEN User.HomePhone = TT&
  IF p = 2 THEN User.BBSPhone = TT&

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine handles the inputting of a range of security
        ' levels.
        '
        ' p   returns with the starting range value.
        '
        ' p0  returns with the ending range value.
        '
        ' Date last checked for perfection: Sep 21 1992
        '
SUB GetSLRange (p,p0)

  p = 0
  p0 = -1
  TT = 10690
  K$ = LineEditTT$(20)
  CALL DispCRLF
  IF LEN(K$) = 0 THEN EXIT SUB
  K = StrSrch(1,K$,Short$(215))            'Find the 'to'.
  IF K = 0 THEN p = Val2&(K$) : _
                p0 = p _
           ELSE p = Val2&(LEFT$(K$,K - 1)) : _
                p0 = Val2&(K$)
  IF ASC(K$) = 45 THEN p = - p
  IF p0 < p THEN SWAP p,p0

END SUB
        '
        '* * * *





        '* * * * * *
        ' This routine gets, and returns with, a description for a
        ' file.
        '
        ' p    What to do:
        '      -1 just get a new decription line.
        '      -2 just add GIF info to a description.
        '      -3 to replace a description line, and add GIF info.
        '       1 to replace a description line, and add GIF info, but
        '         to not replace description line if already has more
        '         than 3 characters.
        '
        ' p$   Output text for first (bar) line.
        ' p0$  Output txt for second (description) line.
        '
        ' A FileList read-in of the desired file must have been done
        ' before calling this.
        '
        ' FileList.FDesc is modified if there were any changes.
        '
        ' Date last checked for perfection: Sep 19 1992
        '
SUB GetDesc (p,p$,p0$)

  SELECT CASE p
    CASE -1, -3, 1
         TT$ = Short$(131) + Form$(1801,p$) + Short$(403) + _
               Form$(1566,p0$) + Short$(664)
         CALL SendTT
         o$(1) = Null$
         IF p = -3 OR p = 1 THEN o$(1) = RTRIM$(FileList.FDesc)
         K0 = 0
         IF p = 1 AND LEN(RTRIM$(FileList.FDesc)) > Settings.MinDescLength _
            THEN K0 = 1 : _
                 TT$ = Short$(668) + RTRIM$(FileList.FDesc) + Short$(673) + _
                       C1310$ : _
                 CALL SendTT
         SELECT CASE K0
           CASE 0
                IF User.UserName <> FileAreaInfo3$(FileList.FArea,1) _
                   THEN LESpecial = 1
                SELECT CASE p
                  CASE -1 : K1 = 11
                            K2 = 20
                  CASE -3 : K1 = 18
                            K2 = 20
                  CASE 1 : K1 = 5
                           K2 = 20
                END SELECT
                CALL BoxEdit(K1,K2,1,51,Short$(90))
                K2$ = RTRIM$(o$(1))
                K0 = LEN(RTRIM$(FileList.FDesc)) - LEN(K2$)
                IF K0 > 0 AND LEN(K2$) > 0 THEN TT$ = SPACE$(K0) : _
                                                CALL SendTT
                CALL DispCRLF
                K2$ = LTRIM$(RTRIM$(K2$))
                IF LEN(K2$) < 3 THEN EXIT SUB
                FileList.FDesc = K2$
         END SELECT
  END SELECT
  SELECT CASE p
    CASE -2, -3, 1
         K1$ = FileAreaInfo3$(FileList.FArea,2) + FileList.FName
         IF BitTest(FileAreaI(FileList.FArea).Attr,1) THEN K0 = 38 _
                                                      ELSE K0 = 52
         IF StrSrch(1,FileList.FName,Short$(128)) > 0 _
            THEN K1$ = GifInfo$(K1$) : _
                 MID$(FileList.FDesc,K0 - LEN(K1$)) = K1$
  END SELECT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to GetDesc, will get the size
        ' information from GIF files.
        '
        ' p$  pathname of file to examine.
        '
        ' Date last checked for perfection: Sep 19 1992
        '
FUNCTION GifInfo$ (p$)

  K0$ = SPACE$(48)
  K = FileOpenR(p$)
  CALL FileGetSLoc(K,0&,K0$)
  CALL FileCloseR(K)
  SELECT CASE LEFT$(K0$,3)
    CASE Short$(355)                    'GIF87a GIF89a
         K = 0
         K0 = AscMid(K0$,11)
         IF BitTest(K0,1) THEN K = 1
         IF BitTest(K0,2) THEN K = K + 2
         IF BitTest(K0,3) THEN K = K + 4
         K0 = 7
         K1 = 9
         K = Power2(K + 1)
    CASE Short$(272), Short$(273)       'Windows bitmap
         K0 = 19
         K1 = 23
         K = IntMid(K0$,47)
    CASE ELSE : GifInfo$ = Lines$(239)
                EXIT FUNCTION
  END SELECT
  GifInfo$ = Short$(267) + IntToStr$(IntMid(K0$,K0)) + Chars$(120) + _
             IntToStr$(IntMid(K0$,K1)) + Chars$(120) + IntToStr$(K) + Chars$(93)

END FUNCTION
        '
        '* * * *


