' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'
' Various database/data manipulation routines:
'   ListUsers
'   CallersLog
'   DirectryView
'   SkillExchange
'   Questionaire
'   BBSReview
'   Reminder
'
SUB OverLay10
END SUB



        '* * * * * *
        ' This routine will display the contents of the USERS file.
        '
        ' p  1 displays all users, or all users matching a search
        '      string.
        '    2 displays all users within a range of security levels.
        '      It's also used to find out which users haven't called
        '      in x days.
        '
        ' Cannot enter a: -'ve to -'ve  range, the nearest allowable
        ' equivalent is: -'ve to 0.
        '
        ' Date last checked for perfection: Sep 15 1992
        '
SUB ListUsers (p)

  CALL BlockToO(0,33)
  TT = 20001
  CALL SendTT
  SELECT CASE p
    CASE 1
         TT = 20002
         K$ = Form1$(2,LineEditTT$(30))
         IF LEN(K$) = 0 THEN K$ = C32$
    CASE 2
         CALL GetSLRange(K0,K1)
         IF K1 < 0 THEN EXIT SUB
         TT = 20003
         CALL GetNumPlusTT(Null$)
         K7 = Val2&(TGot$)
         IF LEN(TGot$) = 0 THEN K7 = 32767
  END SELECT
  TT = 20004
  CALL SendTT
  IF TGot > 0 THEN EXIT SUB
  K3 = 1
  TGot = 0
  DO
    IF TGot = 45 THEN TT = 20001 : _
                      CALL SendTT
    IF p = 1 THEN TT = 20006 : _
                  K8 = 2 _
             ELSE TT = 20005 : _
                  K8 = 1
    CALL SendTT
    K9 = FileOpenR(FileNames(1))
    k10 = FileOpenR(FileNames(56))
    kz = FileLof&(k10,32)
    K3& = kz
    CALL ShowMeter(- K3&)
    IF K3 = 1 THEN K2 = K8 _
              ELSE K2 = kz
    WHILE K2 >= K8 AND K2 <= kz AND TGot < 1
      SELECT CASE p
        CASE 1
             CALL FileGetRec(K10,K2,32,UserIDX)
             SELECT CASE StrSrch(1,UserIDX.UserName,K$)
               CASE IS > 0
                    CALL FileGetRec(K9,UserIDX.RecNum,384,AnyUser)
                    CALL DateDMY(AnyUser.LastDateOn,K4,K5,K6)
                    TT$ = o$(8 + (AnyUser.UserName = User.UserName)) + _
                          Form$(2769,AnyUser.UserName) + o$(9) + _
                          Form$(2469,AnyUser.CityState) + o$(10) + _
                          IntToDate3$(AnyUser.LastDateOn) + o$(11) + _
                          Form$(702,STR$(AnyUser.Logons)) + o$(12) + _
                          Form$(502,STR$(AnyUser.Uplds)) + o$(13) + _
                          Form$(301,STR$(AnyUser.Dnlds)) + C1310$
                    CALL SendTT
             END SELECT
        CASE 2
             K2& = K2
             CALL ShowMeter(K2&)
             CALL FileGetRec(K10,K2,32,UserIDX)
             CALL FileGetLoc(K9,384& * UserIDX.RecNum - 299,2,K4)
             SELECT CASE K4
               CASE K0 TO K1
                    CALL FileGetRec(K9,UserIDX.RecNum,384,AnyUser)
                    K& = DaysSince&(AnyUser.LastDateOn)
                    K0& = AnyUser.MsgsPosted + AnyUser.FMsgsPosted + _
                          AnyUser.EMsgsPosted + AnyUser.NetMailSent
                    K1& = AnyUser.Logons
                    TT$ = o$(15 + (K& < K7)) + _
                          Form$(2405,AnyUser.UserName) + _
                          Form$(702,STR$(AnyUser.SecLevel)) + o$(16) + _
                          Form2$(12,AnyUser.DLBytes) + _
                          Form2$(12,AnyUser.ULBytes) + Form2$(7,K0&) + _
                          Form2$(7,K0&) + o$(12) + Form2$(7,K&)
                    IF LEN(RTRIM$(AnyUser.SysopNote)) > 0 _
                       THEN TT$ = TT$ + o$(17)
                    TT$ = TT$ + C1310$
                    CALL SendTT
             END SELECT
      END SELECT
      IF K3 = 1 THEN K2 = K2 + 1 _
                ELSE K2 = K2 - 1
    WEND
    CALL FileCloseR(K10)
    CALL FileCloseR(K9)
    K3 = - K3
  LOOP UNTIL TGot <> 45
  IF TGot < 1 THEN TT = 20018 : _
                   CALL SendTT
  CALL Paused

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will display the contents of the CALLERS log
        ' file.
        '
        ' p  1 lists the log for user or sysop.
        '    2 searches the log for a matching text string.  Returning
        '      with all found entries, and the name associated with
        '      those entries (since it's usually used to see who
        '      uploaded something).
        '
        ' Date last checked for perfection: Sep 15 1992
        '
SUB CallersLog (p)

  CALL BlockToO(0,34)
  SELECT CASE p
    CASE 1
         TT = 20001
         CALL SendTT
         IF TGot > 0 THEN EXIT SUB
    CASE 2
         TT = 20013
         K2$ = UCASE$(LineEditTT$(49))
         IF LEN(K2$) = 0 THEN EXIT SUB
         CALL DispCRLF
         CALL DispCRLF
         K0$ = Null$
  END SELECT
  K1$ = RTRIM$(Settings.LogLeader)
  K2 = LEN(K1$)
  K9 = 0
  K3 = FileOpenR(FileNames(25))
  K0& = FileLof&(K3,1)
  CALL ShowMeter(- K0&)
  K& = K0&
  DO
    K9 = K9 + 1
    K$ = FileGetLineR$(K3,K&)
    K$ = LEFT$(K$,79)
    K1 = (AscMid(K$,3) = 45 AND AscMid(K$,7) = 45)
    SELECT CASE p
      CASE 2
           CALL ShowMeter(K0& - K&)
           IF K1 THEN K0$ = K$
           IF StrSrch(1,UCASE$(K$),K2$) = 0 THEN K$ = Null$
           IF LEN(K$) > 0 AND LEN(K0$) > 0 AND K1 = 0 _
              THEN TT$ = o$(3) + K0$ + C1310$ : _
                   CALL SendTT : _
                   K0$ = Null$
           IF TGot > 0 THEN K$ = Null$
    END SELECT
    SELECT CASE LEFT$(K$,K2)
      CASE K1$
           TT$ = o$(4) + K$ + o$(5)
           IF UserSL = LevelsSize _
              THEN TT$ = o$(6) + TT$ + C1310$ _
              ELSE IF BitTest(Settings.Toggles1,7) THEN TT$ = TT$ + C1310$ : _
                                                        CALL AnsiTT : _
                                                        TT$ = Null$ _
                                                   ELSE TT$ = Null$
      CASE ELSE
           K0 = StrSrch(1,K$,o$(7))
           IF K0 > 0 THEN TT$ = o$(8) + MID$(K$,11,K0 - 11) _
                     ELSE TT$ = Null$ : _
                          K0 = StrSrch(1,K$,o$(9)) : _
                          IF K0 = 0 THEN K0 = 11
           IF K1 THEN TT$ = o$(5) + LEFT$(K$,10) + TT$ + o$(5) + MID$(K$,K0) _
                 ELSE TT$ = o$(10) + K$ + o$(11)
           TT$ = o$(6) + TT$ + C1310$
    END SELECT
    IF LEN(K$) > 0 THEN CALL SendTT : _
                        K9 = 0
    IF K9 = 50 AND p = 2 THEN TT = 20012 : _
                              CALL SendTT : _
                              K9 = 0
  LOOP UNTIL K& = -1 OR TGot > 0
  CALL FileCloseR(K3)
  IF p = 2 AND TGot < 1 THEN TT = 20002 : _
                             CALL SendTT
  CALL Paused

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine reads/accesses DIRECTRY files.
        '
        '                  xx = DIRECTRY number
        '                       DIRECTRY.Dxx  data
        '                       DIRECTRY.Txx  titles
        '                       DIRECTRY.Ixx  index
        '
        ' Each data element selected is displayed, then a Paused is
        ' done and a wait for the user to hit [Enter].
        '
        '
        ' Date last checked for perfection: Sep 2 1992 
        '
SUB DirectryView (p)

  K0$ = Form4$(2,p)
  K1 = FileOpenR(RTRIM$(FileNames(44)) + K0$)             'DIRECTRY.Dxx
  K2 = FileOpenR(RTRIM$(FileNames(45)) + K0$)             'DIRECTRY.Txx
  K3 = FileOpenR(RTRIM$(FileNames(46)) + K0$)             'DIRECTRY.Ixx
  DO
    '
    ' Get data to display.  Show titles.
    '
    K0& = 0
    TT$ = FileGetLine$(K2,K0&)                    'Top line of screen.
    CALL SendTT
    TT$ = FileGetLine$(K2,K0&)                    'Question line.
    K$ = Null$
    DO : K$ = K$ + RTRIM$(FileGetLine$(K2,K0&)) + C0$
    LOOP UNTIL K0& = -1
    CALL MenuSystem(K$,0)
    IF TGot = 0 THEN EXIT DO
    K = TGot
    '
    ' Display a data item.
    '
    K0& = 0
'    K$ = FileGetLine$(K1,K0&)                      'Data type.
    TT$ = FileGetLine$(K1,K0&)                     'Header line.
    IF TT$ = Short$(411) THEN TT = 10107 : _
                              CALL SendTT
'    SELECT CASE LEFT$(K$,4)
'      CASE Short$(407)
'           CALL FileGetRec(K3,K,4,K0&)             'Get location of line.
'           TT$ = FileGetLine$(K1,K0&) + C1310$     'Get the line. 
'           CALL SendTT
'      CASE Short$(408)
           CALL FileGetRec(K3,K,4,K0&)            'Get location of block.
           TT$ = FileGetLine$(K1,K0&)             'First line of block.
           DO
             TT$ = Short$(413) + TT$ + C1310$
             CALL SendTT
             TT$ = FileGetLine$(K1,K0&)           'More lines of block.
           LOOP UNTIL K0& = -1 OR TT$ = Short$(503) OR NoCarrier OR TGot > 0
'      CASE Short$(410)
'           CALL FileGetRec(K3,K * 2 - 1,4,K0&)    'Get location of text.
'           CALL FileGetRec(K3,K * 2,4,K&)         'Get size of text.
'           K& = K0& + K&
'           DO
'             TT$ = Short$(414) + FileGetBlock$(K1,K0&,K&)
'             CALL SendTT
'           LOOP UNTIL TGot > 0 OR K0& = K&
'    END SELECT
    CALL Paused
  LOOP UNTIL NoCarrier
  CALL FileCloseR(K1)
  CALL FileCloseR(K2)
  CALL FileCloseR(K3)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will display/add/update a list of users and
        ' their specialities.
        '
        ' Date last checked for perfection: Aug 31 1992
        '
SUB SkillExchange

  CALL BlockToO(0,35)
  CALL DispTextBlock(0,2,C13$)
  K& = 0
  CALL TGet2(o$(1) + C13$)
  SELECT CASE TGot
    CASE 1
         TT = 20011
         CALL SendTT
         K0 = FileOpenR(FileNames(17))
         WHILE K& <> -1 AND TGot < 0
           TT$ = FileGetLine$(K0,K&)
           SELECT CASE AscNull(TT$)
             CASE 49
                  K$ = MID$(TT$,2,30)
                  K2 = (K$ = User.UserName)
                  TT$ = o$(5 + K2) + _
                        StripLeft$(NCR$(K$) + o$(7 + K2) + o$(2),31) + _
                        Short$(92) + MID$(TT$,32) + C1310$
                  CALL SendTT
           END SELECT
         WEND
         CALL DispCRLF
         CALL FileCloseR(K0)
         CALL Paused
    CASE 2, 3
         TT = 20008
         CALL SendTT
         K$ = o$(9) + User.UserName
         K0 = FileOpenR(FileNames(17))
         DO
           K0$ = FileGetLine$(K0,K&)
           IF LEFT$(K0$,31) = K$ THEN K& = -2
         LOOP UNTIL K& < 0
         CALL FileCloseR(K0)
         TT = 20010
         CALL SendTT
         IF DriveSpc&(FileNames(17)) < Settings.MinSpace THEN TT = 20012 : _
                                                              CALL SendTT : _
                                                              EXIT SUB
         TT = 20003
         CALL SendTT
         IF K& = -2 THEN TT$ = o$(13) + MID$(K0$,32) + o$(14) _
                    ELSE TT$ = o$(15)
         TT$ = LEFT$(NCR$(User.UserName) + o$(2),31) + TT$
         K1$ = LineEditTT$(47)
         K = LEN(MID$(K0$,32)) - LEN(K1$)
         K1$ = LTRIM$(RTRIM$(K1$))
         IF LEN(K1$) < 5 THEN EXIT SUB
         IF K > 0 THEN TT$ = SPACE$(K) : _
                       CALL SendTT
         CALL DispCRLF
         CALL DispCRLF
         K& = 0
         K = FileOpenWDA(FileNames(17))
         DO
           K0& = K&
           K0$ = FileGetLine$(K,K&)
           IF LEFT$(K0$,31) = K$ THEN K& = -2
         LOOP UNTIL K& < 0
         K$ = K$ + K1$ + C1310$
         IF K& = -1 THEN CALL FilePutSEnd(K,K$) _
                    ELSE CALL CutOut(K,Null$,K0& + 1,LEN(K0$) + 2&) : _
                         CALL CutIn(K,Null$,K0& + 1,K$)
         CALL FileCloseW(K)
         TT = 20016
         CALL SendTT
    CASE ELSE
         TT = 20017
         CALL SendTT
  END SELECT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This is a very simplistic questionaire/survey system.
        '
        ' The SURVEY.xxx files consist of two entries:
        '   A line of text in SendTT format, which is either text to
        '   display, or a question to ask.
        '   A number, which corressponds to the size of the allowed
        '   input.
        '
        '  p  1 if should ask a survey
        '     2 if should answer a survey
        '  p$ survey file to use
        '
        ' Date last checked for perfection: Sep 15 1992
        '
SUB Questionaire (p,p$)

  K0 = FileOpenR(RTRIM$(FileNames(47)) + p$)
  K1 = FileOpenW(RTRIM$(FileNames(48)) + p$)
  K& = 0
  K0& = 0
  SELECT CASE p
    CASE 2
         DO
           TT$ = FileGetLine$(K0,K&)
           IF LEN(TT$) = 0 THEN TT$ = C1310$
           K =  Val2&(TT$)
           IF LEN(STR$(K)) <> LEN(LTRIM$(RTRIM$(TT$))) + 1 THEN K = 0
           IF K > 0 THEN TT$ = Null$ : _
                         CALL FilePutSend(K1,LineEditTT$(K) + C1310$) _
                    ELSE CALL SendTT
         LOOP UNTIL K& = -1
         CALL FilePutSend(K1,C1310$)
    CASE 1
         DO
           DO
             TT$ = FileGetLine$(K0,K&)
             IF LEN(TT$) = 0 THEN TT$ = C1310$
             K = Val2&(TT$)
             IF LEN(STR$(K)) <> LEN(LTRIM$(RTRIM$(TT$))) + 1 THEN K = 0
             IF K > 0 THEN TT$ = FileGetLine$(K1,K0&) : _
                           CALL SendTT _
                      ELSE CALL ReplaceCharacters(TT$,-4,Short$(132),0) : _
                           CALL SendTT
           LOOP UNTIL K& = -1
           CALL Paused
           K& = 0
           TT$ = FileGetLine$(K1,K0&)
         LOOP UNTIL K0& = -1 OR K0& + 2 >= FileLof&(K1,1)
  END SELECT
  CALL FileCloseR(K0)
  CALL FileCloseW(K1)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will add to, or list, the BBS reviews file.
        '
        ' Date last checked for perfection: Sep 23 1992
        '
SUB BBSReview

  CALL BlockToO(0,36)
  TT = 20004
  CALL SendTT
  K& = 0
  CALL TGet2(o$(2) + C13$)
  SELECT CASE TGot
    CASE 1
         K5 = FileOpenR(FileNames(16))
         TT = 20003
         CALL SendTT
         DO
           K$ = FileGetLine$(K5,K&)
           SELECT CASE AscNull(K$)
             CASE 50
                  IF LEN(RTRIM$(MID$(K$,2,20))) = 0 _
                     THEN TT$ = o$(9) _
                     ELSE TT$ = o$(5) + Form$(2005,MID$(K$,2))
                  TT$ = TT$ + o$(6) + MID$(K$,22) + C1310$
                  CALL SendTT
           END SELECT
         LOOP UNTIL K& = -1 OR TGot > 0
         CALL  FileCloseR(K5)
         CALL Paused
    CASE 2
         TT = 20007
         CALL SendTT
         IF DriveSpc&(FileNames(16)) < Settings.MinSpace THEN TT = 20008 : _
                                                              CALL SendTT : _
                                                              EXIT SUB
         TT = 20001
         CALL SendTT
         CALL GetPhoneNumber(0)
         IF LEN(TGot$) = 0 THEN EXIT SUB
         K0$ = o$(10) + Form$(2001,TGot$)
         CALL DispCRLF
         CALL DispCRLF
         '
         ' First we search thru the file looking for a matching phone number.
         '
         K = FileOpenR(FileNames(16))
         K& = 0
         K1$ = Null$
         DO
           K2$ = MID$(K1$,2,20)
           K1$ = FileGetLine$(K,K&)
           SELECT CASE K0$
             CASE LEFT$(K1$,21)
                  IF K& = -1 _
                     THEN K0& = FileLof&(K,1) - 1 _
                     ELSE DO : _
                            K0& = K& : _
                            K5 = LEN(RTRIM$(MID$(FileGetLine$(K,K&),2,20))) : _
                          LOOP UNTIL K& = -1 OR K5 > 0
                  K& = -2
           END SELECT
         LOOP UNTIL K& < 0
         CALL FileCloseR(K)
         SELECT CASE K&
           CASE -2
                '
                ' Matching entry found, tell them the BBS name.
                '
                TT$ = o$(11) + NCR$(K2$) + C1310$
                CALL SendTT
                K = 2
                K0$ = o$(10)
           CASE -1
                '
                ' No matching entry found, get a new BBS name.
                '
                TT = 20012
                K5$ = UCASE$(LineEditTT$(20))
                IF LEN(K5$) = 0 THEN EXIT SUB
                K2$ = Form$(2001,K5$)
                K = 0
         END SELECT
         '
         ' Get the text for the entry.
         '
         K$ = Null$
         K4$ = Null$
         K3$ = Null$
         K0 = 0
         TT = 20013
         CALL SendTT
         K7$ = Null$
         CALL GetMessageText(0,K7$)
         SELECT CASE LEN(K7$)
           CASE IS > 4
                CALL CRsToSpaces(K7$)
                CALL FindMsgLine(0,58,5,K4$,K1,K2,K7$)
                K4$ = Null$
                FOR K1 = 1 TO K2 + 1
                  IF LEN(K3$) > 0 _
                     THEN SELECT CASE K : _
                            CASE 0 : K6$ = o$(10) + K2$ : _
                            CASE 1 : K6$ = K0$ : _
                            CASE ELSE : K6$ = o$(15) : _
                          END SELECT : _
                          K$ = K$ + K6$ + K3$ + C1310$ : _
                          K = K + 1
                  CALL IntMax(K0,LEN(RTRIM$(K4$)))
                  K3$ = K4$
                  CALL FindMsgLine(K1,58,5,K4$,K2,K3,K7$)
                NEXT
                K4$ = o$(14) + NCR$(User.UserName)
                SELECT CASE LEN(K3$)
                  CASE IS > 0
                       SELECT CASE LEN(K3$) + LEN(K4$) + 1
                         CASE IS > K0
                              IF K0 > LEN(K4$) _
                                 THEN K4$ = SPACE$(K0 - LEN(K4$)) + K4$
                              SELECT CASE K
                                CASE 0 : K6$ = o$(10) + K2$
                                CASE 1 : K6$ = K0$
                                CASE ELSE : K6$ = o$(15)
                              END SELECT
                              K$ = K$ + K6$ + K3$ + C1310$
                              K3$ = Null$
                              K0 = LEN(K4$)
                              K = K + 1
                       END SELECT
                       K4$ = K3$ + SPACE$(K0 - LEN(K3$) - LEN(K4$)) + K4$
                       SELECT CASE K
                         CASE 0 : K6$ = o$(10) + K2$ + K4$ + C1310$ + K0$
                         CASE 1 : K6$ = K0$ + K4$
                         CASE ELSE : K6$ = o$(15) + K4$
                       END SELECT
                       K$ = K$ + K6$ + C1310$
                       IF K& = -1 THEN CALL SharedWriteEOF(16,-1,Null$,K$) _
                                  ELSE CALL CutIn(0,FileNames(16),K0& + 1,K$)
                END SELECT
                TT = 20016
                CALL SendTT
         END SELECT 
    CASE ELSE
         TT = 20017
         CALL SendTT
  END SELECT

END SUB
        '
        '* * * *


        '* * * * * *
        ' This routine lets the user make/erase thier UserNote field.
        '
        ' Date last checked for perfection: Sep 3 1992
        '
SUB Reminder

  K$ = RTRIM$(User.UserNote)
  TT$ = Lines$(108) + K$ + Short$(417)
  K0$ = LineEditTT$(52)
  K = LEN(K$) - LEN(K0$)
  IF K > 0 THEN TT$ = SPACE$(K) : _
                CALL SendTT
  User.UserNote = K0$
  TT = 193
  CALL SendTT

END SUB
        '
        '* * * *



