' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'
' This file contains door related routines:
'   DoorSystem
'   DoorSystemExitTT
'   DoorSystemReturn
'   LogOut  (put here to speed up when a user hangs up in a door)



        '* * * * * *
        ' This routine handles the exiting to doors.  Including the
        ' creation of the necessary files and the exit from the BBS.
        '
        ' p$  The command string being used.
        '
        ' p0$ The current menu being used.
        '
        ' Date last checked for perfection: Jan 20 1992
        '
SUB DoorSystem (p$,p0$)

  CALL BlockToO(2,7)
  IF User.Elapsed > Levels(UserSL).DLMinsPerDay THEN TT = 20052 : _
                                                     CALL SendTT : _
                                                     EXIT SUB
  K0 = 1   'Shell exit.
  K1 = 0   'No door files.
  K2 = 0   'No door record.
  FOR K = 2 TO 4
    K$ = UCASE$(WordsGet$(p$,K,0))
    FOR K4 = 1 TO WordsCnt(o$(1))
      IF WordsGet$(o$(1),K4,0) = K$ THEN K0 = K4 : _
                                         EXIT FOR
    NEXT
    FOR K5 = 1 TO WordsCnt(o$(2))
      IF WordsGet$(o$(2),K5,0) = K$ THEN K1 = K5  : _
                                         EXIT FOR
    NEXT
    IF K4 > WordsCnt(o$(1)) AND K5 > WordsCnt(o$(2)) THEN K2 = Val2&(K$) : _
                                                          EXIT FOR
  NEXT
  K0$ = WordsGet$(p$,K + 1,K3)
  IF K3 > 0 THEN p$ = MID$(p$,K3) _
            ELSE p$ = Null$
  IF K2 = 0 THEN EXIT SUB
  IF K0 = 3 AND DriveSpc&(Paths$(2)) < 400000& THEN TT = 158 : _
                                                    CALL SendTT : _
                                                    EXIT SUB
  '
  ' Get our door information.
  '
  K = FileOpenR(FileNames(37))
  CALL FileGetRec(K,K2,244,Door)
  CALL FileCloseR(K)

  IF Door.StartTime <> Door.EndTime _
     THEN kz1$ = IntToTime$(Door.StartTime) : _
          kz2$ = IntToTime$(Door.EndTime) : _
          IF NOT (TIME$ >= kz1$ AND TIME$ <= kz2$) _
             THEN CALL TTInsertStr2(o$(53),RightTime$(kz1$),RightTime$(kz2$)) : _
                  CALL SendTT : _
                  EXIT SUB

  K0$ = UCASE$(RTRIM$(Door.Path))
  IF LEN(K0$) = 0 THEN K0$ = Paths$(2)
  IF DriveSpc&(K0$) <= Door.MinSpace THEN TT = 158 : _
                                          CALL SendTT : _
                                          EXIT SUB
  IF AscRight(K0$) <> 92 THEN K0$ = K0$ + o$(15)
  '
  ' Output a JDRBBSxx.DEF and an alternate door file.
  '
  FOR K = 1 TO 2
    SELECT CASE K
      CASE 1
           IF K1 > 0 THEN K$ = WordsGet$(o$(3),K1,0) : _
                          TT$ = o$(3 + K1)
           IF K1 = 1 THEN K$ = K$ + IntToStr$(Settings.Node) + o$(13)
           IF K1 = 2 THEN TT$ = TT$ + o$(38)
      CASE 2                  'JDR_BBS's JDRBBSxx.DEF door file.
           K1 = 1
           K$ = o$(17) + Form4$(2,Settings.Node) + o$(13)
           TT$ = o$(18)
    END SELECT
    SELECT CASE K1
      CASE IS > 0
           CALL KillFile(K0$ + K$)
           K3 = FileOpenW(K0$ + K$)
           IF K1 = 5 THEN CALL FilePutRec(K3,1,128,PCB14) _
                     ELSE IF K1 = 6 THEN CALL FilePutRec(K3,1,128,PCB12) _
                                    ELSE CALL DoorSystemExitTT(K3,p0$)
           CALL FileCloseW(K3)
    END SELECT
  NEXT
  K1$ = ExpandStr$(Door.Execute)
  '
  ' Create RUN_DOOR.BAT if not a shell or swap exit.
  '
  SELECT CASE K0
    CASE 2
         K2$ = o$(39) + IntToStr$(K2) + C1310$ + LEFT$(K0$,2) + _
               C1310$ + o$(50) + MID$(K0$,3,LEN(K0$) - 3) + C1310$ + K1$
         K2$ = K2$ + C1310$ + LEFT$(Paths$(2),2) + C1310$ + _
               o$(50) + MID$(Paths$(2),3,LEN(Paths$(2)) - 3) + C1310$ + _
               RTRIM$(FileNames(55))
         CALL KillFile(FileNames(54))
         CALL SharedWriteEOF(54,0,Null$,K2$)
  END SELECT
  '
  ' If door not done from WFC, then update user and system stats.
  '
  SELECT CASE LEN(RTRIM$(User.UserName))
    CASE IS > 0
         SumLog.Doors = SumLog.Doors + 1
         User.Doors = User.Doors - (User.Doors < 32767)
         k3 = FileOpenW(FileNames(26))
         k& = FileLof&(k3,1)
         k$ = o$(19)
         DO
           k& = k& - 146
           CALL FileGetSLoc(k3,k&,k$)
         LOOP UNTIL k& < 0 OR k$ = User.UserName
         IF K& >= 0 THEN CALL FilePutLoc(k3,k&,146,SumLog)
         CALL FileCloseW(K3)
         kz = WriteStuff(1)
         kz = WriteStuff(4)
  END SELECT
  IF K0 = 2 THEN K = FosIntAX(CommPort,&H1D00) : _
                 TT$ = Null$ : _
                 CALL ShellDosTT(2)
  IF BitTest(Settings.Toggles2,8) OR BitTest(User.Attr,6) _
     THEN CALL FileCloseW(Handle(1))
  TT$ = K1$
  CALL ShellDosTT(13)
  CALL DoorSystemReturn(K2,p0$)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to DoorSystem, converts a door specs
        ' string into a door file.
        '
        ' p  file handle of door exit file.
        '
        ' p$ menu currently at.
        '
        ' TT/TT$  is the string of what to do.
        '
        ' Date last checked for perfection: Feb 1 1993
        '
SUB DoorSystemExitTT (p,p$)

  K0$ = Null$
  FOR K = 1 TO LEN(TT$) \ 3
    K$ = Null$
    K& = 0
    SELECT CASE Val2&(MID$(TT$,K * 3 - 2,3))
      CASE  1 : K$ = User.UserName                      'User's full name.
                K& = BiSearch(5,0,User.UserName)        'User's record number.
                PCB14.UserName = K$
                PCB14.RecNum = K&
                PCB12.UserName = K$
                PCB12.RecNum = K&
                PCB14.Misc1 = o$(20)
                PCB14.TimeUsed = 0
                PCB14.Misc4 = o$(21)
                PCB12.Misc1 = o$(22)
                PCB12.Misc2 = o$(23)
                PCB12.Misc3 = Form$(3902,o$(24))
      CASE  2 : K$ = User.CityState                     'User's location.
                K& = 15                                 'Default color.
      CASE  3 : K$ = Form$(16,User.UserName)            'User's first name.
                K& = Levels(UserSL).SecLevel            'User's SL value.
                PCB14.FirstName = K$
                PCB12.FirstName = K$
      CASE  4 : K$ = User.Password                      'User's password.
                K& = - (CommPort > 0)                   '0/1 local or not.
                PCB14.Password = K$
                PCB12.Password = K$
      CASE  5 : K$ = Door.UserName                      'Door-Op's name.
                K& = Settings.ModemBaud                 'Modem init baud rate.
                IF CommPort = 0 THEN K& = 0             '0 if local.
                PCB14.BPSRate = Form$(502,LongToStr$(K&))
      CASE  6 : K& = User.Uplds                         'User's total files uploaded.
                K$ = o$(25)
      CASE  7 : K& = User.Dnlds                         'User's total files downloaded.
                K$ = LongToStr$(StrToNumL&(SumLog.BaudRate)) 'Connection string.
                IF CommPort = 0 THEN K$ = o$(26)        'KB if local.
      CASE  8 : K& = User.Logons                        'User's total logons.
                K$ = Form1$(1,User.UserName)            'User's last name.
      CASE  9 : K& = User.ULBytes \ 1024&               'Total K uploaded.
                IF LEN(GlobalStuff$(4)) > 0 _
                   THEN K$ = GlobalStuff$(4) + C32$ + p$ _
                   ELSE K$ = p$
      CASE 10 : K& = User.DLBytes \ 1024&               'Total K downloaded.
                IF CommPort = 0 _
                   THEN K$ = o$(31) _
                   ELSE K$ = LongToStr$(Settings.ModemBaud) + o$(27)
      CASE 11 : K& = User.MsgsPosted + User.EMsgsPosted + User.FMsgsPosted + _
                     User.NetMailSent                   'Total messages posted.
                K$ = o$(28)
      CASE 12 : K0 = DLTime
                IF Door.MaxTime < K0 THEN K0 = Door.MaxTime
                K& = K0 * 60&                            'Time left (in seconds).
                K$ = STR$(K&) + o$(32)   'change to '.0' only
                PCB12.SecsAvail = K&
      CASE 13 : K0 = DLTime
                IF Door.MaxTime < K0 THEN K0 = Door.MaxTime
                K& = K0                                 'Time left (in minutes).
                PCB14.MinsAvail = K0
                PCB14.MinsAvail2 = K0
      CASE 14 : K$ = User.Protocol                      'Default protocol.
                K& = CanDL&                             'Number of allowed DL bytes.
      CASE 16 : K$ = IntToPhone$(User.HomePhone)        'Home phone number.
      CASE 17 : K$ = IntToPhone$(User.BBSPhone)         'Work/data/BBS phone number.
      CASE 18 : K& = 24                                 'Height of user's screen.
                K$ = TIME$ + C32$ + IntToDate2$(User.LastDateOn)
      CASE 19 : K$ = User.UserNote                      'Comment on user.
      CASE 20 : K$ = IntToDate2$(User.LastDateOn)       'Last date user called.
                                                        'Last new files scan date.
      CASE 21 : K$ = o$(34 + BitTest(Settings.Toggles2,2)) 'Y/N screen blank.
                PCB12.BlankScr = o$(36 + BitTest(Settings.Toggles2,2))
                PCB14.BlankScr = PCB12.BlankScr
      CASE 22 : K$ = o$(33)
      CASE 23 : K& = 8                                  'Parity.
                K$ = o$(37)                             'Ansi graphics.
      CASE 24 : K& = 0
                K$ = o$(48)
      CASE 25 : K& = 1
                K$ = o$(49)
      CASE 26 : K$ = IntToDate2$(User.SubsEnd)          'User expiration date.
      CASE 27 : K$ = IntToDate2$(User.BirthDate)        'User's birthdate.
      CASE 28 : K$ = Paths$(2)                          'Path to main/BBS files.
      CASE 29 : K$ = Door.Path                          'Path to door files.
      CASE 30 : K& = -1
                'I also use this one for K$ = NULL$ (blank line).
      CASE 31 : K& = User.Doors                         'Number of doors user opened.
      CASE 32 : K& = StrToNumL&(SumLog.BaudRate)
                K0$ = LongToStr$(K&)
                PCB14.Connect = Form$(502,K0$)
                PCB12.BPSRate = K0$
                IF CommPort = 0 THEN K& = 0 : _
                                     PCB14.Connect = o$(40) : _
                                     PCB12.BPSRate = o$(40)
                                                        'Connection baud.
                                                        '0 if local.
      CASE 33 : K$ = Time$                              'Current time in HH:MM:SS.
      CASE 34 : K$ = IntToTime$(SumLog.TimeOn)          'Logon time in HH:MM:SS.
      CASE 35 : K$ = IntToDate2$(SumLog.DateOn)         'Logon date in MM/DD/YY.
      CASE 36 : K$ = RTRIM$(SumLog.BaudRate)            'Connection string.
                                                        ''CONSOLE' if local.
                K& = ConnectCPS
      CASE 37 : K& = Settings.ExchMins                  'Exchange rate-mins.
      CASE 38 : K& = Settings.ExchBytes                 'Exchange rate-bytes.
      CASE 39 : K& = StrToNumL&(SumLog.BaudRate)
                SELECT CASE K&
                  CASE 300   : K& = 1
                  CASE 1200  : K& = 2
                  CASE 9600  : K& = 3
                  CASE 19200 : K& = 4
                  CASE ELSE  : K& = 0
                END SELECT
                IF K& = 0 THEN K$ = o$(29) _
                          ELSE K$ = o$(30)
      CASE 40 : K$ = o$(41)                             '00:00 Time of next event.
      CASE 43 : K$ = Settings.LogLeader
      CASE 44 : K0 = ElapsedTime(o$(42),K1)             'Current time since midnight.
                K& = K0 * 60&                           'In seconds.
                K$ = LEFT$(TIME$,5)                     'Current time in HH:MM.
                                                        'Time of this call.
                                                        'Time of last call.
                PCB14.LogonMins = K0                    'Minutes since midnight.
                PCB14.LogonTime = K$                    'HH:MM of current time.
                PCB12.LogonTime = K$                    'HH:MM of current time.
                PCB12.LogonSecs = K&                    'Seconds since midnight.
                PCB12.LogonSecs2 = K&                   'Same as LogonSecs.
      CASE 45 : K$ = o$(34)
      CASE 46 : K$ = Door.LogType
      CASE 48 : K& = CommPort                            'Comm port being used.
                PCB14.CommPort = IntToStr$(CommPort)
                K$ = o$(43) + PCB14.CommPort + o$(44)  'COMx:
      CASE 49 : K0 = 0
                IF BitTest(Settings.Toggles2,3) THEN CALL BitSet(K0,1)
                IF BitTest(Settings.Toggles2,2) THEN CALL BitSet(K0,2)
                IF BitTest(Settings.Toggles1,5) THEN CALL BitSet(K0,3)
                IF BitTest(User.Attr,6) OR BitTest(Settings.Toggles2,8) _
                   THEN CALL BitSet(K0,4)
                K& = K0
                                                       'Toggles:
                                                       'set: 1 = Sysop on next.
                                                       '     2 = Keep screen blank.
                                                       '     3 = Trap chat to file.
                                                       '     4 = Trap all to file.
      CASE 50 : K& = DaysSince&(User.BirthDate) \ 365&   'User's age.
      CASE 51 : K$ = o$(46 + BitTest(User.Toggles,16)) 'M/F gender of user.
      CASE 52 : K& = User.MinCredits                    'User's 'gold'.
      CASE 53 : K& = 80                                  'Width of user's screen.
      CASE 55 : K$ = FileNames(25)          'Path and filename of the log file.
      CASE 56 : K$ = FileNames(52)                      'Trap chat file.
      CASE 57 : K$ = FileNames(51)                      'Trap all file.
      CASE 58 : K& = - (User.SecLevel = Settings.CoSysopSL) '0/1 User = co-sysop.
      CASE 60 : K$ = Lines$(2)                           'BBS's name.
      CASE 61 : K$ = Form$(20,Door.UserName)             'Door-Op's first name.
      CASE 62 : K$ = Form1$(1,Door.UserName)             'Door-Op's last name.
      CASE 63 : K$ = o$(43) + IntToStr$(CommPort)        'COMx format.
      CASE 65 : IF User.UserName = Door.UserName _
                   THEN  K& = 255 _
                   ELSE  K& = UserSL                    'User's SL (1-255).
      CASE 66 : K& = - (User.UserName = Door.UserName)  'User = Door-Op.
      CASE 67 : K$ = o$(47)                             '8N1 Comm parameters.
      CASE 70 : K$ = o$(49 + BitTest(Settings.Toggles2,10))    'Maximum baud.
      CASE 71 : K& = Settings.Node
                PCB14.Node = IntToStr$(Settings.Node) 'Node number. ('1' to '9')
      CASE 72 : K& = User.DLBytes                     'User's downloaded bytes.
      CASE 73 : K& = User.ULBytes                     'User's uploaded bytes.
    END SELECT
    '
    ' Output the line (maybe).
    '
    SELECT CASE AscMid(TT$,K * 3 - 2)
      CASE 35    '#  Use K&, write to own line.
           K0$ = K0$ + LongToStr$(K&) + C1310$
      CASE 37    '%  Use K$, write to own line.
           K0$ = K0$ + UCASE$(LTRIM$(RTRIM$(K$))) + C1310$
      CASE 33    '!  Use K$, no modifications, write to own line.
           K0$ = K0$ + K$ + C1310$
    END SELECT
  NEXT
  CALL FilePutSEnd(p,K0$)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine handles the returning from door exits.  Only
        ' JDRBBSxx.DEF is checked for alterations.
        '
        ' p  is the door number we're returning from.
        '
        ' p$  menu to return to.
        '
        ' Date last checked for perfection: Sep 19 1992
        '
SUB DoorSystemReturn (p,p$)

  MinTimer = TimeToInt(TIME$)
  '
  ' Get our door information.
  '
  K0 = FileOpenR(FileNames(37))
  IF p > FileLof&(K0,244) THEN CALL FileCloseR(K0) : _
                               p = -1 :_
                               EXIT SUB
  CALL FileGetRec(K0,p,244,Door)
  CALL FileCloseR(K0)
  '
  ' Process the JDRBBSxx.DEF file.
  '
  K$ = RTRIM$(Door.Path)
  IF LEN(K$) = 0 THEN K$ = Paths$(2)
  K4 = FileOpenR(K$ + o$(17) + Form4$(2,Settings.Node) + o$(13))
  K0& = 0
  FOR K2 = 1 TO LEN(o$(18)) \ 3
    K$ = LTRIM$(RTRIM$(FileGetLine$(K4,K0&)))
    K& = Val2&(K$)
    K0 = (AscNull(K$) = 43)
    K1 = (AscNull(K$) = 45)
    kkz = k2
    if len(K$) = 0 AND kkz = 1 then kkz = 0
    SELECT CASE Kkz
      CASE 1
           SELECT CASE ReadStuff(1,K$)
             CASE -1
                  kz = ReadStuff(4,User.UserName)
                  UserSL = MappedSL(User.SecLevel)
                  CALL LoadFixedFiles
                  k0 = FileOpenR(FileNames(26))
                  k& = FileLof&(k0,1)
                  k$ = o$(19)
                  DO
                    k& = k& - 146
                    CALL FileGetSLoc(k0,k&,k$)
                  LOOP UNTIL k& < 0 OR k$ = User.UserName
                  IF K& >= 0 THEN CALL FileGetLoc(k0,k&,146,SumLog)
                  CALL FileCloseR(k0)
           END SELECT
      CASE 2 : CommPort = K&
               K3 = FosIntAX(CommPort,&H1C00)       'fossil on.
      CASE 3 : Kz1 = ElapsedTime(K$,K3)
      CASE 7 : IF LEN(K$) <= 4 THEN p$ = K$ _
                               ELSE kzz = StrSrch1(K$,32) : _
                                    GlobalStuff$(4) = LEFT$(K$,kzz - 1) : _
                                    p$ = MID$(K$,kzz + 1)
      CASE 23
           IF K0 THEN UserSL = UserSL + K& : _
                      User.SecLevel = Levels(UserSL).SecLevel
           IF K1 THEN UserSL = UserSL - K& : _
                      User.SecLevel = Levels(UserSL).SecLevel
      CASE 26
           IF K0 AND User.Uplds < 32767 THEN User.Uplds = User.Uplds + K& : _
                                             SumLog.Uplds = SumLog.Uplds + K&
           IF K1 THEN User.Uplds = User.Uplds - K& : _
                      SumLog.Uplds = SumLog.Uplds - K&
      CASE 27
           IF K0 AND User.Dnlds < 32767 THEN User.Dnlds = User.Dnlds + K& : _
                                             SumLog.Dnlds = SumLog.Dnlds + K&
           IF K1 THEN User.Dnlds = User.Dnlds - K& : _
                      SumLog.Dnlds = SumLog.Dnlds - K&
      CASE 28
           IF K0 THEN User.ULBytes = User.ULBytes + K& : _
                      SumLog.ULBytes = SumLog.ULBytes + K&
           IF K1 THEN User.ULBytes = User.ULBytes - K& : _
                      SumLog.ULBytes = SumLog.ULBytes - K&
      CASE 29
           IF K0 THEN User.DLBytes = User.DLBytes + K& : _
                      SumLog.DLBytes = SumLog.DLBytes + K&
           IF K1 THEN User.DLBytes = User.DLBytes - K& : _
                      SumLog.DLBytes = SumLog.DLBytes - K&
      CASE 30
           IF BitTest(K&,1) THEN CALL BitSet(Settings.Toggles2,3)
           IF BitTest(K&,2) THEN CALL BitSet(Settings.Toggles2,2)
           IF BitTest(K&,3) THEN CALL BitSet(Settings.Toggles1,5)
           IF BitTest(K&,4) THEN CALL BitSet(Settings.Toggles2,8)
      CASE 31
           IF K0 AND K& + User.MinCredits < 32767& _
              THEN User.MinCredits = User.MinCredits + K&
           IF K1 AND K& + User.MinCredits > -32767& _
              THEN User.MinCredits = User.MinCredits - K&
      CASE 32 : ConnectCPS = K&
    END SELECT
  NEXT
  CALL FileCloseR(K4)
  K$ = RTRIM$(Door.Path)
  IF LEN(K$) = 0 THEN K$ = Paths$(2)
  CALL KillFile(K$ + o$(17) + Form4$(2,Settings.Node) + o$(13))
  FOR K = 1 TO WordsCnt(o$(3))
    K0$ = K$ + WordsGet$(o$(3),K,0)
    IF K = 1 THEN CALL KillFile(K0$ + IntToStr$(Settings.Node) + o$(13)) _
             ELSE CALL KillFile(K0$)
  NEXT
  IF kz = 0 THEN EXIT SUB
  IF DriveSpc&(FileNames(11)) < Settings.MinSpace _
     THEN CALL KillFile(FileNames(11))
  IF NoCarrier AND BitTest(Settings.LoggingAmount,16) _
     THEN TT$ = NCR(User.Username) + o$(51) + RTRIM$(Door.Execute) : _
          CALL LogTT
  IF BitTest(User.Attr,6) AND NOT BitTest(Settings.Toggles2,8) _
     AND LEN(RTRIM$(User.UserName)) > 0 _
     THEN Handle(1) = FileOpenW(FileNames(51))
  User.Elapsed = User.Elapsed + kz1
  CALL WhatDoing(0)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This is the Goodbye/logout subroutine.  End of session
        ' handling.
        '
        ' Date last checked for perfection: Sep 14 1992
        '
SUB LogOut

  IF GInUse > 0 OR UGInUse > 0 THEN TT = 10064 : _
                                    CALL SendTT
  CALL HangUp
  CALL KillFile(FileNames(49))
  CALL KillFile(FileNames(12))                     'NODECHAT.INF
  GlobalStuff$(17) = Null$                         'Clear CHAT note.
  GlobalStuff$(8) = STRING$(350,0)                 'Clear command counters.
  BatchToDL$ = Null$                               'Clear DL batch.
  REDIM o$(150)                                    'Extra space for next user.
  REDIM GObjects$(255)
  GlobalStuff$(26) = Null$
  K0$ = NCR$(User.UserName)
  IF LEN(K0$) = 0 THEN kz = 0 _
                  ELSE kz = BiSearch(5,0,User.UserName)
  SELECT CASE kz
    CASE IS > 1
         '
         ' Update the log file.
         '
         IF LEN(RTRIM$(User.CityState)) > 0 _
            THEN TT$ = Short$(136) + NCR$(User.CityState) _
            ELSE TT$ = Null$
         IF BitTest(Settings.LoggingAmount,1) _
            THEN TT$ = IntToDate3$(SumLog.DateOn) + C32$ + K0$ + TT$ + _
                       Short$(137) + RightTime$(IntToTime$(SumLog.TimeOn)) + _
                       Short$(976) + RightTime$(Null$) + Short$(892) + _
                       RTRIM$(SumLog.BaudRate) + C41$ : _
                 CALL LogTT
         '
         ' Update user record.
         '
         User.Connect = Chars$(StrSrch(1,Short$(893),LEFT$(SumLog.BaudRate,2) + Chars$(46)) \ 2 + 49)
         User.HiFilePtr = Settings.HiFilePtr
         User.LastDateOn = SumLog.DateOn
         User.Attempts = C0$
         User.ElapsedMins = User.ElapsedMins + ElapsedTime(IntToTime$(MinTimer),0)
         K = WriteStuff(1)
         K = WriteStuff(4)
         '
         ' Close the Chat Trap or Trap All files if need be.
         '
         IF BitTest(User.Attr,6) OR BitTest(Settings.Toggles2,8) _
            THEN TT$ = C1310$ + Short$(894) + K0$ + Short$(737) + TIME$ + _
                       Short$(895) + C1310$ : _
                 IF DriveSpc&(FileNames(51)) > Settings.MinSpace _
                    THEN CALL FilePutSEnd(Handle(1),TT$)
         IF BitTest(User.Attr,6) AND NOT BitTest(Settings.Toggles2,8) _
            THEN CALL FileCloseW(Handle(1))
         '
         ' Update hourly graph data.
         '
         ' If we've started a new day (caller was first call after midnight)
         ' then shift the hourly info over 24 hours, and clean the slate, else
         ' get the hourly info for the last 24 hours.
         '
         IF Settings.HourlyDate <> SumLog.DateOn _
            THEN Settings.HourlyData = STRING$(24,0) + Settings.HourlyData
         K0 = ElapsedTime(IntToTime$(SumLog.TimeOn),K)  'Calculate call length.
         SumLog.TotalMinsUsed = K0
         K = Val3(IntToTime$(SumLog.TimeOn),1) + 1      'Get starting hour.
         K0 = K0 + AscMid(Settings.HourlyData,K)        'Add to what's there.
         WHILE K0 > 60                                  'Go below 1 hour.
           MID$(Settings.HourlyData,K,1) = Chars$(60)   'Store an hour.
           K0 = K0 - 60                                 'Reduce by 60 minutes.
           K = K + 1                                    'Next storage hour.
           IF K = 25 THEN Settings.HourlyData = STRING$(24,0) + Settings.HourlyData : _
                          K = 1                         'Next day processing.
         WEND
         MID$(Settings.HourlyData,K,1) = Chars$(K0)     'Residual time.
         Settings.HourlyDate = DateToInt(DATE$)
         kz = WriteStuff(3)
         '
         ' Update statistical summary log.
         '
         CALL UpdateSumLog
         IF BitTest(User.Attr,1) _
            THEN KK = FileOpenWDA(FileNames(56)) : _
                 CALL CutOut(KK,Null$,BiSearch(2,KK,User.UserName) * 32& - 31,32&) : _
                 CALL FileCloseW(KK)
    CASE ELSE
         IF BitTest(Settings.LoggingAmount,1) _
            THEN TT$ = Short$(867) + RightTime$(Null$) + Short$(139) + _
                       TIME$ + Short$(896) + Short$(869) + _
                       RTRIM$(SumLog.BaudRate) + Chars$(124) : _
                 CALL LogTT
  END SELECT
  CALL WhatDoing(-1)
  User.UserName = Null$
  User.Language = Null$
  CALL LoadFixedFiles

END SUB
        '
        '* * * *


