' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'
SUB OverLay4
END SUB



        '* * * * * *
        ' This routine will display the 'text' within a file.
        '
        ' It converts all characters that aren't a CR or between
        ' ASCII 31 and ASCII 127 and makes them spaces--then removes
        ' all but one space.  This combination keeps 'true' text files
        ' readable, while also making non-text files readable (such
        ' as archives).  This is not really a 'read text files'
        ' command, as it scrunches up text lines.
        '
        ' Date last checked for perfection: Aug 31 1992
        '
SUB TypeFile

  TT = 97
  CALL SendTT
  SELECT CASE UserSL
    CASE LevelsSize
         TT = 10628
         K1$ = LineEditTT$(49)
         IF K1$ = Null$ THEN EXIT SUB
    CASE ELSE
         TT = 98
         CALL SendTT
         CALL GetFileName(0,K$,K,Null$)
         IF K < 1 THEN EXIT SUB
         K1$ = FileAreaInfo3$(FileIDX.FArea,2) + K$
  END SELECT
  IF NOT FindF2(K1$,FFile) THEN TT = 195 : _
                                CALL SendTT : _
                                EXIT SUB
  K0 = FileType(K1$)
  IF K0 >= 1 AND K0 <= 6 THEN TT = 21 : _
                              CALL SendTT : _
                              EXIT SUB
  TT = 22
  CALL SendTT
  GInUse = -1       'Stop any GIP codes in the file--particularly 'fPATHNAME'.
  UGInUse = -1
  K$ = SPACE$(512)                 '512 only buffer for smooth speed on an XT.
  K0 = FileOpenR(K1$)
  K& = 0
  K0& = FileLof&(K0,1)
  WHILE K& < K0& AND TGot < 0 AND NOT NoCarrier
    IF K& + 512 > K0& THEN K$ = LEFT$(K$,K0& - K&)
    CALL FileGetSLoc(K0,K&,K$)
    K = Crunch(K$)
    K& = K& + 512
    TT$ = Short$(166) + LEFT$(K$,K)
    CALL SendTT
  WEND
  CALL FileCloseR(K0)
  CALL Paused
  GInUse = 0
  UGInUse = 0

END SUB
        '
        '* * * *


        '* * * * * *
        ' This routine will display a text file, one line at a time,
        ' provided the line contains a matching string.
        '
        ' p$   pathname to view
        '
        ' p0$  string to match
        '
        ' Date last checked for perfection: Dec 2 1993
        '
SUB TypeFile2 (p$,p0$)

  TGot = 0
  IF NOT FindF2(p$,FFile) THEN EXIT SUB
  GInUse = -1       'Stop any GIP codes in the file--particularly 'fPATHNAME'.
  UGInUse = -1
  K0 = FileOpenR(p$)
  K1 = (AscNull(p0$) = 45)
  IF K1 THEN p0$ = MID$(p0$,2) : _
             K& = FileLof&(K0,1) _
        ELSE K& = 0
  DO
    IF K1 THEN K$ = FileGetLineR$(K0,K&) _
          ELSE K$ = FileGetLine$(K0,K&)
    IF StrSrch(1,K$,p0$) > 0 THEN TT$ = Short$(166) + K$ + C1310$ : _
                                  CALL SendTT
  LOOP UNTIL TGot > 0 OR K& = -1 OR NoCarrier
  CALL FileCloseR(K0)
  GInUse = 0
  UGInUse = 0

END SUB
        '
        '* * * *


        '* * * * * *
        ' This routine adds an entry to the reviews file.
        '
        ' Date last checked for perfection: Sep 1 1992
        '
SUB AddReview

  IF DriveSpc&(FileNames(15)) < Settings.MinSpace THEN TT = 122 : _
                                                       CALL SendTT : _
                                                       EXIT SUB
  CALL DispTextBlock(0,4,C13$)
  IF TGot > 0 THEN EXIT SUB
  CALL GetFileName(0,K$,K,Null$)
  IF K < 1 OR BitTest(FileIDX.Attr,7) THEN EXIT SUB
  CALL DispCRLF
  K4 = FileOpenR(FileNames(4))
  K = BiSearch(3,0,K$)
  IF K < 1 THEN CALL FileCloseR(K4) : _
                EXIT SUB
  CALL FileGetRec(K4,FileIDX.FRec,119,FileList)
  CALL FileCloseR(K4)
  IF FileList.UserName = User.UserName THEN TT = 196 : _
                                            TGot = GetYNTT _
                                       ELSE TGot = 0
  SELECT CASE TGot
    CASE -1
         K$ = FileList.FDesc
         CALL GetDesc(-3,Null$,Short$(118))
         K4 = FileOpenW(FileNames(4))
         K = BiSearch(3,0,FileList.FName)
         IF K < 1 THEN CALL FileCloseR(K4) : _
                       EXIT SUB
         CALL FilePutRec(K4,FileIDX.FRec,119,FileList)
         CALL FileCloseW(K4)
         CALL GiveCredit(K$,0)
    CASE ELSE
         TT = 194
         CALL SendTT
         K2$ = Null$
         CALL GetMessageText(0,K2$)
         IF StripLen(K2$) < 5 THEN EXIT SUB
         CALL CRsToSpaces(K2$)
         K1$ = Null$
         K2 = 1
         K3 = 0
         DO
           CALL FindMsgLine(K2,Settings.ReviewLen,5,K0$,K0,K1,K2$)
           IF K2 = 1 THEN K3$ = FileIDX.FName _
                     ELSE K3$ = SPACE$(12)
           CALL IntMax(K3,LEN(RTRIM$(K0$)))
           IF LEN(K0$) > 0 AND K0 > 0 _
              THEN K1$ = K1$ + Chars$(51) + K3$ + K0$ + C1310$
           K2 = K2 + 1
         LOOP UNTIL K0 = -1
         K$ = Short$(467) + NCR$(User.UserName)
         IF FileList.UserName = User.UserName THEN K$ = K$ + Short$(647)
         IF Levels(UserSL).ShowLevel = Levels(1).ShowLevel _
            THEN K$ = K$ + Short$(651) + IntToStr$(Levels(UserSL).ShowLevel) + C41$
         K = K3 - LEN(K$)
         K0 = K - LEN(K0$)
         IF K0 > 0 THEN K0$ = K0$ + SPACE$(K0) + K$ _
                   ELSE IF LEN(K$) + LEN(K0$) < Settings.ReviewLen _
                           THEN K0$ = K0$ + K$ _
                           ELSE K1$ = K1$ + Chars$(51) + K3$ + K0$ + C1310$ : _
                                K3$ = SPACE$(12) : _
                                IF K > 0 THEN K0$ = SPACE$(K) + K$ _
                                         ELSE K0$ = K$
         K3$ = K1$ + Chars$(51) + K3$ + K0$
         CALL SharedWriteEOF(15,FileList.FArea,Null$,K3$)
  END SELECT
  TT = 4
  CALL SendTT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will alter a user's High File Pointer to that
        ' of a previous day.
        '
        ' Date last checked for perfection: Feb 20 1993
        '
SUB AlterFilePtr

  TT = 7
  K = GetDate
  IF K = 0 THEN EXIT SUB
  TT = 71
  CALL SendTT
  K$ = RIGHT$(K$,2) + IntToDate2$(K)
  K = FileOpenR(FileNames(4))
  K& = FileLof&(K,1) - 6
  K0& = User.HiFilePtr
  WHILE K& > 0
    CALL FileGetLoc(K,K&,2,K0)
    K0$ = IntToDate2$(K0)
    K0$ = RIGHT$(K0$,2) + K0$
    CALL FileGetLoc(K,K& - 111,4,K1&)
    IF (K1& < K0& AND K0$ >= K$) OR (K1& > K0& AND K0$ < K$) THEN K0& = K1& - 1
    K& = K& - 119
  WEND
  CALL FileCloseR(K)
  TT = 6
  CALL SendTT
  IF K0& < 0 THEN K0& = 0
  User.HiFilePtr = K0&

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will display a list of new messages (that the
        ' user hasn't read, and a list of new files (since the user's
        ' last logon).
        '
        ' Date last checked for perfection: Sep 15 1992
        '
SUB NewStuff

  CALL BlockToO(0,21)
  TT = 20001
  CALL SendTT
  K = 0
  K0 = 0
  FOR K7 = 0 TO BasesSize
    IF TGot > 0 THEN EXIT FOR
    K1 = (BitTest(MsgAreaI(K7 + 1).SubType,2) OR NOT MAccessAllowed(K7))
    SELECT CASE K1
      CASE 0
           K& = LongMid(UserMsgInfo$,K7 * 4 + 1)
           K6 = FileOpenR(Form4$(10,K7 + 1))
           k99 = FileOpenR(FileNames(2))
           K2 = FileLof&(K6,12)
           K5 = K2         'K5 = the number of messages that are not new.
           SELECT CASE K5
             CASE IS > 0
                  DO
                    CALL FileGetRec(K6,K5,12,MsgIDX)
                    IF K& >= MsgIDX.MsgNum THEN EXIT DO
                    K5 = K5 - 1
                  LOOP UNTIL K5 = 0
           END SELECT
           K1 = K5 + 1     'K1 = the first message new to user.
           K3 = K2
           SELECT CASE K3
             CASE IS >= K1
                  DO
                    IF K0 = 0 THEN K0 = -1 : _
                                   TT = 20016 : _
                                   CALL SendTT : _
                                   IF TGot > 0 THEN EXIT DO
                    CALL FileGetRec(K6,K3,12,MsgIDX)
                    CALL FileGetLoc(k99,MsgIDX.MsgLoc,136,Message)
                    IF Message.MsgTo = o$(3) _
                       THEN TT$ = o$(4) _
                       ELSE TT$ = Form$(2305,Message.MsgTo)
                    K$ = UnSq$(RTRIM$(Message.MsgSubject))
                    K = -1
                    TT$ = o$(5) + Form$(601,STR$(Message.MsgNum)) + o$(6) + _
                          Form$(2305,Message.MsgFrom) + o$(7) + TT$ + o$(8) + _
                          LEFT$(K$,25) + C1310$
                    CALL SendTT
                    IF TGot > 0 THEN EXIT DO
                    K3 = K3 - 1
                  LOOP UNTIL K3 < K1
           END SELECT
           CALL FileCloseR(k99)
           CALL FileCloseR(K6)
    END SELECT
  NEXT
  IF TGot > 0 THEN EXIT SUB
  TT = 20010 + (K = 0)
  CALL SendTT
  IF TGot > 0 THEN EXIT SUB
  K = 0
  K3 = FileOpenR(FileNames(4))
  K4 = FileLof&(K3,119)
  K9 = K4
  SELECT CASE K9
    CASE IS > 0
         DO
           CALL FileGetLoc(K3,K9 * 119& - 117,4,K&)
           SELECT CASE K&
             CASE IS > User.HiFilePtr
                  CALL FileGetRec(K3,K9,119,FileList)
                  K2 = FAccessAllowed(FileList.FArea)
                  IF BitTest(FileList.Attr,6) THEN K2 = 0       'Invisible.
                  IF BitTest(FileList.Attr,7) THEN K2 = 0       'Incomplete.
                  IF BitTest(FileList.Attr,1) THEN K2 = 0       'Deleted.
                  SELECT CASE K2
                    CASE -1
                         IF User.HighestPtr < K& _
                            THEN User.HighestPtr = FileList.HiFilePtr
                         TT$ = o$(11) + FileList.FName + o$(12) + _
                               Form$(1166,STR$(FileList.FSize)) + o$(13) + _
                               RTRIM$(FileList.FDesc) + C1310$
                         CALL SendTT
                         IF TGot > 0 THEN EXIT DO
                         K = -1
                  END SELECT
           END SELECT
           K9 = K9 - 1
         LOOP UNTIL K9 = 0
  END SELECT
  CALL FileCloseR(K3)
  IF TGot > 0 THEN EXIT SUB
  TT = 20015 + (K = 0)
  CALL SendTT
  IF TGot > 0 THEN EXIT SUB
  K = 0
  K0 = FileOpenR(FileNames(14))
  K& = FileLof&(K0,1)
  DO
    TT$ = FileGetLineR$(K0,K&)
    IF Val2&(LEFT$(TT$,10)) <= User.HiFilePtr THEN TT$ = NULL$ : _
                                                   K& = -1
    IF LEN(TT$) > 0 THEN K = -1 : _
                         TT$ = o$(2) + MID$(TT$,11) + C1310$ : _
                         CALL SendTT
  LOOP UNTIL K& = -1 OR TGot > 0
  CALL FileCloseR(K0)
  IF TGot < 1 AND K = 0 THEN TT = 20017 : _
                             CALL SendTT
  CALL Paused

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will alter the Life & Death Count of a file.
        '
        ' Each user above a specified security level can alter the L&D
        ' Count of one file each day.
        '
        ' Users cannot modify files for which they uploaded.  They may
        ' try to keep it up by increasing the L&D count.  They also
        ' may upload bad stuff knowing that they can help speed it's
        ' removal.
        '
        ' A user may only delete a file when all of the below are
        ' true:
        '   They have high enough SL.
        '   There is less than a defined number of bytes on the drive.
        '   It's toggled on.
        '   The L&D count is currently at zero.
        '
        ' A user may not increase the count if it is 9, +9, or blank.
        ' Since this is like stopping daily auto-reduction.
        '
        ' Date last checked for perfection: Sep 3 1992
        '
SUB LifeDeath

  CALL BlockToO(0,22)
  IF SumLog.DateOn = User.AlterDate THEN TT = 20001 : _
                                         CALL SendTT : _
                                         EXIT SUB
  TT = 20002
  CALL SendTT
  CALL GetFileName(0,K$,K0,Null$)
  IF K0 < 1 THEN EXIT SUB
  K2 = FileOpenR(FileNames(4))
  K0 = BiSearch(3,0,K$)
  IF K0 < 1 THEN CALL FileCloseR(K2) : _
                 EXIT SUB
  CALL FileGetRec(K2,FileIDX.FRec,119,FileList)
  CALL FileCloseR(K2)
  IF FileList.UserName = User.UserName THEN TT = 20003 : _
                                            CALL SendTT : _
                                            EXIT SUB
  SELECT CASE FileList.LDCount
    CASE 10       : TT$ = o$(4)
    CASE IS < 10  : TT$ = STR$(FileList.LDCount * 2 + 2) + o$(5)
    CASE 11 TO 28 : TT$ = STR$(FileList.LDCount * 3 - 11) + o$(6)
  END SELECT
  TT$ = o$(7) + LTRIM$(TT$) + o$(29)
  CALL SendTT
  CALL TGet2(o$(9) + C13$)
  K1 = FileList.LDCount
  SELECT CASE TGot
    CASE 1
         TT = 20010
         CALL SendTT
         SELECT CASE FileList.LDCount
           CASE 0 TO 8, 11 TO 27 : FileList.LDCount = FileList.LDCount + 1
           CASE 9, 10, 28 : TT = 20011
                            CALL SendTT
         END SELECT
    CASE 2
         TT = 20012
         CALL SendTT
         SELECT CASE FileList.LDCount 
           CASE 1 TO 9, 12 TO 28 : FileList.LDCount = FileList.LDCount - 1
           CASE 10 : IF FileList.FArea = 1 THEN FileList.LDCount = 9 _
                                           ELSE FileList.LDCount = 28
           CASE 11 : FileList.LDCount = 9
           CASE 0
                K = -1
                IF NOT BitTest(Settings.Toggles1,1) THEN TT = 20013 : _
                                                         CALL SendTT : _
                                                         K = 0
                IF DriveSpc&(FileAreaInfo3$(1,2)) >= Settings.LDDelSpace _
                   THEN TT$ = o$(14) + Commas$(Settings.LDDelSpace) + o$(15) : _
                        CALL SendTT : _
                        K = 0
                IF Levels(UserSL).SecLevel < Settings.LDDelSL _
                   THEN TT$ = o$(16) + STR$(Settings.LDDelSL) + o$(17) : _
                        CALL SendTT : _
                        K = 0
                IF FileList.FArea > 1 THEN TT = 20018 : _
                                           CALL SendTT : _
                                           K = 0
                IF K THEN TT$ = o$(19) + RTRIM$(FileList.FName) + o$(20) : _
                          IF GetYNTT THEN CALL RemoveFile(FileList.FName) : _
                                          TT = 20021 : _
                                          User.AlterDate = SumLog.DateOn _
                                     ELSE K = 0
                IF NOT K THEN TT = 20022
                CALL SendTT
                EXIT SUB
         END SELECT
    CASE ELSE
         TT = 20023
         CALL SendTT
         EXIT SUB
  END SELECT
  SELECT CASE K1
    CASE 0        : TT$ = o$(24)
    CASE 1 TO 9   : TT$ = STR$(K1 * 2 + 2) + o$(25) + Chars$(K1 + 48)
    CASE 10       : TT$ = o$(26)
    CASE 11 to 19 : TT$ = STR$(K1 * 3 - 11) + o$(27) + Chars$(68 - K1)
    CASE 20 TO 28 : TT$ = STR$(K1 * 3 - 11) + o$(28) + Chars$(K1 + 29)
  END SELECT
  IF FileList.LDCount <> K1 THEN User.AlterDate = SumLog.DateOn
  SELECT CASE FileList.LDCount
    CASE 10       : K$ = o$(4)
    CASE IS < 10  : K$ = STR$(FileList.LDCount * 2 + 2) + o$(5)
    CASE 11 TO 28 : K$ = STR$(FileList.LDCount * 3 - 11) + o$(6)
  END SELECT
  TT$ = o$(32) + LTRIM$(TT$) + o$(31) + LTRIM$(K$) + o$(8)
  CALL SendTT
  K2 = FileOpenW(FileNames(4))
  K0 = BiSearch(3,0,FileList.FName)
  IF K0 > 0 THEN CALL FilePutRec(K2,FileIDX.FRec,119,FileList)
  CALL FileCloseW(K2)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will display a text file in a variety of
        ' formats.
        '
        ' p   Type of display to do.
        '
        ' p0  returns with -1 if [Enter] was it while displaying.
        '     (and then should ignore any PAUS or ENTR after it)
        '
        ' p$  Pathname of file to display.
        '
        ' Date last checked for perfection: Sep 15 1992
        '
SUB MNxDisplays (p,p0,p$)

  IF FindF(p$,FFile) = 0 THEN p0 = -1 : _
                              EXIT SUB
  CALL BlockToO(0,23)
  K4 = FileOpenR(p$)
  SELECT CASE p
    CASE 1    'MNb
         K& = 0
         TT$ = FileGetLine$(K4,K&)
         K2 = 78 - LEN(TT$)
         K3 = K2 \ 2
         IF K3 + K3 <> K2 THEN K2 = K3 + 1 _
                          ELSE K2 = K3
         TT$ = o$(1) + SPACE$(K3) + o$(2) + TT$ + o$(3) + SPACE$(K2) + o$(4)
         CALL SendTT
         DO
           TT$ = o$(6) + FileGetLine$(K4,K&)
           IF LEN(TT$) > 77 THEN TT$ = Form$(8401,TT$) _
                            ELSE TT$ = Form1$(80,TT$)
           TT$ = TT$ + o$(5)
           CALL SendTT
         LOOP UNTIL K& = -1 OR TGot > 0
         IF TGot < 1 THEN TT = 20007 : _
                          CALL SendTT _
                     ELSE p0 = -1
    CASE 2, 3   'MNj MNh
         TT = 20011 + (p = 2)
         CALL SendTT
         K& = 0
         DO
           TT$ = o$(12) + FileGetLine$(K4,K&) + C1310$
           CALL SendTT
         LOOP UNTIL K& = -1 OR TGot > 0
         IF TGot > 0 THEN p0 = -1
    CASE 4   'MNl
         TT$ = o$(13) + FFile.FDate + o$(14)
         CALL SendTT
         K& = 0
         DO
           TT$ = o$(15) + FileGetLine$(K4,K&) + C1310$
           CALL SendTT
         LOOP UNTIL K& = -1 OR TGot > 0
         IF TGot > 0 THEN p0 = -1
    CASE 5   'MNp
         K& = 0
         K1 = 0
         DO
           K1 = K1 + 1
           TT$ = FileGetLine$(K4,K&)
         LOOP UNTIL K& = -1
         K& = 0
         K$ = FileGetLine$(K4,K&)
         FOR K = 1 to K1 \ 19
           K2 = 78 - LEN(K$) - 7
           IF K1 \ 19 > 9 THEN K2 = K2 - 1
           IF K > 9 THEN K2 = K2 - 1
           K3 = K2 \ 2
           IF K3 + K3 <> K2 THEN K2 = K3 + 1 _
                            ELSE K2 = K3
           TT$ = o$(16) + SPACE$(K3) + o$(17) + K$ + o$(18) + IntToStr$(K) + _
                 o$(19) + IntToStr$(K1 \ 19) + o$(8) + SPACE$(K2) + o$(4)
           CALL SendTT
           FOR K0 = 1 to 19
             TT$ = o$(9) + FileGetLine$(K4,K&)
             IF LEN(TT$) > 77 THEN TT$ = Form$(8201,TT$) _
                              ELSE TT$ = Form1$(80,TT$)
             TT$ = TT$ + o$(5)
             IF TGot < 1 THEN CALL SendTT
           NEXT
         IF NoCarrier THEN EXIT FOR
         IF TGot < 1 THEN TT = 20007 : _
                          CALL SendTT
         CALL Paused
       NEXT
       p0 = -1
  END SELECT
  CALL FileCloseR(K4)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine adds to the requests file.
        '
        ' There are 3 groupings displayed: requests, unprotects, and SL
        ' based targetted requests.  But the user only sees two
        ' levels, simple requests, and SL based targetted requests.
        '
        ' Date last checked for perfection: Sep 1 1992
        '
SUB AddRequest

  CALL BlockToO(0,24)
  IF DriveSpc&(FileNames(14)) < Settings.MinSpace THEN TT = 20016 : _
                                                  CALL SendTT : _
                                                  EXIT SUB
  CALL DispTextBlock(0,3,C13$)
  IF TGot < 0 THEN CALL TGet(o$(2) + C13$)
  K1$ = Null$
  SELECT CASE TGot
    CASE 49
         TT = 20003
         K1$ = LineEditTT$(38)
         TT = 20004
    CASE 50
         TT = 20005
         CALL SendTT
         IF Levels(UserSL).SecLevel < Settings.SLEachOther _
            THEN TT$ = o$(6) + STR$(Settings.SLEachOther) + o$(7) _
            ELSE TT$ = o$(8) + IntToStr$(LEN(o$(9)) - 1) + o$(10) + o$(9) + _
                       o$(11) : _
                 K1$ = LCASE$(LineEditTT$(12)) : _
                 IF LEN(K1$) > 0 _
                    THEN K0$ = o$(12) + NCR$(User.UserName) + o$(13) : _
                         TT$ = o$(14) + K0$ + o$(4) : _
                         K1$ = o$(9) + K1$ + K0$ _
                    ELSE TT = 20004
    CASE ELSE : TT = 20001
  END SELECT
  CALL SendTT
  IF LEN(K1$) = 0 THEN EXIT SUB
  CALL IncreaseHiFilePtr
  CALL SharedWriteEOF(14,0,Null$,Form$(1002,STR$(Settings.HiFilePtr)) + K1$)
  TT = 20015
  CALL SendTT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will display the to-get-higher-access screens.
        '
        ' The filenames must have the name: filename.xxx where xxx is
        ' the Security Level (from SETUP.INI) that was given
        ' them--not the value, since values range from -32,767 to
        ' +32,767.  Example, level 1 = 5 (actually -32,767 to +5),
        ' level 2 = 10 (6 - 10), level 3 = 20 (11 - 20), etc.
        ' Filename.001, Filename.01, and Filename.1 will all be
        ' considered Level 1--but Filename.010 and Filename.100 are
        ' not (they are 10 and 100, respectively).
        '
        ' If a level doesn't have an access screen, then the highest
        ' available one is used (at a level lower than theirs)--thus
        ' if SL 95 doesn't have an access screen, but SL 90 does, then
        ' SL 90's screen will be displayed (eg. filename.004).
        '
        ' For multiple access screens for a single level, they should
        ' have filenames such that, when sorted, they appear in the
        ' order you want them displayed.
        '
        ' Date last checked for perfection: Sep 2 1992 
        '
SUB Apply

  K0 = 1
  IF FindF(RTRIM$(FileNames(42)) + Short$(645),FWork(K0)) = 0 THEN EXIT SUB
  DO : K0 = K0 + 1
  LOOP UNTIL FindF(Null$,FWork(K0)) = 0
  CALL FWorkSort(K0 - 1)
  K1 = 0
  K2 = UserSL
  DO
    FOR K = 1 TO K0 - 1
      K3 = 0
      SELECT CASE BitTest(User.Attr,10)
        CASE 0
             IF StrSrch1(FWork(K).FName,46) > 0 AND Val2&(FWork(K).FName) = K2 _
                THEN K3 = 1
        CASE ELSE
             IF RIGHT$(RTRIM$(FWork(K).FName),4) = Short$(838) THEN K3 = 1
      END SELECT
      IF K3 = 1 _
         THEN CALL DispFile(LEFT$(FileNames(42),StrSrchR(FileNames(42),92)) + FWork(K).FName,C13$) : _
              CALL Paused : _
              K1 = -1
    NEXT
    IF NOT K1 THEN K2 = K2 - 1
  LOOP UNTIL K1 OR (K2 = 0)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will download the latest JDR_mmyy.  All
        ' download directories are searched when looking for the
        ' file.
        '
        ' p$  is the filename to download.
        '
        ' Date last checked for perfection: Sep 3 1992 
        '
SUB DoAFreeDownload (p$)

  IF NOT FindF2(p$,FFile) THEN EXIT SUB
  CALL BuildFnamesCtl(p$)
  CALL AdjustProtocol(User.Protocol)
  K0$ = MID$(TT$,54,40)
  TT$ = Short$(113) + RTRIM$(Form$(7908,MID$(TT$,20,34))) + Lines$(18)
  CALL SendTT
  CALL SysopLine(9)
  TT$ = Null$
  CALL ShellDosTT(3)
  CALL Delay
  CALL PurgeComIO(CommPort)
  CALL FileAppendToLog(K0$)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will exchange minutes for megabytes and
        ' vice-versa.
        '
        ' Date last checked for perfection: Sep 2 1992 
        '
SUB Exchange

  CALL BlockToO(0,25)
  TT$ = o$(1) + Form$(32,STR$(User.MinCredits)) + o$(2) + Commas$(CanDL&) + _
        o$(3)
  IF User.MinMegs > 0 _
     THEN TT$ = TT$ + Commas$(User.MinMegs * Settings.ExchBytes) + o$(4) _
     ELSE IF User.MinMegs < 0 _
             THEN TT$ = TT$ + STR$(User.MinMegs * - Settings.ExchMins) + o$(5)
  TT$ = TT$ + o$(6) + Commas$(Settings.ExchBytes) + o$(7) + _
        STR$(Settings.ExchMins) + o$(8) + STR$(Settings.ExchMins) + _
        o$(9) + Commas$(Settings.ExchBytes) + o$(10)
  CALL SendTT
  IF CanDL& < Settings.ExchBytes _
     THEN TT = 20011 : _
          CALL SendTT _
     ELSE TT = 20012 : _
          IF GetYNTT THEN User.MinMegs = User.MinMegs + 1 : _
                          User.MinCredits = User.MinCredits + Settings.ExchMins : _
                          TT = 20013 : _
                          CALL SendTT : _
                          EXIT SUB
  IF User.MinCredits < Settings.ExchMins _
     THEN TT = 20014 : _
          CALL SendTT : _
          CALL Paused _
     ELSE TT = 20015 : _
          IF GetYNTT THEN User.MinMegs = User.MinMegs - 1 : _
                          User.MinCredits = User.MinCredits - Settings.ExchMins : _
                          TT = 20013 : _
                          CALL SendTT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine gets the users protocol choice from the
        ' available protocols.
        '
        ' Date last checked for perfection: Sep 3 1992
        '
SUB GetProtocol

  TT = 10107
  CALL SendTT
  K1 = FileOpenR(FileNames(69))
  K$ = SPACE$(53)
  K& = -211
  K0$ = Null$
  K1$ = Null$
  K = FileLof&(K1,211) - 1
  FOR K0 = 0 TO K
    K& = K& + 211
    CALL FileGetSLoc(K1,K&,K$)
    IF Levels(UserSL).SecLevel >= IntMid(K$,2) _
       AND Levels(UserSL).SecLevel <= IntMid(K$,4) _
       AND ASC(K$) <> 66 AND ASC(K$) <> 72 _
       THEN K0$ = K0$ + RTRIM$(RIGHT$(K$,34)) + C0$ : _
            K1$ = K1$ + LEFT$(K$,1)
  NEXT
  CALL FileCloseR(K1)
  TT = 91
  CALL MenuSystem(K0$,0)
  IF TGot > 0 THEN User.Protocol = MID$(K1$,TGot,1)

END SUB
        '
        '* * * *


