' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.


' This file contains the routines to work with archives:
'   Archiver
'   ArchiveFileInfo
'   ViewContents
'   ExtractFiles


        '* * * * * *
        ' This routine will analyze the protocol's log file after file
        ' transfers.
        '
        ' p     1 for uploads only
        '       0 for downloads only
        '      -1 for both uploads and downloads
        '      The purpose for this is to decide where to deduct
        '      the minutes used.
        '
        ' p$   for uploads: a description if entered
        '      for downloads: returns 1 if at least one file was
        '                     sent (for auto-logoff)
        '
        ' p00$ User name (for Target)
        '
        ' p0$  transfer session's start time
        '
        ' p1$  protocol used.
        '
        ' p0   0 to display the heading, -1 to not (should only be used
        '      when know they will only be downloading).
        '
        ' Date last checked for perfection: Sep 10 1992
        '
SUB ProcessLog (p,p$,p00$,p0$,p1$,p0)

  k66 = 0
  IF BitTest(User.Toggles,1) THEN CALL CommOut(C7$ + C7$)
  K1 = ElapsedTime(p0$,K2)
  SELECT CASE p
    CASE -1, 1
         User.MinsULing = User.MinsULing + K1
         SumLog.MinsULing = SumLog.MinsULing + K1
         IF DriveSpc&(FileNames(11)) < Settings.MinSpace _
            THEN CALL KillFile(FileNames(11))
         '
         ' Clear the input buffer after doing uploads.  Purge and delay until we
         ' stop receiving characters.
         '
         FOR K2 = 1 to 10
           CALL Delay
           IF CommIn(0) >= 0 THEN CALL PurgeComIO(CommPort) _
                             ELSE EXIT FOR
         NEXT
         IF K2 = 11 THEN CALL HangUp
  END SELECT
  IF p < 1 THEN User.MinsDLing = User.MinsDLing + K1 : _
                SumLog.MinsDLing = SumLog.MinsDLing + K1
  CALL AdjustProtocol(p1$)
  IF NOT FindF2(MID$(TT$,54,40),FFile) THEN EXIT SUB
  K8 = FileIndex
  K5$ = TT$
  IF p <> 0 THEN CALL KillFile(FileNames(49))
  K4 = FileOpenR(MID$(K5$,54,40))           'Protocol log, usually DSZLOG
  K5 = FileOpenW(FileNames(4))              'FILELIST.
  K0& = 0
  IF LEN(p$) > 3 THEN K3$ = p$ _
                 ELSE K3$ = Null$
  K77 = p0
  DO
    IF K77 = 0 THEN TT = 10107 : _
                    CALL SendTT : _
                    K77 = -1
    K4$ = FileGetLine$(K4,K0&)
    K6 = 0       'assume a neutral successful upload state.
    K7 = 0       'assume a neutral successful download state.
    K2$ = WordsGet$(K4$,IntMid(K5$,14),0)
    IF StrSrch(1,RTRIM$(MID$(K5$,11,3)),K2$) > 0 _
       OR StrSrch(1,K2$,RTRIM$(MID$(K5$,11,3))) > 0 _
       THEN K7 = -1
    IF StrSrch(1,RTRIM$(MID$(K5$,7,3)),K2$) > 0 _
       OR StrSrch(1,K2$,RTRIM$(MID$(K5$,7,3))) > 0 _
       THEN K6 = -1
    IF K2$ = MID$(K5$,10,1) THEN K7 = 1
    IF K2$ = MID$(K5$,6,1) THEN K6 = 1
    TT$ = K4$
    K4$ = UCASE$(WordsGet$(K4$,IntMid(K5$,16),0))
    K2 = StrSrchR(K4$,92)
    IF K2 = 0 THEN K2 = StrSrchR(K4$,47)
    IF K2 > 0 THEN K4$ = MID$(K4$,K2 + 1)
    IF LEN(K4$) = 0 THEN K4$ = Short$(902) : _
                         K9 = 0 _
                    ELSE K9 = BiSearch(3,0,FORM$(1201,K4$))
    IF K9 > 0 THEN FileIndex = FileIDX.FArea _
              ELSE FileIndex = K8
    IF BitTest(Settings.LoggingAmount,11) _
       THEN CALL LogTT              'Do logging here because we want FileIndex.
    '
    ' K6 could be -1 wrongly: when the file is on-line, the user fails to DL
    ' it, and the fail DL string is in the fail UL string ('E').  Fixed by
    ' checking: 1. file on-line, 2. file not incomplete.
    '
    IF K6 = -1 AND K9 > 0 _
       THEN IF NOT BitTest(FileIDX.Attr,7) THEN K6 = 0 : _
                                                K7 = -1
    SELECT CASE K7
      CASE -1
           User.BadDLs = User.BadDLs - (User.BadDLs < 32767)
           SumLog.BadDLs = SumLog.BadDLs + 1
      CASE 1
           SELECT CASE K9
             CASE IS > 0
                  CALL FileGetRec(K5,FileIDX.FRec,119,FileList)
                  IF FileList.UserName <> User.UserName _
                     THEN FileList.Downloaded = FileList.Downloaded + 1
                  FileList.LastDLed = SumLog.DateOn
                  IF Settings.AutoValAfDLx > 0 AND BitTest(FileList.Attr,3) _
                     AND FileList.Downloaded >= Settings.AutoValAfDLx _
                     THEN CALL GiveCredit(Null$,3) : _
                          CALL BitClear(FileList.Attr,3)
                  CALL FilePutRec(K5,FileIDX.FRec,119,FileList)
                  p$ = Chars$(49)
                  SumLog.DLBytes = SumLog.DLBytes + FileList.FSize
                  SumLog.Dnlds = SumLog.Dnlds + 1
                  IF NOT (BitTest(FileList.Attr,2) _
                     OR (BitTest(FileList.Attr,9) AND ConnectCPS >= 800)) _
                     THEN kk = -1 _
                     ELSE kk = 0
                  SELECT CASE kk
                    CASE -1
                         User.Dnlds = User.Dnlds - (User.Dnlds < 32767)
                         kk = Settings.FPWorthInBytes
                         SELECT CASE kk
                           CASE 0 : kk& = FileList.FSize
                           CASE ELSE
                                IF FileList.LDCount > 99 _
                                   THEN kk& = (FileList.LDCount - 100) * kk _
                                   ELSE kk& = (FileList.FSize \ kk) * kk
                         END SELECT
                         User.DLBytes = User.DLBytes + kk&
                    CASE ELSE
                         K1 = K1 - FileList.FSize \ (ConnectCPS * 57&)
                         IF K1 < 0 THEN K1 = 0
                  END SELECT
                  '
                  ' Don't do if:
                  '   file isn't yet validated.
                  '   uploader is the downloader
                  '   uploader is the sysop
                  '   we passed 'don't do after x times'
                  '   we passed 'don't do after x days'
                  '   we haven't reached 'do after x days'
                  '   the file specifically says to not do
                  '   the bytes % is 0 and the minutes % is 0
                  '
                  kx = -1
                  IF BitTest(FileList.Attr,3) THEN kx = 0
                  IF FileList.UserName = User.UserName _
                     OR FileList.UserName = Settings.Sysop _
                     THEN kx = 0
                  IF Settings.CreditAfDLxLim > 0 _
                     AND FileList.Downloaded >= Settings.CreditAfDLxLim _
                     THEN kx = 0
                  IF Settings.CreditAfDLdLim > 0 _
                     THEN IF DaysSince&(FileList.DateULed) > Settings.CreditAfDLdLim _
                             THEN kx = 0
                  IF Settings.CreditAfDLx > 0 _
                     THEN IF DaysSince&(FileList.DateULed) <= Settings.CreditAfDLx _
                             THEN kx = 0
                  IF BitTest(FileList.Attr,8) THEN kx = 0
                  IF Settings.GivePctgBEaDL < 1 THEN kx = 0
                  SELECT CASE kx
                    CASE -1
                         kx& = FileList.FSize \ 100
                         ky = -100
                         IF ReadStuff(2,FileList.UserName) _
                            THEN AnyUser.ULBytes = AnyUser.ULBytes + kx& * Settings.GivePctgBEaDL : _
                                 IF NOT BitTest(AnyUser.Attr,11) THEN Ky = WriteStuff(2)
                  END SELECT
                  IF Settings.GivePctgMEaDL < 1 THEN kx = 0
                  SELECT CASE kx
                    CASE -1
                         kx = FileList.FSize \ 13680&
                         kx = (kx * Settings.GivePctgMEaDL) \ 100
                         IF ReadStuff(2,FileList.UserName) _
                            THEN AnyUser.MinCredits = AnyUser.MinCredits + kx : _
                                 IF NOT BitTest(AnyUser.Attr,11) THEN Ky = WriteStuff(2)
                  END SELECT
           END SELECT
    END SELECT
    CALL FileAreaInfo(FileIndex)
    K2$ = RTRIM$(FileArea.Path) + K4$
    K2 = 0
    IF K6 <> 0 THEN K2 = FindF(K2$,FFile) : _
                    IF K6 = 1 AND K2 = 0 THEN K6 = -1
    SELECT CASE K6
      CASE -1
           User.BadULs = User.BadULs - (User.BadULs < 32767)
           SumLog.BadULs = SumLog.BadULs + 1
           IF K2 <> 0 AND K9 = 0 _ 
              THEN CALL CreateFileStuff(3,64,0,K5,0) : _
                   CALL FilePutRec(K5,FileLof&(K5,119) + 1,119,FileList) : _
                   CALL UpdateHiFilePtr(FileIndex,FileList.HiFilePtr)
      CASE 1
           k77 = 0
           CALL SharedWriteEOF(49,0,Null$,RTRIM$(K2$))      'FNAMES.CTL
           IF LEN(p00$) > 0 _
              THEN K2$ = Short$(123) + IntTodate3$(SumLog.DateOn) + _
                         Short$(904) + NCR$(User.Username) + Short$(124) + _
                         RTRIM$(FFile.FName) + Short$(125) : _
                   Message.MsgTo = p00$ : _
                   CALL AddAMessage(2,K2$,0,0)
           IF K9 > 0 THEN IF NOT BitTest(FileIDX.Attr,7) THEN K9 = -1
           SELECT CASE K9
             CASE -1
                  '
                  ' File was already on-line, a duplicate upload.
                  '
                  TT$ = Short$(905) + Form$(1502,K4$) + Lines$(61)
                  CALL SendTT
             CASE ELSE
                  '
                  ' IF K9 = 0 then file is new, else it's a former <incomplete>.
                  '
                  IF K9 = 0 _
                     THEN CALL CreateFileStuff(1,0,9,0,0) : _
                          CALL UpdateHiFilePtr(FileIndex,FileList.HiFilePtr) _
                     ELSE CALL FileGetRec(K5,FileIDX.FRec,119,FileList) : _
                          CALL BitClear(FileList.Attr,7) : _
                          FileList.FSize = FFile.FSize
                  FileList.FDesc = K3$
                  CALL GetDesc(1,Short$(121),Form$(1502,K4$))
                  IF K4$ = UCASE$(RTRIM$(FileList.FDesc)) _
                     THEN FileList.FDesc = Null$
                  IF LEN(p00$) > 0 _
                     THEN FileList.LDCount = 2 _
                     ELSE FileList.Percentage = IntMid(K5$,18) : _
                          CALL GiveCredit(Null$,1)
                  SumLog.Uplds = SumLog.Uplds + 1
                  SumLog.ULBytes = SumLog.ULBytes + FFile.FSize
                  CALL DispCRLF
                  IF (ASC(FileList.FDesc) = 92 _
                      OR ASC(FileList.FDesc) = 47) _
                     AND User.SecLevel >= Settings.SysopOnlyUL _
                     THEN CALL BitSet(FileList.Attr,6) : _
                          TT = 62 : _
                          CALL SendTT
                  SELECT CASE K9
                    CASE 0
                         CALL CreateFileStuff(2,FileList.Attr,0,K5,0)
                         CALL FilePutRec(K5,FileLof&(K5,119) + 1,119,FileList)
                    CASE ELSE
                         CALL FilePutRec(K5,FileIDX.FRec,119,FileList)
                         FileIDX.Attr = FileList.Attr
                         FileIDX.FSize = FileList.FSize
                         KK = FileOpenW(FileNames(59))
                         CALL FilePutRec(KK,K9,22,FileIDX)
                         CALL FileCloseW(KK)
                  END SELECT
                  CALL SharedWriteEOF(8,-1,Null$,LEFT$(ExpandFileName$(K4$),9))  'FNAMES.DAT
           END SELECT
    END SELECT
    IF K6 = 1 THEN CALL Paused : _
                   K66 = K66 + 1
  LOOP UNTIL K0& = -1
  CALL FileCloseR(K4)
  CALL FileCloseW(K5)
  CALL KillFile(MID$(K5$,54,40))
  IF K66 > 0 _
     THEN CALL Wipe(StripLen(Lines$(3))) : _
          TT = 147 : _
          CALL SendTT : _
          K2 = WriteStuff(3)
  IF p = -1 OR p = 0 THEN CALL AI(5,Null$,K1,0,0,0,0,0&,0&)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine handles working with file archives.
        '
        ' p$  can contain a filename for the routine to work with
        '     rather than asking the user for one.
        '
        ' p  number of directories to use.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
SUB Archiver (p$)

  CALL BlockToO(0,32)
  K = LEN(p$)
  TT = 20002 + (K = 0)
  CALL SendTT
  IF K = 0 THEN CALL GetFileName(0,p$,K,Null$) _
           ELSE K = BiSearch(3,0,Form$(1201,p$))
  IF K < 1 OR BitTest(FileIDX.Attr,7) THEN EXIT SUB
  FOR K0 = 1 TO DirsSize
    K0$ = FileAreaInfo3$(K0,2) + p$
    IF FindF2(K0$,FFile) THEN EXIT FOR
  NEXT
  IF K0 > DirsSize THEN EXIT SUB
  K2 = FileType(K0$)
  IF K2 < 1 OR K2 > 3 THEN TT$ = SPACE$(14 - LEN(p$)) + o$(3) : _
                           CALL SendTT : _
                           EXIT SUB : _
  IF GetFilePassword(FFile.FName) = 0 THEN EXIT SUB
  TT = 20004
  CALL SendTT
  IF TGot > 0 THEN EXIT SUB
  CALL ViewContents(K0$,K2)
  DO
    IF TGot < 1 THEN TT = 20037 : _
                     CALL SendTT : _
                     CALL TGet2(o$(6) + C13$)
    SELECT CASE TGot
      CASE 1
           TT = 20007
           CALL SendTT
           CALL ViewContents(K0$,K2)
      CASE 2
           TT = 20008
           CALL SendTT
           K1$ = DoPaths$(K2)
           CALL ReplaceStrings(K1$,o$(9),K0$)
           TT$ = ExpandStr$(K1$)
           CALL ShellDosTT(8)
      CASE 3
           TT = 20010
           CALL SendTT
           CALL ExtractFiles(K0$,K2,p$)
      CASE ELSE
           TT = 20011
           CALL SendTT
           EXIT DO
    END SELECT
  LOOP UNTIL NoCarrier

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to Archiver, gets and returns the
        ' information about a single archive member file.
        '
        ' p    Archieve type: 1 = ZIP, 2 = ARJ, 3 = LZH
        '
        ' p&   current position in the file.
        '
        ' p$   path and file name of member.
        '
        ' p0&  Original size
        '
        ' p1&  Stored size
        '
        ' p0   Date integer
        '
        ' p0$  Method
        '
        ' p1   opened file's handle
        '
        ' If change this routine, be sure to change the very similar
        ' ArchiveFile2Info routine in REG_PKG2.BAS.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
SUB ArchiveFileInfo (p,p&,p$,p0&,p1&,p0,p0$,p1)

  SELECT CASE p
    CASE 1
         CALL FileGetLoc(p1,p& - 1,30,ZIPInfo)
         p& = p& + 30
         '
         ' Last time I checked PkZip specs, only PK+c3+c4 was what marked a
         ' ZIP header.  But someone uploaded a file with PK+c7+c8, so I've
         ' included that as well
         ' --but, alas, the data's structure is also different, so I'll wait
         ' and see if it reappears in another archive.
         '
'         IF ZIPInfo.TestString <>  o$(12) + Chars$(3) + Chars$(4) _
'            AND ZIPInfo.TestString <>  o$(12) + C7$ + C8$ _
         IF ZIPInfo.TestString <>  o$(12) + Chars$(3) + Chars$(4) _
            THEN p& = FileLof&(p1,1) : _
                 p$ = Null$ : _
                 EXIT SUB
         p0& = ZIPInfo.OriginalSize
         p1& = ZIPInfo.StoredSize
         p0 = ZIPInfo.FileDate
         IF ZIPInfo.Method > 8 _
            THEN p0$ = o$(13) _
            ELSE p0$ = MID$(o$(14),ZIPInfo.Method * 8 + 1,8)
         p$ = SPACE$(ZIPInfo.NameLength) 'See ExtractFiles--Quirk after a line like this.
                                         'Before this p1& is ok, after, it jumps 500k.
         CALL FileGetSLoc(p1,p& - 1,p$)
         p& = p& + p1& + ZIPInfo.NameLength + ZIPInfo.HeaderLength
    CASE 3
         CALL FileGetLoc(p1,p& - 1,22,LZHInfo)
         p& = p& + 22
         p0& = LZHInfo.OriginalSize
         p1& = LZHInfo.StoredSize
         p0 = LZHInfo.FileDate
         p0$ = LZHInfo.Method
         p$ = SPACE$(ASC(LZHInfo.NameLength))
         CALL FileGetSLoc(p1,p& - 1,p$)
         p& = p& + p1& + 2 + ASC(LZHInfo.HeaderLength) - 22
    CASE 2
         CALL FileGetLoc(p1,p& - 1,34,ARJInfo)
         K2& = p&
         p& = p& + 34
         p0& = ARJInfo.OriginalSize
         p1& = ARJInfo.StoredSize   'If EntryType = 2 this value is either 0
                                    'or extrmely large.  I don't know if this
                                    'true for other EntryType's.
         IF ASC(ArjInfo.EntryType) = 2 THEN p1& = 0
         p0 = ARJInfo.FileDate
         K1 = ASC(ARJInfo.Method)
         IF K1 > 4 THEN p0$ = o$(13) _
                   ELSE p0$ = MID$(o$(15),K1 * 9 + 1,9)
         p$ = Null$
         K$ = C32$
         CALL FileGetSLoc(p1,p& - 1,K$)
         p& = p& + 1
         IF ARJInfo.HeaderLength = 0 THEN K$ = C0$    'Last Header.
         WHILE K$ <> C0$
           p$ = p$ + K$
           CALL FileGetSLoc(p1,p& - 1,K$)
           p& = p& + 1
         WEND
         p& = K2& + p1& + ARJInfo.HeaderLength + 10
         IF ASC(ARJInfo.EntryType) <> 0 THEN p$ = Null$
         IF ARJInfo.HeaderLength = 0 THEN p& = FileLof&(p1,1)
  END SELECT
  CALL ReplaceCharacters(p$,47,Null$,92)  'Replace '/' with '\' for extract.
                                          '(ie. ARJ uses /'s, but only
                                          'recognizes \'s for !x.lst members.

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to Archiver, lists the contents of an
        ' archive.
        '
        ' p$  name of archive.
        '
        ' p   Archieve type: 1 = ZIP, 2 = ARJ, 3 = LZH
        '
        ' Date last checked for perfection: Sep 10 1992
        '
SUB ViewContents (p$,p)

  TT = 20036
  CALL SendTT
  K9 = FileOpenR(p$)
  K& = 1
  DO
    CALL ArchiveFileInfo(p,K&,K0$,K0&,K1&,K0,K1$,K9)
    SELECT CASE LEN(K0$)
      CASE IS > 0
           IF LEN(K0$) > 26 _
              THEN TT$ = LEFT$(K0$,11) + o$(17) + RIGHT$(K0$,12) _
              ELSE TT$ = Form$(2601,K0$)
           TT$ = o$(18) + TT$ + o$(19) + Form2$(11,K0&) + o$(20) + _
                 Form2$(11,K1&) + Form$(966,PercentCalc$(K0&,K1&)) + _
                 o$(21) + IntToDate3$(K0) + o$(22) + _
                 RTRIM$(Form$(908,K1$)) + C1310$
           CALL SendTT
    END SELECT
  LOOP UNTIL K& + 3 >= FileLof&(K9,1) OR TGot > 0
  CALL FileCloseR(K9)
  IF TGot > 0 THEN TGot = StrSrch1(o$(6) + C13$,TGot)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to Archiver, handles the extraction
        ' of files.
        '
        ' p$   pathname of archive.
        '
        ' p    Archieve type: 1 = ZIP, 2 = ARJ, 3 = LZH
        '
        ' p0$  filename of archive.
        '
        ' Date last checked for perfection: Apr 16 1993
        '
        ' If the original file is free, then so is the extracted file.
        '
        ' Future watch:  see if the archivers add the capability to 'delete
        '                members of an archive into a new archive.'  A
        '                command like: 'arj d archive *.* -x!list.lst archive2'
        '                In which internally everything is done the same, but
        '                at the last second, instead of deleting 'archive' and
        '                and renaming the temp file to 'archive', the temp file
        '                is simply renamed to 'archive2' ('archive' is not
        '                deleted/altered).
        '
        '
SUB ExtractFiles (p$,p,p0$)

  K9 = FileOpenR(p$)
  CALL KillFile(FileNames(49))
  K10 = FileOpenW(FileNames(49))
  K& = 1
  K1$ = Paths$(9) + p0$
  K1& = FileLof&(K9,1) + Settings.MinSpace
  K2& = 0
  K2 = 0
  TT$ = o$(30)
  kk& = -1
  DO
    K0$ = Null$
    CALL ArchiveFileInfo(p,K&,K0$,0&,K0&,0,"",K9)      'Don't use Null$.
    K0 = LEN(K0$)
    SELECT CASE K0
      CASE IS > 0
           TT$ = TT$ + o$(24) + K0$ + o$(25)
           CALL SendTT
           CALL TGet2(o$(26) + C13$ + Chars$(2))
           CALL Wipe(6)
           SELECT CASE TGot
             CASE 1
                  '
                  ' Bit slower than just keeping counters--but not called
                  ' too often, and has the advantage of seeing the current
                  ' drive space.
                  '
                  SELECT CASE K0&
                    CASE IS > DriveSpc&(K1$) - K1& - K2&
                         TT$ = o$(27)
                         K0 = K0 + StripLen(TT$)
                         CALL SendTT
                         TGot = -1
                    CASE ELSE
                         K3 = (K0& > CanDL& - K2&)
                         IF BitTest(User.Attr,16) THEN K3 = 0 : _
                                                       kk& = 0
                         IF BitTest(FileIDX.Attr,2) _
                            OR (BitTest(FileIDX.Attr,9) AND ConnectCPS >= 800) _
                            THEN K3 = 0 : _
                                 kk& = 0
                         SELECT CASE K3
                           CASE -1
                                TT$ = o$(28)
                                K0 = K0 + StripLen(TT$)
                                CALL SendTT
                                TGot = -1
                           CASE ELSE
                                TT = 20029
                                CALL SendTT
                                K2 = K2 + 1
                                K2& = K2& + K0&
                                TT$ = o$(30)
                                TGot = 1
                                IF p <> 3 _
                                   THEN CALL FilePutSend(K10,K0$ + C1310$)
                         END SELECT
                  END SELECT
           END SELECT
           IF TGot <> 1 THEN CALL Wipe(3 + K0) : _
                             TT$ = Null$ : _
                             IF p = 3 THEN CALL FilePutSend(K10,K0$ + C1310$)
    END SELECT
  LOOP UNTIL K& + 3 >= FileLof&(K9,1) OR NoCarrier
  CALL FileCloseR(K9)
  CALL FileCloseW(K10)
  IF TGot <> 1 THEN CALL Wipe(StripLen(o$(30)))
  IF K2 = 0 THEN TGot = -1 : _
                 EXIT SUB
  TT = 20031
  CALL SendTT
  CALL CopyFile(0,p$,K1$)
  K2$ = DoPaths$(p + 3)
  CALL ReplaceStrings(K2$,o$(9),K1$)
  TT$ = ExpandStr$(K2$)
  CALL ShellDosTT(8)
  IF FindF(K1$,FFile) = 0 THEN TT = 20032 : _
                               CALL SendTT : _
                               EXIT SUB
  IF kk& = -1 THEN kk& = FFile.FSize
  K2$ = Paths$(9) + o$(38) + RIGHT$(K1$,4)     'to bypass processlog's
                                               'subtracting the whole file.
  CALL CopyFile(1,K1$,K2$)
  TT$ = o$(33) + ParseForName$(K2$) + o$(34) + Commas$(FFile.FSize) + o$(35)
  SELECT CASE GetYNTT
    CASE -1
         K1$ = K2$
         CALL BuildFnamesCtl(K1$)
         CALL AdjustProtocol(User.Protocol)
         TT$ = o$(16) + RTRIM$(Form$(7908,MID$(TT$,20,34))) + o$(5)
         z = 4
         CALL ShellDownload(z)
         IF z = -1 THEN User.DLBytes = User.DLBytes - kk&
  END SELECT
  CALL KillFile(K2$)

END SUB
        '
        '* * * *


