' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'
' This file contains various routines from PointShoot, ListDir, and
' PagedFileSystem.
'  DispRequests
'  DLBatchStuff
'  DLStuff
'  DisplayReviews
'  LoadDirContents
'  DoNextFile
'
SUB OverLay3
END SUB




        '* * * * * *
        ' This routine displays the information in the requests file.
        '
        ' There are 3 levels displayed: requests, unprotects, and SL
        ' based targetted requests.
        '
        ' They are listed in the above order.  The key word looked for
        ' is 'unprotect'.
        '
        ' Date last checked for perfection: Sep 19 1992
        '
SUB DispRequests

  TT = 208
  CALL SendTT
  IF TGot > 0 THEN EXIT SUB
  K1 = FileOpenR(FileNames(14))
  K& = 0
  K = 1
  K0$ = Short$(740)
  WHILE K& <> -1 AND TGot < 1
    K$ = FileGetLine$(K1,K&)
    SELECT CASE StrSrch(1,K$,K0$) + StrSrch(1,K$,Short$(218)) 
      CASE 0
           K$ = MID$(K$,11)
           IF LEN(K$) > 29 THEN K$ = Form$(3801,K$) _
                           ELSE K$ = Form1$(38,K$)
           IF K = 1 _
              THEN TT$ = K$ + Short$(219) _
              ELSE TT$ = Short$(232) + TT$ + Short$(98) + K$ + Short$(271) : _
                   CALL SendTT
           K = - K
    END SELECT
    IF K& = -1 AND K = -1 _
       THEN TT$ = Short$(232) + TT$ + Short$(428) : _
            CALL SendTT
  WEND
  IF TGot > 0 THEN CALL FileCloseR(K1) : _
                   EXIT SUB
  TT = 10259
  CALL SendTT
  K& = 0
  K = 1
  WHILE (K& <> -1 OR K = -1) AND TGot < 1
    K$ = FileGetLine$(K1,K&)
    SELECT CASE StrSrch(1,K$,Short$(218))
      CASE IS > 0
           K$ = MID$(K$,11)
           IF LEN(K$) > 29 THEN K$ = Form$(3801,K$) _
                           ELSE K$ = Form1$(38,K$)
           IF K = 1 _
              THEN TT$ = K$ + Short$(219) _
              ELSE TT$ = Short$(232) + TT$ + Short$(98) + K$ + Short$(271) : _
                   CALL SendTT
           K = - K
    END SELECT
    IF K& = -1 AND K = -1 THEN K = 1
  WEND
  IF TGot > 0 THEN CALL FileCloseR(K1) : _
                   EXIT SUB
  TT = 10328
  CALL SendTT
  SELECT CASE Levels(UserSL).SecLevel
    CASE IS >= Settings.SLEachOther
         K& = 0
         WHILE K& <> -1 AND TGot < 1
           TT$ = FileGetLine$(K1,K&)
           SELECT CASE StrSrch(1,TT$,K0$)
             CASE IS > 0
                  IF LEN(TT$) > 82 THEN TT$ = Form$(8701,TT$) _
                                   ELSE TT$ = Form1$(87,TT$)
                  TT$ = Short$(232) + MID$(TT$,11) + Short$(271)
                  CALL SendTT
           END SELECT
         WEND
  END SELECT
  IF TGot < 1 THEN TT$ = Short$(311) + STRING$(77,196) + Short$(336) : _
                   CALL SendTT
  CALL FileCloseR(K1)
  CALL Paused

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine handles various batch file stuff.
        '
        ' p   what to do:
        '     2 to add to batch.
        '     3 to list the batch contents and offer to delete any.
        '     5 to list the batch contents and offer to download them.
        '     6 to list the batch contents and go and download them.
        '     7 delete entries from the batch.
        '     4 download the batch.
        '
        ' p$  actual batch.
        '
        ' p0$ if PagF system, then last displayed file names.
        '
        ' Date last checked for perfection: Nov 6 1992
        '
SUB DLBatchStuff (p,p$,p0$)

  IF NoCarrier THEN EXIT SUB
  DO
    SELECT CASE p
      CASE 2
           '
           ' Add to batch.
           '
           CALL DLStuff(0,p$,K&,p0$)
           DO
             TT = 137
             CALL SendTT
             CALL GetFileName(1 + 2,K0$,p,p0$)
             IF p < 1 THEN CALL Wipe(LEN(Lines$(137)) + LEN(K0$)) : _
                           EXIT DO
             IF BitTest(FileIDX.Attr,2) _
                OR (BitTest(FileIDX.Attr,9) AND ConnectCPS >= 800) _
                THEN FileIDX.FSize = 0
             SELECT CASE FileIDX.FSize + K&
               CASE IS > (DLTime * (ConnectCPS * 57&))
                    TT = 25
                    CALL SendTT
               CASE ELSE
                    kk = BitTest(User.Attr,16)
                    kk4 = Settings.FPWorthInBytes
                    SELECT CASE kk4
                      CASE 0
                           IF kk = 0 THEN IF FileIDX.FSize + K& <= CanDL& _
                                             THEN kk = -1 _
                                             ELSE TT = 128 : _
                                                  CALL SendTT
                      CASE ELSE
                           Kk7 = FileOpenR(FileNames(4))
                           CALL FileGetRec(Kk7,FileIDX.FRec,119,FileList)
                           CALL FileCloseR(kk7)
                           IF FileList.LDCount > 99 _
                              THEN kk4 = FileList.LDCount - 100
                           IF kk = 0 _
                              THEN IF ((FileIDX.FSize + K&) \ kk4) <= (CanDL& \ kk4) _
                                      THEN kk = -1 _
                                      ELSE TT = 233 : _
                                           CALL SendTT
                    END SELECT
                    IF kk = -1 _
                       THEN kz$ = Form$(1201,K0$) : _
                            IF StrSrch(1,p$,kz$) > 0 _
                               THEN TT = 68 : _
                                    CALL SendTT _
                               ELSE p$ = p$ + kz$ + MKL$(FileIDX.FSize)
             END SELECT
             CALL DispCRLF
           LOOP UNTIL LEN(p$) > 1600
tgot = 0
      CASE 3, 5, 6
           '
           ' List the contents of the batch.
           '
           K0 = LEN(p$) \ 16
           K1 = 1
           WHILE K1 <= K0
             TT$ = Null$
             FOR K2 = K1 TO K1 + 2
               IF K2 <= K0 _
                  THEN TT$ = TT$ + Short$(762) + _
                             Form$(966,Commas$(LongMid(p$,K2 * 16 - 3))) +  _
                             Short$(905) + Form$(1465,MID$(p$,K2 * 16 - 15,12))
             NEXT
             TT$ = RTRIM$(TT$) + C1310$
             CALL SendTT
             K1 = K1 + 3
           WEND
           IF K0 = 0 THEN IF p <> 5 THEN TT = 26 : _
                                         CALL SendTT : _
                                         p = 0 _
                                    ELSE p = 0
           SELECT CASE p
             CASE 3 : TT = 27
                      IF GetYNTT THEN p = 7 _
                                 ELSE p = 0
                      CALL DispCRLF
             CASE 5 : TT = 23
                      IF GetYNTT THEN p = 4 _
                                 ELSE p = 0
             CASE 6 : p = 4
           END SELECT
tgot = 0
      CASE 7
           '
           ' Remove entries from the batch.
           '
           DO
             TT = 129
             CALL SendTT
             CALL GetFileName(1,K0$,p,Null$)
             IF p < 1 THEN CALL Wipe(LEN(Lines$(129)) + LEN(K0$)) : _
                           EXIT DO
             IF p > 0 _
                THEN K0 = StrSrch(1,p$,Form$(1201,K0$)) : _
                     IF K0 > 0 THEN p$ = LEFT$(p$,K0 - 1) + MID$(p$,K0 + 16)
             CALL DispCRLF
             IF LEN(p$) = 0 THEN p = -1
           LOOP UNTIL p < 1
tgot = 0
      CASE 4
           '
           ' Download the batch.  Bytes and time checking done when added
           ' to the batch, but done again here as well (excess removed).
           '
           CALL DispCRLF
           K$ = Null$
           p = -1
           K& = 0
           WHILE LEN(p$) > 0
             K0$ = LEFT$(p$,12)
             K0& = LongMid(p$,13)
             p$ = MID$(p$,17)
             kk3 = GetFilePassword(K0$)   'also gets FileIDX
             kk4 = Settings.FPWorthInBytes
             SELECT CASE kk4
               CASE 0    : kk2 = (K0& + K& <= CanDL&)
               CASE ELSE
                    kk2 = ((K0& + K&) \ kk4) <= (CanDL& \ kk4)
             END SELECT
             IF BitTest(User.Attr,16) _
                OR ((K0& + K& <= (DLTime * (ConnectCPS * 57&))) AND kk2) _
                THEN IF kk3 _
                        THEN K$ = K$ + FileAreaInfo3$(FileIDX.FArea,2) + _
                                  K0$ + C1310$ : _
                             K& = K& + K0& : _
                             p = 0
           WEND
           IF p = 0 THEN CALL RatiosCheck(p)
           SELECT CASE p
             CASE -2
                  p = -1
                  TT = 234
                  CALL SendTT
                  CALL Paused
             CASE -3
                  p = -1
                  TT = 235
                  CALL SendTT
                  CALL Paused
           END SELECT
           CALL BuildFnamesCtl(K$)
           IF p THEN EXIT DO
           TT = 66
           K = GetYNTT
           CALL DispCRLF
           CALL DispCRLF
           CALL AdjustProtocol(User.Protocol)
           TT$ = Short$(602) + RTRIM$(Form$(7908,MID$(TT$,20,34))) + Lines$(18)
           TGot = 1001 + K
    END SELECT
  LOOP UNTIL p < 1

END SUB
        '
        '* * * *

 


        '* * * * * *
        ' This routine handles various download-related operations.
        '
        ' p   What to do:
        '     0 Display what the user has available and has allocated.
        '     1 Ask for and download a single file.
        '
        ' p$  DL batch (if any)
        '
        ' p&  returns with the total bytes allocated so far when p = 0.
        '
        ' Date last checked for perfection: Nov 6 1992
        '
SUB DLStuff (p,p$,p&,p0$)

  SELECT CASE p
    CASE 0
         kk = BitTest(User.Attr,16)
         kk4 = Settings.FPWorthInBytes
         SELECT CASE kk4
           CASE 0
                IF kk THEN K$ = Short$(143) _
                      ELSE K$ = Commas$(CanDL&)
                CALL TTInsertStr2(Lines$(130),K$,STR$(DLTime))
           CASE ELSE
                IF kk THEN K$ = Short$(143) _
                      ELSE K$ = Commas$(CanDL& \ kk4)
                CALL TTInsertStr2(Lines$(236),K$,STR$(DLTime))
         END SELECT
         CALL TTInsertStr2(Lines$(130),K$,STR$(DLTime))
         CALL SendTT
         p& = 0
         FOR K1 = 1 TO LEN(p$) \ 16
           p& = p& + LongMid(p$,K1 * 16 - 3)
         NEXT
         IF p& > 0 _
            THEN CALL TTInsertStr2(Lines$(131),Commas$(p&),STR$(p& \ (ConnectCPS * 57&))) : _
                 CALL SendTT
         CALL DispCRLF
    CASE 1
         TT = 134
         CALL SendTT
         CALL GetFileName(1 + 2,K0$,0,p0$)
         IF NOT GetFilePassword(K0$) THEN EXIT SUB
         IF BitTest(FileIDX.Attr,2) _
            OR (BitTest(FileIDX.Attr,9) AND ConnectCPS >= 800) _
            THEN FileIDX.FSize = 0
         kk = BitTest(User.Attr,16)
         kk4 = Settings.FPWorthInBytes
         SELECT CASE kk4
           CASE 0
                IF FileIDX.FSize + p& > CanDL& AND NOT kk _
                   THEN TT = 128 : _
                        CALL SendTT : _
                        EXIT SUB
           CASE ELSE
                Kk7 = FileOpenR(FileNames(4))
                CALL FileGetRec(Kk7,FileIDX.FRec,119,FileList)
                CALL FileCloseR(kk7)
                IF FileList.LDCount > 99 _
                   THEN kk4 = FileList.LDCount - 100
                IF ((FileIDX.FSize + p&) \ kk4) > (CanDL& \ kk4) AND NOT kk _
                   THEN TT = 233 : _
                        CALL SendTT : _
                        EXIT SUB
         END SELECT
         IF FileIDX.FSize + p& > (DLTime * (ConnectCPS * 57&)) _
            THEN TT = 25 : _
                 CALL SendTT : _
                 EXIT SUB
         CALL BuildFnamesCtl(FileAreaInfo3$(FileIDX.FArea,2) + K0$)
         CALL AdjustProtocol(User.Protocol)
         TT$ = Short$(751) + RTRIM$(Form$(7908,MID$(TT$,20,34))) + Lines$(18)
         TGot = 1000
  END SELECT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine displays the reviews for a file area.
        '
        ' p  -1 if should wipe and do a paused
        '     0 if not
        '     1 like 0 but without the filename
        '
        ' FileIndex is relied upon.
        '
        ' Date last checked for perfection: Nov 7 1992
        '
SUB DisplayReviews (p,p$)

  IF p = -1 THEN CALL Wipe(StripLen(Lines$(3)) - 3)
  K0$ = RTRIM$(FileNames(15)) + Form4$(3,FileIndex)
  IF NOT FindF2(K0$,FFile) THEN EXIT SUB
  IF p <> 1 THEN TT = 67 : _
                 CALL SendTT
  K0 = FileOpenR(K0$)
  K& = 0
  K1 = 0
  K2 = 0
  K3 = LEN(p$)
  DO
    K$ = FileGetLine$(K0,K&)
    K0$ = MID$(K$,2,12)
    IF K3 > 0 THEN IF K1 THEN IF LEN(RTRIM$(K0$)) > 0 THEN K1 = 0
    IF K3 > 0 THEN IF NOT K1 THEN IF K0$ = p$ THEN K1 = -1
    SELECT CASE p
      CASE 1
           IF K1 OR K3 = 0 _
              THEN TT$ = TT$ + C1310$ + Short$(213) + _
                         IntToStr$(Settings.SpB4Review) + Chars$(67) + _
                         MID$(K$,14) : _
                   K2 = -1
      CASE ELSE
           IF K1 OR K3 = 0 _
              THEN TT$ = Short$(774) + ExpandFileName$(K0$) + Short$(97) + _
                         SPACE$(Settings.SpB4Review - 12 + 2) + _
                         MID$(K$,14) + C1310$ : _
                   CALL SendTT : _
                   K2 = -1
    END SELECT
  LOOP UNTIL K& = -1 OR TGot > 0
  CALL FileCloseR(K0)
  IF p = -1 THEN CALL Paused
  IF K3 > 0 AND K2 = 0 AND p <> 1 THEN TT = 136 : _
                                       CALL SendTT

END SUB
        '
        '* * * *

'A call to load FindF(dir,fwork(1)) must be done before calling this.
FUNCTION LoadDirContents%

  '
  ' Locate all the files in the directory.  An alternative
  ' method is to scan the entire FILES.IDX file looking for
  ' matching .FArea's.
  '
  ' BiSearch est: NLogN wher N is number of files in dir.
  ' FILES.IDX est: total number of entries.
  ' BiSearch offers the advantage of sorted entries.
  ' Files.idx offers the advantage of disk buffered speed.
  '
  ' 3 dirs with 100 files each (300 total):
  ' Bisearch = 600 reads of files.idx per dir.
  ' Files.idx = 300 reads of files.idx per dir.
  ' 10 dirs with 100 files each (1000 total):
  ' Bisearch = 600 reads of files.idx per dir.
  ' Files.idx = 1000 reads of files.idx per dir.
  ' 20 dirs with 100 files each (2000 total):
  ' Bisearch = 600 reads of files.idx per dir.
  ' Files.idx = 2000 reads of files.idx per dir.
  '
  ' So, Bisearch method is better as number of files increase.
  ' Therefore that is the method used.
  '
  K3 = 1
  DO
    K3 = K3 + 1
    K9 = CommIn(256)
  LOOP UNTIL FindF(Null$,FWork(K3)) = 0 OR K9 = 13 OR K3 = Settings.MaxFilesInDir
  IF K9 = 13 THEN LoadDirContents% = 0 : _
                  EXIT FUNCTION
  FWork(0).FName = C0$
  K3 = K3 - 1
  IF NOT BitTest(FileArea.Attr,7) THEN CALL FWorkSort(K3)
  IF CommIn(256) = 0 THEN K3 = 0
  LoadDirContents% = K3

END FUNCTION


'K = FWork() to use
'K0 = handle of opened filenames(4)
'     if < 0 then only doing new files.
'     [note, opened as Read-only]
'p1 = fileindex
'p2 = handle of already-opened FILES.IDX  [note, opened as read-only]
SUB DoNextFile (K,K0,p1,p2)

  if k0 < 0 then k2 = -1 : _
                 k0 = - k0 _
            else k2 = 0
  '
  ' Locate all the files in the directory.  An alternative
  ' method is to scan the entire FILES.IDX file looking for
  ' matching .FArea's.
  '
  ' BiSearch est: NLogN wher N is number of files in dir.
  ' FILES.IDX est: total number of entries.
  ' BiSearch offers the advantage of sorted entries.
  ' Files.idx offers the advantage of disk buffered speed.
  '
  ' 3 dirs with 100 files each (300 total):
  ' Bisearch = 600 reads of files.idx per dir.
  ' Files.idx = 300 reads of files.idx per dir.
  ' 10 dirs with 100 files each (1000 total):
  ' Bisearch = 600 reads of files.idx per dir.
  ' Files.idx = 1000 reads of files.idx per dir.
  ' 20 dirs with 100 files each (2000 total):
  ' Bisearch = 600 reads of files.idx per dir.
  ' Files.idx = 2000 reads of files.idx per dir.
  '
  ' So, Bisearch method is better as number of files increase.
  ' Therefore that is the method used.
  '
  K1 = BiSearch(3,p2,FWork(K).FName)
  '
  ' No FileList entry found?  Fix this 'loose' file by giving it an entry.
  '
  SELECT CASE K1
    CASE IS < 1
         IF BitTest(FileAreaI(p1).Attr,10) THEN FileList.FName = Null$ : _
                                                FileList.HiFilePtr = -1 : _
                                                EXIT SUB
         FFile = FWork(K)
         FileIndex = p1
         CALL CreateFileStuff(3,0,0,K0,p2)
         FileList.UserName = FileAreaInfo3$(p1,1)
         CALL FilePutRec(K0,FileLof&(K0,119) + 1,119,FileList)
         K1 = BiSearch(3,p2,FWork(K).FName)
         IF BitTest(Settings.LoggingAmount,14) _
            THEN TT$ = Short$(682) + FileList.FName : _
                 CALL ScreamErrorTT
  END SELECT
  SELECT CASE K2
    CASE 0 : CALL FileGetRec(K0,FileIDX.FRec,119,FileList)
    CASE ELSE
         CALL FileGetLoc(K0,119& * FileIDX.FRec - 119 + 2,4,K&)
         IF K& > User.HiFilePtr _
            THEN CALL FileGetRec(K0,FileIDX.FRec,119,FileList) _
            ELSE FileList.HiFilePtr = -1 : _
                 EXIT SUB
  END SELECT
  IF BitTest(FileAreaI(p1).Attr,9) THEN EXIT SUB  'don't do any auto-correcting
  '
  ' File area's don't match?  Fix this by giving it it's current file area.
  '
  IF FileList.FArea <> p1 OR FileIDX.FArea <> p1 _
     THEN FileList.FArea = p1 : _
          FileIDX.FArea = p1 : _
          CALL FilePutRec(K0,FileIDX.FRec,119,FileList) : _
          CALL FilePutRec(p2,K1,22,FileIDX) : _
          IF BitTest(Settings.LoggingAmount,14) _
             THEN TT$ = Short$(683) + FileList.FName : _
                  CALL ScreamErrorTT
  '
  ' File size's don't match?  Fix this by giving it it's current file size.
  '
  IF FileList.FSize <> FWork(K).FSize OR FileIDX.FSize <> FWork(K).FSize _
     THEN FileList.FSize = FWork(K).FSize : _
          FileIDX.FSize = FWork(K).FSize : _
          CALL FilePutRec(K0,FileIDX.FRec,119,FileList) : _
          CALL FilePutRec(p2,K1,22,FileIDX) : _
          IF BitTest(Settings.LoggingAmount,14) _
             THEN TT$ = Short$(755) + FileList.FName : _
                  CALL ScreamErrorTT
  '
  ' File attributes's don't match?  Fix this by using FileList's.
  '
  IF FileIDX.Attr <> FileList.Attr _
     THEN FileIDX.Attr = FileList.Attr : _
          CALL FilePutRec(p2,K1,22,FileIDX) : _
          IF BitTest(Settings.LoggingAmount,14) _
             THEN TT$ = Short$(765) + FileList.FName : _
                  CALL ScreamErrorTT
  '
  ' File area HiFilePtr is too low?  Fix this quietly.
  '
  IF FileList.HiFilePtr > FileAreaI(p1).HiFilePtr _
     THEN CALL UpdateHiFilePtr(p1,FileList.HiFilePtr)

END SUB



' p = file area
' p$ returns a string of 12 char filenames.
SUB IDReviews (p,p$)

  p$ = Null$
  K0$ = RTRIM$(FileNames(15)) + Form4$(3,p)
  IF FindF(K0$,FFile) = 0 THEN EXIT SUB
  K0 = FileOpenR(K0$)
  K& = 0
  K0& = FFile.FSize
  K1$ = Chars$(10) + Chars$(51)
  DO
    K$ = Chars$(10) + FileGetBlock$(K0,K&,K0&)
    kz = StrSrch(1,K$,K1$)
    WHILE kz > 0
      IF AscMid(K$,kz + 2) <> 32 THEN p$ = p$ + MID$(K$,kz + 2,12)
      kz = StrSrch(kz + 1,K$,K1$)
    WEND
    K9 = CommIn(256)
  LOOP UNTIL K& = K0& OR K9 = 13
  CALL FileCloseR(K0)
  IF K9 = 13 THEN TGot = 13 _
             ELSE TGot = -1

END SUB





        '* * * * * *
        ' This routine, internal to PointShoot, handles some of the
        ' can-be-overlaid stuff.
        '
        ' p  Toggle for whether to do P&S or not.
        '
        ' p2 number of directories
        '
        ' Date last checked for perfection: Nov 3 1992
        '
SUB PointShoot2 (p,K2,K5,p2)

  CALL FileAreaInfo(FileIndex)
  IF FindF(RTRIM$(FileArea.Path) + Short$(822),FWork(1)) = 0 _
     THEN TGot = 1000 : _
          EXIT SUB
  K0 = 1
  DO : K0 = K0 + 1
  LOOP UNTIL FindF(Null$,FWork(K0)) = 0 OR K0 = Settings.MaxFilesInDir
  FWork(0).FName = C0$
  TT$ = Short$(966) + RTRIM$(FileArea.Title) + Short$(729)
  CALL SendTT
  IF TGot = 46 THEN CALL BitClear(p,2)
  IF TGot > 0 THEN TGot = 1000 : _
                   EXIT SUB
  IF NOT BitTest(FileArea.Attr,7) THEN CALL FWorkSort(K0 - 1)
  TT$ = Null$
  K1 = 0
  K2 = 0
  K3 = 0
  K4 = 1
  KK = FileOpenR(FileNames(59))
  WHILE K4 < K0
    K5 = BiSearch(3,KK,FWork(K4).FName)
    IF K5 > 0 _
       THEN IF BitTest(FileIDX.Attr,6) OR BitTest(FileIDX.Attr,7) _
               THEN K5 = 0
    SELECT CASE K5
      CASE 0 : FOR K5 = K4 TO K0 - 2
                 FWork(K5) = FWork(K5 + 1)
               NEXT
               K0 = K0 - 1
               K4 = K4 - 1
      CASE ELSE
           TT$ = TT$ + C32$ + FWork(K4).FName
           o$(K4) = AnsiLocStr$(K3 + 6,K2 * 13 + 1)
           K2 = K2 + 1
           IF K2 = 6 THEN K2 = 0 : _
                          K3 = K3 + 1
           IF K3 = 25 THEN K3 = 24               'Need a fix/stop here.
           K1 = K1 + 1
           IF K4 = K0 - 1 THEN K1 = 6
           IF K1 = 6 THEN TT$ = Short$(968) + RTRIM$(TT$) + C1310$ : _
                          CALL SendTT : _
                          K1 = 0 : _
                          TT$ = Null$ : _
                          IF TGot > 0 THEN K4 = K0
    END SELECT
    K4 = K4 + 1
  WEND
  CALL FileCloseR(KK)
  IF TGot = 46 THEN CALL BitClear(p,2)
  IF TGot > 0 THEN TGot = 1000 : _
                   EXIT SUB
  K4 = 0
  K& = 0
  K5 = 1
  WHILE K5 < LEN(BatchToDL$)
    K0$ = MID$(BatchToDL$,K5,12)
    K4 = K4 + 1
    K& = K& + LongMid(BatchToDL$,K5 + 12)
    FOR K3 = 1 TO K0 - 1
      IF FWork(K3).FName = K0$ _
         THEN o$(K3) = o$(K3) + Short$(342) : _
              TT$ = o$(K3) + Short$(974) + FWork(K3).FName + Short$(762) : _
              CALL SendTT : _
              BatchToDL$ = LEFT$(BatchToDL$,K5 - 1) + MID$(BatchToDL$,K5 + 16) : _
              K5 = K5 - 16
    NEXT
    K5 = K5 + 16
  WEND
  TT$ = o$(1) + Short$(116 + (AscRight(o$(1)) = 222)) + FWork(1).FName + _
        Short$(762)
  CALL SendTT
  CALL LoadFileSpecs(-1,FileIndex,K2$)
  K2 = 1                                        'Current file name working on.
  K3 = 0
  '
  ' K3 is a general bit register:
  '    16 bits:
  '     Bit 1 ON to show the current file's description.
  '     Bit 2 ON to toggle showing all file descriptions.
  '
  K5 = (K0 - 1) \ 6 + 1
  K4$ = Short$(972) + Chars$(4) + C13$ + C1$
  DO
    '
    ' No need for SendTT input checks, since that routine doesn't handle
    ' arrow keys,and in most situations we'll want to output everything
    ' anyways.
    '
    CALL TGet(K4$)
    KK = TGot
    IF AscRight(o$(K2)) = 222 _
       THEN TT$ = Short$(974) + FWork(K2).FName + Short$(762) _
       ELSE TT$ = Short$(975) + FWork(K2).FName
    TT$ = o$(K2) + TT$
    CALL SendTT
    SELECT CASE KK
      CASE 43, 45, 46, 86, 68
           FOR K6 = 1 TO K0 - 1
             IF AscRight(o$(K6)) = 222 AND LEN(BatchToDL$) < 1600 _
                THEN BatchToDL$ = BatchToDL$ + FWork(K6).FName + MKL$(FWork(K6).FSize)
           NEXT
           IF KK = 68 THEN TT$ = AnsiLocStr$(K5 + 8,1) : _
                           CALL SendTT
    END SELECT
    SELECT CASE KK
      CASE DownSC  : IF K2 + 6 <= K0 - 1 THEN K2 = K2 + 6
      CASE UpSC    : IF K2 - 6 > 0 THEN K2 = K2 - 6
      CASE LeftSC  : IF K2 - 1 > 0 THEN K2 = K2 - 1
      CASE RightSC : IF K2 + 1 <= K0 - 1 THEN K2 = K2 + 1
      CASE 43, 45, 66, 68, 85, 86, 90 : TGot = 1000 + KK
                                        EXIT DO
      CASE 49 : IF K2 + 5 <= K0 - 1 THEN K2 = K2 + 5
      CASE 50 : IF K2 + 6 <= K0 - 1 THEN K2 = K2 + 6
      CASE 51 : IF K2 + 7 <= K0 - 1 THEN K2 = K2 + 7
      CASE 52 : IF K2 - 1 > 0 THEN K2 = K2 - 1
      CASE 54 : IF K2 + 1 <= K0 - 1 THEN K2 = K2 + 1
      CASE 55 : IF K2 - 7 > 0 THEN K2 = K2 - 7
      CASE 56 : IF K2 - 6 > 0 THEN K2 = K2 - 6
      CASE 57 : IF K2 - 5 > 0 THEN K2 = K2 - 5
      CASE 63 : CALL BitSet(K3,2)              'Show this description.
      CASE 47 : CALL BitToggle(K3,1)           'Always show descriptions.
      CASE 46 : CALL BitClear(p,2)             'Switch to 'normal' listing.
                TGot = 1000
                EXIT DO
      CASE 81 : CALL BitSet(p,4)
                TGot = 1000
                EXIT DO
      CASE ELSE                                  'Mark/unmark/tag/untag.
           SELECT CASE AscRight(o$(K2))
             CASE 222
                  o$(K2) = LEFT$(o$(K2),LEN(o$(K2)) - 8)
                  K4 = K4 - 1
                  K& = K& - FWork(K2).FSize
             CASE ELSE
                  K& = K& + FWork(K2).FSize
                  TT$ = AnsiLocStr$(K5 + 6,1)
                  CALL SendTT
                  kk2 = BitTest(User.Attr,16)
                  kk4 = Settings.FPWorthInBytes
                  kk5 = GetFilePassword(FWork(K2).FName)  'gets FileIDX
                  SELECT CASE kk4
                    CASE 0    : kk3 = (CanDL& >= K&)
                    CASE ELSE
                         Kk7 = FileOpenR(FileNames(4))
                         CALL FileGetRec(Kk7,FileIDX.FRec,119,FileList)
                         CALL FileCloseR(kk7)
                         IF FileList.LDCount > 99 _
                            THEN kk4 = FileList.LDCount - 100
                         kk3 = (CanDL& \ kk4) >= (K& \ kk4)
                  END SELECT
                  IF (kk3 OR kk2) AND (DLTime >= K& \ (ConnectCPS * 57&)) _
                     AND kk5 _
                     THEN o$(K2) = o$(K2) + Short$(342) : _
                          K4 = K4 + 1 _
                     ELSE K& = K& - FWork(K2).FSize
           END SELECT
           TT$ = AnsiLocStr$(K5 + 7,1) + Short$(977) + STR$(K4) + _
                 Lines$(216) + Commas$(K&) + Lines$(217) + _
                 STR$(K& \ (ConnectCPS * 57&)) + Lines$(218) + _
                 RTRIM$(SumLog.BaudRate) + Lines$(135)
           CALL SendTT
    END SELECT  
    TT$ = o$(K2) + Short$(116 + (AscRight(o$(K2)) = 222)) + FWork(K2).FName + _
          Short$(762)
    CALL SendTT
    '
    ' Display the description line, if desired.
    '
    IF BitTest(K3,1) OR BitTest(K3,2) _
       THEN K1 = FileOpenW(FileNames(4)) : _
            zz = BiSearch(3,0,FWork(K2).FName) : _
            CALL FileGetRec(K1,FileIDX.FRec,119,FileList) : _
            CALL FileCloseW(K1) : _
            TT$ = AnsiLocStr$(K5 + 8,1) + Short$(979) : _
            CALL SendTT : _
            CALL DispDescLine(32,K2,Null$,Null$,K2$,0) : _
            IF BitTest(K3,2) THEN CALL BitClear(K3,1) : _
                                  CALL BitClear(K3,2)
  LOOP UNTIL NoCarrier

END SUB
        '
        '* * * *




'p = 0 for event/menu option to build
'p = 1 for menu option to DL.
'ck each nodes fnames.ctl, if DLing a master list, then don't do event.
'include date, name of bbs, and phone number, at top of list.
'delete fnames.ctl in logout

'the menu option to DL should not exist if the pathnames are in the file
'areas themselves (say uploads), because this option deletes the file
'after sending it (it duplicates the original, then deletes it).  dupicates
'because there isn't a way of knowing ahead of time which version the user
'wants.  problem here too w/multiple users: one DL's, another want's to DL
'and it won't copy, and will delete the original midway anyways.


SUB MasterListHandler (p)

  K0 = 1
  Work(1) = FileAreaI(1).ScanSL
  FOR K = 2 TO DirsSize
    SELECT CASE BitTest(FileAreaI(K).Attr,11)
      CASE 0
           FOR K1 = 1 TO K0
             IF Work(K1) = FileAreaI(K).ScanSL THEN EXIT FOR
           NEXT
           IF K1 > K0 THEN K0 = K0 + 1 : _
                           Work(K0) = FileAreaI(K).ScanSL
    END SELECT
  NEXT
  IF K0 > 9 THEN K0 = 9
  SELECT CASE p
    CASE 0
         TT = 10283
         CALL SendTT
         TT = 10678
         CALL SendTT
         IF DriveSpc&(FileNames(86)) < Settings.MinULSpace THEN EXIT SUB
         FOR K = 1 TO K0
           Work(K0 + K) = FileOpenW(RTRIM$(FileNames(86)) + Chars$(48 + K))
           CALL TTInsertStr1(GetBlock$(2,49),IntToDate3$(SumLog.DateOn))
           CALL ReplaceStrings(TT$,Short$(109),C1310$)
           CALL FilePutSEnd(Work(K0 + K),TT$)
         NEXT
         FOR K = 1 TO DirsSize
           SELECT CASE BitTest(FileAreaI(K).Attr,11)
             CASE 0
                  CALL FileAreaInfo(K)
                  zz = FindF(RTRIM$(FileArea.Path) + Short$(760),FWork(1))
                  IF BitTest(FileArea.Attr,6) THEN zz = 0
                  SELECT CASE zz
                    CASE IS <> 0
                         x$ = Null$           'Protect Work() from the call.
                         FOR K9 = 1 TO K0 + K0
                           x$ = x$ + MKI$(Work(K9))
                         NEXT
                         K3 = LoadDirContents
                         IF K3 = 0 THEN zz = 0
                  END SELECT
                  SELECT CASE zz
                    CASE IS <> 0
                         FOR K9 = 1 TO K0 + K0
                           Work(K9) = IntMid(x$,(K9 - 1) * 2 + 1)
                         NEXT
                         TT$ = Short$(679) + RTRIM$(FileArea.Title) + Short$(195)
                         CALL SendTT
                         K0$ = C1310$ + C1310$ + RTRIM$(FileArea.Title) + C1310$ + _
                               C1310$ + Short$(680) + C1310$ + Short$(681) + C1310$
                         FOR K1 = 1 TO K0
                           IF FileArea.ScanSL <= Work(K1) _
                              THEN CALL FilePutSEnd(Work(K0 + K1),K0$)
                         NEXT
                         K5 = 0
                         K6 = FileOpenR(FileNames(4))
                         K7 = FileOpenR(FileNames(59))
                         DO
                           K5 = K5 + 1
                           SELECT CASE BiSearch(3,K7,FWork(K5).FName)
                             CASE IS > 0
                                  CALL FileGetRec(K6,FileIDX.FRec,119,FileList)
                                  K0$ = ExpandFileName$(FWork(K5).FName)
                                  K0$ = K0$ + Form$(1066,Commas$(FileList.FSize))
                                  K0$ = K0$ + IntToDate3$(FileList.DateULed)
                                  IF BitTest(FileList.Attr,2) THEN K1 = 102 _
                                                              ELSE K1 = 32
                                  K0$ = K0$ + Chars$(K1) + C32$ + _
                                        RTRIM$(LEFT$(FileList.FDesc,45)) + C1310$
                                  FOR K1 = 1 TO K0
                                    IF FileArea.ScanSL <= Work(K1) _
                                       AND NOT BitTest(FileList.Attr,6) _
                                       AND NOT BitTest(FileList.Attr,7) _
                                       AND FileList.Password = 0 _
                                       AND FileList.Group = 0 _
                                       THEN CALL FilePutSEnd(Work(K0 + K1),K0$)
                                  NEXT
                           END SELECT
                         LOOP UNTIL K5 = k3
                         CALL FileCloseR(K6)
                         CALL FileCloseR(K7)
                  END SELECT
           END SELECT
         NEXT
         FOR K = 1 TO K0
           CALL FileCloseW(Work(K0 + K))
         NEXT
         FOR K = 1 TO K0
           CALL CopyFile(1,RTRIM$(FileNames(86)) + Chars$(48+ K),FileNames(96))
           '
           ' PKZIP.EXE /o C:\BBS\MASTER.ZIx C:\BBS\MASTER.LST
           '
           TT$ = RTRIM$(FileNames(30)) + Short$(592) + _
                 RTRIM$(FileNames(86 + K)) + C32$ + RTRIM$(FileNames(96))
           CALL ShellDosTT(8)
           IF K < K0 THEN CALL KillFile(FileNames(96))  'Keep last list.
         NEXT
    CASE ELSE
         K = K0
         DO
           IF Work(K) <= Levels(UserSL).SecLevel THEN EXIT DO
           K = K - 1
         LOOP UNTIL K = 0
         IF K = 0 THEN TT = 245 : _
                       CALL SendTT : _
                       EXIT SUB
         kz = FindF(FileNames(86 + K),FFile)
         IF DriveSpc&(FileNames(97)) <= FFile.FSize THEN TT = 246 : _
                                                         CALL SendTT : _
                                                         EXIT SUB
         CALL CopyFile(0,RTRIM$(FileNames(86 + K)),FileNames(97))
         CALL BuildFnamesCtl(FileNames(97))
         CALL AdjustProtocol(User.Protocol)
         K$ = MID$(TT$,54,40)
         TT$ = Short$(751) + RTRIM$(Form$(7908,MID$(TT$,20,34))) + Lines$(18)
         CALL ShellDownload(-1)
         CALL KillFile(FileNames(97))
         CALL FileAppendToLog(K$)
  END SELECT

END SUB




