' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'
' Various message downloading and related routines.
'  MsgDownload
'  UserMsgAreasDef
'  MsgDownload3
'  MsgDownload2
'  BuildQWKFile
'  ImportRepPackets



        '* * * * * *
        ' This routine handles the downloading of messages.
        '
        ' Date last checked for perfection: Dec 22 1992
        '
SUB MsgDownload

  CALL BlockToO(0,38)
  K = BaseIndex
  K$ = Null$
  DO
    '
    ' Build list of message areas the user has access to and toggled ON.
    '
    K0 = 0
    K4$ = Null$
    FOR K1 = 0 TO BasesSize
      K& = LongMid(UserMsgInfo$,K1 * 4 + 1)
      SELECT CASE MAccessAllowed(K1)
        CASE -1
             K0 = K0 + 1
             Work(K0) = K1
             K0$ = MsgAreaInfo3$(K1 + 1,2) + C0$
             IF K& < MsgAreaI(K1 + 1).NextNumber - 1 _
                THEN K4$ = K4$ + o$(64) + K0$ _
                ELSE K4$ = K4$ + K0$
      END SELECT
    NEXT
    IF NOT MAccessAllowed(BaseIndex) THEN BaseIndex = Work(1)
    '
    ' Loop, displaying the menu and processing the commands.
    '
    DO
      K0$ = o$(1) + C13$
      IF BaseIndex < 0 OR BaseIndex > BasesSize THEN BaseIndex = 32767
      CALL DispFile(FileNames(103),K0$)
      IF TGot < 1 THEN CALL TGet2(K0$) _
                  ELSE TGot = StrSrch1(K0$,TGot)
      SELECT CASE TGot
        CASE 1 : EXIT DO
        CASE 2 : CALL NextArea(2,BasesSize)
        CASE 3 : CALL NextArea(-2,BasesSize)
        CASE 4 : K1 = BaseIndex
                 CALL UserMsgAreasDef      'Changes the arrays.
                 BaseIndex = K1
                 EXIT DO
        CASE 5
             '
             ' Select a message area for detailed work.
             '
             TT = 20002
             CALL SendTT
             TT = 20003
             CALL MenuSystem(K4$,0)
             IF TGot > 0 THEN BaseIndex = Work(TGot)
        CASE 6
             '
             ' Incorporate all new messages.
             '
             K0$ = o$(4)
             FOR K1 = 1 TO K0
               IF LEN(K$) > 4096 THEN EXIT FOR
               IF LongMid(UserMsgInfo$,Work(K1) * 4 + 1) < MsgAreaI(Work(K1) + 1).NextNumber - 1 _
                  THEN K$ = K$ + C0$ + Form4$(3,Work(K1)) + K0$
             NEXT
             TT = 20005
             CALL SendTT
        CASE 7
             '
             ' Incorporate all messages.
             '
             K0$ = o$(6)
             FOR K1 = 1 TO K0
               IF LEN(K$) > 4096 THEN EXIT FOR
               K$ = K$ + C0$ + Form4$(3,Work(K1)) + K0$
             NEXT
             TT = 20005
             CALL SendTT
        CASE 8
             '
             ' List contents of the transfer list.
             '
             TT = 20007
             CALL SendTT
             K1 = 0
             FOR K2 = 1 to K0
               IF StrSrch(1,K$,C0$ + Form4$(3,Work(K2))) > 0 _
                  THEN CALL IntMax(K1,MsgAreaI(Work(K2) + 1).SLen * 100 + 1)
             NEXT
             K5 = 0
             FOR K2 = 1 TO K0
               K0$ = C0$ + Form4$(3,Work(K2))
               K3 = StrSrch(1,K$,K0$)
               IF K3 > 0 _
                  THEN K5 = 1 : _
                       TT$ = o$(8) + Form$(K1,MsgAreaInfo3$(Work(K2) + 1,2)) + _
                             o$(9) : _
                       DO : _
                         K4 = StrSrch2(K3,K$,32) : _
                         TT$ = TT$ + MID$(K$,K3 + 4,K4 - K3 - 3) : _
                         K3 = StrSrch(K4,K$,K0$) : _
                       LOOP UNTIL K3 = 0 : _
                       CALL SendTT
             NEXT
             IF K5 = 0 THEN TT = 20010 : _
                            CALL SendTT
             CALL DispCRLF
             CALL Paused
        CASE 9
             '
             ' Edit the transfer list for a message area.
             '
             K0$ = C0$ + Form4$(3,BaseIndex)
             '
             ' Separate out references to this area.
             '
             K1$ = Null$
             K1 = StrSrch(1,K$,K0$)
             WHILE K1 > 0
               K2 = StrSrch2(K1,K$,32)
               K1$ = K1$ + MID$(K$,K1 + 4,K2 - K1 - 3)
               MID$(K$,K1,1) = C32$         'no need to clear it all out.
               K1 = StrSrch(K2,K$,K0$)
             WEND
             '
             ' Display what was pulled out.
             '
             DO
               TT$ = o$(11) + MsgAreaInfo3$(BaseIndex + 1,2) + o$(12) + _
                     K1$ + o$(14 + (LEN(K1$) = 0))
               K2$ = UCASE$(LineEditTT$(512))
               IF AscNull(K2$) = 63 THEN CALL DispTextBlock(0,5,Null$)
             LOOP UNTIL AscNull(K2$) <> 63 OR NoCarrier
             K1$ = K1$ + C32$ + K2$ + C32$
             '
             ' Analyze our new line and merge it back with K$.
             '
             K1 = StrSrch(1,K1$,o$(15))
             WHILE K1 > 0
               K1$ = MID$(K1$,K1 + 3)
               K1 = StrSrch(1,K1$,o$(15))
             WEND
             FOR K1 = 1 TO WordsCnt(K1$)
               K0$ = WordsGet$(K1$,K1,0)
               FOR KK1 = 1 TO 4
                 IF LEFT$(K0$,3) = MID$(o$(16),KK1 * 3 - 2,3) _
                    THEN K$ = K$ + C0$ + Form4$(3,BaseIndex) + K0$ + C32$ : _
                         EXIT FOR
               NEXT
               IF LEN(K$) > 4096 THEN EXIT FOR
             NEXT
        CASE 10
             '
             ' Let user upload a .REP packet.
             '
             K& = DriveSpc&(Paths$(9)) \ 3
             TT$ = o$(17) + _
                   RTRIM$(Form$(7908,o$(18) + Commas$(K&) + o$(19))) + _
                   o$(20)
             CALL SendTT
             IF K& < Settings.MinULSpace THEN TT = 20021 : _
                                              CALL SendTT : _
                                              CALL Paused : _
                                              TGot = 1 : _
                                              EXIT DO
             CALL AdjustProtocol(User.Protocol)
             K3$ = TT$
             TT$ = o$(65) + RTRIM$(Form$(7908,MID$(K3$,20,34))) + o$(23)
             CALL SendTT
             K1$ = TIME$
             TT$ = Null$
             CALL ShellDosTT(10)
             CALL FileAppendToLog(MID$(K3$,54,40))
             K1 = ElapsedTime(K1$,K3)
             CALL AI(6,Paths$(9) + Short$(957),K1,0,0,0,0,0&,0&)
             CALL ImportRepPackets
             EXIT DO
        CASE 11
             CALL MsgDownload2(K$,K0)
             K0$ = Paths$(9) + o$(43)
             IF FindF2(K0$,FFile) _
                THEN DO: CALL KillFile(Paths$(9) + FFile.FName) : _
                     LOOP UNTIL FindF2(K0$,FFile) = 0
      END SELECT
    LOOP UNTIL NoCarrier
  LOOP UNTIL NoCarrier OR TGot = 1
  BaseIndex = K

END SUB
        '
        '* * * *









'This routine will toggle on/off message bases for a user, or, if the sysop,
'all users.
'NOTE:  Sysops: to change all entries: first change your toggle to what you
'               don't want it to be.  Then select to toggle all, and then
'               all users (including you) will get the opposite of what you
'               have.
        '
        ' Date last checked for perfection:
        '
SUB UserMsgAreasDef

  DO
    CALL DispTextBlock(0,6,Null$)
    IF UserSL = LevelsSize THEN TT = 47 : _
                                K2 = GetYNTT : _
                                CALL DispCRLF _
                           ELSE K2 = 0
    K1 = 1                                       'We don't do the first area.
    K$ = Null$
    FOR BaseIndex = 1 TO BasesSize
      K1 = K1 + 4
      IF LongMid(UserMsgInfo$,K1) = -1 _
         THEN K$ = K$ + Lines$(48) + C0$ _
         ELSE K$ = K$ + MsgAreaInfo3$(BaseIndex + 1,2) + _
                   Short$(587 + (K >= 0)) + C0$      '586 if K >= 0
    NEXT
    TT = 49
    CALL MenuSystem(K$,0)
    IF TGot = 0 THEN EXIT DO
    TGot = TGot * 4 + 1
    K1& = LongMid(UserMsgInfo$,TGot)
    SELECT CASE K1&
      CASE -1   : K0& = -1           'Don't alter locked-out areas.
      CASE 0, 1 : K0& = -2           'Don't create locked-out areas.
      CASE ELSE : K0& = - K1&
    END SELECT
    MID$(UserMsgInfo$,TGot,4) = MKL$(K0&)        'Do for current user.
    SELECT CASE K2
      CASE -1
           '
           ' Do for all users.  High-message-read is preserved.
           '
           K3 = FileOpenW(FileNames(3))
           K1 = LEN(UserMsgInfo$)
           FOR K = 0 TO FileLof&(K3,K1) - 1
             K& = 1& * K * K1 + TGot - 1 
             CALL FileGetLoc(K3,K&,4,K1&)
             K2& = K1&
             SELECT CASE K1&
               CASE -1         'locked out.
               CASE 0, 1 : IF K0& < 0 THEN K1& = -2 'otherwise no change.
               CASE ELSE
                    IF (K1& < 0 AND K0& > 0) OR (K1& > 0 AND K0& < 0) _
                       THEN K1& = - K1&
             END SELECT
             IF K1& <> K2& THEN CALL FilePutLoc(K3,K&,4,K1&)
           NEXT
           CALL FileCloseW(K3)
           TT = 4
           CALL SendTT
    END SELECT
  LOOP UNTIL NoCarrier

END SUB
        '
        '* * * *




'p    message area working with
'p$   string of messages to send (from user)
'p0$  string of messages to send (generated)
'p&   returns with the user's last read value for the area.
'p0   handle for MESSAGES.HDR
'p1   handle for MSGS_xxx.IDX
'
SUB MsgDownload3 (p,p$,p0$,p&,p0,p1)

  K = BitTest(MsgAreaI(p + 1).SubType,2)        'Private/public flag.
  K0 = StrCkSum(User.UserName)
  p& = LongMid(UserMsgInfo$,p * 4 + 1)
  '
  ' Process for each type of command: ALL NEW IR: ER:
  '
  FOR K1 = 1 to 4
    K$ = C0$ + Form4$(3,p) + MID$(o$(16),K1 * 3 - 2,3)
    K2 = StrSrch(1,p$,K$)
    WHILE (K2 > 0) AND (NOT NoCarrier)
      IF K1 = 3 OR K1 = 4 THEN K0$ = WordsGet$(MID$(p$,K2 + 7),1,0) : _
                               K& = StrToNumL&(K0$) : _
                               K0& = Val2&(K0$)
      FOR K3 = 1 TO FileLof&(p1,12)
        IF LEN(p0$) \ 4 >= Settings.DLMsgsMax AND K1 <> 4 THEN EXIT FOR
        CALL FileGetRec(p1,K3,12,MsgIDX)
        K0$ = MKL$(MsgIDX.MsgLoc)
        K4 = 0
        IF K1 <> 1 THEN K5 = StrSrch(1,p0$,K0$)
        SELECT CASE K1
          CASE 2 : IF MsgIDX.MsgNum <= p& THEN K4 = 1
          CASE 3 : IF MsgIDX.MsgNum < K& OR MsgIDX.MsgNum > K0& OR K5 > 0 _
                      THEN K4 = 1      'Ignore including outside K& to K0&.
          CASE 4 : IF MsgIDX.MsgNum < K& OR MsgIDX.MsgNum > K0& OR K5 = 0 _
                      THEN K4 = 1      'Ignore excluding outside K& to K0&.
        END SELECT
        K6 = 0
        IF K1 <> 4 AND K AND K4 = 0 _
           THEN IF K0 = MsgIDX.MsgFrom _
                   THEN K6 = 6 _
                   ELSE IF K0 = MsgIDX.MsgTo THEN K6 = 36 _
                                             ELSE K4 = 1
        IF K6 > 0 _
           THEN K3$ = o$(24) : _
                CALL FileGetSLoc(p0,MsgIDX.MsgLoc + K6,K3$) : _
                IF User.UserName <> K3$ THEN K4 = 1
        IF K4 = 0 _
           THEN IF K1 <> 4 _
                   THEN p0$ = p0$ + K0$ : _
                   ELSE IF K5 <> 0 _
                           THEN p0$ = LEFT$(p0$,K5 - 1) + MID$(p0$,K5 + 4)
      NEXT
      IF K1 = 1 OR K1 = 2 THEN K2 = 0 _
                          ELSE K2 = StrSrch(K2 + 1,p$,K$)
      IF K1 = 1 THEN K1 = 3
    WEND
  NEXT

END SUB
        '
        '* * * *




' actually send them messages.
'
'p$ contains the messages-to-use info string
'p contains the number of areas being used
'  Work() contains the area numbers.
SUB MsgDownload2 (p$,p)

  TT = 20025
  CALL SendTT
  CALL TGet(o$(66) + C13$)
  K = TGot
  IF K < 14 THEN TT = 20027 : _
                 CALL SendTT : _
                 EXIT SUB
  K& = DriveSpc&(Paths$(9)) \ 3   'Extra (beyond 1/2) because we don't
                                  'include the header sizes as we go
                                  'calculate.
  IF K& > Settings.MaxDLMsgsSize AND Settings.MaxDLMsgsSize > 0 _
     THEN K& = Settings.MaxDLMsgsSize
  TT$ = o$(K) + Commas$(1& * Settings.DLMsgsMax) + o$(28) + Commas$(K&) + o$(29)
  CALL SendTT
  K1 = 0                      'Max length of titles counter.
  FOR K2 = 1 TO p
    IF StrSrch(1,p$,C0$ + Form4$(3,Work(K2))) > 0 _
       THEN CALL IntMax(K1,MsgAreaI(Work(K2) + 1).SLen * 100 + 1)
    FWork(K2).FSize = 0
  NEXT
  K2 = 0                      'Total messages counter.
  K10 = 0                     'Next record for .QWK file.
  '
  ' Build MESSAGES.TXT.
  '
  K4 = FileOpenW(FileNames(2))
  K5 = FileOpenR(FileNames(73))
  SELECT CASE K
    CASE 49 : K21 = FileOpenW(Paths$(9) + o$(30))
    CASE 50 : K21 = FileOpenW(FileNames(80))
    CASE 51 : K21 = FileOpenW(FileNames(80))
  END SELECT
  FOR K6 = 1 TO p
    IF NoCarrier THEN EXIT FOR
    K$ = Null$               'Messages to store.
    K7 = FileOpenR(Form4$(10,Work(K6) + 1))
    CALL MsgDownload3(Work(K6),p$,K$,K0&,K4,K7)
    K8 = LEN(K$) \ 4
    SELECT CASE K8
      CASE IS > 0
           '
           ' Actually store the messages.
           '
           IF K = 49 THEN K20 = FileOpenW(Paths$(9) + Form4$(3,K6) + o$(31))
           K1& = 0                   'Total size used for this area counter.
           TT$ = o$(11) + Form$(K1,MsgAreaInfo3$(Work(K6) + 1,2)) + o$(12)
           CALL SendTT
           K30$ = MsgAreaInfo3$(Work(K6) + 1,1)
           CALL ShowMeter(-1& * K8)
           FOR K9 = 0 TO K8 - 1
             IF K2 < 0 OR NoCarrier THEN EXIT FOR
             K2& = LongMid(K$,K9 * 4 + 1)
             K2 = K2 + 1
             SELECT CASE K
               CASE 49 : CALL BuildQWKFile(K2&,K2,p,K21,K10,K6,K4,K5,K0$,K20)
               CASE 50 : CALL DispMessage(K2&,-3,Null$,K4,K5,K0$,K21,K30$)
               CASE 51 : CALL DispMessage(K2&,3,Null$,K4,K5,K0$,K21,K30$)
             END SELECT
             K1& = K1& + LEN(K0$)
             IF K2 >= Settings.DLMsgsMax THEN K2 = -1
             IF K& <= K1& OR K10 > 32000 THEN K2 = -1
             CALL ShowMeter(1& * K9 + 1)
             IF TGot > 0 THEN EXIT FOR
             IF Message.MsgNum > K0& THEN K0& = Message.MsgNum
           NEXT
           IF K = 49 THEN CALL FileCloseW(K20)
           TT$ = o$(33 + (K1 > 5001))
           IF K9 > 0 _
              THEN TT$ = TT$ + STR$(K9) + o$(35 + (K9 = 1)) + _
                         Commas$(K1&) + o$(36)
           IF K2 = -1 THEN TT$ = TT$ + o$(37) : _
                           K2 = -2
           IF K2 = -2 _
              THEN TT$ = TT$ + C32$ +  IntToStr$(K8 - K9) + _
                         o$(39 + (K8 - K9 = 1))
           CALL SendTT
           CALL DispCRLF
           K& = K& - K1&
           FWork(K6).FSize = K0&
    END SELECT
    CALL FileCloseR(K7)
  NEXT
  CALL FileCloseW(K4)
  CALL FileCloseR(K5)
  CALL FileCloseW(K21)
  '
  ' Archive MESSAGES.TXT into MESSAGES.QWK/ZIP and send it.
  '
  TT = 20040
  CALL SendTT
  IF NoCarrier THEN EXIT SUB
  K$ = o$(42 + (K = 49))
  TT$ = RTRIM$(FileNames(30)) + o$(44) + Paths$(9) + K$ + C32$ + Paths$(9) + _
        o$(43)
  CALL ShellDosTT(8)
  IF FindF(Paths$(9) + K$,FFile) = 0 THEN TT = 20045 : _
                                          CALL SendTT : _
                                          EXIT SUB
  TT$ = o$(46) + K$ + o$(47) + Commas$(FFile.FSize) + o$(48)
  IF NOT GetYNTT THEN EXIT SUB
  CALL BuildFnamesCtl(Paths$(9) + K$)
  CALL AdjustProtocol(User.Protocol)
  K1$ = TT$
  TT$ = o$(52) + RTRIM$(Form$(7908,MID$(TT$,20,34))) + o$(53)
  K1 = -2
  CALL ShellDownload(K1)
  TT$ = K1$
  CALL FileAppendToLog(MID$(TT$,54,40))
  SELECT CASE K1
    CASE -1
         p$ = Null$
         FOR K1 = 1 TO p
           IF FWork(K1).FSize > 0 _
              THEN MID$(UserMsgInfo$,Work(K1) * 4 + 1,4) = MKL$(FWork(K1).FSize)
         NEXT
         SumLog.MsgsDownloaded = SumLog.MsgsDownloaded + K2
  END SELECT

END SUB
        '
        '* * * *




           ' Store the message in .QWK format.
'p  current message counter (1..n).
'p0 number of message areas the user has access to/toggled ON.
'p1 handle for MESSAGES.DAT.
'p2 next record to write to in MESSAGES.DAT.
'p3 message area offset in Work() working on.
'p4 handle of already-opened MESSAGES.HDR.
'p5 handle of already-opened MESSAGES.BDY.
'p& location in MESSAGES.HDR of message.
'p$ returns with text from the message.
'p6 handle of already-opened xxx.NDX file.
SUB BuildQWKFile (p&,p,p0,p1,p2,p3,p4,p5,p$,p6)

  CALL FileGetLoc(p4,p&,136,Message)
  p$ = SPACE$(Message.NumOfBytes)
  CALL FileGetSLoc(p5,Message.MsgLoc,p$)
  IF BitTest(Message.Attr,2) THEN CALL UnSq2(p$)
  CALL ExpandFileMsgs(p$,Settings.Sysop)
  p$ = p$ + C13$
  CALL StripExtras(p$)
  CALL ReplaceCharacters(p$,0,Null$,62)
  CALL ReplaceCharacters(p$,13,Null$,227)
  SELECT CASE p
    CASE 1
         '
         ' With the first message, write out the control files.
         '
         K = FileOpenW(Paths$(9) + o$(54))
         CALL MakeFileFromBlock(K,2,47)
         K$ = DATE$ + o$(55) + TIME$ + C1310$ + RTRIM$(User.UserName) + _
              C1310$ + C1310$ + o$(56) + C1310$ + o$(56) + C1310$ + _
              IntToStr$(p0 - 1) + C1310$
         CALL FilePutSEnd(K,K$)
         FOR K0 = 1 TO p0
           K$ = IntToStr$(K0) + C1310$ + _
                StripAnsi$(MsgAreaInfo3$(Work(K0) + 1,2)) + C1310$
           CALL FilePutSEnd(K,K$)
         NEXT
         K$ = o$(57) + C1310$ + o$(58) + C1310$ + o$(59) + C1310$
         CALL FilePutSEnd(K,K$)
         CALL FileCloseW(K)
         K = FileOpenW(Paths$(9) + o$(60))
         CALL MakeFileFromBlock(K,2,46)
         CALL FileCloseW(K)
         CALL CopyFile(0,FileNames(102),Paths$(9) + o$(57))
         K = FindF(RTRIM$(FileNames(23)) + o$(61),FWork(1))
         SELECT CASE K
           CASE IS <> 0
                K0 = 1
                DO : K0 = K0 + 1
                LOOP UNTIL FindF(Null$,FWork(K0)) = 0
                CALL FWorkSort(K0 - 1)
                K$ = LEFT$(FileNames(23),StrSrchR(FileNames(23),92))
                K2 = FileOpenW(Paths$(9) + o$(58))
                FOR K = 1 TO K0 - 1
                  CALL FilePutSEnd(K2,MID$(o$(62),5) + C1310$)
                  K1 = FileOpenR(K$ + FWork(K).FName)
                  K& = 0
                  K0$ = FileGetLine$(K1,K&)        'Get us past the date line.
                  WHILE K& > 0
                    CALL FilePutSEnd(K2,FileGetLine$(K1,K&) + C1310$)
                  WEND
                  CALL FileCloseR(K1)
                NEXT
                CALL FileCloseW(K2)
         END SELECT
         CALL Quote(1)
         K$ = LEFT$(PID + o$(63) + CopyRight + SPACE$(128),128)
         CALL FilePutSEnd(p1,K$)
         p2 = 2
         QWKRec.Status2 = Chars$(225)
  END SELECT
  K0 = LEN(p$) \ 128 + 1
  QWKRec.MsgNum     = IntToStr$(p)
  QWKRec.DateSent   = IntToDate2$(Message.MsgDateSent)
  QWKRec.TimeSent   = IntToTime$(Message.MsgTimeSent)
  QWKRec.MsgTo      = Message.MsgTo
  QWKRec.MsgFrom    = Message.MsgFrom
  QWKRec.MsgSubject = UnSq$(Message.MsgSubject)
  QWKRec.MsgNum2    = LongToStr$(Message.MsgNum)
  QWKRec.NumRecs    = IntToStr$(K0 + 1)
  QWKRec.IDXNum     = p3                        'The area in their 1..n list.
  IF BitTest(MsgAreaI(Work(p3) + 1).SubType,2) _
     THEN K1 = 43 + (Message.MsgDateRcvd = 0) _
     ELSE IF Message.MsgDateRcvd <> 0 THEN K1 = 32 _
                                      ELSE K1 = 45
  QWKRec.Status = Chars$(K1)
  CALL FilePutRec(p1,p2,128,QWKRec)
  CALL FilePutSEnd(p1,LEFT$(p$ + SPACE$(128),K0 * 128))
  K1 = 152
  K& = p2
  WHILE K& < 8388608& AND K& > 0
    K& = K& * 2
    K1 = K1 - 1
  WEND
  K$ = MKL$(K&)
  K2 = IntMid(K$,3)
  CALL BitClear(K2,8)
  K$ = LEFT$(K$,2) + LEFT$(MKI$(K2),1) + Chars$(K1) + Chars$(p3)
  CALL FilePutSEnd(p6,K$)
  p2 = p2 + K0 + 1

END SUB



SUB ImportRepPackets

  K = 0
  FOR K0 = 0 TO BasesSize
    IF MAccessAllowed(K0) THEN K = K + 1 : _
                               Work(K) = K0
  NEXT
  Message.MsgFrom = User.UserName
  Message.Attr2 = 0
  Message.SourceAddr = Null$
  Message.DestAddr = Null$
  K0$ = SPACE$(128)
  K0 = 0
  WHILE FindF2(Paths$(9) + Short$(957),FFile)
    TT$ = Lines$(84) + RTRIM$(FFile.FName) + Short$(253)
    CALL SendTT
    K2$ = FFile.FName
    K1$ = DoPaths$(13)
    CALL ReplaceStrings(K1$,Short$(147),K2$)
    TT$ = ExpandStr$(K1$)
    CALL ShellDosTT(9)
    CALL KillFile(Paths$(9) + K2$)
    WHILE FindF2(Paths$(9) + Short$(958),FFile)
      TT$ = Lines$(29) + RTRIM$(FFile.FName) + Short$(435)
      CALL SendTT
      K1$ = Paths$(9) + FFile.FName
      K1 = FileOpenR(K1$)
      K& = FileLof&(K1,1)
      K2$ = Null$
      K0& = 128
      WHILE K0& + 128 < K&
        CALL FileGetSLoc(K1,K0&,K0$)
        Message.MsgTo = MID$(K0$,22,25)
        Message.MsgSubject = MID$(K0$,72,25)    'So small, no need to Sq$.
        IF CommPort = 0 OR User.UserName = Settings.Sysop _
           THEN Message.MsgFrom = MID$(K0$,47,25)
        K2 = IntMid(K0$,124)
        IF K2 > K OR K2 < 0 THEN K2 = 1         'Default to Private Mail.
        Message.MsgBase = Work(K2)
        TT$ = Lines$(85) + NCR$(Message.MsgTo) + Lines$(86) + _
              RTRIM$(Message.MsgSubject) + Lines$(87) + _
              MsgAreaInfo3$(Message.MsgBase + 1,2) + C1310$
        CALL SendTT
        K0 = K0 + 1
        FOR K3 = 1 TO Val2&(MID$(K0$,117,6)) - 1
          K0& = K0& + 128
          IF K0& >= K& THEN EXIT FOR
          CALL FileGetSLoc(K1,K0&,K0$)
          IF LEN(K2$) < 8000 THEN K2$ = K2$ + K0$
        NEXT
        K2 = LEN(K2$)
        K3 = AscMid(K2$,K2)
        WHILE (K3 = 0 OR K3 = 32) AND K2 > 1
          K2 = K2 - 1
          K3 = AscMid(K2$,K2)
        WEND
        K2$ = LEFT$(K2$,K2) + C13$
        CALL ReplaceStrings(K2$,Chars$(227) + Chars$(227),C13$ + C32$ + Chars$(227))
        CALL ReplaceStrings(K2$,Chars$(227),C13$)
        Message.Attr = 0
        K3$ = K2$
        CALL StrXLate(K3$,GlobalStuff$(15))
        IF LEN(RTRIM$(K3$)) = 0 THEN K2$ = Sq$(K2$) : _
                                     CALL BitSet(Message.Attr,2) _
                                ELSE K3$ = Null$
        CALL AddAMessage(0,K2$,0,0)
        K2$ = Null$
        K0& = K0& + 128
      WEND
      CALL FileCloseR(K1)
      CALL KillFile(K1$)
    WEND
  WEND
  IF K0 = 0 THEN TT = 54 : _
                 CALL SendTT
  CALL Paused

END SUB

