' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'
'
' Various statistical routines:
'   Hourly
'   Profile
'   ProfileMsgs
'   ProfileSLs
'   StatsCalc
'   StatsDisp
'   UserHistory





        '* * * * * *
        ' This routine will display the hourly usage graph.
        '
        ' p  0 for block output
        '    1 for numeric output
        '
        ' Do a check for TGot$ = 'T' and send '[0m' after calling
        ' this routine.
        '
        ' Date last checked for perfection: Sep 2 1992 
        '
SUB Hourly (p)

  CALL BlockToO(0,41)
  K2$ = o$(18)
  K5 = -4
  K6 = -3
  K9 = -23
  FOR K = 1 TO 8
    K9 = K9 + 24
    K5 = K5 + 5
    K6 = K6 + 4
    K$ = MID$(Settings.HourlyData,K9,24)
    K2$ = K2$ + MID$(o$(3),K5,5) + o$(5)
    '
    ' Build a 24 hour line (actually 2 lines).
    '
    K0$ = Null$
    K1$ = Null$
    FOR K0 = 1 TO 24
      K2 = AscMid(K$,K0)
      IF K2 < 1 OR K2 > 60 _
         THEN K0$ = K0$ + o$(6) : _
              K1$ = K1$ + o$(6) _
         ELSE K4 = (K2 - 1) \ 15 + 1 : _
              K1$ = K1$ + o$(7) : _
              IF p = 0 THEN K0$ = K0$ + o$(9 + K4) _
                       ELSE K0$ = K0$ + o$(13 + K4) + Form4$(9,K2)
              IF K4 = 3 OR K4 = 4 THEN K0$ = K0$ + o$(8)
    NEXT
    K2$ = K2$ + K0$ + o$(9) + MID$(o$(4),K6,4) + o$(1) + K1$ + o$(9)
  NEXT
  K2$ = K2$ + o$(19)
  CALL SendIt(K2$)
  CALL Paused

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine handles displaying of information about another
        ' user.
        '
        ' K8  exit's with -1, if no user to look at, or [Enter] pressed
        '     in middle of ProfileMsgs--which means do not do a Paus.
        '
        ' Date last checked for perfection: Mar 5 1993
        '
SUB Profile (K8)

  TT = 160
  LESpecial = 9
  K = GetUserNameTT
  LESpecial = 0
  IF K < 1 THEN K8 = -1 : _
                EXIT SUB
  K3 = FileOpenR(FileNames(3))
  K = BiSearch(5,0,AnyUser.UserName)
  K$ = UserMsgInfo$
  CALL FileGetSLoc(K3,1& * (K - 1) * LEN(K$),K$)
  CALL FileCloseR(K3)
  SWAP User,AnyUser
  User.Attr = AnyUser.Attr
  User.Toggles = AnyUser.Toggles
  CALL DispFile(FileNames(66),C13$)
  CALL Paused
  CALL DispFile(FileNames(67),C13$)
  CALL Paused
  SWAP User,AnyUser
  CALL ProfileSLs(1,K8)
  IF K8 <> -1 THEN CALL Paused : _
                   CALL ProfileMsgs(K$,1,K8) _
              ELSE K8 = 1 : _
                   CALL ProfileMsgs(K$,1,K8)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine summarizes how many messages the user has read
        ' in all the message bases.
        '
        ' p$  NULL means use UserMsgInfo$, otherwise use this.
        '     (p$ will get changed).
        '
        ' p   1 if we're looking at someone else's stats.
        '     anything else if we're looking at the user's stats.
        '
        ' p0  returns -1 if [Enter] hit while displaying, otherwise
        '     not changed.
        '
        ' Date last checked for perfection: Sep 3 1992
        '
SUB ProfileMsgs (p$,p,p0)

  CALL BlockToO(0,42)
  IF LEN(p$) = 0 THEN p$ = UserMsgInfo$
  TT = 20001
  CALL SendTT
  IF TGot > 0 THEN p0 = -1 : _
                   EXIT SUB
  K0 = 0
  FOR K1 = 1 TO BasesSize
    IF MAccessAllowed(K1) THEN CALL IntMax(K0,MsgAreaI(K1 + 1).SLen)
  NEXT
  IF K0 > 31 THEN K0 = 31
  IF UserSL = LevelsSize THEN K3 = 0 _
                         ELSE K3 = 1
  K4 = -3 + K3 * 4
  FOR K1 = K3 TO BasesSize
    K4 = K4 + 4
    K& = LongMid(p$,K4)
    IF NOT MAccessAllowed(K1) THEN K& = -1
    SELECT CASE K&
      CASE IS >= 0
           K2 = FileOpenR(Form4$(10,K1 + 1))
           K6 = FileLof&(K2,12)
           K5 = K6     'K5 = the number of messages that are not new.
           SELECT CASE K5
             CASE IS > 0
                  DO
                    CALL FileGetRec(K2,K5,12,MsgIDX)
                    IF K& >= MsgIDX.MsgNum THEN EXIT DO
                    K5 = K5 - 1
                  LOOP UNTIL K5 = 0
           END SELECT
           CALL FileCloseR(K2)
           IF K5 = K6 THEN K1$ = o$(6) _
                      ELSE IF K5 = 0 THEN K1$ = o$(3) _
                                     ELSE K1$ = Commas$(1& * K5)
           TT$ = MsgAreaInfo3$(K1 + 1,2)
           IF MsgAreaI(K1 + 1).SLen > K0 _
              THEN TT$ = StripLeft$(TT$,K0 - 3) + o$(4)
           TT$ = o$(5) + Form$(K0 * 100 + 2,TT$) + o$(9) + _
                 Commas$(1& * K6) + o$(8 + (p = 1))  + K1$ + o$(2)
           CALL SendTT
           IF TGot > 0 THEN p0 = -1 : _
                            EXIT FOR
    END SELECT
  NEXT

END SUB
        '
        '* * * *



        '* * * * * *
        ' This routine displays a screen summarizing how the user
        ' compares with the averages of the users in the other SL
        ' ranges.
        '
        ' p  1 if we're looking at someone else's stats.
        '    anything else if we're looking at the user's stats.
        '
        ' p0 returns with -1 if [Enter] hit while displaying, otherwise
        '    not changed.
        '
        ' The average of the SL range to which the user belongs has
        ' the user's own stats subtracted from the totals before
        ' displaying.
        '
        ' The totals are distorted slightly: as the totals represent
        ' the last time 'update stats' was run, and the user's record
        ' represents current values--this is only really noticable
        ' when the SL range has only one user (such as the sysop
        ' range).
        '
        ' Date last checked for perfection: Sep 3 1992
        '
SUB ProfileSLs (p,p0)

  TT$ = Lines$(161) + Short$(106 + (p = 1)) + Lines$(151)
  CALL SendTT
  IF TGot > 0 THEN p0 = -1 : _
                   EXIT SUB
  K4& = 2510 + Settings.StatsSize * 34 * 12
  K1 = 0
  K$ = STRING$(28,0)                                      'Storage.
  FOR K0 = 1 TO LevelsSize
    K5 = 0
    IF K0 < LevelsSize _
       THEN IF Levels(K0).ShowLevel = Levels(K0 + 1).ShowLevel _
               AND UserSL <> LevelsSize _
               THEN K5 = 1
    K4& = K4& + 16
    K5& = K4& + 12 + LevelsSize * 16
    K2 = FileOpenR(FileNames(13))
    FOR K4 = 1 TO 7
      SELECT CASE K4
        CASE 1 : kz& = K4& + 12            'total users/sl
        CASE 2 : kz& = K4& + 8             'total posts/sl
        CASE 3 : kz& = K5&                 'Total UL bytes/SL.
        CASE 4 : kz& = K5& + 4             'Total uploads/SL.
        CASE 5 : kz& = K5& + 8             'Total logons/SL.
        CASE 6 : kz& = K4&                 'Total DL bytes/SL.
        CASE 7 : kz& = K4& + 4             'Total downloads/SL.
      END SELECT
      CALL FileGetLoc(K2,Kz&,4,K0&)
      MID$(K$,k4 * 4 - 3,4) = MKL$(LongMid(K$,k4 * 4 - 3) + k0&)
    NEXT
    CALL FileCloseR(K2)
    IF MappedSL(AnyUser.SecLevel) = K0 THEN K1 = 1 _
                                       ELSE K1 = K1 - 1
    SELECT CASE K1
      CASE 1
           K1 = 9999
           MID$(K$,1,4) = MKL$(LongMid(K$,1) - 1)
           MID$(K$,5,4) = MKL$(LongMid(K$,5) - AnyUser.MsgsPosted - AnyUser.FMsgsPosted - AnyUser.EMsgsPosted - AnyUser.NetMailSent)
           MID$(K$,9,4) = MKL$(LongMid(K$,9) - AnyUser.ULBytes)
           MID$(K$,13,4) = MKL$(LongMid(K$,13) - AnyUser.Uplds)
           MID$(K$,17,4) = MKL$(LongMid(K$,17) - AnyUser.Logons)
           MID$(K$,21,4) = MKL$(LongMid(K$,21) - AnyUser.DLBytes)
           MID$(K$,25,4) = MKL$(LongMid(K$,25) - AnyUser.Dnlds)
    END SELECT
    SELECT CASE K5
      CASE 0
           K& = LongMid(K$,1)
           TT$ = Form2$(9,K&)
           IF K& = 0 THEN K& = 1
           TT$ = Form2$(10,LongMid(K$,5) \ K&) + TT$
           TT$ = Form2$(15,LongMid(K$,9) \ K&) + _
                 Form2$(7,LongMid(K$,13) \ K&) + _
                 Form2$(10,LongMid(K$,17) \ K&) + TT$
           IF UserSL = LevelsSize THEN K5 = Levels(K0).SecLevel _
                                  ELSE K5 = Levels(K0).ShowLevel
           TT$ = Short$(108) + Form$(502,STR$(K5)) + _
                 Form2$(15,LongMid(K$,21) \ K&) + _
                 Form2$(7,LongMid(K$,25) \ K&) + TT$ + C1310$
                 K$ = STRING$(28,0)                                 'Storage.
           SELECT CASE K1
             CASE IS > 1
                  K0& = AnyUser.Dnlds
                  K1& = AnyUser.Uplds
                  K2& = AnyUser.Logons
                  K3& = AnyUser.MsgsPosted + AnyUser.FMsgsPosted + AnyUser.EMsgsPosted + AnyUser.NetMailSent
                  IF UserSL = LevelsSize THEN K5 = AnyUser.SecLevel _
                                         ELSE K5 = Levels(K0).ShowLevel
'                                         ELSE K5 = Levels(UserSL).ShowLevel
                  TT$ = TT$ + Short$(97) + Form$(502,STR$(K5)) + _
                        Form2$(15,AnyUser.DLBytes) + Form2$(7,K0&) + _
                        Form2$(15,AnyUser.ULBytes) + Form2$(7,K1&) + _
                        Form2$(10,K2&) + Form2$(10,K3&) + Short$(110 + (p = 1))
                  K1 = 0
           END SELECT
           CALL SendTT
           IF TGot > 0 THEN p0 = -1 : _
                            EXIT FOR
    END SELECT
  NEXT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine updates the data used for the statistics
        ' screens and fixes the voting numbers in RESULTS (for when
        ' you remove a user who voted, repairs the voting numbers in
        ' RESULTS).
        '
        ' Vote weights are applied to the options, not to the number
        ' of users who voted for that option.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
SUB StatsCalc

  TT = 10799
  CALL SendTT
  FOR K = 0 TO Settings.MaxFilesInDir
    FWork(K).FSize = 0
    Work(K) = 0
  NEXT
  K = FileOpenR(FileNames(115))
  K& = Blocks&(2,43)
  FOR K0 = 9 TO 59
    o$(K0) = FileGetLine$(K,K&)
  NEXT
  CALL FileCloseR(K)
  K$ = Null$
  K0& = 2514
  '
  ' 12 stats screens, 1 total stats screen, and 1 for voting update,
  ' and another for 50 states.
  '
  CALL ShowMeter(-15&)
  FOR K = 0 TO 14
    K6 = FileOpenR(FileNames(1))
    K7 = FileOpenW(FileNames(13))
    CALL ShowMeter(1& * K + 1)
    FOR K0 = 2 TO FileLof&(K6,384)
      CALL FileGetRec(K6,K0,384,AnyUser)
      SELECT CASE BitTest(AnyUser.Attr,1)
        CASE 0
             SELECT CASE K                        
               CASE 0 TO 11
                    SELECT CASE K
                      CASE 0, 6  : K& = AnyUser.DLBytes
                      CASE 1, 7  : K& = AnyUser.Dnlds
                      CASE 2, 8  : K& = AnyUser.ULBytes
                      CASE 3, 9  : K& = AnyUser.Uplds
                      CASE 4, 10 : K& = AnyUser.Logons
                      CASE 5, 11 : K& = AnyUser.MsgsPosted + AnyUser.FMsgsPosted + _
                                        AnyUser.EMsgsPosted + AnyUser.NetMailSent
                    END SELECT
                    K2 = K0
                    FOR K1 = 0 TO Settings.StatsSize - 1
                      SELECT CASE K
                        CASE 0 TO 5
                             IF K& > FWork(K1).FSize _
                                THEN SWAP K&, FWork(K1).FSize : _
                                     SWAP K2, Work(K1)
                        CASE 6 TO 11
                             IF K& < FWork(K1).FSize AND K& <> 0 _
                                AND AnyUser.Logons >= Settings.WorstLogons _
                                AND AnyUser.SecLevel >= Settings.WorstSL _
                                THEN SWAP K&, FWork(K1).FSize : _
                                     SWAP K2, Work(K1)
                      END SELECT
                    NEXT
               CASE 12
                    '
                    'FWork(0).FSize = total DL bytes
                    'FWork(1).FSize = total DL files
                    'FWork(2).FSize = total messages posted
                    'FWork(3...2 + LevelsSize * 4) = bytes, files, msgs, number
                    '                                for each SL
                    'FWork(3 + LevelsSize * 4) = total UL bytes
                    'FWork(4 + LevelsSize * 4) = total UL files
                    'FWork(5 + LevelsSize * 4) = total logons
                    'FWork(6 + LevelsSize * 4...5 + LevelsSize * 8)
                    ' = bytes, files, msgs, number for each SL
                    '
                    K2 = MappedSL(AnyUser.SecLevel)
                    FOR K1 = 0 TO 13
                      SELECT CASE K1
                        CASE 0    : K& = 0       'old total DL bytes field.
                        CASE 1, 4 : K& = AnyUser.Dnlds
                        CASE 2, 5 : K& = AnyUser.MsgsPosted + AnyUser.EMsgsPosted + _
                                         AnyUser.FMsgsPosted + AnyUser.NetMailSent
                        CASE 3    : K& = AnyUser.DLBytes
                        CASE 6, 13 : K& = 1
                        CASE 7, 10 : K& = AnyUser.ULBytes
                        CASE 8, 11 : K& = AnyUser.Uplds
                        CASE 9, 12 : K& = AnyUser.Logons
                      END SELECT
                      SELECT CASE K1
                        CASE 0 TO 2   : K3 = K1
                        CASE 3 TO 6   : K3 = K2 * 4 + K1 - 4
                        CASE 7 TO 9   : K3 = LevelsSize * 4 + K1 - 4
                        CASE 10 TO 13 : K3 = LevelsSize * 4 + K2 * 4 + K1 - 8
                        CASE ELSE
                      END SELECT
                      FWork(K3).FSize = FWork(K3).FSize + K&
                    NEXT
                    K0$ = C32$ + LongToStr$(AnyUser.DLBytes)
                    IF LEN(K0$) > LEN(K$) THEN SWAP K0$, K$
                    K3 = LEN(K$)
                    K0$ = Form$(K3 * 100 + 2,K0$)           'Make same width.
                    K2 = 0                                  'Carry = 0.
                    K1 = K3
                    WHILE K1 > 0
                      K3 = Val2&(MID$(K$,K1,1)) + Val2&(MID$(K0$,K1,1)) + K2
                      K2 = K3 \ 10                          'Whats left = carry.
                      MID$(K$,K1,1) = RIGHT$(C32$ + IntToStr$(K3),1)
                      K1 = K1 - 1
                    WEND
               CASE 13
                    SELECT CASE AnyUser.SecLevel
                      CASE IS >= Settings.CanVoteSL
                           K5 = Levels(MappedSL(AnyUser.SecLevel)).VoteWeight
                           FOR K1 = 1 TO 100
                             K2 = AscMid(AnyUser.Votes,K1)
                             IF K2 > 0 THEN K1& = K1 * 18 - 17 + K2 * 2 - 1 : _
                                            CALL FileGetLoc(K7,K1&,2,K3) : _
                                            CALL FilePutLoc(K7,K1&,2,K3 + K5) : _
                                            K1& = K1 * 18 - 18 : _
                                            CALL FileGetLoc(K7,K1&,2,K3) : _
                                            CALL FilePutLoc(K7,K1&,2,K3 + 1)
                           NEXT
                    END SELECT
               CASE 14
                    '
                    ' Users in 50 states stats.
                    '
                    K$ = AnyUser.CityState
                    K1 = StrSrch1(K$,44)
                    CALL StrXLate(K$,GlobalStuff$(14))
                    IF K1 > 0 THEN K$ = LTRIM$(RTRIM$(MID$(K$,K1))) _
                              ELSE K1 = WordsCnt(K$) : _
                                   IF K1 < 2 THEN K$ = Null$ _
                                             ELSE K$ = WordsGet$(K$,K1,0)
                    K2 = -1
                    SELECT CASE LEN(K$)
                      CASE IS > 1
                           K$ = LEFT$(K$,2) + Chars$(124)
                           FOR K1 = 9 TO 58
                             IF StrSrch(1,o$(K1),K$) > 0 THEN EXIT FOR
                           NEXT
                           Work(K1) = Work(K1) + 1
                           K2 = 0
                    END SELECT
                    IF K2 THEN Work(59) = Work(59) + 1
             END SELECT
      END SELECT
    NEXT
    SELECT CASE K
      CASE 0 TO 11
           '
           ' Store our rankings screens.
           '
           K0$ = SPACE$(30)
           FOR K0 = 0 TO Settings.StatsSize - 1
             IF Work(K0) = 0 _
                THEN K0$ = C1$ + SPACE$(29) _
                ELSE CALL FileGetSLoc(K6,(Work(K0) - 1) * 384&,K0$)
             CALL FilePutSLoc(K7,K0&,K0$)
             CALL FilePutLoc(K7,K0& + 30,4,FWork(K0).FSize)
             K0& = K0& + 34
             Work(K0) = 0
             IF K < 5 OR K = 11 THEN FWork(K0).FSize = 0 _
                                ELSE FWork(K0).FSize = 2100000000&
           NEXT
      CASE 12
           '
           ' Store our totals data.
           '
           FOR K0 = 0 TO 5 + LevelsSize * 8
             CALL FilePutLoc(K7,K0&,4,FWork(K0).FSize)
             K0& = K0& + 4
           NEXT
           '
           ' Store our total downloads.
           '
           K$ = Form$(1501,K$)
           CALL FilePutSLoc(K7,2285&,K$)
           '
           ' Zero out our current voting results.  (100 voting questions
           ' times 20 bytes per question).
           '
           K$ = STRING$(2000,0)
           CALL FilePutSLoc(K7,0&,K$)
      CASE 14
           '
           ' Store the state's totals.
           '
           FOR K0 = 9 TO 59
             CALL FilePutLoc(K7,2001& + (K0 - 9) * 2,2,Work(K0))
           NEXT
    END SELECT
    CALL FileCloseR(K6)
    CALL FileCloseW(K7)
  NEXT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will display the statistics screens.
        '
        ' p  Which screen to show, returns with -1 if aborted midway.
        '
        ' Date last checked for perfection: Sep 14 1992
        '
SUB StatsDisp (p)

  CALL BlockToO(0,43)
  K3 = FileOpenR(FileNames(13))
  kz = FindF(FileNames(56),FFile)
  kz = FFile.FSize \ 32 - 1    '-1 because #NEWUSER stats aren't used.
  SELECT CASE p
    CASE 1 TO 12
         K$ = User.UserName
         CALL FileGetSLoc(K3,2514 + 34& * (p - 1) * Settings.StatsSize,K$)
         K0 = p
         IF p > 6 THEN K0 = K0 - 6
         TT$ = o$(7) + o$(K0) + o$(9 + (K$ = User.UserName))
         CALL SendTT
         K0$ = K$
         K1$ = K$
         FOR K0 = 0 TO Settings.StatsSize - 1
           IF TGot > 0 THEN p = -1 : _
                            EXIT FOR
           K4& = 2480 + (p - 1) * Settings.StatsSize * 34 + K0 * 34
           CALL FileGetSLoc(K3,K4&,K0$)
           CALL FileGetLoc(K3,K4& + 30,4,K0&)
           CALL FileGetSLoc(K3,K4& + 34,K$)
           CALL FileGetLoc(K3,K4& + 64,4,K&)
           CALL FileGetSLoc(K3,K4& + 68,K1$)
           K4& = K4& + 98
           K3$ = o$(10)
           K2$ = o$(11)
           TT$ = o$(12)
           SELECT CASE User.UserName
             CASE K0$
                  IF K0 > 7 THEN K2$ = o$(13) : _
                                 TT$ = o$(14)
             CASE K$
                  K3$ = o$(15)
                  K2$ = o$(16)
                  TT$ = o$(17)
             CASE K1$
                  IF K0 < 10 THEN K2$ = o$(18) : _
                                  TT$ = o$(19)
           END SELECT
           TT$ = o$(20) + Form4$(9,K0 + 1) + K2$ + Form$(3012,K$) + TT$
           SELECT CASE p
             CASE 2, 4, 8, 10
                  TT$ = TT$ + RIGHT$(o$(29) + Commas$(K&) + o$(21),11)
             CASE 5, 6, 11, 12
                  TT$ = TT$ + RIGHT$(o$(29) + Commas$(K&) + o$(22),11)
             CASE 1, 3, 7, 9
                  TT$ = TT$ + RIGHT$(o$(29) + Commas$(K&),11)
           END SELECT
           TT$ = TT$ + o$(23)
           CALL SendTT
         NEXT
         TT$ = o$(24) + K3$ + o$(25) + K3$ + o$(26) + STRING$(90,219) + o$(27)
         IF TGot < 1 THEN CALL SendTT
    CASE 0
         kz$ = STRING$(16,0)
         FOR K = 1 TO 3 + LevelsSize * 2
           SELECT CASE K
             CASE 1
                  K$ = o$(28)
                  CALL FileGetSLoc(K3,2285&,K$)
                  K$ = RTRIM$(K$)
                  K2 = LEN(K$) - 9
                  IF K2 < 0 THEN K2 = 0
                  K4& = 2514 + Settings.StatsSize * 34 * 12
                  CALL FileGetLoc(K3,K4&,4,K&)           'Total DL's (not used).
                  K& = Val2&(LEFT$(K$,LEN(K$) - K2))
                  CALL FileGetLoc(K3,K4& + 4,4,K0&)      'Total DL files.
                  CALL FileGetLoc(K3,K4& + 8,4,K1&)      'Total messages posted.
                  K4& = K4& + 12
                  TT = 88
             CASE 2 TO LevelsSize + 1, 3 + LevelsSize TO 2 + LevelsSize * 2
                  IF K < LevelsSize + 3 THEN K00 = K - 1 _
                                        ELSE K00 = K - LevelsSize - 2
                  kz5 = 0
                  IF K00 < LevelsSize _
                     THEN IF Levels(K00).ShowLevel = Levels(K00 + 1).ShowLevel _
                          AND UserSL <> LevelsSize _
                          THEN kz5 = 1
                  FOR K0 = 1 TO 4
                    CALL FileGetLoc(K3,K4&,4,K2&)
                    K4& = K4& + 4
                    MID$(kz$,K0 * 4 - 3,4) = MKL$(LongMid(kz$,K0 * 4 - 3) + k2&)
                  NEXT
                  SELECT CASE kz5
                    CASE 0
                         IF UserSL = LevelsSize THEN K00 = Levels(K00).SecLevel _
                                                ELSE K00 = Levels(K00).ShowLevel
                         TT$ = o$(22) + Form$(598,STR$(K00)) + o$(30)
                         FOR K0 = 1 TO 4
                           K2& = LongMid(kz$,K0 * 4 - 3)
                           SELECT CASE K0
                             CASE 1 : K0$ = RTRIM$(STR$(K2&))
                                      K1 = LEN(K0$) - K2
                                      IF K1 > 0 THEN K3& = Val2&(LEFT$(K0$,K1))
                                      K1$ = PercentCalc$(K&,K3&)
                                      K1 = 13
                             CASE 2 : K1 = 7
                                      K1$ = PercentCalc$(K0&,K2&)
                             CASE 3 : K1 = 8
                                      K1$ = PercentCalc$(K1&,K2&)
                             CASE 4 : K1 = 7
                                      K3& = kz
                                      K1$ = PercentCalc$(K3&,K2&)
                           END SELECT
                           TT$ = TT$ + Form2$(K1,K2&) + _
                                 Form$(802,LEFT$(K1$,StrSrch1(K1$,46) + 3))
                         NEXT
                         TT$ = TT$ + o$(31)
                         kz5 = 0
                         kz$ = STRING$(16,0)
                    CASE ELSE : TT$ = Null$
                  END SELECT
             CASE 2 + LevelsSize
                  K1$ = o$(32)
                  K0 = LEN(K$)
                  IF K0 > 3 THEN K$ = LEFT$(K$,K0 - 3) + o$(33) + RIGHT$(K$,3)
                  IF K0 > 6 THEN K$ = LEFT$(K$,K0 - 6) + o$(33) + RIGHT$(K$,7)
                  IF K0 > 9 THEN K$ = LEFT$(K$,K0 - 9) + o$(33) + RIGHT$(K$,11)
                  K0 = LEN(K$) + 1
                  TT$ = o$(34) + LEFT$(o$(35),20 - K0) + C32$ + K$ + K1$ + _
                        Form2$(7,K0&) + K1$ + Form2$(8,K1&) + K1$ + _
                        Form$(702,STR$(kz)) + K1$ + o$(36)
                  CALL FileGetLoc(K3,K4&,4,K&)              'Total UL's.
                  CALL FileGetLoc(K3,K4& + 4,4,K0&)         'Total UL files.
                  CALL FileGetLoc(K3,K4& + 8,4,K1&)         'Total Logons.
                  K4& = K4& + 12
                  TT$ = TT$ + Form2$(14,K&) + K1$ + Form2$(7,K0&) + K1$ + _
                        Form2$(8,K1&) + K1$ + Form$(702,STR$(kz)) + K1$ + o$(37)
             CASE 3 + LevelsSize * 2 : TT = 20038
           END SELECT
           CALL SendTT
           IF TGot > 0 THEN p = -1 : _
                            EXIT FOR
         NEXT
  END SELECT
  CALL FileCloseR(K3)

END SUB
        '
        '* * * *



        '* * * * * *
        ' This routine will display all data about them in the
        ' SUMMARY.DAT file.
        '
        ' p  1     for current user
        '    else  ask for a user's name
        '
        ' Date last checked for perfection: Jun 7 1993
        '
SUB UserHistory (p)

  CALL BlockToO(0,44)
  IF p = 1 THEN CALL UpdateSumLog : _
                AnyUser = User _
           ELSE TT = 10283 : _
                CALL SendTT :_
                TT = 20001 : _
                IF GetUserNameTT < 1 THEN EXIT SUB
  TT$ = o$(2) + NCR$(AnyUser.UserName) + o$(17)
  CALL SendTT
  IF TGot > 0 THEN EXIT SUB
  K = FileOpenR(FileNames(26))
  K0 = BiSearch(8,K,MKL$(AnyUser.LastCallerNum))
  K2$ = Null$
  WHILE TGot < 1 AND K0 > 0 AND SumRec.UserName = AnyUser.UserName
    K0$ = IntToDate3$(SumRec.DateOn)
    K3$ = RightTime$(IntToTime$(SumRec.TimeOn))
    K1$ = Form$(802,K3$)
    IF LEN(K2$) = 0 THEN K2$ = K0$ + C32$ + K3$
    TT$ = o$(4) + Form$(665,MID$(K0$,4,3) + C32$ + LTRIM$(LEFT$(K0$,2))) + _
          Form$(666,LEFT$(K1$,5) + MID$(K1$,7,1)) + o$(5) + _
          Form$(566,LongToStr$(SumRec.CallerNum)) + o$(6) + _
          Form$(1365,SumRec.BaudRate) + o$(7) + IntToStr$(SumRec.NodeOn) + _
          C32$ + o$(8) + Form3$(SumRec.TotalMinsUsed) + o$(9)
    TT$ = TT$ + Form$(502,IntToStr$(SumRec.MsgsReadOnLine)) + o$(10) + _
          Form3$(SumRec.MsgsPosted + SumRec.EMsgsPosted + SumRec.FMsgsPosted + _
          SumRec.NetMailSent + SumRec.RamblesMade + SumRec.RamblesAdded) + _
          o$(9) + Form$(502,IntToStr$(SumRec.MsgsDownloaded)) + o$(10) + _
          Form3$(SumRec.MsgsUploaded) + o$(9) + Form3$(SumRec.MsgsRcvd + _
          SumRec.EMsgsRcvd + SumRec.NetMailRcvd) + o$(11)
    TT$ = TT$ + Form4$(9,SumRec.PagedSysop) + o$(12) + Form3$(SumRec.Uplds) + _
          Form$(502,IntToStr$(SumRec.ULBytes \ 1024)) + o$(13) + _
          Form3$(SumRec.Dnlds) + _
          Form$(502,IntToStr$(SumRec.DLBytes \ 1024)) + o$(14) + _
          Form3$(SumRec.Doors) + C1310$
    CALL SendTT
    IF TGot < 1 THEN K0 = BiSearch(8,K,MKL$(SumRec.LastCallerNum))
  WEND
  CALL FileCloseR(K)
  IF TGot > 0 THEN EXIT SUB
  TT = 20015
  CALL SendTT
  IF TGot < 1 AND LEN(K2$) > 0 _
     THEN TT$ = o$(16) + K0$ + C32$ + K3$ + o$(3) + K2$ + C1310$ : _
          CALL SendTT
  CALL Paused

END SUB
        '
        '* * * *

