
; === General setup ===

; +---------------------------------------------+
; |                                             |
; | Maximus File Finder .CTL file               |
; |                                             |
; +---------------------------------------------+
;
; All the keywords have to start at the beginning of the line.
;
; Origin : What to put in the origin
;

Origin MaxFFind @ Koos z'n Doos (03402-56619/36647)

;
; Areafile : Path + Name of area.dat (default= AREA.DAT in current dir)
;

AreaFile H:\BBS\MAX\AREA.DAT

;
; Headerfile : Path + Name of headerfile to put above the result list
;

HeaderFile H:\BBS\MAX\MAXFF.HDR

; MaxSecLevel : Maximum level for areas to be included (default=1)
;
; Twit=-2, Disgrace=0, Limited=1, Normal=2, Worthy=3, Privil=4, Favored=5,
; Extra=6, Clerk=7, AsstSysop=8, Sysop=9

MaxSecLevel   1

; Group definitions
;
; These are evaluated from left to right, entries without a '!' are positive
; and entries with a '!' are negative.
; AM* matches all areas that start with 'AM'
; *,!AM* matches all areas and then deletes all areas that start with 'AM'

;Group Amiga AM*

Group NoAmiga *,!AM*

; A Group 'All' with '*' as group definition is NOT needed, and will slow
; down MaxFF. If you want to use all areas, DO NOT specify a group.

;Group All *

; === Setup specific to FileFinder mode ===

; MaxFinds : Maximum number of finds before search is ended (default=50)

MaxFinds      50

; MinWild : Minumum length of text in wildcard search (default=2)

MinWild       2

; MinSubs : Minimum length of text in substring search (default=2)

MinSubs       2

; Replace file extension on file name searches (TEST.ARJ becomes TEST.*).

ReplaceExtension

; Skip messages that originated locally.

; SkipLocal

; Maximum age (in days) of request.

; MaxRequestAge 7

; Netmail area to reply in. On replies the matching AKA from the area is used.
; Including type (Squish or *.MSG)

NetMail    H:\BBS\MESSAGE\NETMAIL     Squish

; Make netmail replies Kill/Sent so they disappear afterwards

KillSent

; Reply with the query again instead of canned "Your query's results"

; ReplyWithQuery

; Area's to be searched
;

FindArea UNI_ALLFIX
		BaseName        H:\BBS\MESSAGE\UALLFIX
		MsgType         Squish
		Address         77:8405/110
;       NetReply
;       ReplyArea
;       Group           MSDOS
End

FindArea FRE_NL_FILEFIND
		BaseName        H:\BBS\MESSAGE\FALLFIX
		MsgType                 Squish
		Address                 87:100/200
End

FindArea
		BaseName                H:\BBS\MESSAGE\MAXFFTST
		MsgType                 Squish
		Address                 87:100/200
		ReplyArea               H:\BBS\MESSAGE\MAXFFTS2
		ReplyAtype              Squish
End

;

; === Setup specific to Newfiles Announcement mode ===
;
; NewFileFrom : From name used in new files found messages

NewFileFrom A.U. Tomaat

; NewFileTo : To name used in new files found messages

NewFileTo All

; NewFileSubject : Subject used in new files found messages

NewFileSubject New Files found at Koos z'n Doos

; SkipName : Start of filename to skip on searches
;
; It works like a wildcard :
; ALLFILES will skip any file that starts with ALLFILES
; ALL will skip any file that starts with ALL (like ALLFILES and ALLFORE)
; ALL. will skip any file that starts with ALL. (like ALL.TXT and ALL.LST but
; not ALLFILES).
;
; Maximum amount of skipnames : 10

SkipName KZDS_ALL

; Defaultage : Age (days) of new files when last run file is not found or
; invalid.
;

DefaultAge 7

; DontAllowFuture : If set, files with a future date will be skipped

DontAllowFuture

; Areas to announce new files in
; MinFiles : Minimum number of new files to make a newfiles announcement
; if there are not enough files, they will be 'saved up' for the next run

NewFilesArea MaxFF.test
		BaseName  H:\BBS\MESSAGE\MAXFFTST
		MsgType   Squish
		Address   87:100/200
                MinFiles  10
;               Group     MSDOS
End
;

; === Setup specific to Files list generator mode ===

; NewFileAge : Age in days of files to be in the newfiles list. Default : 30

; NewFileAge 30

; FileListHeader : Name of header file to be included on top of allfiles and
; newfiles listings

FileListHeader H:\BBS\MAX\ALLFGEN.HDR
