/***********************************************************************
*                                                                      *
*  Implementation of all the edit stuff                                *
*                                                                      *
*  Purpose : Fullscreen editor functions                               *
*                                                                      *
*  Author  : Peter Bloemendaal                                         *
*            Brainbox systems +31-70-3523661                           *
*  eMail   : internet -> bloemendaal@rullf2.LeidenUniv.nl              *
*            fidonet  -> 2:281/908                                     *
*                                                                      *
*----------------------------------------------------------------------*
*                                                                      *
*  Modified by Phil Ward                                               *                     *
*           Nytech Software Design                                     *
*                                                                      *
*                                                                      *
* $Log: edit.cpv $
// Modification  Dec 23, 1994  14:44:12 UTC +5  Nytech Software Design
// Added the Append File routine 
//
// Revision 1.4  1994/09/08  08:36:27  BRAINBOX
// 1. Removed most #if 0 statements put in by I_A and beatified source
//
// Revision 1.3  1994/09/06  18:56:13  BRAINBOX
// 1. Bounce checked by I_A
//
// Revision 1.2  1994/08/25  20:04:34  BRAINBOX
// rcsco edit.cpp
//
// Revision 1.1  1994/08/23  21:56:12  BRAINBOX
// Initial revision
//
*                                                                      *
************************************************************************
*/

// I_A: all txtlength /* strlen(txt) */  has been replaced by 'txtlength /* txtlength /* strlen(txt) */  */' ...

#ifndef _EDIT_CPP
#define _EDIT_CPP

#ifndef _PB_SDK_H
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#endif

#include "key_def.h"
#include "edit_glb.h"


#include "INPUT.CPP"
#include "OUTPUT.CPP"
#include "EDIT.HPP"

// Copy the current screen to the old screen
void Edit::copyScreen(void)
{
	 register int i ;

	 for (i = 0 ; i < height ; i++)
      memcpy(oldScreen[i],curScreen[i], width+1) ; // I_A: memcpy() is faster than strcpy()
}

int Edit::setMargins(int top, int bottom, int tops, int bots)
{
   if (top + bottom + 1 >= width)
      return 1 ;
   if (top <= tops || bottom <= bots)
      return 1 ;

   topMargin    = top ;
   bottomMargin = bottom ;
   topSens      = tops ;
   bottomSens   = bottom ;
   return 0 ;
}


// Add a character in the edit box at the currect position
void Edit::addchar(char ch)
{

   if(!c_fEditable) return;

   if (insertmode)
	 {
     if (txtlength /* strlen(txt) */  + (_BLOCK/2) > memmaltxt)
     {
        if(memmaltxt == 0xFFFF) {
           err = TRUE;
           return;
        }
        // realloc more memory
        if(memmaltxt > 0xFFFF - _BLOCK ) {
           memmaltxt = 0xFFFF;
				} else {
           memmaltxt += _BLOCK ;
		}
        // I_A: since I had to fix this code anyway, strtcols memory has become indepentdant of 'txt'
        if ( (txt = (unsigned char*) realloc(txt, memmaltxt)) == NULL)
           err = 1 ;
     }
     memmove(txt+curpos+1, txt+curpos, txtlength /* strlen(txt) */  - curpos + 1); // +1 for traling '\0'
     txtlength++;  // I_A: update length
     txt[curpos++] = ch ;
   }
   else         // Insert mode is false
   {
      if (curpos == txtlength   )
      {
         if (txtlength  + (_BLOCK/2) > memmaltxt)
         {
            // realloc more memory
            memmaltxt += _BLOCK ;
            if ( (txt = (unsigned char*) realloc(txt, memmaltxt)) == NULL)
               err = 1 ;
         }
				 txt[curpos++] = ch ;
		 txt[curpos] = '\0' ;
         txtlength++; // I_A: update length...
      } else
         txt[curpos++] = ch ;
   }
}

// Delete the character before the current position
void Edit::backspace(void) // actually backspace()
{
	 if(!c_fEditable) return;

   if (curpos != 0) {
      if (insertmode) {
         register char *txtp = txt + curpos;
         memmove(txtp-1,txtp, txtlength - curpos +1) ; // +1 for trailing '\0'
         curpos--;
         txtlength--;
      } else {
         txt[--curpos] = ' ' ;
      }
   }
}

// Delete the character at the current position
void Edit::delpos(void)
{
   if(!c_fEditable) return;

   {
   register char *txtp = txt + curpos;

   if (curpos == txtlength)
      return ;
   memmove(txtp, txtp + 1, txtlength - curpos) ; // seems to be ok!
   }
   txtlength--;
}


void Edit::cursorDown(void)
{
   register unsigned short newpos; // I_A: unsigned unsigned short newpos; ???
   register unsigned short i ;

	 newpos = strtcols[lincur+1] ;
   if (newpos < txtlength )
   {
      for  (i = newpos ; i <= strtcols[lincur+2] && txt[i] != '\n'
         && i < txtlength   && i - newpos < colpos ; i++)
         ;
      if (txt[i] == '\n' && txt[i+1] == '\n' )
         i++ ;
      curpos = i ;
	 }
}


void Edit::cursorUp(void)
{
   register unsigned short i ;
   if (linpos)
   {

      register unsigned int lincurpos_1 = strtcols[lincur-1];
      register unsigned int lincurpos_0 = strtcols[lincur];

      for (i = lincurpos_1 ; i <= lincurpos_0 && txt[i] != '\n'
         &&  i - lincurpos_1 < colpos ; i++)
            ;

      if (txt[i] == '\n' && txt[i+1] == '\n' && i != 0)
         i++ ;
      curpos = i ;
   }
}

void Edit::pagedown(void)
{
   register int right ;

   right = curpos - strtcols[lincur]  ;
	 curpos = strtcols[min(linmax,lincur + height)] ;
   for ( ; txt[curpos] != '\n' && txt[curpos] != '\0' && right ; right--)
	  curpos++ ;
}

void Edit::pageup(void)
{
   register int right ;

	 right = curpos - strtcols[lincur]  ;
	 curpos = strtcols[max(0,lincur - height)] ;
   for ( ; txt[curpos] != '\n' && txt[curpos] != '\0' && right ; right--)
      curpos++ ;
}

// Newline
// Implemented to override for special occasions
void Edit::newline(void)
{
   if(!c_fEditable) {
      cursorDown();
   } else {
      addchar('\n') ;
   }
}

// Cursor Home
void Edit::home(void)
{
	 curpos = strtcols[lincur] ;
}

// Cursor End
void Edit::end(void)
{
   register unsigned short i ;
   register unsigned int lincurpos_1 = strtcols[lincur+1];

   for (i = strtcols[lincur] ; i < lincurpos_1 - 1
      && i < txtlength /* strlen(txt) */  ; i++)
      ;
   if (txt[i+1] == '\n')
         i++ ;
   curpos =  i ;
}

void Edit::deleteLine(void)
{
   unsigned short start, end ;

   if(!c_fEditable) return;

   if (curpos == txtlength)
      return ;
   start = strtcols[lincur] ;
	end   = strtcols[min(linmax,lincur+1)] ;
   if (lincur == linmax)
      end = strlen(txt) ;
   if (start != end)  // I_A added condition
   {
      memmove(txt+start, txt+end, strlen(txt)-end+1) ;  // I_A: changed (optimized strlen())
      txtlength -= end - start;
      curpos = strtcols[lincur] ;
   }
   else
   {
      this->delpos() ;
      curpos = strtcols[lincur]+1 ;

   }
}

void Edit::deleteWord(void)
{
   register unsigned short i ;

   if(!c_fEditable) return;

   for (i = curpos ; i <= txtlength  && txt[i] != ' ' && txt[i] != '\n' ; i++)
      ;
   // I_A: memmove() optimized (strlen())
   memmove(txt+curpos,txt + i + 1, strlen(txt + i + 2)) ; // +1 for trailing '\0'
   txtlength -= i + 1 - curpos;
}

// Calculate the line and column number from which the
// virtual screen starts displaying its text!
// Calculate the value of variables to position the virtual window
// later and position the cursor in the virtual window.
//
// strtcols[]  array to integers holding first position of a line
// lincur      line in the text (a strtcol[]) at which the cursor stands
// linorg      first line in virtual window
// curpos      position in the txt of the cursor
// linpos      line postion of the cursor in the virtual window
// colpos      column position of the curosr in the virtual window
//
// lin         line counter
// col         column counter
// lastspace   position in txt of the last space (used for word wrapping)
//
// This routine is the speed bottleneck of this program
//
void Edit::calculateLineColumn(void)
{
	 unsigned short lin, col, linorg, lastspace,
									startline, startpos ;
	 register unsigned short i ;
//	 unsigned short linlast; // I_A added
    unsigned short i_limit;

	 col = lastspace = 0 ;
	 linpos = colpos = -1 ;
	 strtcols[0] = 0 ;

   // Calculate start line and position, so not the whole text has to be
	// calculated. This works because the maximal cursor displacement is height
   startline = max(0,lincur - height) ;
   if (startline >= memmalint)
   {
#ifdef DEBUG
      printf("%d[%s] >>> reallocating strtcol[] array.\n", __LINE__, __FILE__);
#endif
      if ( (strtcols = (unsigned int*) realloc(strtcols, (memmalint = startline + STRTCOLS_INCREMENT) * sizeof(*strtcols))) == NULL)
      {
         printf("out of memory allocating index array\n");
         exit(1);
      }
   }
   startpos  = strtcols[startline] ;
	lin = startline ;
//	linlast = lin + height * 2; // I_A added

	// Browse the text from the starting point height*width after curpos is reached
	 // I_A: 'invariant code motion' (wat een kreet! wow!) 'curpos + height*width does not change inside loop: optimize!
	for (i=startpos, i_limit = curpos + height*width ;
        txt[i] != '\0' && i < i_limit;
				i++)
   {
      if (txt[i] == '\n' || col >= width )// Cursor has to go to the next line
		{
		   col = 0 ;
		   if ( i == curpos)
			     linpos = lin ;
		   if (txt[i] != ' ' && txt[i] != '\n' && lastspace != 0 )
																		     // Wrapping of words are needed!
		   {
			     col = width - lastspace - 1 ; // Calculate new column
			     if (i - (width - lastspace) < curpos && i >= curpos && linpos != -1)
					   linpos++ ;                 /* If curpos was in wrapped part,
																				   increase linposition           */
		   }
		   lin++ ;
      if (lin >= memmalint)
      {
#ifdef DEBUG
         printf("%d[%s] >>> reallocating strtcol[] array.\n", __LINE__, __FILE__);
#endif
         if ( (strtcols = (unsigned int*) realloc(strtcols, (memmalint += STRTCOLS_INCREMENT) * sizeof(*strtcols))) == NULL)
         {
            printf("out of memory allocating index array\n");
            exit(1);
         }
      }
   	if (col != 0 || txt[i] != ' ' || txt[i-1] == ' ' )
		   if (txt[i] == '\n')
   		   strtcols[lin] = i ;
			else
			   strtcols[lin] = i - col++ ;
				lastspace = 0 ;
		}
		else
		{
		   if (txt[i] == ' ')
			     lastspace = col ;
		   if ( i == curpos)
			     linpos = lin ;
		   if ( txt[i] != ' ' || col != 0 || lin == 0 || txt[i-1] == ' ' )
            strtcols[lin] = i - col++ ;
      }
   }  // Next i

   if (lin+2 >= memmalint)
   {
#ifdef DEBUG
      printf("%d[%s] >>> reallocating strtcol[] array.\n", __LINE__, __FILE__);
#endif
      if ( (strtcols = ( unsigned int*) realloc(strtcols, (memmalint += STRTCOLS_INCREMENT) * sizeof(*strtcols))) == NULL)
      {
         printf("out of memory allocating index array\n");
         exit(1);
	  }
   }
   strtcols[lin+1] = MAXINT ;
	strtcols[lin+2] = MAXINT ;
	linmax = lin ;

	// Calculate the column position
	if (linpos == - 1)
		linpos = lin ;
	colpos = curpos - strtcols[linpos] ;
	if (txt[curpos-1] == '\n' && linpos > 0)
	   colpos = max(0,curpos - strtcols[linpos] - 1);

	// Remember the actual position of the line in the text of the cursor
	lincur = linpos ;

	// Calculate the virtual window position
   for (linorg = 0 ; linorg <= lin ; linorg++)
	   if (strtcols[linorg] == virorg)
      break ;
   if (linorg == lin)
	  linorg = 0 ;

   if (linpos < linorg + topSens)
		virorg = strtcols[max(0,linpos - topMargin + 1)] ;
	if (linpos + bottomSens > linorg + height)
		virorg = strtcols[max(0,linpos - (height - bottomMargin) - 1)] ;
	for (linorg = 0 ; linorg <= lin ; linorg++)
	   if (strtcols[linorg] == virorg)
		   break ;
	linpos = lincur - linorg ;
}



void Edit::formatText(void)
{
	 register unsigned short i;
	 short lin, col;
	 short lastspace;

   // Clear the whole textscreen
   for (i = 0 ; i < height ; i++) // I_A
   {
      memset(curScreen[i], ' ', width);
      curScreen[i][width] = '\0';
   }

   lin = 0 ;
   col = 0 ;
	lastspace = 0 ;

   calculateLineColumn() ;

   // Now fill in the textscreenlines
	for (i=virorg ; lin < height && txt[i] != '\0' ; i++)
   {
      if (txt[i] == '\n' || col >= width )
      {
         col = 0 ;
         if (txt[i] != ' ' && txt[i] != '\n' && lastspace != 0)   // Wrapping of words are needed!
         {
            if ((lin + 1) < height) // I_A
			{
               strcpy(curScreen[lin+1],curScreen[lin]+lastspace+1) ;
               col = width - lastspace - 1 ;
            }
            // I_A: you *know* how wide every line is!
            // Clear from lastspace to \0
            memset(curScreen[lin] + lastspace + 1, ' ', width - lastspace - 1);
         }
         if (i != virorg || txt[i] != '\n')
            lin++ ;
         if (i == 0 && txt[0]== '\n')
            lin++ ;
				if (lin >= height) // I_A added
              break;
         if (col != 0 || txt[i] != ' ' || txt[i-1] == ' ')
            if (txt[i] != '\n')
				   curScreen[lin][col++] = txt[i] ;

         lastspace = 0 ;
      }
      else
	  {
         if (txt[i] == ' ')
            lastspace = col ;

            // don't show the space used for wrapping at the start of the new line
         if (txt[i] != ' ' || col != 0 || lin == 0 || txt[i-1] == ' ')
            curScreen[lin][col++] = txt[i] ;
      }
   }  // next i
}


// Only display changed parts of lines
void Edit::display(void)
{
   register int  i, j, k;
   char *st ;


   st = (char*) malloc(width+1) ;

   this->formatText() ;


   this->Output::outTextattr(color) ;

   for (i = 0 ; i < height ; i++)
   {
     register unsigned char *curScreen_i = curScreen[i];
     register unsigned char *oldScreen_i = oldScreen[i];

     if (strcmp(curScreen_i,oldScreen_i) != 0)
      {
         for (j = 0 ; j < width ; j++)
            if (curScreen_i[j] != oldScreen_i[j])
							 break ;
         for (k = width ; k > 0 ; k--)
            if (curScreen_i[k] != oldScreen_i[k])
               break ;
         strncpy(st,curScreen_i+j,k-j+1) ;
         st[k - j + 1] = '\0' ;

		 this->Output::outGotoxy(x1 + j, y1 + i) ;
				 this->Output::outPrintf(st) ;
      }
   }
   // Place cursor
   redrawCursor() ;

   copyScreen() ;

   free(st) ;
}


/***********************************************************************
*                                                                      *
*                                                                      *
*                                                                      *
*                                                                      *
*                 Public member functions of Edit                      *
*                                                                      *
*                                                                      *
*                                                                      *
*                                                                      *
************************************************************************
*/



// You can not make an instance of edit this way
Edit::Edit()
{
	 err = TRUE ;
}


// The only constructor of edit
Edit::Edit(int xx1, int yy1, int xx2, int yy2, unsigned char *txttxt)
{
	 int i ;

	 err    = FALSE ;
																		// Allocate memory for string
																		// and array of ints
	 memmaltxt = _BLOCK + strlen(txttxt) + 1  ;
	 memmalint = memmaltxt / _BLKPRT ;
	 if ( (txt = (unsigned char*) malloc(memmaltxt)) == NULL)
			err = TRUE ;
	 if ( (strtcols = (unsigned int*) malloc(memmalint * sizeof(*strtcols))) == NULL)
			err = TRUE ;

	 strcpy(txt,txttxt) ;
	txtlength = strlen(txt) ; // I_A added
	 x1 = xx1 ;
	 x2 = xx2 ;
	 y1 = yy1 ;
	 y2 = yy2 ;
	 width  = x2 - x1 + 1;
	 height = y2 - y1 + 1;

	 // Allocate memory for virtual screen
	 if ( (curScreen = (char **) malloc(height * sizeof(char*))) == NULL)
			err = TRUE ;
	 if ( (oldScreen = (char **) malloc(height * sizeof(char*))) == NULL)
			err = TRUE ;
	 for (i = 0 ; i < height ; i++) // I_A
	 {
			if ( (curScreen[i] = (char*) malloc(width + 1)) == NULL)
				 err = TRUE ;
      if ( (oldScreen[i] = (char*) calloc(1, width + 1)) == NULL) // I_A: watch it! >>>calloc<<<
				 err = TRUE ;

   // I_A: for safe operation you need to initialize oldScreen. Only
   //      than can you be sure the first display() will draw the
   //      complete screen...
   }

	 curpos     = 0 ;                 // Set cursor always to first position
	 lincur     = 0 ;                 // Set current line at 0
																		// Calculate some default margins
	 topMargin  = bottomMargin = (height - 1) / 2 ;
	 topSens    = bottomSens   = bottomMargin / 2 ;
	 insertmode = TRUE ;
	 c_fEditable = TRUE;
																		// Set default input mode and emulation
	 inputmode  = INPUT_KEYBOARD ;
	 outputmode = OUTPUT_CON ;
	 Instream::termmode    = TERM_SCREEN ;
	 Output::termmode   = TERM_SCREEN ;
	 virorg = 0 ;

	 color = (C_LIGHTGRAY << 4) + BLUE ;   // Set defaul color
																		// Make an outputfile and open it
	 doubleWidth = TRUE ;
	 border = -1 ;
	 topColor =  ( C_LIGHTGRAY << 4 ) | C_DARKGRAY ;
	 botColor =  ( C_LIGHTGRAY << 4 ) | C_WHITE ;
}

Edit::~Edit()
{
   int i ;
	 for (i = 0 ; i < height ; i++) // I_A
	 {
      free(curScreen[i]) ;
      free(oldScreen[i]) ;
   }
   free(curScreen) ;
   free(oldScreen) ;
   free(txt) ;
	 free(strtcols) ;
   fclose(Output::fpOut) ;
   unlink(Output::outputFilename) ;       // This will fail if someone
											      	// still opens this file for
                                          // read.
}

int Edit::setCursorPos(unsigned short pos)
{
   if (pos > txtlength )
      return 1 ;
   curpos = pos ;
   return 0 ;
}

// Change the coordinates of a window
int Edit::setWindow(int xx1, int yy1, int xx2, int yy2,  bool clear)
{
	 int i ;

	 if (xx1 < 0 || xx2 <= xx1 ||
	 yy1 < 0 || yy2 < yy1)
			return 1 ;
	 if (clear)
       this->clrWindow() ;              // Clear the screen

	 // Delete all allocated memory
	 for (i = 0 ; i < height ; i++)   // I_A
	 {
			free(curScreen[i]) ;
			free(oldScreen[i]) ;
	 }
	 free(curScreen) ;
	 free(oldScreen) ;
//	 free(txt) ;
//	 free(strtcols) ;

	 x1 = xx1 ;
	 x2 = xx2 ;
	 y1 = yy1 ;
	 y2 = yy2 ;
	 width  = x2 - x1 + 1;
	 height = y2 - y1 + 1;


	 // Allocate memory for virtual screen
   if ( (curScreen = (char **) malloc(height * sizeof(char*))) == NULL)
			err = TRUE ;
   if ( (oldScreen = (char **) malloc(height * sizeof(char*))) == NULL)
			err = TRUE ;
   for (i = 0 ; i < height ; i++) // I_A
	 {
   	if ( (curScreen[i] = (char*) malloc(width + 1)) == NULL)
				 err = TRUE ;
      if ( (oldScreen[i] = (char*) calloc(1, width + 1)) == NULL) // I_A: calloc() !!!!
				 err = TRUE ;
   // I_A: for safe operation you need to initialize oldScreen. Only
   //      than can you be sure the first display() will draw the
   //      complete screen...
   }
	 this->redraw() ;                // Re-display the whole screen
	 return 0 ;
}

int Edit::setText(unsigned char *txttxt)
{
	err = TRUE ;
	free(txt) ;
	free(strtcols) ;
	memmaltxt = _BLOCK + strlen(txttxt) + 1  ;
	memmalint = memmaltxt / _BLKPRT ;
	if ( (txt = (unsigned char*) malloc(memmaltxt + _BLOCK)) == NULL)
	   return 1 ;
	if ( (strtcols = (unsigned int*) malloc(memmalint * sizeof(*strtcols))) == NULL)
      return 1 ;
   err = FALSE ;

	strcpy(txt,txttxt) ;
   txtlength = strlen(txt);

   this->redraw() ;
   return 0 ;
}




void  Edit::setColor(unsigned char col)
{
   color = col ;
}

void Edit::setEditable(bool p_fEditable)
{
   c_fEditable = p_fEditable;
}


unsigned char *Edit::getText(void)
{
   return txt ;
}


int  Edit::loadFile(char *fileName)
{
   FILE *in ;
   unsigned short i ;

   memmaltxt = fastFilelength(fileName) ;
   if ( (in = fopen(fileName,"rt")) == NULL)
			return 1 ;
   err = TRUE ;
   free(txt) ;
	 free(strtcols) ;
	 if ( (txt = ( unsigned char*) malloc(memmaltxt + _BLOCK)) == NULL) {
      fclose(in);
      return 1 ;
   }

   err = FALSE ;
   i = 0 ;

   // I_A: *much* faster!
   i = fread(txt, 1, memmaltxt, in);
   txt[i] = '\0' ;
   txtlength = strlen(txt);

   // i == REAL length of file (incl \n\r => \n translation!)
   memmalint = i / _BLKPRT;
	 if ( (strtcols = (unsigned int*) malloc(memmalint * sizeof(*strtcols))) == NULL) {
      fclose(in);
      return 1 ;
   }

   // hieronder ook nog even naar kijken. while(i--) { /* etc */ }
   while ( txtlength  > 0 && txt[txtlength /* strlen(txt) */ -1] ==  255) {
      txt[txtlength -1] = '\0' ;
   }

   fclose(in) ;
   return 0 ;
}

//
// Modification made to allow for Importing text into the editor
// and appending it to the text already there
//
 
int  Edit::appendFile(char *fileName, char *FileName)
{
FILE *in;
FILE *out;
unsigned short i ;

   memmaltxt = fastFilelength(FileName) ;
   if ( (in = fopen(FileName,"rt")) == NULL)
			return 1 ;
   err = TRUE ;
   free(txt) ;
	 free(strtcols) ;
if ( (txt = ( unsigned char*) malloc(memmaltxt + _BLOCK)) == NULL) {
	  fclose(in);
	  return 1 ;
   }
   i = fread(txt, 1, memmaltxt, in);
   txt[i] = '\0' ;
   txtlength = strlen(txt);

   // i == REAL length of file (incl \n\r => \n translation!)
   memmalint = i / _BLKPRT;
	 if ( (strtcols = (unsigned int*) malloc(memmalint * sizeof(*strtcols))) == NULL) {
	  fclose(in);
	  return 1 ;
   }

   // hieronder ook nog even naar kijken. while(i--) { /* etc */ }
   while ( txtlength  > 0 && txt[txtlength /* strlen(txt) */ -1] ==  255) {
	  txt[txtlength -1] = '\0' ;
   }

   fclose(in) ;
	if ((out = fopen(fileName,"at")) == NULL )
		return NULL;
   if (fputs(txt,out) == EOF) {
	  fclose(out);
	  return EOF ;
	}
	fclose(out);
 return 0;
}


int  Edit::saveFile(char *fileName)
{
   FILE *out ;

   if ( (out = fopen(fileName,"wt")) == NULL )
      return NULL ;
   if (fputs(txt,out) == EOF) {
      fclose(out);
      return EOF ;
   }
   fclose(out) ;
   return 0 ;
}


void Edit::redraw(void)
{
   register int i ;

   this->drawborder() ;
   this->formatText() ;
   this->Output::outTextattr(color) ;

	 for (i = 0 ; i < height ; i++)
   {
      this->Output::outGotoxy(x1,y1+i) ;
      this->Output::outPrintf(curScreen[i]) ;
	}
   // Place cursor
   this->redrawCursor() ;

   this->copyScreen() ;
}


void Edit::redrawCursor(void)
{
   this->Output::outGotoxy(min(x1 + width - 1,x1 + colpos),min(y1 + height - 1,linpos+y1)) ;
}

// Clear the whole textscreen
void Edit::clrWindow(void)
{
   register short i;

   for (i = 0 ; i < height ; i++) // I_A
   {
      memset(curScreen[i], ' ', width);
      curScreen[i][width] = 0;
   }

	for (i = 0 ; i < height ; i++) // I_A
   {
      this->Output::outGotoxy(x1,y1+i) ;
      this->Output::outPrintf(curScreen[i]) ;
   }
}



// Poll for a key. Return NULL when there area none available
int Edit::poll(void)
{
	 if(err) {
			return 0;
	 }

	 return this->peekbuffer() == INPUT_NONE ? 0 : this->getkey() ;
}

bool Edit::error(void)
{
   return err ;
}

// Act on the key
void Edit::interpKey(int key)
{
   if (key >=32 && key < 128)
      addchar(key) ;
   else
      switch(key)
      {
         case KEY_ENT:
			newline() ;
            break ;
         case KEY_BACK:
            backspace() ;
            break ;
         case KEY_DEL:
            delpos() ;
            break ;
         case KEY_DN:
            cursorDown() ;
            break ;
         case KEY_UP :
            cursorUp() ;
            break ;
         case KEY_LT:
            if (curpos != 0)
               curpos-- ;
            break ;
         case KEY_RT:
            if(txt[curpos] == '\n') {
               addchar(' ');
			} else {
               if (curpos < txtlength  )
                  curpos++ ;
            }
            break ;
         case KEY_HOME:
            home() ;
            break ;
         case KEY_END:
            end() ;
            break ;
         case KEY_INS:{
		insertmode = !insertmode ;
		isinsert = TRUE;  // added this for the INS OVR Display
		break ;}
         case KEY_CTLY:
            deleteLine() ;
            break ;
         case KEY_CTLT:
            deleteWord() ;
            break ;
         case KEY_PGDN:
			pagedown() ;
            break ;
         case KEY_PGUP:
            pageup() ;
            break ;
				 default:
            processKey(key) ;
         break ;
      } // end switch
   display() ;
}

void Edit::change(void)
{
   int key ;

   key = NULL ;
   while (key != KEY_ESC)
   {
      if ((key = poll()) != 0) // I_A: *not* compareing with NULL but with 0!
         interpKey(key) ;
   }
}

void Edit::setTopColor(unsigned char col)
{
   topColor = col ;
}

unsigned char Edit::getTopColor(void)
{
  return topColor ;
}

void Edit::setBotColor(unsigned char col)
{
   botColor = col ;
}

unsigned char Edit::getBotColor(void)
{
  return botColor ;
}

void Edit::setBorder(int brd)
{
   border = brd ;
}

int Edit::getBorder(void)
{
   return border ;
}

void Edit::drawborder(void)
{
   int i ;
#if 0
   char vertline[7][8] ;

   if (border < 0)
      return ;

   strcpy(vertline[0],"ڰ") ;
   strcpy(vertline[1],"") ;
   strcpy(vertline[2],"") ;
   strcpy(vertline[3],"") ;
   strcpy(vertline[4],"İ") ;
   strcpy(vertline[5],"ٰ") ;
#else
   static char vertline[6][7] =
   {
     "ڰ",
     "",
     "",
     "",
     "İ",
     "ٰ"
   };

   if (border < 0 || border >= 7) // I_A: upper check '>= 7' added
      return ;
#endif

   // Draw top
   outTextattr(topColor) ;
   if (doubleWidth)
   {
      outGotoxy(x1 - 2,y1 - 1) ;
			outChar(' ') ;
      outChar(vertline[0][border]) ;
   }
   else
   {
      outGotoxy(x1 - 1,y1 - 1) ;
      outChar(vertline[0][border]) ;
   }
   for (i = x1 ; i <= x1 + width ; i++)
      outChar(vertline[4][border]) ;
   outTextattr(botColor) ;
   if (doubleWidth)
   {
      outGotoxy(width + x1 ,y1 - 1) ;
      outChar(vertline[3][border]) ;
      outChar(' ') ;
   }
   else
   {
      outGotoxy(width + x1 + 1,y1 - 1) ;
      outChar(vertline[3][border]) ;
   }

   // Draw body
	 for (i = y1  ; i < height + y1  ; i++)
      if (doubleWidth)
      {
         outTextattr(topColor) ;
         outGotoxy(x1 - 2,i) ;
         outChar(' ') ;
         outChar(vertline[1][border]) ;
         outTextattr(botColor) ;
         outGotoxy(x1 + width ,i) ;
         outChar(vertline[1][border]) ;
         outChar(' ') ;
			}
      else
	  {
         outTextattr(topColor) ;
         outGotoxy(x1 - 1,i) ;
         outChar(vertline[1][border]) ;
         outTextattr(botColor) ;
         outGotoxy(x1 + width + 1,i) ;
         outChar(vertline[1][border]) ;
      }

   // Draw bottom
   outTextattr(topColor) ;
   if (doubleWidth)
   {
			outGotoxy(x1 - 2,y1 +height ) ;
      outChar(' ') ;
      outChar(vertline[2][border]) ;
   }
   else
   {
			outGotoxy(x1 - 1,y1 +height ) ;
      outChar(vertline[2][border]) ;
   }
   outTextattr(botColor) ;
   for (i = x1 ; i <= x1 + width ; i++)
      outChar(vertline[4][border]) ;
   if (doubleWidth)
   {
			outGotoxy(width + x1 ,y1 + height ) ;
      outChar(vertline[5][border]) ;
      outChar(' ') ;
   }
   else
   {
	   outGotoxy(width + x1 ,y1 + height ) ;
      outChar(vertline[5][border]) ;
   }

}


#endif
