/***********************************************************************
*                                                                      *
*  Definition file for EDIT.HPP                                        *
*                                                                      *
*  Purpose : Defines KEYS and proboard stuff                           *
*                                                                      *
*  Author  : Peter Bloemendaal                                         *
*            Brainbox systems +31-70-3523661                           *
*  eMail   : internet -> bloemendaal@rullf2.LeidenUniv.nl              *
*            fidonet  -> 2:281/908                                     *
*                                                                      *
*----------------------------------------------------------------------*
*                                                                      *
* $Header: C:\PROGRAMS\TC\EDIT\RCS\key_def.v 1.1                       *
*  1994/07/30 09:31:32 BRAINBOX Exp BRAINBOX $                         *
*                                                                      *
* $Log: key_def.v $
 * Revision 1.7  1994/08/20  13:34:13  BRAINBOX
 * 1. More definitions added to make Edit PEX compatible
 *
 * Revision 1.6  1994/08/12  13:38:22  BRAINBOX
 * 1. Code beautified
 *                                                    *
* Revision 1.5  1994/08/11  22:33:59  BRAINBOX                         *
* 1. Fileno implemented                                                *
*                                                                      *
* Revision 1.4  1994/08/10  20:24:18  BRAINBOX                         *
* 1. Added textattr function to SetFullColor                           *
*                                                                      *
* Revision 1.3  1994/08/08  13:23:38  BRAINBOX                         *
* 1. Bool definition changed                                           *
*                                                                      *
* Revision 1.2  1994/08/01  21:31:01  BRAINBOX                         *
* 2. Global stuff removed                                              *
*                                                                      *
* Revision 1.1  1994/07/30  09:31:32  BRAINBOX                         *
* Initial revision                                                     *
*                                                                      *
*                                                                      *
************************************************************************
*/
#ifndef _PB_SDK_H


/**** KEY scan codes ****/
#define KEY_F1   0x3B00U
#define KEY_F2   0x3C00U
#define KEY_F3   0x3D00U
#define KEY_F4   0x3E00U
#define KEY_F5   0x3F00U
#define KEY_F6   0x4000U
#define KEY_F7   0x4100U
#define KEY_F8   0x4200U
#define KEY_F9   0x4300U
#define KEY_F10  0x4400U

#define KEY_SF1   0x5400U
#define KEY_SF2   0x5500U
#define KEY_SF3   0x5600U
#define KEY_SF4   0x5700U
#define KEY_SF5   0x5800U
#define KEY_SF6   0x5900U
#define KEY_SF7   0x5A00U
#define KEY_SF8   0x5B00U
#define KEY_SF9   0x5C00U
#define KEY_SF10  0x5D00U

#define KEY_CF1   0x5E00U
#define KEY_CF2   0x5F00U
#define KEY_CF3   0x6000U
#define KEY_CF4   0x6100U
#define KEY_CF5   0x6200U
#define KEY_CF6   0x6300U
#define KEY_CF7   0x6400U
#define KEY_CF8   0x6500U
#define KEY_CF9   0x6600U
#define KEY_CF10  0x6700U

#define KEY_AF1   0x6800U
#define KEY_AF2   0x6900U
#define KEY_AF3   0x6A00U
#define KEY_AF4   0x6B00U
#define KEY_AF5   0x6C00U
#define KEY_AF6   0x6D00U
#define KEY_AF7   0x6E00U
#define KEY_AF8   0x6F00U
#define KEY_AF9   0x7000U
#define KEY_AF10  0x7100U

#define KEY_ALT1 0x7800U
#define KEY_ALT2 0x7900U
#define KEY_ALT3 0x7A00U
#define KEY_ALT4 0x7B00U
#define KEY_ALT5 0x7C00U
#define KEY_ALT6 0x7D00U
#define KEY_ALT7 0x7E00U
#define KEY_ALT8 0x7F00U
#define KEY_ALT9 0x8000U
#define KEY_ALT0 0x8100U

#define KEY_ALTA 0x1E00U
#define KEY_ALTB 0x3000U
#define KEY_ALTC 0x2E00U
#define KEY_ALTD 0x2000U
#define KEY_ALTE 0x1200U
#define KEY_ALTF 0x2100U
#define KEY_ALTG 0x2200U
#define KEY_ALTH 0x2300U
#define KEY_ALTI 0x1700U
#define KEY_ALTJ 0x2400U
#define KEY_ALTK 0x2500U
#define KEY_ALTL 0x2600U
#define KEY_ALTM 0x3200U
#define KEY_ALTN 0x3100U
#define KEY_ALTO 0x1800U
#define KEY_ALTP 0x1900U
#define KEY_ALTQ 0x1000U
#define KEY_ALTR 0x1300U
#define KEY_ALTS 0x1F00U
#define KEY_ALTT 0x1400U
#define KEY_ALTU 0x1600U
#define KEY_ALTV 0x2F00U
#define KEY_ALTW 0x1100U
#define KEY_ALTX 0x2D00U
#define KEY_ALTY 0x1500U
#define KEY_ALTZ 0x2C00U

#define KEY_CTLA 0x0001U
#define KEY_CTLB 0x0002U
#define KEY_CTLC 0x0003U
#define KEY_CTLD 0x0004U
#define KEY_CTLE 0x0005U
#define KEY_CTLF 0x0006U
#define KEY_CTLG 0x0007U
#define KEY_CTLH 0x0008U
#define KEY_CTLI 0x0009U
#define KEY_CTLJ 0x000AU
#define KEY_CTLK 0x000BU
#define KEY_CTLL 0x000CU
#define KEY_CTLM 0x000DU
#define KEY_CTLN 0x000EU
#define KEY_CTLO 0x000FU
#define KEY_CTLP 0x0010U
#define KEY_CTLQ 0x0011U
#define KEY_CTLR 0x0012U
#define KEY_CTLS 0x0013U
#define KEY_CTLT 0x0014U
#define KEY_CTLU 0x0015U
#define KEY_CTLV 0x0016U
#define KEY_CTLW 0x0017U
#define KEY_CTLX 0x0018U
#define KEY_CTLY 0x0019U
#define KEY_CTLZ 0x001AU

#define KEY_DEL  0x5300U
#define KEY_INS  0x5200U
#define KEY_HOME 0x4700U
#define KEY_END  0x4F00U

#define KEY_PGUP 0x4900U
#define KEY_PGDN 0x5100U
#define KEY_UP   0x4800U
#define KEY_DN   0x5000U
#define KEY_LT   0x4B00U
#define KEY_RT   0x4D00U

#define KEY_ESC  0x001BU
#define KEY_ENT  0x000DU
#define KEY_RET  0x000DU
#define KEY_TAB  0x0009U
#define KEY_STAB 0x0F00U
#define KEY_CPGUP 0x8400U
#define KEY_CPGDN 0x7600U

#endif

// Always define these
#define KEY_BACK 0x0008U

#define MAXPATH 128


// Define some thing not defined in PB_SDK.H
// Can only be used by Proboard Bulletin Board system
#ifdef _PB_SDK_H

#define getch ScanKey
#define EOF (-1)            /* End of file indicator */
#define gotoxy GotoXY
#define clrscr() printf("\f")
#define cprintf printf
#define _dos_findfirst dos_findfirst

#define _A_NORMAL  0x00
#define _A_RDONLY	0x01
#define _A_HIDDEN	0x02
#define _A_SYSTEM	0x04
#define _A_LABEL	0x08
#define _A_DIREC	0x10
#define _A_ARCH		0x20

int fileno(FILE *fp)
{
   return *fp ;
}

void textattr(int color)
{
	 SetFullColor(color) ;
}

int kbhit (void)
{
	union REGS reg ;
	struct SREGS sreg ;
	reg.h.ah 	= 0x0B ;
	intdosx(&reg, &reg, &sreg) ;

	return reg.x.ax & 255 ;
}


int strcmpi(const char *s1,const char *s2)
{
   int ret ;

   char *su1, *su2 ;

   if ( (su1 = (char*) malloc(strlen(s1) +1)) == NULL)
      return NULL ;
   if ( (su2 = (char*) malloc(strlen(s2) +1)) == NULL)
      return NULL ;

   strcpy(su1,s1) ;
   strcpy(su2,s2) ;

   strupr(su1) ;
   strupr(su2) ;

   ret = strcmp(su1,su2) ;
   free(su1) ;
   free(su2) ;

   return ret ;
}

#endif
