* Configuration file for the BBS File Manager program

* This file must be kept in the same subdirectory as the BBSFMAN.EXE
* executable program (or BBSFMAN2.EXE for OS/2).  This file is read whenever
* the BBSFMAN program is started.  Each statement is preceded by a comment
* that describes what the statement is for.  Any statement comment that
* begins with "!!!" *must* be modified in order for BBSFMAN to work properly.
* Other statements are optional.

* All lines that begin with a "*" character are treated as a comment and are
* ignored.


* The following specifies the path that all other incompletely specified
* paths are relative to.  This must come before the use of any relative
* path usages.  It should end with a trailing '\'.

RELATIVE_PATH d:\max\


* !!! There are two methods of defining your fileareas for BBSFMAN to use.
* You must pick one and only one of these and the other should be commented
* out.
* 1) You can specify them here in the profile by using FILEAREA statements.
*    Here's some example FILEAREA statements.  The format is:
*    FILEAREA Fileareanumber Fileareapath Fileareadescription
*
* 2) For Maximus BBSs, you can just specify what your FILEAREA.CTL file is.
*    BBSFMAN will read that and use this information.  Please see the
*    complete documentation about possible support of other BBSs.

* !!!The following statements use method #1:

*FILEAREA 0 d:\max\files\uncheck Unchecked Uploads
*FILEAREA 1 d:\max\files\games Game Programs
*FILEAREA 2 d:\bbsfman\test1 This is a test area (test 1)
*FILEAREA 3 d:\bbsfman\test2 This is a test area (test 2)
*FILEAREA 99 d:\bbsfman\junk Junk filearea


* !!!The following statement is to use method #2:

AREACTL d:\max\filearea.ctl


* External program useage:  A number of statements use external programs
* (viewers, archivers, etc.).  All these have a common method for specifying
* parameters for them:
*  - If you don't specify any of the following special parameters, the
*    complete path/filename will automatically be appended to the external
*    program call.
*  - $D indicates append the disk at the current position.
*  - $P indicates append the path at the current position.
*  - $F indicates append the filename and extension at the current position.
*  - $N indicates append the filename (no extenstion) at the current postion.
*  - $E indicates append the file extension at the current position.
*  - $O indicates do not append the path/filename automatically.  It is
*    mainly useful in user defined functions.


* !!!ARCHIVER is the name of your file archive manager (for example, SHEZ).
* You may have to specify the full pathname to the program.

ARCHIVER c:\util\shez $p\$f


* ARCHIVER_EXT is the file extensions you wish to use your archive
* manager on.  All others will use your text editor.

ARCHIVER_EXT ZIP ZOO LZH ARC ARJ


* !!!PICVIEWER is the name of the picture viewer you want to use to
* view graphics files.  You may have to specify the full pathname
* to the program.

PICVIEWER d:\pics\cshow $p\$f+


* PICVIEWER_EXT is the file extensions you wish to use your picture
* viewer on.

PICVIEWER_EXT GIF JPG BMP PCX TIF MCP PIC MAC


* BROWSER is the text/hex file browser you wish to use to view raw file
* data. You may have to specify the full pathname to the program.  Note in this
* case the path/filename is appended automatically since no "$" parameter
* is used.

BROWSER fv


* EDITOR is the text editor you wish to use to view and edit various
* files that are not compressed by an archive program.  You may have
* to specify the full pathname to the program.

EDITOR t


* GIF_TO_JPG is the name of the GIF to JPG converter you wish to use.
* Note that the date of the output file will automatically be set to
* that of the input file.

GIF_TO_JPG d:\pics\gif2jpg -j -a


* JPG_TO_GIF is the name of the JPG to GIF converter you wish to use.
* Note that the date of the output file will automatically be set to
* that of the input file.

JPG_TO_GIF d:\pics\jpg2gif -a
*JPG_TO_GIF d:\pics\alchemy -g


* GIF_COMPRESS is the name of the GIF compressor you wish to use.
* Note that the date of the output file will automatically be set to
* that of the input file.

GIF_COMPRESS d:\pics\giflite -t -b -l


* EQUATE_SIMILAR_EXT is a parameter that should have a value of "0" or "1".
* It tells the program whether or not to treat all files that have an
* extension contained in ARCHIVER_EXT or PICVIEWER_EXT as equivalent as
* far as their description is concerned.  For example, if you have a file
* called PANDA.GIF and a file called PANDA.JPG in a given subdirectory but
* only PANDA.GIF has its description in the FILES.BBS file, then PANDA.JPG
* will also be given the same description.  This feature is useful if you
* compress your GIF files into JPG files.  There is then no need to copy the
* description when you create the JPG file since the program will get it
* automatically from the GIF file.  Similarly, this is useful with various
* archive formats such as ZIP and ARJ.

EQUATE_SIMILAR_EXT 1


* Many BBSs have a filearea where they put "garbage" files users upload.
* These could be duplicate files users uploded with a different filename
* or they could be files that don't meet the quality standards for the
* BBS.  This program lets you deal with these files in a very automated
* manner.  First, you must define one of your fileareas to be a "junk"
* filearea.  You also must define the name of a text file that contains
* a log of your user's uploads (the format of this files must be one
* entry per line).  You must also define a file to be your JUNK.LOG file.
* Here's how it all works:
*  - Suppose a user uploads FOOBAR.GIF.  Hopefully, your BBS software would
*    automatically record this in your upload log file.
*  - When you look at FOOBAR.GIF you see it is a duplicate file.  You use
*    the program's normal commands to move this file into your junk filearea.
*  - Under the covers, BBSFMAN will automatically do the following:
*    - Remove the description of FOOBAR.GIF from the FILES.BBS (nothing new
*      here) of the filearea it was in.
*    - Create a 0 length file in your junk filearea and add an entry into
*      the FILES.BBS for the junk filearea.
*    - Look in your upload log file and copy the line with this file to
*      the JUNK.LOG file.  This allows you later to remove the upload credit
*      for this user (if you so choose).

* Here's the definition of the three variables.  If you choose not to use
* this function, make the junk filearea equal to -1 or comment out all the
* variables.

JUNK_FILEAREA 99
FN_UL_LOG     d:\max\ul.log
FN_JUNK_LOG   d:\max\junk.log


* The BACKUP_FILESBBS parameter determines whether or not BBSFMAN
* makes a backup copy of your FILES.BBS file to FILES.BAK.  It does
* this everytime you bring-up a new file directory display.  A "1"
* means perform the automatic backup and a "0" means don't do it.

BACKUP_FILESBBS 1


* The MAX_FILESBBS_LINE parameter determines the maximum permissible line
* in FILES.BBS.  If you start with a FILES.BBS with a longer line than this,
* BBSFMAN will abort at start-up.  If you try to create a line longer than
* this from within BBSFMAN, it will automatically truncate it to this length.
* This parameter must be less than or equal to 1000 and greater than 25.

MAX_FILESBBS_LINE 255


* TOUCH_ON_MOVE parameter indicates whether or not a file that is moved to
* a different directory should keep the original date ("0") or get the current
* date ("1").

TOUCH_ON_MOVE 1


* The SORT_ORDER is how directories are sorted on start-up.  This may be
* one of the following:  "NAME", "EXT", "SIZE", "DATE".

SORT_ORDER date


* The FN_PKUNZIP is the full path and filename for the PKUNZIP program.
* It is necessary if you wish to automatically get descriptions from
* FILE_ID.DIZ files.

FN_PKUNZIP c:\util\pkunzip


* The FN_ARJ is the full path and filename for the ARJ program.
* It is necessary if you wish to automatically get description from
* FILE_ID.DIZ files.

FN_ARJ c:\util\arj


* The FN_LHARC is the full path and filename for the LHARC program.
* It is necessary if you wish to automatically get description from
* FILE_ID.DIZ files.

FN_LHARC c:\util\lharc


* The following are user-defined functions which you can execute by hitting
* ALT+<number> key.  You can declare up to 10 user functions.  The format is:
*
* USER_FUNC_x "Description of func" program-name parameters
*
* where x is a number between 0 and 9.  "Description of func" must be inside
* double-quotes and be less than 40 characters long.  The remainder is
* the program-name and parameters and is in a similiar format to the
* previous usages.

USER_FUNC_0 "Directory List"  DIR $D*.*
USER_FUNC_1 "Search for similar files"  GSEE d:$N*.*
USER_FUNC_2 "Search for similar files"  GSEE e:$N*.*
USER_FUNC_3 "Directory List on File" FL
USER_FUNC_4 "Directory Tree" FLTREE $O
USER_FUNC_5 "Full-screen Directory" FL $P\*.*
USER_FUNC_6 "Check Disk" CHKDSK $O
USER_FUNC_7 "Alchemy JPG->GIF" ALCHEMY -g $N.$E
USER_FUNC_8 "Unused" $O
USER_FUNC_9 "MPEG Viewer" MPLAY


* The following sections are used in creating an FILEIDEX.LST which is a
* list of all files on your bulletin board.  Typically, you would call
* this with a DOS BAT file (or OS/2 CMD file) to generate a new list once
* a day.  You would probably also re-name it to whatever you want and put
* in the appropriate file area and also ZIP it.
*
* The following is the filename of a file that will be placed at the top
* of your FILEIDEX.LST file.  It typically would be the logo for your BBS
* or any other descriptive info you want.

FILEIDEX_FN_HEADER d:\max\zip_cmnt.txt


* The following are lists of fileareas to build a FILEIDEX.LST.  For
* example, many BBSs have a list of files for their "normal" files and
* another for their "adult" files.  The following sections allow you to
* group various fileareas together and have BBSFMAN build an FILEIDEX.LST
* for each of the groups.  When you execute the option of BBSFMAN to
* build a filelist ("-L"), you can optionally specify a number for which
* file grouping to build a list for.  For example, "-L3".  If you don't
* specify the number, it will build a list for all areas.  The syntax for
* the groupings is:
*
* FILEIDEX_GROUP_x file_area <file_area> ...
*
* where x is a number between 1 and 9 and file_area is a filearea number for
* your BBS.
*

FILEIDEX_GROUP_1 1 10 11 12 13 14 15 16 17 18 19 20 22 23 24 30 40 41 99
FILEIDEX_GROUP_2 0 2 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 75 80 81


* You can select colors for many aspects of the menus and popup windows
* that are displayed by altering the color "number" in this section.
* The color choices and their coresponding numbers are defined as follows:
*
*    BLACK = 0          * Foreground and background
*    BLUE = 1           * Foreground and background
*    GREEN = 2          * Foreground and background
*    CYAN = 3           * Foreground and background
*    RED = 4            * Foreground and background
*    MAGENTA = 5        * Foreground and background
*    BROWN = 6          * Foreground and background
*    LIGHTGRAY = 7      * Foreground and background
*    DARKGRAY = 8       * Foreground only
*    LIGHTBLUE = 9      * Foreground only
*    LIGHTGREEN = 10    * Foreground only
*    LIGHTCYAN = 11     * Foreground only
*    LIGHTRED = 12      * Foreground only
*    LIGHTMAGENTA = 13  * Foreground only
*    YELLOW = 14        * Foreground only
*    WHITE = 15         * Foreground only

* Foreground color for active window
COL_ACTIVE 15

* Foreground color for inactive window
COL_INACTIVE 14

* Normal background color
COL_BACKGROUND 1

* Foreground color for pop-up windows
COL_POPUP_FORE 0

* Background color for pop-up windows
COL_POPUP_BACK 3

* Reverse video color for pop-up windows
COL_POPUP_REV 7
