
                                                                1
                                                  Introduction to
                                                        Financial
                                                           Wonder


Financial Wonder ("FW") is a state-of-the-art professional financial
package for:

   * Preparing Financial Reports & Consolidations
   * Preparing Budgets
   * Analyzing Corporate Decisions


   For those using Financial Wonder for OSAS
   -----------------------------------------
   Financial Wonder for OSAS is a version of Financial Wonder that can
   read and write to the Open Systems Accounting Software General
   Ledger version 4.1. All features of the standard Financial Wonder
   program are present in Financial Wonder for OSAS.

   Financial Wonder for OSAS can import the following from your general
   ledger:
      * Current Year Amounts
      * Budgeted Amounts
      * Prior Year Amounts

   Financial Wonder for OSAS can export the following to your general
   ledger:
      * Budgeted Amounts


Although the user should have some experience using the Personal
Computer, the true power of FW has been hidden to make the
program easy to use. This makes FW user-friendly, while retaining
a high level of sophistication. Spreadsheet users will find FW easy
to work with.

Financial Wonder is a spreadsheet that uses virtual memory for
program and file operations. MS-DOS 3.1 or later, and 640KB of
conventional memory are required. At least 1 megabyte of
expanded or extended memory is highly recommended.

* 5000 accounts per file
* Consolidate 100 files per level
* All consolidating amounts are displayable
* 37 monthly columns (versions available for 121 and 241 monthly columns)
* Lotus WK1 import & export
* ACCOUNTING LOGIC PRE-PROGRAMMED!!
* SELF-BALANCING FINANCIALS
* Reporting & Consolidations


Preparing Financial Reports and Consolidations
----------------------------------------------
Import financial accounts directly from Lotus WK1 files:

   * Import directly into our set of financial statements
   * Re-calculate to produce easy to use cash reports and very
     detailed FASB 95 cash reports
   * Ratio analysis produced - 22 ratios
   * Consolidate an unlimited number of files
   * CONSOLIDATING DETAILS ARE DISPLAYED !
   * CONSOLIDATE FILES WITH DIFFERENT ACCOUNT STRUCTURES


Preparing Budgets & Forecasts
-----------------------------
Financial Wonder provides the tools to create the detailed budgets
& forecasts business has always wanted.

Executives need this information to properly manage their business,
make policy decisions, and arrive at major decisions that can make
or break their company.

Financial Wonder will allow them to view the company's course
before it happens, NOT after it is too late.

You may choose from 120 formula methods by simply selecting the
method #, and you can combine any of our 100 customizable Seasonality
Charts with a formula method at any time.

This allows you to play "What-if" games to your heart's content.

ALL WITHOUT ANY PROGRAMMING !!



Analyzing Corporate Decisions
-----------------------------
Financial Wonder provides the tools needed for corporate budgeting,
forecasting and cash flow analysis:

   * Accounting department
   * Budgeting department
   * Financial analysis
   * Financing bank loans
   * Business plans
   * Business decision making
        > Capital investment
        > Sales price sensitivity analysis
        > Comparison to corporate profit goals
        > New Venture feasibility study
        > Effect of policy change on cash flow:
            - marketing plans
            - collection and payment policy
            - loan agreement
            - intercompany debt arrangement
            - discounts on large sales orders
            - employment levels and number or length of shifts
   * Mergers & Acquisitions
   * FASB 95 Cash Statements
            Why spend hours preparing by hand!

            Create reasonable monthly financials from historical
            annual reports using Seasonality Screens to estimate
            monthly activity for the past year. This is great for
            cash flow analysis.



FEATURES
--------

FW provides numerous features:


   * Over 250 financial accounts are preprogrammed.

   * New sub-accounts can be easily created.

   * Three years are forecast on a monthly basis, resulting in
      36 monthly forecasted sets of financials and ratios.

     Versions for up to 20 years by month are available. Files
     created with our 3 year version will load into larger versions.

   * Spreadsheet format provides comfort and familiarity.

   * "What-if" calculations are easily performed.

   * A flexible mixture of Monthly, Quarterly and Annual size
      periods can be defined by the user. FW understands
      the size of each forecast period, with spreading to
      create monthly financials based on your use of our
      extensive list of forecast methods.

   * 120 Formula Methods provide State-of-the-Art power.

     A number of methods allow for compounding on a monthly basis,
     geometric progression (calculated by either the user or FW),
     weighting based on seasonality, and combinations of compounding,
     geometric progression and seasonality.
     (A geometric progression is, in essence, a trend line
     between the opening and the ending amounts).

   * FW allows you to link accounts (the results of one account
     are based on that of another account - ex: Cost of Goods Sold
     might be a percent of Sales) regardless of the numerical sequence
     of the accounts (ex: Sales might be a percent of Cost of
     Goods Sold) - and many levels deep!

   * Interest on each monthly cash flow is recorded, net of tax-
     effect. All financial statements are then updated before FW
     calculates the next month. Interest on current cash flow is
     based on the user's estimate of days available.

   * The present value of monthly cash flow is calculated for you
     as an aid in determining the value of the business.

   * Our use of multiple interactive spreadsheets and flexible
     data entry provide the user a common ground with spreadsheet
     programs. Similar to ordinary spreadsheet programs, full
     cursor commands are available for moving around our
     spreadsheets.

   * One-key conversion of files to LOTUS 123.

     8 financial reports may be converted to LOTUS 123. These are
     the Calculations and Monthly Calculations for the three financial
     statements, inclusive of ratios, and FASB 95 Cash Statements
     using either the direct or indirect method. These 8 reports will
     create about 400K of 123 files in a couple of minutes. Your 123
     files will have the cell-width set, dollar signs, lines and double
     lines around totals, and extensive use of range commands and sums
     of these ranges pre-programmed for you. You can then customize your
     reports in LOTUS should you wish.

   * Easy to use 600+ page manual (half-size pages).

     This provides a short review in operating FW, and a large reference
     manual covering all 120 formula methods, financial statement preparation,
     report preparation and ratio method formulas. Use what you wish; there
     is no need to learn all or even most of FW to operate the program.

     Hundreds of clear examples provide you with what you need to
     know, when you need it.

     WE RECOMMEND SOME READING, BUT MANY CUSTOMERS DIVE RIGHT INTO THE
     PROGRAM.

   * 100 Seasonality screens allows for a global change to Seasonality.

     Enter your Seasonality on a monthly basis. All formula methods using
     Seasonality use these screens. Changes can be made easily and in
     seconds. NO other program features this much flexibility.

   * Special Management Tools.

     Special ratio analysis features are provided. Set your ratings -
     FW will tell you how you did on a monthly basis and explain each ratio.

     Ratios can be calculated based on beginning, average or ending
     balances, and are individually user selectable.

   * 20 Report layouts are available for you to customize and save.

   * Reports are printed formally, with dollar signs, sub-totals and totals.

   * Printouts of either Data Entry or Calculated results display account
     numbers and formula methods.

   * Easy installation.

   * Screen colors may be changed at any time. B&W is also acceptable.

   * FW provides print drivers supporting over 600 printers, using up to
     43 different fonts (availability is printer dependent).

   * Numerous additional features are provided :
        * six spreadsheet copy commands to replicate amounts
        * change account number
        * change account description
        * mark row for deletion to exclude account from the calculation
        * remove mark for deletion
        * add new account
        * delete sub-account
        * move a row
        * move a block of rows
        * create your own templates from previously created files
          (blank amounts feature)
        * global conversion between upper and lower case
          account descriptions with the first character capitalized
        * drop to a DOS shell to provide some multi-tasking capabilities





FORMULA METHODS
---------------

FW provides the flexibility to forecast a mixture of Monthly, Quarterly and
Annual size periods. To accomplish this FW understands the size of each
forecast period and allows for compounding on a monthly basis.

120 Formula Methods provide state-of-the-art power:

I.    Formula Methods with Automatic Spreading
      ----------------------------------------

      Separate formula methods are provided for the Balance
      Sheet and the Income Statement. (See the section
      "Formula Entry Screens" later in this chapter for examples of the
      difference between Balance Sheet and Income Statement
      formula methods)


      Spreading Methods
      -----------------
      The following formula methods will spread your quarterly
      or annual period across the individual monthly periods
      in one of four ways:

      1) Spread over the period evenly
      2) Spread over the period seasonally adjusted
      3) Increase by geometric progression over the period
      4) Increase by geometric progression seasonally adjusted


      Formula Methods which can be Spread
      -----------------------------------
      Separate Balance Sheet and Income Statement methods
      have been provided for the following

      * Specify Dollar Units

      * Increase the Previous Balance by an Amount

      * Growth Rate - Increment the Previous Balance by a Percent
                      Adjust for period size difference

      * Growth Rate - Increment the Previous Balance by a Percent
                      NO adj for period size difference

      * Annual Percent Increase - NO compounding
                            Adjust for period size difference




II.   Other Formula Methods
      ---------------------

      Separate formula methods are provided for the Balance Sheet
      and the Income Statement.

     * Increment the Previous Balance by an Annual Percent - Compounded:

         * Exact seasonal amount
         * Rounded seasonal amount
         * Non-seasonal amount (no rounding required)

     * Percent of Another Variable

     * Percent of Another Variable's Previous Month

     * Percent of a Change in Another Variable

     * Percent of a $ Change in Another Variable

     * State Accounts Receivable as Average Days Outstanding

     * State Accounts Payable as Average Days Outstanding

     * State Inventory as Average Days Outstanding

     * Income Tax - Specify Dollar Amount

     * Income Tax - Percent of Income Before Taxes +
                    Non-tax deductible Amounts

       Tax expense may be forecast as a specific dollar
       amount or as a percent of taxable income.

       Net Operating Loss ("NOL") Carryforwards prior to the
       years being forecast, may be specified.

       Forecast months which reflect a loss may be handled
       similar to a carryback, added to available NOL
       carryforward amounts, or ignored with no tax recovery
       or addition to opening NOL carryforward amounts.

     * One Month Dollar Amount - Place amount into specific month

       This allows you to forecast on an annual or quarterly
       basis, and place an amount into any monthly period.

     * Dollar Amount to be Placed into Each Month

        A specific dollar amount will be placed:

        1) Into each month of the annual or quarterly period

        2) Into each month of the annual or quarterly period
           through a selected month

        3) Into each month of the annual or quarterly period
           beginning with a selected month through to the end
           of the period

     * Lets the user go directly to the Monthly Calc screen, and
       enter exact dollar amounts into each monthly column.

       THIS FORMULA METHOD - #99, IS A MAJOR FEATURE THAT CANNOT
       BE DUPLICATED IN A STANDARD SPREADSHEET PROGRAM. IT ALLOWS
       YOU TO FORECAST ON AN ANNUAL BASIS, BUT ENTER MONTHLY
       AMOUNTS FOR ANY ACCOUNT OR SUB-ACCOUNT. OTHER ACCOUNTS AND
       SUB-ACCOUNTS MAY BASE THEIR RESULTS ON THESE INDIVIDUALLY
       ENTERED MONTHLY AMOUNTS. THIS ALLOWS YOUR SPREADSHEET TO
       LOOK AT ANY CELL ON EITHER A MONTHLY OR AN ANNUAL BASIS.


FINANCIAL WONDER RAISES THE STANDARD
------------------------------------

  *  Budgets deal with months, not years. But who wants to
     build 36 monthly forecasts! FW is an expert system.

     You may enter information in a combination of monthly,
     quarterly and annual periods, flexibly structured by the
     user. FW knows the size of your periods and will act
     accordingly, spreading on a monthly basis in accordance
     with the formula method chosen; which might be
     different for each account/period (every amount or
     percentage may be forecast independently).

     There is only one set of formula methods. At the
     appropriate time, FW will review the shape of your years
     (entered by you as monthly, quarterly and annual
     periods) and act accordingly, transparent to the user.
     This is an original concept and is the whole basis of FW.


--------   NO OTHER PROGRAM CAN DO ALL THIS   --------


  *  Offers such a variety of formula methods.

  *  Allows you to use a different formula method for each
     data entry period of each account.

  *  Allow the user to create sub-accounts. Spreadsheet
     templates are not flexible enough to accomplish this.

  *  FW allows you to link accounts (the results of one account
     are based on that of another account - for example: Cost of Goods Sold
     might be a percent of Sales) regardless of the numerical sequence
     of the accounts (for example: Sales might be a percent of Cost of
     Goods Sold).

     Other programs require that the linked account be a
     lower number so that the linked account will be
     calculated first. This logic went out the window when
     LOTUS arrived, several years ago. FW allows you to link
     account #1 to account #2, #2 to #3, #3 to #4, and on.
     FW will search for the lowest level needed and work up
     the ladder you have created - AUTOMATICALLY!

  *  FW's 100 Seasonality Screens allow for a global change to
     Seasonality. Other programs act as if they never heard
     of Seasonality!

  *  FW considers monthly compounding and geometric progressions
     in their formula methods - and considers both accumulating
     or growth balances representative of Balance Sheets and
     cumulative amounts representative of Income Statements.

     To accomplish this, special mathematical formulas
     were derived. These math formulas are proprietary.

  *  Interest on monthly cash flow is recorded in the current
     period based on the user's estimate of days available.

     Other programs calculate interest based on the
     previous period's cash flow. Consequently, interest
     as a result of large changes in cash flow is never
     recorded in the current period, on other programs.

  *  FW can identify errors in your cash flow, and correct the
     Cash Statement, automatically, while at the same time
     showing you the amount and location of the differences.
     FW also has a built-in error report which identifies the
     location of errors from linking to non-existent accounts.

  *  FW allows you to customize and save 20 report formats
     for printing.

  *  You may select the use of beginning, ending or average
      balances for calculating your ratio analyses - with each
      ratio individually set. This is an original concept of FW.

  *  Use the ratio analyses to grade yourself by using our Ratio
     Sensitivity screen.

     You can set up five gradings, Excellent to Poor. These parameters
     will then be used to rate your forecasted performance. This is a
     terrific Management Tool, yet easy to use. Once again, an original
     concept of FW.




PULL-DOWN MENUS
---------------

FW provides an easy-to-use menu of options. The user can move throughout the
program by pressing the "/" key to activate the main menu, and activate
pull-down menu listings. You may even use the left and right arrows to
traverse between the pull-down options.




DATA ENTRY
----------

  There are three Data Entry screens:

        Balance Sheet - Data Entry
        Income Statement - Data Entry
        Cash Statement - Data Entry


  Most of your time in Financial Wonder will be spent inputting
  forecast amounts into these screens and selecting formula
  methods in the set of Formula Entry screens.

  There are

    * 55 predefined accounts in the Balance Sheet, consisting
      of various asset and liability accounts, special accounts
      and account totals.

    * 44 predefined accounts in the Income Statement,
       consisting of various income and expense accounts, and
       account totals.

    * 38 predefined accounts in the Cash Statement input,
       consisting of various cash receipt and payment accounts
       which provide amounts not otherwise obtainable from the
       balance sheet or income statement, accounts disclosing
       share of capital stock, and rates to determine discounted
       cash flow (many of these accounts will only be needed
       from time-to-time).

  You may freely use the various accounts, or insert new sub-accounts,
  in preparing your forecast. The special accounts and account totals
  will be calculated for you.

   *   In addition FW provides you with approximately 130
       predefined accounts representing a Cash Statement and
       extensive ratio analyses.

       This is completely pre-programmed. FW prepares this
       statement and all ratio analyses for you automatically each
       time you re-calculate.

       The Cash Statement is easy-to-understand. For external
       reporting, FW will print out or convert to Lotus 1-2-3 file
       format a cash statement in compliance with FASB 95, using
       either the direct or the indirect method.


  Cursor Commands
  ---------------
  Similar to ordinary spreadsheet programs, full cursor commands
  are available for moving about the spreadsheet. Each screen in
  FW appears as a single spreadsheet. By using your cursor keys -
  up, dn, pgup, pgdn, home, end, and others - you will be able
  to either slowly scroll or quickly move about each spreadsheet.


  Account Descriptions
  --------------------
  Account descriptions may be changed for any account and at
  any time. Although you may change an account's description, the
  character of the account will remain the same. For example, the
  account "Accounts Receivable" will always remain Accounts
  Receivable in character when FW calculates the cash flow and
  ratio analyses. Changes made while in this screen will be
  reflected throughout the program and in all printouts, reports and
  conversions to LOTUS 123.


  Add New Sub-Accounts
  ----------------
  Predefined accounts have account numbers in even thousands
  (for example, Cash is 100000 and Inventories is 108000). New sub-
  accounts may be added (or later deleted) with ease. These sub-
  accounts will have the same properties as the main account.

     NOTE: Three sub-accounts to Accounts Receivable have
     been added in the Balance Sheet - Data Entry screen
     displayed on this page in the printed manual.

  Account descriptions are selected by the user. These accounts
  will have the same properties as the main Accounts Receivable
  account. All forecasted amounts will be added to Accounts
  Receivable in the calculation of Cash Flow and various Ratio
  Analyses.  These new accounts will appear throughout the
  program and in all printouts, reports and conversions to LOTUS
  123. Any of these sub-accounts can also be "rolled-up" into
  Accounts Receivable when printing Financial Reports. In fact,
  the main Accounts Receivable account can be "rolled-up" into
  Other Current Assets.


  Mark Row for Deletion
  ---------------------
  To play what-if-games, you do not need to delete portions of your
  work. Both main and sub-accounts may be marked for deletion.
  If you were to re-calculate your model you would see that
  although the account was still there, FW ignored all Data Entry
  information for marked accounts. As far as the calculation is
  concerned that row does not exist. For example, say that you
  have five possible sales and five possible matching cost of goods
  sold scenarios. Instead of constantly revising your model you
  would enter all five scenarios and simply mark and unmark
  accounts for deletion, and then re-calculate each scenario.




FORMULA ENTRY
-------------

  FW comes alive with its available formula methods. Each Data
  Entry cell (month/year period) may use a different formula
  method! This allows you to use several different formula methods
  across one account. Most other products limit use to one formula
  method for each account.

  All 120 formula methods are pre-programmed, and the power of
  these methods far exceeds that previously available using any
  general spreadsheet package.

  There are three Formula Entry screens:

   Balance Sheet - Formula Entry
   Income Statement - Formula Entry
   Cash Statement - Formula Entry

  FW calculates each Data Entry cell individually, based on the
  results of the previous cell (chronologically). Selected formula
  methods link one account to the results of other accounts or sub-
  accounts, which in turn could be linked to the results of still other
  accounts or sub-accounts.

  Formula methods are categorized as Nonclassified, Balance Sheet
  and Income Statement.


  Balance Sheet
  -------------
  Balance Sheet types represent accumulating or growth
  balances. Spreading (to create monthly financials) ties together
  the peaks of the opening and closing balances.

  For example, the opening balance for cash might be $90 with
  $120 representing the balance after one Quarter (of a year).
  The intervening months might show $100 and $110
  establishing a line between the peaks of $90 for the opening
  balance and $120 for the closing balance. Balance Sheet
  types represent a balance at the end of a specified period.


  Income Statement
  ----------------
  Income Statement types represent the total amount for that period.

  For example, an amount of $120 for one Quarter might be
  spread $40, $40 and $40 for each of the three monthly
  periods. Income Statement types represent amounts to be
  distributed over the period.


  Cash Statement
  --------------
  Cash Statement method selection will entail using a
  combination of the two types noted above. Capital
  investment and income/loss accounts will typically use income
  statement or nonclassified type methods. A request for the
  number of shares of capital stock will typically use a
  nonclassified method to place the same number of shares into
  each month.


  To allow for total flexibility and optimum power, most of the
  formula methods from these three categories have been made
  available to all three financial statements.

  Geometric progression and most other formula methods will also
  operate from the first forecast period entered, by prompting the user
  for historical income statement amounts.

  A geometric progression is, in essence, a trend line between the
  opening and the ending amounts. By prompting the user for historical
  amounts, only when needed and only from the first forecast period
  entered, FW can create a trend line (FW's trend line assumes a
  monthly compounding of the growth percentage -similar to the
  compounding of money's deposited in an interest bearing account).





CALCULATION
-----------

There are three Calculation screens:

   Balance Sheet - Calculation
   Income Statement - Calculation
   Cash Statement - Calculation

FW will first calculate all results on a monthly basis, displayed in
the three Monthly Calc screens. FW will then display/combine all
balances/amounts in the same manner (month/quarter/year
period) as you used to input your data, displaying the results in
these Calculation screens.

You should use the Calculation screens first, in reviewing results.
The Monthly Calc screens may then be reviewed for the
spreading of amounts on a monthly basis. Since FW looks at
each cell as a separate calculation, most errors may be clearly
identified from the Calculation screens.

FW provides you with approximately 130 predefined accounts
representing a Cash Statement and extensive ratio analyses. This is
completely pre-programmed. FW prepares this statement and all ratio
analyses for you automatically each time you re-calculate.

FW will also print and convert to Lotus 1-2-3, a cash statement in
accordance with FASB 95 using either the "Direct Method" or the
"Indirect Method."

Full cursor commands are available for moving about the
spreadsheet.

Calculation screens are for display only. You may not make any
changes to the results displayed.





MONTHLY CALCULATION
-------------------

There are three Monthly Calculation screens:

   Balance Sheet - Monthly Calc
   Income Statement - Monthly Calc
   Cash Statement - Monthly Calc

FW will first calculate all results on a monthly basis, displayed in
these three Monthly Calc screens. FW will then display/combine
all balances/amounts in the same manner (month/quarter/year
period) as you used to input your data, displaying the results on
the three Calculation screens.

You should use the Calculation screens first in reviewing results.
The Monthly Calc screens may then be reviewed for the
spreading of amounts on a monthly basis.

After FW determines your positive or negative monthly cash flow,
interest income or expense will be calculated for you and
adjusted for tax effect, based on the current tax rates forecast. All
financial statements will then be changed by FW to reflect these
amounts prior to the calculation by FW of the subsequent month.
Rates of interest and taxes can be set in the Income Statement -
Data Entry screen.

Full cursor commands are available for moving about the
spreadsheet.

Monthly Calc screens are for display only. You may not make any
changes to the results displayed.


                         CURSOR COMMANDS
                         ---------------

        Left/Right                              Command
        Left one cell                           LEFT
        Right one cell                          RIGHT
        Left five cells                         SHIFT + TAB
        Right five cells                        TAB
        To beginning of line                    HOME
        To end of line                          END

        Up/Down
        Line up                                 UP
        Line down                               DOWN
        Up 15 lines                             PGUP
        Down 15 lines                           PGDN
        To top line                             CTRL + PGUP
        To bottom line                          CTRL + PGDN
        To top line - first column              CTRL + HOME
        To bottom line - last column            CTRL + END


                        SPREADSHEET COMMANDS
                        --------------------

        Copy right one cell
                  safety limits                 F2
                  no safety limits              CTRL + F2
        Copy right for curr year
                  safety limits                 F3
                  no safety limits              CTRL + F3
        Copy right for all years
                  safety limits                 F4
                  no safety limits              CTRL + F4

        Change account number                   F5
        Change account description              F6
        Remove mark for deletion                F8
        Delete line                             CTRL + F8
        Add new line                            INS
        Mark line for deletion                  DEL




                         SEASONALITY COMMANDS
                         --------------------

        Copy right one cell                     F2, F3, CTRL+F2, or CTRL+F3
        Copy right one cell (all months)        SHFT+F2 or SHFT+F3
        Copy for all years                      F4 or CTRL+F4
        Copy for all years (all months)         SHFT+F4



                                COLORS
                                ------

        Groupings:  Data Entry, Formula Entry, Calculations and
                    Monthly Calc, Seasonality, Setup


        Portion of Screen       KEY             No. of Colors Available
        -----------------       --------        -----------------------
        Background              ALT + F1                 8
        Cell-block              ALT + F2                16
        Account numbers         ALT + F3                16
        Month/Year heading      ALT + F4                16
        Account descriptions    ALT + F5                16
        Cell amounts            ALT + F6                16
        Menu                    ALT + F7                16
        Menu descriptions       ALT + F8                16
        Statement title         ALT + F9                16
        Default colors
          -all items above      ALT + F10               16



                                SCREENS
                                -------

Destination                               Movement
-----------     ----------------------------------------------------------
                Top Menu    Pull-down       Key
                --------    ----------      ------------------------------
Data Entry      Screens     Data Entry      F1 - from B/S,I/S or C/S
                                            F9 or '/' - from Formula Entry
Historical B/S  Screens     Data Entry      LEFT arrow from 1st column
Formula Entry   Screens     Data Entry      F10
Calculations    Screens     Calculations    F1 - from B/S,I/S or C/S
Monthly Calc    Screens     Monthly Calc    F1 - from B/S,I/S or C/S




SETUP
-----

As was previously noted, FW allows you to enter information in a
combination of monthly, quarterly and annual periods. When you create
a new file, FW will request that you setup the manner in which you will
enter your information. Your spreadsheet headings will then be created
for you automatically. FW will know the size of your period (month,
quarter, or year), therefore only one set of formula methods are needed.

FW re-evaluates your setup each time you re-calculate. Therefore, you
will be allowed to change your period structure, should you choose to do so.

Say you have forecast the first quarter of the year as a quarterly period.
Now, two months later you would like to enter your actual results for the
first two months. FW will allow you to divide the quarterly period into
three monthly periods. You may now enter your results for the first two
months, adjust your forecast for the third month, and re-calculate using
these changes to re-evaluate the remainder of your forecast.

FW will also allow you to combine monthly and quarterly periods
into quarterly and annual periods, respectively. This feature also
allows you to use previously created files as the basis for templates,
changing the periods for Data Entry to fit your new requirements.

  NOTE: If you need to forecast beyond three years, make a template
        out of the first file using the ending balances as the
        opening balances for the next three year forecast, saving
        this as your second file.

        Or, you may purchase our 10 year or 20 year version.


SEASONALITY
-----------

100 Seasonality screens allow for a global change to Seasonality.
Enter your Seasonality on a monthly basis (100 percent for each year
forecast). A formula method using Seasonality can use any one
of the 100 screens available. Changes can be made easily and in
seconds. NO other program features a powerful feature such as this.
In fact, other programs act as if they never heard of Seasonality!



RATIO METHOD
------------

Opinions differ on specific formulas used in calculating various
ratios. The differences are with respect to whether balance sheet
amounts, used in the calculation, should be determined at the
beginning of the period, end of the period or an average of the
current and the previous period. Opinions also differ from ratio to
ratio. This author feels generally that whenever possible an
average should be used. However in an effort to provide the user
a say in this matter, FW has provided the user with the ability to
select how the ratios will be calculated. Each ratio may be
calculated differently.



RATIO SENSITIVITY
-----------------

Forecasting amounts is only part of the story. Ratio analysis is
used extensively by many companies to reflect the direction a
company is heading. Although we provide numerous ratio results
at the end of our Cash Statement, we decided to pump some life
into these numbers.

With your knowledge of your business and with readily
available industry data, we have allowed you to grade your future
- and hopefully change it for the better (in both this forecast and
in actual practice).

This management tool is both easy to use and extremely
powerful. You simply enter (using this screen) your concept of
what you would consider EXCELLENT, GOOD, AVERAGE, FAIR
and POOR. These parameters will then be used to rate your
forecast.

Your entries will be saved with the file, and your grading will be
updated each time you either re-calculate or modify your rating
system.



RATIO CALC
----------

The screen shown above displays the result of your grading one
financial ratio. The gross profit margins, shown above, are those
of the latest re-calculation and are the same as those displayed
in the ratio analysis within the Cash Statement. The grades are
applied based on your pre-determined grading system.

You can change the grading system and review the changes in
this screen without re-calculating the entire file.

By using the cursor keys you can page through 22 ratios.

Both these screens and those showing our descriptive text can
be printed out. FW will only print those ratio screens that you
wish to print.





RATIO REVIEW
------------

While reviewing your Ratio Calc results, you can display our Ratio
Analysis description. Each ratio has its own clear explanation.
Suggestions for management are provided below the explanation.

These descriptive screens can be printed out.




LOTUS SELECTION
---------------

The files created within FW may be selected for conversion into
LOTUS 123 readable files with the press of ONE key. The files
created will be complete with pre-arranged cell widths, range
names by group (ex: Total Current Assets), and SUM of rows or
ranges. The range names will make it easy for you to modify the
123 file, in LOTUS, if you wish.




123 FILES
---------

Once your 123 file has been created, you will have the LOTUS
graph capability, and access to any other product that will
work with 123 files.

In addition, these files can be read by Excel, Supercalc 5 and Quattro.




DOS SHELL
---------

FW can exit to DOS while maintaining your FW program. The
program will call-up a second copy of your COMMAND.COM (make
sure your PATH command has been set in CONFIG.SYS). You
will then be able to perform all of your regular DOS commands.
To return to FW, type EXIT at the DOS prompt. FW will continue
from the point where you left.



TEMPLATE
--------

This feature will allow you to blank amounts, formulas or seasonal
percentages. This allows you to use your completed files as
templates to create new scenarios.



UPPER/LOWER CASE
----------------

FW has a set of screens, which will allow you to convert account
descriptions to Upper or Lower case on a global scale. When you convert
to Lower case the first letter will be capitalized. Use of this feature
can be a nice touch when printing final reports. Selections can be
restricted to either the B/S, I/S or C/S, and can be applied to either
general account descriptions, total accounts such as Total Current Assets,
or special accounts used specifically by FW.




REPORT CUSTOMIZE
----------------

Up to 20 different report layouts may be stored and then selected
for printing.

Generally, all accounts will be printed out. However, sub-accounts
created by the user (such as A/R - #1 Foreign noted in the
demo2.wdr file, and displayed in the manual) can be changed to "Off",
and any amounts in that account will be added to the main account
(such as Accounts Receivable noted in the display in the manual).
The line for that sub-account will not be printed.

Should the main account (accounts in even thousands - ex:
Accounts Receivable is #105000) be changed to "Off", any
amounts in that account will be added to its respective Other
account, such as Other Current Assets or Other Assets.

If both a main account and some or all of its sub-accounts were
turned off for printing, those amounts would be added to its
respective Other account. The sub-accounts left "On" would print
normally.



REPORT PRINTING
---------------

You may select which reports you would like to print.
One of the 20 customized report layouts may then be selected.
Report printing is batch oriented.



PRINT OPTIONS
-------------

You may change your printer setup at any time prior to printing
Printouts or Reports. Using different typefaces or changing the
lines per inch is straightforward.

There are up to 43 different fonts available (availability is printer
dependent). Over 600 dot matrix and laser jet printers are
supported.

If you like small condensed printouts (or reports) try superscript
(16 characters per inch) with 8 lines per inch printing. Or stick
to a standard 10 characters per inch with 6 lines per inch. It's a
snap to change! You can even change the margins on the
printed page and the number of columns printed on each page.
You may also change printers without leaving the program.

Several print drivers may be installed onto your hard drive. This
makes switching equipment easy.




PRINT SELECTION
---------------

All printing within FW is batch oriented, for ease of use. By
moving the cell-block (cursor) over your selections and pressing
Y or N, FW will note which selections you would like printed.
These reports will then be printed consecutively.

Similar print options are also available for printing

                        1) Printouts
                        2) Reports
                        3) Ratio Analyses

--------------------------------------------------------

The following seven Chapters will explain in detail how to
use Financial Wonder.

Chapters 9 through 13 will explain each financial account,
how to enter amounts, and how to create report layouts.

A large Formula Reference section follows these Chapters.
This may be read prior to using FW, or used as the need
arises. Hundreds of examples are provided.

The Example Summary in Chapter 15 can be very useful in
understanding the differences and similarities between the
various formula methods.

Wherever possible, examples have been created using
similar circumstances and amounts. Small amounts have
been used to enhance your understanding.

In some cases, several different methods will arrive at the
same result in a given set of circumstances. As
circumstances change, this may not always hold true. Each
formula method explains these similarities and differences.

Even though two different methods may arrive at similar
results in our examples be alert to calculation differences
between formula methods, as large forecasted amounts will
magnify these differences.

