

                                                               18
                                              B/S Formula Method:
                                             Specify Dollar Units


NUMBER         FORMULA METHOD DESCRIBED
------         ------------------------

101            B/S - Specify Dollar Units
                     Spread Evenly

SCREENS
    All

DATA ENTRY
    Dollar or unit amount

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of either a dollar amount or number of
    capital shares. Any change in the current balance over the earlier
    forecast balance will be divided evenly on a monthly basis.

USE
    One of the easiest methods to understand, this represents a principle
    formula method.

    You as the forecaster determine the account balance as of a particular
    date. FW calculates the monthly balances.

    This formula method behaves similar to methods 105, 111, 115 and 121.

    Formula Method 105 is the same as 101, with the exception that 105
    represents the increment and not the final balance amount. If you plan
    to make changes to earlier forecast periods and wish the current balance
    to also change, then use 105 instead of 101.

    Formula Methods 111, 115 and 121 allow you to state the current period
    as a percentage growth or decline of the earlier forecast balance. If you
    plan to make changes in earlier forecast periods and wish the current
    balance to also change, but by a percentage of the earlier forecast
    balance, then use one of these methods instead of 101.

OVERRIDE
    None




NUMBER         FORMULA METHOD DESCRIBED
------         ------------------------

101            B/S - Specify Dollar Units
                     Spread Evenly


EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $450-December
          Assumption:   None
              Method:   Select Formula Method 101 for the Month Ending
                        December 1990 and enter $450 in the December 1990
                        Data Entry screen. Since the period size is only one
                        month, no spreading is necessary. Formula Methods
                        102, 103 and 104 will produce a similar result.


   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $350-Oct, $400-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Sept 1990) is $300
              Method:   Select Formula Method 101 for the Quarter Ending
                        December 1990 and enter $450 in the December 1990
                        Data Entry screen. The program will spread the
                        difference of $150 between the current and earlier
                        forecast balance in even $50 increments over the
                        current period's monthly amounts.

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $313-Jan, $325-Feb, $338-Mar,
                        $350-Apr, $363-May, $375-Jun,
                        $388-Jul, $400-Aug, $413-Sep,
                        $425-Oct, $438-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Dec 1989) is $300
              Method:   Select Formula Method 101 for the Year Ending
                        December 1990 and enter $450 in the December 1990
                        Data Entry screen. The program will spread the
                        difference of $150 between the current and earlier
                        forecast balance in even $12.50 increments over the
                        current period's monthly amounts. Each calculated
                        balance is rounded up or down to the nearest whole
                        dollar.




NUMBER         FORMULA METHOD DESCRIBED
------         ------------------------

102            B/S - Specify Dollar Units
                     Spread Seasonally

SCREENS
    All

DATA ENTRY
    Dollar or unit amount

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of either a dollar amount or number of
    capital shares. Any change in the current balance over the earlier
    forecast balance will be divided on a monthly weighted seasonal basis.
    The seasonal percentages used are those related to the period chosen, as
    entered in the seasonal screen selected.

USE
    This represents a principle formula method.

    You as the forecaster determine the account balance as of a particular
    date. FW calculates the monthly balances using the seasonal percentages
    input. FW knows which months relate to the current Data Entry period,
    obtains the related seasonal percentages from the seasonal screen,
    calculates a weighted average based on the total of these percentages
    and completes the calculation.

    This formula method behaves similar to methods 106, 112, 116 and 122.

    Formula Method 106 is the same as 102, with the exception that 106
    represents the increment and not the final balance amount. If you plan
    to make changes to earlier forecast periods and wish the current balance
    to also change, then use 106 instead of 102.

    Formula Methods 112, 116 and 122 allow you to state the current period as
    a percentage growth or decline of the earlier forecast balance. If you
    plan to make changes in earlier forecast periods and wish the current
    balance to also change, but by a percentage of the earlier forecast
    balance, then use one of these methods instead of 102.

OVERRIDE
    None





NUMBER         FORMULA METHOD DESCRIBED
------         ------------------------

102            B/S - Specify Dollar Units
                     Spread Seasonally

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $450-December
          Assumption:   None
              Method:   Select Formula Method 102 for the Month Ending
                        December 1990 and enter $450 in the December 1990
                        Data Entry screen. Since the period size is only one
                        month, no spreading is necessary. Formula Methods
                        101, 103 and 104 will produce a similar result.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $380-Oct, $423-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Sept 1990) is $300
                        Seasonal Percentages are
                        15pct-Oct, 8pct-Nov, 5pct-Dec
              Method:   Select Formula Method 102 for the Quarter Ending
                        December 1990 and enter $450 in the December 1990
                        Data Entry screen. The program will spread the
                        difference of $150 between the current and earlier
                        forecast balance based on a weighted average of
                        seasonal percentages for that quarter. The difference
                        between $450.00 expected and $450.01 calculated will
                        be allocated on a weighted average basis.
   Oct = $380.36 = $300.00 + $150*(15pct/(15pct+8pct+5pct))
   Nov = $423.22 = $380.36 + $150*( 8pct/(15pct+8pct+5pct))
   Dec = $450.01 = $423.22 + $150*( 5pct/(15pct+8pct+5pct))

   Difference = $0.01 = ($450 - $450.01)

   Oct = $380 = $380.35 = $380.36 - ($380.36-300.00)/($450.01-300.00)*$0.01
   Nov = $423 = $423.21 = $423.22 - ($423.22-300.00)/($450.01-300.00)*$0.01
   Dec = $450 = $450.00 = $450.01 - ($450.01-300.00)/($450.01-300.00)*$0.01



   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $323-Jan, $330-Feb, $338-Mar,
                        $353-Apr, $368-May, $383-Jun,
                        $393-Jul, $404-Aug, $408-Sep,
                        $431-Oct, $443-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Dec 1989) is $300
                        Seasonal Percentages are
                        15pct-Jan,  5pct-Feb,  5pct-Mar,
                        10pct-Apr, 10pct-May, 10pct-Jun,
                         7pct-Jul,  7pct-Aug,  3pct-Sep,
                        15pct-Oct,  8pct-Nov,  5pct-Dec
              Method:   Select Formula Method 102 for the Year Ending
                        December 1990 and enter $450 in the December 1990
                        Data Entry screen. The program will spread the
                        difference of $150 between the current and earlier
                        forecast balance based on a weighted average of
                        seasonal percentages for that year.
   Jan = $323 = $322.50 = $300.00 + $150 * 15pct
   Feb = $330 = $330.00 = $322.50 + $150 *  5pct
   Mar = $338 = $337.50 = $330.00 + $150 *  5pct
   Apr = $353 = $352.50 = $337.50 + $150 * 10pct
   May = $368 = $367.50 = $352.50 + $150 * 10pct
   Jun = $383 = $382.50 = $367.50 + $150 * 10pct
   Jul = $393 = $393.00 = $382.50 + $150 *  7pct
   Aug = $404 = $403.50 = $393.00 + $150 *  7pct
   Sep = $408 = $408.00 = $403.50 + $150 *  3pct
   Oct = $431 = $430.50 = $408.00 + $150 * 15pct
   Nov = $443 = $442.50 = $430.50 + $150 *  8pct
   Dec = $450 = $450.00 = $442.50 + $150 *  5pct







NUMBER         FORMULA METHOD DESCRIBED
------         ------------------------

103            B/S - Specify Dollar Units
                     Spread by Geometric Progression

SCREENS
    All

DATA ENTRY
    Dollar or unit amount

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of either a dollar amount or number of
    capital shares. Any change in the current balance over the earlier
    forecast balance will be divided in such a manner as to create a constant
    rate of growth across the monthly balances.

USE
    This represents a principle formula method.

    You as the forecaster determine the account balance as of a particular
    date. FW calculates the monthly balances in such a manner as to create a
    constant rate of growth across the monthly balances. The growth rate
    assumes a monthly compounding of the rate.

    The computed growth rate is very accurate. The user will notice a slight
    change in the growth rate as a result of rounding the individual results
    to the nearest whole dollar. All monthly amounts within a Data Entry
    period are first calculated using the calculated growth rate before
    rounding is performed. Future forecast periods and the use of these
    amounts as a linked account refer to the final whole dollar results.

    This formula method behaves similar to methods 107, 113, 117 and 123.

    Formula Method 107 is the same as 103, with the exception that 107
    represents the increment and not the final balance amount. If you plan to
    make changes to earlier forecast periods and wish the current balance to
    also change, then use 107 instead of 103.

    Formula Methods 113, 117 and 123 allow you to state the current period as
    a percentage growth or decline of the earlier forecast balance. If you
    plan to make changes in earlier forecast periods and wish the current
    balance to also change, but by a percentage of the earlier forecast
    balance, then use one of these methods instead of 103.

OVERRIDE
    If the previous Data Entry period or opening (historical) balance sheet,
    income or cash statement amount is $0, then Formula Method 103 will not
    be used by FW. Instead Formula Method 101 will be used by default.
    (see also chapter 16)
    NO ERROR MESSAGE WILL BE RETURNED!




NUMBER         FORMULA METHOD DESCRIBED
------         ------------------------

103            B/S - Specify Dollar Units
                     Spread by Geometric Progression

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $450-December
          Assumption:   None
              Method:   Select Formula Method 103 for the Month Ending
                        December 1990 and enter $450 in the December 1990
                        Data Entry screen. Since the period size is only one
                        month, no spreading is necessary. Formula Methods
                        101, 102 and 104 will produce a similar result.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $422-Oct, $436-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Sept 1990) is $409
              Method:   Select Formula Method 103 for the Quarter Ending
                        December 1990 and enter $450 in the December 1990
                        Data Entry screen. The program will spread the
                        difference of $41 between the current and earlier
                        forecast balance in such a manner as to create a
                        constant rate of growth across the monthly balances.
   (1/12 yr = 1.0079928089 - calc by FW :
    4/12 yr = 1.0323565920 = 1.0079928089^4)

   Oct = $422 = $422.23 =$409 * 1.0323565920 :(1.0079928089^4)
   Nov = $436 = $435.90 =$409 * 1.0657601330 :(1.0079928089^8)
   Dec = $450 = $450.00 =$409 * 1.1002444988 :(1.0079928089^12)

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $412-Jan, $416-Feb, $419-Mar,
                        $422-Apr, $426-May, $429-Jun,
                        $432-Jul, $436-Aug, $439-Sep,
                        $443-Oct, $446-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Dec 1989) is $409
              Method:   Select Formula Method 103 for the Year Ending
                        December 1990 and enter $450 in the December 1990
                        Data Entry screen. The program will spread the
                        difference of $41 between the current and earlier
                        forecast balance in such a manner as to create a
                        constant rate of growth across the monthly balances.
   Jan = $412 = $412.27 = $409 * 1.0079928089 :(calc by FW)
   Feb = $416 = $415.56 = $409 * 1.0160495027 :(1.0079928089^2)
   Mar = $419 = $418.89 = $409 * 1.0241705922 :(1.0079928089^3)
   Apr = $422 = $422.23 = $409 * 1.0323565920 :(1.0079928089^4)
   May = $426 = $425.61 = $409 * 1.0406080209 :(1.0079928089^5)
   Jun = $429 = $429.01 = $409 * 1.0489254019 :(1.0079928089^6)
   Jul = $432 = $432.44 = $409 * 1.0573092622 :(1.0079928089^7)
   Aug = $436 = $435.90 = $409 * 1.0657601330 :(1.0079928089^8)
   Sep = $439 = $439.38 = $409 * 1.0742785500 :(1.0079928089^9)
   Oct = $443 = $442.89 = $409 * 1.0828650532 :(1.0079928089^10)
   Nov = $446 = $446.43 = $409 * 1.0915201866 :(1.0079928089^11)
   Dec = $450 = $450.00 = $409 * 1.1002444988 :(1.0079928089^12)





NUMBER         FORMULA METHOD DESCRIBED
------         ------------------------

104            B/S - Specify Dollar Units
                     Spread by Geometric Prog - Seasonally

SCREENS
    All

DATA ENTRY
    Dollar or unit amount

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of either a dollar amount or number of
    capital shares. Any change in the current balance over the earlier
    forecast balance will be divided in such a manner as to create a constant
    rate of growth across the monthly balances. These results (prior to
    rounding to the nearest whole dollar) are then adjusted on a monthly
    weighted seasonal basis. The seasonal percentages used are those related
    to the period chosen, as entered in the seasonal screen selected.

USE
    This represents a principle formula method.

    You as the forecaster determine the account balance as of a particular
    date. FW calculates the monthly balances in such a manner as to create a
    constant rate of growth across the monthly balances. The growth rate
    assumes a monthly compounding of the rate. FW then uses the seasonal
    percentages input. The program knows which months relate to the current
    Data Entry period, obtains the related seasonal percentages from the
    seasonal screen, calculates a weighted average based on the total of
    these percentages and completes the calculation.

    The computed growth rate is very accurate. The user will notice a slight
    change in the growth rate as a result of rounding the individual results
    to the nearest whole dollar. All monthly amounts within a Data Entry
    period are first calculated using the calculated growth rate and then
    seasonally adjusted before rounding is performed. Future forecast periods
    and the use of these amounts as a linked account refer to the final whole
    dollar results.

    This formula method behaves similar to methods 108, 114, 118 and 124.

    Formula Method 108 is the same as 104, with the exception that 108
    represents the increment and not the final balance amount. If you plan to
    make changes to earlier forecast periods and wish the current balance to
    also change, then use 108 instead of 104.

    Formula Methods 114, 118 and 124 allow you to state the current period as
    a percentage growth or decline of the earlier forecast balance. If you
    plan to make changes in earlier forecast periods and wish the current
    balance to also change, but by a percentage of the earlier forecast
    balance, then use one of these methods instead of 104.

OVERRIDE
    If the previous Data Entry period or opening (historical) balance sheet,
    income or cash statement amount is $0, then Formula Method 104 will not
    be used by FW. Instead Formula Method 102 will be used by default.
    (see also chapter 16)
    NO ERROR MESSAGE WILL BE RETURNED!




NUMBER         FORMULA METHOD DESCRIBED
------         ------------------------

104            B/S - Specify Dollar Units
                     Spread by Geometric Prog - Seasonally

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $450-December
          Assumption:   None
              Method:   Select Formula Method 104 for the Month Ending
                        December 1990 and enter $450 in the December 1990
                        Data Entry screen. Since the period size is only one
                        month, no spreading is necessary. Formula Methods
                        101, 102 and 103 will produce a similar result.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $431-Oct, $442-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Sep 1990) is $409
              Method:   Select Formula Method 104 for the Quarter Ending
                        December 1990 and enter $450 in the December 1990
                        Data Entry screen. The program will spread the
                        difference of $41 between the current and earlier
                        forecast balance in such a manner as to create a
                        constant rate of growth across the monthly balances.
                        These results are then adjusted on a monthly weighted
                        seasonal basis. The difference between $450.00
                        expected and $449.54 calculated will be allocated
                        on a weighted average basis.
(1/12 yr = .0079928089 - calc by FW :
 4/12 yr = .0323565920 = 1.0079928089^4 - 1)

Oct = $430.27 = $409.00+($409 *  .0323565920 * (15pct/(28pct/3)))
Nov = $441.98 = $430.27+($409 * (.0657601330 -.0323565920)*( 8pct/(28pct/3)))
Dec = $449.54 = $441.98+($409 * (.1002444988 -.0657601330)*( 5pct/(28pct/3)))

Difference = $0.46 = ($450.00 - $449.54)

Oct = $431 = $430.51 = $430.27 + ($430.27 - 409.00)/($449.54 - 409.00)*$0.46
Nov = $442 = $442.35 = $441.98 + ($441.98 - 409.00)/($449.54 - 409.00)*$0.46
Dec = $450 = $450.00 = $449.54 + ($449.54 - 409.00)/($449.54 - 409.00)*$0.46

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $415-Jan, $417-Feb, $419-Mar,
                        $423-Apr, $427-May, $431-Jun,
                        $434-Jul, $437-Aug, $438-Sep,
                        $444-Oct, $448-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Dec 1989) is $409
              Method:   Select Formula Method 104 for the Year Ending
                        December 1990 and enter $450 in the December 1990
                        Data Entry screen. The program will spread the
                        difference of $41 between the current and earlier
                        forecast balance in such a manner as to create a
                        constant rate of growth across the monthly balances.
                        These results are then adjusted on a monthly weighted
                        seasonal basis. The difference between $450.00
                        expected and $449.90 calculated will be allocated
                        on a weighted average basis.
  (Jan .0079928089 is calc by FW :
   Feb .0160495027 = 1.0079928089^2 - 1)

  Jan = $414.88=$409.00+($409*.0079928089 * (15pct/(100pct/12pct)))
  Feb = $416.86=$414.88+($409*(.0160495027 -.0079928089)* (5pct/(100pct/12)))
  Mar = $418.85=$416.86+($409*(.0241705922 -.0160495027)* (5pct/(100pct/12)))
  Apr = $422.87=$418.85+($409*(.0323565920 -.0241705922)*(10pct/(100pct/12)))
  May = $426.92=$422.87+($409*(.0406080209 -.0323565920)*(10pct/(100pct/12)))
  Jun = $431.00=$426.92+($409*(.0489254019 -.0406080209)*(10pct/(100pct/12)))
  Jul = $433.88=$431.00+($409*(.0573092622 -.0489254019)* (7pct/(100pct/12)))
  Aug = $436.79=$433.88+($409*(.0657601330 -.0573092622)* (7pct/(100pct/12)))
  Sep = $438.04=$436.79+($409*(.0742785500 -.0657601330)* (3pct/(100pct/12)))
  Oct = $444.36=$438.04+($409*(.0828650532 -.0742785500)*(15pct/(100pct/12)))
  Nov = $447.76=$444.36+($409*(.0915201866 -.0828650532)* (8pct/(100pct/12)))
  Dec = $449.90=$447.76+($409*(.1002444988 -.0915201866)* (5pct/(100pct/12)))

  Difference = $0.10 = ($450.00 - $449.90)

  Jan = $415 = $414.89 = $414.88 + ($414.88-409.00)/($449.90-409.00)*$0.10
  Feb = $417 = $416.88 = $416.86 + ($416.86-409.00)/($449.90-409.00)*$0.10
  Mar = $419 = $418.87 = $418.85 + ($418.85-409.00)/($449.90-409.00)*$0.10
  Apr = $423 = $422.90 = $422.87 + ($422.87-409.00)/($449.90-409.00)*$0.10
  May = $427 = $426.96 = $426.92 + ($426.92-409.00)/($449.90-409.00)*$0.10
  Jun = $431 = $431.05 = $431.00 + ($431.00-409.00)/($449.90-409.00)*$0.10
  Jul = $434 = $433.94 = $433.88 + ($433.88-409.00)/($449.90-409.00)*$0.10
  Aug = $437 = $436.86 = $436.79 + ($436.79-409.00)/($449.90-409.00)*$0.10
  Sep = $438 = $438.11 = $438.04 + ($438.04-409.00)/($449.90-409.00)*$0.10
  Oct = $444 = $444.45 = $444.36 + ($444.36-409.00)/($449.90-409.00)*$0.10
  Nov = $448 = $447.85 = $447.76 + ($447.76-409.00)/($449.90-409.00)*$0.10
  Dec = $450 = $450.00 = $449.90 + ($449.90-409.00)/($449.90-409.00)*$0.10
