

                                                               22
                                              B/S Formula Method:
                                          Annual Percent Increase


NUMBER           FORMULA METHOD DESCRIBED
------           ------------------------

121              B/S - Annual Rate
                       Adj for Period Size diff
                       Spread Evenly

SCREENS
    All

DATA ENTRY
    Percentage

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of an annual change (growth or decline) of
    the earlier forecast balance to arrive at the current balance. The
    percent change will be adjusted if the size of the current Data Entry
    period is other than one year.

           Size of Cur Prd    Percent Entered    Percent Change Used
           ---------------    ---------------    -------------------
           Month              10pct              .8333pct
           Quarter            10pct              2.5pct
           Year               10pct              10pct

           Month              120pct             10pct
           Quarter            40pct              10pct
           Year               10pct              10pct

    Any change in the current balance over the earlier forecast balance will
    be divided evenly on a monthly basis.

USE
    You as the forecaster determine the amount of annual growth or decline in
    the account balance over the earlier forecast balance as of a particular
    date. This amount is adjusted for period size differences. FW then
    calculates the monthly balances.

    This formula method behaves similar to methods 101, 105, 111 and 115.

    Formula Method 101 is the same as 121, with the exception that 101
    represents the final balance amount and not the increment. If you do not
    wish the current balance to fluctuate in response to changes to earlier
    forecast periods, then use 101 instead of 121.

    Formula Method 105 allows you to state the current period as an amount
    instead of as a percentage.

    Formula Methods 111 and 115 allow you to state the current period as a
    general growth rate instead of an annual percentage.

OVERRIDE
    None




NUMBER           FORMULA METHOD DESCRIBED
------           ------------------------

121              B/S - Annual Rate
                       Adj for Period Size diff
                       Spread Evenly


EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $450-December
          Assumption:   Earlier forecast bal (Nov 1990) is $300
              Method:   Select Formula Method 121 for the Month Ending
                        December 1990 and enter 600pct in the December 1990
                        Data Entry screen. The 600pct will be size adjusted
                        to 50pct. Since the period size is only one month, no
                        spreading is necessary. Formula Methods 122, 123 and
                        124 will produce a similar result.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $350-Oct, $400-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Sep 1990) is $300
              Method:   Select Formula Method 121 for the Quarter Ending
                        December 1990 and enter 200pct in the December 1990
                        Data Entry screen. The program will spread the
                        difference of $150 between the current and earlier
                        forecast balance in even $50 increments over the
                        current period's monthly amounts.

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $313-Jan, $325-Feb, $338-Mar,
                        $350-Apr, $363-May, $375-Jun,
                        $388-Jul, $400-Aug, $413-Sep,
                        $425-Oct, $438-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Dec 1989) is $300
              Method:   Select Formula Method 121 for the Year Ending
                        December 1990 and enter 50pct in the December 1990
                        Data Entry screen. The program will spread the
                        difference of $150 between the current and earlier
                        forecast balance in even $12.50 increments over the
                        current period's monthly amounts. Each calculated
                        balance is rounded up or down to the nearest whole
                        dollar.




NUMBER           FORMULA METHOD DESCRIBED
------           ------------------------

122              B/S - Annual Rate
                       Adj of Period Size diff
                       Spread Seasonally

SCREENS
    All

DATA ENTRY
    Percentage

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of an annual change (growth or decline) of
    the earlier forecast balance to arrive at the current balance. The
    percent change will be adjusted if the size of the current Data Entry
    period is other than one year.

            Size of Cur Prd    Percent Entered    Percent Change Used
            ---------------    ---------------    -------------------
            Month              10pct              .8333pct
            Quarter            10pct              2.5pct
            Year               10pct              10pct

            Month              120pct             10pct
            Quarter            40pct              10pct
            Year               10pct              10pct

    Any change in the current balance over the earlier forecast balance will
    be divided on a monthly weighted seasonal basis. The seasonal
    percentages used are those related to the period chosen, as entered in
    the seasonal screen selected.

USE
    You as the forecaster determine the amount of annual growth or decline in
    the account balance over the earlier forecast balance as of a particular
    date. This amount is adjusted for period size differences. FW then
    calculates the monthly balances using the seasonal percentages input. FW
    knows which months relate to the current Data Entry period, obtains the
    related seasonal percentages from the seasonal screen, calculates a
    weighted average based on the total of these percentages and completes
    the calculation.

    This formula method behaves similar to methods 102, 106, 112 and 116.

    Formula Method 102 is the same as 122, with the exception that 102
    represents the final balance amount and not the increment. If you do not
    wish the current balance to fluctuate in response to changes to earlier
    forecast periods ,then use 102 instead of 122.

    Formula Method 106 allows you to state the current period as an amount
    instead of as a percentage.

    Formula Methods 112 and 116 allows you to state the current period as a
    general growth rate instead of an annual percentage.

OVERRIDE
    None






NUMBER           FORMULA METHOD DESCRIBED
------           ------------------------

122              B/S - Annual Rate
                       Adj for Period Size diff
                       Spread Seasonally


EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $450-December
          Assumption:   Earlier forecast bal (Nov 1990) is $300
              Method:   Select Formula Method 122 for the Month Ending
                        December 1990 and enter 600pct in the December 1990
                        Data Entry screen. The 600pct will be size adjusted
                        to 50pct. Since the period size is only one month, no
                        spreading is necessary. Formula Methods 121, 123 and
                        124 will produce a similar result.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $380-Oct, $423-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Sep 1990) is $300
                        Seasonal Percentages are
                        15pct-Oct, 8pct-Nov, 5pct-Dec
              Method:   Select Formula Method 122 for the Quarter Ending
                        December 1990 and enter 200pct in the December 1990
                        Data Entry screen. The program will spread the
                        difference of $150 between the current and earlier
                        forecast balance based on a weighted average of
                        seasonal percentages for that quarter. The difference
                        between $450 expected and $450.01 calculated will be
                        allocated on a weighted average basis.
  Oct = $380.36 = $300.00 + $150*(15pct/(15pct+8pct+5pct))
  Nov = $423.22 = $380.36 + $150*( 8pct/(15pct+8pct+5pct))
  Dec = $450.01 = $423.22 + $150*( 5pct/(15pct+8pct+5pct))

  Difference = $0.01 = ($450 - $450.01)

  Oct = $380 = $380.35 = $380.36 - ($380.36-300.00)/($450.01-300.00)*$0.01
  Nov = $423 = $423.21 = $423.22 - ($423.22-300.00)/($450.01-300.00)*$0.01
  Dec = $450 = $450.00 = $450.01 - ($450.01-300.00)/($450.01-300.00)*$0.01

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $323-Jan, $330-Feb, $338-Mar,
                        $353-Apr, $368-May, $383-Jun,
                        $393-Jul, $404-Aug, $408-Sep,
                        $431-Oct, $443-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Dec 1989) is $300
                        Seasonal Percentages are
                        15pct-Jan,  5pct-Feb,  5pct-Mar,
                        10pct-Apr, 10pct-May, 10pct-Jun,
                         7pct-Jul,  7pct-Aug,  3pct-Sep,
                        15pct-Oct,  8pct-Nov,  5pct-Dec
              Method:   Select Formula Method 122 for the Year Ending
                        December 1990 and enter 50pct in the December 1990
                        Data Entry screen. The program will spread the
                        difference of $150 between the current and earlier
                        forecast balance based on a weighted average of
                        seasonal percentages for that year.
   Jan = $323 = $322.50 = $300.00 + $150 * 15pct
   Feb = $330 = $330.00 = $322.50 + $150 *  5pct
   Mar = $338 = $337.50 = $330.00 + $150 *  5pct
   Apr = $353 = $352.50 = $337.50 + $150 * 10pct
   May = $368 = $367.50 = $352.50 + $150 * 10pct
   Jun = $383 = $382.50 = $367.50 + $150 * 10pct
   Jul = $393 = $393.00 = $382.50 + $150 *  7pct
   Aug = $404 = $403.50 = $393.00 + $150 *  7pct
   Sep = $408 = $408.00 = $403.50 + $150 *  3pct
   Oct = $431 = $430.50 = $408.00 + $150 * 15pct
   Nov = $443 = $442.50 = $430.50 + $150 *  8pct
   Dec = $450 = $450.00 = $442.50 + $150 *  5pct




NUMBER           FORMULA METHOD DESCRIBED
------           ------------------------

123              B/S - Annual Rate
                       Adj for Period Size diff
                       Spread by Geometric Progression

SCREENS
    All

DATA ENTRY
    Percentage

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of an annual change (growth or decline) of
    the earlier forecast balance to arrive at the current balance. The
    percent change will be adjusted if the size of the current Data Entry
    period is other than one year.

            Size of Cur Prd    Percent Entered    Percent Change Used
            ---------------    ---------------    -------------------
            Month              10pct              .8333pct
            Quarter            10pct              2.5pct
            Year               10pct              10pct

            Month              120pct             10pct
            Quarter            40pct              10pct
            Year               10pct              10pct

    Any change in the current balance over the earlier forecast balance will
    be divided in such a manner as to create a constant rate of growth across
    the monthly balances.

USE
    You as the forecaster determine the amount of annual growth or decline in
    the account balance over the earlier forecast balance as of a particular
    date. This amount is adjusted for period size differences. FW then
    calculates the monthly balances in such a manner as to create a constant
    rate of growth across the monthly balances. The growth rate assumes a
    monthly compounding of the rate.

    The computed growth rate is very accurate. The user will notice a slight
    change in the growth rate as a result of rounding the individual results
    to the nearest whole dollar. All monthly amounts within a Data Entry
    period are first calculated using the calculated growth rate before
    rounding is performed. Future forecast periods and the use of these
    amounts as a linked account refer to the final whole dollar results.

    This formula method behaves similar to methods 103, 107, 113 and 117.

    Formula Method 103 is the same as 123, with the exception that 103
    represents the final balance amount and not the increment. If you do not
    wish the current balance to fluctuate in response to changes to earlier
    forecast periods, then use 103 instead of 123.

    Formula Method 107 allows you to state the current period as an amount
    instead of as a percentage.

    Formula Methods 113 and 117 allows you to state the current period as a
    general growth rate instead of an annual percentage.

OVERRIDE
    If the previous Data Entry period or opening (historical) balance sheet,
    income or cash statement amount is $0, then Formula Method 123 will not
    be used by FW. Instead Formula Method 121 will be used by default.
    (see also chapter 16)
    NO ERROR MESSAGE WILL BE RETURNED!





NUMBER           FORMULA METHOD DESCRIBED
------           ------------------------

123              B/S - Annual Rate
                       Adj for Period Size diff
                       Spread by Geometric Progression

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $450-December
          Assumption:   Earlier forecast bal (Nov 1990) is $409
              Method:   Select Formula Method 123 for the Month Ending
                        December 1990 and enter 120pct in the December 1990
                        Data Entry screen. The 120pct will be size adjusted
                        to 10pct. Since the period size is only one month, no
                        spreading is necessary. Formula Methods 121, 122 and
                        124 will produce a similar result.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $422-Oct, $436-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Sep 1990) is $409
              Method:   Select Formula Method 123 for the Quarter Ending
                        December 1990 and enter 40pct in the December 1990
                        Data Entry screen. The 40pct will be size adjusted to
                        10pct and the program will spread the difference of
                        $41 between the current and earlier forecast balance
                        in such a manner as to create a constant rate of
                        growth across the monthly balances.
   Oct = $422 = $422.20 = $409 * 1.0322801155 :(calc by FW)
   Nov = $436 = $435.83 = $409 * 1.0656022368 :(1.0079741404^8)
   Dec = $450 = $449.90 = $409 * 1.1000000000 :(1.0079741404^12)

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $412-Jan, $416-Feb, $419-Mar,
                        $422-Apr, $426-May, $429-Jun,
                        $432-Jul, $436-Aug, $439-Sep,
                        $443-Oct, $446-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Dec 1989) is $409
              Method:   Select Formula Method 123 for the Year Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen. The program will spread the
                        difference of $41 between the current and earlier
                        forecast balance in such a manner as to create a
                        constant rate of growth across the monthly balances.
   Jan = $412 = $412.26 = $409 * 1.0079741404 :(calc by FW)
   Feb = $416 = $415.55 = $409 * 1.0160118678 :(1.0079741404^2)
   Mar = $419 = $418.86 = $409 * 1.0241136891 :(1.0079741404^3)
   Apr = $422 = $422.20 = $409 * 1.0322801155 :(1.0079741404^4)
   May = $426 = $425.57 = $409 * 1.0405116621 :(1.0079741404^5)
   Jun = $429 = $428.96 = $409 * 1.0488088482 :(1.0079741404^6)
   Jul = $432 = $432.38 = $409 * 1.0571721972 :(1.0079741404^7)
   Aug = $436 = $435.83 = $409 * 1.0656022368 :(1.0079741404^8)
   Sep = $439 = $439.31 = $409 * 1.0740994986 :(1.0079741404^9)
   Oct = $443 = $442.81 = $409 * 1.0826645189:(1.0079741404^10)
   Nov = $446 = $446.34 = $409 * 1.0912978378:(1.0079741404^11)
   Dec = $450 = $449.90 = $409 * 1.1000000000:(1.0079741404^12)




NUMBER           FORMULA METHOD DESCRIBED
------           ------------------------

124              B/S - Annual Rate
                       Adj for Period Size diff
                       Spread by Geometric Prog - Seasonally

SCREENS
    All

DATA ENTRY
    Percentage

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of an annual change (growth or decline) of
    the earlier forecast balance to arrive at the current balance. The
    percent change will be adjusted if the size of the current Data Entry
    period is other than one year.

             Size of Cur Prd    Percent Entered    Percent Change Used
             ---------------    ---------------    -------------------
             Month              10pct              .8333pct
             Quarter            10pct              2.5pct
             Year               10pct              10pct

             Month              120pct             10pct
             Quarter            40pct              10pct
             Year               10pct              10pct

    Any change in the current balance over the earlier forecast balance will
    be divided in such a manner as to create a constant rate of growth across
    the monthly balances. These results (prior to rounding to the nearest
    whole dollar) are then adjusted on a monthly weighted seasonal basis. The
    seasonal percentages used are those related to the period chosen, as
    entered in the seasonal screen selected.

USE
    You as the forecaster determine the amount of annual growth or decline in
    the account balance over the earlier forecast balance as of a particular
    date. This amount is adjusted for period size differences. FW then
    calculates the monthly balances in such a manner as to create a constant
    rate of growth across the monthly balances. The growth rate assumes a
    monthly compounding of the rate. FW then uses the seasonal percentages
    input. The program knows which months relate to the current Data Entry
    period, obtains the related seasonal percentages from the seasonal
    screen, calculates a weighted average based on the total of these
    percentages and completes the calculation.

    The computed growth rate is very accurate. The user will notice a slight
    change in the growth rate as a result of rounding the individual results
    to the nearest whole dollar. All monthly amounts within a Data Entry
    period are first calculated using the calculated growth rate and then
    seasonally adjusted before rounding is performed. Future forecast periods
    and the use of these amounts as a linked account refer to the final whole
    dollar results.

    This formula method behaves similar to methods 104, 108, 114 and 118.

    Formula Method 104 is the same as 124, with the exception that 104
    represents the final balance amount and not the increment. If you do not
    wish the current balance to fluctuate in response to changes to earlier
    forecast periods ,then use 104 instead of 124.

    Formula Method 108 allows you to state the current period as an amount
    instead of as a percentage.

    Formula Methods 114 and 118 allow you to state the current period as a
    general growth rate instead of an annual percentage.

OVERRIDE
    If the previous Data Entry period or opening (historical) balance sheet,
    income or cash statement amount is $0, then Formula Method 124 will not
    be used by FW. Instead Formula Method 122 will be used by default.
    (see also chapter 16)
    NO ERROR MESSAGE WILL BE RETURNED!





NUMBER           FORMULA METHOD DESCRIBED
------           ------------------------

124              B/S - Annual Rate
                       Adj for Period Size diff
                       Spread by Geometric Prog - Seasonally

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $450-December
          Assumption:   Earlier forecast bal (Nov 1990) is $409
              Method:   Select Formula Method 124 for the Month Ending
                        December 1990 and enter 120pct in the December 1990
                        Data Entry screen. The 120pct will be size adjusted
                        to 10pct. Since the period size is only one month, no
                        spreading is necessary. Formula Methods 121, 122 and
                        123 will produce a similar result.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $430-Oct, $442-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Sep 1990) is $409
                        Seasonal Percentages are
                        15pct-Oct, 8pct-Nov, 5pct-Dec
              Method:   Select Formula Method 124 for the Quarter Ending
                        December 1990 and enter 40pct in the December 1990
                        Data Entry screen. The 40pct will be size adjusted to
                        10pct ($409 * 1.1 = $449.90) and the program will
                        spread the difference of $41 between the current and
                        earlier forecast balance in such a manner as to
                        create a constant rate of growth across the monthly
                        balances. These results are then adjusted on a
                        monthly weighted seasonal basis. The difference
                        between $450 expected and $449.44 calculated will be
                        allocated on a weighted average basis.
(1/12 yr = .0079741404 - calc by FW :
 4/12 yr = .0322801155 = 1.0079741404^4 - 1)

Oct = $430.22 = $409.00+($409 *  .0322801155 * (15pct/(28pct/3)))
Nov = $441.90 = $430.22+($409 * (.0656022368 -.0322801155)*( 8pct/(28pct/3)))
Dec = $449.44 = $441.90+($409 * (.1000000000 -.0656022368)*( 5pct/(28pct/3)))

Difference = $0.46 = ($449.90 - $449.44)

Oct = $430 = $430.46 = $430.22 + ($430.22 - 409.00)/($449.44 - 409.00)*$0.46
Nov = $442 = $442.27 = $441.90 + ($441.90 - 409.00)/($449.44 - 409.00)*$0.46
Dec = $450 = $449.90 = $449.44 + ($449.44 - 409.00)/($449.44 - 409.00)*$0.46

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $415-Jan, $417-Feb, $419-Mar,
                        $423-Apr, $427-May, $431-Jun,
                        $434-Jul, $437-Aug, $438-Sep,
                        $444-Oct, $448-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Dec 1989) is $409
                        Seasonal Percentages are
                        15pct-Jan,  5pct-Feb,  5pct-Mar,
                        10pct-Apr, 10pct-May, 10pct-Jun,
                         7pct-Jul,  7pct-Aug,  3pct-Sep,
                        15pct-Oct,  8pct-Nov,  5pct-Dec
              Method:   Select Formula Method 124 for the Year Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen ($409 * 1.1 = $449.90. The program
                        will spread the difference of $41 between the current
                        and earlier forecast balance in such a manner as to
                        create a constant rate of growth across the monthly
                        balances. These results are then adjusted on a
                        monthly weighted seasonal basis. The difference
                        between $450 expected and $449.80 calculated will be
                        allocated on a weighted average basis.
(Jan .0079741404 is calc by FW :
 Feb .0160118678 = 1.0079741404^2 - 1)

Jan = $414.87=$409.00+($409*.0079741404 * (15pct/(100pct/12pct)))
Feb = $416.84=$414.87+($409*(.0160118678 -.0079741404) * (5pct/(100pct/12)))
Mar = $418.83=$416.84+($409*(.0241136891 -.0160118678) * (5pct/(100pct/12)))
Apr = $422.84=$418.83+($409*(.0322801155 -.0241136891) *(10pct/(100pct/12)))
May = $426.88=$422.84+($409*(.0405116621 -.0322801155) *(10pct/(100pct/12)))
Jun = $430.95=$426.88+($409*(.0488088482 -.0405116621) *(10pct/(100pct/12)))
Jul = $433.82=$430.95+($409*(.0571721972 -.0488088482) * (7pct/(100pct/12)))
Aug = $436.72=$433.82+($409*(.0656022368 -.0571721972) * (7pct/(100pct/12)))
Sep = $437.97=$436.72+($409*(.0740994986 -.0656022368) * (3pct/(100pct/12)))
Oct = $444.28=$437.97+($409*(.0826645189 -.0740994986) *(15pct/(100pct/12)))
Nov = $447.67=$444.28+($409*(.0912978378 -.0826645189) * (8pct/(100pct/12)))
Dec = $449.80=$444.28+($409*(.1000000000 -.0912978378) * (5pct/(100pct/12)))

Difference = $0.10 = ($449.90 - $449.80)

Jan = $415 = $414.88 = $414.87 + ($414.87 - 409.00)/($449.80 - 409.00)*$0.10
Feb = $417 = $416.86 = $416.84 + ($416.84 - 409.00)/($449.80 - 409.00)*$0.10
Mar = $419 = $418.85 = $418.83 + ($418.83 - 409.00)/($449.80 - 409.00)*$0.10
Apr = $423 = $422.87 = $422.84 + ($422.84 - 409.00)/($449.80 - 409.00)*$0.10
May = $427 = $426.92 = $426.88 + ($426.88 - 409.00)/($449.80 - 409.00)*$0.10
Jun = $431 = $431.00 = $430.95 + ($430.95 - 409.00)/($449.80 - 409.00)*$0.10
Jul = $434 = $433.88 = $433.82 + ($433.82 - 409.00)/($449.80 - 409.00)*$0.10
Aug = $437 = $436.79 = $436.72 + ($436.72 - 409.00)/($449.80 - 409.00)*$0.10
Sep = $438 = $438.04 = $437.97 + ($437.97 - 409.00)/($449.80 - 409.00)*$0.10
Oct = $444 = $444.37 = $444.28 + ($444.28 - 409.00)/($449.80 - 409.00)*$0.10
Nov = $448 = $447.76 = $447.67 + ($447.67 - 409.00)/($449.80 - 409.00)*$0.10
Dec = $450 = $449.90 = $449.80 + ($449.80 - 409.00)/($449.80 - 409.00)*$0.10


