

                                                               23
                                              B/S Formula Method:
                                  Incr Prev Bal by Annual Percent


NUMBER          FORMULA METHOD DESCRIBED
------          ------------------------

131             B/S - Increment the PrevBal by an
                      Annual Percent - COMPOUNDED
                      Exact seasonal amount

SCREENS
    All

DATA ENTRY
    Percentage

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of an annual change (growth or decline) of
    the earlier forecast balance to arrive at the current balance. The
    percent change will be adjusted if the size of the current Data Entry
    period is other than one year.

            Size of Cur Prd    Percent Entered    Percent Change Used
            ---------------    ---------------    -------------------
            Month              10pct              .79741404pct
            Quarter            10pct              2.41136891pct
            Year               10pct              10pct

    Any change in the current balance over the earlier forecast balance will
    be divided in such a manner as to create a constant rate of growth across
    the monthly balances. These results (prior to rounding to the nearest
    whole dollar) are then adjusted on a monthly weighted seasonal basis. The
    seasonal percentages used are those related to the period chosen, as
    entered in the seasonal screen selected. As a result of swings in the
    monthly seasonality, the balance at the end of the period may not equal
    the growth over the previous Data Entry period.

USE
    You as the forecaster determine the amount of annual growth or decline in
    the account balance over the earlier forecast balance as of a particular
    date. This amount is adjusted for period size differences. FW then
    calculates the monthly balances in such a manner as to create a constant
    rate of growth across the monthly balances. The growth rate assumes a
    monthly compounding of the rate. FW then uses the seasonal percentages
    input. The program knows which months relate to the current Data Entry
    period, obtains the related seasonal percentages from the seasonal
    screen, calculates a weighted average based on the total of these
    percentages and completes the calculation.

    The computed growth rate is very accurate. The user will notice a slight
    change in the growth rate as a result of rounding the individual results
    to the nearest whole dollar. All monthly amounts within a Data Entry
    period are first calculated using the calculated growth rate and then
    seasonally adjusted before rounding is performed. Future forecast periods
    and the use of these amounts as a linked account refer to the final whole
    dollar results.

    Formula Method 131 is similar to 124 when used in an annual period.
    However, in a Quarterly or Monthly period Formula Method 131 calculates
    the compounded rate for the period size, whereas 124 merely takes a
    portion of the annual rate (for example, 1/4 or 1/12). In addition,
    as a result of swings in the monthly seasonality, the balance at the
    end of the period may not equal the growth over the previous Data Entry
    period.

OVERRIDE
    If the previous Data Entry period or opening (historical) balance sheet,
    income or cash statement amount is $0, then Formula Method 131 will not
    be used by FW. Instead Formula Method 122 will be used by default.
    (see also chapter 16)
    NO ERROR MESSAGE WILL BE RETURNED!




NUMBER          FORMULA METHOD DESCRIBED
------          ------------------------

131             B/S - Increment the PrevBal by an
                      Annual Percent - COMPOUNDED
                      Exact seasonal amount

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $450-December
          Assumption:   Earlier forecast bal (Nov 1990) is $446
              Method:   Select Formula Method 131 for the Month Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen. A 10pct annual rate would
                        represent a .79741404pct rate for one month with
                        monthly compounding ($446 *  1.0079741404 = $449.56
                        or $450). Since the period size is only one month,
                        no spreading is necessary.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $445-Oct, $449-Nov, $451-Dec
          Assumption:   Earlier forecast bal (Sep 1990) is $439
                        Seasonal Percentages are
                        15pct-Oct, 8pct-Nov, 5pct-Dec
              Method:   Select Formula Method 131 for the Quarter Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen. A 10pct annual rate would
                        represent a 2.41136891pct rate for one quarter with
                        monthly compounding ($439 * 1.0241136891 = $449.59
                        seasonally adjusted to $450.77 or $451). The program
                        will spread the difference of $11 between the current
                        and earlier forecast balance in such a manner as to
                        create a constant rate of growth across the monthly
                        balances. These results are then adjusted on a
                        monthly weighted seasonal basis.
 (Oct .0079741404 is calc by FW :
  Nov .0160118678 = 1.00797412404^2 - 1)

 Oct =$445=$445.30=$439.00+($439 * .0079741404 * (15pct/(100pct/12))
 Nov =$449=$448.64=
         $445.30+($439 * (.0160118678 -.0079741404)*(8pct/(100pct/12)))
 Dec =$451=$450.77=
         $448.64+($439 * (.0241136891 -.0160118678)*(5pct/(100pct/12)))

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $415-Jan, $417-Feb, $419-Mar,
                        $423-Apr, $427-May, $431-Jun,
                        $434-Jul, $437-Aug, $438-Sep,
                        $444-Oct, $448-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Dec 1989) is $409
                        Seasonal Percentages are
                        15pct-Jan,  5pct-Feb,  5pct-Mar,
                        10pct-Apr, 10pct-May, 10pct-Jun,
                         7pct-Jul,  7pct-Aug,  3pct-Sep,
                        15pct-Oct,  8pct-Nov,  5pct-Dec
              Method:   Select Formula Method 131 for the Year Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen ($409 * 1.1 = $449.90 seasonally
                        adjusted to $449.80 or $450). The program will spread
                        the difference of $41 between the current and earlier
                        forecast balance in such a manner as to create a
                        constant rate of growth across the monthly balances.
                        These results are then adjusted on a monthly weighted
                        seasonal basis. (Although the spread in the results
                        is not dramatic, larger numbers would show a more
                        dramatic effect)
(Jan .0079741404 is calc by FW :
 Feb .0160118678 = 1.00797412404^2 - 1)

Jan =$415=$414.87=$409.00+($409 * .0079741404 * (15pct/(100pct/12)))
Feb =$417=$416.84=
          $414.87+($409*(.0160118678 -.0079741404)* (5pct/(100pct/12)))
Mar =$419=$418.83=
          $416.84+($409*(.0241136891 -.0160118678)* (5pct/(100pct/12)))
Apr =$423=$422.84=
          $418.83+($409*(.0322801155 -.0241136891)*(10pct/(100pct/12)))
May =$427=$426.88=
          $422.84+($409*(.0405116621 -.0322801155)*(10pct/(100pct/12)))
Jun =$431=$430.95=
          $426.88+($409*(.0488088482 -.0405116621)*(10pct/(100pct/12)))
Jul =$434=$433.82=
          $430.95+($409*(.0571721972 -.0488088482)* (7pct/(100pct/12)))
Aug =$437=$436.72=
          $433.82+($409*(.0656022368 -.0571721972)* (7pct/(100pct/12)))
Sep =$438=$437.97=
          $436.72+($409*(.0740994986 -.0656022368)* (3pct/(100pct/12)))
Oct =$444=$444.28=
          $437.97+($409*(.0826645189 -.0740994986)*(15pct/(100pct/12)))
Nov =$448=$447.67=
          $444.28+($409*(.0912978378 -.0826645189)* (8pct/(100pct/12)))
Dec =$450=$449.80=
          $444.28+($409*(.1000000000 -.0912978378)* (5pct/(100pct/12)))





NUMBER          FORMULA METHOD DESCRIBED
------          ------------------------

132             B/S - Increment the PrevBal by an
                      Annual Percent - COMPOUNDED
                      Rounded seasonal amount

SCREENS
    All

DATA ENTRY
    Percentage

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of an annual change (growth or decline) of
    the earlier forecast balance to arrive at the current balance. The
    percent change will be adjusted if the size of the current Data Entry
    period is other than one year.

          Size of Cur Prd    pct Entered    pctChange Used
          ---------------    ---------    ------------
          Month              10pct          .79741404pct
          Quarter            10pct          2.41136891pct
          Year               10pct          10pct

    Any change in the current balance over the earlier forecast balance will
    be divided in such a manner as to create a constant rate of growth across
    the monthly balances. These results (prior to rounding to the nearest
    whole dollar) are then adjusted on a monthly weighted seasonal basis. The
    seasonal percentages used are those related to the period chosen, as
    entered in the seasonal screen selected. As a result of swings in the
    monthly seasonality, the balance at the end of the period may not equal
    the growth over the previous Data Entry period. This method will take the
    difference between the pctChange Used (10pct is used in the examples) and
    that obtained under method 131, and allocate this amount to the
    individual months based on a weighted average basis of each month's
    increment over the previous month.

    Example : in the Yearly example shown below, $409 with a 10pct growth =
              $449.90. However, the final month's result is $449.80. The
              difference of .10 would be allocated to January as follows:

             ($414.8706 - $409) / ($449.8018 - $409) * $0.10 = $0.0144
              $414.8706 + $0.0144 = $414.885 or $415.

    Needless to say this example looks awfully finicky. However, when
    dealing with large dollar amounts and big swings in seasonality or where
    rounding differences are bothersome, this method is available for your
    use. With FW you can afford to be finicky, sit back, and let the computer
    do all the hard work!

USE
    You as the forecaster determine the amount of annual growth or decline in
    the account balance over the earlier forecast balance as of a particular
    date. This amount is adjusted for period size differences. FW then
    calculates the monthly balances in such a manner as to create a constant
    rate of growth across the monthly balances. The growth rate assumes a
    monthly compounding of the rate. FW then uses the seasonal percentages
    input. The program knows which months relate to the current Data Entry
    period, obtains the related seasonal percentages from the seasonal
    screen, calculates a weighted average based on the total of these
    percentages and completes the calculation.

    The computed growth rate is very accurate. The user will notice a slight
    change in the growth rate as a result of rounding the individual results
    to the nearest whole dollar. All monthly amounts within a Data Entry
    period are first calculated using the calculated growth rate and then
    seasonally adjusted before rounding is performed. Future forecast periods
    and the use of these amounts as a linked account refer to the final whole
    dollar results.

    Formula Method 132 is similar to 124 when used in an annual period.
    However, in a Quarterly or Monthly period, Formula Method 131 calculates
    the compounded rate for the period size, whereas 124 merely takes a
    portion of the annual rate (for example, 1/4 or 1/12). In addition,
    as a result of swings in the monthly seasonality, the balance at the
    end of the period may not equal the growth over the previous Data Entry
    period.

OVERRIDE
    If the previous Data Entry period or opening (historical) balance sheet,
    income or cash statement amount is $0, then Formula Method 132 will not
    be used by FW. Instead Formula Method 122 will be used by default.
    (see also chapter 16)
    NO ERROR MESSAGE WILL BE RETURNED!




NUMBER          FORMULA METHOD DESCRIBED
------          ------------------------

132             B/S - Increment the PrevBal by an
                      Annual Percent - COMPOUNDED
                      Rounded seasonal amount

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $450-December
          Assumption:   Earlier forecast bal (Nov 1990) is $446
              Method:   Select Formula Method 132 for the Month Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen. A 10pct annual rate would
                        represent a .79741404pct rate for one month with
                        monthly compounding ($446 * 1.0079741404 = $449.56 or
                        $450). Since the period size is only one month,
                        no spreading is necessary.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $445-Oct, $448-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Sep 1990) is $439
                        Seasonal Percentages are
                        15pct-Oct, 8pct-Nov, 5pct-Dec
              Method:   Select Formula Method 132 for the Quarter Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen. A 10pct annual rate would
                        represent a 2.41136891pct rate for one quarter with
                        monthly compounding ($439 * 1.0241136891 = $449.59 or
                        $450). The program will spread the difference of $11
                        between the current and earlier forecast balance in
                        such a manner as to create a constant rate of growth
                        across the monthly balances. These results are then
                        adjusted on a monthly weighted seasonal basis.
(Oct .0079741404 is calc by FW :
 Nov .0160118678 = 1.00797412404^2 - 1)

Oct = $445=$444.65=$444.63=$439.00+($439*.0079741404  * (15pct/(28pct/3))
Nov = $448=$447.67=$447.65=$444.63+($439*(.0160118678-.0079741404) *
                           (8pct/(28pct/3)))
Dec = $450=$449.59=$449.56=$447.65+($439*(.0241136891-.0160118678) *
                           (5pct/(28pct/3)))

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $415-Jan, $417-Feb, $419-Mar,
                        $423-Apr, $427-May, $431-Jun,
                        $434-Jul, $437-Aug, $438-Sep,
                        $444-Oct, $448-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Dec 1989) is $409
                        Seasonal Percentages are
                        15pct-Jan,  5pct-Feb,  5pct-Mar,
                        10pct-Apr, 10pct-May, 10pct-Jun,
                         7pct-Jul,  7pct-Aug,  3pct-Sep,
                        15pct-Oct,  8pct-Nov,  5pct-Dec
              Method:   Select Formula Method 132 for the Year Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen ($409 * 1.1 = $449.90 or $450). The
                        program will spread the difference of $41 between the
                        current and earlier forecast balance in such a manner
                        as to create a constant rate of growth across the
                        monthly balances. These results are then adjusted on
                        a monthly weighted seasonal basis. (Although the
                        spread in the results is not dramatic, larger numbers
                        would show a more dramatic effect)
(Jan .0079741404 is calc by FW :
 Feb .0160118678 = 1.00797412404^2 - 1)

Jan =$415=$414.88=$414.87=$409.00+($409 * .0079741404) * (15pct/(100pct/12)))
Feb =$417=$416.86=$416.84=$414.87+($409*(.0160118678 -.0079741404) *
                           (5pct/(100pct/12)))
Mar =$419=$418.85=$418.83=$416.84+($409*(.0241136891 -.0160118678) *
                           (5pct/(100pct/12)))
Apr =$423=$422.87=$422.84=$418.83+($409*(.0322801155 -.0241136891) *
                          (10pct/(100pct/12)))
May =$427=$426.92=$426.88=$422.84+($409*(.0405116621 -.0322801155) *
                          (10pct/(100pct/12)))
Jun =$431=$431.00=$430.95=$426.88+($409*(.0488088482 -.0405116621) *
                          (10pct/(100pct/12)))
Jul =$434=$433.88=$433.82=$430.95+($409*(.0571721972 -.0488088482) *
                           (7pct/(100pct/12)))
Aug =$437=$436.79=$436.72=$433.82+($409*(.0656022368 -.0571721972) *
                           (7pct/(100pct/12)))
Sep =$438=$438.05=$437.97=$436.72+($409*(.0740994986 -.0656022368) *
                           (3pct/(100pct/12)))
Oct =$444=$444.37=$444.28=$437.97+($409*(.0826645189 -.0740994986) *
                          (15pct/(100pct/12)))
Nov =$448=$447.76=$447.67=$444.28+($409*(.0912978378 -.0826645189) *
                           (8pct/(100pct/12)))
Dec =$450=$449.90=$449.80=$447.67+($409*(.1000000000 -.0912978378) *
                           (5pct/(100pct/12)))





NUMBER          FORMULA METHOD DESCRIBED
------          ------------------------

133             B/S - Increment the PrevBal by an
                      Annual Percent - COMPOUNDED
                      Non-seasonal amount
                      (no rounding required)

SCREENS
    All

DATA ENTRY
    Percentage

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of an annual change (growth or decline) of
    the earlier forecast balance to arrive at the current balance. The
    percent change will be adjusted if the size of the current Data Entry
    period is other than one year.

            Size of Cur Prd    Percent Entered    Percent Change Used
            ---------------    ---------------    -------------------
            Month              10pct              .79741404pct
            Quarter            10pct              2.41136891pct
            Year               10pct              10pct

    Any change in the current balance over the earlier forecast balance will
    be divided in such a manner as to create a constant rate of growth across
    the monthly balances.

USE
    You as the forecaster determine the amount of annual growth or decline in
    the account balance over the earlier forecast balance as of a particular
    date. This amount is adjusted for period size differences. FW then
    calculates the monthly balances in such a manner as to create a constant
    rate of growth across the monthly balances. The growth rate assumes a
    monthly compounding of the rate.

    The computed growth rate is very accurate. The user will notice a slight
    change in the growth rate as a result of rounding the individual results
    to the nearest whole dollar. All monthly amounts within a Data Entry
    period are first calculated using the calculated growth rate before
    rounding is performed. Future forecast periods and the use of these
    amounts as a linked account refer to the final whole dollar results.

    Formula Method 133 is similar to 123 when used in an annual period.
    However, in a Quarterly or Monthly period Formula Method 133 calculates
    the compounded rate for the period size whereas 123 merely takes a
    portion of the annual rate (for example, 1/4 or 1/12).

OVERRIDE
    If the previous Data Entry period or opening (historical) balance sheet,
    income or cash statement amount is $0, then Formula Method 133 will not
    be used by FW. Instead Formula Method 121 will be used by default.
    (see also chapter 16)
    NO ERROR MESSAGE WILL BE RETURNED!




NUMBER          FORMULA METHOD DESCRIBED
------          ------------------------

133             B/S - Increment the PrevBal by an
                      Annual Percent - COMPOUNDED
                      Non-seasonal amount
                      (no rounding required)

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $450-December
          Assumption:   Earlier forecast balance (Nov 1990) is $446
              Method:   Select Formula Method 133 for the Month Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen. A 10pct annual rate would
                        represent a .79741404pct rate for one month with
                        monthly compounding ($446 * 1.0079741404 = $449.56 or
                        $450). Since the period size is only one month,
                        no spreading is necessary.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $443-Oct, $446-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Sep 1990) is $439
              Method:   Select Formula Method 133 for the Quarter Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen. A 10pct annual rate would
                        represent a 2.41136891pct rate for one quarter with
                        monthly compounding ($439 * 1.0241136891 = $449.59).
                        The program will spread the difference of $11 between
                        the current and earlier forecast balance in such a
                        manner as to create a constant rate of growth across
                        the monthly balances.
   Oct = $443 = $442.50 = $439 * 1.0079741404 :(calc by FW)
   Nov = $446 = $446.03 = $439 * 1.0160118678 :(1.0079741404^2)
   Dec = $450 = $449.59 = $439 * 1.0241136891 :(1.0079741404^3)

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $412-Jan, $416-Feb, $419-Mar,
                        $422-Apr, $426-May, $429-Jun,
                        $432-Jul, $436-Aug, $439-Sep,
                        $443-Oct, $446-Nov, $450-Dec
          Assumption:   Earlier forecast bal (Dec 1989) is $409
              Method:   Select Formula Method 133 for the Year Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen ($409 * 1.1 = $449.90). The program
                        will spread the difference of $41 between the current
                        and earlier forecast balance in such a manner as to
                        create a constant rate of growth across the monthly
                        balances. (Although the spread in the results is not
                        dramatic, larger numbers would show a more dramatic
                        effect)
   Jan = $412 = $412.26 = $409 * 1.0079741404 :(calc by FW)
   Feb = $416 = $415.55 = $409 * 1.0160118678 :(1.0079741404^2)
   Mar = $419 = $418.86 = $409 * 1.0241136891 :(1.0079741404^3)
   Apr = $422 = $422.20 = $409 * 1.0322801155 :(1.0079741404^4)
   May = $426 = $425.57 = $409 * 1.0405116621 :(1.0079741404^5)
   Jun = $429 = $428.96 = $409 * 1.0488088482 :(1.0079741404^6)
   Jul = $432 = $432.38 = $409 * 1.0571721972 :(1.0079741404^7)
   Aug = $436 = $435.83 = $409 * 1.0656022368 :(1.0079741404^8)
   Sep = $439 = $439.31 = $409 * 1.0740994986 :(1.0079741404^9)
   Oct = $443 = $442.81 = $409 * 1.0826645189 :(1.0079741404^10)
   Nov = $446 = $446.34 = $409 * 1.0912978378 :(1.0079741404^11)
   Dec = $450 = $449.90 = $409 * 1.1000000000 :(1.0079741404^12)
