

                                                               25
                                              I/S Formula Method:
                                             Specify Dollar Units


NUMBER        FORMULA METHOD DESCRIBED
------        ------------------------

201           I/S - Specify Dollar Units
                    Spread Evenly

SCREENS
    All

DATA ENTRY
    Dollar or unit amount

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of either a dollar amount or number of
    capital shares. The amount will be divided evenly on a monthly basis.

USE
    One of the easiest methods to understand, this represents a principle
    formula method.

    You as the forecaster determine the cumulative amount for the period.
    FW calculates the monthly amounts.

    This formula method behaves similar to methods 205, 211, 215 and 221.

    Formula Method 205 is the same as 201, with the exception that 205
    represents the increment and not the cumulative amount. If you plan to
    make changes to earlier forecast periods and wish the current amount to
    also change, then use 205 instead of 201.

    Formula Methods 211, 215 and 221 allow you to state the current period
    as a percentage growth or decline of the earlier amount. If you plan to
    make changes in earlier forecast periods and wish the current amount to
    also change, but by a percentage of the earlier forecast amount, then use
    one of these methods instead of 201.

OVERRIDE
    None




NUMBER        FORMULA METHOD DESCRIBED
------        ------------------------

201           I/S - Specify Dollar Units
                    Spread Evenly


EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $1200-December
          Assumption:   None
              Method:   Select Formula Method 201 for the Month Ending
                        December 1990 and enter $1200 in the December 1990
                        Data Entry screen. Since the period size is only one
                        month, no spreading is necessary. Formula Methods
                        202, 203 and 204 will produce a similar result.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $400-Oct, $400-Nov, $400-Dec
          Assumption:   None
              Method:   Select Formula Method 201 for the Quarter Ending
                        December 1990 and enter $1200 in the December 1990
                        Data Entry screen. The program will spread the $1200
                        amount over the current quarter's monthly periods in
                        even $400 amounts. Rounding is performed on the
                        cumulative amount through each monthly period (within
                        the Data Entry period)!

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $100-Jan, $101-Feb, $100-Mar,
                        $100-Apr, $100-May, $101-Jun,
                        $100-Jul, $100-Aug, $100-Sep,
                        $101-Oct, $100-Nov, $100-Dec
          Assumption:   None
              Method:   Select Formula Method 201 for the Year Ending
                        December 1990 and enter $1203 in the December 1990
                        Data Entry screen. The program will spread the $1203
                        amount over the current Year's monthly periods in
                        even $100.25 amounts. Rounding is performed on the
                        cumulative amount through each monthly period (within
                        the Data Entry period)!




NUMBER        FORMULA METHOD DESCRIBED
------        ------------------------

202           I/S - Specify Dollar Units
                    Spread Seasonally

SCREENS
    All

DATA ENTRY
    Dollar or unit amount

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of either a dollar amount or number of
    capital shares. The amount will be divided evenly on a monthly weighted
    seasonal basis. The seasonal percentages used are those related to the
    period chosen, as entered in the seasonal screen selected.

USE
    This represents a principle formula method.

    You as the forecaster determine the cumulative amount for the period.
    FW calculates the monthly amounts using the seasonal percentages input.
    FW knows which months relate to the current Data Entry period, obtains
    the related seasonal percentages from the seasonal screen, calculates a
    weighted average based on the total of these percentages and completes
    the calculation.

    This formula method behaves similar to methods 206, 212, 216 and 222.

    Formula Method 206 is the same as 202, with the exception that 206
    represents the increment and not the cumulative amount. If you plan to
    make changes to earlier forecast periods and wish the current amount to
    also change, then use 206 instead of 202.

    Formula Methods 212, 216 and 222 allow you to state the current period as
    a percentage growth or decline of the earlier amount. If you plan to make
    changes in earlier forecast periods and wish the current amount to also
    change, but by a percentage of the earlier forecast amount, then use one
    of these methods instead of 202.

OVERRIDE
    None





NUMBER        FORMULA METHOD DESCRIBED
------        ------------------------

202           I/S - Specify Dollar Units
                    Spread Seasonally

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $1200-December
          Assumption:   None
              Method:   Select Formula Method 202 for the Month Ending
                        December 1990 and enter $1200 in the December 1990
                        Data Entry screen. Since the period size is only one
                        month, no spreading is necessary. Formula Methods
                        201, 203 and 204 will produce a similar result.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $643-Oct, $343-Nov, $214-Dec
          Assumption:   None
                        Seasonal Percentages are
                        15pct-Oct, 8pct-Nov, 5pct-Dec
              Method:   Select Formula Method 202 for the Quarter Ending
                        December 1990 and enter $1200 in the December 1990
                        Data Entry screen. The program will spread the $1200
                        amount over the current quarter's monthly periods
                        based on a weighted average of seasonal percentages
                        for that quarter. Rounding is performed on the
                        cumulative amount through each monthly period (within
                        the Data Entry period)!
   Oct = $643 = $642.86 = $1200 * ( 15pct/(15pct+8pct+5pct) )
   Nov = $343 = $342.86 = $1200 * (  8pct/(15pct+8pct+5pct) )
   Dec = $214 = $214.29 = $1200 * (  5pct/(15pct+8pct+5pct) )

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $180-Jan, $ 61-Feb, $ 60-Mar,
                        $120-Apr, $120-May, $121-Jun,
                        $ 84-Jul, $ 84-Aug, $ 36-Sep,
                        $181-Oct, $ 96-Nov, $ 60-Dec
          Assumption:   Seasonal Percentages are
                        15pct-Jan,  5pct-Feb,  5pct-Mar,
                        10pct-Apr, 10pct-May, 10pct-Jun,
                         7pct-Jul,  7pct-Aug,  3pct-Sep,
                        15pct-Oct,  8pct-Nov,  5pct-Dec
              Method:   Select Formula Method 202 for the Year Ending
                        December 1990 and enter $1203 in the December 1990
                        Data Entry screen. The program will spread the $1203
                        amount over the current year's monthly periods
                        balance based on a weighted average of seasonal
                        percentages for that year. Rounding is performed on
                        the cumulative amount through each monthly period
                        (within the Data Entry period)!
   Jan = $180 = $180.45 = $1203 * ( 15pct /100pct )
   Feb = $ 61 = $ 60.15 = $1203 * (  5pct /100pct )
   Mar = $ 60 = $ 60.15 = $1203 * (  5pct /100pct )
   Apr = $120 = $120.30 = $1203 * ( 10pct /100pct )
   May = $120 = $120.30 = $1203 * ( 10pct /100pct )
   Jun = $121 = $120.30 = $1203 * ( 10pct /100pct )
   Jul = $ 84 = $ 84.21 = $1203 * (  7pct /100pct )
   Aug = $ 84 = $ 84.21 = $1203 * (  7pct /100pct )
   Sep = $ 36 = $ 36.09 = $1203 * (  3pct /100pct )
   Oct = $181 = $180.45 = $1203 * ( 15pct /100pct )
   Nov = $ 96 = $ 96.24 = $1203 * (  8pct /100pct )
   Dec = $ 60 = $ 60.15 = $1203 * (  5pct /100pct )




NUMBER        FORMULA METHOD DESCRIBED
------        ------------------------

203           I/S - Specify Dollar Units
                    Spread by Geometric Progression

SCREENS
    All

DATA ENTRY
    Dollar or unit amount

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of either a dollar amount or number of
    capital shares. The amount will be divided in such a manner as to create
    a constant rate of growth across the monthly amounts.

USE
    This represents a principle formula method.

    You as the forecaster determine the cumulative amount for the period.
    FW calculates the monthly amounts in such a manner as to create a
    constant rate of growth across the monthly amounts. The growth rate
    assumes a monthly compounding of the rate.

    The computed growth rate is very accurate. The user will notice a slight
    change in the growth rate as a result of rounding the individual results
    to the nearest whole dollar. All monthly amounts within a Data Entry
    period are first calculated using the calculated growth rate before
    rounding is performed. Future forecast periods and the use of these
    amounts as a linked account refer to the final whole dollar results.

    This formula method behaves similar to methods 207, 213, 217 and 223.

    Formula Method 207 is the same as 203, with the exception that 207
    represents the increment and not the cumulative amount. If you plan to
    make changes to earlier forecast periods and wish the current amount to
    also change, then use 207 instead of 203.

    Formula Methods 213, 217 and 223 allow you to state the current period as
    a percentage growth or decline of the earlier forecast amount. If you
    plan to make changes in earlier forecast periods and wish the current
    amount to also change, but by a percentage of the earlier forecast
    amount, then use one of these methods instead of 203.

OVERRIDE
    If the previous Data Entry period or opening (historical) balance sheet,
    income or cash statement amount is $0, then Formula Method 203 will not
    be used by FW. Instead Formula Method 201 will be used by default.
    (see also chapter 16)
    NO ERROR MESSAGE WILL BE RETURNED!

    Seasonality Adjustment
    ----------------------
    If the previous Data Entry formula method was a seasonal income formula
    method (methods 202, 204, 206, 208, 212, 214, 216, 218, 222, 224, 231 and
    232) then the last monthly calculated amount will have its seasonality
    removed (only for the purpose of performing the current period
    calculation - the previous amount will NOT actually be changed). This
    will eliminate over/under inflated calculations in the use of this method
    in the immediate subsequent period.

    For example, if the current quarterly period is forecast as $750 (or as a
    growth percentage), and the last calculated monthly amount used a
    seasonal income formula method, and that amount was $100 with a
    5pct season rate for that month, then the prior amount will be re-cast as
    follows:

            ($100 * 3(months in the current forecast period))
                           /
                    (5pct * 12(months)/100pct)
            =  $500.
            $750/$500 is a 50pct increase over the previous period.




NUMBER        FORMULA METHOD DESCRIBED
------        ------------------------

203           I/S - Specify Dollar Units
                    Spread by Geometric Progression

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $450-December
          Assumption:   None
              Method:   Select Formula Method 203 for the Month Ending
                        December 1990 and enter $450 in the December 1990
                        Data Entry screen. Since the period size is only one
                        month, no spreading is necessary. Formula Methods
                        201, 202 and 204 will produce a similar result.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $325-Oct, $395-Nov, $480-Dec
          Assumption:   The earlier forecast amount (Qtr of Sep 89) is $800
                        with $267 in the month of Sep 1990
              Method:   Select Formula Method 203 for the Quarter Ending
                        December 1990 and enter $1200 in the December 1990
                        Data Entry screen. The program will spread the $1200
                        amount over the current quarter's monthly periods in
                        such a manner as to create a constant rate of growth
                        between the monthly amounts. Rounding is performed
                        on the cumulative amount through each monthly period
                        (within the Data Entry period)!
 Oct = $325 = $324.73=$1200 * .2706077927 (calc by FW - 21.62pct = $325/$267)
 Nov = $395 = $394.94=$1200 * .3291165593 (21.62pct growth = .32912/.27061)
 Dec = $480 = $480.33=$1200 * .4002756480 (21.62pct growth = .40028/.32912)

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $369-Jan, $375-Feb, $380-Mar,
                        $385-Apr, $391-May, $397-Jun,
                        $402-Jul, $409-Aug, $414-Sep,
                        $420-Oct, $426-Nov, $432-Dec
          Assumption:   The earlier forecast amount (Qtr of Dec 1989) is
                        $1092 with $364 in the month of Dec 1989
              Method:   Select Formula Method 203 for the Year Ending
                        December 1990 and enter $4800 in the December 1990
                        Data Entry screen. The program will spread the $4800
                        amount over the current year's monthly periods in
                        such a manner as to create a constant rate of growth
                        between the monthly amounts. Rounding is performed on
                        the cumulative amount through each monthly period
                        (within the Data Entry period)!
 Jan = $369 = $369.26= $4800 * .0769291044 (calc by FW - 1.44pct = $369/$364)
 Feb = $375 = $374.58= $4800 * .0780384182 (1.44pct growth - .07804/.07693)
 Mar = $380 = $379.99= $4800 * .0791637283
 Apr = $385 = $385.47= $4800 * .0803052653
 May = $391 = $391.02= $4800 * .0814632633
 Jun = $397 = $396.66= $4800 * .0826379594
 Jul = $402 = $402.38= $4800 * .0838295947
 Aug = $409 = $408.18= $4800 * .0850384133
 Sep = $414 = $414.07= $4800 * .0862646630
 Oct = $420 = $420.04= $4800 * .0875085951
 Nov = $426 = $426.10= $4800 * .0887704647
 Dec = $432 = $432.24= $4800 * .0900505303 (1.44pct growth - .09005/.08877)

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $369-Jan, $375-Feb, $380-Mar,
                        $385-Apr, $391-May, $397-Jun,
                        $402-Jul, $409-Aug, $414-Sep,
                        $420-Oct, $426-Nov, $432-Dec
          Assumption:   The earlier forecast amount (Yr of Dec 1989) is
                        $4368 with $364 in the month of Dec 1989
              Method:   Select Formula Method 203 for the Year Ending
                        December 1990 and enter $4800 in the December 1990
                        Data Entry screen. The program will spread the $4800
                        amount over the current year's monthly periods in
                        such a manner as to create a constant rate of growth
                        between the monthly amounts. Rounding is performed on
                        the cumulative amount through each monthly period
                        (within the Data Entry period)!
 Jan = $369 = $369.26= $4800 * .0769291044 (calc by FW - 1.44pct = $369/$364)
 Feb = $375 = $374.58= $4800 * .0780384182 (1.44pct growth - .07804/.07693)
 Mar = $380 = $379.99= $4800 * .0791637283
 Apr = $385 = $385.47= $4800 * .0803052653
 May = $391 = $391.02= $4800 * .0814632633
 Jun = $397 = $396.66= $4800 * .0826379594
 Jul = $402 = $402.38= $4800 * .0838295947
 Aug = $409 = $408.18= $4800 * .0850384133
 Sep = $414 = $414.07= $4800 * .0862646630
 Oct = $420 = $420.04= $4800 * .0875085951
 Nov = $426 = $426.10= $4800 * .0887704647
 Dec = $432 = $432.24= $4800 * .0900505303 (1.44pct growth - .09005/.08877)



NUMBER        FORMULA METHOD DESCRIBED
------        ------------------------

204           I/S - Specify Dollar Units
                    Spread by Geometric Prog - Seasonally

SCREENS
    All

DATA ENTRY
    Dollar or unit amount

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of either a dollar amount or number of
    capital shares. The amount will be divided in such a manner as to create
    a constant rate of growth across the monthly balances. These results
    (prior to rounding to the nearest whole dollar) are then adjusted on a
    monthly weighted seasonal basis. The seasonal percentages used are those
    related to the period chosen, as entered in the seasonal screen selected.

USE
    This represents a principle formula method.

    You as the forecaster determine the cumulative amount for the period.
    FW calculates the monthly amounts in such a manner as to create a
    constant rate of growth across the monthly balances. The growth rate
    assumes a monthly compounding of the rate. FW then uses the seasonal
    percentages input. The program knows which months relate to the current
    Data Entry period, obtains the related seasonal percentages from the
    seasonal screen, calculates a weighted average based on the total of
    these percentages and completes the calculation.

    The computed growth rate is very accurate. The user will notice a slight
    change in the growth rate as a result of rounding the individual results
    to the nearest whole dollar. All monthly amounts within a Data Entry
    period are first calculated using the calculated growth rate and then
    seasonally adjusted before rounding is performed. Future forecast periods
    and the use of these amounts as a linked account refer to the final whole
    dollar results.

    This formula method behaves similar to methods 208, 214, 218 and 224.

    Formula Method 208 is the same as 204, with the exception that 208
    represents the increment and not the cumulative amount. If you plan to
    make changes to earlier forecast periods and wish the current amount to
    also change, then use 208 instead of 204.

    Formula Methods 214, 218 and 224 allow you to state the current period as
    a percentage growth or decline of the earlier forecast balance. If you
    plan to make changes in earlier forecast periods and wish the current
    balance to also change, but by a percentage of the earlier forecast
    amount, then use one of these methods instead of 104.

OVERRIDE
    If the previous Data Entry period or opening (historical) balance sheet,
    income or cash statement amount is $0, then Formula Method 204 will not
    be used by FW. Instead Formula Method 202 will be used by default.
    (see also chapter 16)
    NO ERROR MESSAGE WILL BE RETURNED!

    Seasonality Adjustment
    ----------------------
    If the previous Data Entry formula method was a seasonal income formula
    method (methods 202, 204, 206, 208, 212, 214, 216, 218, 222, 224, 231 and
    232) then the last monthly calculated amount will have its seasonality
    removed (only for the purpose of performing the current period
    calculation - the previous amount will NOT actually be changed). This
    will eliminate over/under inflated calculations in the use of this method
    in the immediate subsequent period.

    For example, if the current quarterly period is forecast as $750 (or as a
    growth percentage), and the last calculated monthly amount used a
    seasonal income formula method, and that amount was $100 with a
    5pct season rate for that month, then the prior amount will be re-cast as
    follows:

            ($100 * 3(months in the current forecast period))
                           /
                    (5pct * 12(months)/100pct)
            =  $500.
            $750/$500 is a 50pct increase over the previous period.



NUMBER        FORMULA METHOD DESCRIBED
------        ------------------------

204           I/S - Specify Dollar Units
                    Spread by Geometric Prog - Seasonally

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $450 in December
          Assumption:   None
              Method:   Select Formula Method 204 for the Month Ending
                        December 1990 and enter $450 in the December 1990
                        Data Entry screen. Since the period size is only one
                        month, no spreading is necessary. Formula Methods
                        201, 202 and 203 will produce a similar result.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $560-Oct, $364-Nov, $276-Dec
          Assumption:   The earlier forecast amount (Qtr of Sept 1990) is
                        $800 with $267 in the month of Sep 1990
                        Seasonal Percentages are
                        15pct-Oct, 8pct-Nov, 5pct-Dec
              Method:   Select Formula Method 204 for the Quarter Ending
                        December 1990 and enter $1200 in the December 1990
                        Data Entry screen. The program will spread the $1200
                        amount over the current quarter's monthly periods in
                        such a manner as to create a constant rate of growth
                        between the monthly amounts. These results are then
                        adjusted on a monthly weighted seasonal basis.
                        Rounding is performed on the cumulative amount
                        through each monthly period (within the Data Entry
                        period)!
   Oct = $521.89 = $1200 * .2706077927 * (15pct/(28pct/3))
   Nov = $338.52 = $1200 * .3291165593 * ( 8pct/(28pct/3))
   Dec = $257.32 = $1200 * .4002756480 * ( 5pct/(28pct/3))

   Difference = $82.27 = $1200 - $1117.73( 521.89 + 338.52 + 257.32 )

   Oct = $560 = $560.30 = $521.89 + ($521.89/$1117.73) * $82.27
   Nov = $364 = $363.44 = $338.52 + ($338.52/$1117.73) * $82.27
   Dec = $276 = $276.26 = $257.32 + ($257.32/$1117.32) * $82.27

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $668-Jan, $225-Feb, $229-Mar,
                        $465-Apr, $471-May, $478-Jun,
                        $339-Jul, $345-Aug, $149-Sep,
                        $760-Oct, $411-Nov, $260-Dec
          Assumption:   The earlier forecast amount (Qtr of Dec 1989) is
                        $1092 with $267 in the month of Dec 1989
                        Seasonal Percentages are
                        15pct-Jan,  5pct-Feb,  5pct-Mar,
                        10pct-Apr, 10pct-May, 10pct-Jun,
                         7pct-Jul,  7pct-Aug,  3pct-Sep,
                        15pct-Oct,  8pct-Nov,  5pct-Dec
              Method:   Select Formula Method 204 for the Year Ending
                        December 1990 and enter $1200 in the December 1990
                        Data Entry screen. The program will spread the $4800
                        amount over the current year's monthly periods in
                        such a manner as to create a constant rate of growth
                        between the monthly amounts. These results are then
                        adjusted on a monthly weighted seasonal basis.
                        Rounding is performed on the cumulative amount
                        through each monthly period (within the Data Entry
                        period)!
   Jan = $664.67 = $4800 * .0769291044 * (15pct/(100pct/12))
   Feb = $224.75 = $4800 * .0780384182 * ( 5pct/(100pct/12))
   Mar = $227.99 = $4800 * .0791637283 * ( 5pct/(100pct/12))
   Apr = $462.56 = $4800 * .0803052653 * (10pct/(100pct/12))
   May = $469.23 = $4800 * .0814632633 * (10pct/(100pct/12))
   Jun = $475.99 = $4800 * .0826379594 * (10pct/(100pct/12))
   Jul = $338.00 = $4800 * .0838295947 * ( 7pct/(100pct/12))
   Aug = $342.87 = $4800 * .0850384133 * ( 7pct/(100pct/12))
   Sep = $149.07 = $4800 * .0862646630 * ( 3pct/(100pct/12))
   Oct = $756.07 = $4800 * .0875085951 * (15pct/(100pct/12))
   Nov = $409.05 = $4800 * .0887704647 * ( 8pct/(100pct/12))
   Dec = $259.35 = $4800 * .0900505303 * ( 5pct/(100pct/12))

   Difference = $20.40 = $4800 - $4779.60( 664.67 + 224.75 +
                         227.99 + 462.56 + 469.23 + 475.99 + 338.00 +
                         342.87 + 149.07 + 756.07 + 409.05 + 259.35)

   Jan = $668 = $667.50 = $664.67 + ($664.67/$4779.60) * $20.40
   Feb = $225 = $225.71 = $224.75 + ($224.75/$4779.60) * $20.40
   Mar = $229 = $228.96 = $227.99 + ($227.99/$4779.60) * $20.40
   Apr = $465 = $464.53 = $462.56 + ($462.56/$4779.60) * $20.40
   May = $471 = $471.23 = $469.23 + ($469.23/$4779.60) * $20.40
   Jun = $478 = $478.03 = $475.99 + ($475.99/$4779.60) * $20.40
   Jul = $339 = $339.44 = $338.00 + ($338.00/$4779.60) * $20.40
   Aug = $345 = $344.34 = $342.87 + ($342.87/$4779.60) * $20.40
   Sep = $149 = $149.70 = $149.07 + ($149.07/$4779.60) * $20.40
   Oct = $760 = $759.30 = $756.07 + ($756.07/$4779.60) * $20.40
   Nov = $411 = $410.80 = $409.05 + ($409.05/$4779.60) * $20.40
   Dec = $260 = $260.45 = $259.35 + ($259.35/$4779.60) * $20.40

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $668-Jan, $225-Feb, $229-Mar,
                        $465-Apr, $471-May, $478-Jun,
                        $339-Jul, $345-Aug, $149-Sep,
                        $760-Oct, $411-Nov, $260-Dec
          Assumption:   The earlier forecast amount (Year of Dec 1989) is
                        $4368 with $267 in the month of Dec 1989
                        Seasonal Percentages are
                        15pct-Jan,  5pct-Feb,  5pct-Mar,
                        10pct-Apr, 10pct-May, 10pct-Jun,
                         7pct-Jul,  7pct-Aug,  3pct-Sep,
                        15pct-Oct,  8pct-Nov,  5pct-Dec
              Method:   Select Formula Method 204 for the Year Ending
                        December 1990 and enter $1200 in the December 1990
                        Data Entry screen. The program will spread the $4800
                        amount over the current year's monthly periods in
                        such a manner as to create a constant rate of growth
                        between the monthly amounts. These results are then
                        adjusted on a monthly weighted seasonal basis.
                        Rounding is performed on the cumulative amount
                        through each monthly period (within the Data Entry
                        period)!
   Jan = $664.67 = $4800 * .0769291044 * (15pct/(100pct/12))
   Feb = $224.75 = $4800 * .0780384182 * ( 5pct/(100pct/12))
   Mar = $227.99 = $4800 * .0791637283 * ( 5pct/(100pct/12))
   Apr = $462.56 = $4800 * .0803052653 * (10pct/(100pct/12))
   May = $469.23 = $4800 * .0814632633 * (10pct/(100pct/12))
   Jun = $475.99 = $4800 * .0826379594 * (10pct/(100pct/12))
   Jul = $338.00 = $4800 * .0838295947 * ( 7pct/(100pct/12))
   Aug = $342.87 = $4800 * .0850384133 * ( 7pct/(100pct/12))
   Sep = $149.07 = $4800 * .0862646630 * ( 3pct/(100pct/12))
   Oct = $756.07 = $4800 * .0875085951 * (15pct/(100pct/12))
   Nov = $409.05 = $4800 * .0887704647 * ( 8pct/(100pct/12))
   Dec = $259.35 = $4800 * .0900505303 * ( 5pct/(100pct/12))

   Difference = $20.40 = $4800 - $4779.60( 664.67 + 224.75 +
                         227.99 + 462.56 + 469.23 + 475.99 + 338.00 +
                         342.87 + 149.07 + 756.07 + 409.05 + 259.35)

   Jan = $668 = $667.50 = $664.67 + ($664.67/$4779.60) * $20.40
   Feb = $225 = $225.71 = $224.75 + ($224.75/$4779.60) * $20.40
   Mar = $229 = $228.96 = $227.99 + ($227.99/$4779.60) * $20.40
   Apr = $465 = $464.53 = $462.56 + ($462.56/$4779.60) * $20.40
   May = $471 = $471.23 = $469.23 + ($469.23/$4779.60) * $20.40
   Jun = $478 = $478.03 = $475.99 + ($475.99/$4779.60) * $20.40
   Jul = $339 = $339.44 = $338.00 + ($338.00/$4779.60) * $20.40
   Aug = $345 = $344.34 = $342.87 + ($342.87/$4779.60) * $20.40
   Sep = $149 = $149.70 = $149.07 + ($149.07/$4779.60) * $20.40
   Oct = $760 = $759.30 = $756.07 + ($756.07/$4779.60) * $20.40
   Nov = $411 = $410.80 = $409.05 + ($409.05/$4779.60) * $20.40
   Dec = $260 = $260.45 = $259.35 + ($259.35/$4779.60) * $20.40
