
                                                               39
                                                     Open Systems
                                                    Import/Export


              NOTE: The printed manual contains 23 screen pictures
                    for this chapter. This helps display exactly
                    what is being explained. Use the printed
                    manual if it is available.


OSAS General Ledger Tools
=========================
Just as FW can read and write Lotus 1-2-3 WK1 files, this version
of FW can directly read and write the Open Systems Accounting
Software ("OSAS") general ledger version 4.10.

FW can import the following from the OSAS GL:
 *  Current year amounts
 *  Budgeted amounts
 *  Last year amounts

FW can export to the OSAS GL):
 *  Budgeted amounts


The Power of Combining OSAS & FW
================================

  Budgeting
  ---------
  FW uses sophisticated spreading techniques that enable
  users to produce forecasts on an annual or other basis,
  creating complete sets of monthly financial statements. In
  this way, seasonality and links to other accounts such as
  linking cost of sales to sales can be accomplished. FW can
  then rewrite the monthly budget amounts back into the
  OSAS General Ledger file.

  Financial Analysis
  ------------------
  FW will help OSAS customers evaluate expected financial
  results. "What-if" analysis becomes an intrinsic part of the
  accounting process. Ratio analysis can be used to "grade"
  the expected results against company expectations or against
  the performance of competitors.

  Financial Reporting
  -------------------
  FW produces a complete set of monthly financial statements --
  not just general ledger accounts. All of the amounts in
  your general ledger accounts can be loaded into FW, or FW
  can be used to summarize accounts into financial
  statements.

  FASB 95 cash statements may be produced using either the
  direct or indirect methods.

  FW can play an important part in your monthly, quarterly,
  and annual financial reporting.

  Lotus 1-2-3 Conversion
  ----------------------
  FW can export its finished set of financial statements to
  WK1 files, with just ONE KEYSTROKE!

  An additional 1-2-3 export has been provided. FW can
  create a WK1 file with the OSAS account number, account
  description, and selected amounts. This allows users to
  import general ledger accounts, and export directly into
  WK1 file format.


Balance Sheet Modifications
---------------------------
FW displays all balance sheet amounts as ending balances as of
the end of each month, quarter or year. OSAS displays the
opening balance and for each month the total transactions for
that month.

Generally, FW will import the OSAS transactions as increases or
decreases to existing balances. FW will export to OSAS the
monthly change in balance sheet accounts, instead of balances.

In addition, both FW and OSAS store contra accounts, such as
allowance for bad debts and accumulated depreciation as positive
amounts. OSAS allows the user to note that an account should be
subtracted, while FW's accounts are pre-defined.

FW only deals with whole dollars. When importing amounts, FW
will round-off amounts. Exporting a percentage of an account will
result in a round-off to the nearest penny.


Financial Accounts
------------------
One of the great strengths of the OSAS chart of accounts is their
flexibility. Account numbers may be any 12 digit combination of
numbers and the alphabet. Any layout of accounts is possible.

The great strength of FW is its structure. While OSAS is very
flexible, financial reports, budgets, cash reports and financial
analysis must be built by the user in a report writer or third party
package such as Lotus 1-2-3.

FW includes a pre-defined set of financial accounts. The
accounting logic is already included for each account. This makes
reporting, budgets and financial analysis simple to obtain. While
pre-defined, FW allows the user to create thousands of sub-
accounts to mirror your general ledger. However, for report
writing, you may wish to use FW to summarize your OSAS
general ledger into a more compressed set of financials. the
choice is yours.


Quick Trial Run
---------------
At the end of this chapter is a quick trial run showing a full
OSAS import. The necessary files have been included in the
program installation. At this time you may wish to jump ahead to
that section, or continue reading the rest of this chapter prior to
running the examples.





OSAS Account Setup
==================
Before we can import OSAS GL amounts, we need to setup an
import file. Run the FW program and select a "new" or a
"previously saved file."

  NOTE: Since FW imports amounts into the currently active
  file, you must load a file at the start of the program before
  FW will display its import/export options.

After a file has been loaded, move the top menu listing to "Files",
and press enter. Then select the top choice "Load/Imp/Exp" from
the pull-down listing.

If this is the first time that you will be setting up an import file
for this OSAS company, select the option to "Create OSAS Setup
- Direct from GL." As we noted earlier in this chapter, FW
cannot use the account setup used within your OSAS GL file. A
setup file of your OSAS accounts and your FW accounts needs to
be set up.

You may also choose the option "Create/Modify Import/Export
Setup," however OSAS users will save time using the automatic
features of "Create OSAS Setup  - Direct from GL." The files
created under either option will be stored identically as (.IMP)
files.

  When importing your OSAS accounts, you have several options.
  ------------------------------------------------------------
  *  Set up a corresponding account in FW for each OSAS GL account.
  *  Combine some or all accounts into a smaller number of FW accounts.
  *  Import some but not all OSAS GL accounts.

  You may use the same setup file for import and export. You
  may also modify and save an (.IMP) import file under a
  different name.

  When combining multiple accounts, FW allows you to export
  a percentage of the combined FW results to various OSAS
  accounts. In this way budgeting telephone expense, or
  example, for 10 departments can be budgeted as one amount
  within FW, with a percentage exported to each of the 10
  accounts within the OSAS GL.

After selecting the option "Create OSAS Setup  - Direct from
GL," a screen titled "Create SETUP from OSAS General Ledger"
will be displayed.

You will be prompted for each item, one at a time. Press the
"ESC" key to abort this screen, or to start over.

  Note:OSAS generally has one file named "GLMAS" that
  stores all accounts for all companies, and a second smaller file
  named "GLMSK" that stores the company letter and account
  layout for each company. FW can read/write these files, or
  copies of these files. For FW purposes, these file names can
  be "GLMAS", "GLMSK" or any other name.

  Since FW does not have file locking for network use, you may
  wish to use a copy of your GLMAS and GLMSK files.

  In addition, FW may have been installed on a machine
  separate from the one containing your OSAS accounting
  system, or you may wish to operate FW from a laptop
  computer for portability. If your OSAS consultant is assisting
  you with your budget preparation, or financial reporting and
  analysis, your consultant need only obtain a copy of your
  GLMAS and GLMSK files. Using different file names assures safety.


 Name of GL file
 ---------------
 Enter the exact location of your GLMAS file. This should
 include the drive letter, subdirectory (if needed), and the file
 name. Under MS-DOS, you may enter names in upper or
 lower case.

 Company ID #
 ------------
 Enter your company letter. Since the GLMAS file can contain
 multiple companies in one file, we need to know which
 company to use.

 Note:Import setup file (.IMP) OSAS account numbers do
 not contain the company letter. If you have multiple
 companies with the same set of accounts, then the same .IMP
 file may be used.

 Name of MASK file
 -----------------
 Enter the exact location of your GLMSK file. This should
 include the drive letter, subdirectory (if needed), and the file
 name.

 Account Sort Number (ex: M123)
 ------------------------------
 FW will read your GLMSK file, and will sort your account
 numbers in the same way that OSAS would sort your
 accounts. If your account mask is set up for 'M' and '1' only,
 then FW will only accept 'M' and '1'. The 'M' can be entered
 in the upper case or lower case ('m').


For our example, we have used the OSAS sample company
GLMAS and GLMSK files. We are operating on a separate
machine from the OSAS accounting system, and have copied
these files from floppy disk into drive G (you may use your
current GLMAS and GLMSK files, or copies of these files).

After entering our "Account Sort Number", FW will proceed with
the setup.

For those familiar with the sample company, provided with your
OSAS accounting system, there are 107 account in the general
ledger. FW will display its work as it sorts through your file. Its
speed of operation will depend on the speed of your machine,
however its operation is fairly quick.

FW will now prompt you for the name of the .IMP file just
created. In this example we have chosen, and typed-in, the name
"OSAS1." You may select any name you wish. FW will save our
work into a file named "OSAS1.IMP", FW having added the
extension of .IMP.

  Note:If you were to press the "ESC" key at this time, the
  file and our work, would not be saved.

After typing the OSAS1, and pressing the "ENTER" key, FW
beeped us, notifying us that a file using the name OSAS1.IMP
was previously saved. After deciding that the previously saved file
is no longer needed, we press 'Y' for yes, and the file is saved.





OSAS to FW Account Setup
========================
We are now ready to proceed. Earlier in this chapter we noted
that you could have selected the menu option "Create/Modify
Import/Export Setup." By having FW create the OSAS setup, we
have saved a lot of work.

However, part of the import file cannot be created by FW.
Because OSAS allows any account number, for any account, FW
cannot match your accounts into our structure without the users
help.

At this time you should verify that the FW file presently in
memory is the file to be used for the OSAS import. Add
additional accounts into the FW spreadsheet as needed, to arrive
at the final structure of your FW BUDGET, RPT, or
CONSOLIDATION file.

In the future, you will be able to create templates of existing files,
so that this process will only need to be updated for new accounts
added to your OSAS general ledger. Also, different import setup
files can be maintained for different purposes.

You are now ready to complete the second part of the import
setup process. Pull-down the "Files" menu selection, and select
"Create/Modify Import/Export Setup."

Since we have just completed the creation of an .IMP file named
OSAS1.IMP, we will select the option "Load/Modify Import
Setup."

From the list of .IMP files, we see the file we just created,
"OSAS1.IMP".  Move the cell-block over the file name, and press
the function key "F10."

We now get to see the product of our work. Actually the process
is fairly simple. Having read this chapter, the steps should be
straightforward.

As you can see in the above screen, FW has set up one half of
the job. The OSAS account numbers have been sorted and
loaded into the .IMP file.

It is assumed that you have already added any new sub-accounts
to the existing BUDGET (or other) file. As a safety feature, FW
will not allow you to enter an FW account that has not been
created.

The first OSAS account is 1000, and we decide that all OSAS
cash accounts will be combined into the FW account 100000. We
will enter 100000 (but we have not pressed the ENTER key as yet).
You can see that the entry is shown on the lower left side of
the screen (all FW entries and error messages are displayed in
this location).

Now we will press the ENTER key.

Simply Amazing !  FW entered its account description "Cash."
This is the account description within the FW spreadsheet.
Instead of just a sea of financial account numbers, you can be
assured that you have entered the correct account number.

If you wish, you could stop here. On importation, FW would
import OSAS account number 1000, into FW account number
100000, only. The other OSAS accounts would not be imported,
as there is no account matchup.

Before we leave this screen we would like to point out that
similar to our regular spreadsheet, the "INS" key will allow new
rows to be inserted, and "CTRL + F8" will delete a row. The
.IMP file holds 5000 rows. Multiple .IMP files may be used to
load accounts into FW's spreadsheet, 5000 rows at a time.

Copy down commands will also speed completion. The "F2" key
will copy a number down to the next row, and move the cell-block
at the same time. "F3" operates 15 lines at a time, "F4" up to 500
at a time. For simplicity, 500 rows will be displayed at a time.
There are 10 pages of 500 rows each, or 5000 in total. These
pages are stored together within one .IMP file.

Alt+P will print a worksheet similar to that displayed on the
screen for all 5000 rows. However, blank cells (those with no
OSAS or FW account number) will not be printed. Alt+G will
print the current page only.

See the chapter "Lotus Import" for a full description of the
features available in the Setup file.

At this point we might decide to leave this file. Press '/' to leave.
This example, there are 107 OSAS entries, but only one FW
entry. Because you might have made an error, and missed
entering an account number, FW prompts you with an error
message as noted above. You can ignore this message by pressing
'Y' to continue.

Changes made to the .IMP file will NOT be automatically saved.
A choice will be presented to either save or not save your file.
This choice will appear weather or not you have modified the
current .IMP file.





OSAS Import
===========
Now that we have  a setup file, let's import the OSAS accounts
into FW. Move the top menu listing to "Files", and press enter.
Then select the top choice "Load/Imp/Exp" from the pull-down
listing.

Select the option "OSAS Import into BUDGET/RPT/CONSOL
file."


The OSAS import screen, displayed above, has several options.

 Name of GL file
 ---------------
 Enter the exact location of your GLMAS file. This should
 include the drive letter, subdirectory (if needed), and the file
 name. Under MS-DOS, you may enter names in upper or
 lower case.

 Import
 ------
 Monthly LastYear, CurrentYear, or Budget amounts may be
 imported from the OSAS GL file. Press 'L', 'C', or 'B' to
 record your selection.

 OSAS - First monthly period
 ---------------------------
 OSAS accounts contain 14 periods.
 *  0          Opening balance
 *  1 to 12    12 months of transactions
 *  13         Used for year-end closing adjustments

 All or selected months may be imported into FW, with the
 following modifications.
 *  The 13th period may not be imported.
 *  Entering '0' will only affect (FW) balance accounts.
    Income and cash statement accounts will import from
    period '1'.

    Period '0', if selected, will be imported into the first
    balance sheet period (within FW) selected. Period '1' will
    be imported into the second period selected for the B/S,
    I/S and C/S.

 Enter the OSAS period number from which to start the
 import.

 OSAS - Last monthly period
 --------------------------
 Enter the last OSAS period number from which to import.

 Company ID #
 ------------
 Enter your company letter. Since the GLMAS file can contain
 multiple companies in one file, we need to know which
 company to use.

 Note:Import setup file (.IMP) OSAS account numbers do
 not contain the company letter. If you have multiple
 companies with the same set of accounts, then the same .IMP
 file may be used.

 B/S - Import OSAS (B)al or (T)ransaction
 ----------------------------------------
 This choice only affects accounts imported into FW balance
 sheet accounts. OSAS stores monthly transactions for balance
 sheet accounts. Generally, you will select 'B' to have these
 transactions reflected as increases/decreases to existing
 balances within FW.

 There may be times where you wish to import balance sheet
 transactions into FW. For example, if you are entering fixed
 asset accounts into Data Entry periods within FW, and you
 are using formula methods 105 to 108, which increase the
 previous balance by an amount, you may wish to import these
 transactions as transactions, and not as balances.

 Only one selection may be made for each import.

 FW - Starting Column #
 ----------------------
 The OSAS monthly periods (0 to 12) will be placed into
 corresponding column within FW. FW's monthly Calc
 spreadsheet starts with an opening balance sheet at column
 '0'. The first 12 monthly periods (1 to 12) represent the first
 year, 13 to 24 the second year, and 25 to 36 the third year.

 Things are a little different if you are entering amounts into
 FW's Data Entry columns, instead of its Monthly Calc
 columns. If the Data Entry columns were all annual, then the
 opening balance sheet would be column '0', the first year
 would be column '1', the second year column '2', and the third
 year column '3'. There would not be any columns beyond
 column 3, in this example. But, as you will see, you can
 request that FW combine OSAS monthly transactions into
 quarterly and annual columns within FW. This can be of use
 in budgeting, and in financial reporting.

 Entering column '0' only affects entries into the B/S. I/S and
 C/S accounts would start at column '1', which in this case
 would be the second column.

 Overwrite amounts already in FW
 -------------------------------
 Answer yes to clear the FW spreadsheet prior to any import
 of amounts. Only the accounts and columns to be imported
 will be cleared. All other accounts and columns within the
 current FW spreadsheet will be unaffected.

 Clearing (to $0) occurs prior to any import of amounts.
 Imported amounted are then "added to" or "subtracted from"
 the current balance or amount. In this way multiple accounts
 can be imported into the same FW account.

 Clear imported accounts through last column
 -------------------------------------------
 Answer yes to clear the FW spreadsheet prior to any import
 of amounts. Only the accounts and columns to be imported
 will be cleared, plus any columns beyond the last columns to
 be imported. All other accounts and columns within the
 current FW spreadsheet will be unaffected.

 "Overwrite amounts already in FW" must be set to "Yes" no
 select this option.

 The user has the option of clearing any mixture of B/S, I/S, or
 C/S accounts (referring to accounts in FW).

 Data Entry (D) or Monthly Calc (M)
 ----------------------------------
 OSAS amounts may be imported into the Data Entry periods,
 or the Monthly Calc (monthly) periods.

 If (D) - Sum amounts : If (M) - Change to #99
 ---------------------------------------------
 If Osas amounts are to be imported into Data Entry periods,
 "Yes" to this option will summarize OSAS monthly amounts
 into the existing monthly/quarterly/annual Data Entry periods
 for the current spreadsheet.

 If Osas amounts are to be imported into Monthly Calc
 (monthly) periods, "Yes" to this option will change the
 respective Data Entry formula method to #99. Formula
 method #99 tells FW that on re-calculation, the monthly calc
 results should be used. This allows OSAS users to import
 monthly amounts into the resulting monthly calculation
 accounts, while at the same time forecasting other accounts
 or columns on a quarterly or annual basis. This can be a very
 powerful "What if" option.

The next step is to select the .IMP file, previously created.

FW will display its progress. The import should be fairly quick.
The above message will appear notifying you that the OSAS file
has been imported into the current FW spreadsheet.

The above reflects the results of the import. In this case we have
imported just one account. OSAS account 1000 has been
imported into FW account 100000. The amounts within A/C
#100000 were first cleared (set to $0).

OSAS A/C #1000:                  FW A/C #100000:
--------------------------       ---------------

Period              Amount       FW Amount     Period
------            --------       ---------     ------
0 Opening         $4514.50        $4515        3/31/89 Op. B/S
1                   351.12
2                  -201.14
3                    12.12         4677        6/30/89 1st qtr
4                   115.50
5                   -15.00
6                    85.75         4863        9/30/89 2nd qtr
7                    15.63
8                   177.90
9                  -220.00         4836        12/31/89 3rd qtr
10                  188.88
11                  -84.60
12                 -100.00         4841        3/31/90 Year end
13                     .00
END               $4840.66

As can be seen from the BS-Data Entry screen, the balance of $4841
at the end of the first year has been extended through the end of
the second and third years. It would not have made sense to go from
$4841 back to $0, so the last recorded amount was extended
through the remaining periods. This extension only applies to FW
balance sheet accounts. No extensions are performed on I/S or
C/S accounts.

If we had selected to leave the existing amounts intact (not clear
the account to $0, prior to the import), then the imported
transactions would be added to existing amounts, including those
in the second and third year.

 For example, if the existing cash balance was $100 for all
 periods for the three years (and the account was not cleared),
 then the balance at the end of the first, second and third year
 would have been $4941 ($100 + $4841).





OSAS Export
===========
Let's assume that FW's purpose was to create monthly budgets.
We now wish to export FW amounts into the OSAS accounts.
Move the top menu listing to "Files", and press enter. Then select
the top choice "Load/Imp/Exp" from the pull-down listing.

Select the option to export budgeted amounts to OSAS (LastYear
and CurrentYear amounts within OSAS may not be re-stated by FW).


The OSAS export screen has several options.

 Name of GL file
 ---------------
 Enter the exact location of your GLMAS file. This should
 include the drive letter, subdirectory (if needed), and the file
 name. Under MS-DOS, you may enter names in upper or
 lower case.

 FW - Starting Column #
 ----------------------
 FW export its Monthly Calc (monthly) amounts into the
 OSAS GL. Data Entry periods may not be exported.

 The FW monthly periods will be placed into corresponding
 column within OSAS. FW's monthly Calc spreadsheet starts
 with an opening balance sheet at column '0'. The first 12
 monthly periods (1 to 12) represent the first year, 13 to 24
 the second year, and 25 to 36 the third year.

 Generally you will not export from FW's column '0'. FW
 assumes that the prior period is $0, and will export the full
 amount in column '0'. Entering column '0' only affects entries
 from the B/S. I/S and C/S accounts would start at column '1',
 which in this case would be the second column.

 FW - Ending Column #
 --------------------
 Enter the last FW column number to export.

 OSAS - First monthly period
 ---------------------------
 OSAS accounts contain 14 periods.
 *  0          Opening balance
 *  1 to 12    12 months of transactions
 *  13         Used for year-end closing adjustments

 All or selected months may be exported into OSAS, with the
 following modification.
 *  FW may only export into periods 1 to 12.

 Enter the first OSAS period number to which FW should export.

 Company ID #
 ------------
 Enter your company letter. Since the GLMAS file can contain
 multiple companies in one file, we need to know which
 company to use.

 Note:Import setup file (.IMP) OSAS account numbers do
 not contain the company letter. If you have multiple
 companies with the same set of accounts, then the same .IMP
 file may be used.

 Overwrite amounts already in OSAS
 ---------------------------------
 Answer yes to clear the OSAS accounts prior to any export of
 amounts from FW. Only the accounts and periods to be
 exported to, will be cleared. All other accounts and periods
 within the OSAS file will be unaffected.

 Clearing (to $0) occurs prior to any export of amounts.
 Exported amounted are then "added to" or "subtracted from"
 the current transaction amount in the OSAS GL. In this way
 multiple accounts can be exported into the same OSAS
 account.

 Clear GL accounts through last period
 -------------------------------------
 Answer yes to clear OSAS prior to any export of amounts.
 Only the accounts and periods to be exported to, will be
 cleared, plus any periods (through period 12) beyond the last
 periods to be exported. All other accounts and periods within
 the OSAS file will be unaffected.

 "Overwrite amounts already in OSAS" must be set to "Yes" no
 select this option.

 The user has the option of clearing any mixture of B/S, I/S, or
 C/S accounts (referring to accounts originating in FW).


After filling out the "Export to Open Systems General Ledger"
screen, FW will ask which .IMP file to use for export. The same
file that was used for import can also be used for export. For our
example we will use the OSAS1.IMP file that we created earlier
in this chapter.

FW will now process this file. The export should be fairly quick.
A message will appear notifying you that the file has been
exported into your GLMAS file (or a copy of your GLMAS file
under a different name).

We have tried to make the OSAS file setup as simple as possible.
At the same time our setup screens have tried to provide all the
options, without making the process overly complex.

Once your IMP file has been created, it can be quickly used over
and over again.





Quick Trial Run
===============
A special example file was installed in your \Wonder\Data
directory. Supplement the following instructions to use our OSAS
examples (the following will only make sense if used while
operating Financial Wonder).

*  Load the budget file named "OSASSAMP.WDR". This is our
   standard file, plus about 15 accounts have been added. Setting
   up this file took less than 5 minutes. We simply pressed the
   "INS" key to insert some new accounts. Since we will be
   importing your OSAS account numbers, I didn't spend time
   entering account descriptions.

*  Press "ENTER" to pull down the "FILES" menu and select
   the pull-down option "Load/Imp/Exp."

*  Select the option "IMPORT FACILITY - OSAS Import into
   BUDGET/RPT/CONSOL file."

*  The screen's title will be "Import from Open Systems General
   Ledger." (assuming the FW program is in the C:\WONDER
   directory), enter the following responses:

    Import - Description            User Response
    --------------------            ---------------------------
    Name of GL file         :       c:\wonder\glmas
    Import                  :       C  (for Current Year)
    First monthly period    :       0  (for the OSAS B/S Opening Balances)
    Last monthly period     :       12 (for months 1 through 12)
    Company ID              :       H  (for the OSAS sample company)
    (B)al or (T)ransact.    :       B  (import balances into the B/S)

    Financial Wonder                                                                                    User Response
     Starting column #      :       0  (import into the FW B/S
                                        opening balance)
    Overwrite amounts already in FW?       :      YES
    Clear imported accts thru last column  :      YES Clear B/S I/S C/S
    Data Entry (D) or Monthly Calc (M)     :      D (for Data Entry column)
    If (D)-Sum Amts ? If (M)-Chge to #9    :      YES Summarize Amounts

    Press "/" to continue, then highlight and press "F10" to select
    the file "OSASSAMP.IMP."

In this example, we have chosen to combine a number of
expense accounts into just three or four expense accounts within
FW. We have also chosen to summarize the 12 months of data in
the OSAS GL, into just one "Data Entry" column within FW, and
to import selected OSAS account descriptions. After this process
is complete, select the "Calculate" top-menu option, and the pull-
down option "Calculate". THAT'S IT!

Select the top-menu "SCREENS", and view the "Data Entry"
to see the amounts imported from your OSAS file, and "Calc" to
view the calculated amounts. Press "F1" to change financial
statements. Press the "LEFT ARROW" key from the first Data
Entry column to view the opening balances on the B/S.

You may now export to Lotus 123 formal reports ("FILES"
menu option, and "LOTUS Conv"), or export the raw account
information to Lotus 123 ("FILES" then "LOAD/IMP/EXP", then
"Lotus Export Using Setup").


A SECOND EXAMPLE
----------------
* Select the "FILES" menu, then "Blank Amounts", and clear all
amounts in the current spreadsheet.

* Select "FILES", then "NEW STRUCT", and change the first
  year from "ANNUAL" to all "MONTHLY", by pressing "M" for monthly.

* Now pull down the "FILES" menu and select the pull-down
  option "Load/Imp/Exp", then select the option "IMPORT
  FACILITY - OSAS Import into BUDGET/RPT/CONSOL
  file." Follow the same procedures as in the first example,
  except make the following change:

    If (D)-Sum Amts ? If (M)-Chge to #9         :  NO

Financial Wonder will now import all 12 months, plus the
opening balances, into Financial Wonder. Simply recalculate, and
you have complete sets of monthly financial statements, including
cash reports and ratio analysis.

