

                                                                7
                                                      Interest on
                                                        Cash Flow


As we learned in Chapter 6, FW will automatically calculate
changes in cash flow for you, will tax effect these changes in
cash flow, and will update your financials. In addition, FW can
calculate interest income/expense on your positive/negative
cash flow. The following accounts will be needed to
implement this:

       Account #254000  Int Expense - excess debt
       Account #255000  Ex Dbt - Days in Period

       Account #260000  Int Income - excess cash
       Account #261000  Ex Csh - Days in Period

If there is a negative cash flow, accounts #254000 and
255000 will be used. For a positive cash flow, accounts
#260000 and 261000 will be used. Let's go over how to use
these accounts.

"Interest Expense - excess debt" expects a rate of interest
expense on negative cash flow for the entire Data Entry
period. The formula method selection is unimportant as FW
will override. As you will note FW will prompt you for a
percentage with up to three decimal places. "Ex Dbt - Days in
Period" expects a number of days, up to three decimal places, to
be used for ADDITIONAL LOANS for the current period only.

For example, say that in the first and second months forecast,
your Company is operating at a negative cash flow. Also, let's
assume that you entered 20 percent in account #254000 and 20
days in account #255000. FW will calculate a 1.6667 percent interest
charge (20 percent / 12 months) for 20 days in the first month. You
have used a going rate of borrowing and forecast that the
additional funds will be needed in the earlier part of the
month. In the second month, you have also operated at a
negative cash flow over-and-above that of the first month.
Here FW shows some of its intelligence. In calculating the
interest expense for the second month, FW will take a full 30
days interest at 1.6667 percent (20 percent / 12 months) on the additional
funds needed in the first month, and still owed to the lender,
and FW will take 20 days interest at 1.6667 percent on the
additional funds needed for the second month. Of course, all
of this will also be tax effected based on the tax rate (account
#282000 / taxable income).

Should the cash flow be positive for the first and second
months forecast, the operations would be similar to that just
described, however interest income, not interest expense,
would be recorded and FW would look at accounts #260000
and 261000 for the rate of interest and the number of days
current funds will be invested.

Although the rates and the number of days remain constant
throughout the Data Entry's forecast period, these items may
be changed in each of the forecast periods.

There are eight possible directions of cash flow:

     A net cash flow of $0 for all previous months. There will
     be $0 balances for MARKETABLE SECURITIES and
     ADDITIONAL LOANS.

       1. A positive cash flow for the current month.

       2. A negative cash flow for the current month.

     A net positive cash flow for all previous months. There
     will be a positive balance for MARKETABLE SECURITIES.

       3. A positive cash flow for the current month.

       4. A negative cash flow for the current month, but
          less than the balance in MARKETABLE SECURITIES.

       5. A negative cash flow for the current month,
          exceeding the balance in MARKETABLE SECURITIES.


     A net negative cash flow for all previous months. There
     will be a positive balance for ADDITIONAL LOANS.

       6. A negative cash flow for the current month.

       7. A positive cash flow for the current month, but less
          than the balance in ADDITIONAL LOANS.

       8. A positive cash flow for the current month,
          exceeding the balance in ADDITIONAL LOANS.



Let's look at a detailed example of how interest is calculated
in each of these instances.


EXAMPLE 1 - A positive cash flow for the current month
======================================================

     ASSUMPTIONS AT THE BEGINNING OF THE MONTH
     -----------------------------------------
       MARKETABLE SECURITIES          $    0
       ADDITIONAL LOANS               $    0
       Account #260000                10 percent
       Account #261000                20 days

     ASSUMPTIONS FOR THE MONTH
     -------------------------
       Positive cash flow this month  $10000
       Tax expense (#282000)          $ 8600
       Taxable income                 $20000

     FW will take the positive cash flow of $10000 multiplied
     by the interest income rate of .8333 percent (10 percent / 12 months)
     times the days this cash was available for investment
     over the number of days in the month .6667 (20 days /
     30 days). The positive cash flow resulted in interest
     income of $55.56 or $56.

     The tax rate for the month is 43 percent ($8600 / $20000). Tax
     expense on interest income is $23.89 or $24 ($55.56 * .43).

     MARKETABLE SECURITIES will increase from $0 at the
     beginning of the month to $10032 ($10000 positive cash
     flow for the month, plus interest income of $56, less tax
     on interest income of $24).

     The Cash Statement, Balance Sheet, and Income
     Statement will all be adjusted to reflect the above.



EXAMPLE 2 - A negative cash flow for the current month
======================================================

     ASSUMPTIONS AT THE BEGINNING OF THE MONTH
     -----------------------------------------
       MARKETABLE SECURITIES          $    0
       ADDITIONAL LOANS               $    0
       Account #254000                20 percent
       Account #255000                20 days

     ASSUMPTIONS FOR THE MONTH
     -------------------------
       Negative cash flow this month  $10000
       Tax expense (#282000)          $ 8600
       Taxable income                 $20000

     FW will take the negative cash flow of $10000 multiplied
     by the interest expense rate of 1.6667 percent (20 percent / 12
     months) times the days this cash was available for
     investment over the number of days in the month .6667
     (20 days / 30 days). The negative cash flow resulted in
     interest expense of $111.11 or $111.

     The tax rate for the month is 43 percent ($8600 / $20000). Tax
     savings on interest expense is $47.78 or $48 ($111.11
     * .43).

     ADDITIONAL LOANS will increase from $0 at the
     beginning of the month to $10063 ($10000 negative cash
     flow for the month, plus interest expense of $111, less
     tax savings on interest expense of $48).

     The Cash Statement, Balance Sheet, and Income
     Statement will all be adjusted to reflect the above.



EXAMPLE 3 - A net positive cash flow for all previous months
            A positive cash flow for the current month
============================================================

     ASSUMPTIONS AT THE BEGINNING OF THE MONTH
     -----------------------------------------
       MARKETABLE SECURITIES          $15000
       ADDITIONAL LOANS               $    0
       Account #260000                10 percent
       Account #261000                20 days

     ASSUMPTIONS FOR THE MONTH
     -------------------------
       Positive cash flow this month  $10000
       Tax expense (#282000)          $ 8600
       Taxable income                 $20000

     Interest income on MARKETABLE SECURITIES is
     calculated by taking the opening balance of $15000
     multiplied by the interest income rate of .8333 percent
     (10 percent / 12 months). The result is $125.00 or $125.

     FW will take the positive cash flow of $10000 multiplied
     by the interest income rate of .8333 percent (10 percent / 12 months)
     times the days this cash was available for investment
     over the number of days in the month .6667 (20 days /
     30 days). The result is $55.56 or $56.

     The positive cash flow resulted in interest income of
     $181 ($125 + $56).

     The tax rate for the month is 43 percent ($8600 / $20000). Tax
     expense on interest income is $78 ($54 + $24) :
     ($125.00 * .43 = $53.75 or $54) + ($55.56 * .43 = $23.89 or $24).

     MARKETABLE SECURITIES will increase from $15000 at the
     beginning of the month to $25103 ($15000 opening balance,
     $10000 positive cash flow for the month, plus interest income
     of $181, less tax on interest income of $78).

     The Cash Statement, Balance Sheet, and Income Statement
     will all be adjusted to reflect the above.



EXAMPLE 4 - A net positive cash flow for all previous months
            A negative cash flow for the current month, but
            less than the balance in MARKETABLE SECURITIES
============================================================

     ASSUMPTIONS AT THE BEGINNING OF THE MONTH
     -----------------------------------------
       MARKETABLE SECURITIES          $15000
       ADDITIONAL LOANS               $    0
       Account #260000                10 percent
       Account #261000                20 days

     ASSUMPTIONS FOR THE MONTH
     -------------------------
       Negative cash flow this month  $10000
       Tax expense (#282000)          $ 8600
       Taxable income                 $20000

     Interest income on MARKETABLE SECURITIES is
     calculated by taking the opening balance of $15000
     multiplied by the interest income rate of .8333 percent
     (10 percent / 12 months). The result is $125.00 or $125.

     FW will take the negative cash flow of $10000 multiplied
     by the interest income rate of .8333 percent (10 percent / 12 months)
     times the days this cash was NOT available for investment
     over the number of days in the month .6667 (20 days /
     30 days). The result is $55.56 or $56.

     The positive cash flow resulted in interest income of $69
     ($125 - $56).

     The tax rate for the month is 43 percent ($8600 / $20000). Tax
     expense on interest income is $30 ($54 - $24) :
     ($125.00 * .43 = $53.75 or $54) - ($55.56 * .43 = $23.89 or $24).

     MARKETABLE SECURITIES will decrease from $15000 at the
     beginning of the month to $5039 ($15000 opening balance,
     $10000 negative cash flow for the month, plus interest income
     of $69, less tax on interest income of $30).

     The Cash Statement, Balance Sheet, and Income Statement
     will all be adjusted to reflect the above.



EXAMPLE 5 - A net positive cash flow for all previous months
            A negative cash flow for the current month,
            exceeding the balance in MARKETABLE SECURITIES
============================================================

     ASSUMPTIONS AT THE BEGINNING OF THE MONTH
     -----------------------------------------
       MARKETABLE SECURITIES          $15000
       ADDITIONAL LOANS               $    0
       Account #254000                20 percent
       Account #255000                20 days
       Account #260000                10 percent
       Account #261000                18 days

     ASSUMPTIONS FOR THE MONTH
     -------------------------
       Negative cash flow this month  $25000
       Tax expense (#282000)          $ 8600
       Taxable income                 $20000


     FW takes interest income on MARKETABLE SECURITIES
     of $15000 multiplied by the interest income rate of
     .8333 percent (10 percent / 12 months) times the number of days
     this money is not needed to cover the negative cash
     flow .3333 ([30 days - 20 days needed for debt]/30
     days). The result is $41.66 or $42.

     This is equivalent to taking interest income on $15000 for
     30 days at 10 percent and interest expense on the same
     $15000 used to fund the negative cash flow for 20 days
     at the same 10 percent rate. FW assumes that the interest
     income rate will be lower than the interest expense rate
     and therefore assumes that you will use previous excess
     funds to fund the negative cash flow.

     The tax rate for the month is 43 percent ($8600 / $20000). Tax
     expense on interest income is $48 ($41.66 * .43 = $17.91 or $18).

     FW will then take the negative cash flow in excess of
     opening MARKETABLE SECURITIES of $10000 ($25000 -
     $15000) multiplied by the interest expense rate of
     1.6667 percent (20 percent / 12 months) times the days this cash
     was borrowed over the number of days in the month
     .6667 (20 days / 30 days). The result is $111.11 or $111.

     The tax rate for the month is 43 percent ($8600 / $20000). Tax
     savings on interest expense is $48 ($111.11 * .43 = $47.78 or $48).

     MARKETABLE SECURITIES will decrease from $15000 at
     the beginning of the month to $0.

     ADDITIONAL LOANS will increase from $0 at the
     beginning of the month to $10039 ($0 opening balance,
     $10000 negative cash flow for the month in excess of
     opening MARKETABLE SECURITIES, less interest income
     of $42, plus tax expense on interest income of $18, plus
     interest expense of $111, less tax savings on interest
     expense of $48.

     The Cash Statement, Balance Sheet, and Income
     Statement will all be adjusted to reflect the above.



EXAMPLE 6 - A net negative cash flow for all previous months
            A negative cash flow for the current month
============================================================

     ASSUMPTIONS AT THE BEGINNING OF THE MONTH
     -----------------------------------------
       MARKETABLE SECURITIES          $    0
       ADDITIONAL LOANS               $15000
       Account #254000                20 percent
       Account #255000                20 days

     ASSUMPTIONS FOR THE MONTH
     -------------------------
       Negative cash flow this month  $10000
       Tax expense (#282000)          $ 8600
       Taxable income                 $20000

     Interest expense on ADDITIONAL LOANS is calculated
     by taking the opening balance of $15000 multiplied by
     the interest expense rate of 1.667 percent (20 percent / 12
     months). The result is $250.00 or $250.

     FW will take the negative cash flow of $10000 multiplied
     by the interest expense rate of 1.6667 percent (20 percent / 12
     months) times the days this cash was available for
     investment over the number of days in the month .6667
     (20 days / 30 days). The result is $111.11 or $111.

     The negative cash flow resulted in interest expense of
     $361 ($250 + $111).

     The tax rate for the month is 43 percent ($8600 / $20000). Tax
     savings on interest expense is $156 ($108 + $48) :
     ($250.00 * .43 = $107.50 or $108) + ($111.11 * .43 = $47.78 or $48).

     ADDITIONAL LOANS will increase from $15000 at the
     beginning of the month to $25205 ($15000 opening balance,
     $10000 negative cash flow for the month, plus interest
     expense of $361, less tax savings on interest expense of
     $156). The Cash Statement, Balance Sheet, and Income
     Statement will all be adjusted to reflect the above.



EXAMPLE 7 - A net negative cash flow for all previous months
            A positive cash flow for the current month, but
            less than the balance in ADDITIONAL LOANS
============================================================

     ASSUMPTIONS AT THE BEGINNING OF THE MONTH
     -----------------------------------------
       MARKETABLE SECURITIES          $    0
       ADDITIONAL LOANS               $15000
       Account #254000                20 percent
       Account #255000                20 days

     ASSUMPTIONS FOR THE MONTH
     -------------------------
       Positive cash flow this month  $10000
       Tax expense (#282000)          $ 8600
       Taxable income                 $20000

     Interest expense on ADDITIONAL LOANS is calculated
     by taking the opening balance of $15000 multiplied by
     the interest expense rate of 1.6667 percent (20 percent / 12
     months). The result is $250.00 or $250.

     FW will take the positive cash flow of $10000 multiplied
     by the interest expense rate of 1.6667 percent (20 percent / 12
     months) times the days this cash was NOT borrowed over
     the number of days in the month .6667 (20 days / 30
     days). The result is $111.11 or $111.

     The negative cash flow resulted in interest expense of
     $139 ($250 - $111).

     The tax rate for the month is 43 percent ($8600 / $20000). Tax
     savings on interest expense is $60 ($108 - $48) :
     ($250.00 * .43 = $107.50 or $108) - ($111.11 * .43 = $47.78 or $48).

     ADDITIONAL LOANS will decrease from $15000 at the
     beginning of the month to $5079 ($15000 opening
     balance, $10000 positive cash flow for the month, plus
     interest expense of $139, less tax savings on interest
     expense of $60).

     The Cash Statement, Balance Sheet, and Income
     Statement will all be adjusted to reflect the above.



EXAMPLE 8 - A net negative cash flow for all previous months
            A positive cash flow for the current month,
            exceeding the balance in ADDITIONAL LOANS
============================================================

     ASSUMPTIONS AT THE BEGINNING OF THE MONTH
     -----------------------------------------
       MARKETABLE SECURITIES          $    0
       ADDITIONAL LOANS               $15000
       Account #254000                20 percent
       Account #255000                18 days
       Account #260000                10 percent
       Account #261000                20 days

     ASSUMPTIONS FOR THE MONTH
     -------------------------
       Positive cash flow this month  $25000
       Tax expense (#282000)          $ 8600
       Taxable income                 $20000


     FW takes interest expense on ADDITIONAL LOANS of
     $15000 multiplied by the interest expense rate of
     1.6667 percent (20 percent / 12 months) times the number of days
     this money is not covered by the positive cash flow
     .3333 ([30 days - 20 days covered by the positive cash
     flow]/30 days). The result is $83.33 or $83.

     This is equivalent to taking interest expense on $15000
     for 30 days at 20 percent and interest income on the same
     $15000 from positive cash flow for 20 days at the same
     20 percent rate. FW assumes that the interest expense rate will
     be higher than the interest income rate and therefore
     assumes that you will fund previous debt with positive
     cash flow from the current period.

     The tax rate for the month is 43 percent ($8600 / $20000). Tax savings
     on interest expense is $48 ($83.33 * .43 = $35.83 or $36).

     FW will then take the positive cash flow in excess of
     opening ADDITIONAL LOANS of $10000 ($25000 - $15000)
     multiplied by the interest income rate of .8333 percent
     (10 percent / 12 months) times the days this cash was
     invested over the number of days in the month .6667
     (20 days / 30 days). The result is $55.56 or $56.

     The tax rate for the month is 43 percent ($8600 / $20000). Tax
     on interest income is $24 ($55.56 * .43 = $23.89 or $24).

     ADDITIONAL LOANS will decrease from $15000 at the
     beginning of the month to $0.

     MARKETABLE SECURITIES will increase from $0 at the
     beginning of the month to $9985 ($0 opening balance,
     $10000 positive cash flow for the month in excess of
     opening ADDITIONAL LOANS, less interest expense of
     $83, plus tax savings on interest expense of $36, plus
     interest income of $56, less tax on interest income of $24).

     The Cash Statement, Balance Sheet, and Income
     Statement will all be adjusted to reflect the above.
