#include "inkey.ch"
#include "fastgt.ch"


#define ENT_SCROLL 1
#define ENT_BOXD   2
#define ENT_BOXS   3
#define ENT_LINEH  4
#define ENT_LINEV  5
#define ENT_SAY    6
#define ENT_SAYGET 7
#define ENT_READ   8
#define ENT_COLOR  9

#define STRUCT_SIZE 479
#define CRLF        Chr( 13 ) + Chr( 10 )

Static aQueue    := {}
Static aQueueStr  := {}
Static aEntity   := { "Scroll", ;
                      "Double Box", ;
                      "Single Box", ;
                      "Horizontal Line", ;
                      "Vertical Line", ;
                      "Say", ;
                      "Say/Get", ;
                      "Read", ;
                      "Default Color" }
Static aMsg      := {}
Static lFlag
Static aOptions
Static cGenCode
Static cFileName
Static gtHandle


Function Main( cFile )
Local nInd
Local lFlag   := .T.
Local nKey
Local nOption
Local nX
Local nY
    gtHandle := gtInit( 4 )
    SET SCOREBOARD OFF
    SET CONFIRM    ON
    SET BELL       OFF
    SetCancel( .F. )
    aOptions := IniLoad( "fastsd.ini", "FASTSD" )
    cFileName := AllTrim( IniSearch( aOptions, "DEFAULTFILE", "noname" ) )
    @  0, 0, 3, 79 BOX SPACE( 9 ) COLOR "GR+/B"
    @ 29, 0 SAY Space( 80 ) COLOR "N/W"
    ChargeFont( "courier.fon" )
    @  0, 1 SAY "Screen Designer, FAST.SD. (C) 1992-94 Manu Roibal, FastWare Solutions" Color "GR+/B"
    VesaSetFont( FONT_BIG )
    @  1, 1 SAY "< New Entity  F2 File  F10 Entity Queue  Esc Exit" Color "W+/B"
    @  2, 1 SAY "File: " + PadR( cFileName, 30 ) Color "W/B"
    For nInd := 0 To 79 Step 10
      @ 3, nInd SAY "" COLOR "GR+/B"
    Next
    MsgInit()
    nY := 4
    nX := 0
    SetCursor( 0 )
    DrawEntity()
    PushMsg( "Push Enter to draw a new entity" )
    If cFile != Nil
      FileOpt( 2, cFile )
      DrawEntity()
    EndIf
    While lFlag
      @ 29, 74 Say Str( nY - 4, 2 ) + ":" + Str( nX, 2 ) COLOR "R/W"
      SetPos( nY, nX )
      MyPencil( nY, nX, .T. )
      nKey := OwnInkey( 0 )
      MyPencil( nY, nX, .F. )
      Do Case
        Case nKey == K_UP
          nY--
        Case nKey == K_DOWN
          nY++
        Case nKey == K_RIGHT
          nX++
        Case nKey == K_LEFT
          nX--
        Case nKey == K_TAB
          nX += 6
        Case nKey == K_SH_TAB
          nX -= 6
        Case nKey == K_HOME
          nX := 0
        Case nKey == K_END
          nX := 79
        Case nKey == K_PGUP
          nY := 0
        Case nKey == K_PGDN
          nY := 28
        Case nKey == K_F2
          FileOpt( 0 )
          DrawEntity()
        Case nKey == K_F10
          Queue()
          DrawEntity()
        Case nKey == K_RETURN
          nOption := NewEntity()
          If nOption == ENT_SCROLL
            AskScroll( nY - 4, nX, nY - 4, nX, "", -1 )
            DrawEntity()
          ElseIf nOption == ENT_BOXD
            AskBoxD( nY - 4, nX, nY - 4, nX, "", -1 )
            DrawEntity()
          ElseIf nOption == ENT_BOXS
            AskBoxS( nY - 4, nX, nY - 4, nX, "", -1 )
            DrawEntity()
          ElseIf nOption == ENT_LINEH
            AskLineH( nY - 4, nX, nY - 4, 0, "", -1 )
            DrawEntity()
          ElseIf nOption == ENT_LINEV
            AskLineV( nY - 4, nX, 0, nX, "", -1 )
            DrawEntity()
          ElseIf nOption == ENT_SAY
            AskSay( nY - 4, nX, "", "", -1 )
            DrawEntity()
          ElseIf nOption == ENT_SAYGET
            AskSayGet( nY - 4, nX, "", "", "", "", "", "", "", 0, -1 )
            DrawEntity()
          ElseIf nOption == ENT_READ
            AskREAD()
          ElseIf nOption == ENT_COLOR
            AskColor( "", -1 )
            DrawEntity()
          EndIf
        Case nKey == K_ESC
          If Inquire( "Are you sure you want to exit to DOS? (Y/N)", "Exit" )
            lFlag := .F.
          EndIf
      EndCase
      nY := Max( Min( nY, 28 ), 4 )
      nX := Max( Min( nX, 79 ), 0 )
    EndDo
    PopMsg()
    IniSave( aOptions, "DEFAULTFILE", cFileName )
    IniWrite( aOptions, "fastsd.ini", "FASTSD" )
Return( Nil )





// ****************************************************
//
// Shows entity queue
//
// ****************************************************
static Function Queue()
Local cScreen := SaveScreen( 6, 2, 25, 77 )
Local cColor  := SetColor( "W+/B", "GR+/B" )
Local nLen
Local nInd
    lFlag := .T.
    While lFlag
      gtWinBox( 6, 2, 25, 77, "W+/B", "Select Entity" )
      aQueueStr := {}
      nLen := Len( aQueue )
      For nInd := 1 To nLen
        aAdd( aQueueStr, PadR( aEntity[ aQueue[ nInd, 1 ] ], 14 ) + ;
                        Str(  aQueue[ nInd, 2 ], 4  ) + ;
                        Str(  aQueue[ nInd, 3 ], 4  ) + ;
                        Str(  aQueue[ nInd, 4 ], 4  ) + ;
                        Str(  aQueue[ nInd, 5 ], 4  ) + ;
                        "  " + ;
                        PadR( aQueue[ nInd, 6 ], 10 ) + ;
                        PadR( aQueue[ nInd, 8 ], 15 ) + ;
                        "    " + ;
                        PadR( aQueue[ nInd, 9 ], 12 ) + ;
                        aQueue[ nInd, 10 ] )
      Next
      If ( Len( aQueueStr ) > 0 )
        aChoice( 8, 3, 24, 76, aQueueStr, .T., "UserQueue" )
      Else
        lFlag := .F.
        ShowMsg( "The entity queue is empty.", "Show Queue" )
      EndIf
    EndDo
    SetColor( cColor )
    RestScreen( 6, 2, 25, 77, cScreen )
Return( Nil )


Function UserQueue( nMode, nElement, nRelative )
Local nKey    := LastKey()
Local nRet    := 2
Local nOption
    If nMode == 3
      If nKey == K_ESC
        nRet  := 0
        lFlag :=.F.
      ElseIf nKey == K_RETURN
        If aQueue[ nElement, 1 ] == ENT_SCROLL
          AskScroll( aQueue[ nElement, 2 ], ;
                     aQueue[ nElement, 3 ], ;
                     aQueue[ nElement, 4 ], ;
                     aQueue[ nElement, 5 ], ;
                     aQueue[ nElement, 6 ], ;
                     nElement )
        ElseIf aQueue[ nElement, 1 ] == ENT_BOXD
          AskBoxD( aQueue[ nElement, 2 ], ;
                   aQueue[ nElement, 3 ], ;
                   aQueue[ nElement, 4 ], ;
                   aQueue[ nElement, 5 ], ;
                   aQueue[ nElement, 6 ], ;
                   nElement )
        ElseIf aQueue[ nElement, 1 ] == ENT_BOXS
          AskBoxS( aQueue[ nElement, 2 ], ;
                   aQueue[ nElement, 3 ], ;
                   aQueue[ nElement, 4 ], ;
                   aQueue[ nElement, 5 ], ;
                   aQueue[ nElement, 6 ], ;
                   nElement )
        ElseIf aQueue[ nElement, 1 ] == ENT_LINEH
          AskLineH( aQueue[ nElement, 2 ], ;
                    aQueue[ nElement, 3 ], ;
                    aQueue[ nElement, 4 ], ;
                    aQueue[ nElement, 5 ], ;
                    aQueue[ nElement, 6 ], ;
                    nElement )
        ElseIf aQueue[ nElement, 1 ] == ENT_LINEV
          AskLineV( aQueue[ nElement, 2 ], ;
                    aQueue[ nElement, 3 ], ;
                    aQueue[ nElement, 4 ], ;
                    aQueue[ nElement, 5 ], ;
                    aQueue[ nElement, 6 ], ;
                    nElement )
        ElseIf aQueue[ nElement, 1 ] == ENT_SAY
          AskSay( aQueue[ nElement, 2 ], ;
                  aQueue[ nElement, 3 ], ;
                  aQueue[ nElement, 7 ], ;
                  aQueue[ nElement, 6 ], ;
                  nElement )
        ElseIf aQueue[ nElement, 1 ] == ENT_SAYGET
          AskSayGet( aQueue[ nElement, 2 ], ;
                     aQueue[ nElement, 3 ], ;
                     aQueue[ nElement, 7 ], ;
                     aQueue[ nElement, 6 ], ;
                     aQueue[ nElement, 9 ], ;
                     aQueue[ nElement, 10 ], ;
                     aQueue[ nElement, 11 ], ;
                     aQueue[ nElement, 12 ], ;
                     aQueue[ nElement, 13 ], ;
                     aQueue[ nElement, 14 ], ;
                     nElement )
        ElseIf aQueue[ nElement, 1 ] == ENT_READ
          ShowMsg( "Error! the READ entity is not editable", "READ entity" )
        ElseIf aQueue[ nElement, 1 ] == ENT_COLOR
          AskColor( aQueue[ nElement, 6 ], ;
                    nElement )
        EndIf
        nRet := 0
      ElseIf nKey == K_INS
        nOption := NewEntity()
        If nOption > 0
          If Inquire( "Do you want to add a new entity? (Y/N)", "Add Entity" )
            aQueue := aSize( aQueue, Len( aQueue ) + 1 )
            aQueue := aIns( aQueue, nElement )
            aQueue[ nElement ] := { nOption, 0, 0, 0, 0, "", "", "", "", "", "", "", "", 0 }
            nRet  := 0
          EndIf
        EndIf
      ElseIf nKey == K_DEL
        If Inquire( "Do you want to delete the entity? (Y/N)", "Delete Entity" )
          aQueue := aDel( aQueue, nElement )
          aQueue := aSize( aQueue, Len( aQueue ) - 1 )
          nRet  := 0
        EndIf
      EndIf
    EndIf
Return( nRet )





// ****************************************************
//
// Shows entities
//
// ****************************************************
static Function NewEntity()
Local nOption
Local cScreen := SaveScreen( 10, 30, 21, 50 )
Local cColor  := SetColor( "N/BG", "W/B" )
    PushMsg( "Select an entity" )
    gtWinBox( 10, 30, 21, 50, "N/BG", "New Entity" )
    nOption := aChoice( 12, 32, 20, 48, aEntity, .T., "UserNew" )
    PopMsg()
    SetColor( cColor )
    RestScreen( 10, 30, 21, 50, cScreen )
Return( nOption )




// ****************************************************
//
// Shows file operations queue
//
// ****************************************************
static Function FileOpt( nNumber, cFile )
Local nOption
Local cScreen   := SaveScreen( 10, 14, 16, 66 )
Local cColor    := SetColor( "N/BG", "W/B" )
Local aOption   := { "File Save", ;
                     "File Load", ;
                     "Generate Code", ;
                     "PseudoGenerate" }
Local GetList := {}
Local nCursor
    PushMsg( "Select an option" )
    gtWinBox( 10, 14, 16, 66, "N/BG", "File" )
    If nNumber == 0
      nOption := aChoice( 12, 15, 16, 35, aOption, .T., "UserNew" )
      cFile := PadR( cFileName + If( nOption == 1 .OR. nOption == 2, ".PRF", ".PRG" ), 80 )
    Else
      cFile := PadR( cFile, 80 )
      Keyboard Chr( K_ESC )
      aChoice( 12, 15, 16, 35, aOption, .T., "UserNew" )
      nOption := nNumber
    EndIf
    PopMsg()
    If nOption > 0 .And. nOption < 4
      nCursor := SetCursor( 1 )
      PushMsg( "Enter the filename" )
      @ 11 + nOption, 29 GET cFile PICTURE "@!S35" VALID ! Empty( cFile )
      Read
      PopMsg()
      SetCursor( nCursor )
    EndIf
    SetColor( cColor )
    RestScreen( 10, 14, 16, 66, cScreen )
    If LastKey() != K_ESC
      If nOption == 1
        WriteFile( cFile )
      ElseIf nOption == 2
        ReadFile( cFile )
      ElseIf nOption == 3
        GenCode( cFile, .T. )
      ElseIf nOption == 4
        GenCode( cFile, .F. )
        FastGTMemo( 4, 4, 26, 74, cGenCode, "Code Generation", "GR+/B", .F. )
      EndIf
      cFileName := If( AT( ".", cFile ) > 0, SubStr( cFile, 1, At( ".", cFile ) - 1 ), cFile )
      @ 2, 1 SAY "File: " + PadR( cFileName, 30 ) Color "W/B"
    EndIf
Return( Nil )




Function UserNew( nMode, nElement, nRelative )
Local nKey := LastKey()
Local nRet := 2
    If nMode == 3
      If nKey == K_RETURN
        nRet := 1
      Elseif nKey == K_ESC
        nRet := 0
      EndIf
    EndIf
Return( nRet )





// ****************************************************
//
// Asks a SCROLL
//
// ****************************************************
static Function AskScroll( nY1, nX1, nY2, nX2, cColor, nPos )
Local cScreen   := SaveScreen( 10, 10, 15, 70 )
Local cOldColor := SetColor( "GR+/B" )
Local nCursor   := SetCursor( 1 )
Local GetList   := {}
    cColor := PadR( cColor, 64 )
    gtWinBox( 10, 10, 15, 70, "W+/B", "Scroll Entity" )
    @ 12, 12 Say "Row    1:" Get nY1    Picture "99"   Range   0, 24
    @ 13, 12 Say "Column 1:" Get nX1    Picture "99"   Range   0, 79
    @ 12, 42 Say "Row    2:" Get nY2    Picture "99"   Range nY1, 24
    @ 13, 42 Say "Column 2:" Get nX2    Picture "99"   Range nX1, 79
    @ 14, 12 Say "Color   :" Get cColor Picture "@S45"
    Read
    If LastKey() != K_ESC
      If Inquire( "Do you want to add the new entity? (Y/N)", "Add Entity" )
        If nPos == -1
          aAdd( aQueue, { ENT_SCROLL, nY1, nX1, nY2, nX2, AllTrim( cColor ), "", "", "", "", "", "", "", 0 } )
        Else
          aQueue[ nPos ] := { ENT_SCROLL, nY1, nX1, nY2, nX2, AllTrim( cColor ), "", "", "", "", "", "", "", 0 }
        EndIf
      EndIf
    EndIf
    SetCursor( nCursor )
    SetColor( cOldColor )
    RestScreen( 10, 10, 15, 70, cScreen )
Return( Nil )





// ****************************************************
//
// Asks a BOX DOUBLE
//
// ****************************************************
static Function AskBoxD( nY1, nX1, nY2, nX2, cColor, nPos )
Local cScreen   := SaveScreen( 10, 10, 15, 70 )
Local cOldColor := SetColor( "GR+/B" )
Local nCursor   := SetCursor( 1 )
Local GetList   := {}
    cColor := PadR( cColor, 64 )
    gtWinBox( 10, 10, 15, 70, "W+/B", "Double Box Entity" )
    @ 12, 12 Say "Row    1:" Get nY1    Picture "99"   Range   0, 24
    @ 13, 12 Say "Column 1:" Get nX1    Picture "99"   Range   0, 79
    @ 12, 42 Say "Row    2:" Get nY2    Picture "99"   Range nY1, 24
    @ 13, 42 Say "Column 2:" Get nX2    Picture "99"   Range nX1, 79
    @ 14, 12 Say "Color   :" Get cColor Picture "@S45"
    Read
    If LastKey() != K_ESC
      If Inquire( "Do you want to add the new entity? (Y/N)", "Add Entity" )
        If nPos == -1
          aAdd( aQueue, { ENT_BOXD, nY1, nX1, nY2, nX2, AllTrim( cColor ), "", "", "", "", "", "", "", 0 } )
        Else
          aQueue[ nPos ] := { ENT_BOXD, nY1, nX1, nY2, nX2, AllTrim( cColor ), "", "", "", "", "", "", "", 0 }
        EndIf
      EndIf
    EndIf
    SetCursor( nCursor )
    SetColor( cOldColor )
    RestScreen( 10, 10, 15, 70, cScreen )
Return( Nil )





// ****************************************************
//
// Asks a BOX SINGLE
//
// ****************************************************
static Function AskBoxS( nY1, nX1, nY2, nX2, cColor, nPos )
Local cScreen   := SaveScreen( 10, 10, 15, 70 )
Local cOldColor := SetColor( "GR+/B" )
Local nCursor   := SetCursor( 1 )
Local GetList   := {}
    cColor := PadR( cColor, 64 )
    gtWinBox( 10, 10, 15, 70, "W+/B", "Single Box Entity" )
    @ 12, 12 Say "Row    1:" Get nY1    Picture "99"   Range   0, 24
    @ 13, 12 Say "Column 1:" Get nX1    Picture "99"   Range   0, 79
    @ 12, 42 Say "Row    2:" Get nY2    Picture "99"   Range nY1, 24
    @ 13, 42 Say "Column 2:" Get nX2    Picture "99"   Range nX1, 79
    @ 14, 12 Say "Color   :" Get cColor Picture "@S45"
    Read
    If LastKey() != K_ESC
      If Inquire( "Do you want to add the new entity? (Y/N)", "Add Entity" )
        If nPos == -1
          aAdd( aQueue, { ENT_BOXS, nY1, nX1, nY2, nX2, AllTrim( cColor ), "", "", "", "", "", "", "", 0 } )
        Else
          aQueue[ nPos ] := { ENT_BOXS, nY1, nX1, nY2, nX2, AllTrim( cColor ), "", "", "", "", "", "", "", 0 }
        EndIf
      EndIf
    EndIf
    SetCursor( nCursor )
    SetColor( cOldColor )
    RestScreen( 10, 10, 15, 70, cScreen )
Return( Nil )





// ****************************************************
//
// Asks a LINE HOR
//
// ****************************************************
static Function AskLineH( nY1, nX1, nY2, nX2, cColor, nPos )
Local cScreen   := SaveScreen( 10, 10, 15, 70 )
Local cOldColor := SetColor( "GR+/B" )
Local nCursor   := SetCursor( 1 )
Local GetList   := {}
    cColor := PadR( cColor, 64 )
    gtWinBox( 10, 10, 15, 70, "W+/B", "Horizontal Line Entity" )
    @ 12, 12 Say "Row    1:" Get nY1    Picture "99"   Range   0, 24
    @ 13, 12 Say "Column 1:" Get nX1    Picture "99"   Range   0, 79
    @ 13, 42 Say "Column 2:" Get nX2    Picture "99"   Range nX1, 79
    @ 14, 12 Say "Color   :" Get cColor Picture "@S45"
    Read
    nY2 := nY1
    If LastKey() != K_ESC
      If Inquire( "Do you want to add the new entity? (Y/N)", "Add Entity" )
        If nPos == -1
          aAdd( aQueue, { ENT_LINEH, nY1, nX1, nY2, nX2, AllTrim( cColor ), "", "", "", "", "", "", "", 0 } )
        Else
          aQueue[ nPos ] := { ENT_LINEH, nY1, nX1, nY2, nX2, AllTrim( cColor ), "", "", "", "", "", "", "", 0 }
        EndIf
      EndIf
    EndIf
    SetCursor( nCursor )
    SetColor( cOldColor )
    RestScreen( 10, 10, 15, 70, cScreen )
Return( Nil )





// ****************************************************
//
// Asks a LINE VER
//
// ****************************************************
static Function AskLineV( nY1, nX1, nY2, nX2, cColor, nPos )
Local cScreen   := SaveScreen( 10, 10, 15, 70 )
Local cOldColor := SetColor( "GR+/B" )
Local nCursor   := SetCursor( 1 )
Local GetList   := {}
    cColor := PadR( cColor, 64 )
    gtWinBox( 10, 10, 15, 70, "W+/B", "Vertical Line Entity" )
    @ 12, 12 Say "Row    1:" Get nY1    Picture "99"   Range   0, 24
    @ 13, 12 Say "Column 1:" Get nX1    Picture "99"   Range   0, 79
    @ 12, 42 Say "Row    2:" Get nY2    Picture "99"   Range nY1, 24
    @ 14, 12 Say "Color   :" Get cColor Picture "@S45"
    Read
    nX2 := nX1
    If LastKey() != K_ESC
      If Inquire( "Do you want to add the new entity? (Y/N)", "Add Entity" )
        If nPos == -1
          aAdd( aQueue, { ENT_LINEV, nY1, nX1, nY2, nX2, AllTrim( cColor ), "", "", "", "", "", "", "", 0 } )
        Else
          aQueue[ nPos ] := { ENT_LINEV, nY1, nX1, nY2, nX2, AllTrim( cColor ), "", "", "", "", "", "", "", 0 }
        EndIf
      EndIf
    EndIf
    SetCursor( nCursor )
    SetColor( cOldColor )
    RestScreen( 10, 10, 15, 70, cScreen )
Return( Nil )





// ****************************************************
//
// Asks a SAY
//
// ****************************************************
static Function AskSay( nY, nX, cText, cColor, nPos )
Local cScreen   := SaveScreen( 10, 10, 16, 70 )
Local cOldColor := SetColor( "GR+/B" )
Local nCursor   := SetCursor( 1 )
Local GetList   := {}
Local cNewText
    cText  := PadR( cText,  120 )
    cColor := PadR( cColor, 64 )
    gtWinBox( 10, 10, 16, 70, "W+/B", "Say Entity" )
    @ 12, 12 Say "Row   :" Get nY     Picture "99"   Range 0, 24
    @ 13, 12 Say "Column:" Get nX     Picture "99"   Range 0, 79
    @ 14, 12 Say "Text  :" Get cText  Picture "@S45" Valid ! Empty( cText )
    @ 15, 12 Say "Color :" Get cColor Picture "@S45"
    Read
    If LastKey() != K_ESC
      If Inquire( "Do you want to add the new entity? (Y/N)", "Add Entity" )
        If lParse( cText, @ cNewText )
          If nPos == -1
            aAdd( aQueue, { ENT_SAY, nY, nX, -1, -1, AllTrim( cColor ), AllTrim( cText ), cNewText, "", "", "", "", "", 0 } )
          Else
            aQueue[ nPos ] := { ENT_SAY, nY, nX, -1, -1, AllTrim( cColor ), AllTrim( cText ), cNewText, "", "", "", "", "", 0 }
          EndIf
        Else
          ShowMsg( "An error ocurred with Text parsing. Text can not be placed", "Parsing Error" )
        EndIf
      EndIf
    EndIf
    SetCursor( nCursor )
    SetColor( cOldColor )
    RestScreen( 10, 10, 16, 70, cScreen )
Return( Nil )





// ****************************************************
//
// Asks a SAYGET
//
// ****************************************************
static Function AskSayGet( nY, nX, cText, cColor, cVar, cType, cPicture, cWhen, cValid, nSize, nPos )
Local cScreen   := SaveScreen( 10, 10, 24, 70 )
Local cOldColor := SetColor( "GR+/B" )
Local nCursor   := SetCursor( 1 )
Local GetList   := {}
Local cNewText
    cText    := PadR( cText,   120 )
    cColor   := PadR( cColor,   64 )
    cVar     := PadR( cVar,     20 )
    cType    := PadR( cType,     1 )
    cPicture := PadR( cPicture, 20 )
    cWhen    := PadR( cWhen,   120 )
    cValid   := PadR( cValid,  120 )
    gtWinBox( 10, 10, 24, 70, "W+/B", "Say/Get Entity" )
    @ 12, 11 Say "Say" COLOR "W+/B"
    @ 17, 11 Say "Get" COLOR "W+/B"
    @ 13, 12 Say "Row    :" Get nY       Picture "99"    Range 0, 24
    @ 14, 12 Say "Column :" Get nX       Picture "99"    Range 0, 79
    @ 15, 12 Say "Text   :" Get cText    Picture "@S45"  Valid ! Empty( cText )
    @ 16, 12 Say "Color  :" Get cColor   Picture "@S45"
    @ 18, 12 Say "Name   :" Get cVar     Picture "@S45"  Valid ! Empty( cText )
    @ 19, 12 Say "Type   :" Get cType    Picture "@!"    Valid Upper( cType ) $ "CDLMN"
    @ 20, 12 Say "Size   :" Get nSize    Picture "99999" When cType $ "CMN"
    @ 21, 12 Say "Picture:" Get cPicture Picture "@S45"
    @ 22, 12 Say "When   :" Get cWhen    Picture "@S45"
    @ 23, 12 Say "Valid  :" Get cValid   Picture "@S45"
    Read
    If LastKey() != K_ESC
      If Inquire( "Do you want to add the new entity? (Y/N)", "Add Entity" )
        If lParse( cText, @ cNewText )
          If nPos == -1
            aAdd( aQueue, { ENT_SAYGET, nY, nX, -1, -1, AllTrim( cColor ), AllTrim( cText ), cNewText, cVar, cType, cPicture, cWhen, cValid, nSize } )
          Else
            aQueue[ nPos ] := { ENT_SAYGET, nY, nX, -1, -1, AllTrim( cColor ), AllTrim( cText ), cNewText, cVar, cType, cPicture, cWhen, cValid, nSize }
          EndIf
        Else
          ShowMsg( "An error ocurred with Text parsing. Text can not be placed", "Parsing Error" )
        EndIf
      EndIf
    EndIf
    SetCursor( nCursor )
    SetColor( cOldColor )
    RestScreen( 10, 10, 24, 70, cScreen )
Return( Nil )





// ****************************************************
//
// Asks a READ
//
// ****************************************************
static Function AskREAD()
    If Inquire( "Do you want to add the new entity? (Y/N)", "Add Entity" )
      aAdd( aQueue, { ENT_READ, -1, -1, -1, -1, "", "", "", "", "", "", "", "", 0 } )
    EndIf
Return( Nil )






// ****************************************************
//
// Asks a COLOR
//
// ****************************************************
static Function AskColor( cColor, nPos )
Local cScreen   := SaveScreen( 10, 10, 13, 70 )
Local cOldColor := SetColor( "GR+/B" )
Local nCursor   := SetCursor( 1 )
Local GetList   := {}
    cColor := PadR( cColor, 64 )
    gtWinBox( 10, 10, 13, 70, "W+/B", "Default Color Entity" )
    @ 12, 12 Say "Color   :" Get cColor Picture "@S45"
    Read
    If LastKey() != K_ESC
      If Inquire( "Do you want to add the new entity? (Y/N)", "Add Entity" )
        If nPos == -1
          aAdd( aQueue, { ENT_COLOR, -1, -1, -1, -1, AllTrim( cColor ), "", "", "", "", "", "", "", 0 } )
        Else
          aQueue[ nPos ] := { ENT_COLOR, -1, -1, -1, -1, AllTrim( cColor ), "", "", "", "", "", "", "", 0 }
        EndIf
      EndIf
    EndIf
    SetCursor( nCursor )
    SetColor( cOldColor )
    RestScreen( 10, 10, 13, 70, cScreen )
Return( Nil )





// ****************************************************
//
// Draws entities on the screen
//
// ****************************************************
static Function DrawEntity()
Local nLen    := Len( aQueue )
Local nInd
Local nAux
Local cColor  := SetColor()
Local nCursor := SetCursor( 0 )
Local nX1
Local nX2
Local nY1
Local nY2
Local cNewColor
Local cDefColor := Nil
    PushMsg( "Redrawing..." )
    SetColor( "W/N" )
    Scroll( 4, 0, 28, 79 )
    For nInd := 1 To nLen
      nY1       := aQueue[ nInd, 2 ] + 4
      nX1       := aQueue[ nInd, 3 ]
      nY2       := aQueue[ nInd, 4 ] + 4
      nX2       := aQueue[ nInd, 5 ]
      cNewColor := If( Empty( aQueue[ nInd, 6 ] ), cDefColor, aQueue[ nInd, 6 ] )
      If aQueue[ nInd, 1 ] == ENT_SCROLL
        DispBox( nY1, nX1, nY2, nX2, "         ", cNewColor )
      ElseIf aQueue[ nInd, 1 ] == ENT_BOXD
        DispBox( nY1, nX1, nY2, nX2, "ͻȺ ", cNewColor )
      ElseIf aQueue[ nInd, 1 ] == ENT_BOXS
        DispBox( nY1, nX1, nY2, nX2, "Ŀ ", cNewColor )
      ElseIf aQueue[ nInd, 1 ] == ENT_LINEH
        @ nY1, nX1 SAY Replicate( "", nX2 - nX1 + 1 ) COLOR cNewColor
      ElseIf aQueue[ nInd, 1 ] == ENT_LINEV
        For nAux := nY1 To nY2
          @ nAux, nX1 SAY "" COLOR cNewColor
        Next
      ElseIf aQueue[ nInd, 1 ] == ENT_SAY
        @ nY1, nX1 SAY aQueue[ nInd, 8 ] COLOR cNewColor
      ElseIf aQueue[ nInd, 1 ] == ENT_SAYGET
        @ nY1, nX1 SAY aQueue[ nInd, 8 ] COLOR cNewColor
        If aQueue[ nInd, 10 ] $ "CMN"
          @ nY1, nX1 + Len( aQueue[ nInd, 8 ] ) + 1 SAY Replicate( aQueue[ nInd, 10 ], aQueue[ nInd, 14 ] ) COLOR cNewColor
        ElseIf aQueue[ nInd, 10 ] == "D"
          @ nY1, nX1 + Len( aQueue[ nInd, 8 ] ) + 1 SAY "DD/DD/DD" COLOR cNewColor
        ElseIf aQueue[ nInd, 10 ] == "L"
          @ nY1, nX1 + Len( aQueue[ nInd, 8 ] ) + 1 SAY "L" COLOR cNewColor
        EndIf
      ElseIf aQueue[ nInd, 1 ] == ENT_COLOR
        cDefColor := cNewColor
      EndIf
    Next
    PopMsg()
    SetCursor( nCursor )
    SetColor( cColor )
Return( Nil )




// ****************************************************
//
// Makes an answer to user
//
// ****************************************************
static Function Inquire( cMessage, cTittle )
Local nLen    := Int( Len( cMessage ) / 2 )
Local cScreen := SaveScreen( 19, 38 - nLen, 22, 44 + nLen )
Local cColor  := SetColor( "R*/W" )
Local cKey    := ""
Local nCursor := SetCursor( 1 )
    gtWinBox( 19, 38 - nLen, 22, 44 + nLen, "W+*/W", cTittle )
    PushMsg( "Press Y or N to continue" )
    ChargeFont( "roman.fon" )
    @ 21, 40 - nLen Say cMessage
    VesaSetFont( FONT_BIG )
    OwnTone( 300, 0 )
    While ! ( cKey $ "YN" )
      SetPos( 21, 42 + nLen )
      cKey := Upper( Chr( OwnInkey( 0 ) ) )
      If ! cKey $ "YN"
        OwnTone( 1000, 0 )
      EndIf
    EndDo
    PopMsg()
    SetCursor( nCursor )
    SetColor( cColor )
    RestScreen( 19, 38 - nLen, 22, 44 + nLen, cScreen )
Return( cKey == "Y" )



// ****************************************************
//
// Shows a warning
//
// ****************************************************
static Function ShowMsg( cMessage, cTittle )
Local nLen    := Int( Len( cMessage ) / 2 )
Local cScreen := SaveScreen( 19, 38 - nLen, 22, 42 + nLen )
Local cColor  := SetColor( "R*/W" )
Local nCursor := SetCursor( 0 )
    PushMsg( "Press any key to continue" )
    gtWinBox( 19, 38 - nLen, 22, 42 + nLen, "W+*/W", cTittle )
    ChargeFont( "roman.fon" )
    @ 21, 40 - nLen Say cMessage
    VesaSetFont( FONT_BIG )
    OwnTone( 300, 0 )
    OwnInkey( 0 )
    PopMsg()
    SetCursor( nCursor )
    SetColor( cColor )
    RestScreen( 19, 38 - nLen, 22, 42 + nLen, cScreen )
Return( Nil )



static Function PushMsg( cMsg )
    aAdd( aMsg, SaveScreen( 29, 0, 29, 70 ) )
    @ 29, 1 SAY PadR( cMsg, 79 ) COLOR "N/W"
Return Nil


static Function PopMsg()
    RestScreen( 29, 0, 29, 70, aTail( aMsg ) )
    aSize( aMsg, Len( aMsg ) - 1 )
Return Nil


static Function MyPencil( nY, nX, lMode )
static cIntScr
    If lMode
      cIntScr := SaveScreen( nY, nX, nY, nX )
      nY *= 16
      nX *= 8
      VesaSetArea( nY + 2, nX,     nY + 13, nX + 6,  8 )
      VesaSetArea( nY + 3, nX + 1, nY + 12, nX + 5,  7 )
      VesaSetArea( nY + 4, nX + 2, nY + 11, nX + 4, 15 )
      VesaLine(    nY + 2, nX,     nY + 13, nX + 6, 14 )
      VesaLine(    nY + 2, nX + 6, nY + 13, nX,     14 )
    Else
      RestScreen( nY, nX, nY, nX, cIntScr )
    EndIf
Return Nil


static Function lParse( cText, cNewText )
Local aArray := aCar2Arr( cText, "+" )
Local nInd
Local lFlag  := .T.
Local cNew   := ""
    cNewText := ""
    For nInd := 1 To Len( aArray )
      If ! Type( aArray[ nInd ] ) $ "UE"
        Begin Sequence
          cNew := &( aArray[ nInd ] )
        End
      Else
        lFlag := .F.
      EndIf
      If ValType( cNew ) == "C"
        cNewText += cNew
      Else
        lFlag := .F.
      EndIf
    Next
Return( lFlag )


static Function WriteFile( cFile )
Local hHandle := fCreate( cFile, 0 )
Local cBuffer
Local nLen    := Len( aQueue )
Local nInd
    If hHandle > -1
      PushMsg( "Saving..." )
      For nInd := 1 To nLen
        cBuffer := ""
        cBuffer += Str(  aQueue[ nInd,  1 ],   1 )
        cBuffer += Str(  aQueue[ nInd,  2 ],   2 )
        cBuffer += Str(  aQueue[ nInd,  3 ],   2 )
        cBuffer += Str(  aQueue[ nInd,  4 ],   2 )
        cBuffer += Str(  aQueue[ nInd,  5 ],   2 )
        cBuffer += PadR( aQueue[ nInd,  6 ],  64 )
        cBuffer += PadR( aQueue[ nInd,  7 ], 120 )
        cBuffer += PadR( aQueue[ nInd,  9 ],  20 )
        cBuffer += PadR( aQueue[ nInd, 10 ],   1 )
        cBuffer += PadR( aQueue[ nInd, 11 ],  20 )
        cBuffer += PadR( aQueue[ nInd, 12 ], 120 )
        cBuffer += PadR( aQueue[ nInd, 13 ], 120 )
        cBuffer += Str(  aQueue[ nInd, 14 ],   5 )
        fWrite( hHandle, cBuffer, STRUCT_SIZE )
      Next
      fClose( hHandle )
      PopMsg()
      ShowMsg( "The file has been saved", "File Save" )
    Else
      ShowMsg( "An error ocurred saving the file", "File Save" )
    EndIf
Return( Nil )



static Function ReadFile( cFile )
Local hHandle := fOpen( cFile, 64 )
Local cBuffer
Local nInd
Local aBuffer
Local cAux
    If hHandle > -1
      PushMsg( "Loading..." )
      aQueue   := {}
      cBuffer := Space( STRUCT_SIZE )
      While ( fRead( hHandle, @ cBuffer, STRUCT_SIZE ) == STRUCT_SIZE )
        aBuffer := {}
        aAdd( aBuffer, Val( SubStr( cBuffer,   1,   1 ) ) )
        aAdd( aBuffer, Val( SubStr( cBuffer,   2,   2 ) ) )
        aAdd( aBuffer, Val( SubStr( cBuffer,   4,   2 ) ) )
        aAdd( aBuffer, Val( SubStr( cBuffer,   6,   2 ) ) )
        aAdd( aBuffer, Val( SubStr( cBuffer,   8,   2 ) ) )
        aAdd( aBuffer, SubStr( cBuffer,       10,  64 ) )
        aAdd( aBuffer, SubStr( cBuffer,       74, 120 ) )
        lParse( aTail( aBuffer ), @ cAux )
        aAdd( aBuffer, cAux )
        aAdd( aBuffer, SubStr( cBuffer,      194,  20 ) )
        aAdd( aBuffer, SubStr( cBuffer,      214,   1 ) )
        aAdd( aBuffer, SubStr( cBuffer,      215,  20 ) )
        aAdd( aBuffer, SubStr( cBuffer,      235, 120 ) )
        aAdd( aBuffer, SubStr( cBuffer,      355, 120 ) )
        aAdd( aBuffer, Val( SubStr( cBuffer, 475,   5 ) ) )
        aAdd( aQueue, aBuffer )
      End
      fClose( hHandle )
      PopMsg()
      ShowMsg( "The file has been loaded", "File Load" )
    Else
      ShowMsg( "An error ocurred loading the file", "File Load" )
    EndIf
Return( Nil )


static Function GenCode( cFile, lMode )
Local hHandle
Local cBuffer
Local nInd
Local nLen
Local nLongVar
Local lFlag
Local lLineV
Local nY1
Local nX1
Local nY2
Local nX2
Local cColor
Local cFrame
    If lMode
      hHandle := fCreate( cFile, 0 )
    Else
      hHandle  := 123456789
      cGenCode := ""
    EndIf
    If hHandle > -1
      PushMsg( "Saving..." )
      WriteF( hHandle, MemoRead( IniSearch( aOptions, "CABFILE", "cab.txt" ) ) )
      WriteF( hHandle, "FUNCTION FASTSD()" + CRLF + CRLF )
      nLen  := Len( aQueue )
      lFlag    := .F.
      lLineV   := .F.
      nLongVar := 7
      For nInd := 1 To nLen
        If aQueue[ nInd, 1 ] == ENT_SAYGET
          nLongVar := Max( nLongVar, Len( AllTrim( aQueue[ nInd, 9 ] ) ) )
        EndIf
      Next
      For nInd := 1 To nLen
        If aQueue[ nInd, 1 ] == ENT_SAYGET
          cBuffer := "LOCAL " + PadR( aQueue[ nInd, 9 ], nLongVar ) + " := "
          If aQueue[ nInd, 10 ] $ "CM"
            cBuffer += "SPACE ( " + Str( aQueue[ nInd, 14 ], 2 ) + " )"
          ElseIf aQueue[ nInd, 10 ] == "D"
            cBuffer += 'cTod( "" )'
          ElseIf aQueue[ nInd, 10 ] == "L"
            cBuffer += ".F."
          ElseIf aQueue[ nInd, 10 ] == "N"
            cBuffer += "0"
          EndIf
          cBuffer += CRLF
          WriteF( hHandle, cBuffer )
          lFlag  := .T.
        ElseIf aQueue[ nInd, 1 ] == ENT_LINEV
          lLineV := .T.
        EndIf
      Next
      If lFlag
        If Upper( IniSearch( aOptions, "LOCALGETLIST", "YES" ) ) == "YES"
          cBuffer := "LOCAL " + PadR( "GetList", nLongVar ) + " := {}" + CRLF
        Else
          cBuffer := "MEMVAR GetList" + CRLF
        EndIf
        WriteF( hHandle, cBuffer )
      EndIf
      If lLineV
        cBuffer := "LOCAL " + PadR( "nIndSD", nLongVar ) + " := 0" + CRLF + CRLF
        WriteF( hHandle, cBuffer )
      EndIf
      For nInd := 1 To nLen
        nY1    := Str( aQueue[ nInd, 2 ], 2 )
        nX1    := Str( aQueue[ nInd, 3 ], 2 )
        nY2    := Str( aQueue[ nInd, 4 ], 2 )
        nX2    := Str( aQueue[ nInd, 5 ], 2 )
        cColor := If( Empty( aQueue[ nInd, 6 ] ), "", Chr( 34 ) + AllTrim( aQueue[ nInd, 6 ] ) + Chr( 34 ) )
        If aQueue[ nInd, 1 ] == ENT_SCROLL .OR. ;
           aQueue[ nInd, 1 ] == ENT_BOXD   .OR. ;
           aQueue[ nInd, 1 ] == ENT_BOXS
          If aQueue[ nInd, 1 ] == ENT_SCROLL
            cFrame := Space( 9 )
          ElseIf aQueue[ nInd, 1 ] == ENT_BOXD
            cFrame := "ͻȺ "
          Else
            cFrame := "Ŀ "
          EndIf
          cFrame := Chr( 34 ) + cFrame + Chr( 34 )
          cBuffer := Indent() + "@ %1, %2, %3, %4 BOX " + cFrame
          cBuffer += If( ! Empty( cColor ), " COLOR %5", "" ) + CRLF
          cBuffer := StrTran( cBuffer, "%1", nY1 )
          cBuffer := StrTran( cBuffer, "%2", nX1 )
          cBuffer := StrTran( cBuffer, "%3", nY2 )
          cBuffer := StrTran( cBuffer, "%4", nX2 )
          cBuffer := StrTran( cBuffer, "%5", cColor )
        ElseIf aQueue[ nInd, 1 ] == ENT_LINEH
          cBuffer := Indent() + "@ %1, %2 SAY %3"
          cBuffer += If( ! Empty( cColor ), " COLOR %4", "" ) + CRLF
          cBuffer := StrTran( cBuffer, "%1", nY1 )
          cBuffer := StrTran( cBuffer, "%2", nX1 )
          cBuffer := StrTran( cBuffer, "%3", 'Replicate( "", ' + Str( Val( nX2 ) - Val( nX1 ) + 1, 2 ) + " )" )
          cBuffer := StrTran( cBuffer, "%4", cColor )
        ElseIf aQueue[ nInd, 1 ] == ENT_LINEV
          cBuffer := Indent() + "FOR nIndSD := " + nY1 + " TO " + nY2 + CRLF
          cBuffer += Indent() + "  @ nIndSD, " + nX1 + ' SAY ""'
          If ! Empty( cColor )
            cBuffer += " COLOR " + cColor + CRLF
          EndIf
          cBuffer += Indent() + "NEXT nIndSD" + CRLF
        ElseIf aQueue[ nInd, 1 ] == ENT_SAY
          cBuffer := Indent() + "@ %1, %2 SAY %3"
          cBuffer += If( ! Empty( cColor ), " COLOR %4", "" ) + CRLF
          cBuffer := StrTran( cBuffer, "%1", nY1 )
          cBuffer := StrTran( cBuffer, "%2", nX1 )
          cBuffer := StrTran( cBuffer, "%3", AllTrim( aQueue[ nInd, 7 ] ) )
          cBuffer := StrTran( cBuffer, "%4", cColor )
        ElseIf aQueue[ nInd, 1 ] == ENT_SAYGET
          cBuffer := Indent() + "@ " + nY1 + ", " + nX1 + " SAY " + AllTrim( aQueue[ nInd, 7 ] )
          If ! Empty( cColor )
            cBuffer += " COLOR " + cColor
          EndIf
          cBuffer += " ;" + CRLF
          cBuffer += Indent() + Space( 9 ) + "GET " + AllTrim( aQueue[ nInd, 9 ] )
          If ! Empty( aQueue[ nInd, 11 ] )
            cBuffer += " ;" + CRLF + Indent() + Space( 9 ) + 'PICTURE "' + AllTrim( aQueue[ nInd, 11 ] ) + '"'
          EndIf
          If ! Empty( aQueue[ nInd, 12 ] )
            cBuffer += " ;" + CRLF + Indent() + Space( 9 ) + "WHEN    " + AllTrim( aQueue[ nInd, 12 ] )
          EndIf
          If ! Empty( aQueue[ nInd, 13 ] )
            cBuffer += " ;" + CRLF + Indent() + Space( 9 ) + "VALID   " + AllTrim( aQueue[ nInd, 13 ] )
          EndIf
          cBuffer += CRLF
        ElseIf aQueue[ nInd, 1 ] == ENT_READ
          cBuffer := Indent() + "READ" + CRLF
        ElseIf aQueue[ nInd, 1 ] == ENT_COLOR
          cBuffer := Indent() + "SetColor ( %1 )" + CRLF
          cBuffer := StrTran( cBuffer, "%1", cColor )
        EndIf
        WriteF( hHandle, cBuffer )
      Next
      WriteF( hHandle, CRLF + "RETURN NIL" + CRLF )
      If lMode
        fClose( hHandle )
      EndIf
      PopMsg()
      ShowMsg( "The code has been generated", "Code Generate" )
    Else
      ShowMsg( "An error ocurred saving the file", "Code Generate" )
    EndIf
Return( Nil )


Static Function WriteF( hHandle, cBuffer )
    If hHandle == 123456789
      cGenCode += cBuffer
    Else
      fWrite( hHandle, cBuffer, Len( cBuffer ) )
    EndIf
Return( Nil )


Static Function Indent()
Return( Space( Val( IniSearch( aOptions, "INDENT", "3" ) ) ) )


Static Function FastGTMemo( nY1, nX1, nY2, nX2, cMemo, cTitulo, cColBro, lWrite )
Local nY      := Row()
Local nX      := Col()
Local cPanta  := SaveScreen( nY1, nX1, nY2, nX2 )
Local cColor  := SetColor( cColBro )
Local nCursor := SetCursor( 1 )
    gtWinBox( nY1, nX1, nY2, nX2, cColBro, cTitulo )
    ChargeFont( "courier.fon" )
    cMemo := MemoEdit( cMemo, nY1 + 2, nX1 + 2, nY2 - 1, nX2 - 2, If( lWrite == Nil, .T., lWrite ) )
    VesaSetFont( FONT_BIG )
    SetColor( cColor )
    SetCursor( nCursor )
    RestScreen( nY1, nX1, nY2, nX2, cPanta )
    SetPos( nY, nX )
Return ( cMemo )


Static Function ChargeFont( cFont )
    If File( cFont )
      VesaLoadFont( cFont )
      VesaSetFont( FONT_USER )
    EndIf
Return( Nil )


static Function MsgInit()
Local cScreen := SaveScreen( 8, 6, 18, 73 )
Local cColor  := SetColor( "GR+/B" )
Local nCursor := SetCursor( 0 )
    PushMsg( "Press any key to continue" )
    gtWinBox( 8, 6, 18, 73, "W+/B", "Welcome to FAST.* Software" )
    ChargeFont( "antique.fon" )
    @ 10, 9 SAY "   Screen Designer and Code Generator, FAST.SD. 0.50 Beta.    "
    ChargeFont( "courier.fon" )
    @ 12, 9 SAY "    This is a 100% Clipper program created by Manu Roibal     "
    ChargeFont( "roman.fon" )
    @ 14, 9 SAY "FAST.SD uses FAST.* Software technology as FAST.lib or FAST.GT"
    VesaSetFont( FONT_BIG )
    @ 16, 9 SAY " (C) 1992-94 Manu Roibal. All rights reserved. Made in Spain  "
    OwnInkey( 30 )
    PopMsg()
    SetCursor( nCursor )
    SetColor( cColor )
    RestScreen( 8, 6, 18, 73, cScreen )
Return( Nil )


Static Function OwnInkey( nParam )
Local nTime
Local nScr
Local nKey   := 0
Local nDelay := Val( IniSearch( aOptions, "TIMESCREENSAVER", "60" ) )
     nParam := If( nParam == Nil, 0.01, nParam )
     nTime  := Seconds() + nParam
     nScr   := nTime
     While nKey == 0 .And. ( ( nParam != 0 .And. nTime > Seconds() ) .Or. nParam == 0 )
       nKey := Inkey()
       If nDelay > 0 .And. nScr + nDelay < Seconds()
         ScreenSaver()
         nScr := Seconds()
       EndIf
     End
Return( nKey )


Static Function OwnTone( nFrec, nDuration )
    If Upper( IniSearch( aOptions, "ALLOWSOUND", "YES" ) ) == "YES"
      Tone( nFrec, nDuration )
    EndIf
Return Nil


EXIT PROCEDURE MyExit()
    gtClose( gtHandle )
RETURN



