DEFINT A-Z

'Declare Routines

'Checks DataFile
DECLARE SUB HolidayCheck ()

'Routine to perform the daily batch file (if it is a different day)
DECLARE SUB DayCheck ()

'Routine to perform the weekly batch file if days since the last run
'is > 6, or if DayOfWeek = 0 (Sunday)
DECLARE SUB WeekCheck ()

'Routine to perform the monthly batch file.
DECLARE SUB MonthCheck ()

'Routine to perform the yearly batch file.
DECLARE SUB YearCheck ()

'Routine to perform the user batch file.
DECLARE SUB UserCheck ()

'Support for the User Batch Routine.
DECLARE SUB UserDaysRead ()
DECLARE SUB ConfigUserRec ()
DECLARE SUB WriteUser (User%, Accum%)

'Routine to Write dat$ (a date in the form "MM-DD-YYYY") in the first 2 bytes
'of the record file
DECLARE SUB RecordDate (Dat$, File$, Locat)

'Routine that handles the init process
DECLARE SUB InitDateCheck ()

'If running under NDOS, this routine interfaces with NDOS to describe the
'DateCheck files
DECLARE SUB Describe (Fle$, des$)

'Needed to check for New DataFile
DECLARE FUNCTION NewCheck (File$)

'Determines whether or not a file exists.  0 for No, -1 for Yes
DECLARE FUNCTION Exist% (File$)

'Determines the name of the file currently in place as the Command Processer
DECLARE FUNCTION Intrptr$ ()

'Translates a 2-byte Date string back to "MM-DD-YYYY" format
DECLARE FUNCTION TranslateDate$ (DateString$)

'Declare Constants
'Program Conditions
CONST False = 0, True = NOT False

'Program Qualities  NOTE: These usually CHANGE from version to version.
CONST Version = "5.20"

'Filename and Description constants
CONST PrShellForDescrip = "NDOS.COM"
CONST OldDataFile = "DATECHK.REC"
CONST DataFile = "DATECHK.DAT", ProgramName = "DATECHK.EXE"
CONST DRFDes = "Data file"
CONST PFDes = "Daily, Weekly and Monthly Maint. Manager"
CONST DailyBatch = "DAILY.BAT", DailyDes = "Daily Maintenance"
CONST WeeklyBatch = "WEEKLY.BAT", WeeklyDes = "Weekly Maintenance"
CONST MonthlyBatch = "MONTHLY.BAT", MonthlyDes = "Monthly Maintenance"
CONST UserBatch = "USER.BAT", UserDes = "User Maintenance"
CONST YearlyBatch = "YEARLY.BAT", YearlyDes = "Yearly Maintenance"

'Command Line Options
CONST CheckOption = "/CHECK"
CONST AutoOption = "/AUTO"
CONST ConfigOption = "/CONFIG"

'Type Definitions
TYPE HolRec
   Date AS STRING * 2
   Text AS STRING * 60
END TYPE

'Declare Arrays and Shared Variables
DIM SHARED Byte(3) AS STRING * 1, RWByte AS STRING * 1, Record AS HolRec
DIM SHARED Flag%(4), Dates$(2), UserDays, UserAccum
DIM SHARED StoreDate AS STRING * 2
'Determine whether or not Describe may be used
IF Intrptr$ = PrShellForDescrip THEN Flag%(1) = True

'Determine whether or not the user wants to be prompted
IF COMMAND$ = AutoOption THEN Flag%(4) = True

Flag%(3) = False
Dates$(1) = DATE$

InitDateCheck

IF COMMAND$ = ConfigOption THEN
   ConfigUserRec
   END
END IF

'Check for whether or not the batch files are due to be run
PRINT "Date Check version "; Version; ".  Checking for due maintenance..."
IF Dates$(1) <> Dates$(2) OR MID$(COMMAND$, 1, 6) = CheckOption THEN
   CALL RecordDate(Dates$(1), DataFile, 1)
   DayCheck
   WeekCheck
   MonthCheck
   YearCheck
   UserCheck
   HolidayCheck
END IF
CLOSE
END

SUB ConfigUserRec ()
INPUT "Enter the number of days to check for the USER.BAT intervention [0]:", User
IF User = 0 THEN
   Fil% = FREEFILE
   OPEN DataFile FOR BINARY AS Fil%
   RWByte = CHR$(0)
   FOR x = 3 TO 5
      PUT #1, x, RWByte
   NEXT
   CLOSE Fil%
   EXIT SUB
ELSE
   CALL WriteUser(User, 0)
END IF
END SUB

SUB DayCheck ()
   IF Flag%(4) = False THEN
      PRINT "Daily Maintenance is due... Execute " + DailyBatch + "? (Y/n)"
      Choi$ = INPUT$(1)
   END IF
   IF UCASE$(Choi$) <> "N" THEN
      PRINT "Performing Daily Maintenance..."
      IF NOT Exist%(DailyBatch) THEN
         PRINT "No " + DailyBatch + "... Skipping..."
      ELSE
         IF Flag%(1) = True THEN
            Describe DailyBatch, DailyDes
         END IF
         SHELL DailyBatch
      END IF
   ELSE
      PRINT "Skipping " + DailyBatch + "..."
   END IF
END SUB

SUB Describe (Fle$, DeSTR$)
   SHELL "describe " + Fle$ + " " + CHR$(34) + DeSTR$ + CHR$(34)
END SUB

FUNCTION Exist% (File$)
   ON ERROR RESUME NEXT
   Handle% = FREEFILE
10 OPEN File$ FOR INPUT AS Handle%
   IF ERL = 10 THEN
      Flag%(2) = True
   END IF
   ON ERROR GOTO 0
   IF Flag%(2) = False THEN
      Exist% = True
   ELSE
      Exist% = False
   END IF
   Flag%(2) = False
   CLOSE Handle%
END FUNCTION

STATIC SUB HolidayCheck ()
   Fil% = FREEFILE
   OPEN DataFile FOR BINARY AS Fil%
   DO
      Numb% = Locat% * 62 + 6
      GET Fil%, Numb%, Record
      TestDate$ = TranslateDate$(Record.Date)
      IF (MONTH(DATEVALUE(Dates$(1))) = MONTH(DATEVALUE(TestDate$))) AND (DAY(DATEVALUE(Dates$(1))) = DAY(DATEVALUE(TestDate$))) THEN
         PRINT
         PRINT Record.Text
         BEEP
         PRINT "Press any key to continue"
         Dummy$ = INPUT$(1)
      END IF
      Locat% = Locat% + 1
   LOOP WHILE Numb% < LOF(Fil%)
   CLOSE Fil%
END SUB

SUB InitDateCheck ()
   IF Exist(OldDataFile) OR NewCheck(DataFile) THEN
      IF Exist(OldDataFile) THEN
         KILL OldDataFile
      END IF
      CALL RecordDate(Dates$(1), DataFile, 1)
      PRINT "This is either an upgrade, or a new installation of Date Check!"
      PRINT "You will be prompted to enter a value for the number of days to"
      PRINT "wait between USER.BAT checks.  If you do not wish to use the"
      PRINT "'User Check' option, just enter 0.  NOTE: You can change your mind"
      PRINT "later by entering /CONFIG on the command line"
      ConfigUserRec
      Flag%(3) = True
   ELSE
      CLOSE Fil%
   END IF
   IF Flag%(1) = True THEN
      Describe DataFile, DRFDes
      Describe ProgramName, PFDes
      IF Flag%(3) = True THEN
         END
      END IF
   END IF
   Fil% = FREEFILE
   OPEN DataFile FOR BINARY AS Fil%
   GET Fil%, 1, StoreDate
   Dates$(2) = TranslateDate$(StoreDate)
   CLOSE Fil%
   UserDaysRead
END SUB

FUNCTION Intrptr$ ()
   Interpreter$ = ENVIRON$("COMSPEC")
   FOR x = LEN(Interpreter$) TO 1 STEP -1
      Check$ = MID$(Interpreter$, x, 1)
      IF Check$ = "\" THEN EXIT FOR
      Temp$ = Check$ + Temp$
   NEXT
   Intrptr$ = UCASE$(Temp$)
END FUNCTION

SUB MonthCheck ()
   IF MID$(Dates$(1), 1, 2) <> MID$(Dates$(2), 1, 2) OR COMMAND$ = CheckOption THEN
      IF Flag%(4) = False THEN
         PRINT "Monthly Maintenance is due... Execute " + MonthlyBatch + "? (Y/n)"
         Choi$ = INPUT$(1)
      END IF
      IF UCASE$(Choi$) <> "N" THEN
         PRINT "Performing Monthly Maintenance..."
         IF NOT Exist%(MonthlyBatch) THEN
            PRINT "No " + MonthlyBatch + "... Skipping..."
         ELSE
            IF Flag%(1) = True THEN
               Describe MonthlyBatch, MonthlyDes
            END IF
            SHELL MonthlyBatch
         END IF
      ELSE
         PRINT "Skipping " + MonthlyBatch + "..."
      END IF
   END IF
END SUB

FUNCTION NewCheck (File$)
   Fi% = FREEFILE
   OPEN File$ FOR RANDOM AS Fi% LEN = 62
   GET Fi%, 1, Record
   IF Record.Date = SPACE$(2) THEN
      NewCheck = True
   ELSE
      NewCheck = False
   END IF
   CLOSE Fi%
END FUNCTION

SUB RecordDate (Dat$, File$, Locat)
   Fil% = FREEFILE
   OPEN File$ FOR BINARY AS Fil%
      Mo% = MONTH(DATEVALUE(Dat$))
      Da% = DAY(DATEVALUE(Dat$))
      Yr% = YEAR(DATEVALUE(Dat$)) - 1980
      Byte(1) = CHR$(Mo% * 16 + (Da% AND 30) / 2)
      Byte(2) = CHR$((Da% AND 1) * 128 + Yr%)
      FOR x = 1 TO 2
         PUT #1, x - 1 + Locat, Byte(x)
      NEXT
   CLOSE Fil%
END SUB

FUNCTION TranslateDate$ (DateString$)
   TotASC$ = ""
   DIM Calc(2) AS INTEGER
   FOR x = 1 TO LEN(DateString$)
      Calc(x) = ASC(MID$(DateString$, x, 1))
   NEXT
   TranslateDate$ = FORMAT$(DATESERIAL(((Calc(2) AND 127) + 1980), ((Calc(1) AND 240) / 16), ((Calc(1) AND 15) * 2 + (Calc(2) AND 128) / 128)), "MM/DD/YYYY")
END FUNCTION

SUB UserCheck ()
   DayCount = DATEVALUE(Dates$(1)) - DATEVALUE(Dates$(2))
   IF (DayCount + UserAccum >= UserDays OR COMMAND$ = CheckOption) AND UserDays > 0 THEN
      IF Flag%(4) = False THEN
         PRINT "User Interval ("; UserDays; " Days) has been exceeded... Execute " + UserBatch + "? (Y/n)"
         Choi$ = INPUT$(1)
      END IF
      IF UCASE$(Choi$) <> "N" THEN
         PRINT "Performing User Maintenance..."
         IF NOT Exist%(UserBatch) THEN
            PRINT "No " + UserBatch + "... Skipping..."
         ELSE
            IF Flag%(1) = True THEN
               Describe UserBatch, UserDes
            END IF
            SHELL UserBatch
         END IF
      ELSE
         PRINT "Skipping " + UserBatch + "..."
      END IF
      CALL WriteUser(UserDays, 0)
   ELSE
      IF UserDays > 0 THEN
         CALL WriteUser(UserDays, UserAccum + DayCount)
      END IF
   END IF
END SUB

SUB UserDaysRead ()
   TotASC$ = ""
   Fil% = FREEFILE
   DIM Calc(3) AS INTEGER
   OPEN DataFile FOR BINARY AS Fil%
   FOR x = 3 TO 5
      GET Fil%, x, Z$
      IF Z$ = "" THEN
         UserDays = 0
         UserAccum = 0
         EXIT FOR
      END IF
      Calc(x - 2) = ASC(Z$)
   NEXT
   UserDays = Calc(1) * 2 + (Calc(2) AND 128) / 128
   UserAccum = (Calc(2) AND 127) * 4 + (Calc(3) AND 192) / 64
   'Notice: Bits 19-24 are UNUSED!
   CLOSE Fil%
END SUB

SUB WeekCheck ()
   DayCount = DATEVALUE(Dates$(1)) - DATEVALUE(Dates$(2))
   StartWeekDay = WEEKDAY(DATEVALUE(Dates$(1)))
   EndWeekDay = WEEKDAY(DATEVALUE(Dates$(2)))
   IF EndWeekDay > StartWeekDay OR DayCount > 6 OR COMMAND$ = CheckOption THEN
      IF Flag%(4) = False THEN
         PRINT "Weekly Maintenance is due... Execute " + WeeklyBatch + "? (Y/n)"
         Choi$ = INPUT$(1)
      END IF
      IF UCASE$(Choi$) <> "N" THEN
         PRINT "Performing Weekly Maintenance..."
         IF NOT Exist%(WeeklyBatch) THEN
            PRINT "No " + WeeklyBatch + "... Skipping..."
         ELSE
            IF Flag%(1) = True THEN
               Describe WeeklyBatch, WeeklyDes
            END IF
            SHELL WeeklyBatch
         END IF
      ELSE
         PRINT "Skipping " + WeeklyBatch + "..."
      END IF
   END IF
END SUB

SUB WriteUser (User, Accum)
   Fil% = FREEFILE
   OPEN DataFile FOR BINARY AS Fil%
   Byte(1) = CHR$((User AND 510) / 2)
   Byte(2) = CHR$((User AND 1) * 128 + (Accum AND 508) / 4)
   Byte(3) = CHR$((Accum AND 3) * 64)
   FOR x = 1 TO 3
      PUT #1, x + 2, Byte(x)
   NEXT
   CLOSE Fil%
END SUB

SUB YearCheck ()
   IF YEAR(DATEVALUE(Dates$(1))) <> YEAR(DATEVALUE(Dates$(2))) OR COMMAND$ = CheckOption THEN
      IF Flag%(4) = False THEN
         PRINT "Yearly Maintenance is due... Execute " + YearlyBatch + "? (Y/n)"
         Choi$ = INPUT$(1)
      END IF
      IF UCASE$(Choi$) <> "N" THEN
         PRINT "Performing Yearly Maintenance..."
         IF NOT Exist%(YearlyBatch) THEN
            PRINT "No " + YearlyBatch + "... Skipping..."
         ELSE
            IF Flag%(1) = True THEN
               Describe YearlyBatch, YearlyDes
            END IF
            SHELL YearlyBatch
         END IF
      ELSE
         PRINT "Skipping " + YearlyBatch + "..."
      END IF
   END IF
END SUB

