program match_file_dates_and_times;
{$M 1024,0,0} {minimize stack and heap}
{$I-} {disable I/O checking - trap I/O errors by checking IOResult}
uses dos;

procedure showhelp(const problem :byte);
(* If any *foreseen* errors arise, we are sent here to
   give a little help and exit (relatively) peacefully *)
const
  progdesc = 'MatchDate v1.00 - Free DOS utility: file date & time matcher.';
  author   = '(c) February 24, 1995, by David Daniel Anderson - Reign Ware.';
  usage    = 'Usage:  MDate control_file change_file   (DOS wildcards are NOT permitted)';
var
  message : string[70];
begin
  writeln(progdesc);
  writeln(author);    writeln;
  writeln(usage);     writeln;
  if problem > 0 then begin
    case problem of
      1 : message := 'Unexpected file error - make sure both files exist.';
    else  message := 'Unanticipated error of unknown type.';
    end;
    writeln (#7,message);
  end;
  halt(problem)
end;

procedure iocheck(const iores :byte);
begin
  if iores <> 0 then showhelp(1);
end;

var
   p1, p2 : pathstr;
   master, change : file;
   fdt  : longint;

begin
  if paramcount <> 2 then showhelp (0);
  p1 := paramstr(1); p2 := paramstr(2);
  assign (master, p1); reset (master); iocheck(ioresult);
  assign (change, p2); reset (change); iocheck(ioresult);
  getftime (master, fdt); setftime (change, fdt);
  close (master); close (change);
  Writeln('Matched date and time of "',p2,'" to "',p1,'".');
end.
