/*
 * Copyright (C) 1992, 1995 Stephen A. Wood.  All rights reserved.
 *
 * This file is part of PAF C-Tools.
 *  
 * These programs are free software; you can redistribute them and/or modify
 * them under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * The GNU General Public License can be found in the file LICENSE.
 * 
 * The author of PAF C-Tools is Stephen A. Wood.  He may be reached on internet
 * at the address saw@cegaf.gov, or via mail at 328 Dominion Drive,
 * Newport News, VA 23602.
 * 
 * ------------
 * 
 * This include file contains data structures used by the various PAF C-Tools
 * programs.
 */

#define TRUE 1
#define FALSE 0

typedef unsigned short int RECORD_PTR;

typedef struct {
  char fname[30];
  int reclen;
  FILE *ptr;
  int nrec;
  RECORD_PTR freehead, freetail, currec;
} PAF_FILE;

typedef struct {
  RECORD_PTR left;
  char name[17];
  RECORD_PTR right;
} NAME_REC;

typedef long int LONGDATE;

typedef struct {
  RECORD_PTR names[5];
  char sex;
  LONGDATE birthdate;/*15*/
  RECORD_PTR birthplace[4];/*23*/
  LONGDATE christdate;/*27*/
  RECORD_PTR christplace[4];/*35*/
  LONGDATE deathdate;/*39*/
  RECORD_PTR deathplace[4];/*47*/
  LONGDATE burialdate;/*51*/
  RECORD_PTR burialplace[4];/*59*/
  char ldsinfo[15];/*74*/
  RECORD_PTR oldersib, ownmarriage, parentmarriage;/*80*/
  char idnum[10];/*90*/
  RECORD_PTR notepad;/*92*/
} INDIV_REC;

typedef struct {
  RECORD_PTR husband, wife, child;
  LONGDATE marriagedate;
  RECORD_PTR marriageplace[4];
  char sealings[5];
  RECORD_PTR mnext_husband;
  RECORD_PTR mnext_wife;
  char divorce;
} MARR_REC;

#define NOTEPADSIZE 254

typedef struct {
  RECORD_PTR next_pad;
  char notelines[NOTEPADSIZE];
} NOTE_REC;

typedef struct {
  char name[41];
  char addr1[41];
  char addr2[41];
  char addr3[41];
  char phone[41];
  char stake[26];
  char unit[8];
} NAMADD_REC;

int paf_open_name(char *path, char c);
int paf_open_indiv(char *path, char c);
int paf_open_marr(char *path, char c);
int paf_open_notes(char *path, char c);
int paf_open_namadd(char *path, char c);
void get_name_rec(RECORD_PTR recno,NAME_REC *namrec);
void get_indiv_rec(RECORD_PTR rin,INDIV_REC *indrec);
void get_marr_rec(unsigned short int mrin,MARR_REC *marec);
void get_note_rec(unsigned short int nbp,NOTE_REC *noterec);
void get_namadd_rec(RECORD_PTR recno,NAMADD_REC *noterec);
void write_indiv_rec(unsigned short int rin,INDIV_REC *indrec);
void write_note_rec(unsigned short int nbp,NOTE_REC *indrec);

enum paffiles {NAME, INDIV, MARR, NOTE, NAMADD};

PAF_FILE *get_paf_filed(enum paffiles type);

void add_to_freelist(RECORD_PTR newfree, PAF_FILE *fil);
RECORD_PTR get_tail(RECORD_PTR first, PAF_FILE *fil);
RECORD_PTR get_next(RECORD_PTR recno, PAF_FILE *fil);
RECORD_PTR get_free_rec(PAF_FILE *fil);

